/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIAsm {
    long address;
    String function = "";
    String opcode = "";
    String args = "";
    long offset;

    public MIAsm(MITuple mITuple) {
        this.parse(mITuple);
    }

    public long getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.function;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getInstruction() {
        return String.valueOf(this.opcode) + " " + this.args;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("address=\"" + Long.toHexString(this.address) + "\"");
        stringBuffer.append(",func-name=\"" + this.function + "\"");
        stringBuffer.append(",offset=\"").append(this.offset).append('\"');
        stringBuffer.append(",inst=\"" + this.getInstruction() + "\"");
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    void parse(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue != null && mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getCString();
            }
            if (string.equals("address")) {
                try {
                    this.address = Long.decode(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("func-name")) {
                this.function = string2;
            } else if (string.equals("offset")) {
                try {
                    this.offset = Long.decode(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("inst")) {
                string2 = ((MIConst)mIValue).getString();
                char[] cArray = string2.toCharArray();
                int n2 = 0;
                while (n2 < cArray.length && cArray[n2] > ' ') {
                    ++n2;
                }
                this.opcode = string2.substring(0, n2);
                while (n2 < cArray.length && cArray[n2] >= '\u0000' && cArray[n2] <= ' ') {
                    ++n2;
                }
                if (n2 < cArray.length) {
                    this.args = string2.substring(n2);
                }
            }
            ++n;
        }
    }

    public String getArgs() {
        return this.args;
    }

    public String getOpcode() {
        return this.opcode;
    }
}

