/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakInsertInfo
extends MIInfo {
    MIBreakpoint[] breakpoints;

    void parse() {
        MIOutput mIOutput;
        MIResultRecord mIResultRecord;
        ArrayList<MIBreakpoint> arrayList = new ArrayList<MIBreakpoint>(1);
        if (this.isDone() && (mIResultRecord = (mIOutput = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                MIBreakpoint mIBreakpoint = null;
                if (string.equals("wpt")) {
                    if (mIValue instanceof MITuple) {
                        mIBreakpoint = new MIBreakpoint((MITuple)mIValue);
                        mIBreakpoint.setEnabled(true);
                        mIBreakpoint.setWriteWatchpoint(true);
                    }
                } else if (string.equals("bkpt")) {
                    if (mIValue instanceof MITuple) {
                        mIBreakpoint = new MIBreakpoint((MITuple)mIValue);
                        mIBreakpoint.setEnabled(true);
                    }
                } else if (string.equals("hw-awpt")) {
                    if (mIValue instanceof MITuple) {
                        mIBreakpoint = new MIBreakpoint((MITuple)mIValue);
                        mIBreakpoint.setAccessWatchpoint(true);
                        mIBreakpoint.setEnabled(true);
                    }
                } else if (string.equals("hw-rwpt") && mIValue instanceof MITuple) {
                    mIBreakpoint = new MIBreakpoint((MITuple)mIValue);
                    mIBreakpoint.setReadWatchpoint(true);
                    mIBreakpoint.setEnabled(true);
                }
                if (mIBreakpoint != null) {
                    arrayList.add(mIBreakpoint);
                }
                ++n;
            }
        }
        this.breakpoints = arrayList.toArray(new MIBreakpoint[arrayList.size()]);
    }

    public MIBreakInsertInfo(MIOutput mIOutput) {
        super(mIOutput);
    }

    public MIBreakpoint[] getMIBreakpoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }
}

