/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakListInfo
extends MIInfo {
    MIBreakpoint[] breakpoints;

    public MIBreakListInfo(MIOutput mIOutput) {
        super(mIOutput);
    }

    public MIBreakpoint[] getMIBreakpoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }

    void parse() {
        MIOutput mIOutput;
        MIResultRecord mIResultRecord;
        ArrayList arrayList = new ArrayList(1);
        if (this.isDone() && (mIResultRecord = (mIOutput = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                if (string.equals("BreakpointTable")) {
                    this.parseTable(mIResultArray[n].getMIValue(), arrayList);
                }
                ++n;
            }
        }
        this.breakpoints = arrayList.toArray(new MIBreakpoint[arrayList.size()]);
    }

    void parseTable(MIValue mIValue, List list) {
        if (mIValue instanceof MITuple) {
            MIResult[] mIResultArray = ((MITuple)mIValue).getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                if (string.equals("body")) {
                    this.parseBody(mIResultArray[n].getMIValue(), list);
                }
                ++n;
            }
        }
    }

    void parseBody(MIValue mIValue, List list) {
        if (mIValue instanceof MIList) {
            MIResult[] mIResultArray = ((MIList)mIValue).getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                MIValue mIValue2;
                String string = mIResultArray[n].getVariable();
                if (string.equals("bkpt") && (mIValue2 = mIResultArray[n].getMIValue()) instanceof MITuple) {
                    list.add(new MIBreakpoint((MITuple)mIValue2));
                }
                ++n;
            }
        }
    }
}

