/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakpoint {
    int number;
    String type = "";
    String disp = "";
    boolean enabled;
    long address;
    String func = "";
    String file = "";
    int line;
    String cond = "";
    int times;
    String what = "";
    String threadId = "";
    int ignore;
    boolean isWpt;
    boolean isAWpt;
    boolean isRWpt;
    boolean isWWpt;
    boolean isHdw;

    public MIBreakpoint(MITuple mITuple) {
        this.parse(mITuple);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public String getType() {
        return this.type;
    }

    public boolean isTemporary() {
        return this.getDisposition().equals("del");
    }

    public boolean isWatchpoint() {
        return this.isWpt;
    }

    public void setWatchpoint(boolean bl) {
        this.isWpt = bl;
    }

    public boolean isHardware() {
        return this.isHdw;
    }

    public void setHardware(boolean bl) {
        this.isWpt = bl;
        this.isHdw = bl;
    }

    public boolean isAccessWatchpoint() {
        return this.isAWpt;
    }

    public void setAccessWatchpoint(boolean bl) {
        this.isWpt = bl;
        this.isAWpt = bl;
    }

    public boolean isReadWatchpoint() {
        return this.isRWpt;
    }

    public void setReadWatchpoint(boolean bl) {
        this.isWpt = bl;
        this.isRWpt = bl;
    }

    public boolean isWriteWatchpoint() {
        return this.isWWpt;
    }

    public void setWriteWatchpoint(boolean bl) {
        this.isWpt = bl;
        this.isWWpt = bl;
    }

    public String getDisposition() {
        return this.disp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public long getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getTimes() {
        return this.times;
    }

    public String getWhat() {
        return this.what;
    }

    public int getIgnoreCount() {
        return this.ignore;
    }

    public String getCondition() {
        return this.cond;
    }

    public String getThreadId() {
        return this.threadId;
    }

    void parse(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue != null && mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getCString();
            }
            if (string.equals("number")) {
                try {
                    this.number = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("type")) {
                this.type = string2;
                if (this.type.startsWith("hw")) {
                    this.isHdw = true;
                    this.isWWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("acc")) {
                    this.isWWpt = true;
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("read")) {
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (this.type.equals("watchpoint")) {
                    this.isWpt = true;
                }
            } else if (string.equals("disp")) {
                this.disp = string2;
            } else if (string.equals("enabled")) {
                this.enabled = string2.equals("y");
            } else if (string.equals("addr")) {
                try {
                    this.address = Long.decode(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("func")) {
                this.func = string2;
            } else if (string.equals("file")) {
                this.file = string2;
            } else if (string.equals("thread")) {
                this.threadId = string2;
            } else if (string.equals("line")) {
                try {
                    this.line = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("times")) {
                try {
                    this.times = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("what") || string.equals("exp")) {
                this.what = string2;
            } else if (string.equals("ignore")) {
                try {
                    this.ignore = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("cond")) {
                this.cond = string2;
            }
            ++n;
        }
    }
}

