/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoThreadsInfo
extends MIInfo {
    protected int[] threadIds;
    protected int currentThreadId;

    public MIInfoThreadsInfo(MIOutput mIOutput) {
        super(mIOutput);
        this.parse();
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public String[] getThreadNames() {
        return null;
    }

    public int getCurrentThread() {
        return this.currentThreadId;
    }

    protected void parse() {
        ArrayList arrayList = new ArrayList();
        if (this.isDone()) {
            MIOutput mIOutput = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = mIOutput.getMIOOBRecords();
            int n = 0;
            while (n < mIOOBRecordArray.length) {
                if (mIOOBRecordArray[n] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord mIStreamRecord = (MIStreamRecord)mIOOBRecordArray[n];
                    String string = mIStreamRecord.getString();
                    this.parseThreadInfo(string.trim(), arrayList);
                }
                ++n;
            }
        }
        this.threadIds = new int[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            this.threadIds[n] = (Integer)arrayList.get(n);
            ++n;
        }
        Arrays.sort(this.threadIds);
    }

    protected void parseThreadInfo(String string, List list) {
        if (string.length() > 0) {
            boolean bl = false;
            if (string.charAt(0) == '*') {
                bl = true;
                string = string.substring(1).trim();
            }
            if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
                int n = 1;
                while (n < string.length() && Character.isDigit(string.charAt(n))) {
                    ++n;
                }
                String string2 = string.substring(0, n);
                try {
                    Integer n2 = Integer.valueOf(string2);
                    list.add(n2);
                    if (bl) {
                        this.currentThreadId = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }
}

