/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIAsyncRecord;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MINotifyAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIStatusAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;
import org.eclipse.cdt.debug.mi.core.output.MITargetStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIParser {
    public MIOutput parse(String string) {
        MIOOBRecord[] mIOOBRecordArray;
        MIOutput mIOutput = new MIOutput();
        MIResultRecord mIResultRecord = null;
        ArrayList<MIOOBRecord> arrayList = new ArrayList<MIOOBRecord>(1);
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            MIOOBRecord mIOOBRecord;
            mIOOBRecordArray = new StringBuffer(stringTokenizer.nextToken());
            if (mIOOBRecordArray.length() > 0 && Character.isDigit(mIOOBRecordArray.charAt(0))) {
                int n2 = 1;
                while (n2 < mIOOBRecordArray.length() && Character.isDigit(mIOOBRecordArray.charAt(n2))) {
                    ++n2;
                }
                String string2 = mIOOBRecordArray.substring(0, n2);
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                mIOOBRecordArray.delete(0, n2);
            }
            if (mIOOBRecordArray.length() <= 0) continue;
            if (mIOOBRecordArray.charAt(0) == '^') {
                mIOOBRecordArray.deleteCharAt(0);
                mIResultRecord = this.processMIResultRecord((StringBuffer)mIOOBRecordArray, n);
                continue;
            }
            if (mIOOBRecordArray.toString().startsWith("(gdb)") || (mIOOBRecord = this.processMIOOBRecord((StringBuffer)mIOOBRecordArray, n)) == null) continue;
            arrayList.add(mIOOBRecord);
        }
        mIOOBRecordArray = arrayList.toArray(new MIOOBRecord[arrayList.size()]);
        mIOutput.setMIOOBRecords(mIOOBRecordArray);
        mIOutput.setMIResultRecord(mIResultRecord);
        return mIOutput;
    }

    private MIResultRecord processMIResultRecord(StringBuffer stringBuffer, int n) {
        MIResultRecord mIResultRecord = new MIResultRecord();
        mIResultRecord.setToken(n);
        if (stringBuffer.toString().startsWith("done")) {
            mIResultRecord.setResultClass("done");
            stringBuffer.delete(0, "done".length());
        } else if (stringBuffer.toString().startsWith("error")) {
            mIResultRecord.setResultClass("error");
            stringBuffer.delete(0, "error".length());
        } else if (stringBuffer.toString().startsWith("exit")) {
            mIResultRecord.setResultClass("exit");
            stringBuffer.delete(0, "exit".length());
        } else if (stringBuffer.toString().startsWith("running")) {
            mIResultRecord.setResultClass("running");
            stringBuffer.delete(0, "running".length());
        } else if (stringBuffer.toString().startsWith("connected")) {
            mIResultRecord.setResultClass("connected");
            stringBuffer.delete(0, "connected".length());
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == ',') {
            stringBuffer.deleteCharAt(0);
            MIResult[] mIResultArray = this.processMIResults(new FSB(stringBuffer));
            mIResultRecord.setMIResults(mIResultArray);
        }
        return mIResultRecord;
    }

    private MIOOBRecord processMIOOBRecord(StringBuffer stringBuffer, int n) {
        MIOOBRecord mIOOBRecord = null;
        char c = stringBuffer.charAt(0);
        if (c == '*' || c == '+' || c == '=') {
            MIResult[] mIResultArray;
            stringBuffer.deleteCharAt(0);
            MIAsyncRecord mIAsyncRecord = null;
            switch (c) {
                case '*': {
                    mIAsyncRecord = new MIExecAsyncOutput();
                    break;
                }
                case '+': {
                    mIAsyncRecord = new MIStatusAsyncOutput();
                    break;
                }
                case '=': {
                    mIAsyncRecord = new MINotifyAsyncOutput();
                }
            }
            mIAsyncRecord.setToken(n);
            int n2 = stringBuffer.toString().indexOf(44);
            if (n2 != -1) {
                mIResultArray = stringBuffer.substring(0, n2);
                mIAsyncRecord.setAsyncClass((String)mIResultArray);
                stringBuffer.delete(0, n2 + 1);
            } else {
                mIAsyncRecord.setAsyncClass(stringBuffer.toString().trim());
                stringBuffer.setLength(0);
            }
            mIResultArray = this.processMIResults(new FSB(stringBuffer));
            mIAsyncRecord.setMIResults(mIResultArray);
            mIOOBRecord = mIAsyncRecord;
        } else if (c == '~' || c == '@' || c == '&') {
            stringBuffer.deleteCharAt(0);
            MIStreamRecord mIStreamRecord = null;
            switch (c) {
                case '~': {
                    mIStreamRecord = new MIConsoleStreamOutput();
                    break;
                }
                case '@': {
                    mIStreamRecord = new MITargetStreamOutput();
                    break;
                }
                case '&': {
                    mIStreamRecord = new MILogStreamOutput();
                }
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '\"') {
                stringBuffer.deleteCharAt(0);
            }
            mIStreamRecord.setCString(this.translateCString(new FSB(stringBuffer)));
            mIOOBRecord = mIStreamRecord;
        } else {
            MITargetStreamOutput mITargetStreamOutput = new MITargetStreamOutput();
            mITargetStreamOutput.setCString(String.valueOf(stringBuffer.toString()) + "\n");
            mIOOBRecord = mITargetStreamOutput;
        }
        return mIOOBRecord;
    }

    private MIResult[] processMIResults(FSB fSB) {
        ArrayList<MIResult> arrayList = new ArrayList<MIResult>();
        MIResult mIResult = this.processMIResult(fSB);
        if (mIResult != null) {
            arrayList.add(mIResult);
        }
        while (fSB.length() > 0 && fSB.charAt(0) == ',') {
            fSB.deleteCharAt(0);
            mIResult = this.processMIResult(fSB);
            if (mIResult == null) continue;
            arrayList.add(mIResult);
        }
        return arrayList.toArray(new MIResult[arrayList.size()]);
    }

    private MIResult processMIResult(FSB fSB) {
        int n;
        MIResult mIResult = new MIResult();
        if (fSB.length() > 0 && Character.isLetter(fSB.charAt(0)) && (n = fSB.indexOf('=')) != -1) {
            String string = fSB.substring(0, n);
            mIResult.setVariable(string);
            fSB.delete(0, n + 1);
            MIValue mIValue = this.processMIValue(fSB);
            mIResult.setMIValue(mIValue);
        } else {
            mIResult.setVariable(fSB.toString());
            mIResult.setMIValue(new MIConst());
            fSB.setLength(0);
        }
        return mIResult;
    }

    private MIValue processMIValue(FSB fSB) {
        MIValue mIValue = null;
        if (fSB.length() > 0) {
            if (fSB.charAt(0) == '{') {
                fSB.deleteCharAt(0);
                mIValue = this.processMITuple(fSB);
            } else if (fSB.charAt(0) == '[') {
                fSB.deleteCharAt(0);
                mIValue = this.processMIList(fSB);
            } else if (fSB.charAt(0) == '\"') {
                fSB.deleteCharAt(0);
                MIConst mIConst = new MIConst();
                mIConst.setCString(this.translateCString(fSB));
                mIValue = mIConst;
            }
        }
        return mIValue;
    }

    private MIValue processMITuple(FSB fSB) {
        MITuple mITuple = new MITuple();
        MIResult[] mIResultArray = null;
        while (fSB.length() > 0 && fSB.charAt(0) != '}') {
            mIResultArray = this.processMIResults(fSB);
        }
        if (fSB.length() > 0 && fSB.charAt(0) == '}') {
            fSB.deleteCharAt(0);
        }
        if (mIResultArray == null) {
            mIResultArray = new MIResult[]{};
        }
        mITuple.setMIResults(mIResultArray);
        return mITuple;
    }

    private MIValue processMIList(FSB fSB) {
        MIResult[] mIResultArray;
        MIValue[] mIValueArray;
        MIList mIList = new MIList();
        ArrayList<MIValue[]> arrayList = new ArrayList<MIValue[]>();
        ArrayList<MIResult[]> arrayList2 = new ArrayList<MIResult[]>();
        while (fSB.length() > 0 && fSB.charAt(0) != ']') {
            mIValueArray = this.processMIValue(fSB);
            if (mIValueArray != null) {
                arrayList.add(mIValueArray);
            } else {
                mIResultArray = this.processMIResult(fSB);
                if (mIResultArray != null) {
                    arrayList2.add(mIResultArray);
                }
            }
            if (fSB.length() <= 0 || fSB.charAt(0) != ',') continue;
            fSB.deleteCharAt(0);
        }
        if (fSB.length() > 0 && fSB.charAt(0) == ']') {
            fSB.deleteCharAt(0);
        }
        mIValueArray = arrayList.toArray(new MIValue[arrayList.size()]);
        mIResultArray = arrayList2.toArray(new MIResult[arrayList2.size()]);
        mIList.setMIValues(mIValueArray);
        mIList.setMIResults(mIResultArray);
        return mIList;
    }

    private String translateCString(FSB fSB) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fSB.length() && !bl2) {
            char c = fSB.charAt(n);
            if (c == '\\') {
                if (bl) {
                    stringBuffer.append(c);
                    bl = false;
                } else {
                    bl = true;
                }
            } else if (c == '\"') {
                if (bl) {
                    stringBuffer.append(c);
                    bl = false;
                } else {
                    bl2 = true;
                }
            } else {
                if (bl) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                bl = false;
            }
            ++n;
        }
        fSB.delete(0, n);
        return stringBuffer.toString();
    }

    public class FSB {
        StringBuffer buf;
        int pos;
        boolean shared;

        public FSB(StringBuffer stringBuffer) {
            this.buf = stringBuffer;
            this.pos = 0;
            this.shared = false;
        }

        public FSB(FSB fSB) {
            this.pos = fSB.pos;
            this.buf = fSB.buf;
            this.shared = true;
        }

        public int length() {
            int n = this.buf.length() - this.pos;
            if (n < 0) {
                return 0;
            }
            return n;
        }

        public char charAt(int n) {
            return this.buf.charAt(n + this.pos);
        }

        private void resolveCopy() {
            if (this.shared) {
                this.buf = new StringBuffer(this.buf.toString());
                this.shared = false;
            }
        }

        public FSB deleteCharAt(int n) {
            if (n == 0) {
                ++this.pos;
            } else {
                this.resolveCopy();
                this.buf = this.buf.deleteCharAt(this.pos + n);
            }
            return this;
        }

        public FSB delete(int n, int n2) {
            if (n == 0) {
                this.pos = this.pos + n2 - n;
            } else {
                this.resolveCopy();
                this.buf.delete(n + this.pos, n2 + this.pos);
            }
            return this;
        }

        public void setLength(int n) {
            if (n == 0) {
                this.pos = this.buf.length();
            }
        }

        public String substring(int n, int n2) {
            return this.buf.substring(n + this.pos, n2 + this.pos);
        }

        public String toString() {
            return this.buf.substring(this.pos, this.buf.length());
        }

        int indexOf(char c) {
            int n = this.buf.length();
            int n2 = this.pos;
            while (n2 < n) {
                if (this.buf.charAt(n2) == c) {
                    return n2 - this.pos;
                }
                ++n2;
            }
            return -1;
        }

        boolean startsWith(String string) {
            int n = Math.min(string.length(), this.length());
            if (n < string.length()) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) != this.buf.charAt(this.pos + n2)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

