/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIRegisterValue {
    int number;
    String value;

    public MIRegisterValue(int n, String string) {
        this.number = n;
        this.value = string;
    }

    public int getNumber() {
        return this.number;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("number=\"").append(this.number).append('\"');
        stringBuffer.append(',').append("value=\"" + this.value + "\"");
        return stringBuffer.toString();
    }

    public static MIRegisterValue[] getMIRegisterValues(MIList mIList) {
        ArrayList<MIRegisterValue> arrayList = new ArrayList<MIRegisterValue>();
        MIValue[] mIValueArray = mIList.getMIValues();
        int n = 0;
        while (n < mIValueArray.length) {
            MIRegisterValue mIRegisterValue;
            if (mIValueArray[n] instanceof MITuple && (mIRegisterValue = MIRegisterValue.getMIRegisterValue((MITuple)mIValueArray[n])) != null) {
                arrayList.add(mIRegisterValue);
            }
            ++n;
        }
        return arrayList.toArray(new MIRegisterValue[arrayList.size()]);
    }

    public static MIRegisterValue getMIRegisterValue(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        MIRegisterValue mIRegisterValue = null;
        if (mIResultArray.length == 2) {
            String string = "";
            MIValue mIValue = mIResultArray[0].getMIValue();
            string = mIValue != null && mIValue instanceof MIConst ? ((MIConst)mIValue).getCString() : "";
            String string2 = "";
            mIValue = mIResultArray[1].getMIValue();
            string2 = mIValue != null && mIValue instanceof MIConst ? ((MIConst)mIValue).getCString() : "";
            try {
                int n = Integer.parseInt(string.trim());
                mIRegisterValue = new MIRegisterValue(n, string2.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return mIRegisterValue;
    }
}

