/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIAsm;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MISrcAsm {
    int line;
    String file = "";
    MIAsm[] asm;

    public MISrcAsm(MITuple mITuple) {
        this.parse(mITuple);
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public MIAsm[] getMIAsms() {
        return this.asm;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("src_and_asm_line={");
        stringBuffer.append("line=\"").append(this.line).append('\"');
        stringBuffer.append(",file=\"" + this.file + "\",");
        stringBuffer.append("line_asm_insn=[");
        int n = 0;
        while (n < this.asm.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.asm[n].toString());
            ++n;
        }
        stringBuffer.append(']');
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    void parse(MITuple mITuple) {
        ArrayList<MIAsm> arrayList = new ArrayList<MIAsm>();
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue != null && mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getCString();
            }
            if (string.equals("line_asm_insn") && mIValue instanceof MIList) {
                MIList mIList = (MIList)mIValue;
                MIValue[] mIValueArray = mIList.getMIValues();
                int n2 = 0;
                while (n2 < mIValueArray.length) {
                    if (mIValueArray[n2] instanceof MITuple) {
                        arrayList.add(new MIAsm((MITuple)mIValueArray[n2]));
                    }
                    ++n2;
                }
            }
            if (string.equals("line")) {
                try {
                    this.line = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("file")) {
                this.file = string2;
            }
            ++n;
        }
        this.asm = arrayList.toArray(new MIAsm[arrayList.size()]);
    }
}

