/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIThreadListIdsInfo
extends MIInfo {
    int[] threadIds;

    public MIThreadListIdsInfo(MIOutput mIOutput) {
        super(mIOutput);
    }

    public int[] getThreadIds() {
        if (this.threadIds == null) {
            this.parse();
        }
        return this.threadIds;
    }

    void parse() {
        MIOutput mIOutput;
        MIResultRecord mIResultRecord;
        if (this.isDone() && (mIResultRecord = (mIOutput = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                MIValue mIValue;
                String string = mIResultArray[n].getVariable();
                if (string.equals("thread-ids") && (mIValue = mIResultArray[n].getMIValue()) instanceof MITuple) {
                    this.parseThreadIds((MITuple)mIValue);
                }
                ++n;
            }
        }
        if (this.threadIds == null) {
            this.threadIds = new int[0];
        }
    }

    void parseThreadIds(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        this.threadIds = new int[mIResultArray.length];
        int n = 0;
        while (n < mIResultArray.length) {
            MIValue mIValue;
            String string = mIResultArray[n].getVariable();
            if (string.equals("thread-id") && (mIValue = mIResultArray[n].getMIValue()) instanceof MIConst) {
                String string2 = ((MIConst)mIValue).getCString();
                try {
                    this.threadIds[n] = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
    }
}

