/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IPageValidator;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class ConfigureSynchronizeScheduleComposite
extends Composite {
    private SubscriberRefreshSchedule schedule;
    private Button userRefreshOnly;
    private Button enableBackgroundRefresh;
    private Text time;
    private Combo hoursOrSeconds;
    private String errorMessage;
    private IPageValidator validator;

    public ConfigureSynchronizeScheduleComposite(Composite parent, SubscriberRefreshSchedule schedule, IPageValidator validator) {
        super(parent, 0);
        this.schedule = schedule;
        this.validator = validator;
        this.createMainDialogArea(parent);
    }

    private void initializeValues() {
        long minutes;
        boolean enableBackground = this.schedule.isEnabled();
        boolean hours = false;
        this.userRefreshOnly.setSelection(!enableBackground);
        this.enableBackgroundRefresh.setSelection(enableBackground);
        long seconds = this.schedule.getRefreshInterval();
        if (seconds <= 60L) {
            seconds = 60L;
        }
        if ((minutes = seconds / 60L) >= 60L) {
            minutes /= 60L;
            hours = true;
        }
        this.hoursOrSeconds.select(hours ? 0 : 1);
        this.time.setText(Long.toString(minutes));
    }

    protected void createMainDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData());
        ConfigureSynchronizeScheduleComposite area = this;
        this.createWrappingLabel(area, Policy.bind("ConfigureRefreshScheduleDialog.1", this.schedule.getParticipant().getName()), 0, 2);
        Label label = new Label((Composite)area, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Policy.bind("ConfigureRefreshScheduleDialog.1a", SubscriberRefreshSchedule.refreshEventAsString(this.schedule.getLastRefreshEvent())));
        this.userRefreshOnly = new Button((Composite)area, 16);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.userRefreshOnly.setLayoutData((Object)gridData2);
        this.userRefreshOnly.setText(Policy.bind("ConfigureRefreshScheduleDialog.2"));
        this.userRefreshOnly.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableBackgroundRefresh = new Button((Composite)area, 16);
        gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.enableBackgroundRefresh.setLayoutData((Object)gridData2);
        this.enableBackgroundRefresh.setText(Policy.bind("ConfigureRefreshScheduleDialog.3"));
        this.enableBackgroundRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite composite = new Composite((Composite)area, 0);
        gridData = new GridData(1794);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite.setLayout((Layout)gridLayout_1);
        Label label2 = new Label(composite, 0);
        label2.setText(Policy.bind("ConfigureRefreshScheduleDialog.4"));
        this.time = new Text(composite, 133120);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 35;
        this.time.setLayoutData((Object)gridData_1);
        this.time.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }
        });
        this.hoursOrSeconds = new Combo(composite, 8);
        this.hoursOrSeconds.setItems(new String[]{Policy.bind("ConfigureRefreshScheduleDialog.5"), Policy.bind("ConfigureRefreshScheduleDialog.6")});
        gridData_1 = new GridData();
        gridData_1.widthHint = 75;
        this.hoursOrSeconds.setLayoutData((Object)gridData_1);
        this.initializeValues();
    }

    public void saveValues() {
        SubscriberParticipant participant;
        int hours = this.hoursOrSeconds.getSelectionIndex();
        long seconds = Long.parseLong(this.time.getText());
        seconds = hours == 0 ? (seconds *= 3600L) : (seconds *= 60L);
        this.schedule.setRefreshInterval(seconds);
        if (this.schedule.isEnabled() != this.enableBackgroundRefresh.getSelection()) {
            this.schedule.setEnabled(this.enableBackgroundRefresh.getSelection(), true);
        }
        if (!(participant = this.schedule.getParticipant()).isPinned() && this.schedule.isEnabled()) {
            participant.setPinned(MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("ConfigureSynchronizeScheduleComposite.0", Utils.getTypeName(participant)), (String)Policy.bind("ConfigureSynchronizeScheduleComposite.1", Utils.getTypeName(participant))));
        }
        participant.setRefreshSchedule(this.schedule);
    }

    public void updateEnablements() {
        try {
            long number = Long.parseLong(this.time.getText());
            if (number <= 0L) {
                this.validator.setComplete(Policy.bind("ConfigureRefreshScheduleDialog.7"));
            } else {
                this.validator.setComplete(null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.validator.setComplete(Policy.bind("ConfigureRefreshScheduleDialog.8"));
        }
        this.time.setEnabled(this.enableBackgroundRefresh.getSelection());
        this.hoursOrSeconds.setEnabled(this.enableBackgroundRefresh.getSelection());
    }

    protected void setErrorMessage(String error) {
        this.errorMessage = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private Label createWrappingLabel(Composite parent, String text, int indent, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }
}

