/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.memory;

import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.IMemoryBlockListener;
import org.eclipse.debug.internal.core.memory.IMemoryBlockManager;
import org.eclipse.debug.internal.core.memory.IMemoryRenderingManager;
import org.eclipse.debug.internal.core.memory.MemoryRenderingManager;

public class MemoryBlockManager
implements IMemoryBlockManager,
IDebugEventSetListener {
    private ArrayList listeners = new ArrayList();
    private ArrayList memoryBlocks = new ArrayList();
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static MemoryBlockManager fgMemoryBlockManager;
    private static MemoryRenderingManager fgMemoryRenderingManager;

    public static IMemoryBlockManager getMemoryBlockManager() {
        if (fgMemoryBlockManager == null) {
            fgMemoryBlockManager = new MemoryBlockManager();
        }
        return fgMemoryBlockManager;
    }

    public static IMemoryRenderingManager getMemoryRenderingManager() {
        if (fgMemoryRenderingManager == null) {
            fgMemoryRenderingManager = new MemoryRenderingManager();
        }
        return fgMemoryRenderingManager;
    }

    public static void pluginShutdown() {
        if (fgMemoryBlockManager != null) {
            fgMemoryBlockManager.shutdown();
        }
        if (fgMemoryRenderingManager != null) {
            fgMemoryRenderingManager.shutdown();
        }
    }

    private MemoryBlockNotifier getMemoryBlockNotifier() {
        return new MemoryBlockNotifier();
    }

    public void addMemoryBlock(IMemoryBlock mem, boolean addDefaultRenderings) {
        if (this.memoryBlocks == null) {
            return;
        }
        if (mem == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.addMemoryBlock", null);
            return;
        }
        if (this.memoryBlocks.contains(mem)) {
            return;
        }
        MemoryRenderingManager renderingManager = (MemoryRenderingManager)MemoryBlockManager.getMemoryRenderingManager();
        if (!addDefaultRenderings) {
            renderingManager.setHandleMemoryBlockAddedEvent(false);
        } else {
            renderingManager.setHandleMemoryBlockAddedEvent(true);
        }
        if (mem == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.addMemoryBlock", null);
            return;
        }
        this.memoryBlocks.add(mem);
        if (this.memoryBlocks.size() == 1) {
            DebugPlugin.getDefault().addDebugEventListener(this);
        }
        this.notifyListeners(mem, 0);
        renderingManager.setHandleMemoryBlockAddedEvent(true);
    }

    public void removeMemoryBlock(IMemoryBlock mem) {
        if (this.memoryBlocks == null) {
            return;
        }
        if (mem == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.removeMemoryBlock", null);
            return;
        }
        this.memoryBlocks.remove(mem);
        if (this.memoryBlocks.size() == 0) {
            DebugPlugin.getDefault().removeDebugEventListener(this);
        }
        if (mem instanceof IExtendedMemoryBlock) {
            ((IExtendedMemoryBlock)mem).delete();
        }
        this.notifyListeners(mem, 1);
    }

    public void addListener(IMemoryBlockListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.addListener", null);
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IMemoryBlockListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.removeListener", null);
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public IMemoryBlock[] getAllMemoryBlocks() {
        IMemoryBlock[] blocks = this.memoryBlocks.toArray(new IMemoryBlock[this.memoryBlocks.size()]);
        return blocks;
    }

    public IMemoryBlock[] getMemoryBlocks(IDebugTarget debugTarget) {
        IMemoryBlock[] blocks = this.memoryBlocks.toArray(new IMemoryBlock[this.memoryBlocks.size()]);
        ArrayList<IMemoryBlock> memoryBlocksList = new ArrayList<IMemoryBlock>();
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i].getDebugTarget() == debugTarget) {
                memoryBlocksList.add(blocks[i]);
            }
            ++i;
        }
        return memoryBlocksList.toArray(new IMemoryBlock[memoryBlocksList.size()]);
    }

    public IMemoryBlock[] getMemoryBlocks(IMemoryBlockRetrieval retrieve) {
        IMemoryBlock[] blocks = this.memoryBlocks.toArray(new IMemoryBlock[this.memoryBlocks.size()]);
        ArrayList<IMemoryBlock> memoryBlocksList = new ArrayList<IMemoryBlock>(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i] instanceof IExtendedMemoryBlock) {
                if (((IExtendedMemoryBlock)blocks[i]).getMemoryBlockRetrieval() == retrieve) {
                    memoryBlocksList.add(blocks[i]);
                }
            } else if (blocks[i].getDebugTarget() == retrieve) {
                memoryBlocksList.add(blocks[i]);
            }
            ++i;
        }
        return memoryBlocksList.toArray(new IMemoryBlock[memoryBlocksList.size()]);
    }

    private void notifyListeners(IMemoryBlock memoryBlock, int event) {
        this.getMemoryBlockNotifier().notify(memoryBlock, event);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    public void handleDebugEvent(DebugEvent event) {
        Object obj = event.getSource();
        IDebugTarget dt = null;
        if (event.getKind() == 8) {
            if (obj instanceof IDebugTarget) {
                dt = (IDebugTarget)obj;
            }
            IMemoryBlock[] deletedMemoryBlocks = this.getMemoryBlocks(dt);
            int i = 0;
            while (i < deletedMemoryBlocks.length) {
                this.removeMemoryBlock(deletedMemoryBlocks[i]);
                ++i;
            }
        }
    }

    public void shutdown() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.memoryBlocks != null) {
            this.memoryBlocks.clear();
            this.memoryBlocks = null;
        }
    }

    class MemoryBlockNotifier
    implements ISafeRunnable {
        private IMemoryBlockListener fListener;
        private int fType;
        private IMemoryBlock fMemoryBlock;

        MemoryBlockNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log(exception);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.MemoryBlockAdded(this.fMemoryBlock);
                    break;
                }
                case 1: {
                    this.fListener.MemoryBlockRemoved(this.fMemoryBlock);
                }
            }
        }

        public void notify(IMemoryBlock memoryBlock, int update) {
            if (MemoryBlockManager.this.listeners != null) {
                this.fType = update;
                IMemoryBlockListener[] copiedListeners = MemoryBlockManager.this.listeners.toArray(new IMemoryBlockListener[MemoryBlockManager.this.listeners.size()]);
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = copiedListeners[i];
                    this.fMemoryBlock = memoryBlock;
                    Platform.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fListener = null;
            this.fMemoryBlock = null;
        }
    }
}

