/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CGlobalVariable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;

public class CDIDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static ICLineBreakpoint createLineBreakpoint(String string, IResource iResource, int n, boolean bl, int n2, String string2, boolean bl2) throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        hashMap.put("lineNumber", new Integer(n));
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n2));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string2);
        hashMap.put("org.eclipse.cdt.debug.core.sourceHandle", string);
        return new CLineBreakpoint(iResource, hashMap, bl2);
    }

    public static ICAddressBreakpoint createAddressBreakpoint(String string, IResource iResource, long l, boolean bl, int n, String string2, boolean bl2) throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        hashMap.put("charStart", new Integer(0));
        hashMap.put("charEnd", new Integer(0));
        hashMap.put("lineNumber", new Integer(-1));
        hashMap.put("lineNumber", new Integer(-1));
        hashMap.put("org.eclipse.cdt.debug.core.address", Long.toString(l));
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string2);
        hashMap.put("org.eclipse.cdt.debug.core.sourceHandle", string);
        return new CAddressBreakpoint(iResource, hashMap, bl2);
    }

    public static ICWatchpoint createWatchpoint(String string, IResource iResource, boolean bl, boolean bl2, String string2, boolean bl3, int n, String string3, boolean bl4) throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl3));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string3);
        hashMap.put("org.eclipse.cdt.debug.core.sourceHandle", string);
        hashMap.put("org.eclipse.cdt.debug.core.expression", string2);
        hashMap.put("org.eclipse.cdt.debug.core.read", new Boolean(bl2));
        hashMap.put("org.eclipse.cdt.debug.core.write", new Boolean(bl));
        return new CWatchpoint(iResource, hashMap, bl4);
    }

    public static ICFunctionBreakpoint createFunctionBreakpoint(String string, IResource iResource, String string2, int n, int n2, int n3, boolean bl, int n4, String string3, boolean bl2) throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        hashMap.put("charStart", new Integer(n));
        hashMap.put("charEnd", new Integer(n2));
        hashMap.put("lineNumber", new Integer(n3));
        hashMap.put("org.eclipse.cdt.debug.core.function", string2);
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n4));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string3);
        hashMap.put("org.eclipse.cdt.debug.core.sourceHandle", string);
        return new CFunctionBreakpoint(iResource, hashMap, bl2);
    }

    public static ICLineBreakpoint lineBreakpointExists(String string, IResource iResource, int n) throws CoreException {
        String string2 = CDIDebugModel.getPluginIdentifier();
        String string3 = CLineBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            ICLineBreakpoint iCLineBreakpoint;
            if (iBreakpointArray[n2] instanceof ICLineBreakpoint && (iCLineBreakpoint = (ICLineBreakpoint)iBreakpointArray[n2]).getMarker().getType().equals(string3) && string != null && string.equals(iCLineBreakpoint.getSourceHandle()) && iCLineBreakpoint.getMarker().getResource().equals((Object)iResource) && iCLineBreakpoint.getLineNumber() == n) {
                return iCLineBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    public static ICAddressBreakpoint addressBreakpointExists(String string, IResource iResource, long l) throws CoreException {
        String string2 = CDIDebugModel.getPluginIdentifier();
        String string3 = CAddressBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICAddressBreakpoint iCAddressBreakpoint;
            if (iBreakpointArray[n] instanceof ICAddressBreakpoint && (iCAddressBreakpoint = (ICAddressBreakpoint)iBreakpointArray[n]).getMarker().getType().equals(string3) && string != null && string.equals(iCAddressBreakpoint.getSourceHandle()) && iCAddressBreakpoint.getMarker().getResource().equals((Object)iResource)) {
                try {
                    if (Long.parseLong(iCAddressBreakpoint.getAddress()) == l) {
                        return iCAddressBreakpoint;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
        return null;
    }

    public static ICWatchpoint watchpointExists(String string, IResource iResource, String string2) throws CoreException {
        String string3 = CDIDebugModel.getPluginIdentifier();
        String string4 = CWatchpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string3);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICWatchpoint iCWatchpoint;
            if (iBreakpointArray[n] instanceof ICWatchpoint && (iCWatchpoint = (ICWatchpoint)iBreakpointArray[n]).getMarker().getType().equals(string4) && string != null && string.equals(iCWatchpoint.getSourceHandle()) && iCWatchpoint.getMarker().getResource().equals((Object)iResource) && iCWatchpoint.getExpression().equals(string2)) {
                return iCWatchpoint;
            }
            ++n;
        }
        return null;
    }

    public static ICFunctionBreakpoint functionBreakpointExists(String string, IResource iResource, String string2) throws CoreException {
        String string3 = CDIDebugModel.getPluginIdentifier();
        String string4 = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string3);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICFunctionBreakpoint iCFunctionBreakpoint;
            if (iBreakpointArray[n] instanceof ICFunctionBreakpoint && (iCFunctionBreakpoint = (ICFunctionBreakpoint)iBreakpointArray[n]).getMarker().getType().equals(string4) && string != null && string.equals(iCFunctionBreakpoint.getSourceHandle()) && iCFunctionBreakpoint.getMarker().getResource().equals((Object)iResource) && iCFunctionBreakpoint.getFunction() != null && iCFunctionBreakpoint.getFunction().equals(string2)) {
                return iCFunctionBreakpoint;
            }
            ++n;
        }
        return null;
    }

    public static IExpression createExpression(IDebugTarget iDebugTarget, String string) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                return new CExpression((CDebugTarget)iDebugTarget, iCDIExpression);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, cDIException.getMessage(), null));
            }
        }
        return null;
    }

    public static IExpression createExpressionForGlobalVariable(IDebugTarget iDebugTarget, IPath iPath, String string) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            ICDIVariableObject iCDIVariableObject = null;
            try {
                iCDIVariableObject = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().getGlobalVariableObject(iPath.lastSegment(), null, string);
                ICDIVariable iCDIVariable = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().createVariable(iCDIVariableObject);
                return new CExpression((CDebugTarget)iDebugTarget, (ICDIVariableObject)iCDIVariable);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, iCDIVariableObject != null ? String.valueOf(iCDIVariableObject.getName()) + ": " + cDIException.getMessage() : cDIException.getMessage(), null));
            }
        }
        return null;
    }

    public static ICGlobalVariable createGlobalVariable(IDebugTarget iDebugTarget, IGlobalVariableDescriptor iGlobalVariableDescriptor) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            ICDIVariableObject iCDIVariableObject = null;
            try {
                iCDIVariableObject = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().getGlobalVariableObject(iGlobalVariableDescriptor.getPath().lastSegment(), null, iGlobalVariableDescriptor.getName());
                ICDIVariable iCDIVariable = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().createVariable(iCDIVariableObject);
                return new CGlobalVariable((CDebugElement)((CDebugTarget)iDebugTarget), iCDIVariable);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, iCDIVariableObject != null ? String.valueOf(iCDIVariableObject.getName()) + ": " + cDIException.getMessage() : cDIException.getMessage(), null));
            }
        }
        return null;
    }
}

