/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.core.model.CCoreFileDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CFormattedMemoryBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IProcess;

public class CDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(final ILaunch iLaunch, final ICDITarget iCDITarget, final String string, final IProcess iProcess, final IProcess iProcess2, final IFile iFile, final boolean bl, final boolean bl2, boolean bl3) throws DebugException {
        final IDebugTarget[] iDebugTargetArray = new IDebugTarget[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                iDebugTargetArray[0] = new CDebugTarget(iLaunch, 1, iCDITarget, string, iProcess, iProcess2, iFile, bl, bl2);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CDebugCorePlugin.log(coreException);
            throw new DebugException(coreException.getStatus());
        }
        ICDIConfiguration iCDIConfiguration = iCDITarget.getSession().getConfiguration();
        if (iCDIConfiguration.supportsBreakpoints() && bl3) {
            CDebugModel.stopInMain((CDebugTarget)iDebugTargetArray[0]);
        }
        if (iCDIConfiguration.supportsResume()) {
            iDebugTargetArray[0].resume();
        }
        return iDebugTargetArray[0];
    }

    public static IDebugTarget newAttachDebugTarget(final ILaunch iLaunch, final ICDITarget iCDITarget, final String string, final IProcess iProcess, final IFile iFile) throws DebugException {
        final IDebugTarget[] iDebugTargetArray = new IDebugTarget[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                iDebugTargetArray[0] = new CDebugTarget(iLaunch, 2, iCDITarget, string, null, iProcess, iFile, false, true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CDebugCorePlugin.log(coreException);
            throw new DebugException(coreException.getStatus());
        }
        ICDIEvent[] iCDIEventArray = new ICDIEvent[]{new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return iCDITarget;
            }
        }};
        ((CDebugTarget)iDebugTargetArray[0]).handleDebugEvents(iCDIEventArray);
        return iDebugTargetArray[0];
    }

    public static IDebugTarget newCoreFileDebugTarget(final ILaunch iLaunch, final ICDITarget iCDITarget, final String string, final IProcess iProcess, final IFile iFile) throws DebugException {
        final IDebugTarget[] iDebugTargetArray = new IDebugTarget[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                iDebugTargetArray[0] = new CCoreFileDebugTarget(iLaunch, iCDITarget, string, iProcess, iFile);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CDebugCorePlugin.log(coreException);
            throw new DebugException(coreException.getStatus());
        }
        ICDIEvent[] iCDIEventArray = new ICDIEvent[]{new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return iCDITarget;
            }
        }};
        ((CDebugTarget)iDebugTargetArray[0]).handleDebugEvents(iCDIEventArray);
        return iDebugTargetArray[0];
    }

    public static IExpression createExpression(IDebugTarget iDebugTarget, String string) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                return new CExpression((CDebugTarget)iDebugTarget, iCDIExpression);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getMessage(), null));
            }
        }
        return null;
    }

    public static IExpression createExpressionForGlobalVariable(IDebugTarget iDebugTarget, IPath iPath, String string) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            ICDIVariableObject iCDIVariableObject = null;
            try {
                iCDIVariableObject = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().getGlobalVariableObject(iPath.lastSegment(), null, string);
                ICDIVariable iCDIVariable = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().createVariable(iCDIVariableObject);
                return new CExpression((CDebugTarget)iDebugTarget, (ICDIVariableObject)iCDIVariable);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, iCDIVariableObject != null ? String.valueOf(iCDIVariableObject.getName()) + ": " + cDIException.getMessage() : cDIException.getMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget iDebugTarget, String string, int n, int n2, int n3, int n4, char c) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                ICDIMemoryBlock iCDIMemoryBlock = ((CDebugTarget)iDebugTarget).getCDISession().getMemoryManager().createMemoryBlock(iCDIExpression.getName(), n2 * n3 * n4);
                return new CFormattedMemoryBlock((CDebugTarget)iDebugTarget, iCDIMemoryBlock, iCDIExpression, n, n2, n3, n4, c);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getDetailMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget iDebugTarget, String string, int n, int n2, int n3, int n4) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                ICDIMemoryBlock iCDIMemoryBlock = ((CDebugTarget)iDebugTarget).getCDISession().getMemoryManager().createMemoryBlock(iCDIExpression.getName(), n2 * n3 * n4);
                return new CFormattedMemoryBlock((CDebugTarget)iDebugTarget, iCDIMemoryBlock, iCDIExpression, n, n2, n3, n4);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getDetailMessage(), null));
            }
        }
        return null;
    }

    private static void stopInMain(CDebugTarget cDebugTarget) throws DebugException {
        block2: {
            ICDILocation iCDILocation = cDebugTarget.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            try {
                cDebugTarget.setInternalTemporaryBreakpoint(iCDILocation);
            }
            catch (DebugException debugException) {
                String string = MessageFormat.format(DebugCoreMessages.getString("CDebugModel.0"), debugException.getStatus().getMessage());
                Status status = new Status(2, debugException.getStatus().getPlugin(), 10000, string, null);
                if (CDebugUtils.question((IStatus)status, cDebugTarget)) break block2;
                cDebugTarget.terminate();
                throw new DebugException((IStatus)new Status(0, debugException.getStatus().getPlugin(), debugException.getStatus().getCode(), debugException.getStatus().getMessage(), null));
            }
        }
    }
}

