/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CFloatingPointValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.w3c.dom.Document;

public class CDebugUtils {
    public static boolean question(IStatus iStatus, Object object) {
        Boolean bl = new Boolean(false);
        IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(iStatus);
        if (iStatusHandler != null) {
            try {
                bl = (Boolean)iStatusHandler.handleStatus(iStatus, object);
            }
            catch (CoreException coreException) {}
        }
        return bl;
    }

    public static void info(IStatus iStatus, Object object) {
        IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(iStatus);
        if (iStatusHandler != null) {
            try {
                iStatusHandler.handleStatus(iStatus, object);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void error(IStatus iStatus, Object object) {
        IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(iStatus);
        if (iStatusHandler != null) {
            try {
                iStatusHandler.handleStatus(iStatus, object);
            }
            catch (CoreException coreException) {}
        }
    }

    public static String toHexAddressString(long l) {
        String string = Long.toHexString(l);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("0x");
        int n = 0;
        while (n < 8 - string.length()) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static char[] getByteText(byte by) {
        return new char[]{CDebugUtils.charFromByte((byte)(by >>> 4 & 0xF)), CDebugUtils.charFromByte((byte)(by & 0xF))};
    }

    public static byte textToByte(char[] cArray) {
        byte by = 0;
        if (cArray.length == 2) {
            byte[] byArray = new byte[]{CDebugUtils.charToByte(cArray[0]), CDebugUtils.charToByte(cArray[1])};
            by = (byte)((byArray[0] << 4) + byArray[1]);
        }
        return by;
    }

    public static char charFromByte(byte by) {
        if (by >= 0 && by <= 9) {
            return (char)(by + 48);
        }
        if (by >= 10 && by <= 15) {
            return (char)(by - 10 + 97);
        }
        return '0';
    }

    public static byte charToByte(char c) {
        if (Character.isDigit(c)) {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(10 + c - 65);
        }
        return 0;
    }

    public static char bytesToChar(byte[] byArray) {
        try {
            return (char)Short.parseShort(new String(byArray), 16);
        }
        catch (RuntimeException runtimeException) {
            return '\u0000';
        }
    }

    public static byte toByte(char[] cArray, boolean bl) {
        if (cArray.length != 2) {
            return 0;
        }
        return (byte)Long.parseLong(CDebugUtils.bytesToString(cArray, bl, true), 16);
    }

    public static short toUnsignedByte(char[] cArray, boolean bl) {
        if (cArray.length != 2) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(cArray, bl, false), 16);
    }

    public static short toShort(char[] cArray, boolean bl) {
        if (cArray.length != 4) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(cArray, bl, true), 16);
    }

    public static int toUnsignedShort(char[] cArray, boolean bl) {
        if (cArray.length != 4) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(cArray, bl, false), 16);
    }

    public static int toInt(char[] cArray, boolean bl) {
        if (cArray.length != 8) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(cArray, bl, true), 16);
    }

    public static long toUnsignedInt(char[] cArray, boolean bl) {
        if (cArray.length != 8) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(cArray, bl, false), 16);
    }

    public static long toLongLong(char[] cArray, boolean bl) {
        if (cArray.length != 16) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(cArray, bl, false), 16);
    }

    public static long toUnsignedLongLong(char[] cArray, boolean bl) {
        return 0L;
    }

    private static String bytesToString(char[] cArray, boolean bl, boolean bl2) {
        char[] cArray2 = new char[cArray.length];
        if (bl) {
            int n = 0;
            while (n < cArray.length / 2) {
                cArray2[2 * n] = cArray[cArray.length - 2 * n - 2];
                cArray2[2 * n + 1] = cArray[cArray.length - 2 * n - 1];
                ++n;
            }
        } else {
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
        }
        return new String(cArray2);
    }

    public static String prependString(String string, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer(n);
        if (string.length() > n) {
            stringBuffer.append(string.substring(0, n));
        } else {
            char[] cArray = new char[n - string.length()];
            Arrays.fill(cArray, c);
            stringBuffer.append(cArray);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static boolean isReferencedProject(IProject iProject, IProject iProject2) {
        if (iProject != null && iProject.exists()) {
            List list = CDebugUtils.getReferencedProjects(iProject2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IProject iProject3 = (IProject)iterator.next();
                if (!iProject3.exists() || !iProject3.equals((Object)iProject2)) continue;
                return true;
            }
        }
        return false;
    }

    public static String serializeDocument(Document document) throws IOException, TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString("UTF8");
    }

    public static IResource getFunctionResource(IFunction iFunction) {
        ITranslationUnit iTranslationUnit = iFunction.getTranslationUnit();
        return iTranslationUnit != null ? iTranslationUnit.getResource() : iFunction.getCProject().getProject();
    }

    public static IResource getMethodResource(IMethod iMethod) {
        ITranslationUnit iTranslationUnit = iMethod.getTranslationUnit();
        return iTranslationUnit != null ? iTranslationUnit.getResource() : iMethod.getCProject().getProject();
    }

    public static String getFunctionName(IFunction iFunction) {
        String string = iFunction.getElementName();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.indexOf("::") != -1) {
            String[] stringArray = iFunction.getParameterTypes();
            stringBuffer.append('(');
            if (stringArray.length == 0) {
                stringBuffer.append("void");
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    if (n != stringArray.length - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static String getMethodQualifiedName(IMethod iMethod) {
        return null;
    }

    public static Number getFloatingPointValue(ICValue iCValue) {
        if (iCValue instanceof CFloatingPointValue) {
            try {
                return ((CFloatingPointValue)iCValue).getFloatingPointValue();
            }
            catch (CDIException cDIException) {}
        }
        return null;
    }

    public static boolean isNaN(Number number) {
        if (number instanceof Double) {
            return ((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return ((Float)number).isNaN();
        }
        return false;
    }

    public static boolean isPositiveInfinity(Number number) {
        if (number instanceof Double) {
            return ((Double)number).isInfinite() && number.doubleValue() == Double.POSITIVE_INFINITY;
        }
        if (number instanceof Float) {
            return ((Float)number).isInfinite() && number.floatValue() == Float.POSITIVE_INFINITY;
        }
        return false;
    }

    public static boolean isNegativeInfinity(Number number) {
        if (number instanceof Double) {
            return ((Double)number).isInfinite() && number.doubleValue() == Double.NEGATIVE_INFINITY;
        }
        if (number instanceof Float) {
            return ((Float)number).isInfinite() && number.floatValue() == Float.NEGATIVE_INFINITY;
        }
        return false;
    }

    public static List getReferencedProjects(IProject iProject) {
        ArrayList<IProject> arrayList = new ArrayList<IProject>(10);
        if (iProject != null && iProject.exists() && iProject.isOpen()) {
            IProject[] iProjectArray = new IProject[]{};
            try {
                iProjectArray = iProject.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int n = 0;
            while (n < iProjectArray.length) {
                if (!iProject.equals((Object)iProjectArray[n]) && iProjectArray[n] != null && iProjectArray[n].exists() && iProjectArray[n].isOpen()) {
                    arrayList.add(iProjectArray[n]);
                    CDebugUtils.getReferencedProjects(iProject, iProjectArray[n], arrayList);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private static void getReferencedProjects(IProject iProject, IProject iProject2, List list) {
        if (iProject2 != null && iProject2.exists() && iProject2.isOpen()) {
            IProject[] iProjectArray = new IProject[]{};
            try {
                iProjectArray = iProject2.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int n = 0;
            while (n < iProjectArray.length) {
                if (!list.contains(iProjectArray[n]) && iProjectArray[n] != null && !iProjectArray[n].equals((Object)iProject) && iProjectArray[n].exists() && iProjectArray[n].isOpen()) {
                    list.add(iProjectArray[n]);
                    CDebugUtils.getReferencedProjects(iProject, iProjectArray[n], list);
                }
                ++n;
            }
        }
    }
}

