/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CBreakpointNotifier;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.ISourceLocator;

public class CBreakpointManager
implements IBreakpointManagerListener,
ICDIEventListener,
IAdaptable {
    private CDebugTarget fDebugTarget;
    private BreakpointMap fMap;
    private boolean fSkipBreakpoint = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CBreakpointManager(CDebugTarget cDebugTarget) {
        this.setDebugTarget(cDebugTarget);
        this.fMap = new BreakpointMap();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.getDebugTarget().getCDISession().getEventManager().addEventListener(this);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.internal.core.CBreakpointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(clazz)) {
            return this.getDebugTarget();
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(clazz)) {
            return this.getDebugTarget();
        }
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.equals(clazz)) {
            return this.getDebugTarget();
        }
        return null;
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDebugTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
    }

    protected ICDIBreakpointManager getCDIBreakpointManager() {
        return this.getDebugTarget().getCDISession().getBreakpointManager();
    }

    protected ICSourceLocator getCSourceLocator() {
        ISourceLocator iSourceLocator = this.getDebugTarget().getLaunch().getSourceLocator();
        if (iSourceLocator instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public void dispose() {
        this.getDebugTarget().getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.removeAllBreakpoints();
        this.getBreakpointMap().dispose();
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
        int n = 0;
        while (n < iCDIEventArray.length) {
            ICDIEvent iCDIEvent = iCDIEventArray[n];
            ICDIObject iCDIObject = iCDIEvent.getSource();
            if (iCDIObject != null && iCDIObject.getTarget().equals(this.getDebugTarget().getCDITarget())) {
                if (iCDIEvent instanceof ICDICreatedEvent) {
                    if (iCDIObject instanceof ICDIBreakpoint) {
                        this.handleBreakpointCreatedEvent((ICDIBreakpoint)iCDIObject);
                    }
                } else if (iCDIEvent instanceof ICDIDestroyedEvent) {
                    if (iCDIObject instanceof ICDIBreakpoint) {
                        this.handleBreakpointDestroyedEvent((ICDIBreakpoint)iCDIObject);
                    }
                } else if (iCDIEvent instanceof ICDIChangedEvent && iCDIObject instanceof ICDIBreakpoint) {
                    this.handleBreakpointChangedEvent((ICDIBreakpoint)iCDIObject);
                }
            }
            ++n;
        }
    }

    public boolean isTargetBreakpoint(ICBreakpoint iCBreakpoint) {
        IResource iResource = iCBreakpoint.getMarker().getResource();
        if (iCBreakpoint instanceof ICAddressBreakpoint) {
            return this.supportsAddressBreakpoint((ICAddressBreakpoint)iCBreakpoint);
        }
        if (iCBreakpoint instanceof ICLineBreakpoint) {
            ICSourceLocator iCSourceLocator = this.getSourceLocator();
            if (iCSourceLocator != null) {
                return iCSourceLocator.contains(iResource);
            }
        } else {
            IProject iProject = iResource.getProject();
            if (iProject != null && iProject.exists()) {
                ICSourceLocator iCSourceLocator = this.getSourceLocator();
                if (iCSourceLocator != null) {
                    return iCSourceLocator.contains((IResource)iProject);
                }
                if (iProject.equals((Object)this.getExecFile().getProject())) {
                    return true;
                }
                return CDebugUtils.isReferencedProject(this.getExecFile().getProject(), iProject);
            }
        }
        return true;
    }

    public boolean isCDIRegistered(ICBreakpoint iCBreakpoint) {
        return this.getBreakpointMap().getCDIBreakpoint(iCBreakpoint) != null;
    }

    public boolean supportsAddressBreakpoint(ICAddressBreakpoint iCAddressBreakpoint) {
        try {
            return this.getExecFile() != null && this.getExecFile().getLocation().toOSString().equals(iCAddressBreakpoint.getSourceHandle());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IFile getCDIBreakpointFile(ICDIBreakpoint iCDIBreakpoint) {
        IResource iResource;
        ICBreakpoint iCBreakpoint = this.getBreakpointMap().getCBreakpoint(iCDIBreakpoint);
        if (iCBreakpoint instanceof ICLineBreakpoint && !(iCBreakpoint instanceof ICAddressBreakpoint) && (iResource = ((ICLineBreakpoint)iCBreakpoint).getMarker().getResource()) instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public ICBreakpoint getBreakpoint(ICDIBreakpoint iCDIBreakpoint) {
        return this.getBreakpointMap().getCBreakpoint(iCDIBreakpoint);
    }

    public long getBreakpointAddress(ICBreakpoint iCBreakpoint) {
        ICDIBreakpoint iCDIBreakpoint;
        if (iCBreakpoint != null && (iCDIBreakpoint = this.getBreakpointMap().getCDIBreakpoint(iCBreakpoint)) instanceof ICDILocationBreakpoint) {
            try {
                ICDILocation iCDILocation = ((ICDILocationBreakpoint)iCDIBreakpoint).getLocation();
                if (iCDILocation != null) {
                    return iCDILocation.getAddress();
                }
            }
            catch (CDIException cDIException) {}
        }
        return 0L;
    }

    public void setBreakpoint(ICBreakpoint iCBreakpoint) throws DebugException {
        this.doSetBreakpoint(iCBreakpoint);
    }

    protected void doSetBreakpoint(ICBreakpoint iCBreakpoint) throws DebugException {
        try {
            ICDIBreakpoint iCDIBreakpoint = this.getBreakpointMap().getCDIBreakpoint(iCBreakpoint);
            if (iCDIBreakpoint == null) {
                if (iCBreakpoint instanceof ICFunctionBreakpoint) {
                    iCDIBreakpoint = this.setFunctionBreakpoint((ICFunctionBreakpoint)iCBreakpoint);
                } else if (iCBreakpoint instanceof ICAddressBreakpoint) {
                    iCDIBreakpoint = this.setAddressBreakpoint((ICAddressBreakpoint)iCBreakpoint);
                } else if (iCBreakpoint instanceof ICLineBreakpoint) {
                    iCDIBreakpoint = this.setLineBreakpoint((ICLineBreakpoint)iCBreakpoint);
                } else if (iCBreakpoint instanceof ICWatchpoint) {
                    iCDIBreakpoint = this.setWatchpoint((ICWatchpoint)iCBreakpoint);
                }
            }
            if (iCDIBreakpoint == null) {
                return;
            }
            if (!iCBreakpoint.isEnabled()) {
                iCDIBreakpoint.setEnabled(false);
            }
            this.setBreakpointCondition(iCBreakpoint);
        }
        catch (CoreException coreException) {
            this.requestFailed(MessageFormat.format(InternalDebugCoreMessages.getString("CBreakpointManager.0"), coreException.getMessage()), coreException);
        }
        catch (NumberFormatException numberFormatException) {
            this.requestFailed(MessageFormat.format(InternalDebugCoreMessages.getString("CBreakpointManager.1"), numberFormatException.getMessage()), numberFormatException);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(MessageFormat.format(InternalDebugCoreMessages.getString("CBreakpointManager.2"), cDIException.getMessage()), cDIException);
        }
    }

    public void removeBreakpoint(ICBreakpoint iCBreakpoint) throws DebugException {
        this.doRemoveBreakpoint(iCBreakpoint);
    }

    protected void doRemoveBreakpoint(ICBreakpoint iCBreakpoint) throws DebugException {
        ICDIBreakpoint iCDIBreakpoint = this.getBreakpointMap().getCDIBreakpoint(iCBreakpoint);
        if (iCDIBreakpoint != null) {
            ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
            try {
                iCDIBreakpointManager.deleteBreakpoints(new ICDIBreakpoint[]{iCDIBreakpoint});
            }
            catch (CDIException cDIException) {
                this.targetRequestFailed(MessageFormat.format(InternalDebugCoreMessages.getString("CBreakpointManager.3"), cDIException.getMessage()), cDIException);
            }
        }
    }

    public void changeBreakpointProperties(ICBreakpoint iCBreakpoint, IMarkerDelta iMarkerDelta) throws DebugException {
        this.doChangeBreakpointProperties(iCBreakpoint, iMarkerDelta);
    }

    protected void doChangeBreakpointProperties(ICBreakpoint iCBreakpoint, IMarkerDelta iMarkerDelta) throws DebugException {
        ICDIBreakpoint iCDIBreakpoint = this.getBreakpointMap().getCDIBreakpoint(iCBreakpoint);
        if (iCDIBreakpoint == null) {
            return;
        }
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        try {
            boolean bl = iCBreakpoint.isEnabled();
            boolean bl2 = iMarkerDelta.getAttribute("org.eclipse.debug.core.enabled", true);
            int n = iCBreakpoint.getIgnoreCount();
            int n2 = iMarkerDelta.getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
            String string = iCBreakpoint.getCondition();
            String string2 = iMarkerDelta.getAttribute("org.eclipse.cdt.debug.core.condition", "");
            if (bl != bl2) {
                iCDIBreakpoint.setEnabled(bl);
            }
            if (n != n2 || !string.equals(string2)) {
                ICDICondition iCDICondition = iCDIBreakpointManager.createCondition(n, string);
                iCDIBreakpoint.setCondition(iCDICondition);
            }
        }
        catch (CoreException coreException) {
            this.requestFailed(MessageFormat.format(InternalDebugCoreMessages.getString("CBreakpointManager.4"), coreException.getMessage()), coreException);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(MessageFormat.format(InternalDebugCoreMessages.getString("CBreakpointManager.5"), cDIException.getMessage()), cDIException);
        }
    }

    private void handleBreakpointCreatedEvent(ICDIBreakpoint iCDIBreakpoint) {
        if (iCDIBreakpoint instanceof ICDILocationBreakpoint) {
            this.doHandleLocationBreakpointCreatedEvent((ICDILocationBreakpoint)iCDIBreakpoint);
        } else if (iCDIBreakpoint instanceof ICDIWatchpoint) {
            this.doHandleWatchpointCreatedEvent((ICDIWatchpoint)iCDIBreakpoint);
        }
        if (!iCDIBreakpoint.isTemporary() && !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            try {
                iCDIBreakpoint.setEnabled(false);
            }
            catch (CDIException cDIException) {
                DebugPlugin.log((Throwable)cDIException);
            }
        }
    }

    protected void doHandleLocationBreakpointCreatedEvent(ICDILocationBreakpoint iCDILocationBreakpoint) {
        if (iCDILocationBreakpoint.isTemporary()) {
            return;
        }
        ICBreakpoint iCBreakpoint = this.getBreakpointMap().getCBreakpoint(iCDILocationBreakpoint);
        if (iCBreakpoint == null) {
            iCBreakpoint = this.createLocationBreakpoint(iCDILocationBreakpoint);
        }
        if (iCBreakpoint != null) {
            this.getBreakpointNotifier().breakpointInstalled(this.getDebugTarget(), iCBreakpoint);
        }
    }

    protected void doHandleWatchpointCreatedEvent(ICDIWatchpoint iCDIWatchpoint) {
        ICBreakpoint iCBreakpoint = this.getBreakpointMap().getCBreakpoint(iCDIWatchpoint);
        if (iCBreakpoint == null) {
            try {
                iCBreakpoint = this.createWatchpoint(iCDIWatchpoint);
            }
            catch (CDIException cDIException) {
            }
            catch (CoreException coreException) {}
        }
        if (iCBreakpoint != null) {
            this.getBreakpointNotifier().breakpointInstalled(this.getDebugTarget(), iCBreakpoint);
        }
    }

    private void handleBreakpointDestroyedEvent(ICDIBreakpoint iCDIBreakpoint) {
        ICBreakpoint iCBreakpoint = this.getBreakpointMap().getCBreakpoint(iCDIBreakpoint);
        this.getBreakpointMap().removeCDIBreakpoint(iCDIBreakpoint);
        if (iCBreakpoint != null) {
            this.getBreakpointNotifier().breakpointRemoved(this.getDebugTarget(), iCBreakpoint);
        }
    }

    private void handleBreakpointChangedEvent(ICDIBreakpoint iCDIBreakpoint) {
        ICBreakpoint iCBreakpoint = this.getBreakpointMap().getCBreakpoint(iCDIBreakpoint);
        if (iCBreakpoint != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
            try {
                if (!this.fSkipBreakpoint && DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                    hashMap.put("org.eclipse.debug.core.enabled", new Boolean(iCDIBreakpoint.isEnabled()));
                } else {
                    hashMap.put("org.eclipse.debug.core.enabled", new Boolean(iCBreakpoint.isEnabled()));
                }
            }
            catch (CDIException cDIException) {
            }
            catch (CoreException coreException) {}
            try {
                hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(iCDIBreakpoint.getCondition().getIgnoreCount()));
            }
            catch (CDIException cDIException) {}
            try {
                hashMap.put("org.eclipse.cdt.debug.core.condition", iCDIBreakpoint.getCondition().getExpression());
            }
            catch (CDIException cDIException) {}
            this.getBreakpointNotifier().breakpointChanged(this.getDebugTarget(), iCBreakpoint, hashMap);
        }
    }

    private void removeAllBreakpoints() {
        ICDIBreakpoint[] iCDIBreakpointArray = this.getBreakpointMap().getAllCDIBreakpoints();
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        if (iCDIBreakpointArray.length > 0) {
            try {
                iCDIBreakpointManager.deleteBreakpoints(iCDIBreakpointArray);
            }
            catch (CDIException cDIException) {
                CDebugCorePlugin.log(cDIException.getMessage());
            }
            ICBreakpoint[] iCBreakpointArray = this.getBreakpointMap().getAllCBreakpoints();
            int n = 0;
            while (n < iCBreakpointArray.length) {
                try {
                    ((CBreakpoint)iCBreakpointArray[n]).decrementInstallCount();
                }
                catch (CoreException coreException) {
                    CDebugCorePlugin.log(coreException.getMessage());
                }
                ++n;
            }
        }
    }

    private ICDIBreakpoint setFunctionBreakpoint(ICFunctionBreakpoint iCFunctionBreakpoint) throws CDIException, CoreException {
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        String string = iCFunctionBreakpoint.getFunction();
        String string2 = string != null && string.indexOf("::") == -1 ? iCFunctionBreakpoint.getFileName() : null;
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation(string2, string, -1);
        ICDILocationBreakpoint iCDILocationBreakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null, true);
            this.getBreakpointMap().put(iCFunctionBreakpoint, iCDILocationBreakpoint);
        }
        return iCDILocationBreakpoint;
    }

    private ICDIBreakpoint setAddressBreakpoint(ICAddressBreakpoint iCAddressBreakpoint) throws CDIException, CoreException, NumberFormatException {
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation(Long.parseLong(iCAddressBreakpoint.getAddress()));
        ICDILocationBreakpoint iCDILocationBreakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null, true);
            this.getBreakpointMap().put(iCAddressBreakpoint, iCDILocationBreakpoint);
        }
        return iCDILocationBreakpoint;
    }

    private ICDIBreakpoint setLineBreakpoint(ICLineBreakpoint iCLineBreakpoint) throws CDIException, CoreException {
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation(iCLineBreakpoint.getMarker().getResource().getLocation().lastSegment(), null, iCLineBreakpoint.getLineNumber());
        ICDILocationBreakpoint iCDILocationBreakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null, true);
            this.getBreakpointMap().put(iCLineBreakpoint, iCDILocationBreakpoint);
        }
        return iCDILocationBreakpoint;
    }

    private ICDIBreakpoint setWatchpoint(ICWatchpoint iCWatchpoint) throws CDIException, CoreException {
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        int n = 0;
        n |= iCWatchpoint.isWriteType() ? 1 : 0;
        n |= iCWatchpoint.isReadType() ? 2 : 0;
        String string = iCWatchpoint.getExpression();
        ICDIWatchpoint iCDIWatchpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            iCDIWatchpoint = iCDIBreakpointManager.setWatchpoint(0, n, string, null);
            this.getBreakpointMap().put(iCWatchpoint, iCDIWatchpoint);
        }
        return iCDIWatchpoint;
    }

    private void setBreakpointCondition(ICBreakpoint iCBreakpoint) throws CoreException, CDIException {
        ICDIBreakpoint iCDIBreakpoint = this.getBreakpointMap().getCDIBreakpoint(iCBreakpoint);
        ICDIBreakpointManager iCDIBreakpointManager = this.getCDIBreakpointManager();
        ICDICondition iCDICondition = iCDIBreakpointManager.createCondition(iCBreakpoint.getIgnoreCount(), iCBreakpoint.getCondition());
        iCDIBreakpoint.setCondition(iCDICondition);
    }

    private BreakpointMap getBreakpointMap() {
        return this.fMap;
    }

    protected void targetRequestFailed(String string, Throwable throwable) throws DebugException {
        this.requestFailed0(string, throwable, 5010);
    }

    protected void requestFailed(String string, Throwable throwable) throws DebugException {
        this.requestFailed0(string, throwable, 5012);
    }

    private void requestFailed0(String string, Throwable throwable, int n) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), n, string, throwable));
    }

    private ICLineBreakpoint createLocationBreakpoint(ICDILocationBreakpoint iCDILocationBreakpoint) {
        ICLineBreakpoint iCLineBreakpoint = null;
        try {
            if (!this.isEmpty(iCDILocationBreakpoint.getLocation().getFile())) {
                ICSourceLocator iCSourceLocator = this.getSourceLocator();
                if (iCSourceLocator != null) {
                    Object object = iCSourceLocator.findSourceElement(iCDILocationBreakpoint.getLocation().getFile());
                    if (object != null && object instanceof IFile) {
                        iCLineBreakpoint = this.createLineBreakpoint((IFile)object, iCDILocationBreakpoint);
                    } else if (!this.isEmpty(iCDILocationBreakpoint.getLocation().getFunction())) {
                        iCLineBreakpoint = this.createFunctionBreakpoint(iCDILocationBreakpoint);
                    } else if (iCDILocationBreakpoint.getLocation().getAddress() > 0L) {
                        iCLineBreakpoint = this.createAddressBreakpoint(iCDILocationBreakpoint);
                    }
                }
            } else if (!this.isEmpty(iCDILocationBreakpoint.getLocation().getFunction())) {
                iCLineBreakpoint = this.createFunctionBreakpoint(iCDILocationBreakpoint);
            } else if (iCDILocationBreakpoint.getLocation().getAddress() > 0L) {
                iCLineBreakpoint = this.createAddressBreakpoint(iCDILocationBreakpoint);
            }
        }
        catch (CDIException cDIException) {
        }
        catch (CoreException coreException) {}
        return iCLineBreakpoint;
    }

    private ICLineBreakpoint createLineBreakpoint(IFile iFile, ICDILocationBreakpoint iCDILocationBreakpoint) throws CDIException, CoreException {
        ICLineBreakpoint iCLineBreakpoint = CDIDebugModel.createLineBreakpoint(iCDILocationBreakpoint.getLocation().getFile(), (IResource)iFile, iCDILocationBreakpoint.getLocation().getLineNumber(), iCDILocationBreakpoint.isEnabled(), iCDILocationBreakpoint.getCondition().getIgnoreCount(), iCDILocationBreakpoint.getCondition().getExpression(), false);
        this.getBreakpointMap().put(iCLineBreakpoint, iCDILocationBreakpoint);
        ((CBreakpoint)((Object)iCLineBreakpoint)).register(true);
        return iCLineBreakpoint;
    }

    private ICFunctionBreakpoint createFunctionBreakpoint(ICDILocationBreakpoint iCDILocationBreakpoint) throws CDIException, CoreException {
        IFile iFile = this.getExecFile();
        String string = iFile.getFullPath().toOSString();
        ICFunctionBreakpoint iCFunctionBreakpoint = CDIDebugModel.createFunctionBreakpoint(string, (IResource)iFile, iCDILocationBreakpoint.getLocation().getFunction(), -1, -1, -1, iCDILocationBreakpoint.isEnabled(), iCDILocationBreakpoint.getCondition().getIgnoreCount(), iCDILocationBreakpoint.getCondition().getExpression(), false);
        this.getBreakpointMap().put(iCFunctionBreakpoint, iCDILocationBreakpoint);
        ((CBreakpoint)((Object)iCFunctionBreakpoint)).register(true);
        return iCFunctionBreakpoint;
    }

    private ICAddressBreakpoint createAddressBreakpoint(ICDILocationBreakpoint iCDILocationBreakpoint) throws CDIException, CoreException {
        IFile iFile = this.getExecFile();
        String string = iFile.getFullPath().toOSString();
        ICAddressBreakpoint iCAddressBreakpoint = CDIDebugModel.createAddressBreakpoint(string, (IResource)iFile, iCDILocationBreakpoint.getLocation().getAddress(), iCDILocationBreakpoint.isEnabled(), iCDILocationBreakpoint.getCondition().getIgnoreCount(), iCDILocationBreakpoint.getCondition().getExpression(), false);
        this.getBreakpointMap().put(iCAddressBreakpoint, iCDILocationBreakpoint);
        ((CBreakpoint)((Object)iCAddressBreakpoint)).register(true);
        return iCAddressBreakpoint;
    }

    private ICWatchpoint createWatchpoint(ICDIWatchpoint iCDIWatchpoint) throws CDIException, CoreException {
        IFile iFile = this.getExecFile();
        String string = iFile.getFullPath().toOSString();
        ICWatchpoint iCWatchpoint = CDIDebugModel.createWatchpoint(string, (IResource)iFile.getProject(), iCDIWatchpoint.isWriteType(), iCDIWatchpoint.isReadType(), iCDIWatchpoint.getWatchExpression(), iCDIWatchpoint.isEnabled(), iCDIWatchpoint.getCondition().getIgnoreCount(), iCDIWatchpoint.getCondition().getExpression(), false);
        this.getBreakpointMap().put(iCWatchpoint, iCDIWatchpoint);
        ((CBreakpoint)((Object)iCWatchpoint)).register(true);
        return iCWatchpoint;
    }

    private ICSourceLocator getSourceLocator() {
        ICSourceLocator iCSourceLocator;
        ISourceLocator iSourceLocator = this.getDebugTarget().getLaunch().getSourceLocator();
        if (iSourceLocator instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        } else {
            iCSourceLocator = null;
        }
        return iCSourceLocator;
    }

    private IFile getExecFile() {
        return this.getDebugTarget().getExecFile();
    }

    private CBreakpointNotifier getBreakpointNotifier() {
        return CBreakpointNotifier.getInstance();
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() <= 0;
    }

    public void breakpointManagerEnablementChanged(boolean bl) {
        this.doSkipBreakpoints(!bl);
    }

    public void skipBreakpoints(boolean bl) {
        if (this.fSkipBreakpoint != bl && (DebugPlugin.getDefault().getBreakpointManager().isEnabled() || !bl)) {
            this.fSkipBreakpoint = bl;
            this.doSkipBreakpoints(bl);
        }
    }

    private void doSkipBreakpoints(boolean bl) {
        ICBreakpoint[] iCBreakpointArray = this.getBreakpointMap().getAllCBreakpoints();
        int n = 0;
        while (n < iCBreakpointArray.length) {
            try {
                ICDIBreakpoint iCDIBreakpoint;
                if (iCBreakpointArray[n].isEnabled() && (iCDIBreakpoint = this.getBreakpointMap().getCDIBreakpoint(iCBreakpointArray[n])) != null) {
                    iCDIBreakpoint.setEnabled(!bl);
                }
            }
            catch (CoreException coreException) {
                DebugPlugin.log((IStatus)coreException.getStatus());
            }
            catch (CDIException cDIException) {
                DebugPlugin.log((Throwable)cDIException);
            }
            ++n;
        }
    }

    private class BreakpointMap {
        private HashMap fCBreakpoints = new HashMap(10);
        private HashMap fCDIBreakpoints = new HashMap(10);

        protected BreakpointMap() {
        }

        protected synchronized void put(ICBreakpoint iCBreakpoint, ICDIBreakpoint iCDIBreakpoint) {
            this.fCBreakpoints.put(iCBreakpoint, iCDIBreakpoint);
            this.fCDIBreakpoints.put(iCDIBreakpoint, iCBreakpoint);
        }

        protected synchronized ICDIBreakpoint getCDIBreakpoint(ICBreakpoint iCBreakpoint) {
            return (ICDIBreakpoint)this.fCBreakpoints.get(iCBreakpoint);
        }

        protected synchronized ICBreakpoint getCBreakpoint(ICDIBreakpoint iCDIBreakpoint) {
            return (ICBreakpoint)this.fCDIBreakpoints.get(iCDIBreakpoint);
        }

        protected synchronized void removeCBreakpoint(ICBreakpoint iCBreakpoint) {
            ICDIBreakpoint iCDIBreakpoint;
            if (iCBreakpoint != null && (iCDIBreakpoint = (ICDIBreakpoint)this.fCBreakpoints.remove(iCBreakpoint)) != null) {
                this.fCDIBreakpoints.remove(iCDIBreakpoint);
            }
        }

        protected synchronized void removeCDIBreakpoint(ICDIBreakpoint iCDIBreakpoint) {
            ICBreakpoint iCBreakpoint;
            if (iCDIBreakpoint != null && (iCBreakpoint = (ICBreakpoint)this.fCDIBreakpoints.remove(iCDIBreakpoint)) != null) {
                this.fCBreakpoints.remove(iCBreakpoint);
            }
        }

        protected ICBreakpoint[] getAllCBreakpoints() {
            Set set = this.fCBreakpoints.keySet();
            return set.toArray(new ICBreakpoint[set.size()]);
        }

        protected ICDIBreakpoint[] getAllCDIBreakpoints() {
            Set set = this.fCDIBreakpoints.keySet();
            return set.toArray(new ICDIBreakpoint[set.size()]);
        }

        protected void dispose() {
            this.fCBreakpoints.clear();
            this.fCDIBreakpoints.clear();
        }
    }
}

