/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CExpressionTarget {
    private CDebugTarget fDebugTarget;
    private Map fExpressions = null;

    public CExpressionTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
        this.fExpressions = new HashMap(10);
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public IValue evaluateExpression(String string) throws DebugException {
        CExpression cExpression = (CExpression)this.fExpressions.remove(string);
        if (cExpression != null) {
            cExpression.dispose();
        }
        cExpression = (CExpression)CDIDebugModel.createExpression(this.getDebugTarget(), string);
        this.fExpressions.put(string, cExpression);
        return cExpression.getValue();
    }

    public void dispose() {
        Iterator iterator = this.fExpressions.values().iterator();
        while (iterator.hasNext()) {
            ((CExpression)iterator.next()).dispose();
        }
        this.fExpressions.clear();
    }
}

