/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;

public class CGlobalVariableManager
implements ICGlobalVariableManager {
    private CDebugTarget fDebugTarget;
    private ArrayList fGlobals = new ArrayList(10);

    public CGlobalVariableManager(CDebugTarget cDebugTarget) {
        this.setDebugTarget(cDebugTarget);
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDebugTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
    }

    public ICGlobalVariable[] getGlobals() {
        return this.fGlobals.toArray(new ICGlobalVariable[this.fGlobals.size()]);
    }

    public void addGlobals(IGlobalVariableDescriptor[] iGlobalVariableDescriptorArray) throws DebugException {
        MultiStatus multiStatus = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 0, "", null);
        ArrayList<ICGlobalVariable> arrayList = new ArrayList<ICGlobalVariable>(iGlobalVariableDescriptorArray.length);
        int n = 0;
        while (n < iGlobalVariableDescriptorArray.length) {
            try {
                arrayList.add(CDIDebugModel.createGlobalVariable(this.getDebugTarget(), iGlobalVariableDescriptorArray[n]));
            }
            catch (DebugException debugException) {
                multiStatus.add(debugException.getStatus());
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            ArrayList arrayList2 = this.fGlobals;
            synchronized (arrayList2) {
                this.fGlobals.addAll(arrayList);
            }
            this.getDebugTarget().fireChangeEvent(512);
        }
        if (!multiStatus.isOK()) {
            throw new DebugException((IStatus)multiStatus);
        }
    }

    public void removeGlobals(ICGlobalVariable[] iCGlobalVariableArray) {
        ArrayList arrayList = this.fGlobals;
        synchronized (arrayList) {
            this.fGlobals.removeAll(Arrays.asList(iCGlobalVariableArray));
        }
        int n = 0;
        while (n < iCGlobalVariableArray.length) {
            iCGlobalVariableArray[n].dispose();
            ++n;
        }
        this.getDebugTarget().fireChangeEvent(512);
    }

    public void removeAllGlobals() {
        ICGlobalVariable[] iCGlobalVariableArray = new ICGlobalVariable[]{};
        ArrayList arrayList = this.fGlobals;
        synchronized (arrayList) {
            iCGlobalVariableArray = this.fGlobals.toArray(new ICGlobalVariable[this.fGlobals.size()]);
            this.fGlobals.clear();
        }
        int n = 0;
        while (n < iCGlobalVariableArray.length) {
            ((CVariable)((Object)iCGlobalVariableArray[n])).dispose();
            ++n;
        }
        this.getDebugTarget().fireChangeEvent(512);
    }

    public void dispose() {
        Iterator iterator = this.fGlobals.iterator();
        while (iterator.hasNext()) {
            ((ICGlobalVariable)iterator.next()).dispose();
        }
        this.fGlobals.clear();
    }

    public IGlobalVariableDescriptor[] getDescriptors() {
        return null;
    }
}

