/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSharedLibrary;
import org.eclipse.debug.core.DebugException;

public class CSharedLibraryManager
extends CUpdateManager
implements ICSharedLibraryManager {
    private ArrayList fSharedLibraries = new ArrayList(5);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSharedLibraryManager(CDebugTarget cDebugTarget) {
        super(cDebugTarget);
        boolean bl = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH);
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(bl);
        }
    }

    public void sharedLibraryLoaded(ICDISharedLibrary iCDISharedLibrary) {
        CSharedLibrary cSharedLibrary = new CSharedLibrary(this.getDebugTarget(), iCDISharedLibrary);
        ArrayList arrayList = this.fSharedLibraries;
        synchronized (arrayList) {
            this.fSharedLibraries.add(cSharedLibrary);
        }
        cSharedLibrary.fireCreationEvent();
        if (cSharedLibrary.areSymbolsLoaded()) {
            this.setBreakpoints();
        }
    }

    public synchronized void sharedLibraryUnloaded(ICDISharedLibrary iCDISharedLibrary) {
        CSharedLibrary cSharedLibrary = this.find(iCDISharedLibrary);
        if (cSharedLibrary != null) {
            ArrayList arrayList = this.fSharedLibraries;
            synchronized (arrayList) {
                this.fSharedLibraries.remove(cSharedLibrary);
            }
            cSharedLibrary.dispose();
            cSharedLibrary.fireTerminateEvent();
        }
    }

    public void symbolsLoaded(ICDISharedLibrary iCDISharedLibrary) {
        CSharedLibrary cSharedLibrary = this.find(iCDISharedLibrary);
        if (cSharedLibrary != null) {
            cSharedLibrary.fireChangeEvent(256);
            this.setBreakpoints();
        }
    }

    public ICSharedLibrary[] getSharedLibraries() {
        return this.fSharedLibraries.toArray(new ICSharedLibrary[this.fSharedLibraries.size()]);
    }

    public void dispose() {
        Iterator iterator = this.fSharedLibraries.iterator();
        while (iterator.hasNext()) {
            ((CSharedLibrary)iterator.next()).dispose();
        }
        this.fSharedLibraries.clear();
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    protected CSharedLibrary find(ICDISharedLibrary iCDISharedLibrary) {
        Iterator iterator = this.fSharedLibraries.iterator();
        while (iterator.hasNext()) {
            CSharedLibrary cSharedLibrary = (CSharedLibrary)iterator.next();
            if (!cSharedLibrary.getCDISharedLibrary().equals(iCDISharedLibrary)) continue;
            return cSharedLibrary;
        }
        return null;
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getSharedLibraryManager();
        }
        return null;
    }

    public void loadSymbols(ICSharedLibrary[] iCSharedLibraryArray) throws DebugException {
        ICDISharedLibraryManager iCDISharedLibraryManager = (ICDISharedLibraryManager)this.getCDIManager();
        if (iCDISharedLibraryManager != null) {
            ArrayList<ICDISharedLibrary> arrayList = new ArrayList<ICDISharedLibrary>(iCSharedLibraryArray.length);
            int n = 0;
            while (n < iCSharedLibraryArray.length) {
                arrayList.add(((CSharedLibrary)iCSharedLibraryArray[n]).getCDISharedLibrary());
                ++n;
            }
            try {
                iCDISharedLibraryManager.loadSymbols(arrayList.toArray(new ICDISharedLibrary[arrayList.size()]));
            }
            catch (CDIException cDIException) {
                this.getDebugTarget().targetRequestFailed(cDIException.getMessage(), null);
            }
        }
    }

    public void loadSymbolsForAll() throws DebugException {
        ICDISharedLibraryManager iCDISharedLibraryManager = (ICDISharedLibraryManager)this.getCDIManager();
        if (iCDISharedLibraryManager != null) {
            try {
                iCDISharedLibraryManager.loadSymbols();
            }
            catch (CDIException cDIException) {
                this.getDebugTarget().targetRequestFailed(cDIException.getMessage(), null);
            }
        }
    }

    private void setBreakpoints() {
        this.getDebugTarget().setBreakpoints();
    }
}

