/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICSignalManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSignal;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class CSignalManager
extends CUpdateManager
implements ICSignalManager {
    private ICSignal[] fSignals = null;
    private boolean fIsDisposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSignalManager(CDebugTarget cDebugTarget) {
        super(cDebugTarget);
    }

    public ICSignal[] getSignals() throws DebugException {
        if (!this.isDisposed() && this.fSignals == null) {
            try {
                ICDISignal[] iCDISignalArray = this.getDebugTarget().getCDISession().getSignalManager().getSignals();
                ArrayList<CSignal> arrayList = new ArrayList<CSignal>(iCDISignalArray.length);
                int n = 0;
                while (n < iCDISignalArray.length) {
                    arrayList.add(new CSignal(this.getDebugTarget(), iCDISignalArray[n]));
                    ++n;
                }
                this.fSignals = arrayList.toArray(new ICSignal[arrayList.size()]);
            }
            catch (CDIException cDIException) {
                this.throwDebugException(cDIException.getMessage(), 5010, cDIException);
            }
        }
        return this.fSignals != null ? this.fSignals : new ICSignal[]{};
    }

    public void dispose() {
        if (this.fSignals != null) {
            int n = 0;
            while (n < this.fSignals.length) {
                ((CSignal)this.fSignals[n]).dispose();
                ++n;
            }
        }
        this.fSignals = null;
        this.fIsDisposed = true;
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public void signalChanged(ICDISignal iCDISignal) {
        CSignal cSignal = this.find(iCDISignal);
        if (cSignal != null) {
            cSignal.fireChangeEvent(256);
        }
    }

    private CSignal find(ICDISignal iCDISignal) {
        try {
            ICSignal[] iCSignalArray = this.getSignals();
            int n = 0;
            while (n < iCSignalArray.length) {
                if (iCSignalArray[n].getName().equals(iCDISignal.getName())) {
                    return (CSignal)iCSignalArray[n];
                }
                ++n;
            }
        }
        catch (DebugException debugException) {}
        return null;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getSignalManager();
        }
        return null;
    }

    protected void throwDebugException(String string, int n, Throwable throwable) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), n, string, throwable));
    }
}

