/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CAddressBreakpoint
extends AbstractLineBreakpoint
implements ICAddressBreakpoint {
    private static final String C_ADDRESS_BREAKPOINT = "org.eclipse.cdt.debug.core.cAddressBreakpointMarker";

    public CAddressBreakpoint() {
    }

    public CAddressBreakpoint(IResource iResource, Map map, boolean bl) throws CoreException {
        super(iResource, CAddressBreakpoint.getMarkerType(), map, bl);
    }

    public static String getMarkerType() {
        return C_ADDRESS_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        StringBuffer stringBuffer = new StringBuffer(BreakpointMessages.getString("CAddressBreakpoint.1"));
        String string = this.ensureMarker().getResource().getName();
        if (string != null && string.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        try {
            long l = Long.parseLong(this.getAddress());
            stringBuffer.append(MessageFormat.format(BreakpointMessages.getString("CAddressBreakpoint.2"), CDebugUtils.toHexAddressString(l)));
        }
        catch (NumberFormatException numberFormatException) {}
        stringBuffer.append(this.getConditionText());
        return stringBuffer.toString();
    }
}

