/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class CBreakpoint
extends Breakpoint
implements ICBreakpoint,
IDebugEventSetListener {
    public CBreakpoint() {
    }

    public CBreakpoint(final IResource iResource, final String string, final Map map, final boolean bl) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                CBreakpoint.this.setMarker(iResource.createMarker(string));
                CBreakpoint.this.ensureMarker().setAttributes(map);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(bl);
            }
        };
        this.run(iWorkspaceRunnable);
    }

    public void createMarker(final IResource iResource, final String string, final Map map, final boolean bl) throws DebugException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                CBreakpoint.this.setMarker(iResource.createMarker(string));
                CBreakpoint.this.ensureMarker().setAttributes(map);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(bl);
            }
        };
        this.run(iWorkspaceRunnable);
    }

    public String getModelIdentifier() {
        return CDIDebugModel.getPluginIdentifier();
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.installCount", 0) > 0;
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.condition", "");
    }

    public void setCondition(String string) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.condition", string);
        this.setAttribute("message", this.getMarkerMessage());
    }

    public int getIgnoreCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
    }

    public void setIgnoreCount(int n) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.ignoreCount", n);
        this.setAttribute("message", this.getMarkerMessage());
    }

    public String getThreadId() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.threadId", null);
    }

    public void setThreadId(String string) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.threadId", string);
    }

    public String getSourceHandle() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
    }

    public void setSourceHandle(String string) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.sourceHandle", string);
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
    }

    protected void run(IWorkspaceRunnable iWorkspaceRunnable) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            throw new DebugException(coreException.getStatus());
        }
    }

    public void register(boolean bl) throws CoreException {
        if (bl) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
    }

    protected abstract String getMarkerMessage() throws CoreException;

    public synchronized void resetInstallCount() throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", 0);
    }

    public synchronized int incrementInstallCount() throws CoreException {
        int n = this.getInstallCount();
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", ++n);
        return n;
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
    }

    public synchronized int decrementInstallCount() throws CoreException {
        int n = this.getInstallCount();
        if (n > 0) {
            this.setAttribute("org.eclipse.cdt.debug.core.installCount", --n);
        }
        return n;
    }

    protected IMarker ensureMarker() throws DebugException {
        return super.ensureMarker();
    }

    protected void setAttribute(String string, Object object) throws CoreException {
        super.setAttribute(string, object);
    }

    public boolean isConditional() throws CoreException {
        return this.getCondition() != null && this.getCondition().trim().length() > 0 || this.getIgnoreCount() > 0;
    }

    protected String getConditionText() throws CoreException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getIgnoreCount();
        if (n > 0) {
            stringBuffer.append(MessageFormat.format(BreakpointMessages.getString("CBreakpoint.1"), new Integer(n)));
        }
        if ((string = this.getCondition()) != null && string.length() > 0) {
            stringBuffer.append(MessageFormat.format(BreakpointMessages.getString("CBreakpoint.2"), string));
        }
        return stringBuffer.toString();
    }
}

