/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CWatchpoint
extends CBreakpoint
implements ICWatchpoint {
    private static final String C_WATCHPOINT = "org.eclipse.cdt.debug.core.cWatchpointMarker";

    public CWatchpoint() {
    }

    public CWatchpoint(IResource iResource, Map map, boolean bl) throws CoreException {
        super(iResource, CWatchpoint.getMarkerType(), map, bl);
    }

    public boolean isWriteType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.write", true);
    }

    public boolean isReadType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.read", false);
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.expression", "");
    }

    public static String getMarkerType() {
        return C_WATCHPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isWriteType() && !this.isReadType()) {
            stringBuffer.append(BreakpointMessages.getString("CWatchpoint.1"));
        } else if (!this.isWriteType() && this.isReadType()) {
            stringBuffer.append(BreakpointMessages.getString("CWatchpoint.2"));
        } else if (this.isWriteType() && this.isReadType()) {
            stringBuffer.append(BreakpointMessages.getString("CWatchpoint.3"));
        } else {
            stringBuffer.append(BreakpointMessages.getString("CWatchpoint.4"));
        }
        stringBuffer.append(' ');
        String string2 = this.ensureMarker().getResource().getName();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if ((string = this.getExpression()) != null && string.length() > 0) {
            stringBuffer.append(MessageFormat.format(BreakpointMessages.getString("CWatchpoint.5"), string));
        }
        stringBuffer.append(this.getConditionText());
        return stringBuffer.toString();
    }
}

