/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CArrayPartition;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;

public class CArrayPartitionValue
extends CDebugElement
implements ICValue {
    private ICDIVariable fCDIVariable;
    private CVariable fParent = null;
    private List fVariables = Collections.EMPTY_LIST;
    private int fStart;
    private int fEnd;
    static /* synthetic */ Class class$0;

    public CArrayPartitionValue(CVariable cVariable, ICDIVariable iCDIVariable, int n, int n2) {
        super((CDebugTarget)cVariable.getDebugTarget());
        this.fCDIVariable = iCDIVariable;
        this.fParent = cVariable;
        this.fStart = n;
        this.fEnd = n2;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            this.fVariables = CArrayPartition.splitArray(this, this.getCDIVariable(), this.getStart(), this.getEnd());
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    protected int getStart() {
        return this.fStart;
    }

    protected int getEnd() {
        return this.fEnd;
    }

    public void setChanged(boolean bl) throws DebugException {
        Iterator iterator = this.fVariables.iterator();
        while (iterator.hasNext()) {
            ((CVariable)iterator.next()).setChanged(bl);
        }
    }

    public String evaluateAsExpression() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICExpressionEvaluator iCExpressionEvaluator = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz);
        String string = null;
        if (iCExpressionEvaluator != null && iCExpressionEvaluator.canEvaluate()) {
            try {
                if (this.getParentVariable() != null) {
                    string = iCExpressionEvaluator.evaluateExpressionToString(this.getParentVariable().getQualifiedName());
                }
            }
            catch (DebugException debugException) {
                string = debugException.getMessage();
            }
        }
        return string;
    }

    public CVariable getParentVariable() {
        return this.fParent;
    }

    protected ICDIVariable getCDIVariable() {
        return this.fCDIVariable;
    }

    public void dispose() {
        Iterator iterator = this.fVariables.iterator();
        while (iterator.hasNext()) {
            ((CVariable)iterator.next()).dispose();
        }
    }
}

