/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugElementErrorStatus;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;

public class CDebugElement
extends PlatformObject
implements ICDebugElement,
ICDebugElementErrorStatus {
    private CDebugTarget fDebugTarget;
    private int fSeverity = 0;
    private String fMessage = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CDebugElement(CDebugTarget cDebugTarget) {
        this.setDebugTarget(cDebugTarget);
    }

    public String getModelIdentifier() {
        return CDebugModel.getPluginIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
    }

    public void internalError(Exception exception) {
        this.logError(exception);
    }

    public void internalError(String string) {
        this.logError(string);
    }

    protected void logError(Exception exception) {
        CDebugCorePlugin.log(exception);
    }

    protected void logError(String string) {
        CDebugCorePlugin.log(string);
    }

    protected void fireEvent(DebugEvent debugEvent) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    protected void fireEventSet(DebugEvent[] debugEventArray) {
        DebugPlugin.getDefault().fireDebugEventSet(debugEventArray);
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public DebugEvent createCreateEvent() {
        return new DebugEvent((Object)this, 4);
    }

    public void fireResumeEvent(int n) {
        this.fireEvent(new DebugEvent((Object)this, 1, n));
    }

    public DebugEvent createResumeEvent(int n) {
        return new DebugEvent((Object)this, 1, n);
    }

    public void fireSuspendEvent(int n) {
        this.fireEvent(new DebugEvent((Object)this, 2, n));
    }

    public DebugEvent createSuspendEvent(int n) {
        return new DebugEvent((Object)this, 2, n);
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public DebugEvent createTerminateEvent() {
        return new DebugEvent((Object)this, 8);
    }

    public void fireChangeEvent(int n) {
        this.fireEvent(new DebugEvent((Object)this, 16, n));
    }

    public DebugEvent createChangeEvent(int n) {
        return new DebugEvent((Object)this, 16, n);
    }

    public ICDISession getCDISession() {
        return this.getCDITarget().getSession();
    }

    public ICDITarget getCDITarget() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICDITarget)iDebugTarget.getAdapter((Class)clazz);
    }

    public void requestFailed(String string, Exception exception) throws DebugException {
        this.requestFailed(string, exception, 5012);
    }

    public void targetRequestFailed(String string, CDIException cDIException) throws DebugException {
        this.requestFailed(MessageFormat.format("Target request failed: {0}.", string), cDIException, 5010);
    }

    public void requestFailed(String string, Throwable throwable, int n) throws DebugException {
        this.throwDebugException(string, n, throwable);
    }

    public void targetRequestFailed(String string, Throwable throwable) throws DebugException {
        this.throwDebugException(MessageFormat.format("Target request failed: {0}.", string), 5010, throwable);
    }

    public void notSupported(String string) throws DebugException {
        this.throwDebugException(string, 5011, null);
    }

    protected void throwDebugException(String string, int n, Throwable throwable) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), n, string, throwable));
    }

    protected void infoMessage(Throwable throwable) {
        Status status = new Status(1, CDebugCorePlugin.getUniqueIdentifier(), 10001, throwable.getMessage(), null);
        CDebugUtils.info((IStatus)status, this.getDebugTarget());
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.getCDISession();
        }
        return super.getAdapter(clazz);
    }

    protected void setStatus(int n, String string) {
        this.fSeverity = n;
        this.fMessage = string;
        if (this.fMessage != null) {
            this.fMessage.trim();
        }
    }

    protected void resetStatus() {
        this.fSeverity = 0;
        this.fMessage = null;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public CDebugElementState getState() {
        return null;
    }

    public IStatus getStatus() {
        return null;
    }

    public String getSubModelIdentifier() {
        return null;
    }
}

