/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;

public class CExpression
extends CModificationVariable
implements IExpression {
    public CExpression(CDebugTarget cDebugTarget, ICDIExpression iCDIExpression) {
        super(cDebugTarget, iCDIExpression);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public CExpression(CDebugTarget cDebugTarget, ICDIVariableObject iCDIVariableObject) {
        super(cDebugTarget, iCDIVariableObject);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public String getExpressionText() {
        try {
            return this.getName();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public IValue getValue() {
        try {
            return super.getValue();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public void dispose() {
        super.dispose();
        try {
            ICDIExpression iCDIExpression = this.getCDIExpression();
            if (iCDIExpression != null) {
                this.getCDISession().getExpressionManager().destroyExpression(iCDIExpression);
            }
        }
        catch (CDIException cDIException) {
            DebugPlugin.log((Throwable)cDIException);
        }
    }

    protected ICDIExpression getCDIExpression() throws CDIException {
        ICDIVariable iCDIVariable = this.getCDIVariable();
        return iCDIVariable instanceof ICDIExpression ? (ICDIExpression)iCDIVariable : null;
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
        int n = 0;
        while (n < iCDIEventArray.length) {
            ICDIEvent iCDIEvent = iCDIEventArray[n];
            if (iCDIEvent instanceof ICDIResumedEvent) {
                if (!(iCDIEvent.getSource() instanceof ICDITarget) || !this.getCDITarget().equals(iCDIEvent.getSource())) break;
                try {
                    this.setChanged(false);
                }
                catch (DebugException debugException) {
                    CDebugCorePlugin.log(debugException);
                }
                break;
            }
            ++n;
        }
        super.handleDebugEvents(iCDIEventArray);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean canEnableDisable() {
        return false;
    }
}

