/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIMemoryChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlockRow;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class CFormattedMemoryBlock
extends CDebugElement
implements IFormattedMemoryBlock,
ICDIEventListener {
    private ICDIExpression fAddressExpression;
    private ICDIMemoryBlock fCDIMemoryBlock;
    private byte[] fBytes = null;
    private int fFormat;
    private int fWordSize;
    private int fNumberOfRows;
    private int fNumberOfColumns;
    private boolean fDisplayAscii = true;
    private char fPaddingChar = (char)46;
    private List fRows = null;
    private Long[] fChangedAddresses = new Long[0];
    private boolean fStartAddressChanged = false;
    static /* synthetic */ Class class$0;

    public CFormattedMemoryBlock(CDebugTarget cDebugTarget, ICDIMemoryBlock iCDIMemoryBlock, ICDIExpression iCDIExpression, int n, int n2, int n3, int n4) {
        this(cDebugTarget, iCDIMemoryBlock, iCDIExpression, n, n2, n3, n4, '\u0000');
    }

    public CFormattedMemoryBlock(CDebugTarget cDebugTarget, ICDIMemoryBlock iCDIMemoryBlock, ICDIExpression iCDIExpression, int n, int n2, int n3, int n4, char c) {
        super(cDebugTarget);
        this.fCDIMemoryBlock = iCDIMemoryBlock;
        this.fAddressExpression = iCDIExpression;
        this.fFormat = n;
        this.fWordSize = n2;
        this.fNumberOfRows = n3;
        this.fNumberOfColumns = n4;
        this.fDisplayAscii = true;
        this.fPaddingChar = c;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public boolean displayASCII() {
        return this.getWordSize() == 1 && this.fDisplayAscii;
    }

    public IFormattedMemoryBlockRow[] getRows() {
        if (this.fRows == null) {
            this.fRows = new ArrayList();
            try {
                int n = 0;
                byte[] byArray = this.getBytes();
                while (byArray != null && n < byArray.length) {
                    int n2 = Math.min(this.fWordSize * this.fNumberOfColumns, byArray.length - n);
                    this.fRows.add(new CFormattedMemoryBlockRow(this.getRowAddress(n), this.createData(byArray, n, n2), this.createAscii(byArray, n, n2)));
                    n += n2;
                }
            }
            catch (DebugException debugException) {}
        }
        return this.fRows.toArray(new IFormattedMemoryBlockRow[this.fRows.size()]);
    }

    private synchronized void resetBytes() {
        this.fBytes = null;
    }

    private void resetRows() {
        this.fRows = null;
    }

    public long nextRowAddress() {
        return 0L;
    }

    public long previousRowAddress() {
        return 0L;
    }

    public long nextPageAddress() {
        return 0L;
    }

    public long previousPageAddress() {
        return 0L;
    }

    public void reformat(int n, int n2, int n3, int n4) throws DebugException {
        this.resetRows();
        this.fFormat = n;
        this.fWordSize = n2;
        this.fNumberOfRows = n3;
        this.fNumberOfColumns = n4;
    }

    public void reformat(int n, int n2, int n3, int n4, char c) throws DebugException {
        this.resetRows();
        this.fFormat = n;
        this.fWordSize = n2;
        this.fNumberOfRows = n3;
        this.fNumberOfColumns = n4;
        this.fPaddingChar = c;
    }

    public long getStartAddress() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getStartAddress();
        }
        return 0L;
    }

    public long getLength() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getLength();
        }
        return 0L;
    }

    public synchronized byte[] getBytes() throws DebugException {
        if (this.fBytes == null && this.fCDIMemoryBlock != null) {
            try {
                this.fBytes = this.fCDIMemoryBlock.getBytes();
            }
            catch (CDIException cDIException) {
                this.targetRequestFailed(cDIException.getMessage(), null);
            }
        }
        byte[] byArray = null;
        if (this.fBytes != null) {
            byArray = new byte[this.fBytes.length];
            System.arraycopy(this.fBytes, 0, byArray, 0, this.fBytes.length);
        }
        return byArray;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(long l, byte[] byArray) throws DebugException {
    }

    public char getPaddingCharacter() {
        return this.fPaddingChar;
    }

    public void dispose() {
        if (this.fCDIMemoryBlock != null) {
            try {
                ((CDebugTarget)this.getDebugTarget()).getCDISession().getMemoryManager().removeBlock(this.fCDIMemoryBlock);
            }
            catch (CDIException cDIException) {
                CDebugCorePlugin.log(cDIException);
            }
            this.fCDIMemoryBlock = null;
        }
        if (this.fAddressExpression != null) {
            try {
                ((CDebugTarget)this.getDebugTarget()).getCDISession().getExpressionManager().destroyExpression(this.fAddressExpression);
            }
            catch (CDIException cDIException) {
                CDebugCorePlugin.log(cDIException);
            }
            this.fAddressExpression = null;
        }
        this.getCDISession().getEventManager().removeEventListener(this);
        this.fireTerminateEvent();
    }

    public String getAddressExpression() {
        return this.fAddressExpression.getName();
    }

    private String[] createData(byte[] byArray, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(n2 / this.getWordSize());
        int n3 = n;
        while (n3 < n + n2) {
            arrayList.add(this.createDataItem(byArray, n3, Math.min(n2 + n - n3, this.getWordSize())));
            n3 += this.getWordSize();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String createDataItem(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n;
        while (n3 < n2 + n) {
            stringBuffer.append(CDebugUtils.getByteText(byArray[n3]));
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String createAscii(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(Character.isISOControl((char)byArray[n3]) || byArray[n3] < 0 ? this.getPaddingCharacter() : (char)byArray[n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
        int n = 0;
        while (n < iCDIEventArray.length) {
            ICDIEvent iCDIEvent = iCDIEventArray[n];
            ICDIObject iCDIObject = iCDIEvent.getSource();
            if (iCDIObject != null && iCDIObject.getTarget().equals(this.getCDITarget())) {
                if (iCDIEvent instanceof ICDIResumedEvent) {
                    if (iCDIObject instanceof ICDITarget) {
                        this.handleResumedEvent((ICDIResumedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIMemoryChangedEvent) {
                    if (iCDIObject instanceof ICDIMemoryBlock && iCDIObject.equals(this.getCDIMemoryBlock())) {
                        this.handleChangedEvent((ICDIMemoryChangedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIChangedEvent) {
                    if (iCDIObject instanceof ICDIExpression && iCDIObject.equals(this.fAddressExpression)) {
                        this.handleAddressChangedEvent((ICDIChangedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIDestroyedEvent && iCDIObject instanceof ICDIExpression && iCDIObject.equals(this.fAddressExpression)) {
                    this.handleDestroyedEvent((ICDIDestroyedEvent)iCDIEvent);
                }
            }
            ++n;
        }
    }

    protected ICDIMemoryBlock getCDIMemoryBlock() {
        return this.fCDIMemoryBlock;
    }

    protected void setCDIMemoryBlock(ICDIMemoryBlock iCDIMemoryBlock) {
        this.fCDIMemoryBlock = iCDIMemoryBlock;
    }

    private void handleResumedEvent(ICDIResumedEvent iCDIResumedEvent) {
        this.resetChangedAddresses();
        this.fStartAddressChanged = false;
        this.fireChangeEvent(512);
    }

    private void handleChangedEvent(ICDIMemoryChangedEvent iCDIMemoryChangedEvent) {
        this.resetBytes();
        this.resetRows();
        this.setChangedAddresses(iCDIMemoryChangedEvent.getAddresses());
        this.fireChangeEvent(512);
    }

    private void handleAddressChangedEvent(ICDIChangedEvent iCDIChangedEvent) {
        this.resetBytes();
        this.resetRows();
        this.fStartAddressChanged = true;
        this.fireChangeEvent(512);
    }

    private void handleDestroyedEvent(ICDIDestroyedEvent iCDIDestroyedEvent) {
        this.fireTerminateEvent();
    }

    public Long[] getChangedAddresses() {
        return this.fChangedAddresses;
    }

    protected void setChangedAddresses(Long[] longArray) {
        this.fChangedAddresses = longArray;
    }

    protected void resetChangedAddresses() {
        this.fChangedAddresses = new Long[0];
    }

    public boolean isFrozen() {
        return this.getCDIMemoryBlock().isFrozen();
    }

    public void setFrozen(boolean bl) {
        this.getCDIMemoryBlock().setFrozen(bl);
    }

    public void setItemValue(int n, String string) throws DebugException {
        byte[] byArray = this.itemToBytes(string.toCharArray());
        this.setBytes(n * this.getWordSize(), byArray);
        this.resetRows();
    }

    private void setBytes(int n, byte[] byArray) throws DebugException {
        try {
            this.getCDIMemoryBlock().setValue(n, byArray);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
    }

    private byte[] itemToBytes(char[] cArray) {
        switch (this.getFormat()) {
            case 0: {
                return this.hexItemToBytes(cArray);
            }
        }
        return new byte[0];
    }

    private byte[] hexItemToBytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length / 2];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = CDebugUtils.textToByte(new char[]{cArray[2 * n], cArray[2 * n + 1]});
            ++n;
        }
        return byArray;
    }

    public void refresh() throws DebugException {
        if (this.getCDIMemoryBlock() != null) {
            try {
                this.getCDIMemoryBlock().refresh();
            }
            catch (CDIException cDIException) {
                this.targetRequestFailed(cDIException.getMessage(), null);
            }
        }
    }

    public boolean canChangeFormat(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 3: {
                return this.getWordSize() != 8;
            }
            case 4: {
                return this.getWordSize() != 8;
            }
        }
        return false;
    }

    public boolean isLittleEndian() {
        IExecFileInfo iExecFileInfo;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iExecFileInfo = (IExecFileInfo)iDebugTarget.getAdapter((Class)clazz)) != null) {
            return iExecFileInfo.isLittleEndian();
        }
        return true;
    }

    public boolean isStartAddressChanged() {
        return this.fStartAddressChanged;
    }

    private long getRowAddress(int n) {
        long l = this.getStartAddress() + (long)n;
        if (l > 0xFFFFFFFFL) {
            l -= 0xFFFFFFFFL;
        }
        return l;
    }

    class CFormattedMemoryBlockRow
    implements IFormattedMemoryBlockRow {
        private long fAddress;
        private String[] fData;
        private String fAscii;

        public CFormattedMemoryBlockRow(long l, String[] stringArray, String string) {
            this.fAddress = l;
            this.fData = stringArray;
            this.fAscii = string;
        }

        public long getAddress() {
            return this.fAddress;
        }

        public String getASCII() {
            return this.fAscii;
        }

        public String[] getData() {
            return this.fData;
        }
    }
}

