/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CGlobalVariable
extends CModificationVariable
implements ICGlobalVariable {
    public CGlobalVariable(CDebugElement cDebugElement, ICDIVariable iCDIVariable) {
        super(cDebugElement, iCDIVariable);
    }

    public IValue getValue() throws DebugException {
        if (!this.isEnabled()) {
            return CVariable.fDisabledValue;
        }
        if (this.fValue == null) {
            ICDIValue iCDIValue = this.getCurrentValue();
            if (iCDIValue instanceof ICDIArrayValue) {
                ICDIVariable iCDIVariable = null;
                try {
                    iCDIVariable = this.getCDIVariable();
                }
                catch (CDIException cDIException) {
                    this.requestFailed("", cDIException);
                }
                int[] nArray = this.getType().getArrayDimensions();
                if (nArray.length > 0 && nArray[0] > 0) {
                    this.fValue = CValueFactory.createArrayValue(this, iCDIVariable, 0, nArray.length - 1);
                }
            } else {
                this.fValue = CValueFactory.createGlobalValue(this, this.getCurrentValue());
            }
        }
        return this.fValue;
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
        super.handleDebugEvents(iCDIEventArray);
        int n = 0;
        while (n < iCDIEventArray.length) {
            ICDIEvent iCDIEvent = iCDIEventArray[n];
            ICDIObject iCDIObject = iCDIEvent.getSource();
            if (iCDIObject != null && iCDIObject.getTarget().equals(this.getCDITarget()) && iCDIEvent instanceof ICDIResumedEvent) {
                try {
                    this.setChanged(false);
                }
                catch (DebugException debugException) {
                    CDebugCorePlugin.log(debugException);
                }
            }
            ++n;
        }
    }

    public void dispose() {
        if (this.getShadow() != null) {
            this.getShadow().dispose();
        }
        try {
            this.getCDISession().getVariableManager().destroyVariable(this.getCDIVariable());
        }
        catch (CDIException cDIException) {}
        super.dispose();
    }

    public boolean canEnableDisable() {
        return true;
    }
}

