/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterGroup
extends CDebugElement
implements IRegisterGroup {
    private String fName;
    private ICDIRegisterObject[] fRegisterObjects;
    private IRegister[] fRegisters;

    public CRegisterGroup(CDebugTarget cDebugTarget, String string, ICDIRegisterObject[] iCDIRegisterObjectArray) {
        super(cDebugTarget);
        this.fName = string;
        this.fRegisterObjects = iCDIRegisterObjectArray;
        this.fRegisters = new IRegister[iCDIRegisterObjectArray.length];
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegister[] getRegisters() throws DebugException {
        int n = 0;
        while (n < this.fRegisters.length) {
            if (this.fRegisters[n] == null) {
                this.fRegisters[n] = new CRegister(this, this.getCDIRegister(this.fRegisterObjects[n]));
            }
            ++n;
        }
        return this.fRegisters;
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisterObjects.length > 0;
    }

    public void dispose() {
        int n = 0;
        while (n < this.fRegisters.length) {
            if (this.fRegisters[n] != null) {
                ((CRegister)this.fRegisters[n]).dispose();
                this.fRegisters[n] = null;
            }
            ++n;
        }
    }

    private ICDIRegister getCDIRegister(ICDIRegisterObject iCDIRegisterObject) throws DebugException {
        try {
            return ((CDebugTarget)this.getDebugTarget()).getCDISession().getRegisterManager().createRegister(iCDIRegisterObject);
        }
        catch (CDIException cDIException) {
            return new CRegister.ErrorRegister(iCDIRegisterObject, cDIException);
        }
    }

    public void resetChangeFlags() {
        int n = 0;
        while (n < this.fRegisters.length) {
            if (this.fRegisters[n] != null) {
                try {
                    ((CRegister)this.fRegisters[n]).setChanged(false);
                }
                catch (DebugException debugException) {
                    DebugPlugin.log((Throwable)debugException);
                }
            }
            ++n;
        }
    }

    public void targetSuspended() {
        int n = 0;
        while (n < this.fRegisters.length) {
            if (this.fRegisters[n] != null && ((CRegister)this.fRegisters[n]).hasErrors()) {
                ((CRegister)this.fRegisters[n]).dispose();
                this.fRegisters[n] = null;
            }
            ++n;
        }
    }
}

