/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;

public class CSignal
extends CDebugElement
implements ICSignal,
ICDIEventListener {
    private ICDISignal fCDISignal;

    public CSignal(CDebugTarget cDebugTarget, ICDISignal iCDISignal) {
        super(cDebugTarget);
        this.fCDISignal = iCDISignal;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public String getDescription() throws DebugException {
        return this.getCDISignal().getDescription();
    }

    public String getName() throws DebugException {
        return this.getCDISignal().getName();
    }

    public boolean isPassEnabled() throws DebugException {
        return !this.getCDISignal().isIgnore();
    }

    public boolean isStopEnabled() throws DebugException {
        return this.getCDISignal().isStopSet();
    }

    public void setPassEnabled(boolean bl) throws DebugException {
        this.handle(bl, this.isStopEnabled());
    }

    public void setStopEnabled(boolean bl) throws DebugException {
        this.handle(this.isPassEnabled(), bl);
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
    }

    public void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public void signal() throws DebugException {
        try {
            this.getCDITarget().signal(this.getCDISignal());
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
    }

    protected ICDISignal getCDISignal() {
        return this.fCDISignal;
    }

    private void handle(boolean bl, boolean bl2) throws DebugException {
        try {
            this.getCDISignal().handle(!bl, bl2);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
    }

    public boolean canModify() {
        return true;
    }
}

