/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CExpressionTarget;
import org.eclipse.cdt.debug.internal.core.CGlobalVariableManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class CStackFrame
extends CDebugElement
implements ICStackFrame,
IRestart,
IResumeWithoutSignal,
ICDIEventListener {
    private ICDIStackFrame fCDIStackFrame;
    private ICDIStackFrame fLastCDIStackFrame;
    private CThread fThread;
    private List fVariables;
    private boolean fRefreshVariables = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public CStackFrame(CThread cThread, ICDIStackFrame iCDIStackFrame) {
        super((CDebugTarget)cThread.getDebugTarget());
        this.setCDIStackFrame(iCDIStackFrame);
        this.setThread(cThread);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        ICGlobalVariable[] iCGlobalVariableArray = this.getGlobals();
        List list = this.getVariables0();
        ArrayList<ICGlobalVariable> arrayList = new ArrayList<ICGlobalVariable>(iCGlobalVariableArray.length + list.size());
        arrayList.addAll(Arrays.asList(iCGlobalVariableArray));
        arrayList.addAll(list);
        return arrayList.toArray(new IVariable[arrayList.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        ((CThread)this.getThread()).switchToFrame(this);
        if (this.fVariables == null) {
            List list = this.getAllCDIVariableObjects();
            this.fVariables = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.fVariables.add(new CModificationVariable(this, (ICDIVariableObject)iterator.next()));
            }
        } else if (this.refreshVariables()) {
            this.updateVariables();
        }
        this.setRefreshVariables(false);
        return this.fVariables;
    }

    protected void updateVariables() throws DebugException {
        Object object;
        List list = this.getAllCDIVariableObjects();
        int n = 0;
        while (n < this.fVariables.size()) {
            object = this.findVariable(list, (CVariable)this.fVariables.get(n));
            if (object != null) {
                list.remove(object);
                ++n;
                continue;
            }
            this.fVariables.remove(n);
        }
        object = list.iterator();
        while (object.hasNext()) {
            this.fVariables.add(new CModificationVariable(this, (ICDIVariableObject)object.next()));
        }
    }

    protected void setThread(CThread cThread) {
        this.fThread = cThread;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }

    public int getLineNumber() throws DebugException {
        if (this.isSuspended()) {
            ISourceLocator iSourceLocator = ((CDebugTarget)this.getDebugTarget()).getSourceLocator();
            if (iSourceLocator != null && iSourceLocator instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable.getAdapter((Class)clazz) != null) {
                    IAdaptable iAdaptable2 = (IAdaptable)iSourceLocator;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((ICSourceLocator)iAdaptable2.getAdapter((Class)clazz2)).getLineNumber(this);
                }
            }
            if (this.getCDIStackFrame() != null && this.getCDIStackFrame().getLocation() != null) {
                return this.getCDIStackFrame().getLocation().getLineNumber();
            }
        }
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        ICDILocation iCDILocation = this.getCDIStackFrame().getLocation();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (iCDILocation.getFunction() != null && iCDILocation.getFunction().trim().length() > 0) {
            string = String.valueOf(string) + iCDILocation.getFunction() + "() ";
        }
        if (iCDILocation.getFile() != null && iCDILocation.getFile().trim().length() > 0) {
            string2 = iCDILocation.getFile();
            if (iCDILocation.getLineNumber() != 0) {
                string3 = NumberFormat.getInstance().format(new Integer(iCDILocation.getLineNumber()));
            }
        } else {
            return string;
        }
        return MessageFormat.format(CoreModelMessages.getString("CStackFrame.0"), string, string2, string3);
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return ((CDebugTarget)this.getDebugTarget()).getRegisterGroups();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return ((CDebugTarget)this.getDebugTarget()).getRegisterGroups().length > 0;
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.isTopStackFrame() && this.getThread().canStepInto();
        }
        catch (DebugException debugException) {
            this.logError((Exception)((Object)debugException));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && this.getThread().canStepOver();
        }
        catch (DebugException debugException) {
            this.logError((Exception)((Object)debugException));
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            if (!this.exists()) {
                return false;
            }
            List list = ((CThread)this.getThread()).computeStackFrames();
            if (list != null && !list.isEmpty()) {
                boolean bl = this.equals(list.get(list.size() - 1));
                return !bl && this.getThread().canStepReturn();
            }
        }
        catch (DebugException debugException) {
            this.logError((Exception)((Object)debugException));
        }
        return false;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.getThread().stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepOver();
        } else {
            this.getThread().stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepReturn();
        } else {
            this.getThread().stepReturn();
        }
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        boolean bl = false;
        try {
            bl = this.exists();
        }
        catch (DebugException debugException) {
            this.logError((Exception)((Object)debugException));
        }
        return bl && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    protected ICDIStackFrame getCDIStackFrame() {
        return this.fCDIStackFrame;
    }

    protected void setCDIStackFrame(ICDIStackFrame iCDIStackFrame) {
        this.fLastCDIStackFrame = iCDIStackFrame != null ? iCDIStackFrame : this.fCDIStackFrame;
        this.fCDIStackFrame = iCDIStackFrame;
        this.setRefreshVariables(true);
    }

    protected ICDIStackFrame getLastCDIStackFrame() {
        return this.fLastCDIStackFrame;
    }

    protected static boolean equalFrame(ICDIStackFrame iCDIStackFrame, ICDIStackFrame iCDIStackFrame2) {
        if (iCDIStackFrame == null || iCDIStackFrame2 == null) {
            return false;
        }
        ICDILocation iCDILocation = iCDIStackFrame.getLocation();
        ICDILocation iCDILocation2 = iCDIStackFrame2.getLocation();
        if (iCDILocation == null || iCDILocation2 == null) {
            return false;
        }
        if (iCDILocation.getFile() != null && iCDILocation.getFile().length() > 0 && iCDILocation2.getFile() != null && iCDILocation2.getFile().length() > 0 && iCDILocation.getFile().equals(iCDILocation2.getFile()) && iCDILocation.getFunction() != null && iCDILocation.getFunction().length() > 0 && iCDILocation2.getFunction() != null && iCDILocation2.getFunction().length() > 0 && iCDILocation.getFunction().equals(iCDILocation2.getFunction())) {
            return true;
        }
        if (!(iCDILocation.getFile() != null && iCDILocation.getFile().length() >= 1 || iCDILocation2.getFile() != null && iCDILocation2.getFile().length() >= 1 || iCDILocation.getFunction() == null || iCDILocation.getFunction().length() <= 0 || iCDILocation2.getFunction() == null || iCDILocation2.getFunction().length() <= 0 || !iCDILocation.getFunction().equals(iCDILocation2.getFunction()))) {
            return true;
        }
        return !(iCDILocation.getFile() != null && iCDILocation.getFile().length() >= 1 || iCDILocation2.getFile() != null && iCDILocation2.getFile().length() >= 1 || iCDILocation.getFunction() != null && iCDILocation.getFunction().length() >= 1 || iCDILocation2.getFunction() != null && iCDILocation2.getFunction().length() >= 1 || iCDILocation.getAddress() != iCDILocation2.getAddress());
    }

    protected boolean exists() throws DebugException {
        return ((CThread)this.getThread()).computeStackFrames().indexOf(this) != -1;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getDebugTarget().getAdapter(clazz);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return this.getDebugTarget().getAdapter(clazz);
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return this;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.ICStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz5) {
            return this;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.debug.core.model.IStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz6) {
            return this;
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz7) {
            return this.getCDIStackFrame();
        }
        return super.getAdapter(clazz);
    }

    protected void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeAllVariables();
    }

    protected List getCDILocalVariableObjects() throws DebugException {
        ArrayList<ICDIVariableObject> arrayList = new ArrayList<ICDIVariableObject>();
        try {
            arrayList.addAll(Arrays.asList(this.getCDISession().getVariableManager().getLocalVariableObjects(this.getCDIStackFrame())));
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
        return arrayList;
    }

    protected List getCDIArgumentObjects() throws DebugException {
        ArrayList<ICDIArgumentObject> arrayList = new ArrayList<ICDIArgumentObject>();
        try {
            arrayList.addAll(Arrays.asList(this.getCDISession().getVariableManager().getArgumentObjects(this.getCDIStackFrame())));
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
        return arrayList;
    }

    protected List getAllCDIVariableObjects() throws DebugException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getCDIArgumentObjects());
        arrayList.addAll(this.getCDILocalVariableObjects());
        return arrayList;
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame iStackFrame = this.getThread().getTopStackFrame();
        return iStackFrame != null && iStackFrame.equals(this);
    }

    protected void disposeAllVariables() {
        if (this.fVariables == null) {
            return;
        }
        Iterator iterator = this.fVariables.iterator();
        while (iterator.hasNext()) {
            ((CVariable)iterator.next()).dispose();
        }
        this.fVariables = null;
    }

    public long getAddress() {
        return this.getCDIStackFrame().getLocation().getAddress();
    }

    public String getFile() {
        return this.getCDIStackFrame().getLocation().getFile();
    }

    public String getFunction() {
        return this.getCDIStackFrame().getLocation().getFunction();
    }

    public int getLevel() {
        return this.getCDIStackFrame().getLevel();
    }

    public int getFrameLineNumber() {
        return this.getCDIStackFrame().getLocation().getLineNumber();
    }

    protected synchronized void preserve() {
        this.preserveVariables();
    }

    private void preserveVariables() {
        if (this.fVariables == null) {
            return;
        }
        try {
            Iterator iterator = this.fVariables.iterator();
            while (iterator.hasNext()) {
                ((CVariable)iterator.next()).setChanged(false);
            }
        }
        catch (DebugException debugException) {
            CDebugCorePlugin.log(debugException);
        }
    }

    protected ICDIVariableObject findVariable(List list, CVariable cVariable) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ICDIVariableObject iCDIVariableObject = (ICDIVariableObject)iterator.next();
            if (!cVariable.sameVariableObject(iCDIVariableObject)) continue;
            return iCDIVariableObject;
        }
        return null;
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    private void setRefreshVariables(boolean bl) {
        this.fRefreshVariables = bl;
    }

    private boolean refreshVariables() {
        return this.fRefreshVariables;
    }

    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    public IValue evaluateExpression(String string) throws DebugException {
        CExpressionTarget cExpressionTarget;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.cdt.debug.internal.core.CExpressionTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (cExpressionTarget = (CExpressionTarget)iDebugTarget.getAdapter((Class)clazz)) != null ? cExpressionTarget.evaluateExpression(string) : null;
    }

    private ICGlobalVariable[] getGlobals() {
        CGlobalVariableManager cGlobalVariableManager = ((CDebugTarget)this.getDebugTarget()).getGlobalVariableManager();
        if (cGlobalVariableManager != null) {
            return cGlobalVariableManager.getGlobals();
        }
        return new ICGlobalVariable[0];
    }
}

