/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.IDummyStackFrame;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.cdt.debug.core.model.IState;
import org.eclipse.cdt.debug.core.model.ISwitchToFrame;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDummyStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class CThread
extends CDebugElement
implements IThread,
IState,
IRestart,
IResumeWithoutSignal,
ISwitchToFrame,
ICDIEventListener {
    private boolean fSuspending;
    private static final int MAX_STACK_DEPTH = 100;
    private ICDIThread fCDIThread;
    private ArrayList fStackFrames;
    private boolean fRunning;
    private boolean fRefreshChildren = true;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private ICDIConfiguration fConfig;
    private boolean fIsCurrent = false;
    private CStackFrame fLastStackFrame = null;
    private int fLastStackDepth = 0;
    private boolean fDisposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CThread(CDebugTarget cDebugTarget, ICDIThread iCDIThread) {
        super(cDebugTarget);
        this.setCDIThread(iCDIThread);
        this.fConfig = this.getCDISession().getConfiguration();
        this.initialize();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.fStackFrames = new ArrayList();
        this.setRunning(false);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List list = Collections.EMPTY_LIST;
        try {
            list = this.computeStackFrames();
        }
        catch (DebugException debugException) {
            this.setStatus(2, debugException.getStatus().getMessage());
            throw debugException;
        }
        return list.toArray(new IStackFrame[list.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return true;
    }

    protected synchronized List computeStackFrames(boolean bl) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = new ArrayList();
            } else if (bl) {
                ICDIStackFrame[] iCDIStackFrameArray;
                int n;
                Object e;
                if (this.fStackFrames.size() > 0 && (e = this.fStackFrames.get(this.fStackFrames.size() - 1)) instanceof IDummyStackFrame) {
                    this.fStackFrames.remove(e);
                }
                ICDIStackFrame[] iCDIStackFrameArray2 = (n = this.getStackDepth()) != 0 ? this.getCDIStackFrames(0, n > this.getMaxStackDepth() ? this.getMaxStackDepth() - 1 : n - 1) : (iCDIStackFrameArray = new ICDIStackFrame[]{});
                if (this.fStackFrames.isEmpty()) {
                    this.addStackFrames(iCDIStackFrameArray, 0, iCDIStackFrameArray.length);
                } else if (n < this.getLastStackDepth()) {
                    this.disposeStackFrames(0, this.getLastStackDepth() - n);
                    this.updateStackFrames(iCDIStackFrameArray, 0, this.fStackFrames, this.fStackFrames.size());
                    if (this.fStackFrames.size() < iCDIStackFrameArray.length) {
                        this.addStackFrames(iCDIStackFrameArray, this.fStackFrames.size(), iCDIStackFrameArray.length - this.fStackFrames.size());
                    }
                } else if (n > this.getLastStackDepth()) {
                    this.disposeStackFrames(iCDIStackFrameArray.length - n + this.getLastStackDepth(), n - this.getLastStackDepth());
                    this.addStackFrames(iCDIStackFrameArray, 0, n - this.getLastStackDepth());
                    this.updateStackFrames(iCDIStackFrameArray, n - this.getLastStackDepth(), this.fStackFrames, iCDIStackFrameArray.length - n + this.getLastStackDepth());
                } else if (n != 0) {
                    ICDIStackFrame iCDIStackFrame;
                    ICDIStackFrame iCDIStackFrame2 = iCDIStackFrameArray.length > 0 ? iCDIStackFrameArray[0] : null;
                    ICDIStackFrame iCDIStackFrame3 = iCDIStackFrame = this.fStackFrames.size() > 0 ? ((CStackFrame)this.fStackFrames.get(0)).getLastCDIStackFrame() : null;
                    if (!CStackFrame.equalFrame(iCDIStackFrame2, iCDIStackFrame)) {
                        this.disposeStackFrames(0, this.fStackFrames.size());
                        this.addStackFrames(iCDIStackFrameArray, 0, iCDIStackFrameArray.length);
                    } else {
                        this.updateStackFrames(iCDIStackFrameArray, 0, this.fStackFrames, iCDIStackFrameArray.length);
                    }
                }
                if (n > this.getMaxStackDepth()) {
                    this.fStackFrames.add(new CDummyStackFrame(this));
                }
                this.setLastStackDepth(n);
                this.setRefreshChildren(false);
            }
        }
        return this.fStackFrames;
    }

    protected ICDIStackFrame[] getCDIStackFrames() throws DebugException {
        return new ICDIStackFrame[0];
    }

    protected ICDIStackFrame[] getCDIStackFrames(int n, int n2) throws DebugException {
        try {
            ((CDebugTarget)this.getDebugTarget()).setCurrentThread(this);
            return this.getCDIThread().getStackFrames(n, n2);
        }
        catch (CDIException cDIException) {
            this.setStatus(1, MessageFormat.format(CoreModelMessages.getString("CThread.0"), cDIException.getMessage()));
            this.targetRequestFailed(cDIException.getMessage(), null);
            return new ICDIStackFrame[0];
        }
    }

    protected void updateStackFrames(ICDIStackFrame[] iCDIStackFrameArray, int n, List list, int n2) throws DebugException {
        int n3 = 0;
        while (n3 < n2) {
            CStackFrame cStackFrame = (CStackFrame)list.get(n);
            cStackFrame.setCDIStackFrame(iCDIStackFrameArray[n]);
            cStackFrame.fireChangeEvent(256);
            ++n;
            ++n3;
        }
    }

    protected void addStackFrames(ICDIStackFrame[] iCDIStackFrameArray, int n, int n2) {
        if (iCDIStackFrameArray.length >= n + n2) {
            int n3 = 0;
            while (n3 < n2) {
                this.fStackFrames.add(n3, new CStackFrame(this, iCDIStackFrameArray[n + n3]));
                ++n3;
            }
        }
    }

    public List computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.refreshChildren());
    }

    public List computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    protected List createAllStackFrames(int n, ICDIStackFrame[] iCDIStackFrameArray) throws DebugException {
        ArrayList<CDebugElement> arrayList = new ArrayList<CDebugElement>(iCDIStackFrameArray.length);
        int n2 = 0;
        while (n2 < iCDIStackFrameArray.length) {
            arrayList.add(new CStackFrame(this, iCDIStackFrameArray[n2]));
            ++n2;
        }
        if (n > iCDIStackFrameArray.length) {
            arrayList.add(new CDummyStackFrame(this));
        }
        return arrayList;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List list = this.computeStackFrames();
        return list.isEmpty() ? null : (IStackFrame)list.get(0);
    }

    public String getName() throws DebugException {
        return this.getCDIThread().toString();
    }

    public IBreakpoint[] getBreakpoints() {
        return ((CDebugTarget)this.getDebugTarget()).getThreadBreakpoints(this);
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
        if (this.isDisposed()) {
            return;
        }
        int n = 0;
        while (n < iCDIEventArray.length) {
            ICDIEvent iCDIEvent = iCDIEventArray[n];
            ICDIObject iCDIObject = iCDIEvent.getSource();
            if (iCDIObject != null && iCDIObject.getTarget().equals(this.getCDITarget())) {
                if (iCDIEvent instanceof ICDISuspendedEvent) {
                    if (iCDIObject instanceof ICDIThread && this.getCDIThread().equals((ICDIThread)iCDIObject) || iCDIObject instanceof ICDITarget) {
                        this.handleSuspendedEvent((ICDISuspendedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIResumedEvent) {
                    if (iCDIObject instanceof ICDIThread && iCDIObject.equals(this.getCDIThread())) {
                        this.handleResumedEvent((ICDIResumedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIDestroyedEvent) {
                    if (iCDIObject instanceof ICDIThread) {
                        this.handleTerminatedEvent((ICDIDestroyedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIDisconnectedEvent) {
                    if (iCDIObject instanceof ICDIThread) {
                        this.handleDisconnectedEvent((ICDIDisconnectedEvent)iCDIEvent);
                    }
                } else if (iCDIEvent instanceof ICDIChangedEvent && iCDIObject instanceof ICDIThread) {
                    this.handleChangedEvent((ICDIChangedEvent)iCDIEvent);
                }
            }
            ++n;
        }
    }

    public boolean canResume() {
        return this.fConfig.supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.fConfig.supportsSuspend() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return !this.fRunning && !this.isTerminated();
    }

    public void resume() throws DebugException {
        if (!this.isSuspended() && !this.isSuspending()) {
            return;
        }
        try {
            this.getCDIThread().resume();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended() || this.isSuspending()) {
            return;
        }
        this.setSuspending(true);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        CThread.this.getCDITarget().suspend();
                    }
                    catch (CDIException cDIException) {
                        try {
                            CThread.this.targetRequestFailed(cDIException.getMessage(), cDIException);
                        }
                        catch (DebugException debugException) {
                            CDebugUtils.error(debugException.getStatus(), CThread.this);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    CThread.this.setSuspending(false);
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    CThread.this.setSuspending(false);
                    return;
                }
            }
        });
    }

    protected void setSuspending(boolean bl) {
        this.fSuspending = bl;
    }

    protected boolean isSuspending() {
        return this.fSuspending;
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    protected boolean canStep() {
        try {
            return this.fConfig.supportsStepping() && this.isSuspended() && this.getTopStackFrame() != null;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean isStepping() {
        return this.getCurrentStateId() == 6;
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        try {
            if (!this.isInstructionsteppingEnabled()) {
                this.getCDIThread().stepInto();
            } else {
                this.getCDIThread().stepIntoInstruction();
            }
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        try {
            if (!this.isInstructionsteppingEnabled()) {
                this.getCDIThread().stepOver();
            } else {
                this.getCDIThread().stepOverInstruction();
            }
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        try {
            this.getCDIThread().stepReturn();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setCDIThread(ICDIThread iCDIThread) {
        this.fCDIThread = iCDIThread;
    }

    protected ICDIThread getCDIThread() {
        return this.fCDIThread;
    }

    protected void setRunning(boolean bl) {
        this.fRunning = bl;
    }

    protected synchronized void preserveStackFrames() {
        Iterator iterator = this.fStackFrames.iterator();
        while (iterator.hasNext()) {
            CStackFrame cStackFrame;
            IAdaptable iAdaptable = (IAdaptable)iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cStackFrame = (CStackFrame)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            cStackFrame.preserve();
        }
        this.setRefreshChildren(true);
    }

    protected synchronized void disposeStackFrames() {
        Iterator iterator = this.fStackFrames.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CStackFrame)) continue;
            ((CStackFrame)e).dispose();
        }
        this.fStackFrames.clear();
        this.setLastStackDepth(0);
        this.resetStatus();
        this.setRefreshChildren(true);
    }

    protected void disposeStackFrames(int n, int n2) {
        ArrayList<CStackFrame> arrayList = new ArrayList<CStackFrame>(n2);
        Iterator iterator = this.fStackFrames.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            CStackFrame cStackFrame;
            IAdaptable iAdaptable = (IAdaptable)iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cStackFrame = (CStackFrame)iAdaptable.getAdapter((Class)clazz)) != null && n3 >= n && n3 < n + n2) {
                cStackFrame.dispose();
                arrayList.add(cStackFrame);
            }
            ++n3;
        }
        this.fStackFrames.removeAll(arrayList);
    }

    protected void terminated() {
        this.setRunning(false);
        this.dispose();
        this.cleanup();
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int n) {
        this.fCurrentStateId = n;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object object) {
        this.fCurrentStateInfo = object;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent iCDISuspendedEvent) {
        this.setRunning(false);
        if (iCDISuspendedEvent.getSource() instanceof ICDITarget) {
            if (this.isCurrent() && this.getCurrentStateId() != 7) {
                this.setCurrentStateId(7);
                ICDISessionObject iCDISessionObject = iCDISuspendedEvent.getReason();
                this.setCurrentStateInfo(iCDISessionObject);
                if (iCDISessionObject instanceof ICDIEndSteppingRange) {
                    this.handleEndSteppingRange((ICDIEndSteppingRange)iCDISessionObject);
                } else if (iCDISessionObject instanceof ICDIBreakpoint) {
                    this.handleBreakpointHit((ICDIBreakpoint)((Object)iCDISessionObject));
                } else if (iCDISessionObject instanceof ICDISignalReceived) {
                    this.handleSuspendedBySignal((ICDISignalReceived)iCDISessionObject);
                } else {
                    this.fireSuspendEvent(16);
                }
            }
            return;
        }
        this.setCurrentStateId(7);
        this.setCurrentStateInfo(null);
    }

    private void handleResumedEvent(ICDIResumedEvent iCDIResumedEvent) {
        this.setRunning(true);
        this.setLastStackFrame(null);
        int n = 5;
        int n2 = 1;
        if (this.isCurrent() && iCDIResumedEvent.getType() != 0) {
            this.preserveStackFrames();
            switch (iCDIResumedEvent.getType()) {
                case 2: 
                case 4: {
                    n2 = 1;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
                case 5: {
                    n2 = 4;
                }
            }
            n = 6;
        } else {
            this.setCurrent(false);
            this.disposeStackFrames();
            this.fireChangeEvent(512);
        }
        this.setCurrentStateId(n);
        this.setCurrentStateInfo(null);
        this.fireResumeEvent(n2);
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange iCDIEndSteppingRange) {
        this.fireSuspendEvent(8);
    }

    private void handleBreakpointHit(ICDIBreakpoint iCDIBreakpoint) {
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignalReceived iCDISignalReceived) {
        this.fireSuspendEvent(0);
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent iCDIDestroyedEvent) {
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent iCDIDisconnectedEvent) {
        this.setCurrentStateId(10);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleChangedEvent(ICDIChangedEvent iCDIChangedEvent) {
    }

    protected void cleanup() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeStackFrames();
    }

    protected synchronized void stepToFrame(IStackFrame iStackFrame) throws DebugException {
    }

    private void setRefreshChildren(boolean bl) {
        this.fRefreshChildren = bl;
    }

    private boolean refreshChildren() {
        return this.fRefreshChildren;
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    protected boolean isCurrent() {
        return this.fIsCurrent;
    }

    protected void setCurrent(boolean bl) {
        this.fIsCurrent = bl;
    }

    public void switchToFrame(IStackFrame iStackFrame) throws DebugException {
        if (iStackFrame == null || !(iStackFrame instanceof CStackFrame)) {
            return;
        }
        try {
            ((CDebugTarget)this.getDebugTarget()).setCurrentThread(this);
            if (this.getLastStackFrame() != null) {
                ((CDebugTarget)this.getDebugTarget()).resetRegisters();
                this.getCDIThread().setCurrentStackFrame(((CStackFrame)iStackFrame).getCDIStackFrame());
            }
            this.setLastStackFrame((CStackFrame)iStackFrame);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
    }

    private void setLastStackFrame(CStackFrame cStackFrame) {
        this.fLastStackFrame = cStackFrame;
    }

    private CStackFrame getLastStackFrame() {
        return this.fLastStackFrame;
    }

    protected int getStackDepth() throws DebugException {
        int n = 0;
        try {
            n = this.getCDIThread().getStackFrameCount();
        }
        catch (CDIException cDIException) {
            this.setStatus(1, MessageFormat.format(CoreModelMessages.getString("CThread.1"), cDIException.getMessage()));
        }
        return n;
    }

    protected int getMaxStackDepth() {
        return 100;
    }

    private void setLastStackDepth(int n) {
        this.fLastStackDepth = n;
    }

    protected int getLastStackDepth() {
        return this.fLastStackDepth;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.IState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    protected void dispose() {
        this.fDisposed = true;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    public String toString() {
        String string = "";
        try {
            string = this.getName();
        }
        catch (DebugException debugException) {}
        return string;
    }

    protected void resumed(int n, List list) {
        this.setRunning(true);
        this.setLastStackFrame(null);
        int n2 = 5;
        if (this.isCurrent() && n != 32 && n != 0) {
            this.preserveStackFrames();
            n2 = 6;
            list.add(this.createResumeEvent(n));
        } else {
            this.setCurrent(false);
            this.disposeStackFrames();
            list.add(this.createChangeEvent(512));
        }
        this.setCurrentStateId(n2);
        this.setCurrentStateInfo(null);
    }

    private boolean isInstructionsteppingEnabled() {
        return ((CDebugTarget)this.getDebugTarget()).isInstructionSteppingEnabled();
    }
}

