/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyBlock;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class Disassembly
extends CDebugElement
implements IDisassembly {
    private static final int DISASSEMBLY_BLOCK_SIZE = 100;
    private DisassemblyBlock[] fBlocks = new DisassemblyBlock[1];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Disassembly(CDebugTarget cDebugTarget) {
        super(cDebugTarget);
    }

    public IDisassemblyBlock getDisassemblyBlock(ICStackFrame iCStackFrame) throws DebugException {
        if (this.fBlocks[0] == null || !this.fBlocks[0].contains(iCStackFrame)) {
            this.fBlocks[0] = this.createBlock(iCStackFrame);
        }
        return this.fBlocks[0];
    }

    private DisassemblyBlock createBlock(ICStackFrame iCStackFrame) throws DebugException {
        ICDISourceManager iCDISourceManager;
        ICDISession iCDISession;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iCDISession = (ICDISession)iDebugTarget.getAdapter((Class)clazz)) != null && (iCDISourceManager = iCDISession.getSourceManager()) != null) {
            String string = iCStackFrame.getFile();
            int n = iCStackFrame.getLineNumber();
            ICDIMixedInstruction[] iCDIMixedInstructionArray = new ICDIMixedInstruction[]{};
            long l = iCStackFrame.getAddress();
            if (string != null && string.length() > 0) {
                try {
                    iCDIMixedInstructionArray = iCDISourceManager.getMixedInstructions(string, n, CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS));
                }
                catch (CDIException cDIException) {
                    this.targetRequestFailed(cDIException.getMessage(), cDIException);
                }
            }
            if (iCDIMixedInstructionArray.length == 0 || !this.containsAddress(iCDIMixedInstructionArray, l)) {
                if (l >= 0L) {
                    try {
                        ICDIInstruction[] iCDIInstructionArray = this.getFunctionInstructions(iCDISourceManager.getInstructions(l, l + 100L));
                        return DisassemblyBlock.create((IDisassembly)this, iCDIInstructionArray);
                    }
                    catch (CDIException cDIException) {
                        this.targetRequestFailed(cDIException.getMessage(), cDIException);
                    }
                }
            } else {
                return DisassemblyBlock.create((IDisassembly)this, iCDIMixedInstructionArray);
            }
        }
        return null;
    }

    private boolean containsAddress(ICDIMixedInstruction[] iCDIMixedInstructionArray, long l) {
        int n = 0;
        while (n < iCDIMixedInstructionArray.length) {
            ICDIInstruction[] iCDIInstructionArray = iCDIMixedInstructionArray[n].getInstructions();
            int n2 = 0;
            while (n2 < iCDIInstructionArray.length) {
                if (iCDIInstructionArray[n2].getAdress() == l) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private ICDIInstruction[] getFunctionInstructions(ICDIInstruction[] iCDIInstructionArray) {
        if (iCDIInstructionArray.length > 0 && iCDIInstructionArray[0].getFuntionName() != null && iCDIInstructionArray[0].getFuntionName().length() > 0) {
            ArrayList<ICDIInstruction> arrayList = new ArrayList<ICDIInstruction>(iCDIInstructionArray.length);
            arrayList.add(iCDIInstructionArray[0]);
            int n = 1;
            while (n < iCDIInstructionArray.length) {
                if (iCDIInstructionArray[0].getFuntionName().equals(iCDIInstructionArray[n].getFuntionName())) {
                    arrayList.add(iCDIInstructionArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new ICDIInstruction[arrayList.size()]);
        }
        return iCDIInstructionArray;
    }

    public void dispose() {
        int n = 0;
        while (n < this.fBlocks.length) {
            if (this.fBlocks[n] != null) {
                this.fBlocks[n].dispose();
                this.fBlocks[n] = null;
            }
            ++n;
        }
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return this.getDebugTarget().getAdapter(clazz);
        }
        return super.getAdapter(clazz);
    }

    public void reset() {
        int n = 0;
        while (n < this.fBlocks.length) {
            if (this.fBlocks[n] != null) {
                this.fBlocks[n].dispose();
                this.fBlocks[n] = null;
            }
            ++n;
        }
        this.fireChangeEvent(512);
    }
}

