/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IAsmSourceLine;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.model.AsmSourceLine;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.ISourceLocator;

public class DisassemblyBlock
implements IDisassemblyBlock,
IAdaptable {
    private IDisassembly fDisassembly;
    private IAsmSourceLine[] fSourceLines;
    private long fStartAddress = 0L;
    private long fEndAddress = 0L;
    private boolean fMixedMode = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private DisassemblyBlock(IDisassembly iDisassembly) {
        this.fDisassembly = iDisassembly;
    }

    public static DisassemblyBlock create(IDisassembly iDisassembly, ICDIMixedInstruction[] iCDIMixedInstructionArray) {
        DisassemblyBlock disassemblyBlock = new DisassemblyBlock(iDisassembly);
        disassemblyBlock.setMixedMode(true);
        ISourceLocator iSourceLocator = iDisassembly.getDebugTarget().getLaunch().getSourceLocator();
        ICSourceLocator iCSourceLocator = null;
        if (iSourceLocator instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        }
        disassemblyBlock.setSourceLines(DisassemblyBlock.createSourceLines(iCSourceLocator, iCDIMixedInstructionArray));
        disassemblyBlock.initializeAddresses();
        return disassemblyBlock;
    }

    public static DisassemblyBlock create(IDisassembly iDisassembly, ICDIInstruction[] iCDIInstructionArray) {
        DisassemblyBlock disassemblyBlock = new DisassemblyBlock(iDisassembly);
        disassemblyBlock.setMixedMode(false);
        disassemblyBlock.setSourceLines(DisassemblyBlock.createSourceLines(iCDIInstructionArray));
        disassemblyBlock.initializeAddresses();
        return disassemblyBlock;
    }

    public IDisassembly getDisassembly() {
        return this.fDisassembly;
    }

    public String getModuleFile() {
        IDisassembly iDisassembly = this.getDisassembly();
        if (iDisassembly != null) {
            IExecFileInfo iExecFileInfo;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iExecFileInfo = (IExecFileInfo)iDisassembly.getAdapter(clazz)) != null && iExecFileInfo.getExecFile() != null) {
                return iExecFileInfo.getExecFile().getLocation().toOSString();
            }
        }
        return "";
    }

    public boolean contains(ICStackFrame iCStackFrame) {
        if (!this.getDisassembly().getDebugTarget().equals(iCStackFrame.getDebugTarget())) {
            return false;
        }
        long l = iCStackFrame.getAddress();
        return l >= this.fStartAddress && l <= this.fEndAddress;
    }

    public IAsmSourceLine[] getSourceLines() {
        return this.fSourceLines;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public boolean isMixedMode() {
        return this.fMixedMode;
    }

    public void dispose() {
    }

    private static IAsmSourceLine[] createSourceLines(ICSourceLocator iCSourceLocator, ICDIMixedInstruction[] iCDIMixedInstructionArray) {
        Object object;
        IAsmSourceLine[] iAsmSourceLineArray = new IAsmSourceLine[iCDIMixedInstructionArray.length];
        LineNumberReader lineNumberReader = null;
        if (iAsmSourceLineArray.length > 0 && iCSourceLocator != null) {
            String string = iCDIMixedInstructionArray[0].getFileName();
            object = iCSourceLocator.findSourceElement(string);
            File file = null;
            if (object instanceof IFile) {
                file = ((IFile)object).getLocation().toFile();
            } else if (object instanceof IStorage) {
                file = ((IStorage)object).getFullPath().toFile();
            }
            if (file != null) {
                try {
                    lineNumberReader = new LineNumberReader(new FileReader(file));
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        int n = 0;
        while (n < iAsmSourceLineArray.length) {
            object = null;
            if (lineNumberReader != null) {
                int n2 = iCDIMixedInstructionArray[n].getLineNumber();
                while (lineNumberReader.getLineNumber() + 1 < n2) {
                    try {
                        lineNumberReader.readLine();
                    }
                    catch (IOException iOException) {}
                }
                if (lineNumberReader.getLineNumber() + 1 == n2) {
                    try {
                        object = String.valueOf(lineNumberReader.readLine()) + '\n';
                    }
                    catch (IOException iOException) {}
                }
            }
            iAsmSourceLineArray[n] = new AsmSourceLine((String)object, iCDIMixedInstructionArray[n].getInstructions());
            ++n;
        }
        return iAsmSourceLineArray;
    }

    private static IAsmSourceLine[] createSourceLines(ICDIInstruction[] iCDIInstructionArray) {
        return new IAsmSourceLine[]{new AsmSourceLine("", iCDIInstructionArray)};
    }

    private void initializeAddresses() {
        if (this.fSourceLines.length > 0) {
            IAsmInstruction[] iAsmInstructionArray = this.fSourceLines[0].getInstructions();
            this.fStartAddress = iAsmInstructionArray[0].getAdress();
            iAsmInstructionArray = this.fSourceLines[this.fSourceLines.length - 1].getInstructions();
            this.fEndAddress = iAsmInstructionArray[iAsmInstructionArray.length - 1].getAdress();
        }
    }

    private void setMixedMode(boolean bl) {
        this.fMixedMode = bl;
    }

    private void setSourceLines(IAsmSourceLine[] iAsmSourceLineArray) {
        this.fSourceLines = iAsmSourceLineArray;
    }
}

