/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CDirectorySourceLocation
implements IDirectorySourceLocation {
    private static final String ELEMENT_NAME = "cDirectorySourceLocation";
    private static final String ATTR_DIRECTORY = "directory";
    private static final String ATTR_ASSOCIATION = "association";
    private static final String ATTR_SEARCH_SUBFOLDERS = "searchSubfolders";
    private IPath fDirectory;
    private IPath fAssociation = null;
    private boolean fSearchForDuplicateFiles = false;
    private boolean fSearchSubfolders = false;
    private File[] fFolders = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CDirectorySourceLocation() {
    }

    public CDirectorySourceLocation(IPath iPath, IPath iPath2, boolean bl) {
        this.setDirectory(iPath);
        this.setAssociation(iPath2);
        this.setSearchSubfolders(bl);
    }

    public Object findSourceElement(String string) throws CoreException {
        Path path;
        File file;
        Object object = null;
        if (!this.isEmpty(string) && this.getDirectory() != null && (object = (file = new File(string)).isAbsolute() ? this.findFileByAbsolutePath(string) : this.findFileByRelativePath(string)) == null && this.getAssociation() != null && (path = new Path(string)).segmentCount() > 1 && this.getAssociation().isPrefixOf((IPath)path)) {
            path = this.getDirectory().append(path.removeFirstSegments(this.getAssociation().segmentCount()));
            object = this.findFileByAbsolutePath(path.toOSString());
        }
        return object;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.core.runtime.IPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this.getDirectory();
        }
        return null;
    }

    private void setDirectory(IPath iPath) {
        this.fDirectory = iPath;
    }

    public IPath getDirectory() {
        return this.fDirectory;
    }

    public void getDirectory(IPath iPath) {
        this.fDirectory = iPath;
    }

    public void setAssociation(IPath iPath) {
        this.fAssociation = iPath;
    }

    public IPath getAssociation() {
        return this.fAssociation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findFileByAbsolutePath(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            return null;
        }
        File[] fileArray = this.getFolders();
        if (fileArray == null) return null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = 0;
        while (n < fileArray.length) {
            Object object = this.findFileByAbsolutePath(fileArray[n], string);
            if (object instanceof List) {
                if (!this.searchForDuplicateFiles()) return linkedList.getFirst();
                linkedList.addAll((List)object);
            } else if (object != null) {
                if (!this.searchForDuplicateFiles()) return object;
                linkedList.add(object);
            }
            ++n;
        }
        if (linkedList.size() <= 0) return null;
        return linkedList.size() == 1 ? linkedList.getFirst() : linkedList;
    }

    private Object findFileByAbsolutePath(File file, String string) {
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            return null;
        }
        Path path = new Path(string);
        Path path2 = new Path(file.getAbsolutePath());
        IPath iPath = this.getAssociation();
        if (!this.isPrefix((IPath)path2, (IPath)path) || path2.segmentCount() + 1 != path.segmentCount()) {
            if (iPath != null && this.isPrefix(iPath, (IPath)path) && iPath.segmentCount() + 1 == path.segmentCount()) {
                path = path2.append(path.removeFirstSegments(iPath.segmentCount()));
            } else {
                return null;
            }
        }
        IFile[] iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        int n = 0;
        while (n < iFileArray.length) {
            if (iFileArray[n].exists()) {
                if (!this.searchForDuplicateFiles()) {
                    return iFileArray[n];
                }
                linkedList.add(iFileArray[n]);
            }
            ++n;
        }
        if (linkedList.size() > 0) {
            return linkedList.size() == 1 ? linkedList.getFirst() : linkedList;
        }
        file2 = path.toFile();
        if (file2.exists() && file2.isFile()) {
            return this.createExternalFileStorage((IPath)path);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findFileByRelativePath(String string) {
        File[] fileArray = this.getFolders();
        if (fileArray == null) return null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = 0;
        while (n < fileArray.length) {
            Object object = this.findFileByRelativePath(fileArray[n], string);
            if (object instanceof List) {
                if (!this.searchForDuplicateFiles()) return linkedList.getFirst();
                linkedList.addAll((List)object);
            } else if (object != null) {
                if (!this.searchForDuplicateFiles()) return object;
                linkedList.add(object);
            }
            ++n;
        }
        if (linkedList.size() <= 0) return null;
        return linkedList.size() == 1 ? linkedList.getFirst() : linkedList;
    }

    private Object findFileByRelativePath(File file, String string) {
        Path path = new Path(file.getAbsolutePath());
        File file2 = (path = path.append(string)).toFile();
        if (file2.exists() && file2.isFile()) {
            path = new Path(file2.getAbsolutePath());
            IFile[] iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            LinkedList<IFile> linkedList = new LinkedList<IFile>();
            int n = 0;
            while (n < iFileArray.length) {
                if (iFileArray[n].exists()) {
                    if (!this.searchForDuplicateFiles()) {
                        return iFileArray[n];
                    }
                    linkedList.add(iFileArray[n]);
                }
                ++n;
            }
            if (linkedList.size() > 0) {
                return linkedList.size() == 1 ? linkedList.getFirst() : linkedList;
            }
            return this.createExternalFileStorage((IPath)path);
        }
        return null;
    }

    private IStorage createExternalFileStorage(IPath iPath) {
        return new FileStorage(iPath);
    }

    public String getMemento() throws CoreException {
        Document document = null;
        Exception exception = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(ELEMENT_NAME);
            document.appendChild(element);
            element.setAttribute(ATTR_DIRECTORY, this.getDirectory().toOSString());
            if (this.getAssociation() != null) {
                element.setAttribute(ATTR_ASSOCIATION, this.getAssociation().toOSString());
            }
            element.setAttribute(ATTR_SEARCH_SUBFOLDERS, new Boolean(this.searchSubfolders()).toString());
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (TransformerException transformerException) {
            exception = transformerException;
        }
        this.abort(MessageFormat.format(InternalSourceLookupMessages.getString("CDirectorySourceLocation.0"), this.getDirectory().toOSString()), exception);
        return null;
    }

    public void initializeFrom(String string) throws CoreException {
        Exception exception = null;
        try {
            Path path;
            Element element = null;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            element = documentBuilder.parse(inputSource).getDocumentElement();
            String string2 = element.getAttribute(ATTR_DIRECTORY);
            if (this.isEmpty(string2)) {
                this.abort(InternalSourceLookupMessages.getString("CDirectorySourceLocation.1"), null);
            } else {
                path = new Path(string2);
                if (path.isValidPath(string2) && path.toFile().isDirectory() && path.toFile().exists()) {
                    this.setDirectory((IPath)path);
                } else {
                    this.abort(MessageFormat.format(InternalSourceLookupMessages.getString("CDirectorySourceLocation.2"), string2), null);
                }
            }
            string2 = element.getAttribute(ATTR_ASSOCIATION);
            if (this.isEmpty(string2)) {
                this.setAssociation(null);
            } else {
                path = new Path(string2);
                if (path.isValidPath(string2)) {
                    this.setAssociation((IPath)path);
                } else {
                    this.setAssociation(null);
                }
            }
            this.setSearchSubfolders(Boolean.valueOf(element.getAttribute(ATTR_SEARCH_SUBFOLDERS)));
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        this.abort(InternalSourceLookupMessages.getString("CDirectorySourceLocation.3"), exception);
    }

    private void abort(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof IDirectorySourceLocation) {
            IPath iPath = ((IDirectorySourceLocation)object).getDirectory();
            IPath iPath2 = ((IDirectorySourceLocation)object).getAssociation();
            if (iPath == null) {
                return false;
            }
            boolean bl = iPath.equals((Object)this.getDirectory());
            if (bl) {
                if (iPath2 == null && this.getAssociation() == null) {
                    return true;
                }
                if (iPath2 != null) {
                    return iPath2.equals((Object)this.getAssociation());
                }
            }
        }
        return false;
    }

    private boolean isPrefix(IPath iPath, IPath iPath2) {
        int n = iPath.segmentCount();
        if (n >= iPath2.segmentCount()) {
            return false;
        }
        String string = iPath.toOSString();
        String string2 = iPath2.removeLastSegments(iPath2.segmentCount() - n).toOSString();
        return string.equalsIgnoreCase(string2);
    }

    public void setSearchForDuplicateFiles(boolean bl) {
        this.fSearchForDuplicateFiles = bl;
    }

    public boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles;
    }

    public boolean searchSubfolders() {
        return this.fSearchSubfolders;
    }

    public void setSearchSubfolders(boolean bl) {
        this.resetFolders();
        this.fSearchSubfolders = bl;
    }

    protected File[] getFolders() {
        if (this.fFolders == null) {
            this.initializeFolders();
        }
        return this.fFolders;
    }

    protected void resetFolders() {
        this.fFolders = null;
    }

    private void initializeFolders() {
        if (this.getDirectory() != null) {
            ArrayList<File> arrayList = new ArrayList<File>();
            File file = this.getDirectory().toFile();
            arrayList.add(file);
            if (this.searchSubfolders()) {
                arrayList.addAll(this.getFileFolders(file));
            }
            this.fFolders = arrayList.toArray(new File[arrayList.size()]);
        }
    }

    private List getFileFolders(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        arrayList.addAll(Arrays.asList(fileArray));
        int n = 0;
        while (n < fileArray.length) {
            arrayList.addAll(this.getFileFolders(fileArray[n]));
            ++n;
        }
        return arrayList;
    }

    public String toString() {
        return this.getDirectory() != null ? this.getDirectory().toOSString() : "";
    }

    public void dispose() {
    }
}

