/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CProjectSourceLocation
implements IProjectSourceLocation {
    private static final String ELEMENT_NAME = "cProjectSourceLocation";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_GENERIC = "generic";
    private IProject fProject;
    private IResource[] fFolders;
    private HashMap fCache = new HashMap(20);
    private HashSet fNotFoundCache = new HashSet(20);
    private boolean fGenerated = true;
    private boolean fSearchForDuplicateFiles = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CProjectSourceLocation() {
    }

    public CProjectSourceLocation(IProject iProject) {
        this.setProject(iProject);
        this.fGenerated = true;
    }

    public CProjectSourceLocation(IProject iProject, boolean bl) {
        this.setProject(iProject);
        this.fGenerated = bl;
    }

    public Object findSourceElement(String string) throws CoreException {
        Object object = null;
        if (!this.isEmpty(string) && this.getProject() != null && !this.notFoundCacheLookup(string)) {
            object = this.cacheLookup(string);
            if (object == null && (object = this.doFindSourceElement(string)) != null) {
                this.cacheSourceElement(string, object);
            }
            if (object == null) {
                this.cacheNotFound(string);
            }
        }
        return object;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this.getProject();
        }
        return null;
    }

    private void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private Object doFindSourceElement(String string) {
        File file = new File(string);
        return file.isAbsolute() ? this.findFileByAbsolutePath(file) : this.findFileByRelativePath(string);
    }

    private Object findFileByAbsolutePath(File file) {
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        if (file.exists()) {
            Path path = new Path(file.getAbsolutePath());
            IFile[] iFileArray = CDebugCorePlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            int n = 0;
            while (n < iFileArray.length) {
                if (iFileArray[n].getProject().equals((Object)this.getProject()) && iFileArray[n].exists()) {
                    if (!this.searchForDuplicateFiles()) {
                        return iFileArray[n];
                    }
                    linkedList.add(iFileArray[n]);
                }
                ++n;
            }
        }
        return linkedList.size() > 0 ? (linkedList.size() == 1 ? linkedList.getFirst() : linkedList) : null;
    }

    private Object findFileByRelativePath(String string) {
        IResource[] iResourceArray = this.getFolders();
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        int n = 0;
        while (n < iResourceArray.length) {
            if (linkedList.size() > 0 && !this.searchForDuplicateFiles()) break;
            IPath iPath = iResourceArray[n].getLocation().append(string);
            File file = new File(iPath.toOSString());
            if (file.exists()) {
                IFile[] iFileArray = CDebugCorePlugin.getWorkspace().getRoot().findFilesForLocation(iPath);
                int n2 = 0;
                while (n2 < iFileArray.length) {
                    if (iFileArray[n2].exists()) {
                        if (!this.searchForDuplicateFiles()) {
                            return iFileArray[n2];
                        }
                        linkedList.add(iFileArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return linkedList.size() > 0 ? (linkedList.size() == 1 ? linkedList.getFirst() : linkedList) : null;
    }

    private Object cacheLookup(String string) {
        return this.fCache.get(string);
    }

    private boolean notFoundCacheLookup(String string) {
        return this.fNotFoundCache.contains(string);
    }

    private void cacheSourceElement(String string, Object object) {
        this.fCache.put(string, object);
    }

    private void cacheNotFound(String string) {
        this.fNotFoundCache.add(string);
    }

    public void dispose() {
        this.fCache.clear();
        this.fNotFoundCache.clear();
    }

    public String getMemento() throws CoreException {
        Document document = null;
        Exception exception = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(ELEMENT_NAME);
            document.appendChild(element);
            element.setAttribute(ATTR_PROJECT, this.getProject().getName());
            element.setAttribute(ATTR_GENERIC, new Boolean(this.isGeneric()).toString());
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (TransformerException transformerException) {
            exception = transformerException;
        }
        this.abort(MessageFormat.format(InternalSourceLookupMessages.getString("CProjectSourceLocation.0"), this.getProject().getName()), exception);
        return null;
    }

    public void initializeFrom(String string) throws CoreException {
        Exception exception = null;
        try {
            Object object;
            Element element = null;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            element = documentBuilder.parse(inputSource).getDocumentElement();
            String string2 = element.getAttribute(ATTR_PROJECT);
            if (this.isEmpty(string2)) {
                this.abort(InternalSourceLookupMessages.getString("CProjectSourceLocation.1"), null);
            } else {
                object = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
                this.setProject((IProject)object);
            }
            object = element.getAttribute(ATTR_GENERIC);
            if (object == null || ((String)object).trim().length() == 0) {
                object = Boolean.FALSE.toString();
            }
            this.setGenerated(((String)object).equals(Boolean.TRUE.toString()));
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        this.abort(InternalSourceLookupMessages.getString("CProjectSourceLocation.2"), exception);
    }

    private void abort(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public boolean isGeneric() {
        return this.fGenerated;
    }

    public void setGenerated(boolean bl) {
        this.fGenerated = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof IProjectSourceLocation && this.getProject() != null) {
            return this.getProject().equals((Object)((IProjectSourceLocation)object).getProject());
        }
        return false;
    }

    private void initializeFolders() {
        final LinkedList<IProject> linkedList = new LinkedList<IProject>();
        if (this.getProject() != null) {
            linkedList.add(this.getProject());
            try {
                this.getProject().accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                        switch (iResourceProxy.getType()) {
                            case 1: {
                                return false;
                            }
                            case 2: {
                                linkedList.addLast(iResourceProxy.requestResource());
                                return true;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException coreException) {}
        }
        this.fFolders = linkedList.toArray(new IResource[linkedList.size()]);
    }

    protected IResource[] getFolders() {
        if (this.fFolders == null) {
            this.initializeFolders();
        }
        return this.fFolders;
    }

    public boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles;
    }

    public void setSearchForDuplicateFiles(boolean bl) {
        this.fCache.clear();
        this.fNotFoundCache.clear();
        this.fSearchForDuplicateFiles = bl;
    }

    public String toString() {
        return this.getProject() != null ? this.fProject.toString() : "";
    }
}

