/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.Disassembly;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceManager
implements ICSourceLocator,
IPersistableSourceLocator,
IAdaptable {
    private ISourceLocator fSourceLocator = null;
    private ILaunch fLaunch = null;
    private CDebugTarget fDebugTarget = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CSourceManager(ISourceLocator iSourceLocator) {
        this.setSourceLocator(iSourceLocator);
    }

    public int getLineNumber(IStackFrame iStackFrame) {
        if (this.getCSourceLocator() != null) {
            return this.getCSourceLocator().getLineNumber(iStackFrame);
        }
        if (iStackFrame instanceof ICStackFrame) {
            return ((ICStackFrame)iStackFrame).getFrameLineNumber();
        }
        return 0;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getSourceLocations() : new ICSourceLocation[]{};
    }

    public void setSourceLocations(ICSourceLocation[] iCSourceLocationArray) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSourceLocations(iCSourceLocationArray);
            CDebugTarget cDebugTarget = this.getDebugTarget();
            if (cDebugTarget != null) {
                Disassembly disassembly = null;
                try {
                    disassembly = (Disassembly)cDebugTarget.getDisassembly();
                }
                catch (DebugException debugException) {}
                if (disassembly != null) {
                    disassembly.reset();
                }
            }
        }
    }

    public boolean contains(IResource iResource) {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().contains(iResource) : false;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.debug.core.model.IPersistableSourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this;
        }
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz5) && this.fSourceLocator instanceof IResourceChangeListener) {
            return this.fSourceLocator;
        }
        return null;
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        Object object = null;
        if (this.getSourceLocator() != null) {
            object = this.getSourceLocator().getSourceElement(iStackFrame);
        }
        return object;
    }

    protected ICSourceLocator getCSourceLocator() {
        if (this.getSourceLocator() instanceof ICSourceLocator) {
            return (ICSourceLocator)this.getSourceLocator();
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        if (this.fSourceLocator != null) {
            return this.fSourceLocator;
        }
        if (this.fLaunch != null) {
            return this.fLaunch.getSourceLocator();
        }
        return null;
    }

    private void setSourceLocator(ISourceLocator iSourceLocator) {
        this.fSourceLocator = iSourceLocator;
    }

    public Object findSourceElement(String string) {
        if (this.getCSourceLocator() != null) {
            return this.getCSourceLocator().findSourceElement(string);
        }
        return null;
    }

    public String getMemento() throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            return this.getPersistableSourceLocator().getMemento();
        }
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeDefaults(iLaunchConfiguration);
        }
    }

    public void initializeFromMemento(String string) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeFromMemento(string);
        }
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        if (this.fSourceLocator instanceof IPersistableSourceLocator) {
            return (IPersistableSourceLocator)this.fSourceLocator;
        }
        return null;
    }

    public IProject getProject() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getProject() : null;
    }

    public void setDebugTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void setSearchForDuplicateFiles(boolean bl) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSearchForDuplicateFiles(bl);
        }
    }

    public boolean searchForDuplicateFiles() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().searchForDuplicateFiles() : false;
    }
}

