/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceUtils {
    private static final String NAME_COMMON_SOURCE_LOCATIONS = "commonSourceLocations";
    private static final String NAME_SOURCE_LOCATION = "sourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";

    public static String getCommonSourceLocationsMemento(ICSourceLocation[] iCSourceLocationArray) {
        Document document = null;
        Exception exception = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(NAME_COMMON_SOURCE_LOCATIONS);
            document.appendChild(element);
            SourceUtils.saveSourceLocations(document, element, iCSourceLocationArray);
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (TransformerException transformerException) {
            exception = transformerException;
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error saving common source settings.", (Throwable)exception));
        return null;
    }

    private static void saveSourceLocations(Document document, Element element, ICSourceLocation[] iCSourceLocationArray) {
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            block3: {
                Element element2 = document.createElement(NAME_SOURCE_LOCATION);
                element2.setAttribute(ATTR_CLASS, iCSourceLocationArray[n].getClass().getName());
                try {
                    element2.setAttribute(ATTR_MEMENTO, iCSourceLocationArray[n].getMemento());
                }
                catch (CoreException coreException) {
                    CDebugCorePlugin.log(coreException);
                    break block3;
                }
                element.appendChild(element2);
            }
            ++n;
        }
    }

    public static ICSourceLocation[] getCommonSourceLocationsFromMemento(String string) {
        ICSourceLocation[] iCSourceLocationArray = new ICSourceLocation[]{};
        if (!SourceUtils.isEmpty(string)) {
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                StringReader stringReader = new StringReader(string);
                InputSource inputSource = new InputSource(stringReader);
                Element element = documentBuilder.parse(inputSource).getDocumentElement();
                if (element.getNodeName().equalsIgnoreCase(NAME_COMMON_SOURCE_LOCATIONS)) {
                    iCSourceLocationArray = SourceUtils.initializeSourceLocations(element);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)parserConfigurationException));
            }
            catch (SAXException sAXException) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)sAXException));
            }
            catch (IOException iOException) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)iOException));
            }
        }
        return iCSourceLocationArray;
    }

    public static ICSourceLocation[] initializeSourceLocations(Element element) {
        LinkedList<ICSourceLocation> linkedList = new LinkedList<ICSourceLocation>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Element element2;
                Node node = nodeList.item(n2);
                short s = node.getNodeType();
                if (s == 1 && (element2 = (Element)node).getNodeName().equalsIgnoreCase(NAME_SOURCE_LOCATION)) {
                    String string = element2.getAttribute(ATTR_CLASS);
                    String string2 = element2.getAttribute(ATTR_MEMENTO);
                    if (string == null || string.trim().length() == 0) {
                        CDebugCorePlugin.log("Unable to restore common source locations - invalid format.");
                    } else {
                        Class clazz = null;
                        try {
                            clazz = CDebugCorePlugin.getDefault().getBundle().loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", string));
                            break block11;
                        }
                        ICSourceLocation iCSourceLocation = null;
                        try {
                            iCSourceLocation = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            CDebugCorePlugin.log("Unable to restore source location: " + illegalAccessException.getMessage());
                            break block11;
                        }
                        catch (InstantiationException instantiationException) {
                            CDebugCorePlugin.log("Unable to restore source location: " + instantiationException.getMessage());
                            break block11;
                        }
                        try {
                            iCSourceLocation.initializeFrom(string2);
                            linkedList.add(iCSourceLocation);
                        }
                        catch (CoreException coreException) {
                            CDebugCorePlugin.log("Unable to restore source location: " + coreException.getMessage());
                        }
                    }
                }
            }
            ++n2;
        }
        return linkedList.toArray(new ICSourceLocation[linkedList.size()]);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

