/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocument;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentPartitioner;
import org.eclipse.debug.internal.ui.views.console.HyperlinkPosition;
import org.eclipse.debug.internal.ui.views.console.InputPartition;
import org.eclipse.debug.internal.ui.views.console.StreamPartition;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ConsoleViewer
extends TextViewer
implements IPropertyChangeListener,
MouseTrackListener,
MouseMoveListener,
MouseListener,
PaintListener,
LineStyleListener,
Listener {
    private Cursor fHandCursor;
    private Cursor fTextCursor;
    private IConsoleHyperlink fHyperLink = null;
    protected InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();
    private boolean fAutoScroll = true;

    public ConsoleViewer(Composite parent) {
        super(parent, ConsoleViewer.getSWTStyles());
        this.getTextWidget().setDoubleClickEnabled(true);
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.ui.console.ConsoleFont"));
        this.getTextWidget().addMouseTrackListener((MouseTrackListener)this);
        this.getTextWidget().addPaintListener((PaintListener)this);
        this.getTextWidget().addLineStyleListener((LineStyleListener)this);
        this.getTextWidget().addListener(2, (Listener)this);
        this.getTextWidget().setTabs(DebugUIPlugin.getDefault().getPluginPreferences().getInt("Console.console_tab_width"));
    }

    private static int getSWTStyles() {
        int styles = 768;
        return styles;
    }

    protected void revealEndOfDocument() {
        if (this.isAutoScroll()) {
            IDocument doc = this.getDocument();
            int lines = doc.getNumberOfLines();
            try {
                int lineEndOffset;
                int lineStartOffset = doc.getLineOffset(lines - 1);
                StyledText widget = this.getTextWidget();
                if (lineStartOffset > 0) {
                    widget.setCaretOffset(lineStartOffset);
                    widget.showSelection();
                }
                if ((lineEndOffset = lineStartOffset + doc.getLineLength(lines - 1)) > 0) {
                    widget.setCaretOffset(lineEndOffset);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void setDocument(IDocument doc) {
        IDocument oldDoc = this.getDocument();
        IDocument document = doc;
        if (oldDoc == null && document == null) {
            return;
        }
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this.fInternalDocumentListener);
            if (oldDoc.equals(document)) {
                document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                return;
            }
        }
        super.setDocument(document);
        if (document != null) {
            this.revealEndOfDocument();
            document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.inColor") || propertyName.equals("org.eclipse.debug.ui.outColor") || propertyName.equals("org.eclipse.debug.ui.errorColor")) {
            this.getTextWidget().redraw();
        } else if (propertyName.equals("org.eclipse.ui.console.ConsoleFont")) {
            this.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.ui.console.ConsoleFont"));
        } else if (propertyName.equals("Console.console_tab_width")) {
            this.getTextWidget().setTabs(DebugUIPlugin.getDefault().getPluginPreferences().getInt("Console.console_tab_width"));
        } else if (propertyName.equals(IInternalDebugUIConstants.PREF_CONSOLE_SCROLL_LOCK)) {
            this.setAutoScroll(!DebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IInternalDebugUIConstants.PREF_CONSOLE_SCROLL_LOCK));
        }
    }

    public void dispose() {
        StyledText control = this.getTextWidget();
        if (control != null) {
            control.removeMouseTrackListener((MouseTrackListener)this);
            control.removePaintListener((PaintListener)this);
        }
        if (this.fHandCursor != null) {
            this.fHandCursor.dispose();
        }
        if (this.fTextCursor != null) {
            this.fTextCursor.dispose();
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        ConsoleDocument doc = (ConsoleDocument)this.getDocument();
        if (doc != null) {
            int length;
            ITypedRegion[] partitions;
            if (doc.isReadOnly()) {
                e.doit = false;
                return;
            }
            IDocumentPartitioner partitioner = doc.getDocumentPartitioner();
            if (partitioner != null && (partitions = partitioner.computePartitioning(length = doc.getLength(), 0)).length != 0) {
                ITypedRegion partition = partitions[partitions.length - 1];
                e.doit = partition.getType().equals(InputPartition.INPUT_PARTITION_TYPE) ? e.start >= partition.getOffset() && e.end <= partition.getLength() + partition.getOffset() : length == e.start;
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
        this.getTextWidget().addMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseExit(MouseEvent e) {
        this.getTextWidget().removeMouseMoveListener((MouseMoveListener)this);
        if (this.fHyperLink != null) {
            this.linkExited(this.fHyperLink);
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        int offset = -1;
        try {
            Point p = new Point(e.x, e.y);
            offset = this.getTextWidget().getOffsetAtLocation(p);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.updateLinks(offset);
    }

    public IConsoleHyperlink getHyperlink(int offset) {
        if (offset >= 0 && this.getDocument() != null) {
            Position[] positions = null;
            try {
                positions = this.getDocument().getPositions(HyperlinkPosition.HYPER_LINK_CATEGORY);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                return null;
            }
            int i = 0;
            while (i < positions.length) {
                Position position = positions[i];
                if (offset >= position.getOffset() && offset <= position.getOffset() + position.getLength()) {
                    return ((HyperlinkPosition)position).getHyperLink();
                }
                ++i;
            }
        }
        return null;
    }

    protected void linkEntered(IConsoleHyperlink link) {
        StyledText control = this.getTextWidget();
        control.setRedraw(false);
        if (this.fHyperLink != null) {
            this.linkExited(this.fHyperLink);
        }
        this.fHyperLink = link;
        this.fHyperLink.linkEntered();
        control.setCursor(this.getHandCursor());
        control.setRedraw(true);
        control.redraw();
        control.addMouseListener((MouseListener)this);
    }

    protected void linkExited(IConsoleHyperlink link) {
        link.linkExited();
        this.fHyperLink = null;
        StyledText control = this.getTextWidget();
        control.setCursor(this.getTextCursor());
        control.redraw();
        control.removeMouseListener((MouseListener)this);
    }

    public void paintControl(PaintEvent e) {
        if (this.fHyperLink != null) {
            IDocument doc = this.getDocument();
            if (doc == null) {
                return;
            }
            ConsoleDocumentPartitioner partitioner = (ConsoleDocumentPartitioner)doc.getDocumentPartitioner();
            if (partitioner == null) {
                return;
            }
            IRegion linkRegion = partitioner.getRegion(this.fHyperLink);
            if (linkRegion != null) {
                int start = linkRegion.getOffset();
                int end = start + linkRegion.getLength();
                IConsoleColorProvider colorProvider = partitioner.getColorProvider();
                try {
                    ITypedRegion partition = doc.getPartition(start);
                    Color fontColor = e.gc.getForeground();
                    if (partition instanceof StreamPartition) {
                        StreamPartition streamPartition = (StreamPartition)partition;
                        fontColor = colorProvider.getColor(streamPartition.getStreamIdentifier());
                    }
                    int startLine = doc.getLineOfOffset(start);
                    int endLine = doc.getLineOfOffset(end);
                    int i = startLine;
                    while (i <= endLine) {
                        IRegion lineRegion = doc.getLineInformation(i);
                        int lineStart = lineRegion.getOffset();
                        int lineEnd = lineStart + lineRegion.getLength();
                        Color color = e.gc.getForeground();
                        e.gc.setForeground(fontColor);
                        if (lineStart < end) {
                            lineStart = Math.max(start, lineStart);
                            lineEnd = Math.min(end, lineEnd);
                            Point p1 = this.getTextWidget().getLocationAtOffset(lineStart);
                            Point p2 = this.getTextWidget().getLocationAtOffset(lineEnd);
                            FontMetrics metrics = e.gc.getFontMetrics();
                            int height = metrics.getHeight();
                            e.gc.drawLine(p1.x, p1.y + height, p2.x, p2.y + height);
                        }
                        e.gc.setForeground(color);
                        ++i;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    protected Cursor getHandCursor() {
        if (this.fHandCursor == null) {
            this.fHandCursor = new Cursor((Device)DebugUIPlugin.getStandardDisplay(), 21);
        }
        return this.fHandCursor;
    }

    protected Cursor getTextCursor() {
        if (this.fTextCursor == null) {
            this.fTextCursor = new Cursor((Device)DebugUIPlugin.getStandardDisplay(), 19);
        }
        return this.fTextCursor;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        String selection;
        if (this.fHyperLink != null && (selection = this.getTextWidget().getSelectionText()).length() <= 0 && e.button == 1) {
            this.fHyperLink.linkActivated();
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        ConsoleDocumentPartitioner partitioner;
        IDocument document = this.getDocument();
        if (document != null && (partitioner = (ConsoleDocumentPartitioner)document.getDocumentPartitioner()) != null) {
            IConsoleColorProvider colorProvider = partitioner.getColorProvider();
            ITypedRegion[] regions = partitioner.computePartitioning(event.lineOffset, event.lineOffset + event.lineText.length());
            StyleRange[] styles = new StyleRange[regions.length];
            int i = 0;
            while (i < regions.length) {
                StreamPartition partition = (StreamPartition)regions[i];
                Color color = colorProvider.getColor(partition.getStreamIdentifier());
                styles[i] = new StyleRange(partition.getOffset(), partition.getLength(), color, null);
                ++i;
            }
            event.styles = styles;
        }
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void handleEvent(Event event) {
        int offset = this.getTextWidget().getCaretOffset();
        this.updateLinks(offset);
    }

    protected void updateLinks(int offset) {
        IConsoleHyperlink link;
        if (offset >= 0 && (link = this.getHyperlink(offset)) != null) {
            if (link.equals(this.fHyperLink)) {
                return;
            }
            this.linkEntered(link);
            return;
        }
        if (this.fHyperLink != null) {
            this.linkExited(this.fHyperLink);
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            ConsoleDocument doc = (ConsoleDocument)ConsoleViewer.this.getDocument();
            if (doc == null) {
                ConsoleViewer.this.getTextWidget().setEditable(false);
                return;
            }
            ConsoleViewer.this.getTextWidget().setEditable(!doc.isReadOnly());
            ConsoleViewer.this.revealEndOfDocument();
        }
    }
}

