/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class FormatColumnAction
extends Action {
    private static final String PREFIX = "FormatColumnAction.";
    private static final String BYTE = "FormatColumnAction.byte";
    private static final String BYTES = "FormatColumnAction.bytes";
    ITableMemoryViewTab fViewTab;
    int fNumBytesPerCol;

    public FormatColumnAction(int numBytes, ITableMemoryViewTab viewTab) {
        String label = numBytes > 1 ? String.valueOf(String.valueOf(numBytes)) + " " + DebugUIMessages.getString(BYTES) : String.valueOf(String.valueOf(numBytes)) + " " + DebugUIMessages.getString(BYTE);
        super.setText(label);
        this.fViewTab = viewTab;
        if (numBytes == this.fViewTab.getColumnSize()) {
            this.setChecked(true);
        }
        this.fNumBytesPerCol = numBytes;
        WorkbenchHelp.setHelp((IAction)this, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".FormatColumnAction_context"));
    }

    public void run() {
        this.fViewTab.format(this.fViewTab.getBytesPerLine(), this.fNumBytesPerCol);
    }

    public int getColumnSize() {
        return this.fNumBytesPerCol;
    }
}

