/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.operations;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class Variable
extends Expression
implements PathComponent {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;
    static final String PSUEDOVARNAMESPACE = "http://xml.apache.org/xalan/psuedovar";

    public int getAnalysisBits() {
        Expression expression;
        XPath xPath;
        ElemVariable elemVariable = this.getElemVariable();
        if (null != elemVariable && null != (xPath = elemVariable.getSelect()) && null != (expression = xPath.getExpression()) && expression instanceof PathComponent) {
            return ((PathComponent)((Object)expression)).getAnalysisBits();
        }
        return 0x4000000;
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean getGlobal() {
        return this.m_isGlobal;
    }

    public boolean isPsuedoVarRef() {
        String string = this.m_qname.getNamespaceURI();
        return null != string && string.equals(PSUEDOVARNAMESPACE) && this.m_qname.getLocalName().startsWith("#");
    }

    public boolean isStableNumber() {
        return true;
    }

    public void setIndex(int n2) {
        this.m_index = n2;
    }

    public void setIsGlobal(boolean bl2) {
        this.m_isGlobal = bl2;
    }

    public void fixupVariables(Vector vector, int n2) {
        Serializable serializable;
        this.m_fixUpWasCalled = true;
        int n3 = vector.size();
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            serializable = (QName)vector.elementAt(i2);
            if (!serializable.equals(this.m_qname)) continue;
            if (i2 < n2) {
                this.m_isGlobal = true;
                this.m_index = i2;
            } else {
                this.m_index = i2 - n2;
            }
            return;
        }
        String string = XSLMessages.createXPATHMessage("ER_COULD_NOT_FIND_VAR", new Object[]{this.m_qname.toString()});
        serializable = new TransformerException(string, this);
        throw new WrappedRuntimeException((Exception)serializable);
    }

    public ElemVariable getElemVariable() {
        ExpressionNode expressionNode = this.getExpressionOwner();
        if (null != expressionNode && expressionNode instanceof ElemTemplateElement) {
            ElemVariable elemVariable;
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)expressionNode;
            if (!(elemTemplateElement instanceof Stylesheet)) {
                while (!(elemTemplateElement.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement elemTemplateElement2 = elemTemplateElement;
                    while (null != (elemTemplateElement = elemTemplateElement.getPreviousSiblingElem())) {
                        if (!(elemTemplateElement instanceof ElemVariable) || !(elemVariable = (ElemVariable)elemTemplateElement).getName().equals(this.m_qname)) continue;
                        return elemVariable;
                    }
                    elemTemplateElement = elemTemplateElement2.getParentElem();
                }
            }
            if (null != (elemVariable = elemTemplateElement.getStylesheetRoot().getVariableOrParamComposed(this.m_qname))) {
                return elemVariable;
            }
        }
        return null;
    }

    public QName getQName() {
        return this.m_qname;
    }

    public void setQName(QName qName) {
        this.m_qname = qName;
    }

    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        if (!this.m_qname.equals(((Variable)expression).m_qname)) {
            return false;
        }
        return this.getElemVariable() == ((Variable)expression).getElemVariable();
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitVariableRef(expressionOwner, this);
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject execute(XPathContext xPathContext, boolean bl2) throws TransformerException {
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        if (this.m_fixUpWasCalled) {
            XObject xObject = this.m_isGlobal ? xPathContext.getVarStack().getGlobalVariable(xPathContext, this.m_index, bl2) : xPathContext.getVarStack().getLocalVariable(xPathContext, this.m_index, bl2);
            if (null == xObject) {
                this.warn(xPathContext, "WG_ILLEGAL_VARIABLE_REFERENCE", new Object[]{this.m_qname.getLocalPart()});
                xObject = new XNodeSet(xPathContext.getDTMManager());
            }
            return xObject;
        }
        Variable variable = this;
        synchronized (variable) {
            ElemVariable elemVariable = this.getElemVariable();
            if (null != elemVariable) {
                this.m_index = elemVariable.getIndex();
                this.m_isGlobal = elemVariable.getIsTopLevel();
                this.m_fixUpWasCalled = true;
                return this.execute(xPathContext);
            }
        }
        throw new TransformerException(XSLMessages.createXPATHMessage("ER_VAR_NOT_RESOLVABLE", new Object[]{this.m_qname.toString()}));
    }
}

