/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import sun.awt.font.BidiUtils;
import sun.awt.font.Decoration;
import sun.awt.font.TextLineComponent;

public final class GraphicComponent
implements TextLineComponent,
Decoration.Label {
    public static final float GRAPHIC_LEADING = 2.0f;
    private GraphicAttribute graphic;
    private int graphicCount;
    private int[] charsLtoV;
    private byte[] levels;
    private Rectangle2D visualBounds = null;
    private float graphicAdvance;
    private LineMetrics lineMetrics;
    private Decoration decorator;

    public float getItalicAngle() {
        return 0.0f;
    }

    public int getNumCharacters() {
        return this.graphicCount;
    }

    public int getNumJustificationInfos() {
        return 0;
    }

    public float getCharAdvance(int n2) {
        return this.graphicAdvance;
    }

    public float getCharX(int n2) {
        int n3 = this.charsLtoV == null ? n2 : this.charsLtoV[n2];
        return this.graphicAdvance * (float)n3;
    }

    public float getCharY(int n2) {
        return 0.0f;
    }

    public boolean caretAtOffsetIsValid(int n2) {
        return true;
    }

    public int getLineBreakIndex(int n2, float f2) {
        int n3 = (int)(f2 / this.graphicAdvance);
        if (n3 > this.graphicCount - n2) {
            n3 = this.graphicCount - n2;
        }
        return n3;
    }

    public float getAdvanceBetween(int n2, int n3) {
        return this.graphicAdvance * (float)(n3 - n2);
    }

    private void initLocalOrdering(int[] nArray, byte[] byArray, int n2, int n3) {
        this.graphicCount = n3 - n2;
        this.charsLtoV = nArray == null || nArray.length == this.graphicCount ? nArray : BidiUtils.createNormalizedMap(nArray, byArray, n2, n3);
        if (byArray == null || byArray.length == this.graphicCount) {
            this.levels = byArray;
        } else {
            this.levels = new byte[this.graphicCount];
            System.arraycopy(byArray, n2, this.levels, 0, this.graphicCount);
        }
    }

    public void draw(Graphics2D graphics2D, float f2, float f3) {
        this.decorator.drawTextAndDecorations(this, graphics2D, f2, f3);
    }

    public void handleDraw(Graphics2D graphics2D, float f2, float f3) {
        for (int i2 = 0; i2 < this.graphicCount; ++i2) {
            this.graphic.draw(graphics2D, f2, f3);
            f2 += this.graphicAdvance;
        }
    }

    public Shape getOutline(float f2, float f3) {
        return this.decorator.getOutline(this, f2, f3);
    }

    public Shape handleGetOutline(float f2, float f3) {
        return this.getVisualBounds();
    }

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n2, int n3, int n4) {
    }

    public LineMetrics getLineMetrics() {
        return this.lineMetrics;
    }

    public Rectangle2D getLogicalBounds() {
        float f2 = 0.0f;
        float f3 = -this.lineMetrics.getAscent();
        float f4 = this.graphicAdvance * (float)this.graphicCount;
        float f5 = this.lineMetrics.getDescent() - f3;
        return new Rectangle2D.Float(f2, f3, f4, f5);
    }

    public Rectangle2D getVisualBounds() {
        if (this.visualBounds == null) {
            this.visualBounds = this.decorator.getVisualBounds(this);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.visualBounds);
        return float_;
    }

    public Rectangle2D handleGetVisualBounds() {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        float f2 = (float)rectangle2D.getWidth() + this.graphicAdvance * (float)(this.graphicCount - 1);
        return new Rectangle2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), f2, (float)rectangle2D.getHeight());
    }

    public Rectangle2D getCharVisualBounds(int n2) {
        return this.decorator.getCharVisualBounds(this, n2);
    }

    public Rectangle2D handleGetCharVisualBounds(int n2) {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(rectangle2D);
        float_.x += this.graphicAdvance * (float)n2;
        return float_;
    }

    public String toString() {
        return "[graphic=" + this.graphic + ":count=" + this.getNumCharacters() + "]";
    }

    static int access$000(GraphicComponent graphicComponent) {
        return graphicComponent.graphicCount;
    }

    private GraphicComponent(GraphicComponent graphicComponent, int n2, int n3, int n4) {
        this.graphic = graphicComponent.graphic;
        this.graphicAdvance = graphicComponent.graphicAdvance;
        this.decorator = graphicComponent.decorator;
        this.lineMetrics = new GraphicLineMetrics(this, null);
        int[] nArray = null;
        byte[] byArray = null;
        if (n4 == 2) {
            nArray = graphicComponent.charsLtoV;
            byArray = graphicComponent.levels;
        } else if (n4 == 0 || n4 == 1) {
            n3 -= n2;
            n2 = 0;
            if (n4 == 1) {
                nArray = new int[n3];
                byArray = new byte[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArray[i2] = n3 - i2 - 1;
                    byArray[i2] = 1;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid direction flag");
        }
        this.initLocalOrdering(nArray, byArray, n2, n3);
    }

    public TextLineComponent getSubset(int n2, int n3, int n4) {
        if (n2 < 0 || n3 > this.graphicCount || n2 >= n3) {
            throw new IllegalArgumentException("Invalid range.  start=" + n2 + "; limit=" + n3);
        }
        if (n2 == 0 && n3 == this.graphicCount && n4 == 2) {
            return this;
        }
        return new GraphicComponent(this, n2, n3, n4);
    }

    public TextLineComponent applyJustificationDeltas(float[] fArray, int n2, boolean[] blArray) {
        return this;
    }

    static GraphicAttribute access$100(GraphicComponent graphicComponent) {
        return graphicComponent.graphic;
    }

    public GraphicComponent(GraphicAttribute graphicAttribute, Decoration decoration, int[] nArray, byte[] byArray, int n2, int n3) {
        if (n3 <= n2) {
            throw new IllegalArgumentException("0 or negative length in GraphicComponent");
        }
        this.graphic = graphicAttribute;
        this.graphicAdvance = graphicAttribute.getAdvance();
        this.lineMetrics = new GraphicLineMetrics(this, null);
        this.decorator = decoration;
        this.initLocalOrdering(nArray, byArray, n2, n3);
    }

    static class 1 {
    }

    private final class GraphicLineMetrics
    extends LineMetrics {
        private final GraphicComponent this$0;

        public float getAscent() {
            return GraphicComponent.access$100(this.this$0).getAscent();
        }

        public float getDescent() {
            return GraphicComponent.access$100(this.this$0).getDescent();
        }

        public float getHeight() {
            return this.getAscent() + this.getDescent() + this.getLeading();
        }

        public float getLeading() {
            return 2.0f;
        }

        public float getStrikethroughOffset() {
            return -(this.getAscent() / 2.0f);
        }

        public float getStrikethroughThickness() {
            return this.getAscent() / 12.0f;
        }

        public float getUnderlineOffset() {
            return this.getDescent() / 3.0f;
        }

        public float getUnderlineThickness() {
            return this.getAscent() / 12.0f;
        }

        public int getBaselineIndex() {
            return GraphicComponent.access$100(this.this$0).getAlignment();
        }

        public int getNumChars() {
            return GraphicComponent.access$000(this.this$0);
        }

        public float[] getBaselineOffsets() {
            return new float[]{0.0f, -7.0f, -14.0f};
        }

        private GraphicLineMetrics(GraphicComponent graphicComponent) {
            this.this$0 = graphicComponent;
        }

        GraphicLineMetrics(GraphicComponent graphicComponent, 1 var2_2) {
            this(graphicComponent);
        }
    }
}

