/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.Serializable;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private static final int maxFirstComponent = 2;
    private static final int maxSecondComponent = 39;
    private int[] components;
    private int componentLen;
    private volatile transient String stringForm;
    private static final int allocationQuantum = 5;

    public int hashCode() {
        int n2 = this.componentLen;
        for (int i2 = 0; i2 < this.componentLen; ++i2) {
            n2 += this.components[i2] * 37;
        }
        return n2;
    }

    public ObjectIdentifier(int[] nArray) throws IOException {
        if (nArray.length >= 1 && (nArray[0] < 0 || nArray[0] > 2)) {
            throw new IOException("First oid component is invalid ");
        }
        if (nArray.length >= 2 && (nArray[1] < 0 || nArray[1] > 39)) {
            throw new IOException("Second oid component is invalid ");
        }
        this.components = (int[])nArray.clone();
        this.componentLen = nArray.length;
    }

    private ObjectIdentifier(int[] nArray, boolean bl2) {
        this.components = nArray;
        this.componentLen = nArray.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)object;
        if (this.componentLen != objectIdentifier.componentLen) {
            return false;
        }
        for (int i2 = 0; i2 < this.componentLen; ++i2) {
            if (this.components[i2] == objectIdentifier.components[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = this.stringForm;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer(this.componentLen * 4);
            for (int i2 = 0; i2 < this.componentLen; ++i2) {
                if (i2 != 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.components[i2]);
            }
            this.stringForm = string = stringBuffer.toString();
        }
        return string;
    }

    public ObjectIdentifier(String string) throws IOException {
        int n2 = 46;
        int n3 = 0;
        int n4 = 0;
        this.componentLen = 0;
        while ((n4 = string.indexOf(n2, n3)) != -1) {
            n3 = n4 + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        n3 = 0;
        int n5 = 0;
        String string2 = null;
        while ((n4 = string.indexOf(n2, n3)) != -1) {
            string2 = string.substring(n3, n4);
            this.components[n5++] = Integer.valueOf(string2);
            if (this.components[n5++] < 0) {
                throw new IOException("oid components must be nonnegative");
            }
            n3 = n4 + 1;
        }
        string2 = string.substring(n3);
        this.components[n5] = Integer.valueOf(string2);
        if (this.components[0] < 0 || this.components[0] > 2) {
            throw new IOException("First oid component is invalid ");
        }
        if (this.components[1] < 0 || this.components[1] > 39) {
            throw new IOException("Second oid component is invalid ");
        }
        this.stringForm = string;
    }

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        this.initFromEncoding(new DerInputStream(derInputBuffer), 0);
    }

    private static int getComponent(DerInputStream derInputStream) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n2 <<= 7;
            int n3 = derInputStream.getByte();
            n2 |= n3 & 0x7F;
            if ((n3 & 0x80) != 0) continue;
            return n2;
        }
        throw new IOException("X509.OID, component value too big");
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.getByte();
        if (by != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")");
        }
        int n2 = derInputStream.available() - derInputStream.getLength() - 1;
        if (n2 < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(derInputStream, n2);
    }

    private void initFromEncoding(DerInputStream derInputStream, int n2) throws IOException {
        boolean bl2 = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (derInputStream.available() > n2) {
            int n3 = ObjectIdentifier.getComponent(derInputStream);
            if (n3 < 0) {
                throw new IOException("X509.ObjectIdentifier() -- component values must be nonnegative");
            }
            if (bl2) {
                int n4 = n3 < 40 ? 0 : (n3 < 80 ? 1 : 2);
                int n5 = n3 - n4 * 40;
                if (n5 > 39) {
                    throw new IOException("X509.ObjectIdentifier() -- Invalid second component");
                }
                this.components[0] = n4;
                this.components[1] = n5;
                this.componentLen = 2;
                bl2 = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] nArray = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, nArray, 0, this.components.length);
                this.components = nArray;
            }
            this.components[this.componentLen++] = n3;
        }
        if (derInputStream.available() != n2) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(this.components[0] * 40 + this.components[1]);
        for (int i2 = 2; i2 < this.componentLen; ++i2) {
            ObjectIdentifier.putComponent(derOutputStream2, this.components[i2]);
        }
        derOutputStream.write((byte)6, derOutputStream2);
    }

    private static void putComponent(DerOutputStream derOutputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[4];
        for (n3 = 0; n3 < 4; ++n3) {
            byArray[n3] = (byte)(n2 & 0x7F);
            if ((n2 >>>= 7) == 0) break;
        }
        while (n3 > 0) {
            derOutputStream.write(byArray[n3] | 0x80);
            --n3;
        }
        derOutputStream.write(byArray[0]);
    }

    public boolean equals(ObjectIdentifier objectIdentifier) {
        return this.equals((Object)objectIdentifier);
    }

    public boolean precedes(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this || this.componentLen < objectIdentifier.componentLen) {
            return false;
        }
        if (objectIdentifier.componentLen < this.componentLen) {
            return true;
        }
        for (int i2 = 0; i2 < this.componentLen; ++i2) {
            if (objectIdentifier.components[i2] >= this.components[i2]) continue;
            return true;
        }
        return false;
    }

    public static ObjectIdentifier newInternal(int[] nArray) {
        return new ObjectIdentifier(nArray, true);
    }
}

