/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.tools;

import com.palmsource.eclipse.palmoscore.targets.IPODPreferences;
import com.palmsource.eclipse.palmoscore.targets.ITargetContributor;
import com.palmsource.eclipse.palmoscore.targets.ITargetEnvironment;
import com.palmsource.eclipse.palmoscore.targets.TargetEnvironment;
import com.palmsource.eclipse.tools.ToolsPlugin;

public class PalmOSDeviceTarget
implements ITargetContributor {
    public ITargetEnvironment makeDefaultTarget(String string) {
        TargetEnvironment targetEnvironment = this.newDeviceTarget();
        if (string.startsWith("serial")) {
            IPODPreferences iPODPreferences = targetEnvironment.getPODPreferences();
            iPODPreferences.setCommunicationMethod("serial");
            iPODPreferences.setSerialPort(this.getSerialPort(string));
        }
        if (string != null) {
            targetEnvironment.setName(ToolsPlugin.getResourceString("Target." + string + ".name"));
        }
        targetEnvironment.store();
        return targetEnvironment;
    }

    public ITargetEnvironment makeNewTarget(String string) {
        if (!string.equals("device")) {
            return null;
        }
        TargetEnvironment targetEnvironment = this.newDeviceTarget();
        targetEnvironment.store();
        return targetEnvironment;
    }

    private TargetEnvironment newDeviceTarget() {
        TargetEnvironment targetEnvironment = new TargetEnvironment("device");
        IPODPreferences iPODPreferences = targetEnvironment.getPODPreferences();
        iPODPreferences.setCommunicationMethod("usb");
        iPODPreferences.setUSBLibrary(ToolsPlugin.getDefault().getUSBLibrary());
        return targetEnvironment;
    }

    private String getSerialPort(String string) {
        String string2 = "COM";
        String[] stringArray = string.split("serial*");
        if (stringArray.length == 2) {
            string2 = String.valueOf(string2) + stringArray[1];
        }
        return string2;
    }
}

