/******************************************************************************
 * This program is subject to copyright protection in accordance with the
 * applicable law and is also subject to the Developer Download Software
 * License Agreement, ("License Agreement") agreed to by the licensee prior to
 * download and receipt of this program.  It must only be used for the purpose
 * of developing software that is compatible with the CLI handheld computer.
 * It must not, except as permitted in the License Agreement, by any means or
 * in any form be reproduced, distributed or lent.  Moreover, no part of the
 * program may be used, viewed, printed, disassembled or otherwise interfered
 * with in any form, except where allowed by the License Agreement, without the
 * express written consent of the copyright holder.
 *
 * THIS PROGRAM IS FURTHER PROVIDED "AS IS" WITH NO WARRANTY OF ANY KIND AND
 * THE COPYRIGHT HOLDER HEREBY DISCLAIMS ALL WARRANTIES, EXPRESS AND IMPLIED AS
 * TO THE PROGRAM.
 *
 * Copyright (c) 2002-2003 Sony Electronics Inc.
 * Some portions copyright (c) 1999 Palm Computing, Inc. or its subsidiaries.
 * All Rights Reserved.
 *
 * File: SilkSample.h
 *
 *****************************************************************************/


#ifndef SILKSAMPLE_H
#define SILKSAMPLE_H

#include <PalmOS.h>



/* CONSTANTS ----------------------------------------------------------- */

#define appFileCreator 'STRT'
#define appVersionNum 0x01
#define appPrefID 0x00
#define appPrefVersionNum 0x01

// minimum OS version supported
// NOTE: OS 4.0 devices incorrectly report the stage number as
// sysROMStageDevelopment (0) instead of sysROMStageRelease (3)
#define MIN_OS_VERSION sysMakeROMVersion(4, 0, 0, 0, 0)

// these values are no longer defined in SonySilkLib.h
#ifndef stdSilkHeight
#define stdSilkHeight   (65)
#define stdStatusHeight (15)
#endif



/* STRUCTURES ---------------------------------------------------------- */

typedef struct
{
    UInt16 refNum;
    Boolean resizeEnabled;

    // The resized flag is a bit redundant, since resizeAmount == 0 could
    // be used as a substitute.  Doing so, however, would make cases where
    // the silkscreen is resized and restored--such that the net change is
    // 0--a bit more difficult to handle.
    Boolean resized;
    PointType resizeAmount;
    FormType* curResizableFormP;
} SilkStateType;



/* GLOBALS ------------------------------------------------------------- */

extern UInt16 gHRRefNum;

extern SilkStateType gSilkState;
extern UInt32 gSilkVerNum;



/* FUNCTION PROTOTYPES ------------------------------------------------- */

UInt16 GetSilkPos(UInt16 silkRefNum);
Err EnableSilkResize(UInt16 silkRefNum, UInt16 state);
Err ResizeSilk(UInt16 silkRefNum, UInt16 state);
void ResizeWindowToDisplay(WinHandle winH, Int16* dxP, Int16* dyP);

void* GetObjectPtr(const FormType* frmP, UInt16 objectID);
UInt16 GetGSIIndex(const FormType* frmP);
void MoveFormObject(FormType* frmP, UInt16 id, Coord dx, Coord dy);

Boolean DoMenuCommand(UInt16 command);

Boolean MainFormHandleEvent(EventType* eventP);
Boolean SecondFormHandleEvent(EventType* eventP);
Boolean ThirdFormHandleEvent(EventType* eventP);


#endif // SILKSAMPLE_H
