/******************************************************************************
 * This program is subject to copyright protection in accordance with the
 * applicable law and is also subject to the Developer Download Software
 * License Agreement, ("License Agreement") agreed to by the licensee prior to
 * download and receipt of this program.  It must only be used for the purpose
 * of developing software that is compatible with the CLI handheld computer.
 * It must not, except as permitted in the License Agreement, by any means or
 * in any form be reproduced, distributed or lent.  Moreover, no part of the
 * program may be used, viewed, printed, disassembled or otherwise interfered
 * with in any form, except where allowed by the License Agreement, without the
 * express written consent of the copyright holder.
 *
 * THIS PROGRAM IS FURTHER PROVIDED "AS IS" WITH NO WARRANTY OF ANY KIND AND
 * THE COPYRIGHT HOLDER HEREBY DISCLAIMS ALL WARRANTIES, EXPRESS AND IMPLIED AS
 * TO THE PROGRAM.
 *
 * Copyright (c) 2002-2003 Sony Electronics Inc.
 * Some portions copyright (c) 1999 Palm Computing, Inc. or its subsidiaries.
 * All Rights Reserved.
 *
 * File: ThirdForm.cpp
 *
 *****************************************************************************/


/** ThirdForm -- a third Form for the SilkSample project;
  *              this Form does not supports resizing the virtual
  *                silkscreen area and demonstrates how to enable/disable
  *                silkescreen resizing for specific Forms
  */

#include <PalmOS.h>
#include <SonyCLIE.h>

#include "SilkSample.h"
#include "SilkSampleRsc.h"



/* FUNCTION DEFINITIONS ------------------------------------------------ */

/***********************************************************************
 * FUNCTION:    PrvThirdFormInit
 * DESCRIPTION: This routine initializes the Third Form.
 * PARAMETERS:  IN/OUT frmP - pointer to the Third Form.
 * RETURNS:
 ***********************************************************************/
static void PrvThirdFormInit(FormType* frmP)
{
    // disable silkscreen resizing for this Form
    if (gSilkState.refNum != sysInvalidRefNum && gSilkState.resizeEnabled)
    {
        // resize the silkscreen to the desired position
        (void) ResizeSilk(gSilkState.refNum, vskResizeMax);

        if (EnableSilkResize(gSilkState.refNum, vskResizeDisable) == errNone)
        {
            gSilkState.resizeEnabled = false;
        }

        gSilkState.curResizableFormP = NULL;
    }

    // this Form does not handle silkscreen resizing, so its widgets do not
    // need to be repositioned dynamically

    // initialize Form selection pushbuttons
    FrmSetControlGroupSelection(frmP, ThirdGroupID, ThirdGoto3PushButton);
}


/***********************************************************************
 * FUNCTION:    ThirdFormHandleEvent
 * DESCRIPTION: This routine is the event handler for the Third Form
 * PARAMETERS:  IN eventP - a pointer to an EventType structure
 * RETURNS:     true if the event has been handled and should not be passed
 *              to a higher level handler.
 ***********************************************************************/
Boolean ThirdFormHandleEvent(EventType* eventP)
{
    Boolean handled = false;

    FormType* frmP;

    switch (eventP->eType)
    {
        case menuEvent:
            handled = DoMenuCommand(eventP->data.menu.itemID);
            break;

        case frmOpenEvent:
            frmP = FrmGetActiveForm();

            // PrvThirdFormInit initializes the Form bounds and widget
            // positions
            PrvThirdFormInit(frmP);
            FrmDrawForm(frmP);

            handled = true;
            break;

        case frmUpdateEvent:
        case winEnterEvent:
            // this Form does not handle silkscreen resizing, so its
            // widgets do not need to be repositioned dynamically
            break;

        case ctlSelectEvent:
            handled = true;
            switch (eventP->data.ctlSelect.controlID)
            {
                case ThirdGoto1PushButton:
                    FrmGotoForm(MainForm);
                    break;

                case ThirdGoto2PushButton:
                    FrmGotoForm(SecondForm);
                    break;

                case ThirdGoto3PushButton:
                    break;

                default:
                    handled = false;
                    break;
            }
            break;

        default:
            break;
    }

    return handled;
}
