#include <stdint.h>
#include <string.h>//for NULL

//from mame used for printing apicalls
typedef struct{
	const char* name;
	uint16_t trap;
}mameList;

mameList traps[] = {
   {"MemInit", 0xA000},
   {"MemInitHeapTable", 0xA001},
   {"MemStoreInit", 0xA002},
   {"MemCardFormat", 0xA003},
   {"MemCardInfo", 0xA004},
   {"MemStoreInfo", 0xA005},
   {"MemStoreSetInfo", 0xA006},
   {"MemNumHeaps", 0xA007},
   {"MemNumRAMHeaps", 0xA008},
   {"MemHeapID", 0xA009},
   {"MemHeapPtr", 0xA00A},
   {"MemHeapFreeBytes", 0xA00B},
   {"MemHeapSize", 0xA00C},
   {"MemHeapFlags", 0xA00D},
   {"MemHeapCompact", 0xA00E},
   {"MemHeapInit", 0xA00F},
   {"MemHeapFreeByOwnerID", 0xA010},
   {"MemChunkNew", 0xA011},
   {"MemChunkFree", 0xA012},
   {"MemPtrNew", 0xA013},
   {"MemPtrRecoverHandle", 0xA014},
   {"MemPtrFlags", 0xA015},
   {"MemPtrSize", 0xA016},
   {"MemPtrOwner", 0xA017},
   {"MemPtrHeapID", 0xA018},
   {"MemPtrCardNo", 0xA019},
   {"MemPtrToLocalID", 0xA01A},
   {"MemPtrSetOwner", 0xA01B},
   {"MemPtrResize", 0xA01C},
   {"MemPtrResetLock", 0xA01D},
   {"MemHandleNew", 0xA01E},
   {"MemHandleLockCount", 0xA01F},
   {"MemHandleToLocalID", 0xA020},
   {"MemHandleLock", 0xA021},
   {"MemHandleUnlock", 0xA022},
   {"MemLocalIDToGlobal", 0xA023},
   {"MemLocalIDKind", 0xA024},
   {"MemLocalIDToPtr", 0xA025},
   {"MemMove", 0xA026},
   {"MemSet", 0xA027},
   {"MemStoreSearch", 0xA028},
   {"SysReserved10Trap1", 0xA029},
   {"MemKernelInit", 0xA02A},
   {"MemHandleFree", 0xA02B},
   {"MemHandleFlags", 0xA02C},
   {"MemHandleSize", 0xA02D},
   {"MemHandleOwner", 0xA02E},
   {"MemHandleHeapID", 0xA02F},
   {"MemHandleDataStorage", 0xA030},
   {"MemHandleCardNo", 0xA031},
   {"MemHandleSetOwner", 0xA032},
   {"MemHandleResize", 0xA033},
   {"MemHandleResetLock", 0xA034},
   {"MemPtrUnlock", 0xA035},
   {"MemLocalIDToLockedPtr", 0xA036},
   {"MemSetDebugMode", 0xA037},
   {"MemHeapScramble", 0xA038},
   {"MemHeapCheck", 0xA039},
   {"MemNumCards", 0xA03A},
   {"MemDebugMode", 0xA03B},
   {"MemSemaphoreReserve", 0xA03C},
   {"MemSemaphoreRelease", 0xA03D},
   {"MemHeapDynamic", 0xA03E},
   {"MemNVParams", 0xA03F},
   {"DmInit", 0xA040},
   {"DmCreateDatabase", 0xA041},
   {"DmDeleteDatabase", 0xA042},
   {"DmNumDatabases", 0xA043},
   {"DmGetDatabase", 0xA044},
   {"DmFindDatabase", 0xA045},
   {"DmDatabaseInfo", 0xA046},
   {"DmSetDatabaseInfo", 0xA047},
   {"DmDatabaseSize", 0xA048},
   {"DmOpenDatabase", 0xA049},
   {"DmCloseDatabase", 0xA04A},
   {"DmNextOpenDatabase", 0xA04B},
   {"DmOpenDatabaseInfo", 0xA04C},
   {"DmResetRecordStates", 0xA04D},
   {"DmGetLastErr", 0xA04E},
   {"DmNumRecords", 0xA04F},
   {"DmRecordInfo", 0xA050},
   {"DmSetRecordInfo", 0xA051},
   {"DmAttachRecord", 0xA052},
   {"DmDetachRecord", 0xA053},
   {"DmMoveRecord", 0xA054},
   {"DmNewRecord", 0xA055},
   {"DmRemoveRecord", 0xA056},
   {"DmDeleteRecord", 0xA057},
   {"DmArchiveRecord", 0xA058},
   {"DmNewHandle", 0xA059},
   {"DmRemoveSecretRecords", 0xA05A},
   {"DmQueryRecord", 0xA05B},
   {"DmGetRecord", 0xA05C},
   {"DmResizeRecord", 0xA05D},
   {"DmReleaseRecord", 0xA05E},
   {"DmGetResource", 0xA05F},
   {"DmGet1Resource", 0xA060},
   {"DmReleaseResource", 0xA061},
   {"DmResizeResource", 0xA062},
   {"DmNextOpenResDatabase", 0xA063},
   {"DmFindResourceType", 0xA064},
   {"DmFindResource", 0xA065},
   {"DmSearchResource", 0xA066},
   {"DmNumResources", 0xA067},
   {"DmResourceInfo", 0xA068},
   {"DmSetResourceInfo", 0xA069},
   {"DmAttachResource", 0xA06A},
   {"DmDetachResource", 0xA06B},
   {"DmNewResource", 0xA06C},
   {"DmRemoveResource", 0xA06D},
   {"DmGetResourceIndex", 0xA06E},
   {"DmQuickSort", 0xA06F},
   {"DmQueryNextInCategory", 0xA070},
   {"DmNumRecordsInCategory", 0xA071},
   {"DmPositionInCategory", 0xA072},
   {"DmSeekRecordInCategory", 0xA073},
   {"DmMoveCategory", 0xA074},
   {"DmOpenDatabaseByTypeCreator", 0xA075},
   {"DmWrite", 0xA076},
   {"DmStrCopy", 0xA077},
   {"DmGetNextDatabaseByTypeCreator", 0xA078},
   {"DmWriteCheck", 0xA079},
   {"DmMoveOpenDBContext", 0xA07A},
   {"DmFindRecordByID", 0xA07B},
   {"DmGetAppInfoID", 0xA07C},
   {"DmFindSortPositionV10", 0xA07D},
   {"DmSet", 0xA07E},
   {"DmCreateDatabaseFromImage", 0xA07F},
   {"DbgSrcMessage", 0xA080},
   {"DbgMessage", 0xA081},
   {"DbgGetMessage", 0xA082},
   {"DbgCommSettings", 0xA083},
   {"ErrDisplayFileLineMsg", 0xA084},
   {"ErrSetJump", 0xA085},
   {"ErrLongJump", 0xA086},
   {"ErrThrow", 0xA087},
   {"ErrExceptionList", 0xA088},
   {"SysBroadcastActionCode", 0xA089},
   {"SysUnimplemented", 0xA08A},
   {"SysColdBoot", 0xA08B},
   {"SysReset", 0xA08C},
   {"SysDoze", 0xA08D},
   {"SysAppLaunch", 0xA08E},
   {"SysAppStartup", 0xA08F},
   {"SysAppExit", 0xA090},
   {"SysSetA5", 0xA091},
   {"SysSetTrapAddress", 0xA092},
   {"SysGetTrapAddress", 0xA093},
   {"SysTranslateKernelErr", 0xA094},
   {"SysSemaphoreCreate", 0xA095},
   {"SysSemaphoreDelete", 0xA096},
   {"SysSemaphoreWait", 0xA097},
   {"SysSemaphoreSignal", 0xA098},
   {"SysTimerCreate", 0xA099},
   {"SysTimerWrite", 0xA09A},
   {"SysTaskCreate", 0xA09B},
   {"SysTaskDelete", 0xA09C},
   {"SysTaskTrigger", 0xA09D},
   {"SysTaskID", 0xA09E},
   {"SysTaskUserInfoPtr", 0xA09F},
   {"SysTaskDelay", 0xA0A0},
   {"SysTaskSetTermProc", 0xA0A1},
   {"SysUILaunch", 0xA0A2},
   {"SysNewOwnerID", 0xA0A3},
   {"SysSemaphoreSet", 0xA0A4},
   {"SysDisableInts", 0xA0A5},
   {"SysRestoreStatus", 0xA0A6},
   {"SysUIAppSwitch", 0xA0A7},
   {"SysCurAppInfoPV20", 0xA0A8},
   {"SysHandleEvent", 0xA0A9},
   {"SysInit", 0xA0AA},
   {"SysQSort", 0xA0AB},
   {"SysCurAppDatabase", 0xA0AC},
   {"SysFatalAlert", 0xA0AD},
   {"SysResSemaphoreCreate", 0xA0AE},
   {"SysResSemaphoreDelete", 0xA0AF},
   {"SysResSemaphoreReserve", 0xA0B0},
   {"SysResSemaphoreRelease", 0xA0B1},
   {"SysSleep", 0xA0B2},
   {"SysKeyboardDialogV10", 0xA0B3},
   {"SysAppLauncherDialog", 0xA0B4},
   {"SysSetPerformance", 0xA0B5},
   {"SysBatteryInfoV20", 0xA0B6},
   {"SysLibInstall", 0xA0B7},
   {"SysLibRemove", 0xA0B8},
   {"SysLibTblEntry", 0xA0B9},
   {"SysLibFind", 0xA0BA},
   {"SysBatteryDialog", 0xA0BB},
   {"SysCopyStringResource", 0xA0BC},
   {"SysKernelInfo", 0xA0BD},
   {"SysLaunchConsole", 0xA0BE},
   {"SysTimerDelete", 0xA0BF},
   {"SysSetAutoOffTime", 0xA0C0},
   {"SysFormPointerArrayToStrings", 0xA0C1},
   {"SysRandom", 0xA0C2},
   {"SysTaskSwitching", 0xA0C3},
   {"SysTimerRead", 0xA0C4},
   {"StrCopy", 0xA0C5},
   {"StrCat", 0xA0C6},
   {"StrLen", 0xA0C7},
   {"StrCompare", 0xA0C8},
   {"StrIToA", 0xA0C9},
   {"StrCaselessCompare", 0xA0CA},
   {"StrIToH", 0xA0CB},
   {"StrChr", 0xA0CC},
   {"StrStr", 0xA0CD},
   {"StrAToI", 0xA0CE},
   {"StrToLower", 0xA0CF},
   {"SerReceiveISP", 0xA0D0},
   {"SlkOpen", 0xA0D1},
   {"SlkClose", 0xA0D2},
   {"SlkOpenSocket", 0xA0D3},
   {"SlkCloseSocket", 0xA0D4},
   {"SlkSocketRefNum", 0xA0D5},
   {"SlkSocketSetTimeout", 0xA0D6},
   {"SlkFlushSocket", 0xA0D7},
   {"SlkSetSocketListener", 0xA0D8},
   {"SlkSendPacket", 0xA0D9},
   {"SlkReceivePacket", 0xA0DA},
   {"SlkSysPktDefaultResponse", 0xA0DB},
   {"SlkProcessRPC", 0xA0DC},
   {"ConPutS", 0xA0DD},
   {"ConGetS", 0xA0DE},
   {"FplInit", 0xA0DF},
   {"FplFree", 0xA0E0},
   {"FplFToA", 0xA0E1},
   {"FplAToF", 0xA0E2},
   {"FplBase10Info", 0xA0E3},
   {"FplLongToFloat", 0xA0E4},
   {"FplFloatToLong", 0xA0E5},
   {"FplFloatToULong", 0xA0E6},
   {"FplMul", 0xA0E7},
   {"FplAdd", 0xA0E8},
   {"FplSub", 0xA0E9},
   {"FplDiv", 0xA0EA},
   {"WinScreenInit", 0xA0EB},
   {"ScrCopyRectangle", 0xA0EC},
   {"ScrDrawChars", 0xA0ED},
   {"ScrLineRoutine", 0xA0EE},
   {"ScrRectangleRoutine", 0xA0EF},
   {"ScrScreenInfo", 0xA0F0},
   {"ScrDrawNotify", 0xA0F1},
   {"ScrSendUpdateArea", 0xA0F2},
   {"ScrCompressScanLine", 0xA0F3},
   {"ScrDeCompressScanLine", 0xA0F4},
   {"TimGetSeconds", 0xA0F5},
   {"TimSetSeconds", 0xA0F6},
   {"TimGetTicks", 0xA0F7},
   {"TimInit", 0xA0F8},
   {"TimSetAlarm", 0xA0F9},
   {"TimGetAlarm", 0xA0FA},
   {"TimHandleInterrupt", 0xA0FB},
   {"TimSecondsToDateTime", 0xA0FC},
   {"TimDateTimeToSeconds", 0xA0FD},
   {"TimAdjust", 0xA0FE},
   {"TimSleep", 0xA0FF},
   {"TimWake", 0xA100},
   {"CategoryCreateListV10", 0xA101},
   {"CategoryFreeListV10", 0xA102},
   {"CategoryFind", 0xA103},
   {"CategoryGetName", 0xA104},
   {"CategoryEditV10", 0xA105},
   {"CategorySelectV10", 0xA106},
   {"CategoryGetNext", 0xA107},
   {"CategorySetTriggerLabel", 0xA108},
   {"CategoryTruncateName", 0xA109},
   {"ClipboardAddItem", 0xA10A},
   {"ClipboardCheckIfItemExist", 0xA10B},
   {"ClipboardGetItem", 0xA10C},
   {"CtlDrawControl", 0xA10D},
   {"CtlEraseControl", 0xA10E},
   {"CtlHideControl", 0xA10F},
   {"CtlShowControl", 0xA110},
   {"CtlGetValue", 0xA111},
   {"CtlSetValue", 0xA112},
   {"CtlGetLabel", 0xA113},
   {"CtlSetLabel", 0xA114},
   {"CtlHandleEvent", 0xA115},
   {"CtlHitControl", 0xA116},
   {"CtlSetEnabled", 0xA117},
   {"CtlSetUsable", 0xA118},
   {"CtlEnabled", 0xA119},
   {"EvtInitialize", 0xA11A},
   {"EvtAddEventToQueue", 0xA11B},
   {"EvtCopyEvent", 0xA11C},
   {"EvtGetEvent", 0xA11D},
   {"EvtGetPen", 0xA11E},
   {"EvtSysInit", 0xA11F},
   {"EvtGetSysEvent", 0xA120},
   {"EvtProcessSoftKeyStroke", 0xA121},
   {"EvtGetPenBtnList", 0xA122},
   {"EvtSetPenQueuePtr", 0xA123},
   {"EvtPenQueueSize", 0xA124},
   {"EvtFlushPenQueue", 0xA125},
   {"EvtEnqueuePenPoint", 0xA126},
   {"EvtDequeuePenStrokeInfo", 0xA127},
   {"EvtDequeuePenPoint", 0xA128},
   {"EvtFlushNextPenStroke", 0xA129},
   {"EvtSetKeyQueuePtr", 0xA12A},
   {"EvtKeyQueueSize", 0xA12B},
   {"EvtFlushKeyQueue", 0xA12C},
   {"EvtEnqueueKey", 0xA12D},
   {"EvtDequeueKeyEvent", 0xA12E},
   {"EvtWakeup", 0xA12F},
   {"EvtResetAutoOffTimer", 0xA130},
   {"EvtKeyQueueEmpty", 0xA131},
   {"EvtEnableGraffiti", 0xA132},
   {"FldCopy", 0xA133},
   {"FldCut", 0xA134},
   {"FldDrawField", 0xA135},
   {"FldEraseField", 0xA136},
   {"FldFreeMemory", 0xA137},
   {"FldGetBounds", 0xA138},
   {"FldGetTextPtr", 0xA139},
   {"FldGetSelection", 0xA13A},
   {"FldHandleEvent", 0xA13B},
   {"FldPaste", 0xA13C},
   {"FldRecalculateField", 0xA13D},
   {"FldSetBounds", 0xA13E},
   {"FldSetText", 0xA13F},
   {"FldGetFont", 0xA140},
   {"FldSetFont", 0xA141},
   {"FldSetSelection", 0xA142},
   {"FldGrabFocus", 0xA143},
   {"FldReleaseFocus", 0xA144},
   {"FldGetInsPtPosition", 0xA145},
   {"FldSetInsPtPosition", 0xA146},
   {"FldSetScrollPosition", 0xA147},
   {"FldGetScrollPosition", 0xA148},
   {"FldGetTextHeight", 0xA149},
   {"FldGetTextAllocatedSize", 0xA14A},
   {"FldGetTextLength", 0xA14B},
   {"FldScrollField", 0xA14C},
   {"FldScrollable", 0xA14D},
   {"FldGetVisibleLines", 0xA14E},
   {"FldGetAttributes", 0xA14F},
   {"FldSetAttributes", 0xA150},
   {"FldSendChangeNotification", 0xA151},
   {"FldCalcFieldHeight", 0xA152},
   {"FldGetTextHandle", 0xA153},
   {"FldCompactText", 0xA154},
   {"FldDirty", 0xA155},
   {"FldWordWrap", 0xA156},
   {"FldSetTextAllocatedSize", 0xA157},
   {"FldSetTextHandle", 0xA158},
   {"FldSetTextPtr", 0xA159},
   {"FldGetMaxChars", 0xA15A},
   {"FldSetMaxChars", 0xA15B},
   {"FldSetUsable", 0xA15C},
   {"FldInsert", 0xA15D},
   {"FldDelete", 0xA15E},
   {"FldUndo", 0xA15F},
   {"FldSetDirty", 0xA160},
   {"FldSendHeightChangeNotification", 0xA161},
   {"FldMakeFullyVisible", 0xA162},
   {"FntGetFont", 0xA163},
   {"FntSetFont", 0xA164},
   {"FntGetFontPtr", 0xA165},
   {"FntBaseLine", 0xA166},
   {"FntCharHeight", 0xA167},
   {"FntLineHeight", 0xA168},
   {"FntAverageCharWidth", 0xA169},
   {"FntCharWidth", 0xA16A},
   {"FntCharsWidth", 0xA16B},
   {"FntDescenderHeight", 0xA16C},
   {"FntCharsInWidth", 0xA16D},
   {"FntLineWidth", 0xA16E},
   {"FrmInitForm", 0xA16F},
   {"FrmDeleteForm", 0xA170},
   {"FrmDrawForm", 0xA171},
   {"FrmEraseForm", 0xA172},
   {"FrmGetActiveForm", 0xA173},
   {"FrmSetActiveForm", 0xA174},
   {"FrmGetActiveFormID", 0xA175},
   {"FrmGetUserModifiedState", 0xA176},
   {"FrmSetNotUserModified", 0xA177},
   {"FrmGetFocus", 0xA178},
   {"FrmSetFocus", 0xA179},
   {"FrmHandleEvent", 0xA17A},
   {"FrmGetFormBounds", 0xA17B},
   {"FrmGetWindowHandle", 0xA17C},
   {"FrmGetFormId", 0xA17D},
   {"FrmGetFormPtr", 0xA17E},
   {"FrmGetNumberOfObjects", 0xA17F},
   {"FrmGetObjectIndex", 0xA180},
   {"FrmGetObjectId", 0xA181},
   {"FrmGetObjectType", 0xA182},
   {"FrmGetObjectPtr", 0xA183},
   {"FrmHideObject", 0xA184},
   {"FrmShowObject", 0xA185},
   {"FrmGetObjectPosition", 0xA186},
   {"FrmSetObjectPosition", 0xA187},
   {"FrmGetControlValue", 0xA188},
   {"FrmSetControlValue", 0xA189},
   {"FrmGetControlGroupSelection", 0xA18A},
   {"FrmSetControlGroupSelection", 0xA18B},
   {"FrmCopyLabel", 0xA18C},
   {"FrmSetLabel", 0xA18D},
   {"FrmGetLabel", 0xA18E},
   {"FrmSetCategoryLabel", 0xA18F},
   {"FrmGetTitle", 0xA190},
   {"FrmSetTitle", 0xA191},
   {"FrmAlert", 0xA192},
   {"FrmDoDialog", 0xA193},
   {"FrmCustomAlert", 0xA194},
   {"FrmHelp", 0xA195},
   {"FrmUpdateScrollers", 0xA196},
   {"FrmGetFirstForm", 0xA197},
   {"FrmVisible", 0xA198},
   {"FrmGetObjectBounds", 0xA199},
   {"FrmCopyTitle", 0xA19A},
   {"FrmGotoForm", 0xA19B},
   {"FrmPopupForm", 0xA19C},
   {"FrmUpdateForm", 0xA19D},
   {"FrmReturnToForm", 0xA19E},
   {"FrmSetEventHandler", 0xA19F},
   {"FrmDispatchEvent", 0xA1A0},
   {"FrmCloseAllForms", 0xA1A1},
   {"FrmSaveAllForms", 0xA1A2},
   {"FrmGetGadgetData", 0xA1A3},
   {"FrmSetGadgetData", 0xA1A4},
   {"FrmSetCategoryTrigger", 0xA1A5},
   {"UIInitialize", 0xA1A6},
   {"UIReset", 0xA1A7},
   {"InsPtInitialize", 0xA1A8},
   {"InsPtSetLocation", 0xA1A9},
   {"InsPtGetLocation", 0xA1AA},
   {"InsPtEnable", 0xA1AB},
   {"InsPtEnabled", 0xA1AC},
   {"InsPtSetHeight", 0xA1AD},
   {"InsPtGetHeight", 0xA1AE},
   {"InsPtCheckBlink", 0xA1AF},
   {"LstSetDrawFunction", 0xA1B0},
   {"LstDrawList", 0xA1B1},
   {"LstEraseList", 0xA1B2},
   {"LstGetSelection", 0xA1B3},
   {"LstGetSelectionText", 0xA1B4},
   {"LstHandleEvent", 0xA1B5},
   {"LstSetHeight", 0xA1B6},
   {"LstSetSelection", 0xA1B7},
   {"LstSetListChoices", 0xA1B8},
   {"LstMakeItemVisible", 0xA1B9},
   {"LstGetNumberOfItems", 0xA1BA},
   {"LstPopupList", 0xA1BB},
   {"LstSetPosition", 0xA1BC},
   {"MenuInit", 0xA1BD},
   {"MenuDispose", 0xA1BE},
   {"MenuHandleEvent", 0xA1BF},
   {"MenuDrawMenu", 0xA1C0},
   {"MenuEraseStatus", 0xA1C1},
   {"MenuGetActiveMenu", 0xA1C2},
   {"MenuSetActiveMenu", 0xA1C3},
   {"RctSetRectangle", 0xA1C4},
   {"RctCopyRectangle", 0xA1C5},
   {"RctInsetRectangle", 0xA1C6},
   {"RctOffsetRectangle", 0xA1C7},
   {"RctPtInRectangle", 0xA1C8},
   {"RctGetIntersection", 0xA1C9},
   {"TblDrawTable", 0xA1CA},
   {"TblEraseTable", 0xA1CB},
   {"TblHandleEvent", 0xA1CC},
   {"TblGetItemBounds", 0xA1CD},
   {"TblSelectItem", 0xA1CE},
   {"TblGetItemInt", 0xA1CF},
   {"TblSetItemInt", 0xA1D0},
   {"TblSetItemStyle", 0xA1D1},
   {"TblUnhighlightSelection", 0xA1D2},
   {"TblSetRowUsable", 0xA1D3},
   {"TblGetNumberOfRows", 0xA1D4},
   {"TblSetCustomDrawProcedure", 0xA1D5},
   {"TblSetRowSelectable", 0xA1D6},
   {"TblRowSelectable", 0xA1D7},
   {"TblSetLoadDataProcedure", 0xA1D8},
   {"TblSetSaveDataProcedure", 0xA1D9},
   {"TblGetBounds", 0xA1DA},
   {"TblSetRowHeight", 0xA1DB},
   {"TblGetColumnWidth", 0xA1DC},
   {"TblGetRowID", 0xA1DD},
   {"TblSetRowID", 0xA1DE},
   {"TblMarkRowInvalid", 0xA1DF},
   {"TblMarkTableInvalid", 0xA1E0},
   {"TblGetSelection", 0xA1E1},
   {"TblInsertRow", 0xA1E2},
   {"TblRemoveRow", 0xA1E3},
   {"TblRowInvalid", 0xA1E4},
   {"TblRedrawTable", 0xA1E5},
   {"TblRowUsable", 0xA1E6},
   {"TblReleaseFocus", 0xA1E7},
   {"TblEditing", 0xA1E8},
   {"TblGetCurrentField", 0xA1E9},
   {"TblSetColumnUsable", 0xA1EA},
   {"TblGetRowHeight", 0xA1EB},
   {"TblSetColumnWidth", 0xA1EC},
   {"TblGrabFocus", 0xA1ED},
   {"TblSetItemPtr", 0xA1EE},
   {"TblFindRowID", 0xA1EF},
   {"TblGetLastUsableRow", 0xA1F0},
   {"TblGetColumnSpacing", 0xA1F1},
   {"TblFindRowData", 0xA1F2},
   {"TblGetRowData", 0xA1F3},
   {"TblSetRowData", 0xA1F4},
   {"TblSetColumnSpacing", 0xA1F5},
   {"WinCreateWindow", 0xA1F6},
   {"WinCreateOffscreenWindow", 0xA1F7},
   {"WinDeleteWindow", 0xA1F8},
   {"WinInitializeWindow", 0xA1F9},
   {"WinAddWindow", 0xA1FA},
   {"WinRemoveWindow", 0xA1FB},
   {"WinSetActiveWindow", 0xA1FC},
   {"WinSetDrawWindow", 0xA1FD},
   {"WinGetDrawWindow", 0xA1FE},
   {"WinGetActiveWindow", 0xA1FF},
   {"WinGetDisplayWindow", 0xA200},
   {"WinGetFirstWindow", 0xA201},
   {"WinEnableWindow", 0xA202},
   {"WinDisableWindow", 0xA203},
   {"WinGetWindowFrameRect", 0xA204},
   {"WinDrawWindowFrame", 0xA205},
   {"WinEraseWindow", 0xA206},
   {"WinSaveBits", 0xA207},
   {"WinRestoreBits", 0xA208},
   {"WinCopyRectangle", 0xA209},
   {"WinScrollRectangle", 0xA20A},
   {"WinGetDisplayExtent", 0xA20B},
   {"WinGetWindowExtent", 0xA20C},
   {"WinDisplayToWindowPt", 0xA20D},
   {"WinWindowToDisplayPt", 0xA20E},
   {"WinGetClip", 0xA20F},
   {"WinSetClip", 0xA210},
   {"WinResetClip", 0xA211},
   {"WinClipRectangle", 0xA212},
   {"WinDrawLine", 0xA213},
   {"WinDrawGrayLine", 0xA214},
   {"WinEraseLine", 0xA215},
   {"WinInvertLine", 0xA216},
   {"WinFillLine", 0xA217},
   {"WinDrawRectangle", 0xA218},
   {"WinEraseRectangle", 0xA219},
   {"WinInvertRectangle", 0xA21A},
   {"WinDrawRectangleFrame", 0xA21B},
   {"WinDrawGrayRectangleFrame", 0xA21C},
   {"WinEraseRectangleFrame", 0xA21D},
   {"WinInvertRectangleFrame", 0xA21E},
   {"WinGetFramesRectangle", 0xA21F},
   {"WinDrawChars", 0xA220},
   {"WinEraseChars", 0xA221},
   {"WinInvertChars", 0xA222},
   {"WinGetPattern", 0xA223},
   {"WinSetPattern", 0xA224},
   {"WinSetUnderlineMode", 0xA225},
   {"WinDrawBitmap", 0xA226},
   {"WinModal", 0xA227},
   {"WinGetDrawWindowBounds", 0xA228},
   {"WinFillRectangle", 0xA229},
   {"WinDrawInvertedChars", 0xA22A},
   {"PrefOpenPreferenceDBV10", 0xA22B},
   {"PrefGetPreferences", 0xA22C},
   {"PrefSetPreferences", 0xA22D},
   {"PrefGetAppPreferencesV10", 0xA22E},
   {"PrefSetAppPreferencesV10", 0xA22F},
   {"SndInit", 0xA230},
   {"SndSetDefaultVolume", 0xA231},
   {"SndGetDefaultVolume", 0xA232},
   {"SndDoCmd", 0xA233},
   {"SndPlaySystemSound", 0xA234},
   {"AlmInit", 0xA235},
   {"AlmCancelAll", 0xA236},
   {"AlmAlarmCallback", 0xA237},
   {"AlmSetAlarm", 0xA238},
   {"AlmGetAlarm", 0xA239},
   {"AlmDisplayAlarm", 0xA23A},
   {"AlmEnableNotification", 0xA23B},
   {"HwrGetRAMMapping", 0xA23C},
   {"HwrMemWritable", 0xA23D},
   {"HwrMemReadable", 0xA23E},
   {"HwrDoze", 0xA23F},
   {"HwrSleep", 0xA240},
   {"HwrWake", 0xA241},
   {"HwrSetSystemClock", 0xA242},
   {"HwrSetCPUDutyCycle", 0xA243},
   {"HwrDisplayInit", 0xA244},
   {"HwrDisplaySleep", 0xA245},
   {"HwrTimerInit", 0xA246},
   {"HwrCursorV33", 0xA247},
   {"HwrBatteryLevel", 0xA248},
   {"HwrDelay", 0xA249},
   {"HwrEnableDataWrites", 0xA24A},
   {"HwrDisableDataWrites", 0xA24B},
   {"HwrLCDBaseAddrV33", 0xA24C},
   {"HwrDisplayDrawBootScreen", 0xA24D},
   {"HwrTimerSleep", 0xA24E},
   {"HwrTimerWake", 0xA24F},
   {"HwrDisplayWake", 0xA250},
   {"HwrIRQ1Handler", 0xA251},
   {"HwrIRQ2Handler", 0xA252},
   {"HwrIRQ3Handler", 0xA253},
   {"HwrIRQ4Handler", 0xA254},
   {"HwrIRQ5Handler", 0xA255},
   {"HwrIRQ6Handler", 0xA256},
   {"HwrDockSignals", 0xA257},
   {"HwrPluggedIn", 0xA258},
   {"Crc16CalcBlock", 0xA259},
   {"SelectDayV10", 0xA25A},
   {"SelectTimeV33", 0xA25B},
   {"DayDrawDaySelector", 0xA25C},
   {"DayHandleEvent", 0xA25D},
   {"DayDrawDays", 0xA25E},
   {"DayOfWeek", 0xA25F},
   {"DaysInMonth", 0xA260},
   {"DayOfMonth", 0xA261},
   {"DateDaysToDate", 0xA262},
   {"DateToDays", 0xA263},
   {"DateAdjust", 0xA264},
   {"DateSecondsToDate", 0xA265},
   {"DateToAscii", 0xA266},
   {"DateToDOWDMFormat", 0xA267},
   {"TimeToAscii", 0xA268},
   {"Find", 0xA269},
   {"FindStrInStr", 0xA26A},
   {"FindSaveMatch", 0xA26B},
   {"FindGetLineBounds", 0xA26C},
   {"FindDrawHeader", 0xA26D},
   {"PenOpen", 0xA26E},
   {"PenClose", 0xA26F},
   {"PenGetRawPen", 0xA270},
   {"PenCalibrate", 0xA271},
   {"PenRawToScreen", 0xA272},
   {"PenScreenToRaw", 0xA273},
   {"PenResetCalibration", 0xA274},
   {"PenSleep", 0xA275},
   {"PenWake", 0xA276},
   {"ResLoadForm", 0xA277},
   {"ResLoadMenu", 0xA278},
   {"FtrInit", 0xA279},
   {"FtrUnregister", 0xA27A},
   {"FtrGet", 0xA27B},
   {"FtrSet", 0xA27C},
   {"FtrGetByIndex", 0xA27D},
   {"GrfInit", 0xA27E},
   {"GrfFree", 0xA27F},
   {"GrfGetState", 0xA280},
   {"GrfSetState", 0xA281},
   {"GrfFlushPoints", 0xA282},
   {"GrfAddPoint", 0xA283},
   {"GrfInitState", 0xA284},
   {"GrfCleanState", 0xA285},
   {"GrfMatch", 0xA286},
   {"GrfGetMacro", 0xA287},
   {"GrfFilterPoints", 0xA288},
   {"GrfGetNumPoints", 0xA289},
   {"GrfGetPoint", 0xA28A},
   {"GrfFindBranch", 0xA28B},
   {"GrfMatchGlyph", 0xA28C},
   {"GrfGetGlyphMapping", 0xA28D},
   {"GrfGetMacroName", 0xA28E},
   {"GrfDeleteMacro", 0xA28F},
   {"GrfAddMacro", 0xA290},
   {"GrfGetAndExpandMacro", 0xA291},
   {"GrfProcessStroke", 0xA292},
   {"GrfFieldChange", 0xA293},
   {"GetCharSortValue", 0xA294},
   {"GetCharAttr", 0xA295},
   {"GetCharCaselessValue", 0xA296},
   {"PwdExists", 0xA297},
   {"PwdVerify", 0xA298},
   {"PwdSet", 0xA299},
   {"PwdRemove", 0xA29A},
   {"GsiInitialize", 0xA29B},
   {"GsiSetLocation", 0xA29C},
   {"GsiEnable", 0xA29D},
   {"GsiEnabled", 0xA29E},
   {"GsiSetShiftState", 0xA29F},
   {"KeyInit", 0xA2A0},
   {"KeyHandleInterrupt", 0xA2A1},
   {"KeyCurrentState", 0xA2A2},
   {"KeyResetDoubleTap", 0xA2A3},
   {"KeyRates", 0xA2A4},
   {"KeySleep", 0xA2A5},
   {"KeyWake", 0xA2A6},
   {"DlkControl", 0xA2A7},
   {"DlkStartServer", 0xA2A8},
   {"DlkGetSyncInfo", 0xA2A9},
   {"DlkSetLogEntry", 0xA2AA},
   {"IntlDispatch", 0xA2AB},
   {"SysLibLoad", 0xA2AC},
   {"SndPlaySmf", 0xA2AD},
   {"SndCreateMidiList", 0xA2AE},
   {"AbtShowAbout", 0xA2AF},
   {"MdmDial", 0xA2B0},
   {"MdmHangUp", 0xA2B1},
   {"DmSearchRecord", 0xA2B2},
   {"SysInsertionSort", 0xA2B3},
   {"DmInsertionSort", 0xA2B4},
   {"LstSetTopItem", 0xA2B5},
   {"SclSetScrollBar", 0xA2B6},
   {"SclDrawScrollBar", 0xA2B7},
   {"SclHandleEvent", 0xA2B8},
   {"SysMailboxCreate", 0xA2B9},
   {"SysMailboxDelete", 0xA2BA},
   {"SysMailboxFlush", 0xA2BB},
   {"SysMailboxSend", 0xA2BC},
   {"SysMailboxWait", 0xA2BD},
   {"SysTaskWait", 0xA2BE},
   {"SysTaskWake", 0xA2BF},
   {"SysTaskWaitClr", 0xA2C0},
   {"SysTaskSuspend", 0xA2C1},
   {"SysTaskResume", 0xA2C2},
   {"CategoryCreateList", 0xA2C3},
   {"CategoryFreeList", 0xA2C4},
   {"CategoryEditV20", 0xA2C5},
   {"CategorySelect", 0xA2C6},
   {"DmDeleteCategory", 0xA2C7},
   {"SysEvGroupCreate", 0xA2C8},
   {"SysEvGroupSignal", 0xA2C9},
   {"SysEvGroupRead", 0xA2CA},
   {"SysEvGroupWait", 0xA2CB},
   {"EvtEventAvail", 0xA2CC},
   {"EvtSysEventAvail", 0xA2CD},
   {"StrNCopy", 0xA2CE},
   {"KeySetMask", 0xA2CF},
   {"SelectDay", 0xA2D0},
   {"PrefGetPreference", 0xA2D1},
   {"PrefSetPreference", 0xA2D2},
   {"PrefGetAppPreferences", 0xA2D3},
   {"PrefSetAppPreferences", 0xA2D4},
   {"FrmPointInTitle", 0xA2D5},
   {"StrNCat", 0xA2D6},
   {"MemCmp", 0xA2D7},
   {"TblSetColumnEditIndicator", 0xA2D8},
   {"FntWordWrap", 0xA2D9},
   {"FldGetScrollValues", 0xA2DA},
   {"SysCreateDataBaseList", 0xA2DB},
   {"SysCreatePanelList", 0xA2DC},
   {"DlkDispatchRequest", 0xA2DD},
   {"StrPrintF", 0xA2DE},
   {"StrVPrintF", 0xA2DF},
   {"PrefOpenPreferenceDB", 0xA2E0},
   {"SysGraffitiReferenceDialog", 0xA2E1},
   {"SysKeyboardDialog", 0xA2E2},
   {"FntWordWrapReverseNLines", 0xA2E3},
   {"FntGetScrollValues", 0xA2E4},
   {"TblSetRowStaticHeight", 0xA2E5},
   {"TblHasScrollBar", 0xA2E6},
   {"SclGetScrollBar", 0xA2E7},
   {"FldGetNumberOfBlankLines", 0xA2E8},
   {"SysTicksPerSecond", 0xA2E9},
   {"HwrBacklightV33", 0xA2EA},
   {"DmDatabaseProtect", 0xA2EB},
   {"TblSetBounds", 0xA2EC},
   {"StrNCompare", 0xA2ED},
   {"StrNCaselessCompare", 0xA2EE},
   {"PhoneNumberLookup", 0xA2EF},
   {"FrmSetMenu", 0xA2F0},
   {"EncDigestMD5", 0xA2F1},
   {"DmFindSortPosition", 0xA2F2},
   {"SysBinarySearch", 0xA2F3},
   {"SysErrString", 0xA2F4},
   {"SysStringByIndex", 0xA2F5},
   {"EvtAddUniqueEventToQueue", 0xA2F6},
   {"StrLocalizeNumber", 0xA2F7},
   {"StrDelocalizeNumber", 0xA2F8},
   {"LocGetNumberSeparators", 0xA2F9},
   {"MenuSetActiveMenuRscID", 0xA2FA},
   {"LstScrollList", 0xA2FB},
   {"CategoryInitialize", 0xA2FC},
   {"EncDigestMD4", 0xA2FD},
   {"EncDES", 0xA2FE},
   {"LstGetVisibleItems", 0xA2FF},
   {"WinSetBounds", 0xA300},
   {"CategorySetName", 0xA301},
   {"FldSetInsertionPoint", 0xA302},
   {"FrmSetObjectBounds", 0xA303},
   {"WinSetColors", 0xA304},
   {"FlpDispatch", 0xA305},
   {"FlpEmDispatch", 0xA306},
   {"ExgInit", 0xA307},
   {"ExgConnect", 0xA308},
   {"ExgPut", 0xA309},
   {"ExgGet", 0xA30A},
   {"ExgAccept", 0xA30B},
   {"ExgDisconnect", 0xA30C},
   {"ExgSend", 0xA30D},
   {"ExgReceive", 0xA30E},
   {"ExgRegisterData", 0xA30F},
   {"ExgNotifyReceiveV35", 0xA310},
   {"SysReserved30Trap2", 0xA311},
   {"PrgStartDialogV31", 0xA312},
   {"PrgStopDialog", 0xA313},
   {"PrgUpdateDialog", 0xA314},
   {"PrgHandleEvent", 0xA315},
   {"ImcReadFieldNoSemicolon", 0xA316},
   {"ImcReadFieldQuotablePrintable", 0xA317},
   {"ImcReadPropertyParameter", 0xA318},
   {"ImcSkipAllPropertyParameters", 0xA319},
   {"ImcReadWhiteSpace", 0xA31A},
   {"ImcWriteQuotedPrintable", 0xA31B},
   {"ImcWriteNoSemicolon", 0xA31C},
   {"ImcStringIsAscii", 0xA31D},
   {"TblGetItemFont", 0xA31E},
   {"TblSetItemFont", 0xA31F},
   {"FontSelect", 0xA320},
   {"FntDefineFont", 0xA321},
   {"CategoryEdit", 0xA322},
   {"SysGetOSVersionString", 0xA323},
   {"SysBatteryInfo", 0xA324},
   {"SysUIBusy", 0xA325},
   {"WinValidateHandle", 0xA326},
   {"FrmValidatePtr", 0xA327},
   {"CtlValidatePointer", 0xA328},
   {"WinMoveWindowAddr", 0xA329},
   {"FrmAddSpaceForObject", 0xA32A},
   {"FrmNewForm", 0xA32B},
   {"CtlNewControl", 0xA32C},
   {"FldNewField", 0xA32D},
   {"LstNewList", 0xA32E},
   {"FrmNewLabel", 0xA32F},
   {"FrmNewBitmap", 0xA330},
   {"FrmNewGadget", 0xA331},
   {"FileOpen", 0xA332},
   {"FileClose", 0xA333},
   {"FileDelete", 0xA334},
   {"FileReadLow", 0xA335},
   {"FileWrite", 0xA336},
   {"FileSeek", 0xA337},
   {"FileTell", 0xA338},
   {"FileTruncate", 0xA339},
   {"FileControl", 0xA33A},
   {"FrmActiveState", 0xA33B},
   {"SysGetAppInfo", 0xA33C},
   {"SysGetStackInfo", 0xA33D},
   {"WinScreenMode", 0xA33E},
   {"HwrLCDGetDepthV33", 0xA33F},
   {"HwrGetROMToken", 0xA340},
   {"DbgControl", 0xA341},
   {"ExgDBRead", 0xA342},
   {"ExgDBWrite", 0xA343},
   {"HostControl", 0xA344},
   {"FrmRemoveObject", 0xA345},
   {"SysReserved30Trap1", 0xA346},
   {"ExpansionDispatch", 0xA347},
   {"FileSystemDispatch", 0xA348},
   {"OEMDispatch", 0xA349},
   {"HwrLCDContrastV33", 0xA34A},
   {"SysLCDContrast", 0xA34B},
   {"UIContrastAdjust", 0xA34C},
   {"HwrDockStatus", 0xA34D},
   {"FntWidthToOffset", 0xA34E},
   {"SelectOneTime", 0xA34F},
   {"WinDrawChar", 0xA350},
   {"WinDrawTruncChars", 0xA351},
   {"SysNotifyInit", 0xA352},
   {"SysNotifyRegister", 0xA353},
   {"SysNotifyUnregister", 0xA354},
   {"SysNotifyBroadcast", 0xA355},
   {"SysNotifyBroadcastDeferred", 0xA356},
   {"SysNotifyDatabaseAdded", 0xA357},
   {"SysNotifyDatabaseRemoved", 0xA358},
   {"SysWantEvent", 0xA359},
   {"FtrPtrNew", 0xA35A},
   {"FtrPtrFree", 0xA35B},
   {"FtrPtrResize", 0xA35C},
   {"SysReserved31Trap1", 0xA35D},
   {"HwrNVPrefSet", 0xA35E},
   {"HwrNVPrefGet", 0xA35F},
   {"FlashInit", 0xA360},
   {"FlashCompress", 0xA361},
   {"FlashErase", 0xA362},
   {"FlashProgram", 0xA363},
   {"AlmTimeChange", 0xA364},
   {"ErrAlertCustom", 0xA365},
   {"PrgStartDialog", 0xA366},
   {"SerialDispatch", 0xA367},
   {"HwrBattery", 0xA368},
   {"DmGetDatabaseLockState", 0xA369},
   {"CncGetProfileList", 0xA36A},
   {"CncGetProfileInfo", 0xA36B},
   {"CncAddProfile", 0xA36C},
   {"CncDeleteProfile", 0xA36D},
   {"SndPlaySmfResource", 0xA36E},
   {"MemPtrDataStorage", 0xA36F},
   {"ClipboardAppendItem", 0xA370},
   {"WiCmdV32", 0xA371},
   {"HwrDisplayAttributes", 0xA372},
   {"HwrDisplayDoze", 0xA373},
   {"HwrDisplayPalette", 0xA374},
   {"BltFindIndexes", 0xA375},
   {"BmpGetBits", 0xA376},
   {"BltCopyRectangle", 0xA377},
   {"BltDrawChars", 0xA378},
   {"BltLineRoutine", 0xA379},
   {"BltRectangleRoutine", 0xA37A},
   {"ScrCompress", 0xA37B},
   {"ScrDecompress", 0xA37C},
   {"SysLCDBrightness", 0xA37D},
   {"WinPaintChar", 0xA37E},
   {"WinPaintChars", 0xA37F},
   {"WinPaintBitmap", 0xA380},
   {"WinGetPixel", 0xA381},
   {"WinPaintPixel", 0xA382},
   {"WinDrawPixel", 0xA383},
   {"WinErasePixel", 0xA384},
   {"WinInvertPixel", 0xA385},
   {"WinPaintPixels", 0xA386},
   {"WinPaintLines", 0xA387},
   {"WinPaintLine", 0xA388},
   {"WinPaintRectangle", 0xA389},
   {"WinPaintRectangleFrame", 0xA38A},
   {"WinPaintPolygon", 0xA38B},
   {"WinDrawPolygon", 0xA38C},
   {"WinErasePolygon", 0xA38D},
   {"WinInvertPolygon", 0xA38E},
   {"WinFillPolygon", 0xA38F},
   {"WinPaintArc", 0xA390},
   {"WinDrawArc", 0xA391},
   {"WinEraseArc", 0xA392},
   {"WinInvertArc", 0xA393},
   {"WinFillArc", 0xA394},
   {"WinPushDrawState", 0xA395},
   {"WinPopDrawState", 0xA396},
   {"WinSetDrawMode", 0xA397},
   {"WinSetForeColor", 0xA398},
   {"WinSetBackColor", 0xA399},
   {"WinSetTextColor", 0xA39A},
   {"WinGetPatternType", 0xA39B},
   {"WinSetPatternType", 0xA39C},
   {"WinPalette", 0xA39D},
   {"WinRGBToIndex", 0xA39E},
   {"WinIndexToRGB", 0xA39F},
   {"WinScreenLock", 0xA3A0},
   {"WinScreenUnlock", 0xA3A1},
   {"WinGetBitmap", 0xA3A2},
   {"UIColorInit", 0xA3A3},
   {"UIColorGetTableEntryIndex", 0xA3A4},
   {"UIColorGetTableEntryRGB", 0xA3A5},
   {"UIColorSetTableEntry", 0xA3A6},
   {"UIColorPushTable", 0xA3A7},
   {"UIColorPopTable", 0xA3A8},
   {"CtlNewGraphicControl", 0xA3A9},
   {"TblGetItemPtr", 0xA3AA},
   {"UIBrightnessAdjust", 0xA3AB},
   {"UIPickColor", 0xA3AC},
   {"EvtSetAutoOffTimer", 0xA3AD},
   {"TsmDispatch", 0xA3AE},
   {"OmDispatch", 0xA3AF},
   {"DmOpenDBNoOverlay", 0xA3B0},
   {"DmOpenDBWithLocale", 0xA3B1},
   {"ResLoadConstant", 0xA3B2},
   {"HwrPreDebugInit", 0xA3B3},
   {"HwrResetNMI", 0xA3B4},
   {"HwrResetPWM", 0xA3B5},
   {"KeyBootKeys", 0xA3B6},
   {"DbgSerDrvOpen", 0xA3B7},
   {"DbgSerDrvClose", 0xA3B8},
   {"DbgSerDrvControl", 0xA3B9},
   {"DbgSerDrvStatus", 0xA3BA},
   {"DbgSerDrvWriteChar", 0xA3BB},
   {"DbgSerDrvReadChar", 0xA3BC},
   {"HwrPostDebugInit", 0xA3BD},
   {"HwrIdentifyFeatures", 0xA3BE},
   {"HwrModelSpecificInit", 0xA3BF},
   {"HwrModelInitStage2", 0xA3C0},
   {"HwrInterruptsInit", 0xA3C1},
   {"HwrSoundOn", 0xA3C2},
   {"HwrSoundOff", 0xA3C3},
   {"SysKernelClockTick", 0xA3C4},
   {"MenuEraseMenu", 0xA3C5},
   {"SelectTime", 0xA3C6},
   {"MenuCmdBarAddButton", 0xA3C7},
   {"MenuCmdBarGetButtonData", 0xA3C8},
   {"MenuCmdBarDisplay", 0xA3C9},
   {"HwrGetSilkscreenID", 0xA3CA},
   {"EvtGetSilkscreenAreaList", 0xA3CB},
   {"SysFatalAlertInit", 0xA3CC},
   {"DateTemplateToAscii", 0xA3CD},
   {"SecVerifyPW", 0xA3CE},
   {"SecSelectViewStatus", 0xA3CF},
   {"TblSetColumnMasked", 0xA3D0},
   {"TblSetRowMasked", 0xA3D1},
   {"TblRowMasked", 0xA3D2},
   {"FrmCustomResponseAlert", 0xA3D3},
   {"FrmNewGsi", 0xA3D4},
   {"MenuShowItem", 0xA3D5},
   {"MenuHideItem", 0xA3D6},
   {"MenuAddItem", 0xA3D7},
   {"FrmSetGadgetHandler", 0xA3D8},
   {"CtlSetGraphics", 0xA3D9},
   {"CtlGetSliderValues", 0xA3DA},
   {"CtlSetSliderValues", 0xA3DB},
   {"CtlNewSliderControl", 0xA3DC},
   {"BmpCreate", 0xA3DD},
   {"BmpDelete", 0xA3DE},
   {"BmpCompress", 0xA3DF},
   {"BmpGetColortable", 0xA3E0},
   {"BmpSize", 0xA3E1},
   {"BmpBitsSize", 0xA3E2},
   {"BmpColortableSize", 0xA3E3},
   {"WinCreateBitmapWindow", 0xA3E4},
   {"EvtSetNullEventTick", 0xA3E5},
   {"ExgDoDialog", 0xA3E6},
   {"SysUICleanup", 0xA3E7},
   {"WinSetForeColorRGB", 0xA3E8},
   {"WinSetBackColorRGB", 0xA3E9},
   {"WinSetTextColorRGB", 0xA3EA},
   {"WinGetPixelRGB", 0xA3EB},
   {"HighDensityDispatch", 0xA3EC},
   {"SysReserved40Trap2", 0xA3ED},
   {"SysReserved40Trap3", 0xA3EE},
   {"SysReserved40Trap4", 0xA3EF},
   {"CncMgrDispatch", 0xA3F0},
   {"SysNotifyBroadcastFromInterrupt", 0xA3F1},
   {"EvtWakeupWithoutNilEvent", 0xA3F2},
   {"StrCompareAscii", 0xA3F3},
   {"AccessorDispatch", 0xA3F4},
   {"BltGetPixel", 0xA3F5},
   {"BltPaintPixel", 0xA3F6},
   {"ScrScreenInit", 0xA3F7},
   {"ScrUpdateScreenBitmap", 0xA3F8},
   {"ScrPalette", 0xA3F9},
   {"ScrGetColortable", 0xA3FA},
   {"ScrGetGrayPat", 0xA3FB},
   {"ScrScreenLock", 0xA3FC},
   {"ScrScreenUnlock", 0xA3FD},
   {"FntPrvGetFontList", 0xA3FE},
   {"ExgRegisterDatatype", 0xA3FF},
   {"ExgNotifyReceive", 0xA400},
   {"ExgNotifyGoto", 0xA401},
   {"ExgRequest", 0xA402},
   {"ExgSetDefaultApplication", 0xA403},
   {"ExgGetDefaultApplication", 0xA404},
   {"ExgGetTargetApplication", 0xA405},
   {"ExgGetRegisteredApplications", 0xA406},
   {"ExgGetRegisteredTypes", 0xA407},
   {"ExgNotifyPreview", 0xA408},
   {"ExgControl", 0xA409},
   {"LmDispatch", 0xA40A},
   {"MemGetRomNVParams", 0xA40B},
   {"FntWCharWidth", 0xA40C},
   {"DmFindDatabaseWithTypeCreator", 0xA40D},
   {"SelectTimeZone", 0xA40E},
   {"TimeZoneToAscii", 0xA40F},
   {"StrNCompareAscii", 0xA410},
   {"TimTimeZoneToUTC", 0xA411},
   {"TimUTCToTimeZone", 0xA412},
   {"PhoneNumberLookupCustom", 0xA413},
   {"HwrDebugSelect", 0xA414},
   {"BltRoundedRectangle", 0xA415},
   {"BltRoundedRectangleFill", 0xA416},
   {"WinPrvInitCanvas", 0xA417},
   {"HwrCalcDynamicHeapSize", 0xA418},
   {"HwrDebuggerEnter", 0xA419},
   {"HwrDebuggerExit", 0xA41A},
   {"LstGetTopItem", 0xA41B},
   {"HwrModelInitStage3", 0xA41C},
   {"AttnIndicatorAllow", 0xA41D},
   {"AttnIndicatorAllowed", 0xA41E},
   {"AttnIndicatorEnable", 0xA41F},
   {"AttnIndicatorEnabled", 0xA420},
   {"AttnIndicatorSetBlinkPattern", 0xA421},
   {"AttnIndicatorGetBlinkPattern", 0xA422},
   {"AttnIndicatorTicksTillNextBlink", 0xA423},
   {"AttnIndicatorCheckBlink", 0xA424},
   {"AttnInitialize", 0xA425},
   {"AttnGetAttention", 0xA426},
   {"AttnUpdate", 0xA427},
   {"AttnForgetIt", 0xA428},
   {"AttnGetCounts", 0xA429},
   {"AttnListOpen", 0xA42A},
   {"AttnHandleEvent", 0xA42B},
   {"AttnEffectOfEvent", 0xA42C},
   {"AttnIterate", 0xA42D},
   {"AttnDoSpecialEffects", 0xA42E},
   {"AttnDoEmergencySpecialEffects", 0xA42F},
   {"AttnAllowClose", 0xA430},
   {"AttnReopen", 0xA431},
   {"AttnEnableNotification", 0xA432},
   {"HwrLEDAttributes", 0xA433},
   {"HwrVibrateAttributes", 0xA434},
   {"SecGetPwdHint", 0xA435},
   {"SecSetPwdHint", 0xA436},
   {"HwrFlashWrite", 0xA437},
   {"KeyboardStatusNew", 0xA438},
   {"KeyboardStatusFree", 0xA439},
   {"KbdSetLayout", 0xA43A},
   {"KbdGetLayout", 0xA43B},
   {"KbdSetPosition", 0xA43C},
   {"KbdGetPosition", 0xA43D},
   {"KbdSetShiftState", 0xA43E},
   {"KbdGetShiftState", 0xA43F},
   {"KbdDraw", 0xA440},
   {"KbdErase", 0xA441},
   {"KbdHandleEvent", 0xA442},
   {"OEMDispatch2", 0xA443},
   {"HwrCustom", 0xA444},
   {"FrmGetActiveField", 0xA445},
   {"SndPlaySmfIrregardless", 0xA446},
   {"SndPlaySmfResourceIrregardless", 0xA447},
   {"SndInterruptSmfIrregardless", 0xA448},
   {"UdaMgrDispatch", 0xA449},
   {"PalmPrivate1", 0xA44A},
   {"PalmPrivate2", 0xA44B},
   {"PalmPrivate3", 0xA44C},
   {"PalmPrivate4", 0xA44D},
   {"BmpGetDimensions", 0xA44E},
   {"BmpGetBitDepth", 0xA44F},
   {"BmpGetNextBitmap", 0xA450},
   {"TblGetNumberOfColumns", 0xA451},
   {"TblGetTopRow", 0xA452},
   {"TblSetSelection", 0xA453},
   {"FrmGetObjectIndexFromPtr", 0xA454},
   {"BmpGetSizes", 0xA455},
   {"WinGetBounds", 0xA456},
   {"BltPaintPixels", 0xA457},
   {"FldSetMaxVisibleLines", 0xA458},
   {"ScrDefaultPaletteState", 0xA459},
   {"PceNativeCall", 0xA45A},
   {"SndStreamCreate", 0xA45B},
   {"SndStreamDelete", 0xA45C},
   {"SndStreamStart", 0xA45D},
   {"SndStreamPause", 0xA45E},
   {"SndStreamStop", 0xA45F},
   {"SndStreamSetVolume", 0xA460},
   {"SndStreamGetVolume", 0xA461},
   {"SndPlayResource", 0xA462},
   {"SndStreamSetPan", 0xA463},
   {"SndStreamGetPan", 0xA464},
   {"MultimediaDispatch", 0xA465},
   {"SndStreamCreateExtended", 0xa466},
   {"SndStreamDeviceControl", 0xa467},
   {"BmpCreateVersion3", 0xA468},
   {"ECFixedMul", 0xA469},
   {"ECFixedDiv", 0xA46A},
   {"HALDrawGetSupportedDensity", 0xA46B},
   {"HALRedrawInputArea", 0xA46C},
   {"GrfBeginStroke", 0xA46D},
   {"BmpPrvConvertBitmap", 0xA46E},
   {"SysReservedTrap5", 0xA46F},
   {"PinsDispatch", 0xA470},
   {"SysReservedTrap1", 0xA471},
   {"SysReservedTrap2", 0xA472},
   {"SysReservedTrap3", 0xA473},
   {"SysReservedTrap4", 0xA474},
   {"LastTrapNumber", 0xA475}
};

const char* lookupTrap(uint16_t trap){
   uint32_t i;

   for(i = 0; i < sizeof(traps) / sizeof(traps[0]); i++)
      if(traps[i].trap == trap)
         return traps[i].name;
   return "Trap function ID unknown";
}

uint16_t reverseLookupTrap(const char* name){
   uint32_t i;

   for(i = 0; i < sizeof(traps) / sizeof(traps[0]); i++)
      if(!strcmp(traps[i].name, name))
         return traps[i].trap;
   return 0x0000;
}
