/* -------------------------------------------------------------------------------- */
/* -- µGUI - Generic GUI module (C)Achim Döbler, 2015                            -- */
/* -------------------------------------------------------------------------------- */
// µGUI is a generic GUI module for embedded systems.
// This is a free software that is open for education, research and commercial
// developments under license policy of following terms.
//
//  Copyright (C) 2015, Achim Döbler, all rights reserved.
//  URL: http://www.embeddedlightning.com/
//
// * The µGUI module is a free software and there is NO WARRANTY.
// * No restriction on use. You can use, modify and redistribute it for
//   personal, non-profit or commercial products UNDER YOUR RESPONSIBILITY.
// * Redistributions of source code must retain the above copyright notice.
//
/* -------------------------------------------------------------------------------- */
/* -- MY SPECIAL THANKS GO TO                                                    -- */
/* -------------------------------------------------------------------------------- */
// Andrey Filimonov (-->https://github.com/Sermus)
// for giving valuable suggestions, reporting bugs and adding several new features.
// Andrey also put a lot of work in the implementaion of anti-aliased font support. 
//
// Mikhail Podkur (-->https://github.com/MikhailPodkur)
// for adding cyrillic 8x12 font, checkbox feature and RGB565 support.
//
// Gustavo Denardin
// for giving valuable suggestions regarding real-time os support.
//
// Samuel Kleiser
// for reporting bugs and giving examples how to improve µGUI.
/* -------------------------------------------------------------------------------- */
/* -- REVISION HISTORY                                                           -- */
/* -------------------------------------------------------------------------------- */
//  Dec 20, 2015  V0.31 Checkbox component with all funtions added.
//                      Cyrillic font 8x12 added.
//                      RGB565 color schema added.
//                      Windows components font could be getted from current GUI by default
//  Mar 18, 2015  V0.3  Driver support added.
//                      Window and object support added.
//                      Touch support added.
//                      Fixed some minor bugs.
//
//  Oct 20, 2014  V0.2  Function UG_DrawRoundFrame() added.
//                      Function UG_FillRoundFrame() added.
//                      Function UG_DrawArc() added.
//                      Fixed some minor bugs.
//
//  Oct 11, 2014  V0.1  First release.
/* -------------------------------------------------------------------------------- */
#include "ugui.h"

/* Static functions */
 void _UG_PutChar( char chr, UG_S16 x, UG_S16 y, UG_COLOR fc, UG_COLOR bc, const UG_FONT* font);

/* Pointer to the gui */
static UG_GUI* gui;

#ifdef USE_FONT_4X6
__UG_FONT_DATA unsigned char font_4x6[256][6]={
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x00
{0x04,0x0A,0x0E,0x0A,0x04,0x00}, // 0x01
{0x04,0x0E,0x0A,0x0E,0x04,0x00}, // 0x02
{0x00,0x0A,0x0E,0x0E,0x04,0x00}, // 0x03
{0x00,0x04,0x0E,0x0E,0x04,0x00}, // 0x04
{0x04,0x0E,0x0E,0x04,0x0E,0x00}, // 0x05
{0x04,0x04,0x0E,0x04,0x0E,0x00}, // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0A
{0x00,0x0C,0x08,0x06,0x06,0x00}, // 0x0B
{0x04,0x0A,0x04,0x0E,0x04,0x00}, // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0D
{0x04,0x0C,0x0A,0x08,0x04,0x00}, // 0x0E
{0x04,0x0E,0x0A,0x0E,0x04,0x00}, // 0x0F
{0x02,0x06,0x0E,0x06,0x02,0x00}, // 0x10
{0x08,0x0C,0x0E,0x0C,0x08,0x00}, // 0x11
{0x04,0x0E,0x04,0x0E,0x04,0x00}, // 0x12
{0x0A,0x0A,0x0A,0x00,0x0A,0x00}, // 0x13
{0x00,0x08,0x04,0x04,0x04,0x04}, // 0x14
{0x04,0x04,0x04,0x04,0x02,0x00}, // 0x15
{0x00,0x00,0x00,0x00,0x0E,0x00}, // 0x16
{0x04,0x0E,0x04,0x0E,0x04,0x0E}, // 0x17
{0x04,0x0E,0x04,0x04,0x04,0x00}, // 0x18
{0x04,0x04,0x04,0x0E,0x04,0x00}, // 0x19
{0x00,0x04,0x0F,0x04,0x00,0x00}, // 0x1A
{0x00,0x02,0x0F,0x02,0x00,0x00}, // 0x1B
{0x00,0x00,0x02,0x0E,0x00,0x00}, // 0x1C
{0x00,0x0A,0x0E,0x0A,0x00,0x00}, // 0x1D
{0x00,0x04,0x0E,0x0E,0x00,0x00}, // 0x1E
{0x00,0x0E,0x0E,0x04,0x00,0x00}, // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00}, // 0x20
{0x04,0x04,0x04,0x00,0x04,0x00}, // 0x21
{0x0A,0x0A,0x00,0x00,0x00,0x00}, // 0x22
{0x0A,0x0E,0x0A,0x0E,0x0A,0x00}, // 0x23
{0x04,0x0C,0x06,0x0C,0x06,0x04}, // 0x24
{0x02,0x08,0x04,0x02,0x08,0x00}, // 0x25
{0x04,0x0A,0x0C,0x0A,0x0E,0x00}, // 0x26
{0x06,0x02,0x00,0x00,0x00,0x00}, // 0x27
{0x04,0x02,0x02,0x02,0x04,0x00}, // 0x28
{0x02,0x04,0x04,0x04,0x02,0x00}, // 0x29
{0x0A,0x04,0x0E,0x04,0x0A,0x00}, // 0x2A
{0x00,0x04,0x0E,0x04,0x00,0x00}, // 0x2B
{0x00,0x00,0x00,0x00,0x06,0x02}, // 0x2C
{0x00,0x00,0x0E,0x00,0x00,0x00}, // 0x2D
{0x00,0x00,0x00,0x00,0x04,0x00}, // 0x2E
{0x08,0x08,0x04,0x02,0x02,0x00}, // 0x2F
{0x0C,0x0A,0x0A,0x0A,0x06,0x00}, // 0x30
{0x04,0x06,0x04,0x04,0x0E,0x00}, // 0x31
{0x06,0x08,0x04,0x02,0x0E,0x00}, // 0x32
{0x06,0x08,0x04,0x08,0x06,0x00}, // 0x33
{0x08,0x0A,0x0E,0x08,0x08,0x00}, // 0x34
{0x0E,0x02,0x06,0x08,0x06,0x00}, // 0x35
{0x04,0x02,0x06,0x0A,0x04,0x00}, // 0x36
{0x0E,0x08,0x0C,0x04,0x04,0x00}, // 0x37
{0x04,0x0A,0x04,0x0A,0x04,0x00}, // 0x38
{0x04,0x0A,0x0C,0x08,0x04,0x00}, // 0x39
{0x00,0x00,0x04,0x00,0x04,0x00}, // 0x3A
{0x00,0x00,0x04,0x00,0x06,0x02}, // 0x3B
{0x08,0x04,0x02,0x04,0x08,0x00}, // 0x3C
{0x00,0x00,0x0E,0x00,0x0E,0x00}, // 0x3D
{0x02,0x04,0x08,0x04,0x02,0x00}, // 0x3E
{0x06,0x08,0x04,0x00,0x04,0x00}, // 0x3F
{0x0E,0x0A,0x0A,0x02,0x0E,0x00}, // 0x40
{0x04,0x0A,0x0E,0x0A,0x0A,0x00}, // 0x41
{0x06,0x0A,0x06,0x0A,0x06,0x00}, // 0x42
{0x0C,0x02,0x02,0x02,0x0C,0x00}, // 0x43
{0x06,0x0A,0x0A,0x0A,0x06,0x00}, // 0x44
{0x0E,0x02,0x06,0x02,0x0E,0x00}, // 0x45
{0x0E,0x02,0x06,0x02,0x02,0x00}, // 0x46
{0x0C,0x02,0x0A,0x0A,0x0C,0x00}, // 0x47
{0x0A,0x0A,0x0E,0x0A,0x0A,0x00}, // 0x48
{0x0E,0x04,0x04,0x04,0x0E,0x00}, // 0x49
{0x08,0x08,0x08,0x0A,0x04,0x00}, // 0x4A
{0x0A,0x0A,0x06,0x0A,0x0A,0x00}, // 0x4B
{0x02,0x02,0x02,0x02,0x0E,0x00}, // 0x4C
{0x0A,0x0E,0x0E,0x0A,0x0A,0x00}, // 0x4D
{0x0A,0x0E,0x0A,0x0A,0x0A,0x00}, // 0x4E
{0x04,0x0A,0x0A,0x0A,0x04,0x00}, // 0x4F
{0x06,0x0A,0x06,0x02,0x02,0x00}, // 0x50
{0x04,0x0A,0x0A,0x0E,0x0C,0x00}, // 0x51
{0x06,0x0A,0x06,0x0A,0x0A,0x00}, // 0x52
{0x0C,0x02,0x0E,0x08,0x06,0x00}, // 0x53
{0x0E,0x04,0x04,0x04,0x04,0x00}, // 0x54
{0x0A,0x0A,0x0A,0x0A,0x0E,0x00}, // 0x55
{0x0A,0x0A,0x0A,0x0A,0x04,0x00}, // 0x56
{0x0A,0x0A,0x0E,0x0E,0x0A,0x00}, // 0x57
{0x0A,0x0A,0x04,0x0A,0x0A,0x00}, // 0x58
{0x0A,0x0A,0x04,0x04,0x04,0x00}, // 0x59
{0x0E,0x08,0x04,0x02,0x0E,0x00}, // 0x5A
{0x06,0x02,0x02,0x02,0x06,0x00}, // 0x5B
{0x02,0x02,0x04,0x08,0x08,0x00}, // 0x5C
{0x06,0x04,0x04,0x04,0x06,0x00}, // 0x5D
{0x04,0x0A,0x00,0x00,0x00,0x00}, // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x0F}, // 0x5F
{0x06,0x04,0x00,0x00,0x00,0x00}, // 0x60
{0x00,0x00,0x0C,0x0A,0x0E,0x00}, // 0x61
{0x02,0x02,0x06,0x0A,0x06,0x00}, // 0x62
{0x00,0x00,0x0C,0x02,0x0C,0x00}, // 0x63
{0x08,0x08,0x0C,0x0A,0x0C,0x00}, // 0x64
{0x00,0x00,0x0E,0x06,0x0C,0x00}, // 0x65
{0x08,0x04,0x0E,0x04,0x04,0x00}, // 0x66
{0x00,0x00,0x0E,0x0A,0x08,0x0E}, // 0x67
{0x02,0x02,0x06,0x0A,0x0A,0x00}, // 0x68
{0x04,0x00,0x04,0x04,0x04,0x00}, // 0x69
{0x04,0x00,0x04,0x04,0x04,0x06}, // 0x6A
{0x02,0x02,0x0A,0x06,0x0A,0x00}, // 0x6B
{0x04,0x04,0x04,0x04,0x04,0x00}, // 0x6C
{0x00,0x00,0x0E,0x0E,0x0A,0x00}, // 0x6D
{0x00,0x00,0x06,0x0A,0x0A,0x00}, // 0x6E
{0x00,0x00,0x04,0x0A,0x04,0x00}, // 0x6F
{0x00,0x00,0x06,0x0A,0x06,0x02}, // 0x70
{0x00,0x00,0x0C,0x0A,0x0C,0x08}, // 0x71
{0x00,0x00,0x06,0x02,0x02,0x00}, // 0x72
{0x00,0x00,0x0C,0x04,0x06,0x00}, // 0x73
{0x00,0x04,0x0E,0x04,0x0C,0x00}, // 0x74
{0x00,0x00,0x0A,0x0A,0x0E,0x00}, // 0x75
{0x00,0x00,0x0A,0x0A,0x04,0x00}, // 0x76
{0x00,0x00,0x0A,0x0E,0x0E,0x00}, // 0x77
{0x00,0x00,0x0A,0x04,0x0A,0x00}, // 0x78
{0x00,0x00,0x0A,0x0A,0x04,0x02}, // 0x79
{0x00,0x00,0x06,0x04,0x0C,0x00}, // 0x7A
{0x0C,0x04,0x06,0x04,0x0C,0x00}, // 0x7B
{0x04,0x04,0x04,0x04,0x04,0x00}, // 0x7C
{0x06,0x04,0x0C,0x04,0x06,0x00}, // 0x7D
{0x0A,0x05,0x00,0x00,0x00,0x00}, // 0x7E
{0x00,0x04,0x0A,0x0E,0x00,0x00}, // 0x7F
{0x0C,0x02,0x02,0x0E,0x04,0x02}, // 0x80
{0x0A,0x00,0x0A,0x0A,0x0C,0x00}, // 0x81
{0x08,0x04,0x0E,0x06,0x0C,0x00}, // 0x82
{0x04,0x0A,0x0C,0x0A,0x0E,0x00}, // 0x83
{0x0A,0x00,0x0C,0x0A,0x0E,0x00}, // 0x84
{0x02,0x04,0x0C,0x0A,0x0E,0x00}, // 0x85
{0x04,0x00,0x0C,0x0A,0x0E,0x00}, // 0x86
{0x00,0x0E,0x02,0x0E,0x04,0x06}, // 0x87
{0x04,0x0A,0x0E,0x06,0x0C,0x00}, // 0x88
{0x0A,0x00,0x0E,0x06,0x0C,0x00}, // 0x89
{0x02,0x04,0x0E,0x06,0x0C,0x00}, // 0x8A
{0x0A,0x00,0x04,0x04,0x04,0x00}, // 0x8B
{0x04,0x0A,0x00,0x04,0x04,0x00}, // 0x8C
{0x02,0x04,0x00,0x04,0x04,0x00}, // 0x8D
{0x0A,0x04,0x0A,0x0E,0x0A,0x00}, // 0x8E
{0x04,0x04,0x0A,0x0E,0x0A,0x00}, // 0x8F
{0x08,0x04,0x0E,0x06,0x0E,0x00}, // 0x90
{0x00,0x00,0x0C,0x0E,0x06,0x00}, // 0x91
{0x0C,0x06,0x0E,0x06,0x0E,0x00}, // 0x92
{0x04,0x0A,0x04,0x0A,0x04,0x00}, // 0x93
{0x0A,0x00,0x04,0x0A,0x04,0x00}, // 0x94
{0x02,0x04,0x04,0x0A,0x04,0x00}, // 0x95
{0x04,0x0A,0x00,0x0A,0x0E,0x00}, // 0x96
{0x02,0x04,0x0A,0x0A,0x0E,0x00}, // 0x97
{0x0A,0x00,0x0A,0x0A,0x04,0x02}, // 0x98
{0x0A,0x04,0x0A,0x0A,0x04,0x00}, // 0x99
{0x0A,0x00,0x0A,0x0A,0x0E,0x00}, // 0x9A
{0x04,0x0E,0x02,0x0E,0x04,0x00}, // 0x9B
{0x08,0x04,0x0E,0x04,0x0E,0x00}, // 0x9C
{0x0A,0x0E,0x04,0x0E,0x04,0x00}, // 0x9D
{0x00,0x06,0x06,0x0A,0x0A,0x00}, // 0x9E
{0x0C,0x04,0x0C,0x04,0x06,0x00}, // 0x9F
{0x08,0x04,0x0C,0x0A,0x0E,0x00}, // 0xA0
{0x08,0x04,0x00,0x04,0x04,0x00}, // 0xA1
{0x08,0x04,0x0E,0x0A,0x0E,0x00}, // 0xA2
{0x08,0x04,0x00,0x0A,0x0E,0x00}, // 0xA3
{0x0E,0x00,0x0E,0x0A,0x0A,0x00}, // 0xA4
{0x0E,0x00,0x0A,0x0E,0x0A,0x00}, // 0xA5
{0x0C,0x0A,0x0E,0x00,0x0E,0x00}, // 0xA6
{0x04,0x0A,0x04,0x00,0x0E,0x00}, // 0xA7
{0x04,0x00,0x04,0x02,0x0C,0x00}, // 0xA8
{0x00,0x0E,0x02,0x02,0x00,0x00}, // 0xA9
{0x00,0x07,0x04,0x04,0x00,0x00}, // 0xAA
{0x02,0x0A,0x04,0x0A,0x0C,0x00}, // 0xAB
{0x02,0x0A,0x04,0x0E,0x08,0x00}, // 0xAC
{0x04,0x00,0x04,0x04,0x04,0x00}, // 0xAD
{0x00,0x0A,0x05,0x0A,0x00,0x00}, // 0xAE
{0x00,0x05,0x0A,0x05,0x00,0x00}, // 0xAF
{0x02,0x08,0x02,0x08,0x02,0x08}, // 0xB0
{0x0A,0x05,0x0A,0x05,0x0A,0x05}, // 0xB1
{0x0D,0x07,0x0D,0x07,0x0D,0x07}, // 0xB2
{0x04,0x04,0x04,0x04,0x04,0x04}, // 0xB3
{0x04,0x04,0x07,0x04,0x04,0x04}, // 0xB4
{0x04,0x07,0x04,0x07,0x04,0x04}, // 0xB5
{0x0A,0x0A,0x0B,0x0A,0x0A,0x0A}, // 0xB6
{0x00,0x00,0x0F,0x0A,0x0A,0x0A}, // 0xB7
{0x00,0x07,0x04,0x07,0x04,0x04}, // 0xB8
{0x0A,0x0B,0x08,0x0B,0x0A,0x0A}, // 0xB9
{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xBA
{0x00,0x0F,0x08,0x0B,0x0A,0x0A}, // 0xBB
{0x0A,0x0B,0x08,0x0F,0x00,0x00}, // 0xBC
{0x0A,0x0A,0x0F,0x00,0x00,0x00}, // 0xBD
{0x04,0x07,0x04,0x07,0x00,0x00}, // 0xBE
{0x00,0x00,0x07,0x04,0x04,0x04}, // 0xBF
{0x04,0x04,0x0C,0x00,0x00,0x00}, // 0xC0
{0x04,0x04,0x0F,0x00,0x00,0x00}, // 0xC1
{0x00,0x00,0x0F,0x04,0x04,0x04}, // 0xC2
{0x04,0x04,0x0C,0x04,0x04,0x04}, // 0xC3
{0x00,0x00,0x0F,0x00,0x00,0x00}, // 0xC4
{0x04,0x04,0x0F,0x04,0x04,0x04}, // 0xC5
{0x04,0x0C,0x04,0x0C,0x04,0x04}, // 0xC6
{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xC7
{0x0A,0x0A,0x02,0x0E,0x00,0x00}, // 0xC8
{0x00,0x0E,0x02,0x0A,0x0A,0x0A}, // 0xC9
{0x0A,0x0B,0x00,0x0F,0x00,0x00}, // 0xCA
{0x00,0x0F,0x00,0x0B,0x0A,0x0A}, // 0xCB
{0x0A,0x0A,0x02,0x0A,0x0A,0x0A}, // 0xCC
{0x00,0x0F,0x00,0x0F,0x00,0x00}, // 0xCD
{0x0A,0x0B,0x00,0x0B,0x0A,0x0A}, // 0xCE
{0x04,0x0F,0x00,0x0F,0x00,0x00}, // 0xCF
{0x0A,0x0A,0x0F,0x00,0x00,0x00}, // 0xD0
{0x00,0x0F,0x00,0x0F,0x04,0x04}, // 0xD1
{0x00,0x00,0x0F,0x0A,0x0A,0x0A}, // 0xD2
{0x0A,0x0A,0x0E,0x00,0x00,0x00}, // 0xD3
{0x04,0x0C,0x04,0x0C,0x00,0x00}, // 0xD4
{0x00,0x0C,0x04,0x0C,0x04,0x04}, // 0xD5
{0x00,0x00,0x0E,0x0A,0x0A,0x0A}, // 0xD6
{0x0A,0x0A,0x0B,0x0A,0x0A,0x0A}, // 0xD7
{0x04,0x0F,0x00,0x0F,0x04,0x04}, // 0xD8
{0x04,0x04,0x07,0x00,0x00,0x00}, // 0xD9
{0x00,0x00,0x0C,0x04,0x04,0x04}, // 0xDA
{0x0F,0x0F,0x0F,0x0F,0x0F,0x0F}, // 0xDB
{0x00,0x00,0x00,0x0F,0x0F,0x0F}, // 0xDC
{0x03,0x03,0x03,0x03,0x03,0x03}, // 0xDD
{0x0C,0x0C,0x0C,0x0C,0x0C,0x0C}, // 0xDE
{0x0F,0x0F,0x0F,0x00,0x00,0x00}, // 0xDF
{0x00,0x00,0x0E,0x06,0x0E,0x00}, // 0xE0
{0x04,0x0A,0x06,0x0A,0x06,0x02}, // 0xE1
{0x0E,0x0A,0x02,0x02,0x02,0x00}, // 0xE2
{0x0E,0x0A,0x0A,0x0A,0x0A,0x00}, // 0xE3
{0x0E,0x02,0x04,0x02,0x0E,0x00}, // 0xE4
{0x00,0x00,0x0C,0x0A,0x04,0x00}, // 0xE5
{0x00,0x00,0x0A,0x0A,0x0E,0x02}, // 0xE6
{0x00,0x08,0x06,0x04,0x04,0x00}, // 0xE7
{0x0E,0x04,0x0A,0x04,0x0E,0x00}, // 0xE8
{0x04,0x0A,0x0E,0x0A,0x04,0x00}, // 0xE9
{0x00,0x04,0x0A,0x0A,0x0A,0x00}, // 0xEA
{0x0C,0x02,0x04,0x0A,0x04,0x00}, // 0xEB
{0x00,0x00,0x0E,0x0A,0x0E,0x00}, // 0xEC
{0x04,0x0E,0x0A,0x0E,0x04,0x00}, // 0xED
{0x0C,0x02,0x0E,0x02,0x0C,0x00}, // 0xEE
{0x04,0x0A,0x0A,0x0A,0x0A,0x00}, // 0xEF
{0x0E,0x00,0x0E,0x00,0x0E,0x00}, // 0xF0
{0x04,0x0E,0x04,0x00,0x0E,0x00}, // 0xF1
{0x06,0x08,0x06,0x00,0x0E,0x00}, // 0xF2
{0x0C,0x02,0x0C,0x00,0x0E,0x00}, // 0xF3
{0x00,0x08,0x04,0x04,0x04,0x04}, // 0xF4
{0x04,0x04,0x04,0x04,0x02,0x00}, // 0xF5
{0x04,0x00,0x0E,0x00,0x04,0x00}, // 0xF6
{0x00,0x0A,0x05,0x0A,0x05,0x00}, // 0xF7
{0x04,0x0A,0x04,0x00,0x00,0x00}, // 0xF8
{0x00,0x04,0x0E,0x04,0x00,0x00}, // 0xF9
{0x00,0x00,0x04,0x00,0x00,0x00}, // 0xFA
{0x0C,0x04,0x04,0x06,0x04,0x00}, // 0xFB
{0x0E,0x0A,0x0A,0x00,0x00,0x00}, // 0xFC
{0x06,0x04,0x02,0x06,0x00,0x00}, // 0xFD
{0x00,0x00,0x06,0x06,0x00,0x00}, // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00}  // 0xFF
};
#endif

#ifdef USE_FONT_5X8
__UG_FONT_DATA unsigned char font_5x8[256][8]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0x0E,0x11,0x1B,0x11,0x1F,0x0E,0x00,0x00},   // 0x01
{0x0E,0x15,0x1F,0x11,0x1F,0x0E,0x00,0x00},   // 0x02
{0x0A,0x1F,0x1F,0x1F,0x0E,0x04,0x00,0x00},   // 0x03
{0x04,0x04,0x0E,0x1F,0x0E,0x04,0x04,0x00},   // 0x04
{0x04,0x0E,0x04,0x1F,0x15,0x04,0x0E,0x00},   // 0x05
{0x04,0x0E,0x1F,0x1F,0x15,0x04,0x0E,0x00},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0x18,0x18,0x0E,0x11,0x11,0x11,0x0E,0x00},   // 0x0B
{0x0E,0x11,0x11,0x11,0x0E,0x04,0x0E,0x04},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0x18,0x1E,0x12,0x12,0x1A,0x1B,0x03,0x00},   // 0x0E
{0x00,0x15,0x0E,0x1B,0x0E,0x15,0x00,0x00},   // 0x0F
{0x00,0x01,0x07,0x1F,0x07,0x01,0x00,0x00},   // 0x10
{0x00,0x10,0x1C,0x1F,0x1C,0x10,0x00,0x00},   // 0x11
{0x04,0x0E,0x04,0x04,0x04,0x0E,0x04,0x00},   // 0x12
{0x00,0x0A,0x0A,0x0A,0x00,0x0A,0x00,0x00},   // 0x13
{0x0E,0x0B,0x0B,0x0A,0x0A,0x0A,0x0A,0x00},   // 0x14
{0x0C,0x02,0x04,0x0A,0x04,0x08,0x06,0x00},   // 0x15
{0x00,0x00,0x00,0x1E,0x1E,0x00,0x00,0x00},   // 0x16
{0x04,0x0E,0x04,0x0E,0x04,0x00,0x0E,0x00},   // 0x17
{0x04,0x0E,0x04,0x04,0x04,0x04,0x04,0x00},   // 0x18
{0x04,0x04,0x04,0x04,0x04,0x0E,0x04,0x00},   // 0x19
{0x00,0x00,0x08,0x1E,0x08,0x00,0x00,0x00},   // 0x1A
{0x00,0x00,0x04,0x1E,0x04,0x00,0x00,0x00},   // 0x1B
{0x00,0x00,0x02,0x02,0x02,0x1E,0x00,0x00},   // 0x1C
{0x00,0x00,0x0A,0x1F,0x0A,0x00,0x00,0x00},   // 0x1D
{0x00,0x04,0x04,0x0E,0x0E,0x1F,0x00,0x00},   // 0x1E
{0x00,0x1F,0x0E,0x0E,0x04,0x04,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00},   // 0x21
{0x0A,0x0A,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x00,0x14,0x1F,0x0A,0x1F,0x05,0x00,0x00},   // 0x23
{0x04,0x0E,0x06,0x04,0x0C,0x0E,0x04,0x00},   // 0x24
{0x12,0x15,0x0E,0x0E,0x15,0x09,0x00,0x00},   // 0x25
{0x04,0x0A,0x06,0x15,0x09,0x16,0x00,0x00},   // 0x26
{0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0x18,0x04,0x02,0x02,0x02,0x04,0x18,0x00},   // 0x28
{0x03,0x04,0x08,0x08,0x08,0x04,0x03,0x00},   // 0x29
{0x04,0x0A,0x04,0x0A,0x00,0x00,0x00,0x00},   // 0x2A
{0x00,0x00,0x00,0x04,0x0E,0x04,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x02},   // 0x2C
{0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00},   // 0x2E
{0x10,0x08,0x08,0x04,0x04,0x02,0x02,0x00},   // 0x2F
{0x0C,0x12,0x12,0x12,0x12,0x0C,0x00,0x00},   // 0x30
{0x04,0x06,0x04,0x04,0x04,0x0E,0x00,0x00},   // 0x31
{0x06,0x08,0x08,0x04,0x02,0x0E,0x00,0x00},   // 0x32
{0x06,0x08,0x06,0x08,0x08,0x06,0x00,0x00},   // 0x33
{0x08,0x0C,0x0A,0x1E,0x08,0x08,0x00,0x00},   // 0x34
{0x0E,0x02,0x06,0x08,0x08,0x06,0x00,0x00},   // 0x35
{0x0C,0x02,0x0E,0x12,0x12,0x0C,0x00,0x00},   // 0x36
{0x1E,0x10,0x08,0x04,0x04,0x04,0x00,0x00},   // 0x37
{0x0C,0x12,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0x38
{0x0C,0x12,0x12,0x1C,0x10,0x0C,0x00,0x00},   // 0x39
{0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00},   // 0x3A
{0x00,0x00,0x04,0x00,0x00,0x04,0x04,0x02},   // 0x3B
{0x00,0x10,0x08,0x06,0x08,0x10,0x00,0x00},   // 0x3C
{0x00,0x00,0x1E,0x00,0x1E,0x00,0x00,0x00},   // 0x3D
{0x00,0x02,0x04,0x18,0x04,0x02,0x00,0x00},   // 0x3E
{0x0E,0x10,0x08,0x04,0x00,0x04,0x00,0x00},   // 0x3F
{0x0C,0x12,0x19,0x15,0x1D,0x01,0x1E,0x00},   // 0x40
{0x00,0x04,0x0A,0x0A,0x1F,0x11,0x00,0x00},   // 0x41
{0x00,0x0E,0x0A,0x06,0x0A,0x0E,0x00,0x00},   // 0x42
{0x00,0x1C,0x02,0x02,0x02,0x1C,0x00,0x00},   // 0x43
{0x00,0x0E,0x12,0x12,0x12,0x0E,0x00,0x00},   // 0x44
{0x00,0x0E,0x02,0x0E,0x02,0x0E,0x00,0x00},   // 0x45
{0x00,0x0E,0x02,0x0E,0x02,0x02,0x00,0x00},   // 0x46
{0x00,0x1C,0x02,0x1A,0x12,0x1C,0x00,0x00},   // 0x47
{0x00,0x12,0x12,0x1E,0x12,0x12,0x00,0x00},   // 0x48
{0x00,0x0E,0x04,0x04,0x04,0x0E,0x00,0x00},   // 0x49
{0x00,0x0E,0x08,0x08,0x08,0x06,0x00,0x00},   // 0x4A
{0x00,0x12,0x0A,0x06,0x0A,0x12,0x00,0x00},   // 0x4B
{0x00,0x02,0x02,0x02,0x02,0x1E,0x00,0x00},   // 0x4C
{0x00,0x11,0x1B,0x15,0x15,0x11,0x00,0x00},   // 0x4D
{0x00,0x12,0x16,0x1A,0x12,0x12,0x00,0x00},   // 0x4E
{0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},   // 0x4F
{0x00,0x0E,0x12,0x0E,0x02,0x02,0x00,0x00},   // 0x50
{0x00,0x0E,0x11,0x11,0x11,0x0E,0x08,0x10},   // 0x51
{0x00,0x06,0x0A,0x06,0x0A,0x12,0x00,0x00},   // 0x52
{0x00,0x0C,0x02,0x04,0x08,0x06,0x00,0x00},   // 0x53
{0x00,0x1F,0x04,0x04,0x04,0x04,0x00,0x00},   // 0x54
{0x00,0x12,0x12,0x12,0x12,0x0C,0x00,0x00},   // 0x55
{0x00,0x12,0x12,0x12,0x0C,0x0C,0x00,0x00},   // 0x56
{0x00,0x11,0x15,0x15,0x0A,0x0A,0x00,0x00},   // 0x57
{0x00,0x11,0x0A,0x04,0x0A,0x11,0x00,0x00},   // 0x58
{0x00,0x11,0x0A,0x04,0x04,0x04,0x00,0x00},   // 0x59
{0x00,0x1E,0x10,0x0C,0x02,0x1E,0x00,0x00},   // 0x5A
{0x0C,0x04,0x04,0x04,0x04,0x04,0x0C,0x00},   // 0x5B
{0x01,0x02,0x02,0x04,0x04,0x08,0x08,0x00},   // 0x5C
{0x06,0x04,0x04,0x04,0x04,0x04,0x06,0x00},   // 0x5D
{0x04,0x0A,0x0A,0x11,0x11,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00},   // 0x5F
{0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0x61
{0x02,0x02,0x0E,0x12,0x12,0x0E,0x00,0x00},   // 0x62
{0x00,0x00,0x0C,0x02,0x02,0x0C,0x00,0x00},   // 0x63
{0x08,0x08,0x0E,0x09,0x09,0x0E,0x00,0x00},   // 0x64
{0x00,0x00,0x04,0x0E,0x02,0x0C,0x00,0x00},   // 0x65
{0x18,0x04,0x1E,0x04,0x04,0x04,0x00,0x00},   // 0x66
{0x00,0x00,0x1C,0x12,0x1E,0x10,0x0E,0x00},   // 0x67
{0x02,0x02,0x0A,0x16,0x12,0x12,0x00,0x00},   // 0x68
{0x04,0x00,0x06,0x04,0x04,0x04,0x00,0x00},   // 0x69
{0x08,0x00,0x0E,0x08,0x08,0x08,0x06,0x00},   // 0x6A
{0x02,0x02,0x0A,0x06,0x0A,0x12,0x00,0x00},   // 0x6B
{0x06,0x04,0x04,0x04,0x04,0x04,0x00,0x00},   // 0x6C
{0x00,0x00,0x15,0x1F,0x15,0x15,0x00,0x00},   // 0x6D
{0x00,0x00,0x0A,0x16,0x12,0x12,0x00,0x00},   // 0x6E
{0x00,0x00,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0x6F
{0x00,0x00,0x0E,0x12,0x12,0x0E,0x02,0x00},   // 0x70
{0x00,0x00,0x0E,0x09,0x09,0x0E,0x08,0x00},   // 0x71
{0x00,0x00,0x0A,0x06,0x02,0x02,0x00,0x00},   // 0x72
{0x00,0x00,0x0C,0x06,0x08,0x06,0x00,0x00},   // 0x73
{0x00,0x04,0x1E,0x04,0x04,0x08,0x00,0x00},   // 0x74
{0x00,0x00,0x12,0x12,0x1A,0x14,0x00,0x00},   // 0x75
{0x00,0x00,0x12,0x12,0x0C,0x0C,0x00,0x00},   // 0x76
{0x00,0x00,0x15,0x15,0x0E,0x0A,0x00,0x00},   // 0x77
{0x00,0x00,0x12,0x0C,0x0C,0x12,0x00,0x00},   // 0x78
{0x00,0x00,0x12,0x12,0x0C,0x0C,0x07,0x00},   // 0x79
{0x00,0x00,0x0E,0x0C,0x02,0x0E,0x00,0x00},   // 0x7A
{0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00},   // 0x7B
{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00},   // 0x7C
{0x02,0x04,0x04,0x08,0x04,0x04,0x02,0x00},   // 0x7D
{0x00,0x00,0x00,0x16,0x09,0x00,0x00,0x00},   // 0x7E
{0x00,0x04,0x0A,0x0A,0x0A,0x0E,0x00,0x00},   // 0x7F
{0x00,0x1C,0x02,0x02,0x02,0x1C,0x08,0x04},   // 0x80
{0x12,0x00,0x12,0x12,0x1A,0x14,0x00,0x00},   // 0x81
{0x10,0x08,0x04,0x0E,0x02,0x0C,0x00,0x00},   // 0x82
{0x0C,0x12,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0x83
{0x0A,0x00,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0x84
{0x01,0x02,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0x85
{0x04,0x0A,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0x86
{0x00,0x00,0x0C,0x02,0x02,0x0C,0x08,0x04},   // 0x87
{0x0C,0x12,0x04,0x0E,0x02,0x0C,0x00,0x00},   // 0x88
{0x0A,0x00,0x04,0x0E,0x02,0x0C,0x00,0x00},   // 0x89
{0x01,0x02,0x04,0x0E,0x02,0x0C,0x00,0x00},   // 0x8A
{0x0A,0x00,0x06,0x04,0x04,0x04,0x00,0x00},   // 0x8B
{0x0C,0x12,0x06,0x04,0x04,0x04,0x00,0x00},   // 0x8C
{0x01,0x02,0x06,0x04,0x04,0x04,0x00,0x00},   // 0x8D
{0x0A,0x04,0x0A,0x0A,0x1F,0x11,0x00,0x00},   // 0x8E
{0x04,0x0A,0x04,0x0A,0x1F,0x11,0x00,0x00},   // 0x8F
{0x10,0x0E,0x02,0x0E,0x02,0x0E,0x00,0x00},   // 0x90
{0x00,0x00,0x0B,0x1C,0x07,0x19,0x00,0x00},   // 0x91
{0x00,0x1C,0x0A,0x1A,0x0F,0x19,0x00,0x00},   // 0x92
{0x06,0x09,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0x93
{0x12,0x00,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0x94
{0x01,0x02,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0x95
{0x06,0x09,0x12,0x12,0x1A,0x14,0x00,0x00},   // 0x96
{0x02,0x04,0x12,0x12,0x1A,0x14,0x00,0x00},   // 0x97
{0x12,0x00,0x12,0x12,0x0C,0x0C,0x07,0x00},   // 0x98
{0x11,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},   // 0x99
{0x09,0x12,0x12,0x12,0x12,0x0C,0x00,0x00},   // 0x9A
{0x00,0x10,0x0C,0x1A,0x16,0x0C,0x02,0x00},   // 0x9B
{0x00,0x04,0x02,0x06,0x03,0x0E,0x00,0x00},   // 0x9C
{0x10,0x0E,0x19,0x15,0x13,0x0E,0x01,0x00},   // 0x9D
{0x00,0x00,0x12,0x0C,0x0C,0x12,0x00,0x00},   // 0x9E
{0x08,0x04,0x04,0x0E,0x04,0x04,0x02,0x00},   // 0x9F
{0x10,0x08,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0xA0
{0x10,0x08,0x06,0x04,0x04,0x04,0x00,0x00},   // 0xA1
{0x10,0x08,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0xA2
{0x10,0x08,0x12,0x12,0x1A,0x14,0x00,0x00},   // 0xA3
{0x1E,0x00,0x0A,0x16,0x12,0x12,0x00,0x00},   // 0xA4
{0x1F,0x12,0x16,0x1A,0x12,0x12,0x00,0x00},   // 0xA5
{0x06,0x08,0x0E,0x0A,0x0E,0x00,0x00,0x00},   // 0xA6
{0x04,0x0A,0x0A,0x0A,0x04,0x00,0x00,0x00},   // 0xA7
{0x00,0x04,0x00,0x04,0x04,0x08,0x06,0x00},   // 0xA8
{0x0E,0x1D,0x1D,0x15,0x1D,0x0E,0x00,0x00},   // 0xA9
{0x00,0x00,0x00,0x0E,0x08,0x08,0x00,0x00},   // 0xAA
{0x13,0x0A,0x1E,0x14,0x0A,0x19,0x00,0x00},   // 0xAB
{0x13,0x0A,0x0A,0x14,0x1A,0x11,0x00,0x00},   // 0xAC
{0x00,0x00,0x04,0x00,0x04,0x04,0x04,0x00},   // 0xAD
{0x00,0x14,0x0A,0x05,0x0A,0x14,0x00,0x00},   // 0xAE
{0x00,0x05,0x0A,0x14,0x0A,0x05,0x00,0x00},   // 0xAF
{0x15,0x00,0x15,0x00,0x15,0x00,0x15,0x00},   // 0xB0
{0x15,0x0A,0x15,0x0A,0x15,0x0A,0x15,0x0A},   // 0xB1
{0x1F,0x15,0x1F,0x15,0x1F,0x15,0x1F,0x15},   // 0xB2
{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04},   // 0xB3
{0x04,0x04,0x04,0x07,0x04,0x04,0x04,0x04},   // 0xB4
{0x08,0x04,0x0A,0x0A,0x1F,0x11,0x00,0x00},   // 0xB5
{0x0C,0x12,0x04,0x0A,0x1F,0x11,0x00,0x00},   // 0xB6
{0x02,0x04,0x0A,0x0A,0x1F,0x11,0x00,0x00},   // 0xB7
{0x0E,0x11,0x1D,0x15,0x1D,0x11,0x0E,0x00},   // 0xB8
{0x0A,0x0A,0x0B,0x08,0x0B,0x0A,0x0A,0x0A},   // 0xB9
{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A},   // 0xBA
{0x00,0x00,0x0F,0x08,0x0B,0x0A,0x0A,0x0A},   // 0xBB
{0x0A,0x0A,0x0B,0x08,0x0F,0x00,0x00,0x00},   // 0xBC
{0x00,0x04,0x0E,0x02,0x0E,0x04,0x00,0x00},   // 0xBD
{0x00,0x11,0x0A,0x04,0x0E,0x04,0x00,0x00},   // 0xBE
{0x00,0x00,0x00,0x07,0x04,0x04,0x04,0x04},   // 0xBF
{0x04,0x04,0x04,0x1C,0x00,0x00,0x00,0x00},   // 0xC0
{0x04,0x04,0x04,0x1F,0x00,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x1F,0x04,0x04,0x04,0x04},   // 0xC2
{0x04,0x04,0x04,0x1C,0x04,0x04,0x04,0x04},   // 0xC3
{0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00},   // 0xC4
{0x04,0x04,0x04,0x1F,0x04,0x04,0x04,0x04},   // 0xC5
{0x16,0x09,0x06,0x08,0x0E,0x1E,0x00,0x00},   // 0xC6
{0x16,0x09,0x04,0x0A,0x1F,0x11,0x00,0x00},   // 0xC7
{0x0A,0x0A,0x1A,0x02,0x1E,0x00,0x00,0x00},   // 0xC8
{0x00,0x00,0x1E,0x02,0x1A,0x0A,0x0A,0x0A},   // 0xC9
{0x0A,0x0A,0x1B,0x00,0x1F,0x00,0x00,0x00},   // 0xCA
{0x00,0x00,0x1F,0x00,0x1B,0x0A,0x0A,0x0A},   // 0xCB
{0x0A,0x0A,0x1A,0x02,0x1A,0x0A,0x0A,0x0A},   // 0xCC
{0x00,0x00,0x1F,0x00,0x1F,0x00,0x00,0x00},   // 0xCD
{0x0A,0x0A,0x1B,0x00,0x1B,0x0A,0x0A,0x0A},   // 0xCE
{0x00,0x11,0x0E,0x0A,0x0E,0x11,0x00,0x00},   // 0xCF
{0x0F,0x04,0x0E,0x09,0x09,0x06,0x00,0x00},   // 0xD0
{0x00,0x0E,0x12,0x17,0x12,0x0E,0x00,0x00},   // 0xD1
{0x0E,0x0E,0x02,0x0E,0x02,0x0E,0x00,0x00},   // 0xD2
{0x11,0x0E,0x02,0x0E,0x02,0x0E,0x00,0x00},   // 0xD3
{0x01,0x0E,0x02,0x0E,0x02,0x0E,0x00,0x00},   // 0xD4
{0x00,0x00,0x06,0x04,0x04,0x04,0x00,0x00},   // 0xD5
{0x10,0x0E,0x04,0x04,0x04,0x0E,0x00,0x00},   // 0xD6
{0x0E,0x0E,0x04,0x04,0x04,0x0E,0x00,0x00},   // 0xD7
{0x11,0x0E,0x04,0x04,0x04,0x0E,0x00,0x00},   // 0xD8
{0x04,0x04,0x04,0x07,0x00,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x1C,0x04,0x04,0x04,0x04},   // 0xDA
{0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F},   // 0xDB
{0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0x1F},   // 0xDC
{0x04,0x04,0x04,0x00,0x00,0x04,0x04,0x04},   // 0xDD
{0x01,0x0E,0x04,0x04,0x04,0x0E,0x00,0x00},   // 0xDE
{0x1F,0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00},   // 0xDF
{0x10,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},   // 0xE0
{0x04,0x0A,0x0A,0x0A,0x12,0x0A,0x00,0x00},   // 0xE1
{0x0E,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},   // 0xE2
{0x01,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},   // 0xE3
{0x16,0x09,0x0C,0x12,0x12,0x0C,0x00,0x00},   // 0xE4
{0x0F,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},   // 0xE5
{0x00,0x00,0x12,0x12,0x1A,0x16,0x02,0x00},   // 0xE6
{0x02,0x02,0x0E,0x12,0x12,0x0E,0x02,0x00},   // 0xE7
{0x00,0x02,0x0E,0x12,0x0E,0x02,0x00,0x00},   // 0xE8
{0x10,0x09,0x09,0x09,0x09,0x06,0x00,0x00},   // 0xE9
{0x1E,0x12,0x12,0x12,0x12,0x0C,0x00,0x00},   // 0xEA
{0x01,0x12,0x12,0x12,0x12,0x0C,0x00,0x00},   // 0xEB
{0x10,0x08,0x12,0x12,0x0C,0x0C,0x03,0x00},   // 0xEC
{0x08,0x15,0x0A,0x04,0x04,0x04,0x00,0x00},   // 0xED
{0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x00},   // 0xF0
{0x00,0x00,0x04,0x0E,0x04,0x0E,0x00,0x00},   // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x1F},   // 0xF2
{0x13,0x0B,0x0A,0x17,0x1A,0x11,0x00,0x00},   // 0xF3
{0x0E,0x0B,0x0B,0x0A,0x0A,0x0A,0x0A,0x00},   // 0xF4
{0x0C,0x02,0x04,0x0A,0x04,0x08,0x06,0x00},   // 0xF5
{0x00,0x04,0x00,0x0E,0x00,0x04,0x00,0x00},   // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x02},   // 0xF7
{0x0C,0x12,0x12,0x0C,0x00,0x00,0x00,0x00},   // 0xF8
{0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00},   // 0xFA
{0x06,0x04,0x04,0x04,0x0E,0x00,0x00,0x00},   // 0xFB
{0x06,0x08,0x06,0x08,0x06,0x00,0x00,0x00},   // 0xFC
{0x06,0x08,0x04,0x02,0x0E,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x1E,0x1E,0x1E,0x1E,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_5X12
__UG_FONT_DATA unsigned char font_5x12[256][12]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x00
{0x0E,0x11,0x11,0x1B,0x11,0x11,0x1B,0x15,0x11,0x0E,0x00,0x00}, // 0x01
{0x0E,0x1F,0x1F,0x15,0x1F,0x1F,0x15,0x1B,0x1F,0x0E,0x00,0x00}, // 0x02
{0x00,0x0A,0x1B,0x1F,0x1F,0x1F,0x1F,0x0E,0x0E,0x04,0x04,0x00}, // 0x03
{0x04,0x04,0x0E,0x0E,0x1F,0x1F,0x1F,0x0E,0x0E,0x04,0x04,0x00}, // 0x04
{0x04,0x0E,0x0E,0x0E,0x04,0x1F,0x1F,0x0E,0x04,0x0E,0x00,0x00}, // 0x05
{0x04,0x04,0x0E,0x0E,0x1F,0x1F,0x1F,0x0E,0x04,0x0E,0x00,0x00}, // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0A
{0x00,0x00,0x1C,0x18,0x14,0x06,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x0B
{0x00,0x06,0x09,0x09,0x09,0x06,0x02,0x02,0x07,0x02,0x00,0x00}, // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0D
{0x0C,0x0A,0x0E,0x0A,0x0A,0x0A,0x0E,0x0E,0x03,0x03,0x00,0x00}, // 0x0E
{0x00,0x00,0x00,0x00,0x15,0x0E,0x11,0x0E,0x15,0x00,0x00,0x00}, // 0x0F
{0x00,0x00,0x01,0x03,0x07,0x0F,0x07,0x03,0x01,0x00,0x00,0x00}, // 0x10
{0x00,0x00,0x08,0x0C,0x0E,0x0F,0x0E,0x0C,0x08,0x00,0x00,0x00}, // 0x11
{0x00,0x04,0x0E,0x15,0x04,0x04,0x04,0x15,0x0E,0x04,0x00,0x00}, // 0x12
{0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x00,0x0A,0x0A,0x00,0x00}, // 0x13
{0x00,0x0E,0x0B,0x0B,0x0B,0x0B,0x0A,0x0A,0x0A,0x0A,0x00,0x00}, // 0x14
{0x00,0x06,0x09,0x01,0x06,0x09,0x06,0x08,0x09,0x06,0x00,0x00}, // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x00}, // 0x16
{0x00,0x04,0x0E,0x15,0x04,0x04,0x04,0x15,0x0E,0x04,0x1F,0x00}, // 0x17
{0x00,0x04,0x0E,0x15,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00}, // 0x18
{0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x15,0x0E,0x04,0x00,0x00}, // 0x19
{0x00,0x00,0x00,0x02,0x04,0x0F,0x04,0x02,0x00,0x00,0x00,0x00}, // 0x1A
{0x00,0x00,0x00,0x04,0x02,0x0F,0x02,0x04,0x00,0x00,0x00,0x00}, // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x0F,0x00,0x00,0x00,0x00}, // 0x1C
{0x00,0x00,0x00,0x0A,0x0A,0x1F,0x0A,0x0A,0x00,0x00,0x00,0x00}, // 0x1D
{0x00,0x00,0x00,0x04,0x04,0x0E,0x0E,0x1F,0x00,0x00,0x00,0x00}, // 0x1E
{0x00,0x00,0x00,0x1F,0x0E,0x0E,0x04,0x04,0x00,0x00,0x00,0x00}, // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x20
{0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x04,0x00,0x00}, // 0x21
{0x0A,0x0A,0x0A,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x22
{0x00,0x0A,0x0A,0x1F,0x0A,0x0A,0x1F,0x0A,0x0A,0x00,0x00,0x00}, // 0x23
{0x00,0x02,0x06,0x09,0x01,0x02,0x04,0x08,0x09,0x06,0x04,0x00}, // 0x24
{0x00,0x0B,0x0B,0x04,0x04,0x02,0x02,0x02,0x0D,0x0D,0x00,0x00}, // 0x25
{0x00,0x02,0x05,0x05,0x05,0x02,0x15,0x09,0x09,0x16,0x00,0x00}, // 0x26
{0x0C,0x0C,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x27
{0x00,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x04,0x00,0x00}, // 0x28
{0x00,0x02,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x02,0x00,0x00}, // 0x29
{0x00,0x00,0x04,0x15,0x0E,0x0E,0x15,0x04,0x00,0x00,0x00,0x00}, // 0x2A
{0x00,0x00,0x00,0x04,0x04,0x1F,0x04,0x04,0x00,0x00,0x00,0x00}, // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x04,0x02}, // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00}, // 0x2E
{0x00,0x08,0x08,0x04,0x04,0x02,0x02,0x02,0x01,0x01,0x00,0x00}, // 0x2F
{0x00,0x0E,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x07,0x00,0x00}, // 0x30
{0x00,0x04,0x06,0x05,0x04,0x04,0x04,0x04,0x04,0x0F,0x00,0x00}, // 0x31
{0x00,0x06,0x09,0x09,0x08,0x04,0x02,0x01,0x01,0x0F,0x00,0x00}, // 0x32
{0x00,0x06,0x09,0x08,0x08,0x06,0x08,0x08,0x09,0x06,0x00,0x00}, // 0x33
{0x00,0x08,0x0C,0x0A,0x0A,0x09,0x0F,0x08,0x08,0x08,0x00,0x00}, // 0x34
{0x00,0x0F,0x01,0x01,0x01,0x07,0x08,0x08,0x09,0x06,0x00,0x00}, // 0x35
{0x00,0x0C,0x02,0x01,0x07,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x36
{0x00,0x0F,0x08,0x08,0x08,0x04,0x04,0x02,0x02,0x02,0x00,0x00}, // 0x37
{0x00,0x06,0x09,0x09,0x09,0x06,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x38
{0x00,0x06,0x09,0x09,0x09,0x09,0x0E,0x08,0x04,0x03,0x00,0x00}, // 0x39
{0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x06,0x06,0x00,0x00}, // 0x3A
{0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x06,0x06,0x04,0x02}, // 0x3B
{0x00,0x00,0x08,0x04,0x02,0x01,0x01,0x02,0x04,0x08,0x00,0x00}, // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00}, // 0x3D
{0x00,0x00,0x01,0x02,0x04,0x08,0x08,0x04,0x02,0x01,0x00,0x00}, // 0x3E
{0x00,0x06,0x09,0x09,0x08,0x04,0x04,0x00,0x04,0x04,0x00,0x00}, // 0x3F
{0x00,0x06,0x09,0x09,0x09,0x0D,0x0D,0x01,0x01,0x0E,0x00,0x00}, // 0x40
{0x00,0x06,0x09,0x09,0x09,0x0F,0x09,0x09,0x09,0x09,0x00,0x00}, // 0x41
{0x00,0x07,0x09,0x09,0x09,0x07,0x09,0x09,0x09,0x07,0x00,0x00}, // 0x42
{0x00,0x06,0x09,0x09,0x01,0x01,0x01,0x01,0x09,0x06,0x00,0x00}, // 0x43
{0x00,0x07,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x07,0x00,0x00}, // 0x44
{0x00,0x0F,0x01,0x01,0x01,0x0F,0x01,0x01,0x01,0x0F,0x00,0x00}, // 0x45
{0x00,0x0F,0x01,0x01,0x01,0x0F,0x01,0x01,0x01,0x01,0x00,0x00}, // 0x46
{0x00,0x06,0x09,0x09,0x01,0x01,0x0D,0x09,0x09,0x06,0x00,0x00}, // 0x47
{0x00,0x09,0x09,0x09,0x09,0x0F,0x09,0x09,0x09,0x09,0x00,0x00}, // 0x48
{0x00,0x0E,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0x49
{0x00,0x0E,0x04,0x04,0x04,0x04,0x04,0x05,0x05,0x02,0x00,0x00}, // 0x4A
{0x00,0x09,0x09,0x05,0x05,0x03,0x05,0x05,0x09,0x09,0x00,0x00}, // 0x4B
{0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x0F,0x00,0x00}, // 0x4C
{0x00,0x09,0x09,0x0F,0x0F,0x09,0x09,0x09,0x09,0x09,0x00,0x00}, // 0x4D
{0x00,0x09,0x09,0x0B,0x0B,0x0D,0x0D,0x09,0x09,0x09,0x00,0x00}, // 0x4E
{0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x4F
{0x00,0x07,0x09,0x09,0x09,0x07,0x01,0x01,0x01,0x01,0x00,0x00}, // 0x50
{0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x04,0x08}, // 0x51
{0x00,0x07,0x09,0x09,0x09,0x07,0x03,0x05,0x09,0x09,0x00,0x00}, // 0x52
{0x00,0x06,0x09,0x09,0x01,0x06,0x08,0x09,0x09,0x06,0x00,0x00}, // 0x53
{0x00,0x1F,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00}, // 0x54
{0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x55
{0x00,0x09,0x09,0x09,0x09,0x09,0x0A,0x0A,0x04,0x04,0x00,0x00}, // 0x56
{0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x0F,0x09,0x09,0x00,0x00}, // 0x57
{0x00,0x09,0x09,0x09,0x06,0x06,0x06,0x09,0x09,0x09,0x00,0x00}, // 0x58
{0x00,0x11,0x11,0x11,0x0A,0x0A,0x04,0x04,0x04,0x04,0x00,0x00}, // 0x59
{0x00,0x0F,0x08,0x04,0x04,0x02,0x02,0x01,0x01,0x0F,0x00,0x00}, // 0x5A
{0x00,0x06,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x06,0x00,0x00}, // 0x5B
{0x00,0x01,0x01,0x02,0x02,0x04,0x04,0x04,0x08,0x08,0x00,0x00}, // 0x5C
{0x00,0x06,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x06,0x00,0x00}, // 0x5D
{0x00,0x04,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F}, // 0x5F
{0x06,0x06,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x60
{0x00,0x00,0x00,0x00,0x06,0x08,0x0E,0x09,0x09,0x0E,0x00,0x00}, // 0x61
{0x00,0x01,0x01,0x01,0x07,0x09,0x09,0x09,0x09,0x07,0x00,0x00}, // 0x62
{0x00,0x00,0x00,0x00,0x0E,0x01,0x01,0x01,0x01,0x0E,0x00,0x00}, // 0x63
{0x00,0x08,0x08,0x08,0x0E,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0x64
{0x00,0x00,0x00,0x00,0x06,0x09,0x09,0x0F,0x01,0x0E,0x00,0x00}, // 0x65
{0x00,0x04,0x02,0x02,0x07,0x02,0x02,0x02,0x02,0x02,0x00,0x00}, // 0x66
{0x00,0x00,0x00,0x00,0x0E,0x09,0x09,0x09,0x09,0x0E,0x08,0x06}, // 0x67
{0x00,0x01,0x01,0x01,0x07,0x09,0x09,0x09,0x09,0x09,0x00,0x00}, // 0x68
{0x00,0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0x69
{0x00,0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x02}, // 0x6A
{0x00,0x01,0x01,0x01,0x09,0x05,0x03,0x03,0x05,0x09,0x00,0x00}, // 0x6B
{0x00,0x06,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0x6C
{0x00,0x00,0x00,0x00,0x09,0x0F,0x09,0x09,0x09,0x09,0x00,0x00}, // 0x6D
{0x00,0x00,0x00,0x00,0x05,0x0B,0x09,0x09,0x09,0x09,0x00,0x00}, // 0x6E
{0x00,0x00,0x00,0x00,0x06,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x6F
{0x00,0x00,0x00,0x00,0x07,0x09,0x09,0x09,0x09,0x07,0x01,0x01}, // 0x70
{0x00,0x00,0x00,0x00,0x0E,0x09,0x09,0x09,0x09,0x0E,0x08,0x08}, // 0x71
{0x00,0x00,0x00,0x00,0x0D,0x0A,0x02,0x02,0x02,0x02,0x00,0x00}, // 0x72
{0x00,0x00,0x00,0x00,0x06,0x09,0x02,0x04,0x09,0x06,0x00,0x00}, // 0x73
{0x00,0x00,0x02,0x02,0x07,0x02,0x02,0x02,0x02,0x06,0x00,0x00}, // 0x74
{0x00,0x00,0x00,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0x75
{0x00,0x00,0x00,0x00,0x09,0x09,0x0A,0x0A,0x04,0x04,0x00,0x00}, // 0x76
{0x00,0x00,0x00,0x00,0x09,0x09,0x09,0x09,0x0F,0x09,0x00,0x00}, // 0x77
{0x00,0x00,0x00,0x00,0x09,0x09,0x06,0x06,0x09,0x09,0x00,0x00}, // 0x78
{0x00,0x00,0x00,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x08,0x07}, // 0x79
{0x00,0x00,0x00,0x00,0x0F,0x08,0x04,0x02,0x01,0x0F,0x00,0x00}, // 0x7A
{0x00,0x04,0x02,0x02,0x02,0x01,0x02,0x02,0x02,0x04,0x00,0x00}, // 0x7B
{0x04,0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x00}, // 0x7C
{0x00,0x02,0x04,0x04,0x04,0x08,0x04,0x04,0x04,0x02,0x00,0x00}, // 0x7D
{0x00,0x0A,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7E
{0x00,0x04,0x04,0x0A,0x0A,0x11,0x11,0x11,0x11,0x1F,0x00,0x00}, // 0x7F
{0x00,0x06,0x09,0x09,0x01,0x01,0x01,0x01,0x09,0x06,0x04,0x02}, // 0x80
{0x00,0x0A,0x0A,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0x81
{0x00,0x0C,0x02,0x00,0x06,0x09,0x09,0x0F,0x01,0x0E,0x00,0x00}, // 0x82
{0x00,0x06,0x09,0x00,0x06,0x09,0x08,0x0E,0x09,0x0E,0x00,0x00}, // 0x83
{0x00,0x0A,0x0A,0x00,0x06,0x09,0x08,0x0E,0x09,0x0E,0x00,0x00}, // 0x84
{0x00,0x03,0x04,0x00,0x06,0x09,0x08,0x0E,0x09,0x0E,0x00,0x00}, // 0x85
{0x00,0x04,0x0A,0x04,0x06,0x09,0x08,0x0E,0x09,0x0E,0x00,0x00}, // 0x86
{0x00,0x00,0x00,0x00,0x0E,0x01,0x01,0x01,0x01,0x0E,0x04,0x03}, // 0x87
{0x00,0x06,0x09,0x00,0x06,0x09,0x09,0x0F,0x01,0x0E,0x00,0x00}, // 0x88
{0x00,0x0A,0x0A,0x00,0x06,0x09,0x09,0x0F,0x01,0x0E,0x00,0x00}, // 0x89
{0x00,0x03,0x04,0x00,0x06,0x09,0x09,0x0F,0x01,0x0E,0x00,0x00}, // 0x8A
{0x00,0x0A,0x0A,0x00,0x06,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0x8B
{0x00,0x06,0x09,0x00,0x06,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0x8C
{0x00,0x06,0x08,0x00,0x06,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0x8D
{0x0A,0x00,0x06,0x09,0x09,0x09,0x0F,0x09,0x09,0x09,0x00,0x00}, // 0x8E
{0x04,0x0A,0x04,0x06,0x09,0x09,0x0F,0x09,0x09,0x09,0x00,0x00}, // 0x8F
{0x0C,0x02,0x00,0x0F,0x01,0x01,0x0F,0x01,0x01,0x0F,0x00,0x00}, // 0x90
{0x00,0x00,0x00,0x00,0x0E,0x14,0x14,0x0E,0x05,0x0A,0x00,0x00}, // 0x91
{0x00,0x00,0x0E,0x07,0x05,0x05,0x0F,0x05,0x05,0x0D,0x00,0x00}, // 0x92
{0x00,0x06,0x09,0x00,0x06,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x93
{0x00,0x0A,0x0A,0x00,0x06,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x94
{0x00,0x06,0x08,0x00,0x06,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x95
{0x00,0x06,0x09,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0x96
{0x00,0x03,0x04,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0x97
{0x00,0x0A,0x0A,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x08,0x07}, // 0x98
{0x0A,0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0x99
{0x0A,0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0x9A
{0x00,0x00,0x00,0x08,0x0E,0x0D,0x0D,0x0B,0x07,0x01,0x00,0x00}, // 0x9B
{0x00,0x04,0x0A,0x02,0x02,0x07,0x02,0x02,0x0B,0x0F,0x00,0x00}, // 0x9C
{0x0E,0x09,0x0D,0x0D,0x0D,0x0B,0x0B,0x0B,0x0B,0x07,0x00,0x00}, // 0x9D
{0x00,0x00,0x00,0x11,0x0A,0x04,0x0A,0x11,0x00,0x00,0x00,0x00}, // 0x9E
{0x08,0x04,0x04,0x04,0x04,0x0E,0x04,0x04,0x04,0x04,0x05,0x02}, // 0x9F
{0x00,0x0C,0x02,0x00,0x06,0x09,0x08,0x0E,0x09,0x0E,0x00,0x00}, // 0xA0
{0x00,0x0C,0x02,0x00,0x06,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0xA1
{0x00,0x0C,0x02,0x00,0x06,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xA2
{0x00,0x0C,0x02,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x00,0x00}, // 0xA3
{0x00,0x0A,0x05,0x00,0x05,0x0B,0x09,0x09,0x09,0x09,0x00,0x00}, // 0xA4
{0x0A,0x05,0x00,0x09,0x0B,0x0F,0x0D,0x09,0x09,0x09,0x00,0x00}, // 0xA5
{0x00,0x06,0x08,0x0E,0x09,0x0E,0x00,0x0F,0x00,0x00,0x00,0x00}, // 0xA6
{0x00,0x06,0x09,0x09,0x09,0x06,0x00,0x0F,0x00,0x00,0x00,0x00}, // 0xA7
{0x00,0x02,0x02,0x00,0x02,0x02,0x01,0x01,0x09,0x06,0x00,0x00}, // 0xA8
{0x00,0x00,0x0E,0x11,0x17,0x1B,0x17,0x1B,0x11,0x0E,0x00,0x00}, // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x08,0x08,0x00,0x00,0x00}, // 0xAA
{0x00,0x02,0x0A,0x0A,0x04,0x02,0x0E,0x09,0x05,0x0C,0x00,0x00}, // 0xAB
{0x00,0x02,0x0A,0x0A,0x04,0x02,0x0A,0x0D,0x0D,0x08,0x00,0x00}, // 0xAC
{0x00,0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00}, // 0xAD
{0x00,0x00,0x00,0x0A,0x0A,0x05,0x05,0x0A,0x0A,0x00,0x00,0x00}, // 0xAE
{0x00,0x00,0x00,0x05,0x05,0x0A,0x0A,0x05,0x05,0x00,0x00,0x00}, // 0xAF
{0x00,0x00,0x15,0x00,0x00,0x0A,0x00,0x00,0x15,0x00,0x00,0x0A}, // 0xB0
{0x00,0x0A,0x00,0x15,0x00,0x0A,0x00,0x15,0x00,0x0A,0x00,0x15}, // 0xB1
{0x0A,0x15,0x0A,0x15,0x0A,0x15,0x0A,0x15,0x0A,0x15,0x0A,0x15}, // 0xB2
{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xB3
{0x04,0x04,0x04,0x04,0x04,0x07,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xB4
{0x0C,0x02,0x00,0x06,0x09,0x09,0x0F,0x09,0x09,0x09,0x00,0x00}, // 0xB5
{0x04,0x0A,0x00,0x06,0x09,0x09,0x0F,0x09,0x09,0x09,0x00,0x00}, // 0xB6
{0x03,0x04,0x00,0x06,0x09,0x09,0x0F,0x09,0x09,0x09,0x00,0x00}, // 0xB7
{0x00,0x00,0x0E,0x11,0x15,0x13,0x13,0x15,0x11,0x0E,0x00,0x00}, // 0xB8
{0x0A,0x0A,0x0A,0x0A,0x0B,0x08,0x0B,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xB9
{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xBA
{0x00,0x00,0x00,0x00,0x0F,0x08,0x0B,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xBB
{0x0A,0x0A,0x0A,0x0A,0x0B,0x08,0x0F,0x00,0x00,0x00,0x00,0x00}, // 0xBC
{0x00,0x00,0x00,0x04,0x0E,0x11,0x01,0x11,0x0E,0x04,0x00,0x00}, // 0xBD
{0x00,0x11,0x0A,0x0A,0x1F,0x04,0x1F,0x04,0x04,0x04,0x00,0x00}, // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x07,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xBF
{0x04,0x04,0x04,0x04,0x04,0x1C,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC0
{0x04,0x04,0x04,0x04,0x04,0x1F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x1F,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xC2
{0x04,0x04,0x04,0x04,0x04,0x1C,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC4
{0x04,0x04,0x04,0x04,0x04,0x1F,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xC5
{0x00,0x0A,0x05,0x00,0x06,0x09,0x08,0x0E,0x09,0x0E,0x00,0x00}, // 0xC6
{0x0A,0x05,0x00,0x06,0x09,0x09,0x0F,0x09,0x09,0x09,0x00,0x00}, // 0xC7
{0x0A,0x0A,0x0A,0x0A,0x1A,0x02,0x1E,0x00,0x00,0x00,0x00,0x00}, // 0xC8
{0x00,0x00,0x00,0x00,0x1E,0x02,0x1A,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xC9
{0x0A,0x0A,0x0A,0x0A,0x1B,0x00,0x1F,0x00,0x00,0x00,0x00,0x00}, // 0xCA
{0x00,0x00,0x00,0x00,0x1F,0x00,0x1B,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xCB
{0x0A,0x0A,0x0A,0x0A,0x1A,0x02,0x1A,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xCC
{0x00,0x00,0x00,0x00,0x1F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00}, // 0xCD
{0x0A,0x0A,0x0A,0x0A,0x1B,0x00,0x1B,0x0A,0x0A,0x0A,0x0A,0x0A}, // 0xCE
{0x00,0x09,0x06,0x09,0x09,0x09,0x09,0x09,0x06,0x09,0x00,0x00}, // 0xCF
{0x00,0x00,0x0C,0x02,0x02,0x04,0x0E,0x09,0x09,0x06,0x00,0x00}, // 0xD0
{0x00,0x06,0x0A,0x0A,0x0A,0x0F,0x0A,0x0A,0x0A,0x06,0x00,0x00}, // 0xD1
{0x04,0x0A,0x00,0x0F,0x01,0x01,0x0F,0x01,0x01,0x0F,0x00,0x00}, // 0xD2
{0x00,0x0A,0x00,0x0F,0x01,0x01,0x0F,0x01,0x01,0x0F,0x00,0x00}, // 0xD3
{0x06,0x08,0x00,0x0F,0x01,0x01,0x0F,0x01,0x01,0x0F,0x00,0x00}, // 0xD4
{0x00,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD5
{0x0C,0x02,0x00,0x0E,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0xD6
{0x04,0x0A,0x00,0x0E,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0xD7
{0x00,0x0A,0x00,0x0E,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0xD8
{0x04,0x04,0x04,0x04,0x04,0x07,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x1C,0x04,0x04,0x04,0x04,0x04,0x04}, // 0xDA
{0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F}, // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F}, // 0xDC
{0x04,0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x00}, // 0xDD
{0x06,0x08,0x00,0x0E,0x04,0x04,0x04,0x04,0x04,0x0E,0x00,0x00}, // 0xDE
{0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDF
{0x0C,0x02,0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xE0
{0x00,0x06,0x09,0x09,0x05,0x07,0x09,0x09,0x09,0x07,0x01,0x01}, // 0xE1
{0x04,0x0A,0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xE2
{0x06,0x08,0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xE3
{0x00,0x0A,0x05,0x00,0x06,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xE4
{0x0A,0x05,0x00,0x06,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xE5
{0x00,0x00,0x00,0x00,0x09,0x09,0x09,0x09,0x09,0x07,0x01,0x01}, // 0xE6
{0x00,0x00,0x00,0x03,0x01,0x07,0x09,0x07,0x01,0x03,0x00,0x00}, // 0xE7
{0x00,0x03,0x01,0x07,0x09,0x09,0x09,0x07,0x01,0x03,0x00,0x00}, // 0xE8
{0x0C,0x02,0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xE9
{0x04,0x0A,0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xEA
{0x06,0x08,0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x06,0x00,0x00}, // 0xEB
{0x00,0x0C,0x02,0x00,0x09,0x09,0x09,0x09,0x09,0x0E,0x08,0x07}, // 0xEC
{0x0C,0x02,0x00,0x11,0x11,0x0A,0x0A,0x04,0x04,0x04,0x00,0x00}, // 0xED
{0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEE
{0x06,0x06,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF0
{0x00,0x00,0x00,0x04,0x04,0x1F,0x04,0x04,0x00,0x1F,0x00,0x00}, // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00}, // 0xF2
{0x07,0x02,0x0C,0x0B,0x04,0x02,0x0A,0x0D,0x0D,0x08,0x00,0x00}, // 0xF3
{0x00,0x0E,0x0B,0x0B,0x0B,0x0B,0x0A,0x0A,0x0A,0x0A,0x00,0x00}, // 0xF4
{0x00,0x06,0x09,0x01,0x06,0x09,0x06,0x08,0x09,0x06,0x00,0x00}, // 0xF5
{0x00,0x00,0x00,0x04,0x00,0x1F,0x00,0x04,0x00,0x00,0x00,0x00}, // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x0D,0x0E,0x00,0x00,0x00,0x00,0x00}, // 0xF7
{0x06,0x09,0x09,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF8
{0x00,0x00,0x00,0x00,0x00,0x0A,0x0A,0x00,0x00,0x00,0x00,0x00}, // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x00,0x00,0x00,0x00,0x00}, // 0xFA
{0x04,0x06,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFB
{0x0F,0x08,0x06,0x08,0x09,0x06,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFC
{0x06,0x09,0x08,0x06,0x01,0x0F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFD
{0x00,0x00,0x00,0x0E,0x0E,0x0E,0x0E,0x0E,0x00,0x00,0x00,0x00}, // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 0xFF
};
#endif

#ifdef USE_FONT_6X8
__UG_FONT_DATA unsigned char font_6x8[256][8]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0x1C,0x22,0x36,0x22,0x2A,0x22,0x1C,0x00},   // 0x01
{0x1C,0x3E,0x2A,0x3E,0x22,0x3E,0x1C,0x00},   // 0x02
{0x00,0x14,0x3E,0x3E,0x3E,0x1C,0x08,0x00},   // 0x03
{0x00,0x08,0x1C,0x3E,0x3E,0x1C,0x08,0x00},   // 0x04
{0x08,0x1C,0x1C,0x08,0x3E,0x3E,0x08,0x00},   // 0x05
{0x00,0x08,0x1C,0x3E,0x3E,0x08,0x1C,0x00},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0x00,0x38,0x30,0x2C,0x12,0x12,0x0C,0x00},   // 0x0B
{0x1C,0x22,0x22,0x1C,0x08,0x1C,0x08,0x00},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0x30,0x2C,0x34,0x2C,0x34,0x36,0x06,0x00},   // 0x0E
{0x00,0x2A,0x1C,0x36,0x1C,0x2A,0x00,0x00},   // 0x0F
{0x04,0x0C,0x1C,0x3C,0x1C,0x0C,0x04,0x00},   // 0x10
{0x10,0x18,0x1C,0x1E,0x1C,0x18,0x10,0x00},   // 0x11
{0x08,0x1C,0x3E,0x08,0x3E,0x1C,0x08,0x00},   // 0x12
{0x14,0x14,0x14,0x14,0x14,0x00,0x14,0x00},   // 0x13
{0x3C,0x2A,0x2A,0x2C,0x28,0x28,0x28,0x00},   // 0x14
{0x1C,0x22,0x0C,0x14,0x18,0x22,0x1C,0x00},   // 0x15
{0x00,0x00,0x00,0x00,0x00,0x1E,0x1E,0x00},   // 0x16
{0x08,0x1C,0x3E,0x08,0x3E,0x1C,0x08,0x1C},   // 0x17
{0x08,0x1C,0x3E,0x08,0x08,0x08,0x08,0x00},   // 0x18
{0x08,0x08,0x08,0x08,0x3E,0x1C,0x08,0x00},   // 0x19
{0x00,0x08,0x18,0x3E,0x18,0x08,0x00,0x00},   // 0x1A
{0x00,0x08,0x0C,0x3E,0x0C,0x08,0x00,0x00},   // 0x1B
{0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x00},   // 0x1C
{0x00,0x14,0x14,0x3E,0x14,0x14,0x00,0x00},   // 0x1D
{0x08,0x08,0x1C,0x1C,0x3E,0x3E,0x00,0x00},   // 0x1E
{0x3E,0x3E,0x1C,0x1C,0x08,0x08,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x08,0x1C,0x1C,0x08,0x08,0x00,0x08,0x00},   // 0x21
{0x36,0x36,0x12,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x00,0x14,0x3E,0x14,0x14,0x3E,0x14,0x00},   // 0x23
{0x04,0x1C,0x02,0x0C,0x10,0x0E,0x08,0x00},   // 0x24
{0x26,0x26,0x10,0x08,0x04,0x32,0x32,0x00},   // 0x25
{0x04,0x0A,0x0A,0x04,0x2A,0x12,0x2C,0x00},   // 0x26
{0x0C,0x0C,0x04,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x00},   // 0x28
{0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x00},   // 0x29
{0x00,0x14,0x1C,0x3E,0x1C,0x14,0x00,0x00},   // 0x2A
{0x00,0x08,0x08,0x3E,0x08,0x08,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x04},   // 0x2C
{0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00},   // 0x2E
{0x00,0x20,0x10,0x08,0x04,0x02,0x00,0x00},   // 0x2F
{0x1C,0x22,0x32,0x2A,0x26,0x22,0x1C,0x00},   // 0x30
{0x08,0x0C,0x08,0x08,0x08,0x08,0x1C,0x00},   // 0x31
{0x1C,0x22,0x20,0x18,0x04,0x02,0x3E,0x00},   // 0x32
{0x1C,0x22,0x20,0x1C,0x20,0x22,0x1C,0x00},   // 0x33
{0x10,0x18,0x14,0x12,0x3E,0x10,0x10,0x00},   // 0x34
{0x3E,0x02,0x02,0x1E,0x20,0x22,0x1C,0x00},   // 0x35
{0x18,0x04,0x02,0x1E,0x22,0x22,0x1C,0x00},   // 0x36
{0x3E,0x20,0x10,0x08,0x04,0x04,0x04,0x00},   // 0x37
{0x1C,0x22,0x22,0x1C,0x22,0x22,0x1C,0x00},   // 0x38
{0x1C,0x22,0x22,0x3C,0x20,0x10,0x0C,0x00},   // 0x39
{0x00,0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x00},   // 0x3A
{0x00,0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x04},   // 0x3B
{0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x00},   // 0x3C
{0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00},   // 0x3D
{0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00},   // 0x3E
{0x1C,0x22,0x20,0x18,0x08,0x00,0x08,0x00},   // 0x3F
{0x1C,0x22,0x3A,0x2A,0x3A,0x02,0x1C,0x00},   // 0x40
{0x1C,0x22,0x22,0x22,0x3E,0x22,0x22,0x00},   // 0x41
{0x1E,0x22,0x22,0x1E,0x22,0x22,0x1E,0x00},   // 0x42
{0x1C,0x22,0x02,0x02,0x02,0x22,0x1C,0x00},   // 0x43
{0x1E,0x22,0x22,0x22,0x22,0x22,0x1E,0x00},   // 0x44
{0x3E,0x02,0x02,0x1E,0x02,0x02,0x3E,0x00},   // 0x45
{0x3E,0x02,0x02,0x1E,0x02,0x02,0x02,0x00},   // 0x46
{0x1C,0x22,0x02,0x3A,0x22,0x22,0x3C,0x00},   // 0x47
{0x22,0x22,0x22,0x3E,0x22,0x22,0x22,0x00},   // 0x48
{0x1C,0x08,0x08,0x08,0x08,0x08,0x1C,0x00},   // 0x49
{0x20,0x20,0x20,0x20,0x22,0x22,0x1C,0x00},   // 0x4A
{0x22,0x12,0x0A,0x06,0x0A,0x12,0x22,0x00},   // 0x4B
{0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x00},   // 0x4C
{0x22,0x36,0x2A,0x22,0x22,0x22,0x22,0x00},   // 0x4D
{0x22,0x26,0x2A,0x32,0x22,0x22,0x22,0x00},   // 0x4E
{0x1C,0x22,0x22,0x22,0x22,0x22,0x1C,0x00},   // 0x4F
{0x1E,0x22,0x22,0x1E,0x02,0x02,0x02,0x00},   // 0x50
{0x1C,0x22,0x22,0x22,0x2A,0x12,0x2C,0x00},   // 0x51
{0x1E,0x22,0x22,0x1E,0x12,0x22,0x22,0x00},   // 0x52
{0x1C,0x22,0x02,0x1C,0x20,0x22,0x1C,0x00},   // 0x53
{0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x00},   // 0x54
{0x22,0x22,0x22,0x22,0x22,0x22,0x1C,0x00},   // 0x55
{0x22,0x22,0x22,0x22,0x22,0x14,0x08,0x00},   // 0x56
{0x22,0x22,0x2A,0x2A,0x2A,0x2A,0x14,0x00},   // 0x57
{0x22,0x22,0x14,0x08,0x14,0x22,0x22,0x00},   // 0x58
{0x22,0x22,0x22,0x14,0x08,0x08,0x08,0x00},   // 0x59
{0x1E,0x10,0x08,0x04,0x02,0x02,0x1E,0x00},   // 0x5A
{0x1C,0x04,0x04,0x04,0x04,0x04,0x1C,0x00},   // 0x5B
{0x00,0x02,0x04,0x08,0x10,0x20,0x00,0x00},   // 0x5C
{0x1C,0x10,0x10,0x10,0x10,0x10,0x1C,0x00},   // 0x5D
{0x08,0x14,0x22,0x00,0x00,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F},   // 0x5F
{0x0C,0x0C,0x08,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0x61
{0x02,0x02,0x1E,0x22,0x22,0x22,0x1E,0x00},   // 0x62
{0x00,0x00,0x1C,0x22,0x02,0x22,0x1C,0x00},   // 0x63
{0x20,0x20,0x3C,0x22,0x22,0x22,0x3C,0x00},   // 0x64
{0x00,0x00,0x1C,0x22,0x1E,0x02,0x1C,0x00},   // 0x65
{0x18,0x04,0x04,0x1E,0x04,0x04,0x04,0x00},   // 0x66
{0x00,0x00,0x3C,0x22,0x22,0x3C,0x20,0x1C},   // 0x67
{0x02,0x02,0x0E,0x12,0x12,0x12,0x12,0x00},   // 0x68
{0x08,0x00,0x08,0x08,0x08,0x08,0x18,0x00},   // 0x69
{0x10,0x00,0x18,0x10,0x10,0x10,0x12,0x0C},   // 0x6A
{0x02,0x02,0x12,0x0A,0x06,0x0A,0x12,0x00},   // 0x6B
{0x08,0x08,0x08,0x08,0x08,0x08,0x18,0x00},   // 0x6C
{0x00,0x00,0x16,0x2A,0x2A,0x22,0x22,0x00},   // 0x6D
{0x00,0x00,0x0E,0x12,0x12,0x12,0x12,0x00},   // 0x6E
{0x00,0x00,0x1C,0x22,0x22,0x22,0x1C,0x00},   // 0x6F
{0x00,0x00,0x1E,0x22,0x22,0x22,0x1E,0x02},   // 0x70
{0x00,0x00,0x3C,0x22,0x22,0x22,0x3C,0x20},   // 0x71
{0x00,0x00,0x1A,0x24,0x04,0x04,0x0E,0x00},   // 0x72
{0x00,0x00,0x1C,0x02,0x1C,0x20,0x1C,0x00},   // 0x73
{0x00,0x04,0x1E,0x04,0x04,0x14,0x08,0x00},   // 0x74
{0x00,0x00,0x12,0x12,0x12,0x1A,0x14,0x00},   // 0x75
{0x00,0x00,0x22,0x22,0x22,0x14,0x08,0x00},   // 0x76
{0x00,0x00,0x22,0x22,0x2A,0x3E,0x14,0x00},   // 0x77
{0x00,0x00,0x12,0x12,0x0C,0x12,0x12,0x00},   // 0x78
{0x00,0x00,0x12,0x12,0x12,0x1C,0x08,0x06},   // 0x79
{0x00,0x00,0x1E,0x10,0x0C,0x02,0x1E,0x00},   // 0x7A
{0x18,0x04,0x04,0x06,0x04,0x04,0x18,0x00},   // 0x7B
{0x08,0x08,0x08,0x00,0x08,0x08,0x08,0x00},   // 0x7C
{0x0C,0x10,0x10,0x30,0x10,0x10,0x0C,0x00},   // 0x7D
{0x14,0x0A,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7E
{0x08,0x1C,0x36,0x22,0x22,0x3E,0x00,0x00},   // 0x7F
{0x1C,0x22,0x02,0x02,0x22,0x1C,0x08,0x0C},   // 0x80
{0x12,0x00,0x12,0x12,0x12,0x1A,0x14,0x00},   // 0x81
{0x30,0x00,0x1C,0x22,0x1E,0x02,0x1C,0x00},   // 0x82
{0x1C,0x00,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0x83
{0x14,0x00,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0x84
{0x0C,0x00,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0x85
{0x1C,0x14,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0x86
{0x00,0x1C,0x22,0x02,0x22,0x1C,0x08,0x0C},   // 0x87
{0x1C,0x00,0x1C,0x22,0x1E,0x02,0x1C,0x00},   // 0x88
{0x14,0x00,0x1C,0x22,0x1E,0x02,0x1C,0x00},   // 0x89
{0x0C,0x00,0x1C,0x22,0x1E,0x02,0x1C,0x00},   // 0x8A
{0x14,0x00,0x08,0x08,0x08,0x08,0x18,0x00},   // 0x8B
{0x1C,0x00,0x08,0x08,0x08,0x08,0x18,0x00},   // 0x8C
{0x04,0x00,0x08,0x08,0x08,0x08,0x18,0x00},   // 0x8D
{0x14,0x00,0x08,0x14,0x22,0x3E,0x22,0x00},   // 0x8E
{0x1C,0x14,0x1C,0x36,0x22,0x3E,0x22,0x00},   // 0x8F
{0x30,0x00,0x3E,0x02,0x1E,0x02,0x3E,0x00},   // 0x90
{0x00,0x00,0x1E,0x28,0x3E,0x0A,0x3C,0x00},   // 0x91
{0x3C,0x0A,0x0A,0x3E,0x0A,0x0A,0x3A,0x00},   // 0x92
{0x1C,0x00,0x0C,0x12,0x12,0x12,0x0C,0x00},   // 0x93
{0x14,0x00,0x0C,0x12,0x12,0x12,0x0C,0x00},   // 0x94
{0x06,0x00,0x0C,0x12,0x12,0x12,0x0C,0x00},   // 0x95
{0x1C,0x00,0x12,0x12,0x12,0x1A,0x14,0x00},   // 0x96
{0x06,0x00,0x12,0x12,0x12,0x1A,0x14,0x00},   // 0x97
{0x14,0x00,0x12,0x12,0x12,0x1C,0x08,0x06},   // 0x98
{0x12,0x0C,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0x99
{0x14,0x00,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0x9A
{0x00,0x00,0x20,0x1C,0x1A,0x16,0x0E,0x01},   // 0x9B
{0x18,0x24,0x04,0x1E,0x04,0x24,0x3A,0x00},   // 0x9C
{0x3C,0x32,0x2A,0x2A,0x2A,0x26,0x1E,0x00},   // 0x9D
{0x00,0x22,0x14,0x08,0x14,0x22,0x00,0x00},   // 0x9E
{0x10,0x28,0x08,0x1C,0x08,0x08,0x0A,0x04},   // 0x9F
{0x18,0x00,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0xA0
{0x18,0x00,0x08,0x08,0x08,0x08,0x18,0x00},   // 0xA1
{0x18,0x00,0x0C,0x12,0x12,0x12,0x0C,0x00},   // 0xA2
{0x18,0x00,0x12,0x12,0x12,0x1A,0x14,0x00},   // 0xA3
{0x14,0x0A,0x00,0x0E,0x12,0x12,0x12,0x00},   // 0xA4
{0x14,0x0A,0x00,0x12,0x16,0x1A,0x12,0x00},   // 0xA5
{0x1C,0x20,0x3C,0x22,0x3C,0x00,0x3C,0x00},   // 0xA6
{0x0C,0x12,0x12,0x12,0x0C,0x00,0x1E,0x00},   // 0xA7
{0x08,0x00,0x08,0x0C,0x02,0x22,0x1C,0x00},   // 0xA8
{0x1E,0x29,0x35,0x2D,0x35,0x21,0x1E,0x00},   // 0xA9
{0x00,0x00,0x3F,0x20,0x20,0x00,0x00,0x00},   // 0xAA
{0x02,0x12,0x0A,0x1C,0x22,0x10,0x38,0x00},   // 0xAB
{0x02,0x12,0x0A,0x34,0x2A,0x38,0x20,0x00},   // 0xAC
{0x08,0x00,0x08,0x08,0x1C,0x1C,0x08,0x00},   // 0xAD
{0x00,0x00,0x24,0x12,0x24,0x00,0x00,0x00},   // 0xAE
{0x00,0x00,0x12,0x24,0x12,0x00,0x00,0x00},   // 0xAF
{0x2A,0x00,0x15,0x00,0x2A,0x00,0x15,0x00},   // 0xB0
{0x2A,0x15,0x2A,0x15,0x2A,0x15,0x2A,0x15},   // 0xB1
{0x15,0x3F,0x2A,0x3F,0x15,0x3F,0x2A,0x3F},   // 0xB2
{0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08},   // 0xB3
{0x08,0x08,0x08,0x0F,0x08,0x08,0x08,0x08},   // 0xB4
{0x18,0x00,0x08,0x14,0x22,0x3E,0x22,0x00},   // 0xB5
{0x1C,0x00,0x08,0x14,0x22,0x3E,0x22,0x00},   // 0xB6
{0x0C,0x00,0x08,0x14,0x22,0x3E,0x22,0x00},   // 0xB7
{0x1E,0x21,0x2D,0x25,0x2D,0x21,0x1E,0x00},   // 0xB8
{0x0A,0x0B,0x08,0x0B,0x0A,0x0A,0x0A,0x0A},   // 0xB9
{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A},   // 0xBA
{0x00,0x0F,0x08,0x0B,0x0A,0x0A,0x0A,0x0A},   // 0xBB
{0x0A,0x0B,0x08,0x0F,0x00,0x00,0x00,0x00},   // 0xBC
{0x00,0x08,0x1C,0x02,0x02,0x1C,0x08,0x00},   // 0xBD
{0x22,0x14,0x08,0x3E,0x08,0x3E,0x08,0x00},   // 0xBE
{0x00,0x00,0x00,0x0F,0x08,0x08,0x08,0x08},   // 0xBF
{0x08,0x08,0x08,0x38,0x00,0x00,0x00,0x00},   // 0xC0
{0x08,0x08,0x08,0x3F,0x00,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x3F,0x08,0x08,0x08,0x08},   // 0xC2
{0x08,0x08,0x08,0x38,0x08,0x08,0x08,0x08},   // 0xC3
{0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},   // 0xC4
{0x08,0x08,0x08,0x3F,0x08,0x08,0x08,0x08},   // 0xC5
{0x28,0x14,0x1C,0x20,0x3C,0x22,0x3C,0x00},   // 0xC6
{0x28,0x14,0x08,0x14,0x22,0x3E,0x22,0x00},   // 0xC7
{0x0A,0x3A,0x02,0x3E,0x00,0x00,0x00,0x00},   // 0xC8
{0x00,0x3E,0x02,0x3A,0x0A,0x0A,0x0A,0x0A},   // 0xC9
{0x0A,0x3B,0x00,0x3F,0x00,0x00,0x00,0x00},   // 0xCA
{0x00,0x3F,0x00,0x3B,0x0A,0x0A,0x0A,0x0A},   // 0xCB
{0x0A,0x3A,0x02,0x3A,0x0A,0x0A,0x0A,0x0A},   // 0xCC
{0x00,0x3F,0x00,0x3F,0x00,0x00,0x00,0x00},   // 0xCD
{0x0A,0x3B,0x00,0x3B,0x0A,0x0A,0x0A,0x0A},   // 0xCE
{0x22,0x1C,0x22,0x22,0x22,0x1C,0x22,0x00},   // 0xCF
{0x0C,0x02,0x04,0x08,0x1C,0x12,0x0C,0x00},   // 0xD0
{0x1C,0x24,0x24,0x2E,0x24,0x24,0x1C,0x00},   // 0xD1
{0x1C,0x00,0x3E,0x02,0x1E,0x02,0x3E,0x00},   // 0xD2
{0x14,0x00,0x3E,0x02,0x1E,0x02,0x3E,0x00},   // 0xD3
{0x0C,0x00,0x3E,0x02,0x1E,0x02,0x3E,0x00},   // 0xD4
{0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00},   // 0xD5
{0x18,0x00,0x1C,0x08,0x08,0x08,0x1C,0x00},   // 0xD6
{0x1C,0x00,0x1C,0x08,0x08,0x08,0x1C,0x00},   // 0xD7
{0x14,0x00,0x1C,0x08,0x08,0x08,0x1C,0x00},   // 0xD8
{0x08,0x08,0x08,0x0F,0x00,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x38,0x08,0x08,0x08,0x08},   // 0xDA
{0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},   // 0xDB
{0x00,0x00,0x00,0x00,0x3F,0x3F,0x3F,0x3F},   // 0xDC
{0x08,0x08,0x08,0x00,0x08,0x08,0x08,0x00},   // 0xDD
{0x0C,0x00,0x1C,0x08,0x08,0x08,0x1C,0x00},   // 0xDE
{0x3F,0x3F,0x3F,0x3F,0x00,0x00,0x00,0x00},   // 0xDF
{0x18,0x0C,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0xE0
{0x00,0x0E,0x12,0x0E,0x12,0x12,0x0E,0x02},   // 0xE1
{0x1C,0x0C,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0xE2
{0x06,0x0C,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0xE3
{0x14,0x0A,0x00,0x0C,0x12,0x12,0x0C,0x00},   // 0xE4
{0x14,0x0A,0x0C,0x12,0x12,0x12,0x0C,0x00},   // 0xE5
{0x00,0x00,0x12,0x12,0x12,0x0E,0x02,0x02},   // 0xE6
{0x00,0x06,0x02,0x0E,0x12,0x0E,0x02,0x06},   // 0xE7
{0x06,0x02,0x0E,0x12,0x12,0x0E,0x02,0x06},   // 0xE8
{0x18,0x00,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0xE9
{0x1C,0x00,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0xEA
{0x06,0x00,0x12,0x12,0x12,0x12,0x0C,0x00},   // 0xEB
{0x18,0x00,0x12,0x12,0x12,0x1C,0x08,0x06},   // 0xEC
{0x18,0x00,0x22,0x14,0x08,0x08,0x08,0x00},   // 0xED
{0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0x0C,0x0C,0x04,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00},   // 0xF0
{0x00,0x08,0x1C,0x08,0x00,0x1C,0x00,0x00},   // 0xF1
{0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00},   // 0xF2
{0x03,0x16,0x0B,0x34,0x2A,0x38,0x20,0x00},   // 0xF3
{0x3C,0x2A,0x2A,0x2C,0x28,0x28,0x28,0x00},   // 0xF4
{0x1C,0x22,0x0C,0x14,0x18,0x22,0x1C,0x00},   // 0xF5
{0x00,0x08,0x00,0x3E,0x00,0x08,0x00,0x00},   // 0xF6
{0x00,0x00,0x00,0x1C,0x18,0x00,0x00,0x00},   // 0xF7
{0x0C,0x12,0x12,0x0C,0x00,0x00,0x00,0x00},   // 0xF8
{0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00},   // 0xFA
{0x04,0x06,0x04,0x04,0x00,0x00,0x00,0x00},   // 0xFB
{0x0E,0x04,0x0C,0x06,0x00,0x00,0x00,0x00},   // 0xFC
{0x06,0x08,0x04,0x0E,0x00,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x1E,0x1E,0x1E,0x1E,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_6X10
__UG_FONT_DATA unsigned char font_6x10[256][10]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x00
{0x00,0x00,0x00,0x1E,0x23,0x2D,0x3F,0x1E,0x00,0x00},  // 0x01
{0x00,0x00,0x00,0x1E,0x37,0x3F,0x33,0x1E,0x00,0x00},  // 0x02
{0x00,0x33,0x3F,0x3F,0x3F,0x1E,0x1E,0x0C,0x00,0x00},  // 0x03
{0x00,0x08,0x0C,0x1E,0x3F,0x1E,0x0C,0x08,0x00,0x00},  // 0x04
{0x00,0x0C,0x0C,0x3F,0x3F,0x3F,0x04,0x04,0x00,0x00},  // 0x05
{0x00,0x08,0x1C,0x1E,0x3F,0x3F,0x04,0x04,0x00,0x00},  // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0A
{0x00,0x18,0x30,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x0B
{0x00,0x0E,0x11,0x11,0x11,0x0E,0x0E,0x04,0x00,0x00},  // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0D
{0x00,0x20,0x3C,0x24,0x24,0x3C,0x3C,0x07,0x03,0x00},  // 0x0E
{0x00,0x00,0x08,0x1E,0x33,0x12,0x1E,0x08,0x00,0x00},  // 0x0F
{0x00,0x00,0x01,0x0F,0x3F,0x0F,0x07,0x01,0x00,0x00},  // 0x10
{0x00,0x00,0x20,0x3C,0x3F,0x3C,0x38,0x20,0x00,0x00},  // 0x11
{0x00,0x08,0x1C,0x08,0x08,0x08,0x08,0x1C,0x08,0x00},  // 0x12
{0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x00,0x0A,0x00,0x00},  // 0x13
{0x00,0x1F,0x17,0x16,0x14,0x14,0x14,0x14,0x14,0x00},  // 0x14
{0x00,0x1C,0x02,0x0C,0x12,0x16,0x08,0x10,0x0E,0x00},  // 0x15
{0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00,0x00,0x00},  // 0x16
{0x08,0x1C,0x08,0x08,0x08,0x08,0x1C,0x08,0x00,0x1C},  // 0x17
{0x00,0x08,0x1C,0x08,0x08,0x08,0x08,0x08,0x08,0x00},  // 0x18
{0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x1C,0x08,0x00},  // 0x19
{0x00,0x00,0x00,0x10,0x3F,0x10,0x00,0x00,0x00,0x00},  // 0x1A
{0x00,0x00,0x00,0x02,0x3F,0x02,0x00,0x00,0x00,0x00},  // 0x1B
{0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x3F,0x00,0x00},  // 0x1C
{0x00,0x00,0x00,0x12,0x3F,0x12,0x00,0x00,0x00,0x00},  // 0x1D
{0x00,0x00,0x08,0x08,0x1C,0x1E,0x1E,0x3F,0x00,0x00},  // 0x1E
{0x00,0x00,0x3F,0x1E,0x1E,0x1C,0x08,0x08,0x00,0x00},  // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x20
{0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00},  // 0x21
{0x0A,0x0A,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x22
{0x00,0x14,0x14,0x3E,0x0A,0x1F,0x05,0x05,0x00,0x00},  // 0x23
{0x04,0x1E,0x05,0x07,0x0C,0x14,0x14,0x0F,0x04,0x00},  // 0x24
{0x00,0x22,0x15,0x0A,0x0C,0x14,0x2A,0x11,0x00,0x00},  // 0x25
{0x00,0x04,0x0A,0x0E,0x26,0x2D,0x19,0x1E,0x00,0x00},  // 0x26
{0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x27
{0x30,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x30,0x00},  // 0x28
{0x03,0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x03,0x00},  // 0x29
{0x00,0x04,0x1B,0x06,0x0A,0x00,0x00,0x00,0x00,0x00},  // 0x2A
{0x00,0x00,0x00,0x04,0x04,0x1F,0x04,0x04,0x00,0x00},  // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x08,0x04},  // 0x2C
{0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00},  // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00},  // 0x2E
{0x20,0x10,0x10,0x08,0x0C,0x04,0x02,0x02,0x01,0x00},  // 0x2F
{0x00,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x30
{0x00,0x06,0x05,0x04,0x04,0x04,0x04,0x1F,0x00,0x00},  // 0x31
{0x00,0x0E,0x10,0x10,0x08,0x04,0x02,0x1E,0x00,0x00},  // 0x32
{0x00,0x1E,0x10,0x10,0x0C,0x10,0x10,0x0E,0x00,0x00},  // 0x33
{0x00,0x08,0x0C,0x0A,0x09,0x1F,0x08,0x08,0x00,0x00},  // 0x34
{0x00,0x1E,0x02,0x02,0x0E,0x10,0x10,0x0E,0x00,0x00},  // 0x35
{0x00,0x1C,0x02,0x01,0x0D,0x13,0x11,0x0E,0x00,0x00},  // 0x36
{0x00,0x1E,0x10,0x08,0x04,0x04,0x02,0x02,0x00,0x00},  // 0x37
{0x00,0x0E,0x11,0x09,0x0E,0x11,0x11,0x0E,0x00,0x00},  // 0x38
{0x00,0x0E,0x11,0x11,0x1E,0x10,0x08,0x07,0x00,0x00},  // 0x39
{0x00,0x00,0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x00,0x00},  // 0x3A
{0x00,0x00,0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x08,0x04},  // 0x3B
{0x00,0x00,0x00,0x10,0x0C,0x03,0x0C,0x10,0x00,0x00},  // 0x3C
{0x00,0x00,0x00,0x00,0x3F,0x00,0x3F,0x00,0x00,0x00},  // 0x3D
{0x00,0x00,0x00,0x01,0x06,0x18,0x06,0x01,0x00,0x00},  // 0x3E
{0x00,0x1E,0x12,0x10,0x08,0x04,0x00,0x04,0x00,0x00},  // 0x3F
{0x00,0x1E,0x11,0x1D,0x15,0x3D,0x01,0x1E,0x00,0x00},  // 0x40
{0x00,0x0C,0x0C,0x0A,0x12,0x1E,0x12,0x21,0x00,0x00},  // 0x41
{0x00,0x0F,0x11,0x11,0x0F,0x11,0x11,0x0F,0x00,0x00},  // 0x42
{0x00,0x1C,0x02,0x01,0x01,0x01,0x02,0x1C,0x00,0x00},  // 0x43
{0x00,0x0F,0x11,0x11,0x11,0x11,0x11,0x0F,0x00,0x00},  // 0x44
{0x00,0x1E,0x02,0x02,0x0E,0x02,0x02,0x1E,0x00,0x00},  // 0x45
{0x00,0x1E,0x02,0x02,0x0E,0x02,0x02,0x02,0x00,0x00},  // 0x46
{0x00,0x1C,0x02,0x01,0x19,0x11,0x12,0x1C,0x00,0x00},  // 0x47
{0x00,0x11,0x11,0x11,0x1F,0x11,0x11,0x11,0x00,0x00},  // 0x48
{0x00,0x1F,0x04,0x04,0x04,0x04,0x04,0x1F,0x00,0x00},  // 0x49
{0x00,0x0E,0x08,0x08,0x08,0x08,0x08,0x06,0x00,0x00},  // 0x4A
{0x00,0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00},  // 0x4B
{0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x1E,0x00,0x00},  // 0x4C
{0x00,0x11,0x1B,0x1B,0x17,0x15,0x15,0x11,0x00,0x00},  // 0x4D
{0x00,0x11,0x13,0x17,0x15,0x19,0x19,0x11,0x00,0x00},  // 0x4E
{0x00,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x4F
{0x00,0x0F,0x11,0x11,0x0F,0x01,0x01,0x01,0x00,0x00},  // 0x50
{0x00,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x30,0x00},  // 0x51
{0x00,0x07,0x09,0x09,0x07,0x05,0x09,0x11,0x00,0x00},  // 0x52
{0x00,0x1C,0x02,0x02,0x0C,0x10,0x10,0x0E,0x00,0x00},  // 0x53
{0x00,0x1F,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00},  // 0x54
{0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x55
{0x00,0x21,0x11,0x12,0x12,0x0A,0x0C,0x04,0x00,0x00},  // 0x56
{0x00,0x11,0x15,0x15,0x15,0x0F,0x0A,0x0A,0x00,0x00},  // 0x57
{0x00,0x21,0x12,0x0C,0x08,0x0C,0x12,0x21,0x00,0x00},  // 0x58
{0x00,0x11,0x0A,0x0A,0x04,0x04,0x04,0x04,0x00,0x00},  // 0x59
{0x00,0x1F,0x10,0x08,0x04,0x02,0x01,0x1F,0x00,0x00},  // 0x5A
{0x1C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x1C,0x00},  // 0x5B
{0x01,0x02,0x02,0x04,0x04,0x08,0x10,0x10,0x20,0x00},  // 0x5C
{0x0E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0E,0x00},  // 0x5D
{0x00,0x04,0x04,0x0A,0x0A,0x0A,0x11,0x00,0x00,0x00},  // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00},  // 0x5F
{0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x60
{0x00,0x00,0x00,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0x61
{0x01,0x01,0x01,0x0D,0x13,0x11,0x11,0x0F,0x00,0x00},  // 0x62
{0x00,0x00,0x00,0x1E,0x01,0x01,0x01,0x1E,0x00,0x00},  // 0x63
{0x10,0x10,0x10,0x1E,0x11,0x11,0x19,0x16,0x00,0x00},  // 0x64
{0x00,0x00,0x00,0x0E,0x11,0x1F,0x01,0x1E,0x00,0x00},  // 0x65
{0x18,0x04,0x04,0x1E,0x04,0x04,0x04,0x04,0x00,0x00},  // 0x66
{0x00,0x00,0x00,0x1E,0x11,0x11,0x19,0x16,0x10,0x0E},  // 0x67
{0x01,0x01,0x01,0x1D,0x13,0x11,0x11,0x11,0x00,0x00},  // 0x68
{0x08,0x00,0x00,0x0E,0x08,0x08,0x08,0x08,0x00,0x00},  // 0x69
{0x08,0x00,0x00,0x0E,0x08,0x08,0x08,0x08,0x08,0x07},  // 0x6A
{0x02,0x02,0x02,0x12,0x0A,0x06,0x0A,0x12,0x00,0x00},  // 0x6B
{0x07,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00},  // 0x6C
{0x00,0x00,0x00,0x1F,0x15,0x15,0x15,0x15,0x00,0x00},  // 0x6D
{0x00,0x00,0x00,0x1D,0x13,0x11,0x11,0x11,0x00,0x00},  // 0x6E
{0x00,0x00,0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x6F
{0x00,0x00,0x00,0x0D,0x13,0x11,0x11,0x0F,0x01,0x01},  // 0x70
{0x00,0x00,0x00,0x1E,0x11,0x11,0x19,0x16,0x10,0x10},  // 0x71
{0x00,0x00,0x00,0x1A,0x16,0x02,0x02,0x02,0x00,0x00},  // 0x72
{0x00,0x00,0x00,0x1C,0x02,0x0C,0x10,0x0E,0x00,0x00},  // 0x73
{0x00,0x04,0x04,0x1E,0x04,0x04,0x04,0x18,0x00,0x00},  // 0x74
{0x00,0x00,0x00,0x11,0x11,0x11,0x19,0x17,0x00,0x00},  // 0x75
{0x00,0x00,0x00,0x11,0x0A,0x0A,0x0A,0x04,0x00,0x00},  // 0x76
{0x00,0x00,0x00,0x25,0x2D,0x2D,0x12,0x12,0x00,0x00},  // 0x77
{0x00,0x00,0x00,0x11,0x0A,0x04,0x0A,0x11,0x00,0x00},  // 0x78
{0x00,0x00,0x00,0x21,0x12,0x12,0x0C,0x0C,0x04,0x03},  // 0x79
{0x00,0x00,0x00,0x1F,0x08,0x04,0x02,0x1F,0x00,0x00},  // 0x7A
{0x1C,0x04,0x04,0x04,0x02,0x04,0x04,0x04,0x1C,0x00},  // 0x7B
{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00},  // 0x7C
{0x0E,0x08,0x08,0x08,0x10,0x08,0x08,0x08,0x0E,0x00},  // 0x7D
{0x00,0x00,0x00,0x00,0x27,0x39,0x00,0x00,0x00,0x00},  // 0x7E
{0x00,0x00,0x04,0x0A,0x11,0x11,0x11,0x1F,0x00,0x00},  // 0x7F
{0x00,0x1C,0x02,0x01,0x01,0x01,0x02,0x1C,0x08,0x0C},  // 0x80
{0x00,0x0A,0x00,0x11,0x11,0x11,0x19,0x17,0x00,0x00},  // 0x81
{0x10,0x08,0x00,0x0E,0x11,0x1F,0x01,0x1E,0x00,0x00},  // 0x82
{0x04,0x0A,0x00,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0x83
{0x00,0x0A,0x00,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0x84
{0x02,0x04,0x00,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0x85
{0x00,0x08,0x14,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0x86
{0x00,0x00,0x00,0x1E,0x01,0x01,0x01,0x1E,0x08,0x0C},  // 0x87
{0x04,0x0A,0x00,0x0E,0x11,0x1F,0x01,0x1E,0x00,0x00},  // 0x88
{0x00,0x0A,0x00,0x0E,0x11,0x1F,0x01,0x1E,0x00,0x00},  // 0x89
{0x02,0x04,0x00,0x0E,0x11,0x1F,0x01,0x1E,0x00,0x00},  // 0x8A
{0x00,0x0A,0x00,0x0E,0x08,0x08,0x08,0x08,0x00,0x00},  // 0x8B
{0x04,0x0A,0x00,0x0E,0x08,0x08,0x08,0x08,0x00,0x00},  // 0x8C
{0x02,0x04,0x00,0x0E,0x08,0x08,0x08,0x08,0x00,0x00},  // 0x8D
{0x0A,0x0C,0x0C,0x0A,0x12,0x1E,0x12,0x21,0x00,0x00},  // 0x8E
{0x1C,0x08,0x0C,0x14,0x12,0x1E,0x22,0x21,0x00,0x00},  // 0x8F
{0x10,0x1E,0x02,0x02,0x0E,0x02,0x02,0x1E,0x00,0x00},  // 0x90
{0x00,0x00,0x00,0x1B,0x24,0x3E,0x05,0x3B,0x00,0x00},  // 0x91
{0x00,0x38,0x0C,0x0C,0x1A,0x0A,0x0E,0x39,0x00,0x00},  // 0x92
{0x04,0x0A,0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x93
{0x00,0x0A,0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x94
{0x02,0x04,0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x95
{0x04,0x0A,0x00,0x11,0x11,0x11,0x19,0x17,0x00,0x00},  // 0x96
{0x02,0x04,0x00,0x11,0x11,0x11,0x19,0x17,0x00,0x00},  // 0x97
{0x00,0x0A,0x00,0x21,0x12,0x12,0x0C,0x0C,0x04,0x03},  // 0x98
{0x0A,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x99
{0x0A,0x11,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0x9A
{0x00,0x00,0x00,0x1E,0x19,0x15,0x13,0x0F,0x00,0x00},  // 0x9B
{0x00,0x18,0x04,0x04,0x0E,0x04,0x04,0x1E,0x00,0x00},  // 0x9C
{0x00,0x1E,0x19,0x15,0x15,0x13,0x13,0x0F,0x00,0x00},  // 0x9D
{0x00,0x00,0x00,0x11,0x0A,0x04,0x0A,0x11,0x00,0x00},  // 0x9E
{0x1C,0x04,0x04,0x0E,0x04,0x04,0x04,0x04,0x04,0x07},  // 0x9F
{0x10,0x08,0x00,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0xA0
{0x08,0x04,0x00,0x0E,0x08,0x08,0x08,0x08,0x00,0x00},  // 0xA1
{0x08,0x04,0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xA2
{0x08,0x04,0x00,0x11,0x11,0x11,0x19,0x17,0x00,0x00},  // 0xA3
{0x0A,0x0E,0x00,0x1D,0x13,0x11,0x11,0x11,0x00,0x00},  // 0xA4
{0x0A,0x15,0x13,0x17,0x15,0x19,0x19,0x11,0x00,0x00},  // 0xA5
{0x00,0x0E,0x0E,0x0A,0x1E,0x00,0x00,0x00,0x00,0x00},  // 0xA6
{0x00,0x0C,0x12,0x12,0x0C,0x00,0x00,0x00,0x00,0x00},  // 0xA7
{0x00,0x00,0x00,0x08,0x00,0x08,0x04,0x02,0x12,0x1E},  // 0xA8
{0x00,0x0E,0x11,0x17,0x11,0x0E,0x00,0x00,0x00,0x00},  // 0xA9
{0x00,0x00,0x00,0x00,0x1F,0x10,0x10,0x00,0x00,0x00},  // 0xAA
{0x00,0x13,0x0A,0x0A,0x3C,0x22,0x1A,0x39,0x00,0x00},  // 0xAB
{0x00,0x13,0x0A,0x0A,0x1C,0x16,0x3E,0x11,0x00,0x00},  // 0xAC
{0x00,0x00,0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x04},  // 0xAD
{0x00,0x00,0x00,0x14,0x0A,0x05,0x0A,0x14,0x00,0x00},  // 0xAE
{0x00,0x00,0x00,0x05,0x0A,0x14,0x0A,0x05,0x00,0x00},  // 0xAF
{0x15,0x00,0x15,0x00,0x15,0x00,0x15,0x00,0x15,0x00},  // 0xB0
{0x2A,0x15,0x2A,0x15,0x2A,0x15,0x2A,0x15,0x2A,0x15},  // 0xB1
{0x3F,0x15,0x3F,0x15,0x3F,0x15,0x3F,0x15,0x3F,0x15},  // 0xB2
{0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08},  // 0xB3
{0x08,0x08,0x08,0x08,0x0F,0x08,0x08,0x08,0x08,0x08},  // 0xB4
{0x08,0x0C,0x0C,0x0A,0x12,0x1E,0x12,0x21,0x00,0x00},  // 0xB5
{0x04,0x0E,0x0C,0x0A,0x12,0x1E,0x12,0x21,0x00,0x00},  // 0xB6
{0x02,0x0C,0x0C,0x0A,0x12,0x1E,0x12,0x21,0x00,0x00},  // 0xB7
{0x00,0x1E,0x21,0x2D,0x25,0x2D,0x21,0x1E,0x00,0x00},  // 0xB8
{0x14,0x14,0x14,0x17,0x10,0x17,0x14,0x14,0x14,0x14},  // 0xB9
{0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14},  // 0xBA
{0x00,0x00,0x00,0x1F,0x10,0x17,0x14,0x14,0x14,0x14},  // 0xBB
{0x14,0x14,0x14,0x17,0x10,0x1F,0x00,0x00,0x00,0x00},  // 0xBC
{0x00,0x08,0x1C,0x0A,0x0A,0x0A,0x1C,0x08,0x00,0x00},  // 0xBD
{0x00,0x21,0x12,0x0C,0x0E,0x04,0x0E,0x04,0x00,0x00},  // 0xBE
{0x00,0x00,0x00,0x00,0x0F,0x08,0x08,0x08,0x08,0x08},  // 0xBF
{0x08,0x08,0x08,0x08,0x38,0x00,0x00,0x00,0x00,0x00},  // 0xC0
{0x08,0x08,0x08,0x08,0x3F,0x00,0x00,0x00,0x00,0x00},  // 0xC1
{0x00,0x00,0x00,0x00,0x3F,0x08,0x08,0x08,0x08,0x08},  // 0xC2
{0x08,0x08,0x08,0x08,0x38,0x08,0x08,0x08,0x08,0x08},  // 0xC3
{0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00},  // 0xC4
{0x08,0x08,0x08,0x08,0x3F,0x08,0x08,0x08,0x08,0x08},  // 0xC5
{0x0A,0x0E,0x00,0x0E,0x10,0x1C,0x12,0x3E,0x00,0x00},  // 0xC6
{0x0A,0x0D,0x0C,0x0A,0x12,0x1E,0x12,0x21,0x00,0x00},  // 0xC7
{0x14,0x14,0x14,0x34,0x04,0x3C,0x00,0x00,0x00,0x00},  // 0xC8
{0x00,0x00,0x00,0x3C,0x04,0x34,0x14,0x14,0x14,0x14},  // 0xC9
{0x14,0x14,0x14,0x37,0x00,0x3F,0x00,0x00,0x00,0x00},  // 0xCA
{0x00,0x00,0x00,0x3F,0x00,0x37,0x14,0x14,0x14,0x14},  // 0xCB
{0x14,0x14,0x14,0x34,0x04,0x34,0x14,0x14,0x14,0x14},  // 0xCC
{0x00,0x00,0x00,0x3F,0x00,0x3F,0x00,0x00,0x00,0x00},  // 0xCD
{0x14,0x14,0x14,0x37,0x00,0x37,0x14,0x14,0x14,0x14},  // 0xCE
{0x00,0x21,0x1E,0x12,0x12,0x1E,0x21,0x00,0x00,0x00},  // 0xCF
{0x0B,0x06,0x09,0x1E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xD0
{0x00,0x0F,0x11,0x11,0x13,0x11,0x11,0x0F,0x00,0x00},  // 0xD1
{0x04,0x1E,0x02,0x02,0x0E,0x02,0x02,0x1E,0x00,0x00},  // 0xD2
{0x0A,0x1E,0x02,0x02,0x0E,0x02,0x02,0x1E,0x00,0x00},  // 0xD3
{0x04,0x1E,0x02,0x02,0x0E,0x02,0x02,0x1E,0x00,0x00},  // 0xD4
{0x00,0x00,0x00,0x0E,0x08,0x08,0x08,0x08,0x00,0x00},  // 0xD5
{0x08,0x1F,0x04,0x04,0x04,0x04,0x04,0x1F,0x00,0x00},  // 0xD6
{0x04,0x1F,0x04,0x04,0x04,0x04,0x04,0x1F,0x00,0x00},  // 0xD7
{0x0A,0x1F,0x04,0x04,0x04,0x04,0x04,0x1F,0x00,0x00},  // 0xD8
{0x08,0x08,0x08,0x08,0x0F,0x00,0x00,0x00,0x00,0x00},  // 0xD9
{0x00,0x00,0x00,0x00,0x38,0x08,0x08,0x08,0x08,0x08},  // 0xDA
{0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},  // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x3F,0x3F,0x3F},  // 0xDC
{0x04,0x04,0x04,0x00,0x00,0x00,0x04,0x04,0x04,0x00},  // 0xDD
{0x04,0x1F,0x04,0x04,0x04,0x04,0x04,0x1F,0x00,0x00},  // 0xDE
{0x3F,0x3F,0x3F,0x3F,0x3F,0x00,0x00,0x00,0x00,0x00},  // 0xDF
{0x08,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xE0
{0x0E,0x09,0x09,0x05,0x05,0x09,0x11,0x1D,0x00,0x00},  // 0xE1
{0x04,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xE2
{0x04,0x0E,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xE3
{0x0A,0x0E,0x00,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xE4
{0x0A,0x0F,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xE5
{0x00,0x00,0x00,0x11,0x11,0x11,0x19,0x17,0x01,0x01},  // 0xE6
{0x01,0x01,0x01,0x0D,0x13,0x11,0x11,0x0F,0x01,0x01},  // 0xE7
{0x00,0x01,0x0F,0x11,0x11,0x11,0x0F,0x01,0x00,0x00},  // 0xE8
{0x08,0x15,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xE9
{0x04,0x1B,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xEA
{0x04,0x19,0x11,0x11,0x11,0x11,0x11,0x0E,0x00,0x00},  // 0xEB
{0x10,0x08,0x00,0x21,0x12,0x12,0x0C,0x0C,0x04,0x03},  // 0xEC
{0x10,0x19,0x0A,0x0A,0x04,0x04,0x04,0x04,0x00,0x00},  // 0xED
{0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEE
{0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEF
{0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00},  // 0xF0
{0x00,0x00,0x04,0x04,0x1F,0x04,0x04,0x1F,0x00,0x00},  // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00},  // 0xF2
{0x00,0x27,0x13,0x0F,0x1C,0x14,0x3E,0x11,0x00,0x00},  // 0xF3
{0x00,0x1F,0x17,0x16,0x14,0x14,0x14,0x14,0x14,0x00},  // 0xF4
{0x00,0x1C,0x02,0x0C,0x12,0x16,0x08,0x10,0x0E,0x00},  // 0xF5
{0x00,0x00,0x00,0x04,0x00,0x1F,0x00,0x04,0x00,0x00},  // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x0C},  // 0xF7
{0x00,0x04,0x0A,0x04,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF8
{0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00},  // 0xFA
{0x00,0x0C,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFB
{0x00,0x1C,0x08,0x1C,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFC
{0x00,0x0E,0x04,0x0E,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFD
{0x00,0x00,0x00,0x3F,0x3F,0x3F,0x3F,0x3F,0x00,0x00},  // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}   // 0xFF
};
#endif

#ifdef USE_FONT_7X12
__UG_FONT_DATA unsigned char font_7x12[256][12]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x00
{0x00,0x1C,0x22,0x55,0x41,0x63,0x5D,0x22,0x1C,0x00,0x00,0x00}, // 0x01
{0x00,0x1C,0x3E,0x6B,0x7F,0x5D,0x63,0x3E,0x1C,0x00,0x00,0x00}, // 0x02
{0x00,0x36,0x7F,0x7F,0x7F,0x3E,0x1C,0x08,0x00,0x00,0x00,0x00}, // 0x03
{0x00,0x08,0x1C,0x3E,0x7F,0x3E,0x1C,0x08,0x00,0x00,0x00,0x00}, // 0x04
{0x1C,0x1C,0x1C,0x2A,0x7F,0x7F,0x36,0x08,0x3E,0x00,0x00,0x00}, // 0x05
{0x08,0x1C,0x3E,0x7F,0x7F,0x7F,0x36,0x08,0x3E,0x00,0x00,0x00}, // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0A
{0x00,0x38,0x30,0x28,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00,0x00}, // 0x0B
{0x1C,0x22,0x22,0x22,0x1C,0x08,0x3E,0x08,0x08,0x00,0x00,0x00}, // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0D
{0x70,0x4C,0x74,0x4C,0x44,0x44,0x74,0x37,0x03,0x00,0x00,0x00}, // 0x0E
{0x08,0x2A,0x1C,0x22,0x63,0x22,0x1C,0x2A,0x08,0x00,0x00,0x00}, // 0x0F
{0x00,0x00,0x04,0x0C,0x1C,0x3C,0x1C,0x0C,0x04,0x00,0x00,0x00}, // 0x10
{0x00,0x00,0x10,0x18,0x1C,0x1E,0x1C,0x18,0x10,0x00,0x00,0x00}, // 0x11
{0x08,0x1C,0x3E,0x08,0x08,0x08,0x3E,0x1C,0x08,0x00,0x00,0x00}, // 0x12
{0x36,0x36,0x36,0x36,0x36,0x36,0x00,0x36,0x36,0x00,0x00,0x00}, // 0x13
{0x7C,0x56,0x56,0x56,0x5C,0x50,0x50,0x50,0x50,0x00,0x00,0x00}, // 0x14
{0x3C,0x36,0x06,0x1E,0x14,0x3C,0x30,0x36,0x1E,0x00,0x00,0x00}, // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x3E,0x00,0x00,0x00}, // 0x16
{0x08,0x1C,0x3E,0x08,0x08,0x3E,0x1C,0x08,0x3E,0x00,0x00,0x00}, // 0x17
{0x08,0x1C,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00}, // 0x18
{0x08,0x08,0x08,0x08,0x08,0x08,0x3E,0x1C,0x08,0x00,0x00,0x00}, // 0x19
{0x00,0x00,0x00,0x08,0x18,0x3F,0x18,0x08,0x00,0x00,0x00,0x00}, // 0x1A
{0x00,0x00,0x00,0x04,0x06,0x3F,0x06,0x04,0x00,0x00,0x00,0x00}, // 0x1B
{0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x3E,0x00,0x00,0x00}, // 0x1C
{0x00,0x00,0x00,0x14,0x36,0x7F,0x36,0x14,0x00,0x00,0x00,0x00}, // 0x1D
{0x08,0x08,0x1C,0x1C,0x3E,0x3E,0x7F,0x7F,0x00,0x00,0x00,0x00}, // 0x1E
{0x00,0x7F,0x7F,0x3E,0x3E,0x1C,0x1C,0x08,0x08,0x00,0x00,0x00}, // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x20
{0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x00,0x00,0x00}, // 0x21
{0x36,0x36,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x22
{0x00,0x14,0x14,0x3E,0x14,0x14,0x3E,0x14,0x14,0x00,0x00,0x00}, // 0x23
{0x08,0x1C,0x26,0x06,0x1C,0x30,0x32,0x1C,0x08,0x08,0x00,0x00}, // 0x24
{0x64,0x6A,0x6A,0x34,0x18,0x2C,0x56,0x56,0x26,0x00,0x00,0x00}, // 0x25
{0x1C,0x36,0x36,0x1C,0x5C,0x76,0x36,0x36,0x6C,0x00,0x00,0x00}, // 0x26
{0x18,0x18,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x27
{0x18,0x0C,0x06,0x06,0x06,0x06,0x06,0x0C,0x18,0x00,0x00,0x00}, // 0x28
{0x06,0x0C,0x18,0x18,0x18,0x18,0x18,0x0C,0x06,0x00,0x00,0x00}, // 0x29
{0x00,0x00,0x36,0x1C,0x7F,0x1C,0x36,0x00,0x00,0x00,0x00,0x00}, // 0x2A
{0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00}, // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x18,0x0C,0x00}, // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x00,0x00,0x00}, // 0x2E
{0x30,0x30,0x18,0x18,0x0C,0x0C,0x06,0x06,0x03,0x00,0x00,0x00}, // 0x2F
{0x3C,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x1E,0x00,0x00,0x00}, // 0x30
{0x18,0x1C,0x1E,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00}, // 0x31
{0x1C,0x36,0x36,0x30,0x18,0x18,0x0C,0x06,0x3E,0x00,0x00,0x00}, // 0x32
{0x1C,0x36,0x30,0x30,0x1C,0x30,0x30,0x36,0x1C,0x00,0x00,0x00}, // 0x33
{0x0C,0x0C,0x0C,0x36,0x36,0x36,0x7E,0x30,0x30,0x00,0x00,0x00}, // 0x34
{0x3E,0x06,0x06,0x06,0x1E,0x30,0x30,0x36,0x1C,0x00,0x00,0x00}, // 0x35
{0x18,0x0C,0x0C,0x06,0x1E,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x36
{0x3E,0x30,0x30,0x18,0x18,0x18,0x0C,0x0C,0x0C,0x00,0x00,0x00}, // 0x37
{0x1C,0x36,0x36,0x36,0x1C,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x38
{0x1C,0x36,0x36,0x36,0x3C,0x18,0x18,0x0C,0x06,0x00,0x00,0x00}, // 0x39
{0x00,0x00,0x1C,0x1C,0x00,0x00,0x00,0x1C,0x1C,0x00,0x00,0x00}, // 0x3A
{0x00,0x00,0x1C,0x1C,0x00,0x00,0x00,0x1C,0x1C,0x18,0x0C,0x00}, // 0x3B
{0x20,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00}, // 0x3C
{0x00,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00}, // 0x3D
{0x02,0x06,0x0C,0x18,0x30,0x18,0x0C,0x06,0x02,0x00,0x00,0x00}, // 0x3E
{0x1C,0x36,0x36,0x30,0x18,0x0C,0x00,0x0C,0x0C,0x00,0x00,0x00}, // 0x3F
{0x38,0x4C,0x66,0x56,0x56,0x56,0x26,0x0C,0x78,0x00,0x00,0x00}, // 0x40
{0x08,0x1C,0x36,0x36,0x36,0x3E,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x41
{0x1E,0x36,0x36,0x36,0x1E,0x36,0x36,0x36,0x1E,0x00,0x00,0x00}, // 0x42
{0x1C,0x36,0x36,0x06,0x06,0x06,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x43
{0x1E,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x1E,0x00,0x00,0x00}, // 0x44
{0x3E,0x06,0x06,0x06,0x1E,0x06,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0x45
{0x3E,0x06,0x06,0x06,0x1E,0x06,0x06,0x06,0x06,0x00,0x00,0x00}, // 0x46
{0x1C,0x36,0x06,0x06,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x47
{0x36,0x36,0x36,0x36,0x3E,0x36,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x48
{0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00}, // 0x49
{0x30,0x30,0x30,0x30,0x30,0x30,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x4A
{0x36,0x36,0x36,0x1E,0x0E,0x1E,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x4B
{0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0x4C
{0x63,0x63,0x77,0x77,0x7F,0x6B,0x6B,0x63,0x63,0x00,0x00,0x00}, // 0x4D
{0x66,0x66,0x6E,0x6E,0x7E,0x76,0x66,0x66,0x66,0x00,0x00,0x00}, // 0x4E
{0x1C,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x4F
{0x1E,0x36,0x36,0x36,0x1E,0x06,0x06,0x06,0x06,0x00,0x00,0x00}, // 0x50
{0x1C,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x1C,0x18,0x30,0x00}, // 0x51
{0x1E,0x36,0x36,0x36,0x1E,0x36,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x52
{0x1C,0x36,0x26,0x0E,0x1C,0x38,0x32,0x36,0x1C,0x00,0x00,0x00}, // 0x53
{0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00}, // 0x54
{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x55
{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x1C,0x08,0x00,0x00,0x00}, // 0x56
{0x63,0x63,0x6B,0x6B,0x6B,0x6B,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x57
{0x36,0x36,0x36,0x1C,0x08,0x1C,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x58
{0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x00,0x00,0x00}, // 0x59
{0x3E,0x30,0x18,0x18,0x0C,0x0C,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0x5A
{0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00}, // 0x5B
{0x06,0x06,0x0C,0x0C,0x18,0x18,0x30,0x30,0x60,0x00,0x00,0x00}, // 0x5C
{0x1E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1E,0x00}, // 0x5D
{0x08,0x1C,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00}, // 0x5F
{0x0C,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x60
{0x00,0x00,0x00,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x61
{0x06,0x06,0x06,0x1E,0x36,0x36,0x36,0x36,0x1E,0x00,0x00,0x00}, // 0x62
{0x00,0x00,0x00,0x1C,0x36,0x06,0x06,0x36,0x1C,0x00,0x00,0x00}, // 0x63
{0x30,0x30,0x30,0x3C,0x36,0x36,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x64
{0x00,0x00,0x00,0x1C,0x36,0x3E,0x06,0x26,0x1C,0x00,0x00,0x00}, // 0x65
{0x38,0x0C,0x0C,0x3E,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00}, // 0x66
{0x00,0x00,0x00,0x3C,0x36,0x36,0x36,0x3C,0x30,0x32,0x1C,0x00}, // 0x67
{0x06,0x06,0x06,0x1E,0x36,0x36,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x68
{0x18,0x00,0x00,0x1C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00}, // 0x69
{0x18,0x00,0x00,0x1C,0x18,0x18,0x18,0x18,0x18,0x18,0x0E,0x00}, // 0x6A
{0x06,0x06,0x06,0x36,0x1E,0x0E,0x1E,0x36,0x36,0x00,0x00,0x00}, // 0x6B
{0x1C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00}, // 0x6C
{0x00,0x00,0x00,0x37,0x7F,0x6B,0x6B,0x6B,0x63,0x00,0x00,0x00}, // 0x6D
{0x00,0x00,0x00,0x1E,0x36,0x36,0x36,0x36,0x36,0x00,0x00,0x00}, // 0x6E
{0x00,0x00,0x00,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x6F
{0x00,0x00,0x00,0x1E,0x36,0x36,0x36,0x36,0x1E,0x06,0x06,0x00}, // 0x70
{0x00,0x00,0x00,0x3C,0x36,0x36,0x36,0x36,0x3C,0x30,0x30,0x00}, // 0x71
{0x00,0x00,0x00,0x36,0x3E,0x06,0x06,0x06,0x06,0x00,0x00,0x00}, // 0x72
{0x00,0x00,0x00,0x3C,0x06,0x1E,0x3C,0x30,0x1E,0x00,0x00,0x00}, // 0x73
{0x00,0x0C,0x0C,0x1E,0x0C,0x0C,0x0C,0x0C,0x38,0x00,0x00,0x00}, // 0x74
{0x00,0x00,0x00,0x36,0x36,0x36,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x75
{0x00,0x00,0x00,0x36,0x36,0x36,0x36,0x1C,0x08,0x00,0x00,0x00}, // 0x76
{0x00,0x00,0x00,0x63,0x6B,0x6B,0x6B,0x3E,0x36,0x00,0x00,0x00}, // 0x77
{0x00,0x00,0x00,0x36,0x36,0x1C,0x1C,0x36,0x36,0x00,0x00,0x00}, // 0x78
{0x00,0x00,0x00,0x36,0x36,0x36,0x36,0x1C,0x18,0x0C,0x06,0x00}, // 0x79
{0x00,0x00,0x00,0x3E,0x30,0x18,0x0C,0x06,0x3E,0x00,0x00,0x00}, // 0x7A
{0x38,0x0C,0x0C,0x0C,0x06,0x0C,0x0C,0x0C,0x38,0x00,0x00,0x00}, // 0x7B
{0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x00}, // 0x7C
{0x06,0x0C,0x0C,0x0C,0x18,0x0C,0x0C,0x0C,0x06,0x00,0x00,0x00}, // 0x7D
{0x2C,0x3E,0x1A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7E
{0x00,0x00,0x08,0x1C,0x36,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00}, // 0x7F
{0x1C,0x36,0x36,0x06,0x06,0x06,0x36,0x36,0x1C,0x08,0x10,0x0C}, // 0x80
{0x36,0x36,0x00,0x36,0x36,0x36,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x81
{0x38,0x0C,0x00,0x1C,0x36,0x3E,0x06,0x26,0x1C,0x00,0x00,0x00}, // 0x82
{0x1C,0x36,0x00,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x83
{0x36,0x36,0x00,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x84
{0x0E,0x18,0x00,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x85
{0x0C,0x12,0x0C,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x86
{0x00,0x00,0x00,0x1C,0x36,0x06,0x06,0x36,0x1C,0x08,0x10,0x0C}, // 0x87
{0x1C,0x36,0x00,0x1C,0x36,0x3E,0x06,0x26,0x1C,0x00,0x00,0x00}, // 0x88
{0x36,0x36,0x00,0x1C,0x36,0x3E,0x06,0x26,0x1C,0x00,0x00,0x00}, // 0x89
{0x0E,0x18,0x00,0x1C,0x36,0x3E,0x06,0x26,0x1C,0x00,0x00,0x00}, // 0x8A
{0x36,0x36,0x00,0x1C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00}, // 0x8B
{0x1C,0x36,0x00,0x0E,0x0C,0x0C,0x0C,0x0C,0x3E,0x00,0x00,0x00}, // 0x8C
{0x0E,0x18,0x00,0x1C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00}, // 0x8D
{0x36,0x36,0x08,0x1C,0x36,0x36,0x3E,0x36,0x36,0x00,0x00,0x00}, // 0x8E
{0x08,0x14,0x08,0x1C,0x36,0x36,0x3E,0x36,0x36,0x00,0x00,0x00}, // 0x8F
{0x38,0x0C,0x00,0x3E,0x06,0x1E,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0x90
{0x00,0x00,0x00,0x3E,0x58,0x5C,0x7A,0x1A,0x6C,0x00,0x00,0x00}, // 0x91
{0x7C,0x1E,0x1A,0x1A,0x7A,0x1E,0x1A,0x1A,0x7A,0x00,0x00,0x00}, // 0x92
{0x1C,0x36,0x00,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x93
{0x36,0x36,0x00,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x94
{0x0E,0x18,0x00,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x95
{0x1C,0x36,0x00,0x36,0x36,0x36,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x96
{0x0E,0x18,0x00,0x36,0x36,0x36,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0x97
{0x36,0x36,0x00,0x36,0x36,0x36,0x36,0x1C,0x18,0x0C,0x06,0x00}, // 0x98
{0x36,0x00,0x1C,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x99
{0x36,0x00,0x36,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0x9A
{0x00,0x00,0x20,0x3C,0x36,0x3E,0x3E,0x36,0x1E,0x02,0x00,0x00}, // 0x9B
{0x1C,0x36,0x06,0x06,0x1F,0x06,0x06,0x03,0x3F,0x00,0x00,0x00}, // 0x9C
{0x20,0x3C,0x36,0x36,0x3E,0x3E,0x36,0x36,0x1E,0x02,0x00,0x00}, // 0x9D
{0x00,0x00,0x22,0x14,0x08,0x14,0x22,0x00,0x00,0x00,0x00,0x00}, // 0x9E
{0x38,0x0C,0x0C,0x3E,0x0C,0x0C,0x0C,0x0C,0x0C,0x06,0x00,0x00}, // 0x9F
{0x38,0x0C,0x00,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0xA0
{0x38,0x0C,0x00,0x1C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00}, // 0xA1
{0x38,0x0C,0x00,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xA2
{0x38,0x0C,0x00,0x36,0x36,0x36,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0xA3
{0x2C,0x1A,0x00,0x1E,0x36,0x36,0x36,0x36,0x36,0x00,0x00,0x00}, // 0xA4
{0x2C,0x1A,0x00,0x66,0x6E,0x7E,0x76,0x66,0x66,0x00,0x00,0x00}, // 0xA5
{0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x3E,0x00,0x00,0x00,0x00}, // 0xA6
{0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x3E,0x00,0x00,0x00,0x00}, // 0xA7
{0x18,0x18,0x00,0x18,0x0C,0x06,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xA8
{0x1C,0x22,0x4D,0x55,0x4D,0x55,0x55,0x22,0x1C,0x00,0x00,0x00}, // 0xA9
{0x00,0x00,0x00,0x00,0x3E,0x20,0x20,0x20,0x20,0x00,0x00,0x00}, // 0xAA
{0x04,0x06,0x24,0x14,0x38,0x44,0x22,0x30,0x70,0x00,0x00,0x00}, // 0xAB
{0x04,0x06,0x24,0x14,0x48,0x64,0x52,0x78,0x40,0x00,0x00,0x00}, // 0xAC
{0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00}, // 0xAD
{0x00,0x00,0x6C,0x36,0x1B,0x1B,0x36,0x6C,0x00,0x00,0x00,0x00}, // 0xAE
{0x00,0x00,0x1B,0x36,0x6C,0x6C,0x36,0x1B,0x00,0x00,0x00,0x00}, // 0xAF
{0x24,0x00,0x09,0x00,0x24,0x00,0x09,0x00,0x24,0x00,0x09,0x00}, // 0xB0
{0x24,0x09,0x24,0x09,0x24,0x09,0x24,0x09,0x24,0x09,0x24,0x09}, // 0xB1
{0x56,0x29,0x56,0x29,0x56,0x29,0x56,0x29,0x56,0x29,0x56,0x29}, // 0xB2
{0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xB3
{0x08,0x08,0x08,0x08,0x08,0x0F,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xB4
{0x38,0x0C,0x08,0x1C,0x36,0x36,0x3E,0x36,0x36,0x00,0x00,0x00}, // 0xB5
{0x1C,0x36,0x08,0x1C,0x36,0x36,0x3E,0x36,0x36,0x00,0x00,0x00}, // 0xB6
{0x0E,0x18,0x08,0x1C,0x36,0x36,0x3E,0x36,0x36,0x00,0x00,0x00}, // 0xB7
{0x1C,0x22,0x49,0x55,0x45,0x55,0x49,0x22,0x1C,0x00,0x00,0x00}, // 0xB8
{0x14,0x14,0x14,0x14,0x17,0x10,0x17,0x14,0x14,0x14,0x14,0x14}, // 0xB9
{0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14}, // 0xBA
{0x00,0x00,0x00,0x00,0x1F,0x10,0x17,0x14,0x14,0x14,0x14,0x14}, // 0xBB
{0x14,0x14,0x14,0x14,0x17,0x10,0x1F,0x00,0x00,0x00,0x00,0x00}, // 0xBC
{0x10,0x10,0x3C,0x06,0x06,0x06,0x3C,0x10,0x10,0x00,0x00,0x00}, // 0xBD
{0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x7E,0x18,0x00,0x00,0x00}, // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x0F,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xBF
{0x08,0x08,0x08,0x08,0x08,0x78,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC0
{0x08,0x08,0x08,0x08,0x08,0x7F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x7F,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xC2
{0x08,0x08,0x08,0x08,0x08,0x78,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC4
{0x08,0x08,0x08,0x08,0x08,0x7F,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xC5
{0x2C,0x1A,0x00,0x1C,0x30,0x3C,0x36,0x36,0x3C,0x00,0x00,0x00}, // 0xC6
{0x2C,0x1A,0x08,0x1C,0x36,0x36,0x3E,0x36,0x36,0x00,0x00,0x00}, // 0xC7
{0x14,0x14,0x14,0x14,0x74,0x04,0x7C,0x00,0x00,0x00,0x00,0x00}, // 0xC8
{0x00,0x00,0x00,0x00,0x7C,0x04,0x74,0x14,0x14,0x14,0x14,0x14}, // 0xC9
{0x14,0x14,0x14,0x14,0x77,0x00,0x7F,0x00,0x00,0x00,0x00,0x00}, // 0xCA
{0x00,0x00,0x00,0x00,0x7F,0x00,0x77,0x14,0x14,0x14,0x14,0x14}, // 0xCB
{0x14,0x14,0x14,0x14,0x74,0x04,0x74,0x14,0x14,0x14,0x14,0x14}, // 0xCC
{0x00,0x00,0x00,0x00,0x7F,0x00,0x7F,0x00,0x00,0x00,0x00,0x00}, // 0xCD
{0x14,0x14,0x14,0x14,0x77,0x00,0x77,0x14,0x14,0x14,0x14,0x14}, // 0xCE
{0x00,0x00,0x2D,0x12,0x21,0x21,0x21,0x12,0x2D,0x00,0x00,0x00}, // 0xCF
{0x3C,0x06,0x0C,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xD0
{0x1E,0x36,0x36,0x36,0x3F,0x36,0x36,0x36,0x1E,0x00,0x00,0x00}, // 0xD1
{0x1C,0x36,0x00,0x3E,0x06,0x1E,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0xD2
{0x36,0x36,0x00,0x3E,0x06,0x1E,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0xD3
{0x0E,0x18,0x00,0x3E,0x06,0x1E,0x06,0x06,0x3E,0x00,0x00,0x00}, // 0xD4
{0x00,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD5
{0x38,0x0C,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00}, // 0xD6
{0x0E,0x1B,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00}, // 0xD7
{0x36,0x36,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00}, // 0xD8
{0x08,0x08,0x08,0x08,0x08,0x0F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x78,0x08,0x08,0x08,0x08,0x08,0x08}, // 0xDA
{0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F}, // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F}, // 0xDC
{0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x00}, // 0xDD
{0x07,0x0C,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00}, // 0xDE
{0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDF
{0x1C,0x06,0x1C,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xE0
{0x1C,0x36,0x36,0x36,0x1E,0x36,0x36,0x36,0x1E,0x06,0x00,0x00}, // 0xE1
{0x1C,0x36,0x1C,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xE2
{0x1C,0x30,0x1C,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xE3
{0x2C,0x1A,0x00,0x1C,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xE4
{0x2C,0x1A,0x1C,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xE5
{0x00,0x00,0x00,0x36,0x36,0x36,0x36,0x36,0x6E,0x06,0x06,0x00}, // 0xE6
{0x00,0x0F,0x06,0x1E,0x36,0x36,0x1E,0x06,0x0F,0x00,0x00,0x00}, // 0xE7
{0x0F,0x06,0x1E,0x36,0x36,0x36,0x1E,0x06,0x0F,0x00,0x00,0x00}, // 0xE8
{0x38,0x0C,0x00,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xE9
{0x1C,0x36,0x00,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xEA
{0x0E,0x18,0x00,0x36,0x36,0x36,0x36,0x36,0x1C,0x00,0x00,0x00}, // 0xEB
{0x38,0x0C,0x00,0x36,0x36,0x36,0x36,0x1C,0x18,0x0C,0x06,0x00}, // 0xEC
{0x38,0x0C,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x00,0x00,0x00}, // 0xED
{0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEE
{0x38,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF0
{0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x7E,0x00,0x00,0x00}, // 0xF1
{0x00,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00}, // 0xF2
{0x0E,0x06,0x2C,0x16,0x48,0x64,0x52,0x78,0x40,0x00,0x00,0x00}, // 0xF3
{0x7C,0x56,0x56,0x56,0x5C,0x50,0x50,0x50,0x50,0x00,0x00,0x00}, // 0xF4
{0x3C,0x36,0x06,0x1E,0x14,0x3C,0x30,0x36,0x1E,0x00,0x00,0x00}, // 0xF5
{0x00,0x00,0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00}, // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x34,0x38,0x00,0x00,0x00,0x00,0x00}, // 0xF7
{0x1C,0x36,0x36,0x36,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF8
{0x00,0x00,0x00,0x00,0x36,0x36,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF9
{0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFA
{0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFB
{0x0E,0x18,0x0C,0x18,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFC
{0x0E,0x18,0x0C,0x06,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFD
{0x00,0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00,0x00,0x00,0x00}, // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 0xFF
};
#endif

#ifdef USE_FONT_8X8
__UG_FONT_DATA unsigned char font_8x8[256][8]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E},   // 0x01
{0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E},   // 0x02
{0x36,0x7F,0x7F,0x7F,0x3E,0x1C,0x08,0x00},   // 0x03
{0x08,0x1C,0x3E,0x7F,0x3E,0x1C,0x08,0x00},   // 0x04
{0x1C,0x3E,0x1C,0x7F,0x7F,0x6B,0x08,0x1C},   // 0x05
{0x08,0x08,0x1C,0x3E,0x7F,0x3E,0x08,0x1C},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0xF0,0xE0,0xF0,0xBE,0x33,0x33,0x33,0x1E},   // 0x0B
{0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0xFE,0xC6,0xFE,0xC6,0xC6,0xE6,0x67,0x03},   // 0x0E
{0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99},   // 0x0F
{0x01,0x07,0x1F,0x7F,0x1F,0x07,0x01,0x00},   // 0x10
{0x40,0x70,0x7C,0x7F,0x7C,0x70,0x40,0x00},   // 0x11
{0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18},   // 0x12
{0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00},   // 0x13
{0xFE,0xDB,0xDB,0xDE,0xD8,0xD8,0xD8,0x00},   // 0x14
{0x7E,0xC3,0x1E,0x33,0x33,0x1E,0x31,0x1F},   // 0x15
{0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00},   // 0x16
{0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF},   // 0x17
{0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00},   // 0x18
{0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00},   // 0x19
{0x00,0x18,0x30,0x7F,0x30,0x18,0x00,0x00},   // 0x1A
{0x00,0x0C,0x06,0x7F,0x06,0x0C,0x00,0x00},   // 0x1B
{0x00,0x00,0x03,0x03,0x03,0x7F,0x00,0x00},   // 0x1C
{0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00},   // 0x1D
{0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00},   // 0x1E
{0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x0C,0x1E,0x1E,0x0C,0x0C,0x00,0x0C,0x00},   // 0x21
{0x36,0x36,0x36,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x36,0x36,0x7F,0x36,0x7F,0x36,0x36,0x00},   // 0x23
{0x0C,0x3E,0x03,0x1E,0x30,0x1F,0x0C,0x00},   // 0x24
{0x00,0x63,0x33,0x18,0x0C,0x66,0x63,0x00},   // 0x25
{0x1C,0x36,0x1C,0x6E,0x3B,0x33,0x6E,0x00},   // 0x26
{0x06,0x06,0x03,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0x18,0x0C,0x06,0x06,0x06,0x0C,0x18,0x00},   // 0x28
{0x06,0x0C,0x18,0x18,0x18,0x0C,0x06,0x00},   // 0x29
{0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00},   // 0x2A
{0x00,0x0C,0x0C,0x3F,0x0C,0x0C,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x0E,0x0C,0x06},   // 0x2C
{0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00},   // 0x2E
{0x60,0x30,0x18,0x0C,0x06,0x03,0x01,0x00},   // 0x2F
{0x1E,0x33,0x3B,0x3F,0x37,0x33,0x1E,0x00},   // 0x30
{0x0C,0x0F,0x0C,0x0C,0x0C,0x0C,0x3F,0x00},   // 0x31
{0x1E,0x33,0x30,0x1C,0x06,0x33,0x3F,0x00},   // 0x32
{0x1E,0x33,0x30,0x1C,0x30,0x33,0x1E,0x00},   // 0x33
{0x38,0x3C,0x36,0x33,0x7F,0x30,0x30,0x00},   // 0x34
{0x3F,0x03,0x1F,0x30,0x30,0x33,0x1E,0x00},   // 0x35
{0x1C,0x06,0x03,0x1F,0x33,0x33,0x1E,0x00},   // 0x36
{0x3F,0x33,0x30,0x18,0x0C,0x06,0x06,0x00},   // 0x37
{0x1E,0x33,0x33,0x1E,0x33,0x33,0x1E,0x00},   // 0x38
{0x1E,0x33,0x33,0x3E,0x30,0x18,0x0E,0x00},   // 0x39
{0x00,0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x00},   // 0x3A
{0x00,0x00,0x0C,0x0C,0x00,0x0E,0x0C,0x06},   // 0x3B
{0x18,0x0C,0x06,0x03,0x06,0x0C,0x18,0x00},   // 0x3C
{0x00,0x00,0x3F,0x00,0x3F,0x00,0x00,0x00},   // 0x3D
{0x06,0x0C,0x18,0x30,0x18,0x0C,0x06,0x00},   // 0x3E
{0x1E,0x33,0x30,0x18,0x0C,0x00,0x0C,0x00},   // 0x3F
{0x3E,0x63,0x7B,0x7B,0x7B,0x03,0x1E,0x00},   // 0x40
{0x0C,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00},   // 0x41
{0x3F,0x66,0x66,0x3E,0x66,0x66,0x3F,0x00},   // 0x42
{0x3C,0x66,0x03,0x03,0x03,0x66,0x3C,0x00},   // 0x43
{0x3F,0x36,0x66,0x66,0x66,0x36,0x3F,0x00},   // 0x44
{0x7F,0x46,0x16,0x1E,0x16,0x46,0x7F,0x00},   // 0x45
{0x7F,0x46,0x16,0x1E,0x16,0x06,0x0F,0x00},   // 0x46
{0x3C,0x66,0x03,0x03,0x73,0x66,0x7C,0x00},   // 0x47
{0x33,0x33,0x33,0x3F,0x33,0x33,0x33,0x00},   // 0x48
{0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00},   // 0x49
{0x78,0x30,0x30,0x30,0x33,0x33,0x1E,0x00},   // 0x4A
{0x67,0x66,0x36,0x1E,0x36,0x66,0x67,0x00},   // 0x4B
{0x0F,0x06,0x06,0x06,0x46,0x66,0x7F,0x00},   // 0x4C
{0x63,0x77,0x7F,0x6B,0x63,0x63,0x63,0x00},   // 0x4D
{0x63,0x67,0x6F,0x7B,0x73,0x63,0x63,0x00},   // 0x4E
{0x1C,0x36,0x63,0x63,0x63,0x36,0x1C,0x00},   // 0x4F
{0x3F,0x66,0x66,0x3E,0x06,0x06,0x0F,0x00},   // 0x50
{0x1E,0x33,0x33,0x33,0x3B,0x1E,0x38,0x00},   // 0x51
{0x3F,0x66,0x66,0x3E,0x1E,0x36,0x67,0x00},   // 0x52
{0x1E,0x33,0x07,0x1C,0x38,0x33,0x1E,0x00},   // 0x53
{0x3F,0x2D,0x0C,0x0C,0x0C,0x0C,0x1E,0x00},   // 0x54
{0x33,0x33,0x33,0x33,0x33,0x33,0x3F,0x00},   // 0x55
{0x33,0x33,0x33,0x33,0x33,0x1E,0x0C,0x00},   // 0x56
{0x63,0x63,0x63,0x6B,0x7F,0x77,0x63,0x00},   // 0x57
{0x63,0x63,0x36,0x1C,0x36,0x63,0x63,0x00},   // 0x58
{0x33,0x33,0x33,0x1E,0x0C,0x0C,0x1E,0x00},   // 0x59
{0x7F,0x33,0x19,0x0C,0x46,0x63,0x7F,0x00},   // 0x5A
{0x1E,0x06,0x06,0x06,0x06,0x06,0x1E,0x00},   // 0x5B
{0x03,0x06,0x0C,0x18,0x30,0x60,0x40,0x00},   // 0x5C
{0x1E,0x18,0x18,0x18,0x18,0x18,0x1E,0x00},   // 0x5D
{0x08,0x1C,0x36,0x63,0x00,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},   // 0x5F
{0x0C,0x0C,0x18,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x1E,0x30,0x3E,0x33,0x6E,0x00},   // 0x61
{0x07,0x06,0x3E,0x66,0x66,0x66,0x3D,0x00},   // 0x62
{0x00,0x00,0x1E,0x33,0x03,0x33,0x1E,0x00},   // 0x63
{0x38,0x30,0x30,0x3E,0x33,0x33,0x6E,0x00},   // 0x64
{0x00,0x00,0x1E,0x33,0x3F,0x03,0x1E,0x00},   // 0x65
{0x1C,0x36,0x06,0x0F,0x06,0x06,0x0F,0x00},   // 0x66
{0x00,0x00,0x6E,0x33,0x33,0x3E,0x30,0x1F},   // 0x67
{0x07,0x06,0x36,0x6E,0x66,0x66,0x67,0x00},   // 0x68
{0x0C,0x00,0x0E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0x69
{0x18,0x00,0x1E,0x18,0x18,0x18,0x1B,0x0E},   // 0x6A
{0x07,0x06,0x66,0x36,0x1E,0x36,0x67,0x00},   // 0x6B
{0x0E,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00},   // 0x6C
{0x00,0x00,0x37,0x7F,0x6B,0x63,0x63,0x00},   // 0x6D
{0x00,0x00,0x1F,0x33,0x33,0x33,0x33,0x00},   // 0x6E
{0x00,0x00,0x1E,0x33,0x33,0x33,0x1E,0x00},   // 0x6F
{0x00,0x00,0x3B,0x66,0x66,0x3E,0x06,0x0F},   // 0x70
{0x00,0x00,0x6E,0x33,0x33,0x3E,0x30,0x78},   // 0x71
{0x00,0x00,0x1B,0x36,0x36,0x06,0x0F,0x00},   // 0x72
{0x00,0x00,0x3E,0x03,0x1E,0x30,0x1F,0x00},   // 0x73
{0x08,0x0C,0x3E,0x0C,0x0C,0x2C,0x18,0x00},   // 0x74
{0x00,0x00,0x33,0x33,0x33,0x33,0x6E,0x00},   // 0x75
{0x00,0x00,0x33,0x33,0x33,0x1E,0x0C,0x00},   // 0x76
{0x00,0x00,0x63,0x63,0x6B,0x7F,0x36,0x00},   // 0x77
{0x00,0x00,0x63,0x36,0x1C,0x36,0x63,0x00},   // 0x78
{0x00,0x00,0x33,0x33,0x33,0x3E,0x30,0x1F},   // 0x79
{0x00,0x00,0x3F,0x19,0x0C,0x26,0x3F,0x00},   // 0x7A
{0x38,0x0C,0x0C,0x07,0x0C,0x0C,0x38,0x00},   // 0x7B
{0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00},   // 0x7C
{0x07,0x0C,0x0C,0x38,0x0C,0x0C,0x07,0x00},   // 0x7D
{0x6E,0x3B,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7E
{0x08,0x1C,0x36,0x63,0x63,0x63,0x7F,0x00},   // 0x7F
{0x1E,0x33,0x03,0x03,0x33,0x1E,0x0C,0x06},   // 0x80
{0x00,0x33,0x00,0x33,0x33,0x33,0x7E,0x00},   // 0x81
{0x18,0x0C,0x1E,0x33,0x3F,0x03,0x1E,0x00},   // 0x82
{0x7E,0xC3,0x3C,0x60,0x7C,0x66,0xFC,0x00},   // 0x83
{0x33,0x00,0x1E,0x30,0x3E,0x33,0x7E,0x00},   // 0x84
{0x06,0x0C,0x1E,0x30,0x3E,0x33,0x7E,0x00},   // 0x85
{0x3C,0x66,0x3C,0x60,0x7C,0x66,0xFC,0x00},   // 0x86
{0x00,0x1E,0x33,0x03,0x33,0x1E,0x0C,0x06},   // 0x87
{0x7E,0xC3,0x3C,0x66,0x7E,0x06,0x3C,0x00},   // 0x88
{0x33,0x00,0x1E,0x33,0x3F,0x03,0x1E,0x00},   // 0x89
{0x06,0x0C,0x1E,0x33,0x3F,0x03,0x1E,0x00},   // 0x8A
{0x33,0x00,0x0E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0x8B
{0x3E,0x63,0x1C,0x18,0x18,0x18,0x3C,0x00},   // 0x8C
{0x06,0x0C,0x0E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0x8D
{0x33,0x0C,0x1E,0x33,0x33,0x3F,0x33,0x00},   // 0x8E
{0x0C,0x12,0x0C,0x1E,0x33,0x3F,0x33,0x00},   // 0x8F
{0x18,0x0C,0x3F,0x06,0x1E,0x06,0x3F,0x00},   // 0x90
{0x00,0x00,0xFE,0x30,0xFE,0x33,0xFE,0x00},   // 0x91
{0x7C,0x36,0x33,0x7F,0x33,0x33,0x73,0x00},   // 0x92
{0x1E,0x33,0x00,0x1E,0x33,0x33,0x1E,0x00},   // 0x93
{0x00,0x33,0x00,0x1E,0x33,0x33,0x1E,0x00},   // 0x94
{0x06,0x0C,0x00,0x1E,0x33,0x33,0x1E,0x00},   // 0x95
{0x1E,0x33,0x00,0x33,0x33,0x33,0x7E,0x00},   // 0x96
{0x06,0x0C,0x00,0x33,0x33,0x33,0x7E,0x00},   // 0x97
{0x00,0x33,0x00,0x33,0x33,0x3F,0x30,0x1F},   // 0x98
{0x63,0x00,0x3E,0x63,0x63,0x63,0x3E,0x00},   // 0x99
{0x33,0x00,0x33,0x33,0x33,0x33,0x1E,0x00},   // 0x9A
{0x00,0x00,0x3E,0x73,0x6B,0x67,0x3E,0x00},   // 0x9B
{0x1C,0x36,0x26,0x0F,0x06,0x67,0x3F,0x00},   // 0x9C
{0x5C,0x36,0x73,0x6B,0x67,0x36,0x1D,0x00},   // 0x9D
{0x00,0x00,0x33,0x1E,0x0C,0x1E,0x33,0x00},   // 0x9E
{0x70,0xD8,0x18,0x7E,0x18,0x18,0x1B,0x0E},   // 0x9F
{0x18,0x0C,0x1E,0x30,0x3E,0x33,0x7E,0x00},   // 0xA0
{0x18,0x0C,0x0E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0xA1
{0x30,0x18,0x00,0x1E,0x33,0x33,0x1E,0x00},   // 0xA2
{0x30,0x18,0x00,0x33,0x33,0x33,0x7E,0x00},   // 0xA3
{0x6E,0x3B,0x00,0x1F,0x33,0x33,0x33,0x00},   // 0xA4
{0x6E,0x3B,0x00,0x37,0x3F,0x3B,0x33,0x00},   // 0xA5
{0x3C,0x36,0x36,0x7C,0x00,0x7E,0x00,0x00},   // 0xA6
{0x3C,0x66,0x66,0x3C,0x00,0x7E,0x00,0x00},   // 0xA7
{0x0C,0x00,0x0C,0x06,0x03,0x33,0x1E,0x00},   // 0xA8
{0x3C,0x5A,0xA5,0x9D,0x95,0x66,0x3C,0x00},   // 0xA9
{0x00,0x00,0x00,0x3F,0x30,0x30,0x00,0x00},   // 0xAA
{0x67,0x36,0x1E,0x7E,0xC6,0x73,0x19,0xF8},   // 0xAB
{0x67,0x36,0x1E,0xCE,0xE6,0xB3,0xF9,0xC0},   // 0xAC
{0x00,0x18,0x00,0x18,0x18,0x3C,0x3C,0x18},   // 0xAD
{0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00},   // 0xAE
{0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00},   // 0xAF
{0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11},   // 0xB0
{0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55},   // 0xB1
{0xBB,0xEE,0xBB,0xEE,0xBB,0xEE,0xBB,0xEE},   // 0xB2
{0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},   // 0xB3
{0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18},   // 0xB4
{0x30,0x18,0x0C,0x1E,0x33,0x3F,0x33,0x00},   // 0xB5
{0x1E,0x21,0x0C,0x1E,0x33,0x3F,0x33,0x00},   // 0xB6
{0x03,0x06,0x0C,0x1E,0x33,0x3F,0x33,0x00},   // 0xB7
{0x3C,0x42,0x9D,0x85,0x9D,0x42,0x3C,0x00},   // 0xB8
{0x6C,0x6C,0x6F,0x60,0x6F,0x6C,0x6C,0x6C},   // 0xB9
{0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C},   // 0xBA
{0x00,0x00,0x7F,0x60,0x6F,0x6C,0x6C,0x6C},   // 0xBB
{0x6C,0x6C,0x6F,0x60,0x7F,0x00,0x00,0x00},   // 0xBC
{0x18,0x18,0x7E,0x03,0x03,0x7E,0x18,0x18},   // 0xBD
{0x33,0x33,0x1E,0x3F,0x0C,0x3F,0x0C,0x0C},   // 0xBE
{0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18},   // 0xBF
{0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00},   // 0xC0
{0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18},   // 0xC2
{0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18},   // 0xC3
{0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00},   // 0xC4
{0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18},   // 0xC5
{0x6E,0x3B,0x1E,0x30,0x3E,0x33,0x7E,0x00},   // 0xC6
{0x6E,0x3B,0x0C,0x1E,0x33,0x3F,0x33,0x00},   // 0xC7
{0x6C,0x6C,0xEC,0x0C,0xFC,0x00,0x00,0x00},   // 0xC8
{0x00,0x00,0xFC,0x0C,0xEC,0x6C,0x6C,0x6C},   // 0xC9
{0x6C,0x6C,0xEF,0x00,0xFF,0x00,0x00,0x00},   // 0xCA
{0x00,0x00,0xFF,0x00,0xEF,0x6C,0x6C,0x6C},   // 0xCB
{0x6C,0x6C,0xEC,0x0C,0xEC,0x6C,0x6C,0x6C},   // 0xCC
{0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00},   // 0xCD
{0x6C,0x6C,0xEF,0x00,0xEF,0x6C,0x6C,0x6C},   // 0xCE
{0x00,0x41,0x7F,0x36,0x36,0x7F,0x41,0x00},   // 0xCF
{0x1B,0x0E,0x1B,0x30,0x3C,0x36,0x1C,0x00},   // 0xD0
{0x3F,0x36,0x66,0x6F,0x66,0x36,0x3F,0x00},   // 0xD1
{0x1E,0x21,0x3F,0x06,0x1E,0x06,0x3F,0x00},   // 0xD2
{0x33,0x00,0x3F,0x06,0x1E,0x06,0x3F,0x00},   // 0xD3
{0x06,0x0C,0x3F,0x06,0x1E,0x06,0x3F,0x00},   // 0xD4
{0x00,0x03,0x02,0x07,0x00,0x00,0x00,0x00},   // 0xD5
{0x18,0x0C,0x1E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0xD6
{0x1E,0x21,0x1E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0xD7
{0x33,0x00,0x1E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0xD8
{0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18},   // 0xDA
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},   // 0xDB
{0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF},   // 0xDC
{0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00},   // 0xDD
{0x06,0x0C,0x1E,0x0C,0x0C,0x0C,0x1E,0x00},   // 0xDE
{0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00},   // 0xDF
{0x18,0x0C,0x3E,0x63,0x63,0x63,0x3E,0x00},   // 0xE0
{0x00,0x1E,0x33,0x1F,0x33,0x1F,0x03,0x03},   // 0xE1
{0x3E,0x41,0x3E,0x63,0x63,0x63,0x3E,0x00},   // 0xE2
{0x0C,0x18,0x3E,0x63,0x63,0x63,0x3E,0x00},   // 0xE3
{0x6E,0x3B,0x00,0x1E,0x33,0x33,0x1E,0x00},   // 0xE4
{0x6E,0x3B,0x3E,0x63,0x63,0x63,0x3E,0x00},   // 0xE5
{0x00,0x66,0x66,0x66,0x66,0x3E,0x06,0x03},   // 0xE6
{0x00,0x07,0x1E,0x36,0x1E,0x06,0x0F,0x00},   // 0xE7
{0x0F,0x06,0x3E,0x66,0x3E,0x06,0x0F,0x00},   // 0xE8
{0x18,0x0C,0x33,0x33,0x33,0x33,0x1E,0x00},   // 0xE9
{0x1E,0x21,0x00,0x33,0x33,0x33,0x1E,0x00},   // 0xEA
{0x06,0x0C,0x33,0x33,0x33,0x33,0x1E,0x00},   // 0xEB
{0x18,0x0C,0x00,0x33,0x33,0x3F,0x30,0x1F},   // 0xEC
{0x18,0x0C,0x33,0x33,0x1E,0x0C,0x1E,0x00},   // 0xED
{0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0x18,0x0C,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00},   // 0xF0
{0x0C,0x0C,0x3F,0x0C,0x0C,0x00,0x3F,0x00},   // 0xF1
{0x00,0x00,0x00,0x3F,0x00,0x3F,0x00,0x00},   // 0xF2
{0x67,0x34,0x1E,0xCC,0xE7,0xB3,0xF9,0xC0},   // 0xF3
{0xFE,0xDB,0xDB,0xDE,0xD8,0xD8,0xD8,0x00},   // 0xF4
{0x7E,0xC3,0x1E,0x33,0x33,0x1E,0x31,0x1F},   // 0xF5
{0x0C,0x0C,0x00,0x3F,0x00,0x0C,0x0C,0x00},   // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x06},   // 0xF7
{0x1C,0x36,0x36,0x1C,0x00,0x00,0x00,0x00},   // 0xF8
{0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00},   // 0xFA
{0x1C,0x1E,0x18,0x18,0x7E,0x00,0x00,0x00},   // 0xFB
{0x3E,0x70,0x3C,0x70,0x3E,0x00,0x00,0x00},   // 0xFC
{0x1E,0x30,0x1C,0x06,0x3E,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_8X12
__UG_FONT_DATA unsigned char font_8x12[256][12]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x00
{0x00,0x7E,0xC3,0x81,0xA5,0x81,0xBD,0x99,0xC3,0x7E,0x00,0x00}, // 0x01
{0x00,0x7E,0xFF,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E,0x00,0x00}, // 0x02
{0x00,0x00,0x22,0x77,0x7F,0x7F,0x7F,0x3E,0x1C,0x08,0x00,0x00}, // 0x03
{0x00,0x08,0x1C,0x3E,0x7F,0x7F,0x3E,0x1C,0x08,0x00,0x00,0x00}, // 0x04
{0x00,0x18,0x3C,0x3C,0xFF,0xE7,0xE7,0x18,0x18,0x7E,0x00,0x00}, // 0x05
{0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x7E,0x18,0x18,0x7E,0x00,0x00}, // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0A
{0x00,0x7C,0x70,0x5C,0x4E,0x1F,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x0B
{0x00,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x18,0x00,0x00}, // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0D
{0x00,0xFE,0xC6,0xFE,0xC6,0xC6,0xC6,0xE6,0xE7,0x67,0x03,0x00}, // 0x0E
{0x00,0x00,0x18,0xDB,0x7E,0xE7,0xE7,0x7E,0xDB,0x18,0x00,0x00}, // 0x0F
{0x00,0x01,0x03,0x07,0x1F,0x7F,0x1F,0x07,0x03,0x01,0x00,0x00}, // 0x10
{0x00,0x40,0x60,0x70,0x7C,0x7F,0x7C,0x70,0x60,0x40,0x00,0x00}, // 0x11
{0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00}, // 0x12
{0x00,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x66,0x66,0x00,0x00}, // 0x13
{0x00,0xFE,0xDB,0xDB,0xDB,0xDE,0xD8,0xD8,0xD8,0xD8,0x00,0x00}, // 0x14
{0x00,0x7E,0xC6,0x0C,0x3C,0x66,0x66,0x3C,0x30,0x63,0x7E,0x00}, // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00}, // 0x16
{0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x7E,0x00}, // 0x17
{0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00}, // 0x18
{0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00}, // 0x19
{0x00,0x00,0x00,0x18,0x30,0x7F,0x30,0x18,0x00,0x00,0x00,0x00}, // 0x1A
{0x00,0x00,0x00,0x0C,0x06,0x7F,0x06,0x0C,0x00,0x00,0x00,0x00}, // 0x1B
{0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x7F,0x00,0x00,0x00,0x00}, // 0x1C
{0x00,0x00,0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00,0x00,0x00}, // 0x1D
{0x00,0x00,0x08,0x08,0x1C,0x1C,0x3E,0x3E,0x7F,0x7F,0x00,0x00}, // 0x1E
{0x00,0x00,0x7F,0x7F,0x3E,0x3E,0x1C,0x1C,0x08,0x08,0x00,0x00}, // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x20
{0x00,0x0C,0x1E,0x1E,0x1E,0x0C,0x0C,0x00,0x0C,0x0C,0x00,0x00}, // 0x21
{0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x22
{0x00,0x36,0x36,0x7F,0x36,0x36,0x36,0x7F,0x36,0x36,0x00,0x00}, // 0x23
{0x0C,0x0C,0x3E,0x03,0x03,0x1E,0x30,0x30,0x1F,0x0C,0x0C,0x00}, // 0x24
{0x00,0x00,0x00,0x23,0x33,0x18,0x0C,0x06,0x33,0x31,0x00,0x00}, // 0x25
{0x00,0x0E,0x1B,0x1B,0x0E,0x5F,0x7B,0x33,0x3B,0x6E,0x00,0x00}, // 0x26
{0x00,0x0C,0x0C,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x27
{0x00,0x30,0x18,0x0C,0x06,0x06,0x06,0x0C,0x18,0x30,0x00,0x00}, // 0x28
{0x00,0x06,0x0C,0x18,0x30,0x30,0x30,0x18,0x0C,0x06,0x00,0x00}, // 0x29
{0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00}, // 0x2A
{0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00}, // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x06,0x00}, // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x00,0x00}, // 0x2E
{0x00,0x00,0x40,0x60,0x30,0x18,0x0C,0x06,0x03,0x01,0x00,0x00}, // 0x2F
{0x00,0x3E,0x63,0x73,0x7B,0x6B,0x6F,0x67,0x63,0x3E,0x00,0x00}, // 0x30
{0x00,0x08,0x0C,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x3F,0x00,0x00}, // 0x31
{0x00,0x1E,0x33,0x33,0x30,0x18,0x0C,0x06,0x33,0x3F,0x00,0x00}, // 0x32
{0x00,0x1E,0x33,0x30,0x30,0x1C,0x30,0x30,0x33,0x1E,0x00,0x00}, // 0x33
{0x00,0x30,0x38,0x3C,0x36,0x33,0x7F,0x30,0x30,0x78,0x00,0x00}, // 0x34
{0x00,0x3F,0x03,0x03,0x03,0x1F,0x30,0x30,0x33,0x1E,0x00,0x00}, // 0x35
{0x00,0x1C,0x06,0x03,0x03,0x1F,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x36
{0x00,0x7F,0x63,0x63,0x60,0x30,0x18,0x0C,0x0C,0x0C,0x00,0x00}, // 0x37
{0x00,0x1E,0x33,0x33,0x33,0x1E,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x38
{0x00,0x1E,0x33,0x33,0x33,0x3E,0x18,0x18,0x0C,0x0E,0x00,0x00}, // 0x39
{0x00,0x00,0x00,0x1C,0x1C,0x00,0x00,0x1C,0x1C,0x00,0x00,0x00}, // 0x3A
{0x00,0x00,0x00,0x1C,0x1C,0x00,0x00,0x1C,0x1C,0x18,0x0C,0x00}, // 0x3B
{0x00,0x30,0x18,0x0C,0x06,0x03,0x06,0x0C,0x18,0x30,0x00,0x00}, // 0x3C
{0x00,0x00,0x00,0x00,0x7E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00}, // 0x3D
{0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00}, // 0x3E
{0x00,0x1E,0x33,0x30,0x18,0x0C,0x0C,0x00,0x0C,0x0C,0x00,0x00}, // 0x3F
{0x00,0x3E,0x63,0x63,0x7B,0x7B,0x7B,0x03,0x03,0x3E,0x00,0x00}, // 0x40
{0x00,0x0C,0x1E,0x33,0x33,0x33,0x3F,0x33,0x33,0x33,0x00,0x00}, // 0x41
{0x00,0x3F,0x66,0x66,0x66,0x3E,0x66,0x66,0x66,0x3F,0x00,0x00}, // 0x42
{0x00,0x3C,0x66,0x63,0x03,0x03,0x03,0x63,0x66,0x3C,0x00,0x00}, // 0x43
{0x00,0x1F,0x36,0x66,0x66,0x66,0x66,0x66,0x36,0x1F,0x00,0x00}, // 0x44
{0x00,0x7F,0x46,0x06,0x26,0x3E,0x26,0x06,0x46,0x7F,0x00,0x00}, // 0x45
{0x00,0x7F,0x66,0x46,0x26,0x3E,0x26,0x06,0x06,0x0F,0x00,0x00}, // 0x46
{0x00,0x3C,0x66,0x63,0x03,0x03,0x73,0x63,0x66,0x7C,0x00,0x00}, // 0x47
{0x00,0x33,0x33,0x33,0x33,0x3F,0x33,0x33,0x33,0x33,0x00,0x00}, // 0x48
{0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0x49
{0x00,0x78,0x30,0x30,0x30,0x30,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x4A
{0x00,0x67,0x66,0x36,0x36,0x1E,0x36,0x36,0x66,0x67,0x00,0x00}, // 0x4B
{0x00,0x0F,0x06,0x06,0x06,0x06,0x46,0x66,0x66,0x7F,0x00,0x00}, // 0x4C
{0x00,0x63,0x77,0x7F,0x7F,0x6B,0x63,0x63,0x63,0x63,0x00,0x00}, // 0x4D
{0x00,0x63,0x63,0x67,0x6F,0x7F,0x7B,0x73,0x63,0x63,0x00,0x00}, // 0x4E
{0x00,0x1C,0x36,0x63,0x63,0x63,0x63,0x63,0x36,0x1C,0x00,0x00}, // 0x4F
{0x00,0x3F,0x66,0x66,0x66,0x3E,0x06,0x06,0x06,0x0F,0x00,0x00}, // 0x50
{0x00,0x1C,0x36,0x63,0x63,0x63,0x73,0x7B,0x3E,0x30,0x78,0x00}, // 0x51
{0x00,0x3F,0x66,0x66,0x66,0x3E,0x36,0x66,0x66,0x67,0x00,0x00}, // 0x52
{0x00,0x1E,0x33,0x33,0x03,0x0E,0x18,0x33,0x33,0x1E,0x00,0x00}, // 0x53
{0x00,0x3F,0x2D,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0x54
{0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x55
{0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x1E,0x0C,0x00,0x00}, // 0x56
{0x00,0x63,0x63,0x63,0x63,0x6B,0x6B,0x36,0x36,0x36,0x00,0x00}, // 0x57
{0x00,0x33,0x33,0x33,0x1E,0x0C,0x1E,0x33,0x33,0x33,0x00,0x00}, // 0x58
{0x00,0x33,0x33,0x33,0x33,0x1E,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0x59
{0x00,0x7F,0x73,0x19,0x18,0x0C,0x06,0x46,0x63,0x7F,0x00,0x00}, // 0x5A
{0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00}, // 0x5B
{0x00,0x00,0x01,0x03,0x06,0x0C,0x18,0x30,0x60,0x40,0x00,0x00}, // 0x5C
{0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00}, // 0x5D
{0x08,0x1C,0x36,0x63,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00}, // 0x5F
{0x0C,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x60
{0x00,0x00,0x00,0x00,0x1E,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0x61
{0x00,0x07,0x06,0x06,0x3E,0x66,0x66,0x66,0x66,0x3B,0x00,0x00}, // 0x62
{0x00,0x00,0x00,0x00,0x1E,0x33,0x03,0x03,0x33,0x1E,0x00,0x00}, // 0x63
{0x00,0x38,0x30,0x30,0x3E,0x33,0x33,0x33,0x33,0x6E,0x00,0x00}, // 0x64
{0x00,0x00,0x00,0x00,0x1E,0x33,0x3F,0x03,0x33,0x1E,0x00,0x00}, // 0x65
{0x00,0x1C,0x36,0x06,0x06,0x1F,0x06,0x06,0x06,0x0F,0x00,0x00}, // 0x66
{0x00,0x00,0x00,0x00,0x6E,0x33,0x33,0x33,0x3E,0x30,0x33,0x1E}, // 0x67
{0x00,0x07,0x06,0x06,0x36,0x6E,0x66,0x66,0x66,0x67,0x00,0x00}, // 0x68
{0x00,0x18,0x18,0x00,0x1E,0x18,0x18,0x18,0x18,0x7E,0x00,0x00}, // 0x69
{0x00,0x30,0x30,0x00,0x3C,0x30,0x30,0x30,0x30,0x33,0x33,0x1E}, // 0x6A
{0x00,0x07,0x06,0x06,0x66,0x36,0x1E,0x36,0x66,0x67,0x00,0x00}, // 0x6B
{0x00,0x1E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00}, // 0x6C
{0x00,0x00,0x00,0x00,0x3F,0x6B,0x6B,0x6B,0x6B,0x63,0x00,0x00}, // 0x6D
{0x00,0x00,0x00,0x00,0x1F,0x33,0x33,0x33,0x33,0x33,0x00,0x00}, // 0x6E
{0x00,0x00,0x00,0x00,0x1E,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x6F
{0x00,0x00,0x00,0x00,0x3B,0x66,0x66,0x66,0x66,0x3E,0x06,0x0F}, // 0x70
{0x00,0x00,0x00,0x00,0x6E,0x33,0x33,0x33,0x33,0x3E,0x30,0x78}, // 0x71
{0x00,0x00,0x00,0x00,0x37,0x76,0x6E,0x06,0x06,0x0F,0x00,0x00}, // 0x72
{0x00,0x00,0x00,0x00,0x1E,0x33,0x06,0x18,0x33,0x1E,0x00,0x00}, // 0x73
{0x00,0x00,0x04,0x06,0x3F,0x06,0x06,0x06,0x36,0x1C,0x00,0x00}, // 0x74
{0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x33,0x33,0x6E,0x00,0x00}, // 0x75
{0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x33,0x1E,0x0C,0x00,0x00}, // 0x76
{0x00,0x00,0x00,0x00,0x63,0x63,0x6B,0x6B,0x36,0x36,0x00,0x00}, // 0x77
{0x00,0x00,0x00,0x00,0x63,0x36,0x1C,0x1C,0x36,0x63,0x00,0x00}, // 0x78
{0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x30,0x18,0x0F}, // 0x79
{0x00,0x00,0x00,0x00,0x3F,0x31,0x18,0x06,0x23,0x3F,0x00,0x00}, // 0x7A
{0x00,0x38,0x0C,0x0C,0x06,0x03,0x06,0x0C,0x0C,0x38,0x00,0x00}, // 0x7B
{0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00,0x00}, // 0x7C
{0x00,0x07,0x0C,0x0C,0x18,0x30,0x18,0x0C,0x0C,0x07,0x00,0x00}, // 0x7D
{0x00,0xCE,0x5B,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7E
{0x00,0x00,0x00,0x08,0x1C,0x36,0x63,0x63,0x7F,0x00,0x00,0x00}, // 0x7F
{0x00,0x1E,0x33,0x33,0x03,0x03,0x03,0x33,0x33,0x1E,0x0C,0x06}, // 0x80
{0x00,0x33,0x33,0x00,0x33,0x33,0x33,0x33,0x33,0x6E,0x00,0x00}, // 0x81
{0x30,0x18,0x0C,0x00,0x1E,0x33,0x3F,0x03,0x33,0x1E,0x00,0x00}, // 0x82
{0x0C,0x1E,0x33,0x00,0x1E,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0x83
{0x00,0x33,0x33,0x00,0x1E,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0x84
{0x03,0x06,0x0C,0x00,0x1E,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0x85
{0x1C,0x36,0x36,0x1C,0x1F,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0x86
{0x00,0x00,0x00,0x00,0x1E,0x33,0x03,0x03,0x33,0x1E,0x0C,0x06}, // 0x87
{0x0C,0x1E,0x33,0x00,0x1E,0x33,0x3F,0x03,0x03,0x3E,0x00,0x00}, // 0x88
{0x00,0x33,0x33,0x00,0x1E,0x33,0x3F,0x03,0x03,0x3E,0x00,0x00}, // 0x89
{0x03,0x06,0x0C,0x00,0x1E,0x33,0x3F,0x03,0x03,0x3E,0x00,0x00}, // 0x8A
{0x00,0x36,0x36,0x00,0x1E,0x18,0x18,0x18,0x18,0x7E,0x00,0x00}, // 0x8B
{0x08,0x1C,0x36,0x00,0x1E,0x18,0x18,0x18,0x18,0x7E,0x00,0x00}, // 0x8C
{0x06,0x0C,0x18,0x00,0x1E,0x18,0x18,0x18,0x18,0x7E,0x00,0x00}, // 0x8D
{0x00,0x33,0x00,0x0C,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00,0x00}, // 0x8E
{0x1E,0x33,0x33,0x1E,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00,0x00}, // 0x8F
{0x30,0x18,0x00,0x3F,0x23,0x03,0x1F,0x03,0x23,0x3F,0x00,0x00}, // 0x90
{0x00,0x00,0x00,0x00,0x7F,0xD8,0xFE,0x1B,0x1B,0xF7,0x00,0x00}, // 0x91
{0x00,0x7C,0x1E,0x1B,0x1B,0x7F,0x1B,0x1B,0x1B,0x7B,0x00,0x00}, // 0x92
{0x0C,0x1E,0x33,0x00,0x1E,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x93
{0x00,0x33,0x33,0x00,0x1E,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x94
{0x03,0x06,0x0C,0x00,0x1E,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x95
{0x0C,0x1E,0x33,0x00,0x33,0x33,0x33,0x33,0x33,0x6E,0x00,0x00}, // 0x96
{0x03,0x06,0x0C,0x00,0x33,0x33,0x33,0x33,0x33,0x6E,0x00,0x00}, // 0x97
{0x00,0x66,0x66,0x00,0x66,0x66,0x66,0x66,0x3C,0x30,0x18,0x0F}, // 0x98
{0x00,0x33,0x00,0x1E,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x99
{0x33,0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0x9A
{0x00,0x00,0x00,0x00,0x1E,0x33,0x3B,0x37,0x33,0x1E,0x00,0x00}, // 0x9B
{0x3C,0x66,0x06,0x06,0x06,0x3F,0x06,0x06,0x03,0x7F,0x00,0x00}, // 0x9C
{0x00,0x5C,0x36,0x73,0x6B,0x6B,0x6B,0x67,0x36,0x1D,0x00,0x00}, // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x63,0x36,0x1C,0x36,0x63,0x00,0x00}, // 0x9E
{0x70,0xD8,0x18,0x18,0x7E,0x18,0x18,0x18,0x1B,0x0E,0x00,0x00}, // 0x9F
{0x30,0x18,0x0C,0x00,0x1E,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0xA0
{0x30,0x18,0x0C,0x00,0x1E,0x18,0x18,0x18,0x18,0x7E,0x00,0x00}, // 0xA1
{0x30,0x18,0x0C,0x00,0x1E,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xA2
{0x30,0x18,0x0C,0x00,0x33,0x33,0x33,0x33,0x33,0x6E,0x00,0x00}, // 0xA3
{0x00,0x6E,0x3B,0x00,0x1F,0x33,0x33,0x33,0x33,0x33,0x00,0x00}, // 0xA4
{0x6E,0x3B,0x00,0x63,0x67,0x6F,0x7B,0x73,0x63,0x63,0x00,0x00}, // 0xA5
{0x00,0x1E,0x33,0x33,0x7E,0x00,0x7F,0x00,0x00,0x00,0x00,0x00}, // 0xA6
{0x00,0x1E,0x33,0x33,0x1E,0x00,0x7F,0x00,0x00,0x00,0x00,0x00}, // 0xA7
{0x00,0x0C,0x0C,0x00,0x0C,0x06,0x03,0x03,0x33,0x1E,0x00,0x00}, // 0xA8
{0x00,0x1C,0x22,0x5D,0x55,0x5D,0x4D,0x55,0x22,0x1C,0x00,0x00}, // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x3F,0x30,0x30,0x30,0x00,0x00,0x00}, // 0xAA
{0x00,0x46,0x67,0x36,0x1E,0x0C,0x76,0xC3,0x61,0x30,0xF8,0x00}, // 0xAB
{0x00,0xC6,0x67,0x36,0x1E,0xEC,0xF6,0xDB,0xCD,0xFC,0xC0,0x00}, // 0xAC
{0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x1E,0x1E,0x1E,0x0C,0x00,0x00}, // 0xAD
{0x00,0x00,0x00,0x00,0xCC,0x66,0x33,0x33,0x66,0xCC,0x00,0x00}, // 0xAE
{0x00,0x00,0x00,0x00,0x33,0x66,0xCC,0xCC,0x66,0x33,0x00,0x00}, // 0xAF
{0x24,0x49,0x92,0x24,0x49,0x92,0x24,0x49,0x92,0x24,0x49,0x92}, // 0xB0
{0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55}, // 0xB1
{0xB6,0xDB,0x6D,0xB6,0xDB,0x6D,0xB6,0xDB,0x6D,0xB6,0xDB,0x6D}, // 0xB2
{0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xB3
{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xB4
{0x30,0x18,0x00,0x0C,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00,0x00}, // 0xB5
{0x1E,0x33,0x00,0x0C,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00,0x00}, // 0xB6
{0x06,0x0C,0x00,0x0C,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00,0x00}, // 0xB7
{0x00,0x1C,0x22,0x5D,0x45,0x45,0x45,0x5D,0x22,0x1C,0x00,0x00}, // 0xB8
{0x66,0x66,0x66,0x66,0x67,0x60,0x60,0x67,0x66,0x66,0x66,0x66}, // 0xB9
{0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66}, // 0xBA
{0x00,0x00,0x00,0x00,0x7F,0x60,0x60,0x67,0x66,0x66,0x66,0x66}, // 0xBB
{0x66,0x66,0x66,0x66,0x67,0x60,0x60,0x7F,0x00,0x00,0x00,0x00}, // 0xBC
{0x00,0x0C,0x0C,0x1E,0x33,0x03,0x03,0x33,0x1E,0x0C,0x0C,0x00}, // 0xBD
{0x33,0x33,0x33,0x33,0x1E,0x3F,0x0C,0x3F,0x0C,0x0C,0x00,0x00}, // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xBF
{0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC0
{0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC1
{0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xC2
{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xC3
{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC4
{0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xC5
{0x00,0x6E,0x3B,0x00,0x1E,0x30,0x3E,0x33,0x33,0x6E,0x00,0x00}, // 0xC6
{0x6E,0x3B,0x00,0x0C,0x1E,0x33,0x33,0x3F,0x33,0x33,0x00,0x00}, // 0xC7
{0x66,0x66,0x66,0x66,0xE6,0x06,0x06,0xFE,0x00,0x00,0x00,0x00}, // 0xC8
{0x00,0x00,0x00,0x00,0xFE,0x06,0x06,0xE6,0x66,0x66,0x66,0x66}, // 0xC9
{0x66,0x66,0x66,0x66,0xE7,0x00,0x00,0xFF,0x00,0x00,0x00,0x00}, // 0xCA
{0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xE7,0x66,0x66,0x66,0x66}, // 0xCB
{0x66,0x66,0x66,0x66,0xE6,0x06,0x06,0xE6,0x66,0x66,0x66,0x66}, // 0xCC
{0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0x00}, // 0xCD
{0x66,0x66,0x66,0x66,0xE7,0x00,0x00,0xE7,0x66,0x66,0x66,0x66}, // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x63,0x3E,0x36,0x3E,0x63,0x00,0x00}, // 0xCF
{0x33,0x0C,0x1B,0x30,0x60,0x7E,0x63,0x63,0x63,0x3E,0x00,0x00}, // 0xD0
{0x00,0x1F,0x36,0x66,0x66,0x6F,0x66,0x66,0x36,0x1F,0x00,0x00}, // 0xD1
{0x1E,0x33,0x00,0x3F,0x23,0x03,0x1F,0x03,0x23,0x3F,0x00,0x00}, // 0xD2
{0x00,0x33,0x00,0x3F,0x23,0x03,0x1F,0x03,0x23,0x3F,0x00,0x00}, // 0xD3
{0x06,0x0C,0x00,0x3F,0x23,0x03,0x1F,0x03,0x23,0x3F,0x00,0x00}, // 0xD4
{0x00,0x0F,0x0C,0x0C,0x0C,0x3F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD5
{0x18,0x0C,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0xD6
{0x1E,0x33,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0xD7
{0x00,0x33,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0xD8
{0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD9
{0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18}, // 0xDA
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 0xDC
{0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00,0x00}, // 0xDD
{0x06,0x0C,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x1E,0x00,0x00}, // 0xDE
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDF
{0x18,0x0C,0x00,0x1E,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xE0
{0x00,0x1E,0x33,0x33,0x1B,0x33,0x33,0x33,0x1F,0x03,0x06,0x00}, // 0xE1
{0x1E,0x33,0x00,0x1E,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xE2
{0x06,0x0C,0x00,0x1E,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xE3
{0x00,0x6E,0x3B,0x00,0x1E,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xE4
{0x6E,0x3B,0x00,0x1E,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xE5
{0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0xDE,0x06,0x03}, // 0xE6
{0x00,0x00,0x07,0x06,0x3E,0x66,0x66,0x3E,0x06,0x0F,0x00,0x00}, // 0xE7
{0x00,0x0F,0x06,0x3E,0x66,0x66,0x66,0x3E,0x06,0x0F,0x00,0x00}, // 0xE8
{0x18,0x0C,0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xE9
{0x1E,0x33,0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xEA
{0x06,0x0C,0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x1E,0x00,0x00}, // 0xEB
{0x60,0x30,0x18,0x00,0x66,0x66,0x66,0x66,0x3C,0x30,0x18,0x0F}, // 0xEC
{0x18,0x0C,0x00,0x33,0x33,0x33,0x1E,0x0C,0x0C,0x1E,0x00,0x00}, // 0xED
{0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEE
{0x30,0x18,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF0
{0x00,0x00,0x0C,0x0C,0x3F,0x0C,0x0C,0x00,0x3F,0x00,0x00,0x00}, // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00}, // 0xF2
{0x07,0xCC,0x66,0x3C,0x1F,0xEC,0xF6,0xDB,0xCD,0xFC,0xC0,0x00}, // 0xF3
{0x00,0xFE,0xDB,0xDB,0xDB,0xDE,0xD8,0xD8,0xD8,0xD8,0x00,0x00}, // 0xF4
{0x00,0x7E,0xC6,0x0C,0x3C,0x66,0x66,0x3C,0x30,0x63,0x7E,0x00}, // 0xF5
{0x00,0x00,0x0C,0x0C,0x00,0x3F,0x00,0x0C,0x0C,0x00,0x00,0x00}, // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0E}, // 0xF7
{0x00,0x3C,0x66,0x66,0x66,0x3C,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF8
{0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFA
{0x00,0x0C,0x0E,0x0C,0x0C,0x1E,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFB
{0x00,0x1E,0x30,0x1C,0x30,0x1E,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFC
{0x00,0x1E,0x30,0x18,0x0C,0x3E,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFD
{0x00,0x00,0x00,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x00,0x00,0x00}, // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 0xFF
};
#endif


#ifdef USE_FONT_8X12_CYRILLIC
__UG_FONT_DATA unsigned char font_8x12[256][12]={
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x00
{0x00, 0x7E, 0xC3, 0x81, 0xA5, 0x81, 0xBD, 0x99, 0xC3, 0x7E, 0x00, 0x00}, // 0x01
{0x00, 0x7E, 0xFF, 0xFF, 0xDB, 0xFF, 0xC3, 0xE7, 0xFF, 0x7E, 0x00, 0x00}, // 0x02
{0x00, 0x00, 0x22, 0x77, 0x7F, 0x7F, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 0x00}, // 0x03
{0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 0x00, 0x00}, // 0x04
{0x00, 0x18, 0x3C, 0x3C, 0xFF, 0xE7, 0xE7, 0x18, 0x18, 0x7E, 0x00, 0x00}, // 0x05
{0x00, 0x18, 0x3C, 0x7E, 0xFF, 0xFF, 0x7E, 0x18, 0x18, 0x7E, 0x00, 0x00}, // 0x06
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x07
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x08
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x09
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x0A
{0x00, 0x7C, 0x70, 0x5C, 0x4E, 0x1F, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x0B
{0x00, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00}, // 0x0C
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x0D
{0x00, 0xFE, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0xE6, 0xE7, 0x67, 0x03, 0x00}, // 0x0E
{0x00, 0x00, 0x18, 0xDB, 0x7E, 0xE7, 0xE7, 0x7E, 0xDB, 0x18, 0x00, 0x00}, // 0x0F
{0x00, 0x01, 0x03, 0x07, 0x1F, 0x7F, 0x1F, 0x07, 0x03, 0x01, 0x00, 0x00}, // 0x10
{0x00, 0x40, 0x60, 0x70, 0x7C, 0x7F, 0x7C, 0x70, 0x60, 0x40, 0x00, 0x00}, // 0x11
{0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x00, 0x00}, // 0x12
{0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00}, // 0x13
{0x00, 0xFE, 0xDB, 0xDB, 0xDB, 0xDE, 0xD8, 0xD8, 0xD8, 0xD8, 0x00, 0x00}, // 0x14
{0x00, 0x7E, 0xC6, 0x0C, 0x3C, 0x66, 0x66, 0x3C, 0x30, 0x63, 0x7E, 0x00}, // 0x15
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00}, // 0x16
{0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x7E, 0x00}, // 0x17
{0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00}, // 0x18
{0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x00, 0x00}, // 0x19
{0x00, 0x00, 0x00, 0x18, 0x30, 0x7F, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00}, // 0x1A
{0x00, 0x00, 0x00, 0x0C, 0x06, 0x7F, 0x06, 0x0C, 0x00, 0x00, 0x00, 0x00}, // 0x1B
{0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x7F, 0x00, 0x00, 0x00, 0x00}, // 0x1C
{0x00, 0x00, 0x00, 0x24, 0x66, 0xFF, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00}, // 0x1D
{0x00, 0x00, 0x08, 0x08, 0x1C, 0x1C, 0x3E, 0x3E, 0x7F, 0x7F, 0x00, 0x00}, // 0x1E
{0x00, 0x00, 0x7F, 0x7F, 0x3E, 0x3E, 0x1C, 0x1C, 0x08, 0x08, 0x00, 0x00}, // 0x1F
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x20
{0x00, 0x0C, 0x1E, 0x1E, 0x1E, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x00, 0x00}, // 0x21
{0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x22
{0x00, 0x36, 0x36, 0x7F, 0x36, 0x36, 0x36, 0x7F, 0x36, 0x36, 0x00, 0x00}, // 0x23
{0x0C, 0x0C, 0x3E, 0x03, 0x03, 0x1E, 0x30, 0x30, 0x1F, 0x0C, 0x0C, 0x00}, // 0x24
{0x00, 0x00, 0x00, 0x23, 0x33, 0x18, 0x0C, 0x06, 0x33, 0x31, 0x00, 0x00}, // 0x25
{0x00, 0x0E, 0x1B, 0x1B, 0x0E, 0x5F, 0x7B, 0x33, 0x3B, 0x6E, 0x00, 0x00}, // 0x26
{0x00, 0x0C, 0x0C, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x27
{0x00, 0x30, 0x18, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x18, 0x30, 0x00, 0x00}, // 0x28
{0x00, 0x06, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00}, // 0x29
{0x00, 0x00, 0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x00}, // 0x2A
{0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00}, // 0x2B
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x06, 0x00}, // 0x2C
{0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x2D
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00}, // 0x2E
{0x00, 0x00, 0x40, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00, 0x00}, // 0x2F
{0x00, 0x3E, 0x63, 0x73, 0x7B, 0x6B, 0x6F, 0x67, 0x63, 0x3E, 0x00, 0x00}, // 0x30
{0x00, 0x08, 0x0C, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x00, 0x00}, // 0x31
{0x00, 0x1E, 0x33, 0x33, 0x30, 0x18, 0x0C, 0x06, 0x33, 0x3F, 0x00, 0x00}, // 0x32
{0x00, 0x1E, 0x33, 0x30, 0x30, 0x1C, 0x30, 0x30, 0x33, 0x1E, 0x00, 0x00}, // 0x33
{0x00, 0x30, 0x38, 0x3C, 0x36, 0x33, 0x7F, 0x30, 0x30, 0x78, 0x00, 0x00}, // 0x34
{0x00, 0x3F, 0x03, 0x03, 0x03, 0x1F, 0x30, 0x30, 0x33, 0x1E, 0x00, 0x00}, // 0x35
{0x00, 0x1C, 0x06, 0x03, 0x03, 0x1F, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x36
{0x00, 0x7F, 0x63, 0x63, 0x60, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x00, 0x00}, // 0x37
{0x00, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x38
{0x00, 0x1E, 0x33, 0x33, 0x33, 0x3E, 0x18, 0x18, 0x0C, 0x0E, 0x00, 0x00}, // 0x39
{0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x00}, // 0x3A
{0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x1C, 0x1C, 0x18, 0x0C, 0x00}, // 0x3B
{0x00, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x00, 0x00}, // 0x3C
{0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x3D
{0x00, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00}, // 0x3E
{0x00, 0x1E, 0x33, 0x30, 0x18, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x00, 0x00}, // 0x3F
{0x00, 0x3E, 0x63, 0x63, 0x7B, 0x4B, 0x7B, 0x03, 0x03, 0x3E, 0x00, 0x00}, // 0x40
{0x00, 0x0C, 0x1E, 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0x41
{0x00, 0x3F, 0x66, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x66, 0x3F, 0x00, 0x00}, // 0x42
{0x00, 0x3C, 0x66, 0x63, 0x03, 0x03, 0x03, 0x63, 0x66, 0x3C, 0x00, 0x00}, // 0x43
{0x00, 0x1F, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36, 0x1F, 0x00, 0x00}, // 0x44
{0x00, 0x7F, 0x46, 0x06, 0x26, 0x3E, 0x26, 0x06, 0x46, 0x7F, 0x00, 0x00}, // 0x45
{0x00, 0x7F, 0x66, 0x46, 0x26, 0x3E, 0x26, 0x06, 0x06, 0x0F, 0x00, 0x00}, // 0x46
{0x00, 0x3C, 0x66, 0x63, 0x03, 0x03, 0x73, 0x63, 0x66, 0x7C, 0x00, 0x00}, // 0x47
{0x00, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0x48
{0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00, 0x00}, // 0x49
{0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x4A
{0x00, 0x67, 0x66, 0x36, 0x36, 0x1E, 0x36, 0x36, 0x66, 0x67, 0x00, 0x00}, // 0x4B
{0x00, 0x0F, 0x06, 0x06, 0x06, 0x06, 0x46, 0x66, 0x66, 0x7F, 0x00, 0x00}, // 0x4C
{0x00, 0x63, 0x77, 0x7F, 0x7F, 0x6B, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00}, // 0x4D
{0x00, 0x63, 0x63, 0x67, 0x6F, 0x7F, 0x7B, 0x73, 0x63, 0x63, 0x00, 0x00}, // 0x4E
{0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00, 0x00}, // 0x4F
{0x00, 0x3F, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x06, 0x0F, 0x00, 0x00}, // 0x50
{0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x73, 0x7B, 0x3E, 0x30, 0x78, 0x00}, // 0x51
{0x00, 0x3F, 0x66, 0x66, 0x66, 0x3E, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00}, // 0x52
{0x00, 0x1E, 0x33, 0x33, 0x03, 0x0E, 0x18, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x53
{0x00, 0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00, 0x00}, // 0x54
{0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x55
{0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00, 0x00}, // 0x56
{0x00, 0x63, 0x63, 0x63, 0x63, 0x6B, 0x6B, 0x36, 0x36, 0x36, 0x00, 0x00}, // 0x57
{0x00, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x1E, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0x58
{0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00, 0x00}, // 0x59
{0x00, 0x7F, 0x73, 0x19, 0x18, 0x0C, 0x06, 0x46, 0x63, 0x7F, 0x00, 0x00}, // 0x5A
{0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00, 0x00}, // 0x5B
{0x00, 0x00, 0x01, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x40, 0x00, 0x00}, // 0x5C
{0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x00}, // 0x5D
{0x08, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x5E
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00}, // 0x5F
{0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x60
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x33, 0x6E, 0x00, 0x00}, // 0x61
{0x00, 0x07, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x66, 0x66, 0x3B, 0x00, 0x00}, // 0x62
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x03, 0x03, 0x33, 0x1E, 0x00, 0x00}, // 0x63
{0x00, 0x38, 0x30, 0x30, 0x3E, 0x33, 0x33, 0x33, 0x33, 0x6E, 0x00, 0x00}, // 0x64
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x33, 0x1E, 0x00, 0x00}, // 0x65
{0x00, 0x1C, 0x36, 0x06, 0x06, 0x1F, 0x06, 0x06, 0x06, 0x0F, 0x00, 0x00}, // 0x66
{0x00, 0x00, 0x00, 0x00, 0x6E, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x33, 0x1E}, // 0x67
{0x00, 0x07, 0x06, 0x06, 0x36, 0x6E, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00}, // 0x68
{0x00, 0x18, 0x18, 0x00, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00}, // 0x69
{0x00, 0x30, 0x30, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E}, // 0x6A
{0x00, 0x07, 0x06, 0x06, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x67, 0x00, 0x00}, // 0x6B
{0x00, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00}, // 0x6C
{0x00, 0x00, 0x00, 0x00, 0x3F, 0x6B, 0x6B, 0x6B, 0x6B, 0x63, 0x00, 0x00}, // 0x6D
{0x00, 0x00, 0x00, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0x6E
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0x6F
{0x00, 0x00, 0x00, 0x00, 0x3B, 0x66, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x0F}, // 0x70
{0x00, 0x00, 0x00, 0x00, 0x6E, 0x33, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x78}, // 0x71
{0x00, 0x00, 0x00, 0x00, 0x37, 0x76, 0x6E, 0x06, 0x06, 0x0F, 0x00, 0x00}, // 0x72
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x06, 0x18, 0x33, 0x1E, 0x00, 0x00}, // 0x73
{0x00, 0x00, 0x04, 0x06, 0x3F, 0x06, 0x06, 0x06, 0x36, 0x1C, 0x00, 0x00}, // 0x74
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6E, 0x00, 0x00}, // 0x75
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00, 0x00}, // 0x76
{0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6B, 0x6B, 0x36, 0x36, 0x00, 0x00}, // 0x77
{0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00, 0x00}, // 0x78
{0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x30, 0x18, 0x0F}, // 0x79
{0x00, 0x00, 0x00, 0x00, 0x3F, 0x31, 0x18, 0x06, 0x23, 0x3F, 0x00, 0x00}, // 0x7A
{0x00, 0x38, 0x0C, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x0C, 0x38, 0x00, 0x00}, // 0x7B
{0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18}, // 0x7C
{0x00, 0x07, 0x0C, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x0C, 0x07, 0x00, 0x00}, // 0x7D
{0x00, 0xCE, 0x5B, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x7E
{0x00, 0x00, 0x00, 0x08, 0x1C, 0x36, 0x63, 0x63, 0x7F, 0x00, 0x00, 0x00}, // 0x7F
{0x00, 0x1F, 0x06, 0x06, 0x36, 0x7E, 0x6E, 0x66, 0x66, 0x36, 0x00, 0x00}, // 0x80
{0x18, 0x00, 0x7F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00}, // 0x81
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x06, 0x00}, // 0x82
{0x00, 0x18, 0x0C, 0x00, 0x3F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00}, // 0x83
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x33, 0x00}, // 0x84
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x2A, 0x00, 0x00}, // 0x85
{0x00, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00}, // 0x86
{0x00, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x00, 0x00}, // 0x87
{0x00, 0x3C, 0x66, 0x06, 0x3F, 0x06, 0x3F, 0x06, 0x66, 0x3C, 0x00, 0x00}, // 0x88
{0x00, 0x12, 0x15, 0x12, 0x08, 0x04, 0x02, 0x49, 0xB5, 0x49, 0x00, 0x00}, // 0x89
{0x00, 0x1C, 0x14, 0x14, 0x14, 0x32, 0x52, 0x52, 0x52, 0x33, 0x00, 0x00}, // 0x8A
{0x00, 0x00, 0x00, 0x20, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x20, 0x00, 0x00}, // 0x8B
{0x00, 0x1B, 0x1B, 0x1B, 0x1B, 0x3F, 0x5B, 0x5B, 0x5B, 0x3B, 0x00, 0x00}, // 0x8C
{0x08, 0x6B, 0x63, 0x33, 0x13, 0x1F, 0x33, 0x33, 0x63, 0x63, 0x00, 0x00}, // 0x8D
{0x00, 0x00, 0x1F, 0x04, 0x04, 0x1C, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00}, // 0x8E
{0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x0C, 0x0C}, // 0x8F
{0x02, 0x0F, 0x02, 0x02, 0x1A, 0x26, 0x22, 0x22, 0x22, 0x22, 0x10, 0x08}, // 0x90
{0x00, 0x18, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x91
{0x00, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x92
{0x00, 0x24, 0x12, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x93
{0x00, 0x36, 0x36, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x94
{0x00, 0x00, 0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00}, // 0x95
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x96
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x97
{0x00, 0x66, 0x66, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x30, 0x18, 0x0F}, // 0x98
{0x00, 0x2F, 0x3A, 0x2A, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x99
{0x00, 0x1C, 0x14, 0x14, 0x12, 0x32, 0x52, 0x52, 0x52, 0x33, 0x00, 0x00}, // 0x9A
{0x00, 0x00, 0x00, 0x04, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x04, 0x00, 0x00}, // 0x9B
{0x00, 0x09, 0x09, 0x09, 0x09, 0x3F, 0x49, 0x49, 0x49, 0x39, 0x00, 0x00}, // 0x9C
{0x00, 0x18, 0x0C, 0x00, 0x33, 0x1B, 0x0F, 0x1B, 0x33, 0x33, 0x00, 0x00}, // 0x9D
{0x00, 0x02, 0x0F, 0x02, 0x02, 0x1A, 0x26, 0x22, 0x22, 0x22, 0x00, 0x00}, // 0x9E
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x0C, 0x0C}, // 0x9F
{0x30, 0x18, 0x0C, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x33, 0x6E, 0x00, 0x00}, // 0xA0
{0x30, 0x18, 0x0C, 0x00, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00}, // 0xA1
{0x30, 0x18, 0x0C, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0xA2
{0x30, 0x18, 0x0C, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6E, 0x00, 0x00}, // 0xA3
{0x00, 0x6E, 0x3B, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0xA4
{0x6E, 0x3B, 0x00, 0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00, 0x00}, // 0xA5
{0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00}, // 0xA6
{0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xA7
{0x36, 0x00, 0x7F, 0x03, 0x03, 0x1F, 0x03, 0x03, 0x03, 0x7F, 0x00, 0x00}, // 0xA8
{0x00, 0x1C, 0x22, 0x5D, 0x55, 0x5D, 0x4D, 0x55, 0x22, 0x1C, 0x00, 0x00}, // 0xA9
{0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00}, // 0xAA
{0x00, 0x00, 0x00, 0x00, 0xCC, 0x66, 0x33, 0x33, 0x66, 0xCC, 0x00, 0x00}, // 0xAB
{0x00, 0xC6, 0x67, 0x36, 0x1E, 0xEC, 0xF6, 0xDB, 0xCD, 0xFC, 0xC0, 0x00}, // 0xAC
{0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x1E, 0x1E, 0x1E, 0x0C, 0x00, 0x00}, // 0xAD
{0x00, 0x00, 0x00, 0x00, 0xCC, 0x66, 0x33, 0x33, 0x66, 0xCC, 0x00, 0x00}, // 0xAE
{0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0xCC, 0xCC, 0x66, 0x33, 0x00, 0x00}, // 0xAF
{0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92}, // 0xB0
{0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55}, // 0xB1
{0xB6, 0xDB, 0x6D, 0xB6, 0xDB, 0x6D, 0xB6, 0xDB, 0x6D, 0xB6, 0xDB, 0x6D}, // 0xB2
{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18}, // 0xB3
{0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18}, // 0xB4
{0x30, 0x18, 0x00, 0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00, 0x00}, // 0xB5
{0x1E, 0x33, 0x00, 0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00, 0x00}, // 0xB6
{0x06, 0x0C, 0x00, 0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00, 0x00}, // 0xB7
{0x00, 0x36, 0x36, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x33, 0x1E, 0x00, 0x00}, // 0xB8
{0x66, 0x66, 0x66, 0x66, 0x67, 0x60, 0x60, 0x67, 0x66, 0x66, 0x66, 0x66}, // 0xB9
{0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66}, // 0xBA
{0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0xCC, 0xCC, 0x66, 0x33, 0x00, 0x00}, // 0xBB
{0x66, 0x66, 0x66, 0x66, 0x67, 0x60, 0x60, 0x7F, 0x00, 0x00, 0x00, 0x00}, // 0xBC
{0x00, 0x0C, 0x0C, 0x1E, 0x33, 0x03, 0x03, 0x33, 0x1E, 0x0C, 0x0C, 0x00}, // 0xBD
{0x33, 0x33, 0x33, 0x33, 0x1E, 0x3F, 0x0C, 0x3F, 0x0C, 0x0C, 0x00, 0x00}, // 0xBE
{0x00, 0x00, 0x36, 0x36, 0x00, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00}, // 0xBF
{0x00, 0x08, 0x1C, 0x36, 0x63, 0x63, 0x7F, 0x63, 0x63, 0x63, 0x00, 0x00}, // 0xC0
{0x00, 0x7F, 0x43, 0x03, 0x03, 0x3F, 0x63, 0x63, 0x63, 0x3F, 0x00, 0x00}, // 0xC1
{0x00, 0x1F, 0x33, 0x33, 0x33, 0x1F, 0x63, 0x63, 0x63, 0x3F, 0x00, 0x00}, // 0xC2
{0x00, 0x7F, 0x46, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0F, 0x00, 0x00}, // 0xC3
{0x00, 0x3C, 0x3C, 0x34, 0x36, 0x36, 0x36, 0x36, 0x7F, 0x63, 0x41, 0x00}, // 0xC4
{0x00, 0x7F, 0x06, 0x06, 0x06, 0x3E, 0x06, 0x06, 0x06, 0x7F, 0x00, 0x00}, // 0xC5
{0x00, 0x6B, 0x6B, 0x2A, 0x1C, 0x1C, 0x2A, 0x6B, 0x6B, 0x6B, 0x00, 0x00}, // 0xC6
{0x00, 0x1E, 0x31, 0x30, 0x1C, 0x30, 0x30, 0x31, 0x3F, 0x1E, 0x00, 0x00}, // 0xC7
{0x00, 0x63, 0x73, 0x73, 0x6B, 0x6B, 0x67, 0x67, 0x63, 0x63, 0x00, 0x00}, // 0xC8
{0x14, 0x08, 0x63, 0x73, 0x73, 0x6B, 0x6B, 0x67, 0x67, 0x63, 0x00, 0x00}, // 0xC9
{0x00, 0x67, 0x66, 0x36, 0x1E, 0x36, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00}, // 0xCA
{0x00, 0x78, 0x78, 0x6C, 0x6C, 0x6C, 0x6C, 0x66, 0x66, 0x67, 0x00, 0x00}, // 0xCB
{0x00, 0x63, 0x63, 0x77, 0x77, 0x6B, 0x6B, 0x63, 0x63, 0x63, 0x00, 0x00}, // 0xCC
{0x00, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0xCD
{0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00, 0x00}, // 0xCE
{0x00, 0x3F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0xCF
{0x00, 0x3F, 0x63, 0x63, 0x63, 0x3F, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00}, // 0xD0
{0x00, 0x1C, 0x36, 0x63, 0x03, 0x03, 0x03, 0x63, 0x36, 0x1C, 0x00, 0x00}, // 0xD1
{0x00, 0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00}, // 0xD2
{0x00, 0x33, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x30, 0x33, 0x1E, 0x00, 0x00}, // 0xD3
{0x00, 0x3E, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x3E, 0x08, 0x08, 0x00, 0x00}, // 0xD4
{0x00, 0x33, 0x33, 0x1E, 0x0C, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0xD5
{0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7E, 0x60, 0x00}, // 0xD6
{0x00, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00}, // 0xD7
{0x00, 0x63, 0x63, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x7F, 0x00, 0x00}, // 0xD8
{0x00, 0x63, 0x63, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0xFF, 0xC0, 0x00}, // 0xD9
{0x00, 0x07, 0x06, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x66, 0x3E, 0x00, 0x00}, // 0xDA
{0x00, 0x63, 0x63, 0x63, 0x63, 0x6F, 0x73, 0x73, 0x73, 0x6F, 0x00, 0x00}, // 0xDB
{0x00, 0x03, 0x03, 0x03, 0x03, 0x1F, 0x33, 0x33, 0x33, 0x1F, 0x00, 0x00}, // 0xDC
{0x00, 0x1E, 0x33, 0x20, 0x60, 0x7C, 0x60, 0x20, 0x33, 0x1E, 0x00, 0x00}, // 0xDD
{0x00, 0x73, 0xDB, 0xDB, 0xDB, 0xDF, 0xDB, 0xDB, 0xDB, 0x73, 0x00, 0x00}, // 0xDE
{0x00, 0x7E, 0x63, 0x63, 0x63, 0x7E, 0x78, 0x6C, 0x66, 0x63, 0x00, 0x00}, // 0xDF
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x33, 0x6E, 0x00, 0x00}, // 0xE0
{0x00, 0x00, 0x20, 0x3E, 0x03, 0x03, 0x1F, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0xE1
{0x00, 0x00, 0x00, 0x00, 0x0F, 0x13, 0x0F, 0x33, 0x33, 0x1F, 0x00, 0x00}, // 0xE2
{0x00, 0x00, 0x00, 0x00, 0x3F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00}, // 0xE3
{0x00, 0x00, 0x00, 0x00, 0x1C, 0x36, 0x36, 0x36, 0x36, 0x7F, 0x63, 0x00}, // 0xE4
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x33, 0x1E, 0x00, 0x00}, // 0xE5
{0x00, 0x00, 0x00, 0x00, 0x6B, 0x2A, 0x1C, 0x2A, 0x2A, 0x6B, 0x00, 0x00}, // 0xE6
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x18, 0x30, 0x33, 0x1E, 0x00, 0x00}, // 0xE7
{0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x73, 0x7B, 0x6F, 0x66, 0x00, 0x00}, // 0xE8
{0x00, 0x14, 0x08, 0x00, 0x63, 0x63, 0x73, 0x7B, 0x6F, 0x66, 0x00, 0x00}, // 0xE9
{0x00, 0x00, 0x00, 0x00, 0x33, 0x1B, 0x0F, 0x1B, 0x33, 0x33, 0x00, 0x00}, // 0xEA
{0x00, 0x00, 0x00, 0x00, 0x38, 0x3C, 0x36, 0x36, 0x33, 0x33, 0x00, 0x00}, // 0xEB
{0x00, 0x00, 0x00, 0x00, 0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x00, 0x00}, // 0xEC
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0xED
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00, 0x00}, // 0xEE
{0x00, 0x00, 0x00, 0x00, 0x3F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00}, // 0xEF
{0x00, 0x00, 0x00, 0x00, 0x1F, 0x33, 0x33, 0x1F, 0x03, 0x03, 0x00, 0x00}, // 0xF0
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x03, 0x03, 0x33, 0x1E, 0x00, 0x00}, // 0xF1
{0x00, 0x00, 0x00, 0x00, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00}, // 0xF2
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x1E, 0x00, 0x00}, // 0xF3
{0x00, 0x00, 0x00, 0x00, 0x3E, 0x6B, 0x6B, 0x6B, 0x3E, 0x08, 0x00, 0x00}, // 0xF4
{0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00, 0x00}, // 0xF5
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7E, 0x60, 0x00}, // 0xF6
{0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x3F, 0x30, 0x30, 0x00, 0x00}, // 0xF7
{0x00, 0x00, 0x00, 0x00, 0x63, 0x6B, 0x6B, 0x6B, 0x6B, 0x7F, 0x00, 0x00}, // 0xF8
{0x00, 0x00, 0x00, 0x00, 0x63, 0x6B, 0x6B, 0x6B, 0x6B, 0x7F, 0x60, 0x00}, // 0xF9
{0x00, 0x00, 0x00, 0x00, 0x07, 0x06, 0x3E, 0x66, 0x66, 0x3E, 0x00, 0x00}, // 0xFA
{0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6F, 0x7B, 0x7B, 0x6F, 0x00, 0x00}, // 0xFB
{0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x1F, 0x33, 0x33, 0x1F, 0x00, 0x00}, // 0xFC
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x33, 0x38, 0x30, 0x33, 0x1E, 0x00, 0x00}, // 0xFD
{0x00, 0x00, 0x00, 0x73, 0xDB, 0xDB, 0xDF, 0xDB, 0xDB, 0x73, 0x00, 0x00}, // 0xFE
{0x00, 0x00, 0x00, 0x00, 0x1E, 0x1B, 0x1B, 0x1E, 0x1C, 0x1B, 0x00, 0x00} // 0xFF
};    
#endif

#ifdef USE_FONT_8X14
__UG_FONT_DATA unsigned char font_8x14[256][14]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0x00,0x00,0x00,0x00,0x3C,0x42,0xA5,0x81,0xBD,0x42,0x3C,0x00,0x00,0x00},   // 0x01
{0x00,0x00,0x00,0x00,0x3C,0x7E,0xDB,0xFF,0xDB,0x42,0x3C,0x00,0x00,0x00},   // 0x02
{0x00,0x66,0xFF,0xFF,0xFF,0xFF,0x7E,0x7E,0x3C,0x3C,0x18,0x00,0x00,0x00},   // 0x03
{0x00,0x10,0x18,0x3C,0x7E,0xFF,0x7E,0x3C,0x38,0x10,0x10,0x00,0x00,0x00},   // 0x04
{0x00,0x18,0x3C,0x3C,0x7E,0xFF,0xFF,0x6E,0x18,0x18,0x18,0x00,0x00,0x00},   // 0x05
{0x00,0x10,0x18,0x38,0x7C,0xFE,0xFF,0xFF,0x6E,0x18,0x18,0x00,0x00,0x00},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0x00,0x60,0xD0,0xA0,0x3C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x0B
{0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x08,0x3E,0x08,0x00,0x00,0x00},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0x00,0x40,0x70,0x58,0x48,0x48,0x48,0x48,0x48,0x78,0x3E,0x0F,0x07,0x00},   // 0x0E
{0x00,0x00,0x00,0x08,0x7E,0x46,0xC3,0x46,0x7E,0x08,0x00,0x00,0x00,0x00},   // 0x0F
{0x00,0x00,0x00,0x01,0x07,0x3F,0xFF,0x3F,0x0F,0x07,0x01,0x00,0x00,0x00},   // 0x10
{0x00,0x00,0x00,0x80,0xE0,0xFC,0xFF,0xFC,0xF0,0xE0,0x80,0x00,0x00,0x00},   // 0x11
{0x00,0x10,0x38,0x54,0x10,0x10,0x10,0x10,0x10,0x10,0x54,0x38,0x10,0x00},   // 0x12
{0x00,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x00,0x24,0x24,0x00,0x00,0x00},   // 0x13
{0x00,0x7E,0x4F,0x4F,0x4F,0x4E,0x48,0x48,0x48,0x48,0x48,0x48,0x48,0x00},   // 0x14
{0x00,0x78,0x04,0x04,0x1C,0x34,0x44,0x4C,0x38,0x60,0x40,0x44,0x3C,0x00},   // 0x15
{0x00,0x00,0x00,0x00,0x00,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x16
{0x10,0x38,0x54,0x10,0x10,0x10,0x10,0x10,0x10,0x54,0x38,0x10,0x00,0x7C},   // 0x17
{0x00,0x10,0x38,0x54,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00},   // 0x18
{0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x54,0x38,0x10,0x00},   // 0x19
{0x00,0x00,0x00,0x00,0x10,0x20,0x7E,0x20,0x10,0x00,0x00,0x00,0x00,0x00},   // 0x1A
{0x00,0x00,0x00,0x00,0x08,0x04,0x7E,0x04,0x08,0x00,0x00,0x00,0x00,0x00},   // 0x1B
{0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x24,0x7E,0x24,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1D
{0x00,0x00,0x00,0x10,0x10,0x38,0x38,0x3C,0x7E,0x7E,0xFF,0x00,0x00,0x00},   // 0x1E
{0x00,0x00,0x00,0xFF,0x7E,0x7E,0x3C,0x38,0x38,0x10,0x10,0x00,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x08,0x08,0x00,0x00,0x00},   // 0x21
{0x24,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x00,0x90,0x90,0x48,0xFE,0x48,0x24,0xFF,0x24,0x12,0x12,0x00,0x00,0x00},   // 0x23
{0x08,0x3C,0x0A,0x0A,0x0A,0x0C,0x18,0x28,0x28,0x28,0x1E,0x08,0x00,0x00},   // 0x24
{0x00,0x86,0x49,0x29,0x29,0x16,0x68,0x94,0x94,0x92,0x61,0x00,0x00,0x00},   // 0x25
{0x00,0x18,0x24,0x24,0x14,0x0C,0x8B,0x91,0x71,0x63,0xFE,0x00,0x00,0x00},   // 0x26
{0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0x60,0x30,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x30,0x60,0x00},   // 0x28
{0x06,0x0C,0x10,0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x10,0x0C,0x06,0x00},   // 0x29
{0x00,0x08,0x08,0x66,0x14,0x2C,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2A
{0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x7F,0x08,0x08,0x08,0x00,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x10,0x08,0x00},   // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00},   // 0x2E
{0x40,0x20,0x20,0x20,0x10,0x10,0x18,0x08,0x08,0x04,0x04,0x04,0x02,0x00},   // 0x2F
{0x00,0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00},   // 0x30
{0x00,0x10,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0xFE,0x00,0x00,0x00},   // 0x31
{0x00,0x1E,0x20,0x20,0x20,0x10,0x10,0x08,0x04,0x02,0x3E,0x00,0x00,0x00},   // 0x32
{0x00,0x3C,0x40,0x40,0x40,0x38,0x40,0x40,0x40,0x40,0x3C,0x00,0x00,0x00},   // 0x33
{0x00,0x20,0x30,0x28,0x28,0x24,0x22,0x7E,0x20,0x20,0x20,0x00,0x00,0x00},   // 0x34
{0x00,0x7C,0x04,0x04,0x04,0x1C,0x60,0x40,0x40,0x40,0x3C,0x00,0x00,0x00},   // 0x35
{0x00,0x38,0x04,0x02,0x02,0x3A,0x46,0x42,0x42,0x44,0x38,0x00,0x00,0x00},   // 0x36
{0x00,0x7E,0x40,0x20,0x20,0x10,0x08,0x08,0x08,0x04,0x04,0x00,0x00,0x00},   // 0x37
{0x00,0x3C,0x42,0x42,0x22,0x1C,0x24,0x42,0x42,0x42,0x3C,0x00,0x00,0x00},   // 0x38
{0x00,0x1C,0x22,0x42,0x42,0x62,0x5C,0x40,0x40,0x20,0x1C,0x00,0x00,0x00},   // 0x39
{0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00},   // 0x3A
{0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x10,0x08,0x00},   // 0x3B
{0x00,0x00,0x00,0x00,0x40,0x30,0x08,0x06,0x08,0x30,0x40,0x00,0x00,0x00},   // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00},   // 0x3D
{0x00,0x00,0x00,0x00,0x02,0x0C,0x10,0x60,0x10,0x0C,0x02,0x00,0x00,0x00},   // 0x3E
{0x00,0x3E,0x42,0x40,0x20,0x10,0x08,0x08,0x00,0x08,0x08,0x00,0x00,0x00},   // 0x3F
{0x00,0x3C,0x46,0x72,0x49,0x49,0x49,0x69,0xDB,0x22,0x3C,0x00,0x00,0x00},   // 0x40
{0x00,0x00,0x10,0x18,0x28,0x24,0x24,0x42,0x7E,0x42,0x81,0x00,0x00,0x00},   // 0x41
{0x00,0x00,0x3E,0x42,0x42,0x22,0x1E,0x22,0x42,0x42,0x3E,0x00,0x00,0x00},   // 0x42
{0x00,0x00,0x7C,0x02,0x01,0x01,0x01,0x01,0x01,0x02,0x7C,0x00,0x00,0x00},   // 0x43
{0x00,0x00,0x1F,0x21,0x41,0x41,0x41,0x41,0x41,0x21,0x1F,0x00,0x00,0x00},   // 0x44
{0x00,0x00,0x7E,0x02,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0x45
{0x00,0x00,0x7E,0x02,0x02,0x02,0x3E,0x02,0x02,0x02,0x02,0x00,0x00,0x00},   // 0x46
{0x00,0x00,0x7C,0x02,0x01,0x01,0x01,0x71,0x41,0x42,0x7C,0x00,0x00,0x00},   // 0x47
{0x00,0x00,0x42,0x42,0x42,0x42,0x7E,0x42,0x42,0x42,0x42,0x00,0x00,0x00},   // 0x48
{0x00,0x00,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3E,0x00,0x00,0x00},   // 0x49
{0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1E,0x00,0x00,0x00},   // 0x4A
{0x00,0x00,0x42,0x22,0x12,0x0A,0x06,0x0A,0x12,0x22,0x42,0x00,0x00,0x00},   // 0x4B
{0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0x4C
{0x00,0x00,0x63,0x63,0x63,0x55,0x55,0x55,0x49,0x41,0x41,0x00,0x00,0x00},   // 0x4D
{0x00,0x00,0x42,0x46,0x46,0x4A,0x4A,0x52,0x52,0x62,0x42,0x00,0x00,0x00},   // 0x4E
{0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x4F
{0x00,0x00,0x3E,0x42,0x42,0x42,0x62,0x1E,0x02,0x02,0x02,0x00,0x00,0x00},   // 0x50
{0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x60,0xC0,0x00},   // 0x51
{0x00,0x00,0x1E,0x22,0x22,0x22,0x1E,0x12,0x32,0x22,0x42,0x00,0x00,0x00},   // 0x52
{0x00,0x00,0x7C,0x02,0x02,0x06,0x18,0x60,0x40,0x40,0x3E,0x00,0x00,0x00},   // 0x53
{0x00,0x00,0x7F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00},   // 0x54
{0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,0x00},   // 0x55
{0x00,0x00,0x81,0x42,0x42,0x22,0x24,0x14,0x14,0x08,0x08,0x00,0x00,0x00},   // 0x56
{0x00,0x00,0x81,0x81,0xC9,0x59,0x5A,0x5A,0x66,0x66,0x24,0x00,0x00,0x00},   // 0x57
{0x00,0x00,0x81,0x42,0x24,0x18,0x18,0x18,0x24,0x42,0x81,0x00,0x00,0x00},   // 0x58
{0x00,0x00,0x81,0x42,0x22,0x14,0x18,0x08,0x08,0x08,0x08,0x00,0x00,0x00},   // 0x59
{0x00,0x00,0x7F,0x40,0x20,0x10,0x08,0x04,0x02,0x01,0x7F,0x00,0x00,0x00},   // 0x5A
{0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x00},   // 0x5B
{0x02,0x04,0x04,0x04,0x08,0x08,0x18,0x10,0x10,0x20,0x20,0x20,0x40,0x00},   // 0x5C
{0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1E,0x00},   // 0x5D
{0x00,0x10,0x10,0x18,0x28,0x28,0x24,0x44,0x42,0x00,0x00,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00},   // 0x5F
{0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x00,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0x61
{0x02,0x02,0x02,0x02,0x3A,0x46,0x42,0x42,0x42,0x46,0x3A,0x00,0x00,0x00},   // 0x62
{0x00,0x00,0x00,0x00,0x78,0x04,0x02,0x02,0x02,0x04,0x78,0x00,0x00,0x00},   // 0x63
{0x40,0x40,0x40,0x40,0x5C,0x62,0x42,0x42,0x42,0x62,0x5C,0x00,0x00,0x00},   // 0x64
{0x00,0x00,0x00,0x00,0x3C,0x44,0x42,0x7E,0x02,0x02,0x7C,0x00,0x00,0x00},   // 0x65
{0x70,0x08,0x08,0x08,0x7E,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00},   // 0x66
{0x00,0x00,0x00,0x00,0x7C,0x62,0x42,0x42,0x42,0x62,0x5C,0x40,0x40,0x3C},   // 0x67
{0x02,0x02,0x02,0x02,0x3A,0x46,0x42,0x42,0x42,0x42,0x42,0x00,0x00,0x00},   // 0x68
{0x18,0x18,0x00,0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0x69
{0x30,0x30,0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1E},   // 0x6A
{0x02,0x02,0x02,0x02,0x22,0x12,0x0A,0x06,0x1A,0x22,0x42,0x00,0x00,0x00},   // 0x6B
{0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0x6C
{0x00,0x00,0x00,0x00,0x6D,0x5B,0x49,0x49,0x49,0x49,0x49,0x00,0x00,0x00},   // 0x6D
{0x00,0x00,0x00,0x00,0x3A,0x46,0x42,0x42,0x42,0x42,0x42,0x00,0x00,0x00},   // 0x6E
{0x00,0x00,0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x6F
{0x00,0x00,0x00,0x00,0x3A,0x46,0x42,0x42,0x42,0x46,0x3A,0x02,0x02,0x02},   // 0x70
{0x00,0x00,0x00,0x00,0x5C,0x62,0x42,0x42,0x42,0x62,0x5C,0x40,0x40,0x40},   // 0x71
{0x00,0x00,0x00,0x00,0x3A,0x26,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00},   // 0x72
{0x00,0x00,0x00,0x00,0x3C,0x02,0x06,0x18,0x20,0x20,0x1E,0x00,0x00,0x00},   // 0x73
{0x00,0x00,0x04,0x04,0x7F,0x04,0x04,0x04,0x04,0x04,0x78,0x00,0x00,0x00},   // 0x74
{0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x62,0x5C,0x00,0x00,0x00},   // 0x75
{0x00,0x00,0x00,0x00,0x81,0x42,0x42,0x22,0x14,0x14,0x08,0x00,0x00,0x00},   // 0x76
{0x00,0x00,0x00,0x00,0x81,0x91,0x5A,0x5A,0x66,0x24,0x24,0x00,0x00,0x00},   // 0x77
{0x00,0x00,0x00,0x00,0x42,0x24,0x18,0x18,0x18,0x24,0x42,0x00,0x00,0x00},   // 0x78
{0x00,0x00,0x00,0x00,0x81,0x42,0x42,0x24,0x24,0x18,0x18,0x08,0x0C,0x07},   // 0x79
{0x00,0x00,0x00,0x00,0x7F,0x20,0x10,0x08,0x04,0x02,0x7F,0x00,0x00,0x00},   // 0x7A
{0x70,0x08,0x08,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x70,0x00},   // 0x7B
{0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00},   // 0x7C
{0x0E,0x10,0x10,0x10,0x10,0x10,0x60,0x10,0x10,0x10,0x10,0x10,0x0E,0x00},   // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x86,0x99,0x61,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7E
{0x00,0x00,0x00,0x08,0x1C,0x22,0x41,0x41,0x41,0x41,0x7F,0x00,0x00,0x00},   // 0x7F
{0x00,0x00,0x7C,0x02,0x01,0x01,0x01,0x01,0x01,0x02,0x7C,0x10,0x20,0x30},   // 0x80
{0x00,0x24,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x62,0x5C,0x00,0x00,0x00},   // 0x81
{0x20,0x10,0x00,0x00,0x3C,0x44,0x42,0x7E,0x02,0x02,0x7C,0x00,0x00,0x00},   // 0x82
{0x18,0x24,0x00,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0x83
{0x00,0x24,0x00,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0x84
{0x08,0x10,0x00,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0x85
{0x10,0x28,0x10,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0x86
{0x00,0x00,0x00,0x00,0x78,0x04,0x02,0x02,0x02,0x04,0x78,0x08,0x10,0x18},   // 0x87
{0x18,0x24,0x00,0x00,0x3C,0x44,0x42,0x7E,0x02,0x02,0x7C,0x00,0x00,0x00},   // 0x88
{0x00,0x48,0x00,0x00,0x3C,0x44,0x42,0x7E,0x02,0x02,0x7C,0x00,0x00,0x00},   // 0x89
{0x08,0x10,0x00,0x00,0x3C,0x44,0x42,0x7E,0x02,0x02,0x7C,0x00,0x00,0x00},   // 0x8A
{0x00,0x24,0x00,0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0x8B
{0x18,0x24,0x00,0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0x8C
{0x08,0x10,0x00,0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0x8D
{0x24,0x00,0x10,0x18,0x28,0x24,0x24,0x42,0x7E,0x42,0x81,0x00,0x00,0x00},   // 0x8E
{0x08,0x14,0x08,0x1C,0x14,0x34,0x22,0x22,0x7E,0x43,0x81,0x00,0x00,0x00},   // 0x8F
{0x20,0x10,0x7E,0x02,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0x90
{0x00,0x00,0x00,0x00,0x77,0x88,0x88,0xFE,0x09,0x09,0xF6,0x00,0x00,0x00},   // 0x91
{0x00,0x00,0xF0,0x18,0x18,0x14,0x74,0x12,0x1E,0x12,0xF1,0x00,0x00,0x00},   // 0x92
{0x18,0x24,0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x93
{0x00,0x24,0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x94
{0x04,0x08,0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x95
{0x18,0x24,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x62,0x5C,0x00,0x00,0x00},   // 0x96
{0x04,0x08,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x62,0x5C,0x00,0x00,0x00},   // 0x97
{0x00,0x24,0x00,0x00,0x81,0x42,0x42,0x24,0x24,0x18,0x18,0x08,0x0C,0x07},   // 0x98
{0x24,0x00,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0x99
{0x24,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,0x00},   // 0x9A
{0x00,0x00,0x00,0x00,0x7E,0x63,0x51,0x49,0x45,0x22,0x1F,0x00,0x00,0x00},   // 0x9B
{0x00,0x70,0x08,0x08,0x08,0x1C,0x08,0x08,0x08,0x04,0x7C,0x00,0x00,0x00},   // 0x9C
{0x00,0x00,0x5C,0x22,0x61,0x51,0x49,0x45,0x43,0x22,0x1D,0x00,0x00,0x00},   // 0x9D
{0x00,0x00,0x00,0x00,0x41,0x22,0x14,0x08,0x14,0x22,0x41,0x00,0x00,0x00},   // 0x9E
{0x70,0x08,0x08,0x08,0x3C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07},   // 0x9F
{0x20,0x10,0x00,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0xA0
{0x20,0x10,0x00,0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0xA1
{0x20,0x10,0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xA2
{0x20,0x10,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x62,0x5C,0x00,0x00,0x00},   // 0xA3
{0x48,0x34,0x00,0x00,0x3A,0x46,0x42,0x42,0x42,0x42,0x42,0x00,0x00,0x00},   // 0xA4
{0x58,0x34,0x42,0x46,0x46,0x4A,0x4A,0x52,0x52,0x62,0x42,0x00,0x00,0x00},   // 0xA5
{0x00,0x3C,0x20,0x38,0x24,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA6
{0x00,0x1C,0x22,0x22,0x22,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA7
{0x00,0x00,0x00,0x00,0x10,0x10,0x00,0x10,0x10,0x08,0x04,0x02,0x42,0x7C},   // 0xA8
{0x00,0x3C,0x42,0x5A,0x5A,0x42,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x40,0x40,0x00,0x00,0x00,0x00,0x00},   // 0xAA
{0x00,0x43,0x22,0x32,0x12,0x0A,0xF8,0x84,0x46,0x32,0xF1,0x00,0x00,0x00},   // 0xAB
{0x00,0x43,0x22,0x12,0x12,0x0A,0x68,0x54,0x4A,0xFA,0x41,0x00,0x00,0x00},   // 0xAC
{0x00,0x00,0x00,0x00,0x08,0x08,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08},   // 0xAD
{0x00,0x00,0x00,0x00,0x48,0x24,0x12,0x12,0x24,0x48,0x00,0x00,0x00,0x00},   // 0xAE
{0x00,0x00,0x00,0x00,0x12,0x24,0x48,0x48,0x24,0x12,0x00,0x00,0x00,0x00},   // 0xAF
{0x49,0x00,0x00,0x49,0x00,0x00,0x49,0x00,0x49,0x00,0x00,0x49,0x00,0x00},   // 0xB0
{0x92,0x49,0x00,0x92,0x49,0x00,0x92,0x49,0x92,0x00,0x49,0x92,0x00,0x49},   // 0xB1
{0xFF,0x49,0x49,0xFF,0x49,0x49,0xFF,0x49,0xFF,0x49,0x49,0xFF,0x49,0x49},   // 0xB2
{0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xB3
{0x10,0x10,0x10,0x10,0x10,0x10,0x1F,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xB4
{0x10,0x08,0x10,0x18,0x28,0x24,0x24,0x42,0x7E,0x42,0x81,0x00,0x00,0x00},   // 0xB5
{0x18,0x24,0x10,0x18,0x28,0x24,0x24,0x42,0x7E,0x42,0x81,0x00,0x00,0x00},   // 0xB6
{0x08,0x10,0x10,0x18,0x28,0x24,0x24,0x42,0x7E,0x42,0x81,0x00,0x00,0x00},   // 0xB7
{0x00,0x3C,0x42,0xB9,0x85,0x85,0x85,0x85,0xB9,0x42,0x3C,0x00,0x00,0x00},   // 0xB8
{0x28,0x28,0x28,0x28,0x28,0x2F,0x20,0x2F,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xB9
{0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x3F,0x20,0x2F,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xBB
{0x28,0x28,0x28,0x28,0x28,0x2F,0x20,0x3F,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBC
{0x00,0x10,0x78,0x14,0x12,0x12,0x12,0x12,0x14,0x78,0x10,0x00,0x00,0x00},   // 0xBD
{0x00,0x81,0x42,0x24,0x14,0x08,0x3E,0x08,0x3E,0x08,0x08,0x00,0x00,0x00},   // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xBF
{0x10,0x10,0x10,0x10,0x10,0x10,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC0
{0x10,0x10,0x10,0x10,0x10,0x10,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xC2
{0x10,0x10,0x10,0x10,0x10,0x10,0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC4
{0x10,0x10,0x10,0x10,0x10,0x10,0xFF,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xC5
{0x48,0x34,0x00,0x00,0x3C,0x40,0x40,0x7C,0x42,0x42,0xFC,0x00,0x00,0x00},   // 0xC6
{0x58,0x34,0x10,0x18,0x28,0x24,0x24,0x42,0x7E,0x42,0x81,0x00,0x00,0x00},   // 0xC7
{0x28,0x28,0x28,0x28,0x28,0xE8,0x08,0xF8,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC8
{0x00,0x00,0x00,0x00,0x00,0xF8,0x08,0xE8,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xC9
{0x28,0x28,0x28,0x28,0x28,0xEF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCA
{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xEF,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xCB
{0x28,0x28,0x28,0x28,0x28,0xE8,0x08,0xE8,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xCC
{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCD
{0x28,0x28,0x28,0x28,0x28,0xEF,0x00,0xEF,0x28,0x28,0x28,0x28,0x28,0x28},   // 0xCE
{0x00,0x00,0x41,0x3E,0x22,0x22,0x22,0x22,0x3E,0x41,0x00,0x00,0x00,0x00},   // 0xCF
{0x17,0x0C,0x16,0x20,0x3C,0x62,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xD0
{0x00,0x00,0x3E,0x42,0x82,0x82,0x8F,0x82,0x82,0x42,0x3E,0x00,0x00,0x00},   // 0xD1
{0x18,0x24,0x7E,0x02,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0xD2
{0x24,0x00,0x7E,0x02,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0xD3
{0x10,0x20,0x7E,0x02,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,0x00},   // 0xD4
{0x00,0x00,0x00,0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},   // 0xD5
{0x20,0x10,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3E,0x00,0x00,0x00},   // 0xD6
{0x18,0x24,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3E,0x00,0x00,0x00},   // 0xD7
{0x24,0x00,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3E,0x00,0x00,0x00},   // 0xD8
{0x10,0x10,0x10,0x10,0x10,0x10,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10},   // 0xDA
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},   // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},   // 0xDC
{0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x00},   // 0xDD
{0x08,0x10,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3E,0x00,0x00,0x00},   // 0xDE
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDF
{0x20,0x10,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xE0
{0x1C,0x22,0x22,0x22,0x12,0x12,0x22,0x42,0x82,0x82,0x72,0x00,0x00,0x00},   // 0xE1
{0x18,0x24,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xE2
{0x08,0x10,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xE3
{0x48,0x34,0x00,0x00,0x1C,0x22,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xE4
{0x58,0x34,0x1C,0x22,0x41,0x41,0x41,0x41,0x41,0x22,0x1C,0x00,0x00,0x00},   // 0xE5
{0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x66,0x5A,0x02,0x02,0x02},   // 0xE6
{0x02,0x02,0x02,0x02,0x3A,0x46,0x42,0x42,0x42,0x46,0x3A,0x02,0x02,0x02},   // 0xE7
{0x00,0x00,0x02,0x02,0x3E,0x42,0x42,0x42,0x3E,0x02,0x02,0x00,0x00,0x00},   // 0xE8
{0x20,0x10,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,0x00},   // 0xE9
{0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,0x00},   // 0xEA
{0x10,0x20,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,0x00},   // 0xEB
{0x20,0x10,0x00,0x00,0x81,0x42,0x42,0x24,0x24,0x18,0x18,0x08,0x0C,0x07},   // 0xEC
{0x20,0x10,0x81,0x42,0x22,0x14,0x18,0x08,0x08,0x08,0x08,0x00,0x00,0x00},   // 0xED
{0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF0
{0x00,0x00,0x00,0x00,0x08,0x08,0x7F,0x08,0x08,0x00,0x7F,0x00,0x00,0x00},   // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF},   // 0xF2
{0x00,0x87,0x44,0x23,0x24,0x17,0x68,0x54,0x4C,0xFA,0x41,0x00,0x00,0x00},   // 0xF3
{0x00,0x7E,0x4F,0x4F,0x4F,0x4E,0x48,0x48,0x48,0x48,0x48,0x48,0x48,0x00},   // 0xF4
{0x00,0x78,0x04,0x04,0x1C,0x34,0x44,0x4C,0x38,0x60,0x40,0x44,0x3C,0x00},   // 0xF5
{0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x7F,0x00,0x18,0x18,0x00,0x00,0x00},   // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x18},   // 0xF7
{0x00,0x08,0x14,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF8
{0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFA
{0x00,0x18,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFB
{0x00,0x3C,0x20,0x18,0x20,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFC
{0x00,0x3C,0x20,0x10,0x08,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x00,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_10X16
__UG_FONT_DATA unsigned char font_10x16[256][32]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x86,0x01,0x4B,0x03,0x01,0x02,0x85,0x02,0x7B,0x03,0x86,0x01,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x01
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0xFE,0x01,0xB7,0x03,0xFF,0x03,0x7B,0x03,0x87,0x03,0xFE,0x01,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x02
{0x00,0x00,0xCE,0x01,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFE,0x01,0xFE,0x01,0xFC,0x00,0xFC,0x00,0x78,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x03
{0x00,0x00,0x10,0x00,0x10,0x00,0x38,0x00,0x7C,0x00,0xFC,0x00,0xFE,0x01,0xFF,0x03,0xFE,0x01,0xFC,0x00,0x78,0x00,0x30,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x04
{0x00,0x00,0x30,0x00,0x78,0x00,0x78,0x00,0x78,0x00,0xFE,0x01,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xDE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x05
{0x00,0x00,0x20,0x00,0x30,0x00,0x78,0x00,0xFC,0x00,0xFE,0x01,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xDE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0x00,0x00,0x80,0x01,0xE0,0x01,0x80,0x03,0x40,0x02,0x7C,0x00,0x42,0x00,0x81,0x00,0x81,0x00,0x81,0x00,0x81,0x00,0x42,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0B
{0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xC4,0x00,0x78,0x00,0x10,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0x00,0x00,0x00,0x01,0xC0,0x01,0x78,0x01,0x18,0x01,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x01,0xC8,0x01,0xE8,0x01,0xE8,0x00,0x0E,0x00,0x0F,0x00,0x07,0x00,0x00,0x00},   // 0x0E
{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xBA,0x01,0xC6,0x00,0x02,0x01,0x03,0x03,0x86,0x01,0xFE,0x01,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x07,0x00,0x3F,0x00,0xFF,0x00,0xFF,0x03,0xFF,0x00,0x3F,0x00,0x07,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x10
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x80,0x03,0xF0,0x03,0xFC,0x03,0xFF,0x03,0xFC,0x03,0xF0,0x03,0x80,0x03,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x11
{0x00,0x00,0x10,0x00,0x38,0x00,0x54,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x54,0x00,0x38,0x00,0x10,0x00,0x00,0x00},   // 0x12
{0x00,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x24,0x00,0x00,0x00,0x24,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x13
{0x00,0x00,0xFC,0x00,0x9E,0x00,0x9E,0x00,0x9E,0x00,0x9C,0x00,0x98,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x00,0x00},   // 0x14
{0x00,0x00,0xF8,0x00,0x04,0x00,0x04,0x00,0x0C,0x00,0x38,0x00,0x64,0x00,0x84,0x00,0x8C,0x00,0xB8,0x00,0x60,0x00,0xC0,0x00,0x80,0x00,0x84,0x00,0x7C,0x00,0x00,0x00},   // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x16
{0x00,0x00,0x10,0x00,0x38,0x00,0x54,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x54,0x00,0x38,0x00,0x10,0x00,0x00,0x00,0x7C,0x00},   // 0x17
{0x00,0x00,0x10,0x00,0x38,0x00,0x54,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00},   // 0x18
{0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x54,0x00,0x38,0x00,0x10,0x00,0x00,0x00},   // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x80,0x00,0xFE,0x01,0x80,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x04,0x00,0xFE,0x01,0x04,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x84,0x00,0xFE,0x01,0x84,0x00,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x70,0x00,0x78,0x00,0xF8,0x00,0xFC,0x00,0xFC,0x01,0xFE,0x01,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0xFE,0x01,0xFC,0x01,0xFC,0x00,0xF8,0x00,0x78,0x00,0x70,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x21
{0x00,0x00,0x44,0x00,0x44,0x00,0x44,0x00,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x00,0x00,0x90,0x00,0x90,0x00,0x48,0x00,0x48,0x00,0xFE,0x01,0x48,0x00,0x24,0x00,0xFF,0x01,0x24,0x00,0x24,0x00,0x12,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x23
{0x20,0x00,0xF8,0x00,0x2C,0x00,0x24,0x00,0x24,0x00,0x28,0x00,0x30,0x00,0x60,0x00,0xE0,0x00,0xA0,0x00,0xA0,0x00,0xA4,0x00,0x7C,0x00,0x20,0x00,0x00,0x00,0x00,0x00},   // 0x24
{0x00,0x00,0x0E,0x02,0x11,0x01,0x91,0x00,0x51,0x00,0x4E,0x00,0x20,0x00,0x10,0x00,0xC8,0x01,0x28,0x02,0x24,0x02,0x22,0x02,0xC1,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x25
{0x00,0x00,0x38,0x00,0x44,0x00,0x44,0x00,0x64,0x00,0x38,0x00,0x0C,0x00,0x12,0x02,0x31,0x02,0x21,0x01,0x41,0x01,0xC2,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x26
{0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0x00,0x00,0x80,0x01,0x60,0x00,0x30,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x30,0x00,0x60,0x00,0x80,0x01,0x00,0x00},   // 0x28
{0x00,0x00,0x06,0x00,0x18,0x00,0x30,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x30,0x00,0x18,0x00,0x06,0x00,0x00,0x00},   // 0x29
{0x00,0x00,0x10,0x00,0x10,0x00,0xD6,0x00,0x6C,0x00,0x28,0x00,0x38,0x00,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFF,0x01,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x10,0x00,0x10,0x00,0x08,0x00},   // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2E
{0x00,0x00,0x00,0x01,0x80,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x02,0x00,0x00,0x00},   // 0x2F
{0x00,0x00,0x38,0x00,0x44,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x30
{0x00,0x00,0x10,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x31
{0x00,0x00,0x3E,0x00,0x42,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0x02,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x32
{0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x38,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x33
{0x00,0x00,0x20,0x00,0x30,0x00,0x28,0x00,0x28,0x00,0x24,0x00,0x22,0x00,0x22,0x00,0x21,0x00,0xFF,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x34
{0x00,0x00,0x7C,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x1C,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x35
{0x00,0x00,0x78,0x00,0x04,0x00,0x04,0x00,0x02,0x00,0x3A,0x00,0x46,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x36
{0x00,0x00,0xFE,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x37
{0x00,0x00,0x7C,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x64,0x00,0x18,0x00,0x64,0x00,0x42,0x00,0x82,0x00,0x82,0x00,0x42,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x38
{0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xC4,0x00,0xB8,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x10,0x00,0x10,0x00,0x08,0x00},   // 0x3B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x00,0x30,0x00,0x0C,0x00,0x0C,0x00,0x30,0x00,0xC0,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x0C,0x00,0x30,0x00,0xC0,0x00,0xC0,0x00,0x30,0x00,0x0C,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3E
{0x00,0x00,0x7E,0x00,0xC2,0x00,0x82,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3F
{0x00,0x00,0x78,0x00,0x84,0x00,0xE2,0x00,0x93,0x00,0x89,0x00,0x89,0x00,0xC9,0x00,0xC9,0x00,0xE9,0x00,0xB2,0x03,0x46,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x40
{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x28,0x00,0x48,0x00,0x44,0x00,0x84,0x00,0xFE,0x00,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x41
{0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x82,0x00,0x82,0x00,0x42,0x00,0x3E,0x00,0x42,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x42
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x86,0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x06,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x43
{0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x42,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x42,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x44
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x45
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x46
{0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x0C,0x01,0x04,0x00,0x02,0x00,0x02,0x00,0xC2,0x01,0x02,0x01,0x04,0x01,0x0C,0x01,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x47
{0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xFE,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x48
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x49
{0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4A
{0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x00,0x42,0x00,0x22,0x00,0x12,0x00,0x0E,0x00,0x0A,0x00,0x12,0x00,0x62,0x00,0x82,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4B
{0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4C
{0x00,0x00,0x00,0x00,0x00,0x00,0xC3,0x00,0xC3,0x00,0xC7,0x00,0xA5,0x00,0xA5,0x00,0xAD,0x00,0x99,0x00,0x99,0x00,0x81,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4D
{0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x00,0x86,0x00,0x8A,0x00,0x8A,0x00,0x92,0x00,0x92,0x00,0xA2,0x00,0xA2,0x00,0xC2,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4E
{0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4F
{0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x42,0x00,0x3E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x50
{0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x40,0x00,0x80,0x01,0x00,0x00},   // 0x51
{0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x22,0x00,0x1E,0x00,0x12,0x00,0x22,0x00,0x42,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x52
{0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x82,0x00,0x02,0x00,0x06,0x00,0x18,0x00,0x60,0x00,0x80,0x00,0x80,0x00,0xC2,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x53
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x54
{0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x55
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x02,0x01,0x84,0x00,0x84,0x00,0x44,0x00,0x48,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x56
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x01,0x02,0x12,0x01,0x32,0x01,0x32,0x01,0x2A,0x01,0x4A,0x01,0xCC,0x00,0xCC,0x00,0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x57
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x84,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x48,0x00,0x84,0x00,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x58
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x84,0x00,0x44,0x00,0x28,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x59
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x01,0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0x02,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5A
{0x00,0x00,0xF8,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xF8,0x00,0x00,0x00},   // 0x5B
{0x00,0x00,0x02,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x00,0x00,0x01,0x00,0x00},   // 0x5C
{0x00,0x00,0x3E,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x3E,0x00,0x00,0x00},   // 0x5D
{0x00,0x00,0x20,0x00,0x20,0x00,0x30,0x00,0x50,0x00,0x58,0x00,0x48,0x00,0x88,0x00,0x84,0x00,0x84,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00},   // 0x5F
{0x10,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x61
{0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7A,0x00,0x46,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x46,0x00,0x3A,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x63
{0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xB8,0x00,0xC4,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xC4,0x00,0xBC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x82,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x65
{0x00,0x00,0xE0,0x01,0x18,0x00,0x08,0x00,0x08,0x00,0xFE,0x01,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB8,0x00,0xC4,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xC4,0x00,0xBC,0x00,0x80,0x00,0x40,0x00,0x3C,0x00},   // 0x67
{0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x72,0x00,0x8A,0x00,0x86,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x68
{0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x69
{0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x1E,0x00},   // 0x6A
{0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x82,0x00,0x62,0x00,0x12,0x00,0x0E,0x00,0x0A,0x00,0x32,0x00,0x42,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6B
{0x00,0x00,0x3C,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCD,0x00,0x33,0x01,0x11,0x01,0x11,0x01,0x11,0x01,0x11,0x01,0x11,0x01,0x11,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x72,0x00,0x8E,0x00,0x86,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7A,0x00,0x46,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x46,0x00,0x3A,0x00,0x02,0x00,0x02,0x00,0x02,0x00},   // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB8,0x00,0xC4,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xC4,0x00,0xBC,0x00,0x80,0x00,0x80,0x00,0x80,0x00},   // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE4,0x00,0x94,0x00,0x8C,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x02,0x00,0x02,0x00,0x0C,0x00,0x30,0x00,0x40,0x00,0x42,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x73
{0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0xFE,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x62,0x00,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x82,0x00,0x82,0x00,0x42,0x00,0x44,0x00,0x24,0x00,0x28,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x11,0x02,0x32,0x01,0x32,0x01,0x4A,0x01,0x4A,0x01,0xCC,0x00,0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x84,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x48,0x00,0x84,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x02,0x01,0x84,0x00,0x4C,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x10,0x00,0x08,0x00,0x07,0x00},   // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7A
{0x00,0x00,0xE0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x0C,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xE0,0x00,0x00,0x00},   // 0x7B
{0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00},   // 0x7C
{0x00,0x00,0x1C,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0xC0,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x1C,0x00,0x00,0x00},   // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x02,0x31,0x02,0xC1,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x28,0x00,0x44,0x00,0xC6,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7F
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x86,0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x06,0x00,0xF8,0x00,0x40,0x00,0x80,0x00,0xE0,0x00},   // 0x80
{0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x62,0x00,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x81
{0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x82,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x82
{0x00,0x00,0x18,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x83
{0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x84
{0x00,0x00,0x04,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x85
{0x10,0x00,0x28,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x20,0x00,0x40,0x00,0x70,0x00},   // 0x87
{0x00,0x00,0x18,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x82,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x88
{0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x82,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x89
{0x00,0x00,0x08,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x82,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8A
{0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8B
{0x00,0x00,0x18,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8C
{0x00,0x00,0x08,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8D
{0x44,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x28,0x00,0x48,0x00,0x44,0x00,0x84,0x00,0xFE,0x00,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8E
{0x30,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x68,0x00,0x48,0x00,0x48,0x00,0xC4,0x00,0x84,0x00,0xFE,0x01,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8F
{0x20,0x00,0x10,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEF,0x00,0x10,0x01,0x10,0x01,0xFE,0x01,0x13,0x00,0x11,0x00,0x31,0x00,0xEE,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x91
{0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x30,0x00,0x28,0x00,0x28,0x00,0x24,0x00,0xE4,0x00,0x24,0x00,0x3E,0x00,0x22,0x00,0xE1,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x92
{0x00,0x00,0x18,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x93
{0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x94
{0x00,0x00,0x04,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x95
{0x00,0x00,0x18,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x62,0x00,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x96
{0x00,0x00,0x04,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x62,0x00,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x97
{0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x02,0x01,0x84,0x00,0x4C,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x10,0x00,0x08,0x00,0x07,0x00},   // 0x98
{0x44,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x99
{0x44,0x00,0x00,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB8,0x00,0x44,0x00,0xA2,0x00,0x92,0x00,0x92,0x00,0x8A,0x00,0x44,0x00,0x3A,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9B
{0x00,0x00,0xE0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x78,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9C
{0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x01,0x84,0x00,0xC2,0x01,0x42,0x01,0x22,0x01,0x12,0x01,0x0A,0x01,0x0E,0x01,0x84,0x00,0x7A,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x84,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x48,0x00,0x84,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9E
{0xE0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x0E,0x00},   // 0x9F
{0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA0
{0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA1
{0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA2
{0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x00,0x62,0x00,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA3
{0x00,0x00,0x48,0x00,0x34,0x00,0x00,0x00,0x00,0x00,0x72,0x00,0x8E,0x00,0x86,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA4
{0x58,0x00,0x34,0x00,0x00,0x00,0x82,0x00,0x86,0x00,0x8A,0x00,0x8A,0x00,0x92,0x00,0x92,0x00,0xA2,0x00,0xA2,0x00,0xC2,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA5
{0x00,0x00,0x3C,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x44,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA6
{0x00,0x00,0x78,0x00,0x84,0x00,0x84,0x00,0x84,0x00,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x0C,0x00,0x02,0x00,0x82,0x00,0x86,0x00,0xFC,0x00},   // 0xA8
{0x00,0x00,0x38,0x00,0x44,0x00,0xBA,0x00,0xAA,0x00,0xBA,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAA
{0x00,0x00,0x83,0x00,0x42,0x00,0x42,0x00,0x22,0x00,0x12,0x00,0x12,0x00,0xC8,0x01,0x08,0x02,0x04,0x02,0x82,0x01,0x82,0x00,0xC1,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAB
{0x00,0x00,0x83,0x00,0x42,0x00,0x42,0x00,0x22,0x00,0x12,0x00,0x12,0x00,0x88,0x01,0x48,0x01,0x24,0x01,0xE2,0x03,0x02,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00},   // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x01,0x88,0x00,0x44,0x00,0x22,0x00,0x44,0x00,0x88,0x00,0x10,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x00,0x44,0x00,0x88,0x00,0x10,0x01,0x88,0x00,0x44,0x00,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAF
{0xDB,0x00,0xDB,0x00,0x00,0x00,0xDB,0x00,0xDB,0x00,0x00,0x00,0xDB,0x00,0xDB,0x00,0x00,0x00,0x00,0x00,0xDB,0x00,0xDB,0x00,0x00,0x00,0xDB,0x00,0xDB,0x00,0x00,0x00},   // 0xB0
{0x6C,0x03,0x6C,0x03,0xDB,0x00,0xFF,0x03,0x6C,0x03,0xDB,0x00,0xFF,0x03,0x6C,0x03,0xDB,0x00,0xDB,0x00,0x6C,0x03,0xFF,0x03,0xDB,0x00,0x6C,0x03,0xFF,0x03,0xDB,0x00},   // 0xB1
{0xFF,0x03,0xFF,0x03,0xDB,0x00,0xFF,0x03,0xFF,0x03,0xDB,0x00,0xFF,0x03,0xFF,0x03,0xDB,0x00,0xDB,0x00,0xFF,0x03,0xFF,0x03,0xDB,0x00,0xFF,0x03,0xFF,0x03,0xDB,0x00},   // 0xB2
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xB3
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x1F,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xB4
{0x20,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x28,0x00,0x48,0x00,0x44,0x00,0x84,0x00,0xFE,0x00,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB5
{0x30,0x00,0x48,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x28,0x00,0x48,0x00,0x44,0x00,0x84,0x00,0xFE,0x00,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB6
{0x08,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x28,0x00,0x48,0x00,0x44,0x00,0x84,0x00,0xFE,0x00,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB7
{0x00,0x00,0x7C,0x00,0xC6,0x00,0x82,0x00,0x79,0x01,0x0D,0x01,0x05,0x01,0x05,0x01,0x0D,0x01,0x79,0x01,0x82,0x00,0xC6,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB8
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x2F,0x00,0x20,0x00,0x2F,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xB9
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x20,0x00,0x2F,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xBB
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x2F,0x00,0x20,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBC
{0x00,0x00,0x20,0x00,0xF8,0x00,0x24,0x00,0x22,0x00,0x22,0x00,0x22,0x00,0x22,0x00,0x22,0x00,0x22,0x00,0x2C,0x00,0xF8,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBD
{0x00,0x00,0x01,0x02,0x02,0x01,0x84,0x00,0x44,0x00,0x28,0x00,0x10,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xBF
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC0
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xC2
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xF0,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC4
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFF,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xC5
{0x00,0x00,0x48,0x00,0x34,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x78,0x00,0x44,0x00,0x42,0x00,0x62,0x00,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC6
{0x58,0x00,0x34,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x28,0x00,0x48,0x00,0x44,0x00,0x84,0x00,0xFE,0x00,0x02,0x01,0x02,0x01,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC7
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0xE8,0x03,0x08,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x03,0x08,0x00,0xE8,0x03,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xC9
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0xEF,0x03,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0xEF,0x03,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xCB
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0xE8,0x03,0x08,0x00,0xE8,0x03,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCD
{0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0xEF,0x03,0x00,0x00,0xEF,0x03,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00,0x28,0x00},   // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0xFC,0x00,0x84,0x00,0x84,0x00,0x84,0x00,0x84,0x00,0xFC,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCF
{0x00,0x00,0x2E,0x00,0x18,0x00,0x2C,0x00,0x40,0x00,0x78,0x00,0xC4,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD0
{0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x42,0x00,0x82,0x00,0x82,0x00,0x8F,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x42,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD1
{0x30,0x00,0x48,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD2
{0x44,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD3
{0x10,0x00,0x20,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD5
{0x20,0x00,0x10,0x00,0x00,0x00,0xFE,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD6
{0x30,0x00,0x48,0x00,0x00,0x00,0xFE,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD7
{0x44,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD8
{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00},   // 0xDA
{0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03},   // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03},   // 0xDC
{0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00},   // 0xDD
{0x08,0x00,0x10,0x00,0x00,0x00,0xFE,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDE
{0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDF
{0x20,0x00,0x10,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE0
{0x00,0x00,0x1C,0x00,0x22,0x00,0x22,0x00,0x22,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x22,0x00,0x42,0x00,0x82,0x00,0x82,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE1
{0x30,0x00,0x48,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE2
{0x08,0x00,0x10,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE3
{0x00,0x00,0x48,0x00,0x34,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x44,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE4
{0x58,0x00,0x34,0x00,0x00,0x00,0x78,0x00,0x84,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x84,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0xC6,0x00,0xBA,0x00,0x02,0x00,0x02,0x00,0x02,0x00},   // 0xE6
{0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7A,0x00,0x46,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x46,0x00,0x3A,0x00,0x02,0x00,0x02,0x00,0x02,0x00},   // 0xE7
{0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x7E,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x42,0x00,0x3E,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE8
{0x20,0x00,0x10,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE9
{0x30,0x00,0x48,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEA
{0x08,0x00,0x10,0x00,0x00,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x44,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEB
{0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x02,0x01,0x84,0x00,0x4C,0x00,0x48,0x00,0x30,0x00,0x30,0x00,0x10,0x00,0x08,0x00,0x07,0x00},   // 0xEC
{0x20,0x00,0x10,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x84,0x00,0x44,0x00,0x28,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xED
{0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0x10,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0xFE,0x01,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0xFF,0x03},   // 0xF2
{0x00,0x00,0x0F,0x02,0x08,0x01,0x86,0x00,0x4C,0x00,0x48,0x00,0x27,0x00,0x90,0x01,0x48,0x01,0x28,0x01,0xE4,0x03,0x02,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF3
{0x00,0x00,0xFC,0x00,0x9E,0x00,0x9E,0x00,0x9E,0x00,0x9C,0x00,0x98,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x00,0x00},   // 0xF4
{0x00,0x00,0xF8,0x00,0x04,0x00,0x04,0x00,0x0C,0x00,0x38,0x00,0x64,0x00,0x84,0x00,0x8C,0x00,0xB8,0x00,0x60,0x00,0xC0,0x00,0x80,0x00,0x84,0x00,0x7C,0x00,0x00,0x00},   // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x40,0x00,0x70,0x00},   // 0xF7
{0x00,0x00,0x30,0x00,0x48,0x00,0x48,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF8
{0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFA
{0x00,0x00,0x18,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFB
{0x00,0x00,0x7C,0x00,0x40,0x00,0x38,0x00,0x40,0x00,0x40,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFC
{0x00,0x00,0x3C,0x00,0x40,0x00,0x40,0x00,0x30,0x00,0x08,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_12X16
__UG_FONT_DATA unsigned char font_12x16[256][32]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0xE0,0x00,0x18,0x03,0x04,0x04,0x04,0x04,0xB2,0x09,0xB2,0x09,0x02,0x08,0x02,0x08,0x12,0x09,0xE2,0x08,0x04,0x04,0x04,0x04,0x18,0x03,0xE0,0x00,0x00,0x00,0x00,0x00},   // 0x01
{0xE0,0x00,0xF8,0x03,0xFC,0x07,0xFC,0x07,0x4E,0x0E,0x4E,0x0E,0xFE,0x0F,0xFE,0x0F,0xEE,0x0E,0x1E,0x0F,0xFC,0x07,0xFC,0x07,0xF8,0x03,0xE0,0x00,0x00,0x00,0x00,0x00},   // 0x02
{0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x03,0xBC,0x07,0xFC,0x07,0xFC,0x07,0xFC,0x07,0xF8,0x03,0xF0,0x01,0xE0,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x03
{0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0xFC,0x07,0xF8,0x03,0xF0,0x01,0xE0,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x04
{0x00,0x00,0x00,0x00,0xE0,0x00,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xEC,0x06,0xFE,0x0F,0xFE,0x0F,0xFE,0x0F,0x4C,0x06,0xE0,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x05
{0x00,0x00,0x00,0x00,0x40,0x00,0x40,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0xFC,0x07,0xFC,0x07,0xFC,0x07,0x58,0x03,0xE0,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x06,0x78,0x05,0xCC,0x04,0x86,0x01,0x86,0x01,0x86,0x01,0xCC,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0B
{0x00,0x00,0x00,0x00,0xE0,0x01,0x30,0x03,0x18,0x06,0x18,0x06,0x18,0x06,0x30,0x03,0xE0,0x01,0xC0,0x00,0xC0,0x00,0xF0,0x03,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0x30,0x00,0x70,0x00,0xD0,0x00,0x90,0x01,0x30,0x03,0x70,0x02,0xD0,0x02,0x90,0x03,0x1C,0x03,0x1E,0x02,0x1E,0x02,0x8C,0x03,0xC0,0x03,0xC0,0x03,0x80,0x01,0x00,0x00},   // 0x0E
{0x00,0x00,0x40,0x00,0x40,0x00,0xE4,0x04,0xF8,0x03,0x18,0x03,0x0C,0x06,0x0E,0x0E,0x0C,0x06,0x18,0x03,0xF8,0x03,0xE4,0x04,0x40,0x00,0x40,0x00,0x00,0x00,0x00,0x00},   // 0x0F
{0x00,0x00,0x00,0x00,0x08,0x00,0x18,0x00,0x38,0x00,0x78,0x00,0xF8,0x00,0xF8,0x01,0xF8,0x00,0x78,0x00,0x38,0x00,0x18,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x10
{0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0xC0,0x01,0xE0,0x01,0xF0,0x01,0xF8,0x01,0xF0,0x01,0xE0,0x01,0xC0,0x01,0x80,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x11
{0x00,0x00,0x40,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0xF8,0x03,0xF0,0x01,0xE0,0x00,0x40,0x00,0x00,0x00,0x00,0x00},   // 0x12
{0x00,0x00,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00},   // 0x13
{0x00,0x00,0xF8,0x07,0x6C,0x03,0x66,0x03,0x66,0x03,0x66,0x03,0x6C,0x03,0x78,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x00,0x00,0x00,0x00},   // 0x14
{0x00,0x00,0xF8,0x01,0x0C,0x03,0x0C,0x00,0x0C,0x00,0xF8,0x01,0x0C,0x03,0x0C,0x03,0xF8,0x01,0x00,0x03,0x00,0x03,0x0C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x07,0xF8,0x07,0xF8,0x07,0x00,0x00,0x00,0x00},   // 0x16
{0x40,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0xF8,0x03,0xF0,0x01,0xE0,0x00,0x40,0x00,0xF8,0x03,0x00,0x00},   // 0x17
{0x00,0x00,0x40,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x00,0x00,0x00,0x00},   // 0x18
{0x00,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0xF8,0x03,0xF0,0x01,0xE0,0x00,0x40,0x00,0x00,0x00,0x00,0x00},   // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x80,0x03,0xFC,0x07,0x80,0x03,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x30,0x00,0x38,0x00,0xFC,0x07,0x38,0x00,0x30,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x01,0x18,0x03,0x1C,0x07,0xFE,0x0F,0x1C,0x07,0x18,0x03,0x10,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0xFC,0x07,0xFE,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x0F,0xFC,0x07,0xF8,0x03,0xF0,0x01,0xE0,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x21
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x00,0x00,0x60,0x06,0x60,0x06,0x60,0x06,0xFC,0x0F,0x30,0x03,0x30,0x03,0x98,0x01,0x98,0x01,0xFE,0x03,0xCC,0x00,0xCC,0x00,0xCC,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x23
{0x60,0x00,0x60,0x00,0xF8,0x01,0xFC,0x03,0x6C,0x00,0x6C,0x00,0xFC,0x01,0xF8,0x03,0x60,0x03,0x60,0x03,0xFC,0x03,0xF8,0x01,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x24
{0x00,0x00,0x00,0x00,0x00,0x08,0x1C,0x0C,0x1C,0x0E,0x1C,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x07,0x0E,0x07,0x06,0x07,0x00,0x00,0x00,0x00},   // 0x25
{0x00,0x00,0xE0,0x00,0xB0,0x01,0x98,0x01,0x98,0x01,0xD8,0x00,0x70,0x00,0x78,0x00,0x7C,0x00,0xCC,0x06,0xCC,0x03,0x8C,0x01,0xDC,0x03,0x78,0x06,0x00,0x00,0x00,0x00},   // 0x26
{0x70,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0xC0,0x01,0x60,0x00,0x70,0x00,0x30,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x30,0x00,0x70,0x00,0x60,0x00,0xC0,0x01,0x00,0x00,0x00,0x00},   // 0x28
{0x38,0x00,0x60,0x00,0xE0,0x00,0xC0,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0xE0,0x00,0x60,0x00,0x38,0x00,0x00,0x00,0x00,0x00},   // 0x29
{0x00,0x00,0x00,0x00,0x00,0x00,0x6C,0x03,0x6C,0x03,0xF8,0x01,0xF0,0x00,0xFC,0x03,0xF0,0x00,0xF8,0x01,0x6C,0x03,0x6C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFC,0x03,0xFC,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x30,0x00},   // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00},   // 0x2E
{0x00,0x00,0x00,0x08,0x00,0x0C,0x00,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2F
{0xF0,0x01,0xFC,0x07,0x0C,0x06,0x06,0x0E,0x06,0x0F,0x86,0x0D,0xC6,0x0C,0x66,0x0C,0x36,0x0C,0x1E,0x0C,0x0E,0x0C,0x0C,0x06,0xFC,0x07,0xF0,0x01,0x00,0x00,0x00,0x00},   // 0x30
{0xC0,0x00,0xE0,0x00,0xF8,0x00,0xF8,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xF8,0x07,0xF8,0x07,0x00,0x00,0x00,0x00},   // 0x31
{0xF8,0x03,0xFC,0x07,0x0E,0x0E,0x06,0x0C,0x06,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0xFE,0x0F,0xFE,0x0F,0x00,0x00,0x00,0x00},   // 0x32
{0xF8,0x03,0xFC,0x07,0x0E,0x0E,0x06,0x0C,0x00,0x0C,0x00,0x0E,0xF0,0x07,0xF0,0x03,0x00,0x06,0x00,0x0C,0x06,0x0C,0x0E,0x0E,0xFC,0x07,0xF8,0x03,0x00,0x00,0x00,0x00},   // 0x33
{0x80,0x03,0xC0,0x03,0xE0,0x03,0x70,0x03,0x38,0x03,0x1C,0x03,0x0E,0x03,0x06,0x03,0xFE,0x0F,0xFE,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00},   // 0x34
{0xFE,0x0F,0xFE,0x0F,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x03,0xFC,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x06,0x0C,0x0E,0x0E,0xFC,0x07,0xF8,0x03,0x00,0x00,0x00,0x00},   // 0x35
{0xC0,0x03,0xE0,0x03,0x70,0x00,0x38,0x00,0x1C,0x00,0x0C,0x00,0xFE,0x03,0xFE,0x07,0x0E,0x0E,0x06,0x0C,0x06,0x0C,0x0E,0x0E,0xFC,0x07,0xF8,0x03,0x00,0x00,0x00,0x00},   // 0x36
{0xFE,0x0F,0xFE,0x0F,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x80,0x01,0x80,0x01,0xC0,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00},   // 0x37
{0xF0,0x01,0xF8,0x03,0x1C,0x07,0x0C,0x06,0x0C,0x06,0x1C,0x07,0xF8,0x03,0xFC,0x07,0x0E,0x0E,0x06,0x0C,0x06,0x0C,0x0E,0x0E,0xFC,0x07,0xF8,0x03,0x00,0x00,0x00,0x00},   // 0x38
{0xF8,0x03,0xFC,0x07,0x0E,0x0E,0x06,0x0C,0x06,0x0C,0x0E,0x0E,0xFC,0x0F,0xF8,0x0F,0x00,0x06,0x00,0x07,0x80,0x03,0xC0,0x01,0xF8,0x00,0x78,0x00,0x00,0x00,0x00,0x00},   // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x30,0x00},   // 0x3B
{0x00,0x03,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x1C,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x03,0x00,0x00,0x00,0x00},   // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3D
{0x0C,0x00,0x1C,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00},   // 0x3E
{0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x3F
{0xF8,0x03,0xFC,0x07,0x0C,0x06,0xE6,0x0D,0xF6,0x0D,0xB6,0x0D,0xB6,0x0D,0xB6,0x0D,0xB6,0x0D,0xF6,0x07,0xE6,0x03,0x0E,0x00,0xFC,0x03,0xF0,0x03,0x00,0x00,0x00,0x00},   // 0x40
{0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFC,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x41
{0xFE,0x00,0xFE,0x01,0x86,0x03,0x06,0x03,0x06,0x03,0x86,0x03,0xFE,0x01,0xFE,0x03,0x06,0x07,0x06,0x06,0x06,0x06,0x06,0x07,0xFE,0x03,0xFE,0x01,0x00,0x00,0x00,0x00},   // 0x42
{0xF0,0x01,0xF8,0x03,0x1C,0x07,0x0C,0x06,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x06,0x1C,0x07,0xF8,0x03,0xF0,0x01,0x00,0x00,0x00,0x00},   // 0x43
{0xFE,0x00,0xFE,0x01,0x86,0x03,0x06,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x86,0x03,0xFE,0x01,0xFE,0x00,0x00,0x00,0x00,0x00},   // 0x44
{0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x01,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0x45
{0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x01,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00},   // 0x46
{0xF0,0x03,0xF8,0x07,0x1C,0x06,0x0C,0x00,0x06,0x00,0x06,0x00,0xC6,0x07,0xC6,0x07,0x06,0x06,0x06,0x06,0x0C,0x06,0x1C,0x06,0xF8,0x07,0xF0,0x07,0x00,0x00,0x00,0x00},   // 0x47
{0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xFE,0x07,0xFE,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x48
{0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x49
{0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x06,0x06,0x06,0x06,0x0E,0x03,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x4A
{0x06,0x06,0x06,0x07,0x86,0x03,0xC6,0x01,0xE6,0x00,0x76,0x00,0x3E,0x00,0x3E,0x00,0x76,0x00,0xE6,0x00,0xC6,0x01,0x86,0x03,0x06,0x07,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x4B
{0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0x4C
{0x06,0x06,0x0E,0x07,0x0E,0x07,0x9E,0x07,0x9E,0x07,0xF6,0x06,0xF6,0x06,0x66,0x06,0x66,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x4D
{0x06,0x06,0x0E,0x06,0x0E,0x06,0x1E,0x06,0x36,0x06,0x36,0x06,0x66,0x06,0x66,0x06,0xC6,0x06,0xC6,0x06,0x86,0x07,0x06,0x07,0x06,0x07,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x4E
{0xF0,0x00,0xF8,0x01,0x9C,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0x9C,0x03,0xF8,0x01,0xF0,0x00,0x00,0x00,0x00,0x00},   // 0x4F
{0xFE,0x01,0xFE,0x03,0x06,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x07,0xFE,0x03,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00},   // 0x50
{0xF0,0x00,0xF8,0x01,0x9C,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xC6,0x06,0xCC,0x03,0x9C,0x03,0xF8,0x07,0xF0,0x06,0x00,0x00,0x00,0x00},   // 0x51
{0xFE,0x01,0xFE,0x03,0x06,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x07,0xFE,0x03,0xFE,0x01,0xE6,0x00,0xC6,0x01,0x86,0x03,0x06,0x07,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x52
{0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x00,0x0E,0x00,0xFC,0x01,0xF8,0x03,0x00,0x07,0x00,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x53
{0xFC,0x03,0xFC,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x54
{0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x55
{0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x56
{0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x06,0x66,0x06,0xF6,0x06,0x9E,0x07,0x0E,0x07,0x0E,0x07,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x57
{0x06,0x06,0x06,0x06,0x0C,0x03,0x0C,0x03,0x98,0x01,0xF0,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x0C,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x58
{0x06,0x06,0x06,0x06,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x59
{0xFE,0x07,0xFE,0x07,0x00,0x03,0x00,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0x5A
{0xF8,0x01,0xF8,0x01,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x5B
{0x00,0x00,0x02,0x00,0x06,0x00,0x0E,0x00,0x1C,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5C
{0xF8,0x01,0xF8,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x5D
{0x40,0x00,0xE0,0x00,0xF0,0x01,0xB8,0x03,0x1C,0x07,0x0E,0x0E,0x06,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x0F,0xFE,0x0F},   // 0x5F
{0x00,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0x61
{0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xF6,0x01,0xFE,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x07,0xFE,0x03,0xFE,0x01,0x00,0x00,0x00,0x00},   // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x06,0x06,0x00,0x06,0x00,0x06,0x00,0x0E,0x06,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x63
{0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0xF8,0x06,0xFC,0x07,0x8E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x06,0xFC,0x07,0xF8,0x07,0x00,0x00,0x00,0x00},   // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x06,0xFE,0x07,0xFE,0x03,0x06,0x00,0x0E,0x00,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x65
{0xE0,0x01,0xF0,0x01,0x38,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xFE,0x00,0xFE,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00},   // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x07,0xFC,0x07,0x0E,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x06,0x00,0x07,0xFC,0x03,0xFC,0x01},   // 0x67
{0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xF6,0x00,0xFE,0x01,0x8E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00},   // 0x68
{0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x69
{0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x00,0x00,0xC0,0x01,0xC0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x98,0x01,0xF8,0x01,0xF0,0x00},   // 0x6A
{0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x8C,0x01,0xCC,0x01,0xEC,0x00,0x7C,0x00,0x7C,0x00,0xEC,0x00,0xCC,0x01,0x8C,0x03,0x0C,0x03,0x00,0x00,0x00,0x00},   // 0x6B
{0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x01,0xFE,0x03,0xFE,0x07,0x66,0x06,0x66,0x06,0x66,0x06,0x66,0x06,0x66,0x06,0x66,0x06,0x00,0x00,0x00,0x00},   // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0xFC,0x03,0x0C,0x07,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x00,0x00,0x00,0x00},   // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0xFE,0x03,0x06,0x07,0x06,0x06,0x06,0x06,0x0E,0x07,0xFE,0x03,0xF6,0x01,0x06,0x00,0x06,0x00,0x06,0x00},   // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x07,0xFC,0x07,0x0E,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x06,0x00,0x06,0x00,0x06},   // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEC,0x03,0xFC,0x07,0x1C,0x06,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00},   // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xFE,0x01,0x06,0x00,0xFE,0x00,0xFC,0x01,0x80,0x01,0x80,0x01,0xFE,0x01,0xFC,0x00,0x00,0x00,0x00,0x00},   // 0x73
{0x00,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xFE,0x00,0xFE,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x01,0xF0,0x01,0x00,0x00,0x00,0x00},   // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x00,0x00,0x00},   // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x66,0x06,0x66,0x06,0x66,0x06,0x66,0x06,0x66,0x06,0xF6,0x06,0xFC,0x03,0x9C,0x03,0x08,0x01,0x00,0x00,0x00,0x00},   // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x8E,0x03,0xDC,0x01,0xF8,0x00,0x70,0x00,0xF8,0x00,0xDC,0x01,0x8E,0x03,0x06,0x03,0x00,0x00,0x00,0x00},   // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00},   // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xFE,0x01,0xC0,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0xFE,0x03,0xFE,0x03,0x00,0x00,0x00,0x00},   // 0x7A
{0xC0,0x03,0xE0,0x03,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x38,0x00,0x1C,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x70,0x00,0xE0,0x03,0xC0,0x03,0x00,0x00},   // 0x7B
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0x7C
{0x3C,0x00,0x7C,0x00,0xE0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x01,0x80,0x03,0xC0,0x01,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xE0,0x00,0x7C,0x00,0x3C,0x00,0x00,0x00},   // 0x7D
{0x00,0x00,0x00,0x00,0x38,0x06,0x6C,0x03,0xC6,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x0C,0x03,0x06,0x06,0x06,0x06,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7F
{0xF0,0x01,0xF8,0x03,0x1C,0x07,0x0C,0x06,0x06,0x06,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x06,0x1C,0x07,0xF8,0x03,0xF0,0x01,0x60,0x00,0x78,0x00,0x78,0x00},   // 0x80
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x00,0x00,0x00},   // 0x81
{0x00,0x00,0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x06,0xFE,0x07,0xFE,0x07,0x06,0x00,0x0E,0x00,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x82
{0x00,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0x83
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0x84
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0x85
{0x00,0x00,0x60,0x00,0x90,0x00,0x60,0x00,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x00,0x06,0x00,0x06,0x00,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x60,0x00,0x78,0x00},   // 0x87
{0x00,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x06,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x88
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x06,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x89
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x06,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x8A
{0x00,0x00,0x00,0x00,0xD8,0x00,0xD8,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x8B
{0x00,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x00,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x8C
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x8D
{0x98,0x01,0x98,0x01,0x00,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x8E
{0x60,0x00,0x90,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0x8F
{0x80,0x01,0xC0,0x00,0x60,0x00,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFE,0x01,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xBC,0x03,0x66,0x06,0x60,0x06,0xFC,0x03,0x66,0x00,0x66,0x00,0x66,0x06,0xDC,0x03,0x00,0x00,0x00,0x00},   // 0x91
{0xE0,0x07,0xE0,0x07,0xF0,0x00,0xF0,0x00,0xF8,0x00,0xD8,0x00,0xD8,0x03,0xCC,0x03,0xCC,0x00,0xFC,0x00,0xFE,0x00,0xC6,0x00,0xC6,0x07,0xC6,0x07,0x00,0x00,0x00,0x00},   // 0x92
{0x00,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x93
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x94
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x95
{0x00,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x00,0x00,0x00},   // 0x96
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x00,0x00,0x00},   // 0x97
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00},   // 0x98
{0x98,0x01,0x98,0x01,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0x99
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x00,0x00,0x00},   // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x06,0xFC,0x03,0x8E,0x07,0xC6,0x06,0x66,0x06,0x36,0x06,0x1E,0x07,0xFC,0x03,0xF6,0x01,0x00,0x00,0x00,0x00},   // 0x9B
{0x00,0x00,0x00,0x00,0xE0,0x01,0xF0,0x03,0x30,0x03,0x30,0x00,0x30,0x00,0xF8,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0xFC,0x07,0xDC,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9C
{0x00,0x00,0x00,0x00,0xF8,0x06,0xFC,0x03,0x8E,0x07,0xC6,0x06,0xC6,0x06,0x66,0x06,0x66,0x06,0x36,0x06,0x36,0x06,0x1E,0x07,0xFC,0x03,0xF6,0x01,0x00,0x00,0x00,0x00},   // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x03,0x98,0x01,0xF0,0x00,0x60,0x00,0xF0,0x00,0x98,0x01,0x0C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9E
{0xC0,0x01,0xE0,0x03,0x60,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x6C,0x00,0x7C,0x00,0x38,0x00,0x00,0x00},   // 0x9F
{0x00,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0xA0
{0x00,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xA1
{0x00,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xA2
{0x00,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x07,0xF8,0x06,0x00,0x00,0x00,0x00},   // 0xA3
{0x00,0x00,0x00,0x00,0x70,0x03,0xD8,0x01,0x00,0x00,0xFC,0x01,0xFC,0x03,0x0C,0x07,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x06,0x00,0x00,0x00,0x00},   // 0xA4
{0x70,0x03,0xD8,0x01,0x00,0x00,0x06,0x06,0x0E,0x06,0x1E,0x06,0x3E,0x06,0x76,0x06,0xE6,0x06,0xC6,0x07,0x86,0x07,0x06,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0xA5
{0xF8,0x03,0xFC,0x07,0x00,0x06,0xFC,0x07,0xFE,0x07,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA6
{0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA7
{0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xA8
{0x00,0x00,0x00,0x00,0xF8,0x03,0xFC,0x07,0x0E,0x0E,0xF6,0x0C,0xB6,0x0D,0xF6,0x0C,0xB6,0x0D,0xB6,0x0D,0x0E,0x0E,0xFC,0x07,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x07,0xFF,0x07,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAA
{0x00,0x00,0x00,0x00,0x0C,0x00,0x0E,0x00,0x0C,0x03,0x8C,0x01,0xDE,0x00,0x60,0x00,0xB0,0x03,0x18,0x06,0x0C,0x03,0x80,0x01,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAB
{0x00,0x00,0x00,0x00,0x0C,0x00,0x0E,0x00,0x0C,0x03,0x8C,0x01,0xDE,0x00,0x60,0x00,0xB0,0x06,0xD8,0x06,0xCC,0x07,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAC
{0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x03,0x8C,0x01,0xC6,0x00,0x8C,0x01,0x18,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC6,0x00,0x8C,0x01,0x18,0x03,0x8C,0x01,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAF
{0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04,0x11,0x01,0x44,0x04},   // 0xB0
{0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05,0xAA,0x0A,0x55,0x05},   // 0xB1
{0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B,0xEE,0x0E,0xBB,0x0B},   // 0xB2
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xB3
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x00,0x7F,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xB4
{0xC0,0x00,0x60,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0xB5
{0x60,0x00,0xF0,0x00,0x98,0x01,0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0xB6
{0x30,0x00,0x60,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0xB7
{0x00,0x00,0x00,0x00,0xF8,0x03,0xFC,0x07,0x0E,0x0E,0xE6,0x0C,0xB6,0x0D,0x36,0x0C,0xB6,0x0D,0xE6,0x0C,0x0E,0x0E,0xFC,0x07,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB8
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6F,0x00,0x6F,0x00,0x60,0x00,0x6F,0x00,0x6F,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xB9
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x7F,0x00,0x60,0x00,0x6F,0x00,0x6F,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xBB
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6F,0x00,0x6F,0x00,0x60,0x00,0x7F,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBC
{0x00,0x00,0x60,0x00,0x60,0x00,0xF0,0x01,0xF8,0x03,0x7C,0x03,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x7C,0x03,0xF8,0x03,0xF0,0x01,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0xBD
{0x06,0x06,0x06,0x06,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0xFC,0x03,0x60,0x00,0xFC,0x03,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x7F,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xBF
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x0F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC0
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xC2
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x0F,0xE0,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC4
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xC5
{0x00,0x00,0x00,0x00,0x70,0x03,0xD8,0x01,0x00,0x00,0xF8,0x03,0xFC,0x07,0x00,0x06,0xF8,0x07,0xFC,0x07,0x06,0x06,0x06,0x06,0xFE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00},   // 0xC6
{0x70,0x03,0xD8,0x01,0x00,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0x98,0x01,0x98,0x01,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00},   // 0xC7
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0xEC,0x0F,0xEC,0x0F,0x0C,0x00,0xFC,0x0F,0xFC,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0xFC,0x0F,0x0C,0x00,0xEC,0x0F,0xEC,0x0F,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xC9
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0xEF,0x0F,0xEF,0x0F,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0xEF,0x0F,0xEF,0x0F,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xCB
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0xEC,0x0F,0xEC,0x0F,0x0C,0x00,0xEC,0x0F,0xEC,0x0F,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCD
{0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0xEF,0x0F,0xEF,0x0F,0x00,0x00,0xEF,0x0F,0xEF,0x0F,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x6C,0x00},   // 0xCE
{0x00,0x00,0x06,0x06,0xF6,0x06,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF6,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCF
{0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0x18,0x01,0x18,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,0xF0,0x01,0x98,0x01,0x98,0x01,0xF8,0x01,0xF0,0x00,0x00,0x00,0x00,0x00},   // 0xD0
{0xFC,0x00,0xFC,0x01,0x8C,0x03,0x0C,0x03,0x0C,0x06,0x0C,0x06,0x1E,0x06,0x1E,0x06,0x0C,0x06,0x0C,0x06,0x0C,0x03,0x8C,0x03,0xFC,0x01,0xFC,0x00,0x00,0x00,0x00,0x00},   // 0xD1
{0x60,0x00,0xF0,0x00,0x98,0x01,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFE,0x01,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0xD2
{0x98,0x01,0x98,0x01,0x00,0x00,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFE,0x01,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0xD3
{0x18,0x00,0x30,0x00,0x60,0x00,0xFE,0x07,0xFE,0x07,0x06,0x00,0x06,0x00,0xFE,0x01,0xFE,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00},   // 0xD4
{0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD5
{0x80,0x01,0xC0,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xD6
{0x60,0x00,0xF0,0x00,0x98,0x01,0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xD7
{0x98,0x01,0x98,0x01,0x00,0x00,0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xD8
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xE0,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},   // 0xDA
{0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F},   // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F},   // 0xDC
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0xDD
{0x18,0x00,0x30,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xDE
{0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDF
{0x80,0x01,0xC0,0x00,0x60,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xE0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x98,0x01,0x0C,0x03,0x0C,0x03,0xFC,0x01,0x8C,0x03,0x0C,0x03,0x0C,0x03,0x8C,0x03,0xFC,0x01,0x0C,0x00,0x0C,0x00},   // 0xE1
{0x60,0x00,0xF0,0x00,0x98,0x01,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xE2
{0x18,0x00,0x30,0x00,0x60,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xE3
{0x00,0x00,0x00,0x00,0xB8,0x01,0xEC,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xE4
{0x70,0x03,0xD8,0x01,0x00,0x00,0xF8,0x01,0xFC,0x03,0x0E,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFE,0x03,0x7E,0x03,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00},   // 0xE6
{0x00,0x00,0x00,0x00,0x3C,0x00,0x3C,0x00,0x18,0x00,0xF8,0x01,0xF8,0x03,0x18,0x03,0x18,0x03,0xF8,0x03,0xF8,0x01,0x18,0x00,0x3C,0x00,0x3C,0x00,0x00,0x00,0x00,0x00},   // 0xE7
{0x3C,0x00,0x3C,0x00,0x18,0x00,0xF8,0x01,0xF8,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0xF8,0x03,0xF8,0x01,0x18,0x00,0x3C,0x00,0x3C,0x00,0x00,0x00,0x00,0x00},   // 0xE8
{0x80,0x01,0xC0,0x00,0x60,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xE9
{0x60,0x00,0xF0,0x00,0x98,0x01,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xEA
{0x18,0x00,0x30,0x00,0x60,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF8,0x01,0x00,0x00,0x00,0x00},   // 0xEB
{0x00,0x00,0x00,0x00,0x80,0x01,0xC0,0x00,0x60,0x00,0x0C,0x03,0x0C,0x03,0x98,0x01,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00},   // 0xEC
{0x80,0x01,0xC0,0x00,0x60,0x00,0x06,0x06,0x0C,0x03,0x98,0x01,0xF0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00},   // 0xED
{0x00,0x00,0x00,0x00,0xE0,0x01,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF2
{0x00,0x00,0x00,0x00,0x0E,0x00,0x18,0x00,0x0C,0x03,0x98,0x01,0xCE,0x00,0x60,0x00,0xB0,0x06,0xD8,0x06,0xCC,0x07,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF3
{0x00,0x00,0xF8,0x07,0x6C,0x03,0x66,0x03,0x66,0x03,0x66,0x03,0x6C,0x03,0x78,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x00,0x00,0x00,0x00},   // 0xF4
{0x00,0x00,0xF8,0x01,0x0C,0x03,0x0C,0x00,0x0C,0x00,0xF8,0x01,0x0C,0x03,0x0C,0x03,0xF8,0x01,0x00,0x03,0x00,0x03,0x0C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC8,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF7
{0xF0,0x00,0xF8,0x01,0x98,0x01,0x98,0x01,0xF8,0x01,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x01,0x9C,0x03,0x9C,0x03,0x08,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0xE0,0x00,0xE0,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFA
{0x18,0x00,0x1C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFB
{0x3C,0x00,0x60,0x00,0x38,0x00,0x60,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFC
{0x3C,0x00,0x60,0x00,0x38,0x00,0x0C,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_12X20
__UG_FONT_DATA unsigned char font_12x20[256][40]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x00
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x08,0x01,0x04,0x02,0xF2,0x04,0xF2,0x04,0x02,0x04,0x0A,0x05,0x0A,0x05,0xF4,0x02,0x08,0x01,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x01
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0xFC,0x03,0x66,0x06,0x66,0x06,0xFE,0x07,0xF6,0x06,0xF6,0x06,0x0C,0x03,0xF8,0x01,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x02
{0x00,0x00,0x00,0x00,0x9E,0x07,0xFE,0x07,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFE,0x07,0xFE,0x07,0xFC,0x03,0xF8,0x01,0xF8,0x01,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x03
{0x00,0x00,0x00,0x00,0x40,0x00,0x60,0x00,0xF0,0x00,0xF0,0x01,0xFC,0x03,0xFE,0x07,0xFF,0x0F,0xFE,0x07,0xFC,0x03,0xF8,0x01,0xF0,0x01,0xE0,0x00,0x60,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x04
{0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF0,0x00,0xFE,0x07,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0x5E,0x07,0x40,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x05
{0x00,0x00,0x00,0x00,0x40,0x00,0x60,0x00,0xE0,0x00,0xF0,0x01,0xF8,0x03,0xFC,0x07,0xFE,0x07,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0x5E,0x07,0x40,0x00,0xE0,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0A
{0x00,0x00,0x00,0x00,0x00,0x07,0xC0,0x07,0x00,0x07,0x80,0x0D,0xF8,0x00,0xFE,0x01,0x86,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x86,0x01,0xFE,0x01,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0B
{0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x0E,0x07,0xFC,0x03,0xF8,0x01,0x60,0x00,0xF8,0x01,0xF8,0x01,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0D
{0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x07,0xC0,0x07,0xF0,0x04,0x30,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x90,0x07,0xD0,0x03,0xD0,0x01,0x1E,0x00,0x0F,0x00,0x07,0x00,0x00,0x00},  // 0x0E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x64,0x00,0xFE,0x03,0xFC,0x01,0x8C,0x01,0x8F,0x07,0x8F,0x07,0xDC,0x01,0xFC,0x01,0xFE,0x03,0x64,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x0E,0x00,0x3E,0x00,0x7E,0x00,0xFE,0x01,0xFE,0x07,0xFE,0x01,0xFE,0x00,0x3E,0x00,0x1E,0x00,0x06,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x10
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x07,0xC0,0x07,0xE0,0x07,0xF8,0x07,0xFE,0x07,0xF8,0x07,0xF0,0x07,0xC0,0x07,0x80,0x07,0x00,0x06,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x11
{0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0x68,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x68,0x01,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00},  // 0x12
{0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x13
{0x00,0x00,0x00,0x00,0xFC,0x03,0x3E,0x02,0x3E,0x02,0x3E,0x02,0x3E,0x02,0x3C,0x02,0x38,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x00,0x00},  // 0x14
{0x00,0x00,0x00,0x00,0xF0,0x01,0xF8,0x01,0x0C,0x00,0x0C,0x00,0x1C,0x00,0xF0,0x00,0xC8,0x01,0x8C,0x03,0x0C,0x03,0x1C,0x03,0xF8,0x01,0xE0,0x01,0x80,0x03,0x00,0x03,0x04,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00},  // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x16
{0x00,0x00,0x60,0x00,0xF0,0x00,0x68,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x68,0x01,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01},  // 0x17
{0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0x68,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00},  // 0x18
{0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x68,0x01,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00},  // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x01,0xFE,0x03,0xFE,0x03,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x08,0x00,0xFC,0x07,0xFC,0x07,0x08,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x00,0x08,0x01,0xFC,0x03,0xFC,0x03,0x08,0x01,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x40,0x00,0x60,0x00,0xE0,0x00,0xF0,0x00,0xF0,0x01,0xF0,0x01,0xF8,0x01,0xF8,0x03,0xFC,0x03,0xFC,0x03,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFC,0x03,0xFC,0x03,0xF8,0x03,0xF8,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xE0,0x00,0x60,0x00,0x40,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x20
{0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x21
{0x00,0x00,0x8C,0x01,0x8C,0x01,0x8C,0x01,0x8C,0x01,0x8C,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x22
{0x00,0x00,0x00,0x00,0x20,0x02,0x20,0x02,0x10,0x01,0x10,0x01,0x10,0x01,0xFE,0x0F,0x88,0x00,0x88,0x00,0x88,0x00,0xFE,0x07,0x44,0x00,0x44,0x00,0x22,0x00,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x23
{0x00,0x00,0x40,0x00,0xF0,0x01,0xF8,0x03,0x4C,0x02,0x4C,0x00,0x4C,0x00,0x78,0x00,0x70,0x00,0xC0,0x01,0xC0,0x01,0x40,0x03,0x40,0x03,0x44,0x03,0xFC,0x01,0xF8,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x24
{0x00,0x00,0x00,0x00,0x1E,0x08,0x33,0x04,0x33,0x02,0x33,0x01,0xB3,0x00,0xB3,0x00,0x5E,0x00,0xA0,0x07,0xD0,0x0C,0xD0,0x0C,0xC8,0x0C,0xC4,0x0C,0xC2,0x0C,0x81,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x25
{0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0x98,0x01,0x98,0x01,0xD8,0x00,0x70,0x00,0x3C,0x00,0x66,0x0C,0xE3,0x0C,0xC3,0x0C,0x83,0x07,0x87,0x07,0xFE,0x07,0xFC,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x26
{0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x27
{0x00,0x00,0x00,0x03,0xC0,0x03,0xE0,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0xE0,0x00,0xC0,0x03,0x00,0x03,0x00,0x00},  // 0x28
{0x00,0x00,0x0C,0x00,0x3C,0x00,0x70,0x00,0x60,0x00,0xC0,0x00,0xC0,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xC0,0x00,0xC0,0x00,0x60,0x00,0x70,0x00,0x3C,0x00,0x0C,0x00,0x00,0x00},  // 0x29
{0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x36,0x03,0xCE,0x03,0x00,0x00,0xD8,0x00,0x9C,0x01,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFE,0x07,0xFE,0x07,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x00,0x00},  // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2E
{0x00,0x00,0x00,0x06,0x00,0x03,0x00,0x03,0x80,0x01,0x80,0x01,0x80,0x01,0xC0,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x00,0x00},  // 0x2F
{0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0x0C,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0x0C,0x03,0xF8,0x01,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x30
{0x00,0x00,0x00,0x00,0x60,0x00,0x7C,0x00,0x66,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x31
{0x00,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x84,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x32
{0x00,0x00,0x00,0x00,0xF8,0x00,0xFC,0x03,0x04,0x03,0x00,0x03,0x80,0x01,0xF8,0x00,0xF8,0x00,0x80,0x01,0x00,0x03,0x00,0x03,0x00,0x03,0x84,0x03,0xFC,0x01,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x33
{0x00,0x00,0x00,0x00,0x80,0x01,0xC0,0x01,0xE0,0x01,0xA0,0x01,0x90,0x01,0x98,0x01,0x8C,0x01,0x84,0x01,0xFE,0x07,0xFE,0x07,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x34
{0x00,0x00,0x00,0x00,0xF8,0x03,0xF8,0x03,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x00,0xF8,0x01,0x80,0x03,0x00,0x03,0x00,0x03,0x80,0x03,0xF8,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x35
{0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0x1C,0x01,0x0C,0x00,0x06,0x00,0xE6,0x00,0xF6,0x01,0x8E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8C,0x03,0xFC,0x01,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x36
{0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x01,0xC0,0x00,0x40,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x37
{0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x01,0x8C,0x01,0x8C,0x01,0x9C,0x01,0xF8,0x00,0x70,0x00,0xEC,0x01,0x86,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x38
{0x00,0x00,0x00,0x00,0x78,0x00,0xFC,0x01,0x8E,0x01,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0x7C,0x03,0x38,0x03,0x00,0x03,0x80,0x01,0xC4,0x01,0xFC,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x00,0x00},  // 0x3B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x07,0xC0,0x03,0xE0,0x00,0x38,0x00,0x0E,0x00,0x38,0x00,0xE0,0x00,0xC0,0x03,0x00,0x07,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x0E,0x00,0x3C,0x00,0x70,0x00,0xC0,0x01,0x00,0x07,0xC0,0x01,0x70,0x00,0x3C,0x00,0x0E,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3E
{0x00,0x00,0x00,0x00,0xFE,0x00,0xFE,0x03,0x82,0x03,0x00,0x03,0x00,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3F
{0x00,0x00,0x00,0x00,0xF0,0x01,0x18,0x03,0x0C,0x06,0xC6,0x07,0x63,0x06,0x33,0x06,0x33,0x06,0x33,0x07,0x33,0x07,0xF3,0x06,0x66,0x0E,0x06,0x00,0x0C,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x40
{0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x41
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0xFE,0x01,0x86,0x01,0x86,0x01,0xC6,0x00,0x7E,0x00,0xFE,0x00,0x86,0x01,0x06,0x03,0x06,0x03,0x06,0x03,0xFE,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x42
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x07,0x1C,0x04,0x0C,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x3C,0x04,0xF8,0x07,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x43
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0xFE,0x01,0x86,0x03,0x06,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x86,0x03,0xFE,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x44
{0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x45
{0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x46
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x07,0x1C,0x04,0x0C,0x00,0x06,0x00,0x06,0x00,0x86,0x07,0x86,0x07,0x06,0x06,0x0C,0x06,0x1C,0x06,0xF8,0x07,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x47
{0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xFE,0x03,0xFE,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x48
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x49
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xC0,0x01,0xFC,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4A
{0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x86,0x03,0xC6,0x01,0xE6,0x00,0x66,0x00,0x36,0x00,0x3E,0x00,0x76,0x00,0xE6,0x00,0xC6,0x01,0x86,0x03,0x06,0x07,0x06,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4B
{0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4C
{0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x8F,0x07,0x8B,0x06,0x8B,0x06,0xDB,0x06,0x53,0x06,0x53,0x06,0x73,0x06,0x23,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4D
{0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x06,0x0E,0x06,0x1E,0x06,0x1E,0x06,0x36,0x06,0x76,0x06,0x66,0x06,0xE6,0x06,0xC6,0x06,0x86,0x07,0x86,0x07,0x06,0x07,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4E
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x07,0x07,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4F
{0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0xFC,0x03,0x0C,0x07,0x0C,0x06,0x0C,0x06,0x0C,0x07,0xFC,0x03,0xFC,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x50
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x80,0x03,0x00,0x0F,0x00,0x04,0x00,0x00},  // 0x51
{0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0xFE,0x01,0x86,0x01,0x86,0x01,0x86,0x01,0xC6,0x01,0xFE,0x00,0x7E,0x00,0xE6,0x00,0xC6,0x01,0x86,0x03,0x06,0x07,0x06,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x52
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x06,0x01,0x06,0x00,0x0E,0x00,0x3C,0x00,0xF8,0x00,0xC0,0x03,0x00,0x03,0x00,0x03,0x86,0x03,0xFE,0x01,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x53
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x54
{0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x55
{0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0C,0x06,0x06,0x06,0x06,0x0E,0x06,0x0C,0x03,0x0C,0x03,0x1C,0x03,0x98,0x01,0xB8,0x01,0xB0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x56
{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x62,0x04,0x62,0x04,0xE2,0x06,0xF6,0x06,0x96,0x06,0x96,0x06,0x96,0x03,0x9C,0x03,0x9C,0x03,0x0C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x57
{0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0E,0x0E,0x06,0x0C,0x03,0x98,0x01,0xF8,0x00,0xF0,0x00,0x60,0x00,0xF0,0x00,0xD8,0x01,0x98,0x01,0x0C,0x03,0x06,0x07,0x03,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x58
{0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0C,0x06,0x06,0x0C,0x03,0x1C,0x03,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x59
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x06,0x00,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x5A
{0x00,0x00,0xF0,0x03,0xF0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xF0,0x03,0xF0,0x03,0x00,0x00},  // 0x5B
{0x00,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x00},  // 0x5C
{0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00},  // 0x5D
{0x00,0x00,0x00,0x00,0x40,0x00,0x40,0x00,0xE0,0x00,0xA0,0x00,0xB0,0x00,0xB0,0x01,0x18,0x01,0x18,0x03,0x0C,0x03,0x0C,0x02,0x06,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00},  // 0x5F
{0x60,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x61
{0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xE6,0x00,0xF6,0x01,0x9E,0x03,0x0E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x01,0xFE,0x01,0xF6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xFC,0x03,0x1C,0x02,0x0E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0E,0x00,0x1C,0x00,0xFC,0x03,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x63
{0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x78,0x03,0xFC,0x03,0x8C,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x03,0x38,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x01,0x8C,0x03,0x06,0x03,0xFE,0x03,0xFE,0x03,0x06,0x00,0x06,0x00,0x0C,0x02,0xFC,0x03,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x65
{0x00,0x00,0xE0,0x07,0xF0,0x07,0x30,0x00,0x30,0x00,0xFE,0x07,0xFE,0x07,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x03,0xFC,0x03,0x8C,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x03,0x78,0x03,0x00,0x03,0x84,0x03,0xFC,0x01,0xF8,0x00},  // 0x67
{0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xE6,0x01,0xF6,0x03,0x1E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x68
{0x00,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x69
{0x00,0x00,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xC0,0x01,0xFC,0x00,0x7C,0x00},  // 0x6A
{0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x07,0x8C,0x03,0xCC,0x01,0xEC,0x00,0x6C,0x00,0x7C,0x00,0xEC,0x00,0xCC,0x01,0x8C,0x03,0x0C,0x07,0x0C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6B
{0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9B,0x03,0xFF,0x07,0x77,0x06,0x33,0x06,0x33,0x06,0x33,0x06,0x33,0x06,0x33,0x06,0x33,0x06,0x33,0x06,0x33,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE6,0x01,0xF6,0x03,0x1E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF6,0x00,0xFE,0x01,0x8E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x01,0xFE,0x01,0xF6,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00},  // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x03,0xFC,0x03,0x8C,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0x7C,0x03,0x38,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03},  // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCC,0x03,0xEC,0x03,0x3C,0x02,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x01,0x0C,0x00,0x0C,0x00,0x3C,0x00,0xF0,0x01,0x80,0x03,0x00,0x03,0x04,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x73
{0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xFE,0x07,0xFE,0x07,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xC6,0x03,0x7E,0x03,0x3C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x0C,0x02,0x0C,0x03,0x0C,0x03,0x18,0x01,0x98,0x01,0x98,0x01,0xB0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0C,0x63,0x0C,0x63,0x0C,0xE2,0x04,0xF6,0x04,0x96,0x04,0x96,0x06,0x96,0x07,0x9C,0x03,0x0C,0x03,0x0C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x07,0x0C,0x03,0x98,0x01,0xB8,0x00,0xF0,0x00,0x60,0x00,0xF0,0x00,0xD8,0x01,0x98,0x01,0x0C,0x03,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x0C,0x02,0x0C,0x03,0x1C,0x03,0x98,0x01,0x98,0x01,0xB0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x3C,0x00,0x1C,0x00},  // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xFE,0x03,0x00,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0xFE,0x03,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x7A
{0x00,0x00,0xC0,0x03,0xE0,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x3C,0x00,0x3C,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x03,0xC0,0x03,0x00,0x00},  // 0x7B
{0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00},  // 0x7C
{0x00,0x00,0x3C,0x00,0x7C,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xC0,0x03,0xC0,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7C,0x00,0x3C,0x00,0x00,0x00},  // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x04,0xFE,0x07,0xC2,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x02,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x7F
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x07,0x1C,0x04,0x0C,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x3C,0x04,0xF8,0x07,0xE0,0x03,0x40,0x00,0xE0,0x00,0x80,0x01,0xE0,0x00},  // 0x80
{0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xC6,0x03,0x7E,0x03,0x3C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x81
{0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x01,0x8C,0x03,0x06,0x03,0xFE,0x03,0xFE,0x03,0x06,0x00,0x06,0x00,0x0C,0x02,0xFC,0x03,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x82
{0xE0,0x00,0xB0,0x01,0x18,0x03,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x83
{0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x84
{0x18,0x00,0x30,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x85
{0x90,0x00,0x90,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xFC,0x03,0x1C,0x02,0x0E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0E,0x00,0x1C,0x00,0xFC,0x03,0xF0,0x01,0x20,0x00,0x70,0x00,0xC0,0x00,0x70,0x00},  // 0x87
{0xE0,0x00,0xB0,0x01,0x18,0x03,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x01,0x8C,0x03,0x06,0x03,0xFE,0x03,0xFE,0x03,0x06,0x00,0x06,0x00,0x0C,0x02,0xFC,0x03,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x88
{0x00,0x00,0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x01,0x8C,0x03,0x06,0x03,0xFE,0x03,0xFE,0x03,0x06,0x00,0x06,0x00,0x0C,0x02,0xFC,0x03,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x89
{0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x01,0x8C,0x03,0x06,0x03,0xFE,0x03,0xFE,0x03,0x06,0x00,0x06,0x00,0x0C,0x02,0xFC,0x03,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8A
{0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8B
{0xC0,0x01,0x60,0x03,0x30,0x06,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8C
{0x30,0x00,0x60,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8D
{0x8C,0x01,0x8C,0x01,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8E
{0x60,0x00,0x90,0x00,0xF0,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8F
{0xC0,0x00,0x60,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xBE,0x03,0xFE,0x07,0xE0,0x0C,0x60,0x0C,0x60,0x0C,0xFC,0x0F,0xE6,0x0F,0x63,0x00,0x63,0x00,0xFF,0x0F,0x9E,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x91
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xE0,0x0F,0xE0,0x00,0xF0,0x00,0xD0,0x00,0xD8,0x07,0xC8,0x07,0xCC,0x00,0xFC,0x00,0xFC,0x00,0xC6,0x00,0xC2,0x0F,0xC3,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x92
{0xE0,0x00,0xB0,0x01,0x18,0x03,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x93
{0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x94
{0x18,0x00,0x30,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x95
{0xE0,0x00,0xB0,0x01,0x18,0x03,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xC6,0x03,0x7E,0x03,0x3C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x96
{0x18,0x00,0x30,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xC6,0x03,0x7E,0x03,0x3C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x97
{0x00,0x00,0x98,0x01,0x98,0x01,0x00,0x00,0x00,0x00,0x06,0x06,0x0C,0x02,0x0C,0x03,0x1C,0x03,0x98,0x01,0x98,0x01,0xB0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x3C,0x00,0x1C,0x00},  // 0x98
{0x8C,0x01,0x8C,0x01,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x07,0x07,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x99
{0x8C,0x01,0x8C,0x01,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x06,0xFC,0x03,0x0C,0x03,0x86,0x07,0xC6,0x06,0x66,0x06,0x36,0x06,0x1E,0x06,0x0C,0x03,0xFC,0x03,0xF6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9B
{0x00,0x00,0x00,0x00,0xE0,0x03,0xF0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0xFC,0x00,0xFC,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9C
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x06,0xFC,0x03,0x8E,0x03,0x87,0x03,0xC3,0x06,0x43,0x06,0x23,0x06,0x13,0x06,0x1B,0x06,0x0E,0x07,0x8E,0x03,0xFE,0x01,0xFB,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x07,0x07,0x8E,0x03,0xDC,0x01,0xF8,0x00,0x70,0x00,0xF8,0x00,0xDC,0x01,0x8E,0x03,0x07,0x07,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9E
{0xC0,0x07,0xE0,0x07,0x60,0x00,0x60,0x00,0x60,0x00,0xF8,0x03,0xF8,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x3E,0x00},  // 0x9F
{0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA0
{0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA1
{0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA2
{0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xC6,0x03,0x7E,0x03,0x3C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA3
{0x00,0x00,0x70,0x02,0xC8,0x01,0x00,0x00,0x00,0x00,0xE6,0x01,0xF6,0x03,0x1E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA4
{0x70,0x02,0xC8,0x01,0x00,0x00,0x0E,0x06,0x0E,0x06,0x1E,0x06,0x1E,0x06,0x36,0x06,0x76,0x06,0x66,0x06,0xE6,0x06,0xC6,0x06,0x86,0x07,0x86,0x07,0x06,0x07,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA5
{0x00,0x00,0x00,0x00,0xFC,0x00,0x84,0x01,0x80,0x01,0xF8,0x01,0x8C,0x01,0x8C,0x01,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA6
{0x00,0x00,0x00,0x00,0xF0,0x00,0x98,0x01,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x98,0x01,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x0E,0x02,0xFC,0x03,0xF8,0x03},  // 0xA8
{0x00,0x00,0x00,0x00,0xF8,0x00,0x8C,0x01,0x76,0x03,0x52,0x02,0x72,0x02,0x32,0x02,0x56,0x03,0x8C,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x07,0xFF,0x07,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAA
{0x00,0x00,0x00,0x00,0x07,0x03,0x86,0x01,0x86,0x01,0xC6,0x00,0x66,0x00,0x66,0x00,0xB6,0x07,0x30,0x0C,0x18,0x0C,0x18,0x0C,0x0C,0x06,0x06,0x03,0x86,0x01,0x83,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAB
{0x00,0x00,0x00,0x00,0x07,0x03,0x86,0x01,0x86,0x01,0xC6,0x00,0x66,0x00,0x66,0x00,0x36,0x06,0x30,0x07,0x98,0x06,0x58,0x06,0x2C,0x06,0xE6,0x0F,0x06,0x06,0x03,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x06,0x18,0x03,0x8C,0x01,0xC6,0x00,0x63,0x00,0xC6,0x00,0x8C,0x01,0x18,0x03,0x30,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x63,0x00,0xC6,0x00,0x8C,0x01,0x18,0x03,0x30,0x06,0x18,0x03,0x8C,0x01,0xC6,0x00,0x63,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAF
{0x33,0x03,0x33,0x03,0x00,0x00,0x00,0x00,0x33,0x03,0x33,0x03,0x00,0x00,0x00,0x00,0x33,0x03,0x33,0x03,0x00,0x00,0x00,0x00,0x33,0x03,0x33,0x03,0x00,0x00,0x00,0x00,0x33,0x03,0x33,0x03,0x00,0x00,0x00,0x00},  // 0xB0
{0xCC,0x0C,0xCC,0x0C,0x33,0x03,0x33,0x03,0xCC,0x0C,0xCC,0x0C,0x33,0x03,0x33,0x03,0xCC,0x0C,0xCC,0x0C,0x33,0x03,0x33,0x03,0xCC,0x0C,0xCC,0x0C,0x33,0x03,0x33,0x03,0xCC,0x0C,0xCC,0x0C,0x33,0x03,0x33,0x03},  // 0xB1
{0xFF,0x0F,0xFF,0x0F,0x33,0x03,0x33,0x03,0xFF,0x0F,0xFF,0x0F,0x33,0x03,0x33,0x03,0xFF,0x0F,0xFF,0x0F,0x33,0x03,0x33,0x03,0xFF,0x0F,0xFF,0x0F,0x33,0x03,0x33,0x03,0xFF,0x0F,0xFF,0x0F,0x33,0x03,0x33,0x03},  // 0xB2
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xB3
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x00,0x7F,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xB4
{0xC0,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB5
{0x70,0x00,0x88,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB6
{0x30,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB7
{0x00,0x00,0x00,0x00,0xF8,0x00,0x04,0x01,0x02,0x02,0xF3,0x06,0x09,0x04,0x05,0x04,0x05,0x04,0x05,0x04,0x05,0x04,0x09,0x04,0xF3,0x06,0x02,0x02,0x04,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB8
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xBF,0x01,0xBF,0x01,0x80,0x01,0xBF,0x01,0xBF,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xB9
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xFF,0x01,0x80,0x01,0xBF,0x01,0xBF,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xBB
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xBF,0x01,0xBF,0x01,0x80,0x01,0xFF,0x01,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xBC
{0x00,0x00,0x00,0x00,0x40,0x00,0x40,0x00,0xF0,0x03,0xF8,0x03,0x5C,0x02,0x4C,0x00,0x4C,0x00,0x4C,0x00,0x4C,0x00,0x5C,0x00,0xF8,0x03,0xF0,0x01,0x40,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xBD
{0x00,0x00,0x00,0x00,0x07,0x0C,0x0E,0x06,0x0C,0x03,0x1C,0x03,0xB8,0x01,0xF0,0x00,0x60,0x00,0xFC,0x03,0x60,0x00,0x60,0x00,0xFC,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x7F,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xBF
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x0F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC0
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xC2
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x0F,0xE0,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC4
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xC5
{0x00,0x00,0x70,0x02,0xC8,0x01,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x04,0x03,0x00,0x03,0x00,0x03,0xF8,0x03,0x0C,0x03,0x06,0x03,0x86,0x03,0xFE,0x0F,0x7C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC6
{0x70,0x02,0xC8,0x01,0x00,0x00,0x60,0x00,0xF0,0x00,0xF0,0x00,0xD0,0x00,0x98,0x01,0x98,0x01,0x8C,0x03,0x0C,0x03,0xFC,0x03,0xFE,0x07,0x06,0x06,0x06,0x06,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC7
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x0F,0xB0,0x0F,0x30,0x00,0xF0,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0xF0,0x0F,0x30,0x00,0xB0,0x0F,0xB0,0x0F,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xC9
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xBF,0x0F,0xBF,0x0F,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0xBF,0x0F,0xBF,0x0F,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xCB
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x0F,0xB0,0x0F,0x30,0x00,0xB0,0x0F,0xB0,0x0F,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xCD
{0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xBF,0x0F,0xBF,0x0F,0x00,0x00,0xBF,0x0F,0xBF,0x0F,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01},  // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x04,0xF4,0x02,0xFC,0x03,0x9C,0x03,0x0C,0x03,0x0C,0x03,0x9C,0x03,0xFC,0x03,0xF4,0x02,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xCF
{0x00,0x00,0xDE,0x00,0x7E,0x00,0xF0,0x00,0xC8,0x01,0xF0,0x03,0xFC,0x03,0x0C,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD0
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0xFE,0x01,0x86,0x03,0x06,0x07,0x06,0x06,0x1F,0x06,0x1F,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x86,0x03,0xFE,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD1
{0xE0,0x00,0x10,0x01,0x00,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD2
{0x18,0x03,0x18,0x03,0x00,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD3
{0x60,0x00,0xC0,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD5
{0xC0,0x00,0x60,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD6
{0x70,0x00,0x88,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD7
{0x8C,0x01,0x8C,0x01,0x00,0x00,0xFE,0x01,0xFE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD8
{0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xE0,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00},  // 0xDA
{0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F},  // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F},  // 0xDC
{0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00},  // 0xDD
{0x30,0x00,0x60,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xDE
{0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xDF
{0xC0,0x00,0x60,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x07,0x07,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE0
{0x00,0x00,0xFC,0x00,0xFE,0x01,0x86,0x01,0x86,0x01,0xC6,0x00,0xC6,0x00,0x66,0x00,0xE6,0x00,0xC6,0x01,0x86,0x03,0x06,0x07,0x06,0x06,0x26,0x06,0xE6,0x07,0xC6,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE1
{0x70,0x00,0x88,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x07,0x07,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE2
{0x30,0x00,0x60,0x00,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x07,0x07,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE3
{0x00,0x00,0x70,0x02,0xC8,0x01,0x00,0x00,0x00,0x00,0xF0,0x00,0xFC,0x03,0x0C,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0xFC,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE4
{0x70,0x02,0xC8,0x01,0x00,0x00,0xF8,0x00,0xFC,0x01,0x8E,0x03,0x07,0x07,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x07,0x07,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFE,0x03,0x76,0x03,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00},  // 0xE6
{0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xE6,0x00,0xF6,0x01,0x8E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x01,0xFE,0x01,0xF6,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00},  // 0xE7
{0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x00,0xFE,0x01,0x86,0x03,0x06,0x03,0x06,0x03,0x86,0x03,0xFE,0x01,0x7E,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE8
{0xC0,0x00,0x60,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE9
{0x70,0x00,0x88,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEA
{0x30,0x00,0x60,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEB
{0x80,0x01,0xC0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x0C,0x02,0x0C,0x03,0x1C,0x03,0x98,0x01,0x98,0x01,0xB0,0x00,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x20,0x00,0x30,0x00,0x3C,0x00,0x1C,0x00},  // 0xEC
{0xC0,0x00,0x60,0x00,0x00,0x00,0x07,0x0C,0x06,0x06,0x0C,0x03,0x1C,0x03,0x98,0x01,0xF0,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xED
{0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEE
{0x60,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFE,0x07,0xFE,0x07,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0x00,0x00,0xFF,0x0F,0x00,0x00},  // 0xF2
{0x00,0x00,0x00,0x00,0x0F,0x0C,0x18,0x06,0x18,0x03,0x86,0x03,0x98,0x01,0xD8,0x00,0x6F,0x07,0x60,0x07,0xB0,0x06,0x58,0x06,0x3C,0x06,0xEC,0x0F,0x06,0x06,0x03,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF3
{0x00,0x00,0x00,0x00,0xFC,0x03,0x3E,0x02,0x3E,0x02,0x3E,0x02,0x3E,0x02,0x3C,0x02,0x38,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x00,0x00},  // 0xF4
{0x00,0x00,0x00,0x00,0xF0,0x01,0xF8,0x01,0x0C,0x00,0x0C,0x00,0x1C,0x00,0xF0,0x00,0xC8,0x01,0x8C,0x03,0x0C,0x03,0x1C,0x03,0xF8,0x01,0xE0,0x01,0x80,0x03,0x00,0x03,0x04,0x03,0xFC,0x01,0xF8,0x00,0x00,0x00},  // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x70,0x00,0xC0,0x00,0x70,0x00},  // 0xF7
{0x00,0x00,0x00,0x00,0x30,0x00,0x48,0x00,0x48,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF8
{0x8C,0x01,0x8C,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFA
{0x00,0x00,0x00,0x00,0x78,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFB
{0x00,0x00,0x00,0x00,0xF8,0x00,0x88,0x01,0x80,0x01,0xF0,0x00,0x80,0x01,0x80,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFC
{0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x03,0x00,0x03,0x80,0x01,0x60,0x00,0x18,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}   // 0xFF
};
#endif

#ifdef USE_FONT_16X26
__UG_FONT_DATA unsigned char font_16x26[256][52]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x00
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x30,0x0C,0x08,0x10,0x64,0x26,0x66,0x66,0x02,0x40,0x02,0x40,0x12,0x48,0x12,0x48,0x36,0x6C,0x24,0x24,0xC8,0x13,0x30,0x0C,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x01
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0xF8,0x1F,0xFC,0x3F,0x9E,0x79,0x9E,0x79,0xFE,0x7F,0xFE,0x7F,0xEE,0x77,0xEE,0x77,0xDC,0x3B,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x02
{0x00,0x00,0x00,0x00,0x3C,0x3C,0x7E,0x7E,0xFE,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x7F,0xFE,0x7F,0xFC,0x3F,0xFC,0x3F,0xF8,0x1F,0xF0,0x0F,0xF0,0x0F,0xE0,0x07,0xC0,0x03,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x03
{0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x01,0xC0,0x01,0xE0,0x03,0xE0,0x07,0xF0,0x0F,0xF8,0x1F,0xFC,0x3F,0xFE,0x7F,0xFF,0xFF,0xFE,0x7F,0xFC,0x3F,0xF8,0x1F,0xF0,0x0F,0xE0,0x07,0xE0,0x03,0xC0,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x04
{0x00,0x00,0x00,0x00,0xC0,0x03,0xE0,0x07,0xF0,0x0F,0xF0,0x0F,0xF0,0x0F,0xF0,0x0F,0xE0,0x07,0xFC,0x3F,0xFE,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x7F,0x9C,0x39,0x80,0x01,0x80,0x01,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x05
{0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x03,0xC0,0x07,0xE0,0x0F,0xF0,0x0F,0xF8,0x1F,0xFC,0x3F,0xFE,0x7F,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x7F,0x9C,0x39,0x80,0x01,0x80,0x01,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0A
{0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x7F,0x00,0x7F,0x00,0x78,0x00,0xCC,0x00,0xCE,0xF0,0x07,0xFC,0x07,0x0E,0x0E,0x06,0x0C,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x06,0x0C,0x0E,0x0E,0xFC,0x07,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0B
{0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x1F,0x38,0x38,0x18,0x30,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x1C,0x60,0x18,0x30,0x78,0x38,0xF0,0x1F,0xC0,0x0F,0x00,0x03,0x00,0x03,0xE0,0x1F,0xE0,0x1F,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0D
{0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x70,0x00,0x7E,0x80,0x7F,0xE0,0x47,0xE0,0x41,0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x78,0x20,0x7C,0x20,0x7E,0x20,0x3E,0x3C,0x1C,0x3E,0x00,0x3F,0x00,0x1F,0x00,0x0E,0x00,0x00,0x00},  // 0x0E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x88,0x11,0xDC,0x3B,0xF8,0x1F,0x30,0x0C,0x18,0x18,0x1E,0x78,0x1E,0x78,0x18,0x18,0x30,0x0C,0xF8,0x1F,0xDC,0x3B,0x88,0x11,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x0F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x0E,0x00,0x3E,0x00,0xFE,0x00,0xFE,0x01,0xFE,0x07,0xFE,0x1F,0xFE,0x7F,0xFE,0x1F,0xFE,0x07,0xFE,0x01,0xFE,0x00,0x3E,0x00,0x0E,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x10
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x70,0x00,0x7C,0x00,0x7F,0x80,0x7F,0xE0,0x7F,0xF8,0x7F,0xFE,0x7F,0xF8,0x7F,0xE0,0x7F,0x80,0x7F,0x00,0x7F,0x00,0x7C,0x00,0x70,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x11
{0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0xC0,0x03,0xE0,0x07,0xB0,0x0D,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xB0,0x0D,0xE0,0x07,0xC0,0x03,0x80,0x01,0x80,0x01,0x00,0x00},  // 0x12
{0x00,0x00,0x00,0x00,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x00,0x00,0x00,0x00,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x13
{0x00,0x00,0x00,0x00,0xF8,0x1F,0xFC,0x1F,0xFE,0x18,0xFE,0x18,0xFE,0x18,0xFE,0x18,0xFE,0x18,0xFC,0x18,0xF8,0x18,0xF0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0x00,0x00},  // 0x14
{0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x1F,0x78,0x10,0x38,0x00,0x38,0x00,0x78,0x00,0xF0,0x01,0xE0,0x07,0xF0,0x0F,0x30,0x1E,0x38,0x3C,0x38,0x38,0x78,0x38,0xF0,0x19,0xE0,0x0F,0x80,0x0F,0x00,0x1E,0x00,0x3C,0x00,0x38,0x00,0x38,0x18,0x3C,0xF8,0x1F,0xE0,0x07,0x00,0x00},  // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x16
{0x00,0x00,0x80,0x01,0x80,0x01,0xC0,0x03,0xE0,0x07,0xB0,0x0D,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xB0,0x0D,0xE0,0x07,0xC0,0x03,0x80,0x01,0x80,0x01,0x00,0x00,0xF0,0x0F,0xF0,0x0F},  // 0x17
{0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0xC0,0x03,0xE0,0x07,0xB0,0x0D,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00},  // 0x18
{0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xB0,0x0D,0xE0,0x07,0xC0,0x03,0x80,0x01,0x80,0x01,0x00,0x00},  // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x0C,0x00,0x18,0xFE,0x7F,0xFE,0x7F,0x00,0x18,0x00,0x0C,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x30,0x00,0x18,0x00,0xFE,0x7F,0xFE,0x7F,0x18,0x00,0x30,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x04,0x30,0x0C,0x18,0x18,0xFE,0x7F,0xFE,0x7F,0x18,0x18,0x30,0x0C,0x20,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x80,0x03,0x80,0x03,0xC0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x0F,0xF0,0x0F,0xF0,0x1F,0xF8,0x1F,0xF8,0x1F,0xFC,0x3F,0xFC,0x3F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFC,0x3F,0xFC,0x3F,0xF8,0x1F,0xF8,0x1F,0xF0,0x1F,0xF0,0x0F,0xE0,0x0F,0xE0,0x07,0xC0,0x07,0xC0,0x03,0x80,0x03,0x80,0x03,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x20
{0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x21
{0x00,0x00,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x10,0x04,0x10,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x22
{0x00,0x00,0x00,0x00,0x80,0x31,0x80,0x31,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xFC,0x7F,0xFC,0x7F,0x60,0x0C,0x60,0x06,0x30,0x06,0xFE,0x3F,0xFE,0x3F,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x8C,0x01,0x8C,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x23
{0x00,0x03,0x00,0x03,0xC0,0x1F,0xF0,0x3F,0x70,0x23,0x38,0x03,0x38,0x03,0x38,0x03,0x78,0x03,0xF0,0x03,0xE0,0x03,0x80,0x07,0x00,0x1F,0x00,0x1F,0x00,0x3B,0x00,0x3B,0x00,0x3B,0x00,0x3B,0x18,0x1B,0xF8,0x1F,0xE0,0x0F,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x24
{0x00,0x00,0x00,0x00,0x3C,0xC0,0x66,0x60,0xC3,0x30,0xC3,0x18,0xC3,0x18,0xC3,0x0C,0xC3,0x06,0x66,0x03,0x3C,0x03,0x80,0x01,0xC0,0x3C,0xC0,0x66,0x60,0xC3,0x30,0xC3,0x18,0xC3,0x18,0xC3,0x0C,0xC3,0x06,0x66,0x03,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x25
{0x00,0x00,0x00,0x00,0xE0,0x03,0xF0,0x07,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x06,0x70,0x07,0xF0,0x01,0xF8,0x00,0xFC,0xE0,0xCE,0xE1,0xC7,0xE3,0x87,0x63,0x07,0x67,0x07,0x7E,0x0F,0x3E,0x1E,0x3C,0xFC,0x7F,0xF0,0xF3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x26
{0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x80,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x27
{0x00,0x00,0x00,0x18,0x00,0x1E,0x00,0x0F,0x80,0x03,0xC0,0x01,0xE0,0x00,0xE0,0x00,0xE0,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x0F,0x00,0x1E,0x00,0x18,0x00,0x00},  // 0x28
{0x00,0x00,0x0C,0x00,0x3C,0x00,0x78,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x80,0x03,0x80,0x03,0x80,0x03,0xC0,0x01,0xE0,0x00,0x78,0x00,0x3C,0x00,0x0C,0x00,0x00,0x00},  // 0x29
{0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x98,0x1B,0x7C,0x3E,0x30,0x0C,0x40,0x02,0xE0,0x07,0x70,0x0E,0x38,0x1C,0x20,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFE,0x7F,0xFE,0x7F,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x03,0x80,0x03,0x80,0x01,0xC0,0x00,0x00,0x00},  // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0xF8,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x2E
{0x00,0x00,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x80,0x01,0x80,0x01,0xC0,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x00,0x00},  // 0x2F
{0x00,0x00,0x00,0x00,0xE0,0x03,0xF0,0x07,0x38,0x0E,0x1C,0x1C,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x1C,0x1C,0x38,0x0E,0xF0,0x07,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x30
{0x00,0x00,0x00,0x00,0x00,0x03,0xE0,0x03,0xFC,0x03,0x8C,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0xFC,0x7F,0xFC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x31
{0x00,0x00,0x00,0x00,0xF0,0x03,0xFC,0x07,0x0C,0x0E,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x0E,0x00,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x30,0x00,0x38,0x00,0x1C,0x00,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x32
{0x00,0x00,0x00,0x00,0xF0,0x03,0xF8,0x0F,0x08,0x1E,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x0C,0x00,0x06,0xE0,0x03,0xE0,0x07,0x00,0x0F,0x00,0x1E,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1E,0x08,0x0F,0xF8,0x07,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x33
{0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0F,0x80,0x0F,0x80,0x0F,0xC0,0x0E,0xE0,0x0E,0x60,0x0E,0x30,0x0E,0x18,0x0E,0x18,0x0E,0x0C,0x0E,0x06,0x0E,0xFE,0x7F,0xFE,0x7F,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x34
{0x00,0x00,0x00,0x00,0xF0,0x3F,0xF0,0x3F,0xF0,0x3F,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xF0,0x03,0xF0,0x0F,0x00,0x1E,0x00,0x3C,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x3C,0x10,0x1E,0xF0,0x0F,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x35
{0x00,0x00,0x00,0x00,0x80,0x1F,0xE0,0x3F,0xF0,0x20,0x70,0x00,0x38,0x00,0x38,0x00,0x1C,0x00,0x9C,0x0F,0xDC,0x1F,0x7C,0x3C,0x3C,0x78,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x38,0x70,0x38,0x38,0x70,0x38,0xF0,0x1F,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x36
{0x00,0x00,0x00,0x00,0xF8,0x3F,0xF8,0x3F,0xF8,0x3F,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x02,0x00,0x03,0x80,0x01,0x80,0x01,0xC0,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x37
{0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x0F,0x78,0x1E,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x78,0x0C,0xF0,0x0F,0xE0,0x03,0xF0,0x0F,0x38,0x1F,0x18,0x1E,0x1C,0x3C,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x38
{0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x1F,0x38,0x1C,0x38,0x38,0x1C,0x38,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x78,0x7C,0xF0,0x77,0xE0,0x73,0x00,0x70,0x00,0x38,0x00,0x38,0x00,0x1C,0x08,0x1E,0xF8,0x0F,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x03,0x80,0x03,0x80,0x01,0xC0,0x00,0x00,0x00},  // 0x3B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x70,0x00,0x3C,0x00,0x0F,0xC0,0x03,0xF0,0x00,0x3C,0x00,0x3C,0x00,0xF0,0x00,0xC0,0x03,0x00,0x0F,0x00,0x3C,0x00,0x70,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x0E,0x00,0x3C,0x00,0xF0,0x00,0xC0,0x03,0x00,0x0F,0x00,0x3C,0x00,0x3C,0x00,0x0F,0xC0,0x03,0xF0,0x00,0x3C,0x00,0x0E,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3E
{0x00,0x00,0x00,0x00,0xF8,0x07,0xFC,0x1F,0x0C,0x3C,0x0C,0x38,0x00,0x38,0x00,0x38,0x00,0x1C,0x00,0x1E,0x00,0x0F,0x80,0x07,0x80,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x3F
{0x00,0x00,0x00,0x00,0xC0,0x0F,0xE0,0x1F,0x70,0x38,0x18,0x30,0x1C,0x3E,0x0C,0x31,0x8E,0x31,0xC6,0x30,0xC6,0x30,0xC6,0x38,0xC6,0x38,0xC6,0x3C,0xC6,0x34,0x8E,0xF7,0x8C,0xF3,0x1C,0x00,0x38,0x08,0xF0,0x0F,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x40
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x03,0xE0,0x03,0x60,0x07,0x60,0x07,0x70,0x06,0x30,0x0E,0x38,0x0E,0x38,0x1C,0x18,0x1C,0xFC,0x3F,0xFC,0x3F,0x0E,0x38,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x41
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x0F,0x1C,0x1E,0x1C,0x1C,0x1C,0x1C,0x1C,0x0E,0xFC,0x07,0xFC,0x07,0x1C,0x1E,0x1C,0x3C,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0xFC,0x1F,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x42
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x3F,0x78,0x30,0x3C,0x00,0x1C,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x1C,0x00,0x3C,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x43
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x0F,0x1C,0x3C,0x1C,0x38,0x1C,0x78,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x38,0x1C,0x38,0x1C,0x1E,0xFC,0x0F,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x44
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x1F,0xF8,0x1F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x7F,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x45
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0xF8,0x7F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x3F,0xF8,0x3F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x46
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x3F,0x78,0x30,0x3C,0x00,0x1C,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x3F,0x0E,0x3F,0x0E,0x38,0x1C,0x38,0x3C,0x38,0x78,0x38,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x47
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x48
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x1F,0xFC,0x1F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x49
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0xF8,0x0F,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x04,0x07,0xFC,0x03,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x78,0x1C,0x3C,0x1C,0x1E,0x1C,0x0F,0x1C,0x07,0x9C,0x03,0xDC,0x01,0xFC,0x00,0xDC,0x01,0xDC,0x03,0x9C,0x07,0x1C,0x0F,0x1C,0x1E,0x1C,0x3C,0x1C,0x78,0x1C,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x3F,0xF8,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x38,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x36,0x36,0x36,0x36,0x36,0x36,0x66,0x32,0x66,0x33,0x66,0x33,0xC6,0x31,0xC6,0x31,0xC6,0x31,0x06,0x30,0x06,0x30,0x06,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x30,0x1C,0x30,0x3C,0x30,0x7C,0x30,0x7C,0x30,0xFC,0x30,0xEC,0x31,0xCC,0x31,0xCC,0x33,0x8C,0x37,0x0C,0x3F,0x0C,0x3E,0x0C,0x3E,0x0C,0x3C,0x0C,0x38,0x0C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x4F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0xF8,0x3F,0x38,0x78,0x38,0x70,0x38,0x70,0x38,0x70,0x38,0x78,0x38,0x3C,0xF8,0x1F,0xF8,0x07,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x50
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x1E,0x00,0x78,0x00,0xF0,0x00,0x40,0x00,0x00},  // 0x51
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x0F,0x1C,0x1E,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x0E,0xFC,0x07,0xFC,0x03,0x9C,0x07,0x1C,0x07,0x1C,0x0F,0x1C,0x1E,0x1C,0x3C,0x1C,0x38,0x1C,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x52
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xF8,0x1F,0x3C,0x18,0x1C,0x00,0x1C,0x00,0x3C,0x00,0xF8,0x00,0xF0,0x07,0xC0,0x1F,0x00,0x3E,0x00,0x38,0x00,0x38,0x00,0x38,0x0C,0x1C,0xFC,0x1F,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x53
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x7F,0xFF,0x7F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x54
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x55
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x0E,0x70,0x0E,0x70,0x1C,0x70,0x1C,0x38,0x3C,0x38,0x38,0x38,0x38,0x1C,0x70,0x1C,0x70,0x0C,0xE0,0x0E,0xE0,0x0E,0xE0,0x07,0xC0,0x07,0xC0,0x07,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x56
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x03,0xC0,0x07,0xC0,0x86,0x61,0xC6,0x63,0xC6,0x63,0xC6,0x63,0xC6,0x63,0x4E,0x76,0x6C,0x36,0x6C,0x36,0x6C,0x36,0x2C,0x3E,0x3C,0x3C,0x3C,0x1C,0x3C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x57
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0xE0,0x3C,0x70,0x78,0x38,0x78,0x1C,0xF0,0x0E,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x07,0xE0,0x07,0x60,0x0F,0x30,0x1E,0x18,0x3C,0x1C,0x38,0x0E,0x78,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x58
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x0E,0x70,0x1C,0x30,0x1C,0x18,0x38,0x1C,0x78,0x0E,0x70,0x07,0xE0,0x03,0xE0,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x59
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0xFC,0x3F,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x80,0x03,0x80,0x01,0xC0,0x00,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0xFE,0x3F,0xFE,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x5A
{0x00,0x00,0xC0,0x3F,0xC0,0x3F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x3F,0xC0,0x3F,0x00,0x00},  // 0x5B
{0x00,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x00,0x80,0x01,0x80,0x01,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x00},  // 0x5C
{0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0xFC,0x03,0xFC,0x03,0x00,0x00},  // 0x5D
{0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x80,0x03,0x80,0x03,0xC0,0x03,0xC0,0x06,0xE0,0x06,0x60,0x0C,0x30,0x0C,0x30,0x18,0x18,0x18,0x18,0x18,0x0C,0x30,0x0C,0x30,0x06,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x5F
{0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x61
{0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x9C,0x07,0xDC,0x1F,0x7C,0x1C,0x3C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x1C,0x3C,0x1E,0xFC,0x0F,0xCC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x3F,0x78,0x20,0x38,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x3C,0x00,0x38,0x00,0xF8,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x63
{0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0xC0,0x73,0xF0,0x7F,0x78,0x7C,0x38,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x7C,0xF0,0x77,0xE0,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x0F,0x78,0x1C,0x38,0x38,0x1C,0x38,0x1C,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x00,0x1C,0x00,0x38,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x65
{0x00,0x00,0x00,0xFF,0x80,0xFF,0xC0,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFC,0x7F,0xFC,0x7F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x73,0xF0,0x7F,0x78,0x7C,0x38,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x7C,0xF0,0x77,0xE0,0x73,0x00,0x70,0x00,0x38,0x18,0x3C,0xF8,0x1F,0xF0,0x07},  // 0x67
{0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x0F,0xDC,0x1F,0x7C,0x3C,0x3C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x68
{0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x69
{0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0xF8,0x0F,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x04,0x07,0xFC,0x07,0xF8,0x01},  // 0x6A
{0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x3C,0x38,0x1E,0x38,0x0E,0x38,0x0F,0xB8,0x07,0xB8,0x03,0xF8,0x03,0xB8,0x03,0xB8,0x07,0x38,0x0F,0x38,0x0E,0x38,0x1E,0x38,0x3C,0x38,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6B
{0x00,0x00,0xF8,0x07,0xF8,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCE,0x31,0xEE,0x79,0xFE,0x7F,0x9E,0x77,0x9E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x8E,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x0F,0xDC,0x1F,0x7C,0x3C,0x3C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x0F,0x3C,0x1E,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x07,0xDC,0x1F,0x7C,0x1C,0x3C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x1C,0x3C,0x1E,0xFC,0x0F,0x9C,0x07,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00},  // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x39,0xF8,0x3F,0x3C,0x3E,0x1C,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1E,0x3C,0x1C,0x3E,0xF8,0x3B,0xF0,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38},  // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x3E,0x70,0x3F,0xF0,0x31,0xF0,0x30,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x78,0x10,0x38,0x00,0x38,0x00,0xF8,0x01,0xF0,0x07,0x80,0x1F,0x00,0x3C,0x00,0x38,0x00,0x38,0x18,0x3C,0xF8,0x1F,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x73
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0xE0,0x00,0xFC,0x3F,0xFC,0x3F,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x01,0xC0,0x3F,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0x3C,0x3E,0xF8,0x3B,0xF0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x70,0x1C,0x38,0x1C,0x38,0x3C,0x38,0x38,0x18,0x38,0x1C,0x70,0x1C,0x70,0x0C,0xE0,0x0E,0xE0,0x0E,0xE0,0x06,0xC0,0x07,0xC0,0x07,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x87,0xC3,0x87,0x43,0xC6,0x63,0xC6,0x63,0x46,0x62,0x6E,0x66,0x6E,0x26,0x6C,0x36,0x2C,0x36,0x3C,0x3C,0x3C,0x3C,0x3C,0x1C,0x18,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x30,0x3C,0x18,0x78,0x0C,0x70,0x0E,0xF0,0x06,0xE0,0x03,0xC0,0x03,0xC0,0x03,0xE0,0x07,0x70,0x0F,0x30,0x0E,0x38,0x1E,0x1C,0x3C,0x0E,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x70,0x1C,0x30,0x1C,0x38,0x38,0x18,0x38,0x1C,0x78,0x1C,0x70,0x0E,0xF0,0x0E,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0x80,0x01,0xC0,0x01,0xC0,0x00,0xE0,0x00,0x7C,0x00,0x3C,0x00},  // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0xFC,0x3F,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0xFC,0x3F,0xFC,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x7A
{0x00,0x00,0x00,0x1F,0x80,0x1F,0xC0,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0xC0,0x01,0xF8,0x00,0xF8,0x00,0xC0,0x01,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x03,0x80,0x1F,0x00,0x1F,0x00,0x00},  // 0x7B
{0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00},  // 0x7C
{0x00,0x00,0x7C,0x00,0xFC,0x00,0xE0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xC0,0x01,0x80,0x0F,0x80,0x0F,0xC0,0x01,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xE0,0x01,0xFC,0x00,0x7C,0x00,0x00,0x00},  // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x60,0xFC,0x63,0xC6,0x3F,0x06,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x7F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x3F,0x78,0x30,0x3C,0x00,0x1C,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x1C,0x00,0x3C,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x02,0x00,0x07,0x00,0x0C,0x00,0x0C,0x80,0x07},  // 0x80
{0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x06,0x30,0x06,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0x3C,0x3E,0xF8,0x3B,0xF0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x81
{0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x80,0x01,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x0F,0x78,0x1C,0x38,0x38,0x1C,0x38,0x1C,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x00,0x1C,0x00,0x38,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x82
{0x00,0x00,0xC0,0x01,0x60,0x03,0x30,0x06,0x18,0x0C,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x83
{0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x0C,0x60,0x0C,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x84
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x85
{0xC0,0x01,0x20,0x02,0x20,0x02,0x20,0x02,0xC0,0x01,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x3F,0x78,0x20,0x38,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x3C,0x00,0x38,0x00,0xF8,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0xC0,0x03},  // 0x87
{0x00,0x00,0xC0,0x01,0x60,0x03,0x30,0x06,0x18,0x0C,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x0F,0x78,0x1C,0x38,0x38,0x1C,0x38,0x1C,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x00,0x1C,0x00,0x38,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x88
{0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x0C,0x60,0x0C,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x0F,0x78,0x1C,0x38,0x38,0x1C,0x38,0x1C,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x00,0x1C,0x00,0x38,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x89
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x0F,0x78,0x1C,0x38,0x38,0x1C,0x38,0x1C,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x00,0x1C,0x00,0x38,0x00,0x78,0x20,0xF0,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8A
{0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x06,0x30,0x06,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8B
{0x00,0x00,0x80,0x03,0xC0,0x06,0x60,0x0C,0x30,0x18,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8C
{0x00,0x00,0x60,0x00,0xC0,0x00,0x80,0x01,0x00,0x03,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8D
{0x30,0x0C,0x30,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x03,0xE0,0x03,0x60,0x07,0x60,0x07,0x70,0x06,0x30,0x0E,0x38,0x0E,0x38,0x1C,0x18,0x1C,0xFC,0x3F,0xFC,0x3F,0x0E,0x38,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8E
{0x80,0x03,0x40,0x04,0x40,0x04,0x40,0x04,0x80,0x03,0x80,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x06,0x60,0x0E,0x60,0x0E,0x70,0x0C,0x30,0x1C,0x38,0x1C,0x38,0x38,0xFC,0x3F,0xFC,0x3F,0x1C,0x70,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x8F
{0x00,0x0E,0x00,0x07,0x80,0x03,0x00,0x00,0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x1F,0xF8,0x1F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x7F,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x3C,0xFC,0x7F,0x80,0x67,0x80,0xE3,0x80,0xE3,0xF0,0xFF,0xFC,0xFF,0x9C,0x03,0x8E,0x03,0x8E,0x03,0x8E,0x03,0x9E,0x87,0xFC,0xFF,0x78,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x91
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0xC0,0x3F,0xC0,0x07,0xE0,0x07,0x60,0x07,0x60,0x07,0x70,0x07,0x30,0x3F,0x38,0x3F,0x18,0x07,0x1C,0x07,0xFC,0x07,0xFC,0x07,0x06,0x07,0x06,0x7F,0x03,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x92
{0x00,0x00,0xC0,0x01,0x60,0x03,0x30,0x06,0x18,0x0C,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x0F,0x3C,0x1E,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x93
{0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x06,0x30,0x06,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x0F,0x3C,0x1E,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x94
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x0F,0x3C,0x1E,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x95
{0x00,0x00,0xC0,0x01,0x60,0x03,0x30,0x06,0x18,0x0C,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0x3C,0x3E,0xF8,0x3B,0xF0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x96
{0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0x3C,0x3E,0xF8,0x3B,0xF0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x97
{0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x06,0x30,0x06,0x00,0x00,0x00,0x00,0x1E,0x70,0x1C,0x30,0x1C,0x38,0x38,0x18,0x38,0x1C,0x78,0x1C,0x70,0x0E,0xF0,0x0E,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0x80,0x01,0xC0,0x01,0xC0,0x00,0xE0,0x00,0x7C,0x00,0x3C,0x00},  // 0x98
{0x30,0x0C,0x30,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x99
{0x60,0x18,0x60,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x33,0xF8,0x1F,0x3C,0x1E,0x1C,0x1E,0x0E,0x3B,0x0E,0x39,0x8E,0x39,0xCE,0x38,0x6E,0x38,0x6E,0x38,0x3C,0x1C,0x3C,0x1E,0xFC,0x0F,0xE6,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9B
{0x00,0x00,0x00,0x00,0x00,0x3E,0x80,0x3F,0x80,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xF0,0x0F,0xF0,0x0F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xE0,0x00,0x70,0x00,0xF8,0x3F,0xF8,0x3F,0xF8,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x67,0xF0,0x3F,0x38,0x1C,0x1C,0x3C,0x1C,0x3C,0x0E,0x76,0x0E,0x73,0x8E,0x71,0x8E,0x71,0xCE,0x70,0x6E,0x70,0x3C,0x38,0x3C,0x38,0x38,0x1C,0xFC,0x0F,0xE6,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x20,0x0E,0x70,0x1C,0x38,0x38,0x1C,0x70,0x0E,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xE0,0x07,0x70,0x0E,0x38,0x1C,0x1C,0x38,0x0E,0x70,0x04,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x9E
{0x00,0x00,0x00,0x3F,0x80,0x3F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xF8,0x1F,0xF8,0x1F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFE,0x00,0x7E,0x00},  // 0x9F
{0x00,0x00,0x00,0x06,0x00,0x03,0x80,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA0
{0x00,0x00,0x00,0x06,0x00,0x03,0x80,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA1
{0x00,0x00,0x00,0x06,0x00,0x03,0x80,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x0F,0x3C,0x1E,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA2
{0x00,0x00,0x00,0x06,0x00,0x03,0x80,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0x3C,0x3E,0xF8,0x3B,0xF0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA3
{0x00,0x00,0x00,0x00,0xE0,0x0C,0xF0,0x0F,0x30,0x07,0x00,0x00,0x00,0x00,0x1C,0x0F,0xDC,0x1F,0x7C,0x3C,0x3C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA4
{0xE0,0x0C,0xF0,0x0F,0x30,0x07,0x00,0x00,0x00,0x00,0x1C,0x30,0x1C,0x30,0x3C,0x30,0x7C,0x30,0x7C,0x30,0xFC,0x30,0xEC,0x31,0xCC,0x31,0xCC,0x33,0x8C,0x37,0x0C,0x3F,0x0C,0x3E,0x0C,0x3E,0x0C,0x3C,0x0C,0x38,0x0C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA5
{0x00,0x00,0x00,0x00,0xE0,0x03,0xF0,0x07,0x10,0x06,0xE0,0x07,0xF0,0x07,0x38,0x06,0x18,0x06,0x18,0x07,0xF8,0x1F,0xF0,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA6
{0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0xC0,0x01,0xE0,0x01,0xF0,0x00,0x78,0x00,0x38,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x30,0x3C,0x30,0xF8,0x3F,0xE0,0x1F},  // 0xA8
{0x00,0x00,0x00,0x00,0xE0,0x03,0x10,0x04,0xE8,0x09,0x24,0x12,0x24,0x12,0xE4,0x11,0x24,0x11,0x24,0x11,0x28,0x0B,0x10,0x04,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAA
{0x00,0x00,0x00,0x00,0x1F,0x0C,0x1F,0x06,0x1C,0x06,0x1C,0x03,0x1C,0x03,0x9C,0x01,0x9C,0x01,0xDC,0x00,0xDC,0x00,0x7C,0x3C,0x30,0xFE,0x30,0xE0,0x18,0xE0,0x18,0x70,0x0C,0x38,0x0C,0x0C,0x06,0x06,0x06,0xFE,0x03,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAB
{0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x0C,0x1C,0x0C,0x1C,0x06,0x1C,0x06,0x1C,0x03,0x1C,0x03,0x9C,0x01,0x9C,0x01,0xDC,0x38,0x60,0x3C,0x60,0x3A,0x30,0x39,0xB0,0x39,0xD8,0x38,0xD8,0xFF,0x0C,0x38,0x0C,0x38,0x06,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01},  // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x10,0xE0,0x38,0x70,0x1C,0x38,0x0E,0x1C,0x07,0x0C,0x03,0x8E,0x03,0x1C,0x07,0x38,0x0E,0x70,0x1C,0xE0,0x38,0x40,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x01,0x9C,0x03,0x38,0x07,0x70,0x0E,0xE0,0x1C,0xC0,0x39,0xC0,0x18,0xE0,0x1C,0x70,0x0E,0x38,0x07,0x9C,0x03,0x08,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xAF
{0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0x00,0x00,0x00,0x00,0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0x00,0x00,0x00,0x00,0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0x00,0x00,0x00,0x00,0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0x00,0x00,0x00,0x00},  // 0xB0
{0x38,0xE7,0x38,0xE7,0x38,0xE7,0xE7,0x1C,0xE7,0x1C,0xFF,0xFF,0x38,0xE7,0x38,0xE7,0xE7,0x1C,0xE7,0x1C,0xFF,0xFF,0x38,0xE7,0x38,0xE7,0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0x38,0xE7,0x38,0xE7,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C,0x38,0xE7,0x38,0xE7,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C},  // 0xB1
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C,0xE7,0x1C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x1C,0xE7,0x1C},  // 0xB2
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xB3
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0x01,0xFF,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xB4
{0x00,0x07,0x80,0x03,0xC0,0x01,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x03,0xE0,0x03,0x60,0x07,0x60,0x07,0x70,0x06,0x30,0x0E,0x38,0x0E,0x38,0x1C,0x18,0x1C,0xFC,0x3F,0xFC,0x3F,0x0E,0x38,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB5
{0xE0,0x03,0x70,0x07,0x38,0x0E,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x03,0xE0,0x03,0x60,0x07,0x60,0x07,0x70,0x06,0x30,0x0E,0x38,0x0E,0x38,0x1C,0x18,0x1C,0xFC,0x3F,0xFC,0x3F,0x0E,0x38,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB6
{0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x03,0xE0,0x03,0x60,0x07,0x60,0x07,0x70,0x06,0x30,0x0E,0x38,0x0E,0x38,0x1C,0x18,0x1C,0xFC,0x3F,0xFC,0x3F,0x0E,0x38,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB7
{0x00,0x00,0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x38,0x38,0x1C,0x70,0x8C,0x6F,0xEE,0xEF,0x66,0xC8,0x36,0xC0,0x36,0xC0,0x36,0xC0,0x36,0xC0,0x36,0xC0,0x66,0xC8,0xEE,0xEF,0x8C,0x67,0x1C,0x70,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xB8
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x7F,0x06,0x7F,0x06,0x00,0x06,0x00,0x06,0x7F,0x06,0x7F,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xB9
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x07,0xFF,0x07,0x00,0x06,0x00,0x06,0x7F,0x06,0x7F,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xBB
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x7F,0x06,0x7F,0x06,0x00,0x06,0x00,0x06,0xFF,0x07,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xBC
{0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0xC0,0x0F,0xF0,0x0F,0xB8,0x09,0xB8,0x01,0x9C,0x01,0x9C,0x01,0x9C,0x01,0x9C,0x01,0x9C,0x01,0x9C,0x01,0x9C,0x01,0xB8,0x01,0xF8,0x09,0xF0,0x0F,0xE0,0x07,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xBD
{0x00,0x00,0x00,0x00,0x0E,0xE0,0x1C,0x60,0x38,0x30,0x38,0x30,0x70,0x18,0xE0,0x0C,0xE0,0x0C,0xC0,0x07,0x80,0x03,0xF8,0x3F,0xF8,0x3F,0x80,0x03,0x80,0x03,0x80,0x03,0xF8,0x3F,0xF8,0x3F,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xFF,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xBF
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xFF,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC0
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xC2
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xFF,0x80,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC4
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xC5
{0x00,0x00,0x00,0x00,0xE0,0x0C,0xF0,0x0F,0x30,0x07,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x0F,0x18,0x1E,0x00,0x1C,0x00,0x1C,0xE0,0x1F,0xF0,0x1F,0x38,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0xF8,0x7B,0xF0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC6
{0xE0,0x0C,0xF0,0x0F,0x30,0x07,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x03,0xE0,0x03,0x60,0x07,0x60,0x07,0x70,0x06,0x30,0x0E,0x38,0x0E,0x38,0x1C,0x18,0x1C,0xFC,0x3F,0xFC,0x3F,0x0E,0x38,0x0E,0x70,0x0E,0x70,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC7
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0xFE,0x60,0xFE,0x60,0x00,0x60,0x00,0xE0,0xFF,0xE0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xE0,0xFF,0x60,0x00,0x60,0x00,0x60,0xFE,0x60,0xFE,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xC9
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x7F,0xFE,0x7F,0xFE,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFE,0x7F,0xFE,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xCB
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0xFE,0x60,0xFE,0x60,0x00,0x60,0x00,0x60,0xFE,0x60,0xFE,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xCD
{0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x7F,0xFE,0x7F,0xFE,0x00,0x00,0x00,0x00,0x7F,0xFE,0x7F,0xFE,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06},  // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x20,0xCC,0x33,0xF8,0x1F,0x30,0x0C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x30,0x0C,0xF8,0x1F,0xCC,0x33,0x04,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xCF
{0x00,0x00,0x1E,0x03,0xFE,0x03,0xF0,0x01,0xF0,0x03,0x18,0x07,0x00,0x0E,0xE0,0x0F,0xF8,0x1F,0x3C,0x1E,0x1C,0x3C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x0F,0x1C,0x3C,0x1C,0x38,0x1C,0x78,0x1C,0x70,0x1C,0x70,0xFF,0x70,0xFF,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x38,0x1C,0x38,0x1C,0x1E,0xFC,0x0F,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD1
{0xC0,0x07,0xE0,0x0E,0x70,0x1C,0x00,0x00,0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x1F,0xF8,0x1F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x7F,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD2
{0x60,0x18,0x60,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x1F,0xF8,0x1F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x7F,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD3
{0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x1F,0xF8,0x1F,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x7F,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD5
{0x00,0x07,0x80,0x03,0xC0,0x01,0x00,0x00,0x00,0x00,0xFC,0x1F,0xFC,0x1F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD6
{0xE0,0x03,0x70,0x07,0x38,0x0E,0x00,0x00,0x00,0x00,0xFC,0x1F,0xFC,0x1F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD7
{0x30,0x0C,0x30,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x1F,0xFC,0x1F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD8
{0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0x01,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x80,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01},  // 0xDA
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},  // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},  // 0xDC
{0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00},  // 0xDD
{0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x00,0xFC,0x1F,0xFC,0x1F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xDE
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xDF
{0x00,0x07,0x80,0x03,0xC0,0x01,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE0
{0x00,0x00,0xF0,0x03,0xF8,0x07,0x3C,0x0E,0x1C,0x0E,0x1C,0x0E,0x1C,0x06,0x1C,0x07,0x9C,0x03,0x9C,0x03,0x9C,0x03,0x9C,0x07,0x1C,0x0F,0x1C,0x1E,0x1C,0x3C,0x1C,0x78,0x1C,0x70,0x1C,0x70,0x9C,0x70,0x9C,0x3F,0x1C,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE1
{0xE0,0x03,0x70,0x07,0x38,0x0E,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE2
{0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE3
{0x00,0x00,0x00,0x00,0xE0,0x0C,0xF0,0x0F,0x30,0x07,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x0F,0x3C,0x1E,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x1C,0x1C,0x3C,0x1E,0xF8,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE4
{0xE0,0x0C,0xF0,0x0F,0x30,0x07,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x38,0x1C,0x1C,0x38,0x1C,0x38,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1C,0x38,0x1C,0x38,0x38,0x1C,0xF0,0x0F,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x3C,0x3C,0x7C,0x3E,0xFC,0x3B,0xDC,0x7B,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00},  // 0xE6
{0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x9C,0x07,0xDC,0x1F,0x7C,0x1C,0x3C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x1C,0x3C,0x1E,0xFC,0x0F,0x9C,0x07,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00},  // 0xE7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xF8,0x1F,0xF8,0x3F,0x38,0x78,0x38,0x70,0x38,0x70,0x38,0x70,0x38,0x78,0x38,0x3C,0xF8,0x1F,0xF8,0x07,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE8
{0x00,0x07,0x80,0x03,0xC0,0x01,0x00,0x00,0x00,0x00,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xE9
{0xE0,0x03,0x70,0x07,0x38,0x0E,0x00,0x00,0x00,0x00,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEA
{0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x00,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEB
{0x00,0x00,0x00,0x06,0x00,0x03,0x80,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x1E,0x70,0x1C,0x30,0x1C,0x38,0x38,0x18,0x38,0x1C,0x78,0x1C,0x70,0x0E,0xF0,0x0E,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0x80,0x01,0xC0,0x01,0xC0,0x00,0xE0,0x00,0x7C,0x00,0x3C,0x00},  // 0xEC
{0x00,0x07,0x80,0x03,0xC0,0x01,0x00,0x00,0x00,0x00,0x07,0xE0,0x0E,0x70,0x1C,0x30,0x1C,0x18,0x38,0x1C,0x78,0x0E,0x70,0x07,0xE0,0x03,0xE0,0x03,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xED
{0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEE
{0x80,0x03,0xC0,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0xF8,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFE,0x7F,0xFE,0x7F,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFF},  // 0xF2
{0x00,0x00,0x00,0x00,0x7E,0xE0,0xFE,0x70,0xE0,0x38,0xE0,0x38,0x3C,0x1C,0x7C,0x1C,0xE0,0x0E,0xE0,0x07,0xFE,0x07,0xBE,0x3B,0xC0,0x3D,0xC0,0x3B,0xE0,0x39,0xF0,0x39,0xF0,0x38,0xF8,0xFF,0x38,0x38,0x1C,0x38,0x0E,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF3
{0x00,0x00,0x00,0x00,0xF8,0x1F,0xFC,0x1F,0xFE,0x18,0xFE,0x18,0xFE,0x18,0xFE,0x18,0xFE,0x18,0xFC,0x18,0xF8,0x18,0xF0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0x00,0x00},  // 0xF4
{0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x1F,0x78,0x10,0x38,0x00,0x38,0x00,0x78,0x00,0xF0,0x01,0xE0,0x07,0xF0,0x0F,0x30,0x1E,0x38,0x3C,0x38,0x38,0x78,0x38,0xF0,0x19,0xE0,0x0F,0x80,0x0F,0x00,0x1E,0x00,0x3C,0x00,0x38,0x00,0x38,0x18,0x3C,0xF8,0x1F,0xE0,0x07,0x00,0x00},  // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x3F,0xFE,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0xC0,0x03},  // 0xF7
{0x00,0x00,0x00,0x00,0xE0,0x00,0x10,0x01,0x10,0x01,0x10,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF8
{0x30,0x0C,0x30,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFA
{0x00,0x00,0x00,0x00,0xE0,0x03,0xE0,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFB
{0x00,0x00,0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x10,0x1C,0x00,0x1C,0xC0,0x07,0xC0,0x0F,0x00,0x1C,0x00,0x1C,0xF0,0x1F,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFC
{0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x1F,0x10,0x1C,0x00,0x1C,0x00,0x0E,0x80,0x07,0xC0,0x01,0x70,0x00,0xF0,0x1F,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}   // 0xFF
};
#endif

#ifdef USE_FONT_22X36
__UG_FONT_DATA unsigned char font_22x36[256][108]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x00
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xF0,0xC0,0x03,0x38,0x00,0x07,0x1C,0x00,0x0E,0xCC,0xE1,0x0C,0xCE,0xE1,0x1C,0xC6,0xE1,0x18,0x06,0x00,0x18,0x06,0x00,0x18,0x26,0x00,0x19,0x66,0x80,0x19,0xCE,0xC0,0x1C,0x8C,0x7F,0x0C,0x1C,0x3F,0x0E,0x38,0x00,0x07,0xF0,0xC0,0x03,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x01
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xF0,0xFF,0x03,0xF8,0xFF,0x07,0xFC,0xFF,0x0F,0x3C,0x1E,0x0F,0x3E,0x1E,0x1F,0x3E,0x1E,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xDE,0xFF,0x1E,0x9E,0x7F,0x1E,0x9E,0x7F,0x1F,0x3C,0x1E,0x0F,0x7C,0x80,0x0F,0xF8,0xE1,0x07,0xF0,0xFF,0x03,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x02
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xC0,0x07,0xFC,0xE1,0x0F,0xFE,0xF3,0x1F,0xFE,0xFF,0x1F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0xF0,0xFF,0x03,0xE0,0xFF,0x01,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x80,0x7F,0x00,0x00,0x3F,0x00,0x00,0x1E,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x03
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x0C,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x80,0x3F,0x00,0x80,0x7F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xFF,0x07,0xFC,0xFF,0x0F,0xFE,0xFF,0x1F,0xFF,0xFF,0x3F,0xFE,0xFF,0x1F,0xFC,0xFF,0x0F,0xF8,0xFF,0x07,0xF0,0xFF,0x03,0xE0,0xFF,0x01,0xE0,0xFF,0x00,0xC0,0x7F,0x00,0x80,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x0C,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x04
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x80,0x7F,0x00,0x80,0x7F,0x00,0xC0,0xFF,0x00,0xC0,0xFF,0x00,0xC0,0xFF,0x00,0xC0,0xFF,0x00,0x80,0x7F,0x00,0x80,0x7F,0x00,0x78,0xBF,0x07,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFE,0xF5,0x1F,0xFE,0xEE,0x0F,0x78,0xCE,0x07,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x05
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x0C,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x80,0x3F,0x00,0x80,0x7F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x01,0xF0,0xFF,0x03,0xF8,0xFF,0x07,0xFC,0xFF,0x0F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFE,0xF5,0x1F,0xFE,0xEE,0x1F,0x78,0x8E,0x07,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0xC0,0x0F,0x00,0xFC,0x0F,0x00,0xF8,0x0F,0x00,0x98,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x19,0x00,0xE0,0x39,0x00,0xE0,0x38,0xC0,0x7F,0x08,0xF0,0x7F,0x00,0xF8,0x7F,0x00,0x3C,0xF0,0x00,0x1E,0xE0,0x01,0x0E,0xC0,0x01,0x07,0x80,0x03,0x07,0x80,0x03,0x07,0x80,0x03,0x07,0x80,0x03,0x07,0x80,0x03,0x0E,0xC0,0x01,0x1E,0xE0,0x01,0x3C,0xF0,0x00,0xF8,0x7F,0x00,0xF0,0x3F,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x01,0xF0,0xC0,0x03,0x78,0x80,0x07,0x38,0x00,0x07,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x38,0x00,0x0F,0x78,0x80,0x07,0xF0,0xC1,0x03,0xE0,0xFF,0x03,0xC0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x0E,0x00,0xC0,0x0F,0x00,0xF0,0x0F,0x00,0xFC,0x0F,0x00,0xFF,0x0C,0x80,0x3F,0x0C,0x80,0x0F,0x0C,0x80,0x03,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0x01,0x0C,0x80,0xC1,0x0F,0x80,0xF1,0x0F,0x80,0xF9,0x07,0x80,0xF9,0x07,0x80,0xF9,0x03,0x80,0xF1,0x00,0xF8,0x01,0x00,0xFE,0x01,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x10,0x1C,0x02,0x78,0x3F,0x07,0xF0,0xFF,0x03,0xE0,0xFF,0x01,0xE0,0xE1,0x01,0xF0,0xC0,0x03,0x7E,0x80,0x1F,0x7E,0x80,0x1F,0x7E,0x80,0x1F,0x70,0x80,0x03,0xF0,0xC0,0x03,0xE0,0xE1,0x01,0xE0,0xFF,0x03,0xF0,0xFF,0x03,0x38,0x3F,0x07,0x10,0x1C,0x02,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x0E,0x00,0x00,0x3E,0x00,0x00,0xFE,0x00,0x00,0xFE,0x03,0x00,0xFE,0x07,0x00,0xFE,0x1F,0x00,0xFE,0x7F,0x00,0xFE,0xFF,0x01,0xFE,0xFF,0x07,0xFE,0xFF,0x1F,0xFE,0xFF,0x07,0xFE,0xFF,0x01,0xFE,0x7F,0x00,0xFE,0x1F,0x00,0xFE,0x07,0x00,0xFE,0x03,0x00,0xFE,0x00,0x00,0x3E,0x00,0x00,0x0E,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x10
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x1C,0x00,0x00,0x1F,0x00,0xC0,0x1F,0x00,0xF0,0x1F,0x00,0xF8,0x1F,0x00,0xFE,0x1F,0x80,0xFF,0x1F,0xE0,0xFF,0x1F,0xF8,0xFF,0x1F,0xFE,0xFF,0x1F,0xF8,0xFF,0x1F,0xE0,0xFF,0x1F,0x80,0xFF,0x1F,0x00,0xFE,0x1F,0x00,0xF8,0x1F,0x00,0xF0,0x1F,0x00,0xC0,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x11
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x1C,0x00,0x00,0x3E,0x00,0x00,0x7F,0x00,0x80,0xFF,0x00,0xC0,0xDD,0x01,0x40,0x1C,0x01,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x40,0x1C,0x01,0xC0,0xDD,0x01,0x80,0xFF,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x12
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x13
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xF8,0x07,0x03,0xF0,0x07,0x03,0xE0,0x07,0x03,0x80,0x07,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x14
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x01,0xE0,0xFF,0x01,0xE0,0x81,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0x00,0x00,0xE0,0x03,0x00,0xE0,0x0F,0x00,0xC0,0x3F,0x00,0xC0,0x7F,0x00,0xE0,0xF8,0x01,0x70,0xE0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF0,0x80,0x03,0xF0,0x81,0x03,0xE0,0x83,0x01,0xC0,0xDF,0x01,0x80,0xFF,0x00,0x00,0xFE,0x00,0x00,0xF8,0x01,0x00,0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x10,0x80,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x16
{0x00,0x08,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x7F,0x00,0x80,0xFF,0x00,0xC0,0xDD,0x01,0x40,0x1C,0x01,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x40,0x1C,0x01,0xC0,0xDD,0x01,0x80,0xFF,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0x00,0x00,0x00}, // 0x17
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x1C,0x00,0x00,0x3E,0x00,0x00,0x7F,0x00,0x80,0xFF,0x00,0xC0,0xDD,0x01,0x40,0x1C,0x01,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x18
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x40,0x1C,0x01,0xC0,0xDD,0x01,0x80,0xFF,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0xC0,0x00,0x00,0xC0,0x01,0x00,0x80,0x03,0xFC,0xFF,0x07,0xFC,0xFF,0x0F,0xFC,0xFF,0x07,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0xC0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0xF8,0xFF,0x0F,0xFC,0xFF,0x0F,0xF8,0xFF,0x0F,0x70,0x00,0x00,0xE0,0x00,0x00,0xC0,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x61,0x00,0xC0,0xC0,0x00,0xE0,0xC0,0x01,0x70,0x80,0x03,0xF8,0xFF,0x07,0xFC,0xFF,0x0F,0xF8,0xFF,0x07,0x70,0x80,0x03,0xE0,0xC0,0x01,0xC0,0xC0,0x00,0x80,0x61,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x80,0x3F,0x00,0x80,0x7F,0x00,0xC0,0x7F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xFE,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x1F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0xF8,0xFF,0x03,0xF0,0xFF,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x01,0xE0,0xFF,0x00,0xC0,0xFF,0x00,0xC0,0x7F,0x00,0x80,0x7F,0x00,0x80,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x20
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x21
{0xF0,0xE0,0x01,0xF0,0xE0,0x01,0xF0,0xE0,0x01,0xF0,0xE0,0x01,0xF0,0xE0,0x01,0xF0,0xE0,0x01,0x60,0xC0,0x00,0x60,0xC0,0x00,0x60,0xC0,0x00,0x60,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x22
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x07,0x00,0x0E,0x07,0x00,0x87,0x03,0x00,0x87,0x03,0x00,0x87,0x03,0x00,0x87,0x03,0x80,0xC3,0x01,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0xFE,0xFF,0x07,0xFE,0xFF,0x07,0xFE,0xFF,0x07,0xE0,0x70,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x23
{0x00,0x0C,0x00,0x00,0x0C,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xE0,0xFF,0x01,0xE0,0x8D,0x01,0xF0,0x0C,0x00,0x70,0x0C,0x00,0x70,0x0C,0x00,0x70,0x0C,0x00,0xF0,0x0C,0x00,0xE0,0x0D,0x00,0xC0,0x0F,0x00,0x80,0x0F,0x00,0x00,0x1F,0x00,0x00,0x7E,0x00,0x00,0xFC,0x00,0x00,0xFC,0x01,0x00,0xCC,0x01,0x00,0xCC,0x03,0x00,0x8C,0x03,0x00,0x8C,0x03,0x00,0x8C,0x03,0x08,0xCC,0x03,0x38,0xEC,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x00,0xC0,0x3F,0x00,0x00,0x0C,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x24
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x38,0xFC,0x01,0x1C,0x8E,0x03,0x0E,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x87,0x03,0x07,0xC7,0x01,0x07,0xC7,0x01,0x07,0xE7,0x00,0x8E,0x73,0x00,0xFC,0x39,0x00,0xF8,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0xC7,0x07,0x00,0xE7,0x0F,0x80,0x73,0x1C,0xC0,0x39,0x38,0xE0,0x38,0x38,0xE0,0x38,0x38,0x70,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x1C,0x70,0x1C,0x0E,0xE0,0x0F,0x07,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x25
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x80,0x7F,0x00,0xC0,0x7F,0x00,0xE0,0xF1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0x70,0x00,0xC0,0x79,0x00,0xC0,0x3F,0x00,0xC0,0x0F,0x00,0xE0,0x07,0x00,0xF8,0x07,0x38,0x3C,0x07,0x38,0x1E,0x0E,0x38,0x0E,0x1E,0x38,0x07,0x3C,0x18,0x07,0x3C,0x1C,0x07,0x78,0x1C,0x07,0xF0,0x0E,0x0F,0xE0,0x0F,0x1E,0xE0,0x07,0x7E,0xC0,0x07,0xFC,0xFF,0x0F,0xF8,0xFF,0x0F,0xC0,0x1F,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x26
{0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x06,0x00,0x00,0x06,0x00,0x00,0x06,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x27
{0x00,0x00,0x06,0x00,0xC0,0x07,0x00,0xF0,0x01,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x00,0xF0,0x01,0x00,0xC0,0x07,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x28
{0x38,0x00,0x00,0xF8,0x00,0x00,0xE0,0x03,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xE0,0x03,0x00,0xF8,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x29
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x30,0x0E,0x03,0xF8,0xC4,0x07,0xF8,0xE1,0x07,0xE0,0xE1,0x01,0x00,0x00,0x00,0x00,0x33,0x00,0x80,0x7F,0x00,0xC0,0xF3,0x00,0xE0,0xE1,0x01,0xE0,0xC0,0x01,0x80,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0C,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2E
{0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0xC0,0x7F,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x70,0xC0,0x01,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x70,0xC0,0x01,0xF0,0xE0,0x01,0xE0,0xFF,0x00,0xC0,0x7F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x30
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x1F,0x00,0xE0,0x1F,0x00,0xF8,0x1F,0x00,0x78,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xF8,0xFF,0x0F,0xF8,0xFF,0x0F,0xF8,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x31
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x1F,0x00,0xF0,0x7F,0x00,0xF0,0xFF,0x00,0x70,0xF0,0x00,0x10,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x32
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0x00,0xF0,0x7F,0x00,0xF0,0xFF,0x00,0x30,0xF0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0x78,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x7F,0x00,0x00,0xF8,0x00,0x00,0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x03,0x00,0xC0,0x01,0x30,0xF0,0x01,0xF0,0xFF,0x00,0xF0,0x7F,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x33
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,0xF0,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0xFC,0x00,0x00,0xEE,0x00,0x00,0xEE,0x00,0x00,0xE7,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0x70,0xE0,0x00,0x70,0xE0,0x00,0x38,0xE0,0x00,0x1C,0xE0,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x34
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x0F,0x00,0xE0,0x3F,0x00,0xE0,0x7F,0x00,0x00,0xF8,0x00,0x00,0xF0,0x00,0x00,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x00,0x60,0xF0,0x00,0xE0,0x7F,0x00,0xE0,0x3F,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x35
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0xFF,0x03,0x80,0xFF,0x03,0xC0,0x03,0x03,0xE0,0x01,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x3E,0x00,0x38,0xFF,0x00,0xB8,0xFF,0x01,0xF8,0xE1,0x03,0x78,0x80,0x03,0x78,0x80,0x07,0x78,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x07,0xF0,0x80,0x03,0xE0,0xC1,0x03,0xC0,0xFF,0x01,0x80,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x36
{0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0x80,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x37
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x01,0xE0,0xE0,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0xF0,0x80,0x03,0xE0,0xC0,0x01,0xE0,0xE3,0x00,0xC0,0x77,0x00,0x80,0x3F,0x00,0x80,0x7F,0x00,0xE0,0xFD,0x00,0xE0,0xF0,0x01,0x70,0xE0,0x03,0x38,0x80,0x07,0x38,0x80,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x07,0xF0,0xC1,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x38
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0x7F,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x70,0xC0,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x80,0x07,0x78,0x80,0x07,0x70,0xC0,0x07,0xF0,0xE1,0x07,0xE0,0x7F,0x07,0xC0,0x3F,0x07,0x80,0x1F,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xE0,0x01,0x30,0xF0,0x00,0xF0,0x7F,0x00,0xF0,0x3F,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0C,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x0E,0x00,0x80,0x0F,0x00,0xE0,0x07,0x00,0xF8,0x01,0x00,0x7C,0x00,0x00,0x1F,0x00,0xC0,0x07,0x00,0xF0,0x03,0x00,0xFC,0x00,0x00,0xF0,0x01,0x00,0xC0,0x07,0x00,0x00,0x1F,0x00,0x00,0x7C,0x00,0x00,0xF8,0x01,0x00,0xE0,0x07,0x00,0x80,0x0F,0x00,0x00,0x0E,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x1C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x01,0x00,0xE0,0x07,0x00,0x80,0x0F,0x00,0x00,0x3E,0x00,0x00,0xF8,0x00,0x00,0xF0,0x03,0x00,0xC0,0x0F,0x00,0xE0,0x03,0x00,0xF8,0x00,0x00,0x3E,0x00,0x80,0x0F,0x00,0xE0,0x07,0x00,0xF8,0x01,0x00,0x7C,0x00,0x00,0x1C,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3E
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x3F,0x00,0xF8,0xFF,0x01,0xF8,0xFF,0x03,0x38,0xC0,0x07,0x38,0x80,0x07,0x38,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x06,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x80,0xFF,0x03,0xC0,0x83,0x07,0xE0,0x00,0x07,0x70,0x00,0x0E,0x38,0xF0,0x0F,0x38,0xF8,0x0F,0x1C,0x1C,0x0E,0x1C,0x0E,0x0E,0x1E,0x0E,0x0E,0x0E,0x06,0x0E,0x0E,0x07,0x0E,0x0E,0x07,0x0F,0x0E,0x07,0x0F,0x0E,0x87,0x0F,0x0E,0x87,0x0F,0x0E,0xC7,0x0E,0x0E,0xEF,0x0E,0x1C,0x7E,0x0E,0x1C,0x7E,0x3E,0x38,0x3C,0x3E,0x38,0x00,0x00,0x70,0x00,0x00,0xE0,0x81,0x01,0xC0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x40
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x7B,0x00,0xC0,0x71,0x00,0xC0,0xF1,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x1E,0x00,0x1E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x41
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x3F,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x01,0x38,0xE0,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x01,0x38,0xF0,0x01,0xF8,0x7F,0x00,0xF8,0x1F,0x00,0xF8,0xFF,0x00,0x38,0xF0,0x01,0x38,0xC0,0x03,0x38,0x80,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0xC0,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x01,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x42
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0x00,0xFF,0x1F,0xC0,0xFF,0x1F,0xE0,0x07,0x1C,0xF0,0x01,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x43
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0xFC,0x7F,0x00,0xFC,0xFF,0x00,0x1C,0xF0,0x01,0x1C,0xC0,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0xC0,0x03,0x1C,0xE0,0x01,0x1C,0xF8,0x01,0xFC,0xFF,0x00,0xFC,0x3F,0x00,0xFC,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x44
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x45
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x46
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0E,0xF8,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0xF0,0x0F,0x0E,0xF0,0x0F,0x0E,0xF0,0x0F,0x1E,0x00,0x0E,0x1C,0x00,0x0E,0x3C,0x00,0x0E,0x7C,0x00,0x0E,0xF8,0x00,0x0E,0xF0,0x07,0x0E,0xE0,0xFF,0x0F,0x80,0xFF,0x0F,0x00,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x47
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x48
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x49
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x08,0x78,0x00,0xF8,0x3F,0x00,0xF8,0x1F,0x00,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x07,0x38,0xC0,0x03,0x38,0xE0,0x01,0x38,0xF0,0x00,0x38,0x78,0x00,0x38,0x38,0x00,0x38,0x3C,0x00,0x38,0x1E,0x00,0x38,0x0F,0x00,0xB8,0x07,0x00,0xB8,0x03,0x00,0xF8,0x07,0x00,0xB8,0x07,0x00,0x38,0x0F,0x00,0x38,0x1E,0x00,0x38,0x3C,0x00,0x38,0x78,0x00,0x38,0xF0,0x00,0x38,0xE0,0x01,0x38,0xC0,0x03,0x38,0x80,0x07,0x38,0x00,0x0F,0x38,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x1F,0x7C,0x00,0x1F,0xFC,0x00,0x1F,0xFC,0x80,0x1F,0xFC,0x80,0x1F,0xDC,0x81,0x1D,0xDC,0xC1,0x1D,0xDC,0xC1,0x1D,0x9C,0xC3,0x1C,0x9C,0xE3,0x1C,0x9C,0x63,0x1C,0x1C,0x67,0x1C,0x1C,0x77,0x1C,0x1C,0x37,0x1C,0x1C,0x3E,0x1C,0x1C,0x3E,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0E,0x78,0x00,0x0E,0xF8,0x00,0x0E,0xF8,0x01,0x0E,0xF8,0x01,0x0E,0xF8,0x03,0x0E,0xB8,0x03,0x0E,0x38,0x07,0x0E,0x38,0x0F,0x0E,0x38,0x0E,0x0E,0x38,0x1E,0x0E,0x38,0x1C,0x0E,0x38,0x3C,0x0E,0x38,0x38,0x0E,0x38,0x70,0x0E,0x38,0xF0,0x0E,0x38,0xE0,0x0E,0x38,0xE0,0x0F,0x38,0xC0,0x0F,0x38,0x80,0x0F,0x38,0x80,0x0F,0x38,0x00,0x0F,0x38,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x07,0x70,0x80,0x07,0x70,0x00,0x0F,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x07,0x70,0xC0,0x07,0xF0,0xFF,0x03,0xF0,0xFF,0x00,0xF0,0x3F,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x50
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xC0,0x7F,0x00,0x80,0x7F,0x00,0x00,0xE0,0x01,0x00,0xC0,0x0F,0x00,0x80,0x3F,0x00,0x00,0x1E,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x51
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x7F,0x00,0xF8,0xFF,0x00,0x38,0xF0,0x01,0x38,0xC0,0x01,0x38,0xC0,0x01,0x38,0xC0,0x01,0x38,0xC0,0x01,0x38,0xE0,0x01,0x38,0xE0,0x00,0x38,0xF8,0x00,0xF8,0x7F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x38,0x3C,0x00,0x38,0x3C,0x00,0x38,0x78,0x00,0x38,0xF0,0x00,0x38,0xE0,0x01,0x38,0xC0,0x03,0x38,0x80,0x03,0x38,0x80,0x07,0x38,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x52
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0xE0,0xFF,0x03,0xF0,0xFF,0x03,0xF0,0x80,0x03,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x07,0x00,0xE0,0x3F,0x00,0x80,0xFF,0x00,0x00,0xFC,0x01,0x00,0xF0,0x03,0x00,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x08,0x80,0x07,0x78,0xC0,0x03,0xF8,0xFF,0x01,0xF8,0xFF,0x00,0xC0,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x53
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x1F,0xFF,0xFF,0x1F,0xFF,0xFF,0x1F,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x54
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x07,0x70,0x80,0x03,0xF0,0xE0,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x55
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x38,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x1E,0x00,0x0E,0x1C,0x00,0x0E,0x3C,0x00,0x0F,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x03,0x70,0x80,0x03,0xF0,0xC0,0x01,0xF0,0xC0,0x01,0xE0,0xE0,0x01,0xE0,0xE1,0x00,0xC0,0xF1,0x00,0xC0,0x73,0x00,0xC0,0x73,0x00,0x80,0x3B,0x00,0x80,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x56
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x38,0x07,0x00,0x38,0x07,0x00,0x38,0x0E,0x00,0x18,0x0E,0x00,0x18,0x0E,0x1E,0x1C,0x0E,0x1E,0x1C,0x0E,0x1E,0x1C,0x0E,0x3E,0x1C,0x0E,0x3F,0x0C,0x1C,0x3F,0x0C,0x1C,0x3B,0x0C,0x1C,0x73,0x0E,0x1C,0x73,0x0E,0x9C,0x73,0x0E,0x9C,0x73,0x06,0xB8,0xE1,0x06,0xB8,0xE1,0x06,0xB8,0xE1,0x06,0xF8,0xE1,0x07,0xF8,0xC0,0x07,0xF8,0xC0,0x03,0xF8,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x57
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x0F,0x70,0x80,0x07,0xF0,0xC0,0x03,0xE0,0xC1,0x01,0xC0,0xE3,0x01,0x80,0xF3,0x00,0x80,0x7F,0x00,0x00,0x3F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x3F,0x00,0x80,0x7F,0x00,0x80,0xF3,0x00,0xC0,0xE1,0x00,0xE0,0xE1,0x01,0xF0,0xC0,0x03,0x70,0x80,0x07,0x38,0x00,0x07,0x1C,0x00,0x0F,0x1E,0x00,0x1E,0x0F,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x58
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x3C,0x3C,0x00,0x1C,0x78,0x00,0x0E,0x78,0x00,0x0F,0xF0,0x00,0x07,0xE0,0x80,0x03,0xE0,0xC1,0x03,0xC0,0xC3,0x01,0x80,0xE3,0x00,0x80,0xF7,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x59
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x0F,0xF8,0xFF,0x0F,0xF8,0xFF,0x0F,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0x80,0x03,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5A
{0x00,0xFF,0x07,0x00,0xFF,0x07,0x00,0xFF,0x07,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0xFF,0x07,0x00,0xFF,0x07,0x00,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5B
{0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5C
{0xF8,0x3F,0x00,0xF8,0x3F,0x00,0xF8,0x3F,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xF8,0x3F,0x00,0xF8,0x3F,0x00,0xF8,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x3B,0x00,0x80,0x3B,0x00,0x80,0x71,0x00,0xC0,0x71,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xC0,0x01,0x60,0xC0,0x01,0x70,0x80,0x03,0x70,0x80,0x03,0x38,0x80,0x03,0x38,0x00,0x07,0x38,0x00,0x07,0x1C,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5F
{0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x61
{0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x7C,0x00,0x38,0xFF,0x00,0xB8,0xFF,0x01,0xF8,0xC1,0x03,0xF8,0x80,0x03,0x78,0x80,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF8,0xE1,0x01,0xF8,0xFF,0x01,0xB8,0xFF,0x00,0x18,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x80,0xFF,0x0F,0xC0,0xFF,0x0F,0xE0,0x03,0x0E,0xF0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0x70,0x00,0x00,0xF0,0x00,0x00,0xE0,0x03,0x0C,0xC0,0xFF,0x0F,0x80,0xFF,0x0F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x63
{0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x80,0x8F,0x03,0xE0,0xBF,0x03,0xF0,0xFF,0x03,0xF0,0xF0,0x03,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x3C,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF0,0x03,0xF0,0xBF,0x03,0xE0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x38,0xC0,0x01,0x38,0x80,0x03,0x1C,0x80,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x81,0x03,0xF0,0xFF,0x03,0xC0,0xFF,0x03,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x65
{0x00,0xF0,0x1F,0x00,0xFC,0x3F,0x00,0xFE,0x3F,0x00,0x1E,0x20,0x00,0x0F,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x8F,0x03,0xE0,0xBF,0x03,0xF0,0xFF,0x03,0xF0,0xF0,0x03,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x3C,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF0,0x03,0xF0,0xBF,0x03,0xE0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x70,0xE0,0x01,0xF0,0xFF,0x00,0xF0,0x7F,0x00,0xC0,0x1F,0x00,0x00,0x00,0x00}, // 0x67
{0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x7C,0x00,0x38,0xFF,0x01,0xB8,0xFF,0x01,0xF8,0xC3,0x03,0xF8,0x80,0x03,0x78,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x68
{0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x69
{0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x7F,0x00,0xF0,0x7F,0x00,0xF0,0x7F,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x18,0x38,0x00,0xF8,0x3F,0x00,0xF8,0x1F,0x00,0xE0,0x07,0x00,0x00,0x00,0x00}, // 0x6A
{0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x80,0x0F,0x70,0xC0,0x07,0x70,0xE0,0x03,0x70,0xF0,0x01,0x70,0xF8,0x00,0x70,0x7C,0x00,0x70,0x3E,0x00,0x70,0x1E,0x00,0x70,0x0F,0x00,0xF0,0x07,0x00,0x70,0x0F,0x00,0x70,0x1E,0x00,0x70,0x3C,0x00,0x70,0x78,0x00,0x70,0xF0,0x00,0x70,0xE0,0x01,0x70,0xC0,0x03,0x70,0x80,0x07,0x70,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6B
{0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x87,0x07,0x9C,0xCF,0x07,0xDC,0xCF,0x0F,0xFC,0x7C,0x0E,0x7C,0x3C,0x0E,0x3C,0x3C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x1C,0x1C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x00,0x38,0xFF,0x01,0xB8,0xFF,0x01,0xF8,0xC3,0x03,0xF8,0x80,0x03,0x78,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x00,0x38,0xFF,0x00,0xB8,0xFF,0x01,0xF8,0xC1,0x03,0xF8,0x80,0x03,0x78,0x80,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF8,0xE1,0x01,0xF8,0xFF,0x01,0xB8,0xFF,0x00,0x38,0x3E,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00}, // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x9F,0x03,0xE0,0xBF,0x03,0xF0,0xFF,0x03,0xF0,0xF0,0x03,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x3C,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF0,0x03,0xF0,0xBF,0x03,0xE0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x00}, // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xF0,0x07,0xE0,0xFC,0x07,0xE0,0xFE,0x07,0xE0,0x0F,0x07,0xE0,0x03,0x07,0xE0,0x01,0x07,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0x80,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0x00,0x00,0xE0,0x07,0x00,0xC0,0x3F,0x00,0x80,0xFF,0x00,0x00,0xFC,0x01,0x00,0xE0,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x10,0x80,0x03,0x70,0xE0,0x03,0xF0,0xFF,0x01,0xF0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x73
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x0F,0x00,0x00,0xFF,0x07,0x00,0xFF,0x07,0x00,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF8,0x03,0xF0,0xBF,0x03,0xF0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x1E,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x3C,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x03,0x70,0x80,0x03,0x70,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xE0,0x01,0xE0,0xE1,0x00,0xC0,0xF1,0x00,0xC0,0x73,0x00,0x80,0x73,0x00,0x80,0x3B,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x38,0x0F,0x00,0x38,0x0F,0x1E,0x18,0x0E,0x1E,0x18,0x0E,0x3E,0x1C,0x0E,0x3E,0x1C,0x0E,0x3F,0x1C,0x1E,0x33,0x0C,0x1C,0x73,0x0C,0x9C,0x73,0x0E,0x9C,0x73,0x0E,0x9C,0x61,0x0E,0xBC,0xE1,0x06,0xF8,0xE1,0x06,0xF8,0xE0,0x06,0xF8,0xC0,0x07,0xF8,0xC0,0x07,0xF8,0xC0,0x03,0x70,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x78,0x00,0x07,0xF0,0x80,0x03,0xE0,0xC1,0x03,0xC0,0xC1,0x01,0xC0,0xE3,0x00,0x80,0xF7,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3F,0x00,0x00,0x7F,0x00,0x80,0xF3,0x00,0xC0,0xE3,0x01,0xE0,0xC1,0x01,0xE0,0xC0,0x03,0x70,0x80,0x07,0x78,0x00,0x0F,0x3C,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x1C,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x38,0x00,0x07,0x38,0x00,0x07,0x70,0x80,0x03,0x70,0x80,0x03,0xF0,0x80,0x03,0xE0,0xC0,0x01,0xE0,0xC1,0x01,0xC0,0xE1,0x00,0xC0,0xE3,0x00,0x80,0x73,0x00,0x80,0x73,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0x7C,0x00,0x00,0x00,0x00,0x00}, // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0xC0,0x07,0x00,0xE0,0x03,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0xC0,0x07,0x00,0xE0,0x03,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7A
{0x00,0xF0,0x03,0x00,0xFC,0x03,0x00,0xFC,0x03,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0F,0x00,0xF0,0x07,0x00,0xF0,0x01,0x00,0xF0,0x07,0x00,0x00,0x0F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1E,0x00,0x00,0xFC,0x03,0x00,0xF8,0x03,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7B
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7C
{0xF0,0x03,0x00,0xF0,0x07,0x00,0xF0,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x3C,0x00,0x00,0xF8,0x03,0x00,0xE0,0x03,0x00,0xF8,0x03,0x00,0x3C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xF8,0x03,0x18,0xFC,0x07,0x18,0x0C,0x1F,0x1C,0x0E,0x3E,0x0C,0x06,0xF8,0x0F,0x06,0xF0,0x07,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x01,0xF0,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0x00,0xFF,0x1F,0xC0,0xFF,0x1F,0xE0,0x07,0x1C,0xF0,0x01,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x30,0x00,0x00,0x10,0x00,0x00,0x78,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xFC,0x00,0x00,0x7C,0x00}, // 0x80
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF8,0x03,0xF0,0xBF,0x03,0xF0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x81
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x38,0xC0,0x01,0x38,0x80,0x03,0x1C,0x80,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x81,0x03,0xF0,0xFF,0x03,0xC0,0xFF,0x03,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x82
{0x00,0x1E,0x00,0x00,0x3F,0x00,0x80,0x7F,0x00,0x80,0x73,0x00,0xC0,0xE1,0x00,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x83
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC3,0x01,0x80,0xC3,0x01,0x80,0xC3,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x84
{0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x85
{0x00,0x1E,0x00,0x00,0x33,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x33,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x80,0xFF,0x0F,0xC0,0xFF,0x0F,0xE0,0x03,0x0E,0xF0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0x70,0x00,0x00,0xF0,0x00,0x00,0xE0,0x03,0x0C,0xC0,0xFF,0x0F,0x80,0xFF,0x0F,0x00,0xFC,0x03,0x00,0x0C,0x00,0x00,0x04,0x00,0x00,0x1E,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00}, // 0x87
{0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x00,0xE7,0x00,0x80,0xC3,0x01,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x38,0xC0,0x01,0x38,0x80,0x03,0x1C,0x80,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x81,0x03,0xF0,0xFF,0x03,0xC0,0xFF,0x03,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x88
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC3,0x01,0x80,0xC3,0x01,0x80,0xC3,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x38,0xC0,0x01,0x38,0x80,0x03,0x1C,0x80,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x81,0x03,0xF0,0xFF,0x03,0xC0,0xFF,0x03,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x89
{0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x38,0xC0,0x01,0x38,0x80,0x03,0x1C,0x80,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x81,0x03,0xF0,0xFF,0x03,0xC0,0xFF,0x03,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8A
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC3,0x01,0x80,0xC3,0x01,0x80,0xC3,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8B
{0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x00,0xE7,0x00,0x80,0xC3,0x01,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8C
{0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8D
{0xE0,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x7B,0x00,0xC0,0x71,0x00,0xC0,0xF1,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x1E,0x00,0x1E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8E
{0x00,0x0E,0x00,0x00,0x11,0x00,0x00,0x11,0x00,0x00,0x11,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x3B,0x00,0xC0,0x79,0x00,0xC0,0x71,0x00,0xC0,0xF0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x01,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8F
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xE1,0x01,0xFC,0xF7,0x07,0xFC,0xFF,0x0F,0x04,0x3F,0x0E,0x00,0x1E,0x0C,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0xE0,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0xFE,0x1F,0x1C,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x1E,0x3F,0x18,0xFC,0xFF,0x1F,0xFC,0xF9,0x1F,0xF0,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x91
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0xFE,0x0F,0x00,0xFE,0x0F,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3B,0x00,0x80,0x3B,0x00,0x80,0x3B,0x00,0xC0,0x39,0x00,0xC0,0x39,0x00,0xE0,0xF8,0x07,0xE0,0xF8,0x07,0x60,0xF8,0x07,0x70,0x38,0x00,0x30,0x38,0x00,0xF8,0x3F,0x00,0xF8,0x3F,0x00,0xFC,0x3F,0x00,0x1C,0x38,0x00,0x0C,0x38,0x00,0x0E,0xF8,0x1F,0x0E,0xF8,0x1F,0x07,0xF8,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x92
{0x00,0x1E,0x00,0x00,0x3F,0x00,0x80,0x7F,0x00,0x80,0x73,0x00,0xC0,0xE1,0x00,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x93
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0xC0,0xE1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x94
{0xF0,0x00,0x00,0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x95
{0x00,0x1E,0x00,0x00,0x3F,0x00,0x80,0x7F,0x00,0x80,0x73,0x00,0xC0,0xE1,0x00,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF8,0x03,0xF0,0xBF,0x03,0xF0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x96
{0xF0,0x00,0x00,0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF8,0x03,0xF0,0xBF,0x03,0xF0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x97
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC3,0x01,0x80,0xC3,0x01,0x80,0xC3,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x1C,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x38,0x00,0x07,0x38,0x00,0x07,0x70,0x80,0x03,0x70,0x80,0x03,0xF0,0x80,0x03,0xE0,0xC0,0x01,0xE0,0xC1,0x01,0xC0,0xE1,0x00,0xC0,0xE3,0x00,0x80,0x73,0x00,0x80,0x73,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0x7C,0x00,0x00,0x00,0x00,0x00}, // 0x98
{0xE0,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x99
{0xC0,0x81,0x03,0xC0,0x81,0x03,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x07,0x70,0x80,0x03,0xF0,0xE0,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x07,0xE0,0xFF,0x03,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0xE0,0x03,0x1C,0x70,0x07,0x1C,0x38,0x07,0x1C,0x1C,0x07,0x1C,0x0E,0x07,0x1C,0x07,0x07,0x9C,0x03,0x07,0xDC,0x01,0x07,0xF8,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xF8,0xFF,0x00,0x9C,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0xFC,0x03,0x00,0xFE,0x03,0x00,0x0E,0x02,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0xE0,0x3F,0x00,0xE0,0x3F,0x00,0xE0,0x3F,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x01,0x00,0xE0,0x01,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x0E,0xE0,0xFF,0x07,0xF0,0xFF,0x03,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0xC0,0x07,0x1C,0xE0,0x07,0x1E,0x70,0x07,0x0E,0x30,0x0E,0x0E,0x38,0x0E,0x0E,0x1C,0x0E,0x0E,0x0E,0x0E,0x0E,0x07,0x0E,0x8E,0x03,0x0E,0x8E,0x01,0x0E,0xDC,0x01,0x0F,0xFC,0x00,0x07,0x7C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF8,0xFF,0x01,0xFC,0xFF,0x00,0x8E,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x04,0x0E,0x00,0x0E,0x1C,0x00,0x07,0x38,0x80,0x03,0x70,0xC0,0x01,0xE0,0xE0,0x00,0xC0,0x71,0x00,0x80,0x3B,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x80,0x3B,0x00,0xC0,0x71,0x00,0xE0,0xE0,0x00,0x70,0xC0,0x01,0x38,0x80,0x03,0x1C,0x00,0x07,0x0E,0x00,0x0E,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9E
{0x00,0xF0,0x03,0x00,0xFC,0x07,0x00,0xFE,0x07,0x00,0x0F,0x04,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x81,0x07,0x00,0xFF,0x03,0x00,0xFF,0x01,0x00,0xFE,0x00,0x00,0x00,0x00,0x00}, // 0x9F
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA0
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA1
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA2
{0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x03,0x38,0xE0,0x03,0x78,0xF8,0x03,0xF0,0xBF,0x03,0xF0,0x9F,0x03,0xC0,0x87,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA3
{0x00,0x00,0x00,0x80,0x87,0x01,0xC0,0xCF,0x01,0xE0,0xFC,0x00,0x60,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x00,0x38,0xFF,0x01,0xB8,0xFF,0x01,0xF8,0xC3,0x03,0xF8,0x80,0x03,0x78,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA4
{0x80,0x87,0x01,0xC0,0xDF,0x01,0x60,0xFE,0x00,0x60,0x78,0x00,0x00,0x00,0x00,0x78,0x00,0x0E,0x78,0x00,0x0E,0xF8,0x00,0x0E,0xF8,0x01,0x0E,0xF8,0x01,0x0E,0xF8,0x03,0x0E,0xB8,0x03,0x0E,0x38,0x07,0x0E,0x38,0x0F,0x0E,0x38,0x0E,0x0E,0x38,0x1E,0x0E,0x38,0x1C,0x0E,0x38,0x3C,0x0E,0x38,0x38,0x0E,0x38,0x70,0x0E,0x38,0xF0,0x0E,0x38,0xE0,0x0E,0x38,0xE0,0x0F,0x38,0xC0,0x0F,0x38,0x80,0x0F,0x38,0x80,0x0F,0x38,0x00,0x0F,0x38,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA5
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0x7F,0x00,0x60,0xF0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xFF,0x00,0xE0,0xFF,0x00,0xE0,0xE0,0x00,0x70,0xE0,0x00,0x70,0xE0,0x00,0xF0,0xF8,0x00,0xE0,0xFF,0x03,0xC0,0xC7,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xE1,0x01,0xE0,0xC0,0x01,0x70,0x80,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0xE0,0xC0,0x01,0xE0,0xE1,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x18,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0xE0,0x01,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x07,0x78,0x00,0x07,0xF8,0x00,0x07,0xF0,0xFF,0x07,0xE0,0xFF,0x07,0x00,0xFF,0x01,0x00,0x00,0x00}, // 0xA8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xC0,0xFF,0x00,0xE0,0xE1,0x01,0x70,0x9F,0x03,0x30,0x33,0x03,0x38,0x33,0x07,0x18,0x33,0x06,0x18,0x0F,0x06,0x18,0x0B,0x06,0x18,0x1B,0x06,0x38,0x1B,0x07,0x30,0x33,0x03,0x70,0x80,0x03,0xE0,0xE1,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAA
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x01,0x1F,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0x70,0x00,0x1C,0x70,0x00,0x1C,0x38,0x00,0x1C,0x3C,0x00,0x1C,0x1C,0x00,0x1C,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x1C,0x07,0x00,0x9C,0xC3,0x0F,0x80,0xE3,0x1F,0xC0,0x21,0x3C,0xC0,0x01,0x38,0xE0,0x00,0x38,0xE0,0x00,0x38,0x70,0x00,0x1C,0x78,0x00,0x0F,0x38,0x80,0x07,0x1C,0x80,0x03,0x1C,0xC0,0x01,0x0E,0xE0,0x00,0x0E,0xE0,0x3F,0x07,0xE0,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAB
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x03,0x1F,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0x70,0x00,0x1C,0x78,0x00,0x1C,0x38,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x0F,0x00,0x87,0x0F,0x80,0xC3,0x0F,0x80,0xE3,0x0E,0xC0,0x61,0x0E,0xC0,0x31,0x0E,0xE0,0x18,0x0E,0xF0,0x0C,0x0E,0x70,0xFC,0x3F,0x38,0xFC,0x3F,0x38,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00}, // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x87,0x03,0x80,0xC3,0x01,0xC0,0xE1,0x00,0xE0,0x70,0x00,0x70,0x38,0x00,0x38,0x1C,0x00,0x1C,0x0E,0x00,0x38,0x1C,0x00,0x70,0x38,0x00,0xE0,0x70,0x00,0xC0,0xE1,0x00,0x80,0xC3,0x01,0x00,0x87,0x03,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x00,0x38,0x38,0x00,0x70,0x70,0x00,0xE0,0xE0,0x00,0xC0,0xC1,0x01,0x80,0x83,0x03,0x00,0x07,0x07,0x00,0x0E,0x0E,0x00,0x07,0x07,0x80,0x83,0x03,0xC0,0xC1,0x01,0xE0,0xE0,0x00,0x70,0x70,0x00,0x38,0x38,0x00,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAF
{0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB0
{0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xFF,0xFF,0x3F,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xFF,0xFF,0x3F,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xF0,0x78,0x3C,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03}, // 0xB1
{0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x8F,0xC7,0x03,0x8F,0xC7,0x03,0x8F,0xC7,0x03}, // 0xB2
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xB3
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xB4
{0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x7B,0x00,0xC0,0x71,0x00,0xC0,0xF1,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x1E,0x00,0x1E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB5
{0x00,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x71,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x7B,0x00,0xC0,0x71,0x00,0xC0,0xF1,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x1E,0x00,0x1E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB6
{0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x7B,0x00,0xC0,0x71,0x00,0xC0,0xF1,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x1E,0x00,0x1E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB7
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xE0,0x01,0x38,0x80,0x03,0x18,0x00,0x03,0x0C,0x00,0x06,0x0C,0x3E,0x06,0x8C,0x7F,0x06,0xC6,0x7F,0x0C,0xC6,0x43,0x0C,0xE6,0x01,0x0C,0xE6,0x00,0x0C,0xE6,0x00,0x0C,0xE6,0x00,0x0C,0xE6,0x00,0x0C,0xE6,0x01,0x0C,0xC6,0x43,0x0C,0xC6,0x7F,0x0C,0x8C,0x7F,0x06,0x0C,0x1E,0x06,0x0C,0x00,0x06,0x18,0x00,0x03,0x38,0x80,0x03,0xF0,0xE0,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB8
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xB9
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xBB
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0xFF,0xE3,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xBC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x0C,0x00,0x00,0x0C,0x00,0x00,0x7F,0x00,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xE0,0x8D,0x01,0xF0,0x0C,0x00,0x70,0x0C,0x00,0x38,0x0C,0x00,0x38,0x0C,0x00,0x38,0x0C,0x00,0x38,0x0C,0x00,0x38,0x0C,0x00,0x38,0x0C,0x00,0x38,0x0C,0x00,0x78,0x0C,0x00,0x70,0x0C,0x00,0xF0,0x0C,0x00,0xE0,0x8D,0x01,0xE0,0xFF,0x01,0xC0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x0C,0x00,0x00,0x0C,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xBD
{0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x38,0x3C,0x00,0x1C,0x78,0x00,0x0E,0x78,0x00,0x07,0xF0,0x80,0x07,0xF0,0x80,0x03,0xE0,0xC1,0x01,0xC0,0xE3,0x00,0xC0,0xF3,0x00,0x80,0x77,0x00,0x80,0x3F,0x00,0x00,0x1F,0x00,0x00,0x1E,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xBF
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC0
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xC2
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC4
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xC5
{0x00,0x00,0x00,0x80,0x87,0x01,0xC0,0xCF,0x01,0xE0,0xFC,0x00,0x60,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x70,0xE0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x80,0xFF,0x01,0xE0,0xFF,0x01,0xF0,0xC0,0x01,0x38,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xC0,0x01,0x1C,0xE0,0x01,0x3C,0xF8,0x01,0xF8,0xBF,0x0F,0xF0,0x9F,0x0F,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC6
{0x80,0x87,0x01,0xC0,0xDF,0x01,0x60,0xFE,0x00,0x60,0x78,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x80,0x3B,0x00,0x80,0x7B,0x00,0xC0,0x71,0x00,0xC0,0xF1,0x00,0xC0,0xE1,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x1E,0x00,0x1E,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC7
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0xFF,0x3F,0x80,0xFF,0x3F,0x80,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x3F,0x80,0xFF,0x3F,0x80,0xFF,0x3F,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xC9
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xCB
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0xE3,0x3F,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xCD
{0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0xFF,0xE3,0x3F,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00,0x80,0xE3,0x00}, // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x04,0x1C,0x00,0x0E,0x38,0x1E,0x07,0xF0,0xFF,0x03,0xE0,0xFF,0x01,0xE0,0xE1,0x01,0xF0,0xC0,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0x70,0x80,0x03,0xF0,0xC0,0x03,0xE0,0xE1,0x01,0xE0,0xFF,0x01,0xF0,0xFF,0x03,0x38,0x1E,0x07,0x1C,0x00,0x0E,0x08,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xCF
{0x3C,0x10,0x00,0xFC,0x39,0x00,0xFC,0x1F,0x00,0xE0,0x0F,0x00,0x80,0x1F,0x00,0xE0,0x3F,0x00,0xF0,0x7C,0x00,0x20,0xF8,0x00,0x00,0xF0,0x00,0x80,0xFF,0x01,0xC0,0xFF,0x01,0xF0,0xFF,0x03,0xF0,0xE0,0x03,0x78,0x80,0x07,0x38,0x80,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x80,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x00,0xC0,0x7F,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0xFC,0x7F,0x00,0xFC,0xFF,0x00,0x1C,0xF0,0x01,0x1C,0xC0,0x03,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0x80,0x07,0x1C,0x00,0x07,0xFF,0x01,0x07,0xFF,0x01,0x07,0xFF,0x01,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0xC0,0x03,0x1C,0xE0,0x01,0x1C,0xF8,0x01,0xFC,0xFF,0x00,0xFC,0x3F,0x00,0xFC,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD1
{0x00,0x3E,0x00,0x00,0x7F,0x00,0x80,0xE3,0x00,0xC0,0xC1,0x01,0x00,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD2
{0xC0,0x81,0x03,0xC0,0x81,0x03,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD3
{0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0xF8,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD5
{0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD6
{0x00,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x71,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD7
{0xE0,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD8
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00}, // 0xDA
{0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F}, // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F}, // 0xDC
{0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDD
{0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDE
{0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDF
{0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE0
{0xC0,0x0F,0x00,0xE0,0x3F,0x00,0xF0,0x7F,0x00,0x78,0x78,0x00,0x38,0x70,0x00,0x38,0x70,0x00,0x38,0x70,0x00,0x38,0x38,0x00,0x38,0x38,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x1E,0x00,0x38,0x3E,0x00,0x38,0x7C,0x00,0x38,0xF8,0x00,0x38,0xF0,0x01,0x38,0xC0,0x03,0x38,0x80,0x07,0x38,0x00,0x0F,0x38,0x00,0x0E,0x38,0x00,0x0E,0x38,0x00,0x0E,0x38,0x06,0x0F,0x38,0xFE,0x07,0x38,0xFE,0x03,0x38,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE1
{0x00,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x71,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE2
{0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE3
{0x00,0x00,0x00,0x80,0x87,0x01,0xC0,0xCF,0x01,0xE0,0xFC,0x00,0x60,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE0,0x01,0x78,0xC0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE4
{0x80,0x87,0x01,0xC0,0xDF,0x01,0x60,0xFE,0x00,0x60,0x78,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF8,0xE0,0x03,0x38,0x80,0x03,0x1C,0x00,0x07,0x1C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x1E,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x80,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0x80,0x03,0x78,0xC0,0x03,0x78,0xE0,0x03,0xF8,0xF1,0x03,0xF8,0xBF,0x03,0xB8,0xBF,0x03,0x38,0x0F,0x07,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00}, // 0xE6
{0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x7C,0x00,0x38,0xFF,0x00,0xB8,0xFF,0x01,0xF8,0xC1,0x03,0xF8,0x80,0x03,0x78,0x80,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x80,0x03,0x78,0xC0,0x03,0xF8,0xE1,0x01,0xF8,0xFF,0x01,0xB8,0xFF,0x00,0x38,0x3E,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00}, // 0xE7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x07,0x70,0x80,0x07,0x70,0x00,0x0F,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x07,0x70,0xC0,0x07,0xF0,0xFF,0x03,0xF0,0xFF,0x00,0xF0,0x3F,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE8
{0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x07,0x70,0x80,0x03,0xF0,0xE0,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE9
{0x00,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x71,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x07,0x70,0x80,0x03,0xF0,0xE0,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEA
{0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x78,0x80,0x07,0x70,0x80,0x03,0xF0,0xE0,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEB
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x1C,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x38,0x00,0x07,0x38,0x00,0x07,0x70,0x80,0x03,0x70,0x80,0x03,0xF0,0x80,0x03,0xE0,0xC0,0x01,0xE0,0xC1,0x01,0xC0,0xE1,0x00,0xC0,0xE3,0x00,0x80,0x73,0x00,0x80,0x73,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0x7C,0x00,0x00,0x00,0x00,0x00}, // 0xEC
{0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x1E,0x00,0x3C,0x3C,0x00,0x1C,0x78,0x00,0x0E,0x78,0x00,0x0F,0xF0,0x00,0x07,0xE0,0x80,0x03,0xE0,0xC1,0x03,0xC0,0xC3,0x01,0x80,0xE3,0x00,0x80,0xF7,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xED
{0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEE
{0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0xF0,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0xFF,0xFF,0x3F,0x00,0x00,0x00}, // 0xF2
{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x38,0xFE,0x01,0x1C,0x82,0x03,0x0E,0x80,0x03,0x0E,0xC0,0x01,0x07,0xFC,0x80,0x03,0x7C,0xC0,0x03,0xE0,0xC1,0x01,0x80,0xE3,0x00,0x80,0x73,0x00,0xC2,0x73,0x00,0xFE,0x39,0x00,0xFE,0x1C,0x0F,0x00,0x9C,0x0F,0x00,0xCE,0x0F,0x00,0xE7,0x0E,0x00,0x67,0x0E,0x80,0x33,0x0E,0xC0,0x19,0x0E,0xE0,0x0D,0x0E,0xE0,0xFC,0x3F,0x70,0xFC,0x3F,0x38,0x00,0x0E,0x38,0x00,0x0E,0x1C,0x00,0x0E,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF3
{0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xFC,0x07,0x03,0xF8,0x07,0x03,0xF0,0x07,0x03,0xE0,0x07,0x03,0x80,0x07,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x01,0xE0,0xFF,0x01,0xE0,0x81,0x01,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xF0,0x00,0x00,0xE0,0x03,0x00,0xE0,0x0F,0x00,0xC0,0x3F,0x00,0xC0,0x7F,0x00,0xE0,0xF8,0x01,0x70,0xE0,0x01,0x70,0xC0,0x03,0x70,0x80,0x03,0xF0,0x80,0x03,0xF0,0x81,0x03,0xE0,0x83,0x01,0xC0,0xDF,0x01,0x80,0xFF,0x00,0x00,0xFE,0x00,0x00,0xF8,0x01,0x00,0xE0,0x01,0x00,0xC0,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x10,0x80,0x03,0xF0,0xE0,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0xFC,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x04,0x00,0x00,0x1E,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00}, // 0xF7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x80,0x1F,0x00,0xC0,0x39,0x00,0xC0,0x30,0x00,0xC0,0x30,0x00,0xC0,0x39,0x00,0x80,0x1F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF8
{0xE0,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFA
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0xC0,0x0F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFB
{0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0xC0,0xFF,0x01,0xC0,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0x7F,0x00,0x00,0x7F,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xC0,0x01,0xC0,0xE0,0x01,0xC0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFC
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x3F,0x00,0xE0,0x7F,0x00,0x60,0xF0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x1E,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x00,0x00,0xE0,0xFF,0x00,0xE0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0xFE,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 0xFF
};
#endif

#ifdef USE_FONT_24X40
__UG_FONT_DATA unsigned char font_24x40[256][120]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x00
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0xC0,0xFF,0x03,0xE0,0x81,0x07,0x70,0x00,0x0E,0x38,0x00,0x1C,0x1C,0x00,0x38,0x8C,0xC3,0x31,0x8E,0xC3,0x71,0x86,0xC3,0x61,0x06,0x00,0x60,0x06,0x00,0x60,0x66,0x00,0x66,0x46,0x00,0x62,0xCE,0x00,0x73,0x8C,0x81,0x31,0x1C,0xFF,0x38,0x38,0x7E,0x1C,0x70,0x00,0x0E,0xE0,0x81,0x07,0xC0,0xFF,0x03,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x01
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0xFF,0x0F,0xF8,0xFF,0x1F,0xFC,0xFF,0x3F,0x7C,0x3C,0x3E,0x7E,0x3C,0x7E,0x7E,0x3C,0x7E,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0x9E,0xFF,0x79,0xBE,0xFF,0x7D,0x3E,0xFF,0x7C,0x7C,0x7E,0x3E,0xFC,0x00,0x3F,0xF8,0x81,0x1F,0xF0,0xFF,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x02
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x0F,0xFC,0xC3,0x3F,0xFC,0xE7,0x3F,0xFE,0xE7,0x7F,0xFE,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0x80,0xFF,0x01,0x00,0xFF,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x03
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7E,0x00,0x00,0xFE,0x00,0x00,0xFF,0x01,0x80,0xFF,0x01,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0xFF,0x0F,0xF8,0xFF,0x1F,0xFC,0xFF,0x3F,0xFE,0xFF,0x7F,0xFF,0xFF,0xFF,0xFE,0xFF,0x7F,0xFC,0xFF,0x3F,0xF8,0xFF,0x1F,0xF0,0xFF,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x80,0xFF,0x03,0x00,0xFF,0x01,0x00,0xFE,0x00,0x00,0x7E,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x18,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x04
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xFF,0x01,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0x80,0xFF,0x01,0x80,0xFF,0x01,0xF8,0xFF,0x1F,0xFC,0xFF,0x3F,0xFE,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xDB,0x7F,0xFC,0x99,0x3F,0xF8,0x3C,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x05
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x18,0x00,0x00,0x1C,0x00,0x00,0x3E,0x00,0x00,0x7F,0x00,0x00,0xFF,0x00,0x80,0xFF,0x01,0xC0,0xFF,0x01,0xE0,0xFF,0x03,0xF0,0xFF,0x07,0xF8,0xFF,0x1F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFE,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xDB,0x7F,0xFC,0x99,0x3F,0x78,0x3C,0x1E,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x80,0x3F,0x00,0xF0,0x3F,0x00,0xF8,0x3F,0x00,0x78,0x3E,0x00,0x00,0x77,0x00,0x80,0x77,0x00,0x80,0x73,0x00,0xC0,0xF3,0x00,0xC0,0xE1,0xC0,0xFF,0x20,0xF0,0xFF,0x00,0xF8,0xFF,0x00,0x7C,0xF0,0x01,0x1E,0xC0,0x03,0x0E,0x80,0x03,0x0F,0x80,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x0F,0x80,0x07,0x0E,0x80,0x03,0x1E,0xC0,0x03,0x7C,0xF0,0x01,0xF8,0xFF,0x00,0xF0,0x7F,0x00,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xE0,0xFF,0x03,0xF0,0xC1,0x07,0x78,0x00,0x0F,0x38,0x00,0x0E,0x3C,0x00,0x1E,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x3C,0x00,0x1E,0x38,0x00,0x0E,0x78,0x00,0x0F,0xF0,0xC1,0x07,0xE0,0xFF,0x03,0xC0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0xE0,0xFF,0x03,0xE0,0xFF,0x03,0xE0,0xFF,0x03,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x38,0x00,0x00,0x3E,0x00,0x80,0x3F,0x00,0xE0,0x3F,0x00,0xFC,0x37,0x00,0xFF,0x31,0x00,0x7F,0x30,0x00,0x1F,0x30,0x00,0x07,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x83,0x3F,0x00,0xE3,0x3F,0x00,0xE3,0x3F,0x00,0xF3,0x1F,0x00,0xF3,0x1F,0x00,0xF3,0x0F,0x00,0xE3,0x03,0xF8,0x03,0x00,0xFE,0x03,0x00,0xFE,0x01,0x00,0xFF,0x01,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x30,0x38,0x0C,0x78,0xFE,0x1C,0xF0,0xFF,0x1F,0xE0,0xFF,0x0F,0xE0,0xC3,0x07,0xE0,0x00,0x0F,0xF0,0x00,0x0F,0x7E,0x00,0x7E,0x7E,0x00,0x7E,0x7E,0x00,0x7E,0xF0,0x00,0x0F,0xE0,0x00,0x0F,0xE0,0xC3,0x07,0xE0,0xFF,0x07,0xF0,0xFF,0x1F,0x78,0xFE,0x1E,0x30,0x38,0x0C,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x0F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x0E,0x00,0x00,0x3E,0x00,0x00,0xFE,0x00,0x00,0xFE,0x03,0x00,0xFE,0x0F,0x00,0xFE,0x1F,0x00,0xFE,0x7F,0x00,0xFE,0xFF,0x01,0xFE,0xFF,0x07,0xFE,0xFF,0x1F,0xFE,0xFF,0x7F,0xFE,0xFF,0x1F,0xFE,0xFF,0x07,0xFE,0xFF,0x01,0xFE,0x7F,0x00,0xFE,0x1F,0x00,0xFE,0x0F,0x00,0xFE,0x03,0x00,0xFE,0x00,0x00,0x3E,0x00,0x00,0x0E,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x10
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x70,0x00,0x00,0x7C,0x00,0x00,0x7F,0x00,0xC0,0x7F,0x00,0xF0,0x7F,0x00,0xF8,0x7F,0x00,0xFE,0x7F,0x80,0xFF,0x7F,0xE0,0xFF,0x7F,0xF8,0xFF,0x7F,0xFE,0xFF,0x7F,0xF8,0xFF,0x7F,0xE0,0xFF,0x7F,0x80,0xFF,0x7F,0x00,0xFE,0x7F,0x00,0xF8,0x7F,0x00,0xF0,0x7F,0x00,0xC0,0x7F,0x00,0x00,0x7F,0x00,0x00,0x7C,0x00,0x00,0x70,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x11
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x00,0xFF,0x01,0x80,0xBB,0x03,0x80,0x38,0x02,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x80,0x38,0x02,0x80,0xBB,0x03,0x00,0xFF,0x01,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x12
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0xC0,0x83,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x13
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x07,0xE0,0xFF,0x07,0xF0,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF0,0x0F,0x06,0xF0,0x0F,0x06,0xE0,0x0F,0x06,0xC0,0x0F,0x06,0x00,0x0F,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x14
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x00,0xFF,0x07,0x80,0xFF,0x07,0xC0,0x03,0x06,0xE0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x03,0x00,0xC0,0x07,0x00,0x80,0x3F,0x00,0x80,0xFF,0x00,0x80,0xFF,0x01,0xC0,0xF1,0x03,0xC0,0xC0,0x07,0xE0,0x80,0x0F,0xE0,0x00,0x0F,0xE0,0x00,0x0E,0xE0,0x01,0x0E,0xC0,0x07,0x0E,0xC0,0x0F,0x07,0x80,0x7F,0x07,0x00,0xFE,0x03,0x00,0xF8,0x03,0x00,0xE0,0x07,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x20,0x00,0x0F,0xE0,0x81,0x07,0xE0,0xFF,0x03,0xE0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x16
{0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x00,0xFF,0x01,0x80,0xBB,0x03,0x80,0x38,0x02,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x80,0x38,0x02,0x80,0xBB,0x03,0x00,0xFF,0x01,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x03,0x80,0xFF,0x03,0x80,0xFF,0x03}, // 0x17
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x00,0xFF,0x01,0x80,0xBB,0x03,0x80,0x38,0x02,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x18
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x80,0x38,0x02,0x80,0xBB,0x03,0x00,0xFF,0x01,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0x00,0x80,0x01,0x00,0x80,0x03,0x00,0x00,0x07,0xFC,0xFF,0x1F,0xFC,0xFF,0x3F,0xFC,0xFF,0x1F,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x01,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x80,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xF8,0xFF,0x3F,0xFC,0xFF,0x3F,0xF8,0xFF,0x3F,0xE0,0x00,0x00,0xC0,0x01,0x00,0x80,0x01,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC3,0x00,0x80,0x81,0x01,0xC0,0x81,0x03,0xE0,0x00,0x07,0xF8,0xFF,0x1F,0xFC,0xFF,0x3F,0xF8,0xFF,0x1F,0xE0,0x00,0x07,0xC0,0x81,0x03,0x80,0x81,0x01,0x00,0xC3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x7E,0x00,0x00,0x7F,0x00,0x00,0xFF,0x00,0x80,0xFF,0x00,0x80,0xFF,0x01,0xC0,0xFF,0x01,0xC0,0xFF,0x03,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFE,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x7F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x07,0xE0,0xFF,0x07,0xE0,0xFF,0x03,0xC0,0xFF,0x03,0xC0,0xFF,0x01,0x80,0xFF,0x01,0x80,0xFF,0x00,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0x7E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x20
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x21
{0x00,0x00,0x00,0xE0,0x83,0x0F,0xE0,0x83,0x0F,0xE0,0x83,0x0F,0xE0,0x83,0x0F,0xE0,0x83,0x0F,0xE0,0x83,0x0F,0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x22
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0xF8,0xFF,0x7F,0xF8,0xFF,0x7F,0xF8,0xFF,0x7F,0x80,0x83,0x03,0x80,0x83,0x03,0x80,0xC3,0x01,0xC0,0xC1,0x01,0xC0,0xC1,0x01,0xFE,0xFF,0x3F,0xFE,0xFF,0x3F,0xFE,0xFF,0x3F,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0x70,0x70,0x00,0x70,0x70,0x00,0x70,0x70,0x00,0x70,0x70,0x00,0x38,0x38,0x00,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x23
{0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0xFC,0x01,0x00,0xFF,0x0F,0x80,0xFF,0x0F,0xC0,0x37,0x0E,0xE0,0x33,0x00,0xE0,0x31,0x00,0xE0,0x31,0x00,0xE0,0x31,0x00,0xE0,0x31,0x00,0xE0,0x33,0x00,0xC0,0x37,0x00,0x80,0x3F,0x00,0x00,0x3F,0x00,0x00,0x7E,0x00,0x00,0xFC,0x00,0x00,0xF0,0x03,0x00,0xF0,0x07,0x00,0xB0,0x0F,0x00,0x30,0x0F,0x00,0x30,0x1F,0x00,0x30,0x1E,0x00,0x30,0x1E,0x00,0x30,0x1E,0x00,0x30,0x1E,0x10,0x30,0x0F,0xF0,0xB0,0x0F,0xF0,0xFF,0x07,0xF0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x24
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0xE0,0xFC,0x03,0x70,0x8E,0x07,0x38,0x0E,0x07,0x38,0x07,0x0E,0x1C,0x07,0x0E,0x0E,0x07,0x0E,0x07,0x07,0x0E,0x07,0x07,0x8E,0x03,0x0E,0xC7,0x01,0x9E,0xC7,0x01,0xFC,0xE3,0x00,0xF0,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x0F,0x00,0xCE,0x3F,0x00,0xE7,0x78,0x80,0xE3,0x70,0x80,0x73,0xE0,0xC0,0x71,0xE0,0xE0,0x70,0xE0,0xE0,0x70,0xE0,0x70,0x70,0xE0,0x38,0xE0,0x70,0x1C,0xE0,0x79,0x1C,0xC0,0x3F,0x0E,0x00,0x0F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x25
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x80,0xFF,0x00,0xC0,0xFF,0x01,0xC0,0xE3,0x03,0xE0,0xC1,0x03,0xE0,0xC1,0x03,0xE0,0xC1,0x03,0xE0,0xC1,0x03,0xE0,0xE3,0x01,0xC0,0xF3,0x00,0xC0,0x7B,0x00,0xC0,0x3F,0x00,0xC0,0x1F,0x00,0xF0,0x0F,0x00,0xF8,0x0F,0xF0,0x3C,0x1F,0xF0,0x1E,0x3E,0xF0,0x1E,0x3C,0xF0,0x0F,0x7C,0x70,0x0F,0xF8,0x70,0x0F,0xF0,0x79,0x0F,0xF0,0x39,0x0F,0xE0,0x3F,0x1F,0xC0,0x1F,0x1E,0x80,0x0F,0x3E,0x80,0x1F,0xFC,0xE0,0x3F,0xF8,0xFF,0x7F,0xF0,0x7F,0xFC,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x26
{0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x27
{0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1F,0x00,0xC0,0x1F,0x00,0xE0,0x07,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x00,0xC0,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x28
{0x00,0x00,0x00,0x38,0x00,0x00,0xF8,0x00,0x00,0xF8,0x03,0x00,0xE0,0x07,0x00,0x80,0x0F,0x00,0x00,0x1F,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0xE0,0x07,0x00,0xF8,0x03,0x00,0xF8,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x29
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x10,0x18,0x08,0x70,0x18,0x0E,0xF8,0x81,0x1F,0xF8,0xC3,0x1F,0xC0,0xC3,0x03,0x00,0x00,0x00,0x00,0x42,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0xC3,0x03,0xC0,0xC3,0x03,0xC0,0x81,0x03,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2E
{0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x2F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x80,0xFF,0x01,0xC0,0xFF,0x03,0xE0,0xC3,0x07,0xF0,0x81,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x38,0x00,0x1C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x38,0x00,0x1C,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF0,0x00,0x0F,0xF0,0x81,0x0F,0xE0,0xC3,0x07,0xC0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x30
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x7C,0x00,0x80,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7B,0x00,0x18,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0xF8,0xFF,0x7F,0xF8,0xFF,0x7F,0xF8,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x31
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x01,0x70,0xE0,0x03,0x10,0xC0,0x03,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0x80,0x03,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF8,0x00,0x00,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x32
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0xC0,0x07,0x00,0x80,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0xE0,0x03,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0xFF,0x03,0x00,0xE0,0x07,0x00,0x80,0x0F,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x0F,0xE0,0xC0,0x07,0xE0,0xFF,0x03,0xE0,0xFF,0x01,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x33
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0xE0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF8,0x03,0x00,0xFC,0x03,0x00,0xDC,0x03,0x00,0xCE,0x03,0x00,0xCF,0x03,0x00,0xC7,0x03,0x80,0xC3,0x03,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0xC0,0x03,0xF0,0xC0,0x03,0x70,0xC0,0x03,0x38,0xC0,0x03,0x3C,0xC0,0x03,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x34
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0x07,0xC0,0xFF,0x07,0xC0,0xFF,0x07,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x1F,0x00,0xC0,0x7F,0x00,0xC0,0xFF,0x01,0x00,0xF0,0x03,0x00,0xC0,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x07,0x00,0xC0,0x07,0x60,0xE0,0x03,0xE0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x35
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0xFE,0x0F,0x00,0xFF,0x0F,0x80,0x0F,0x0E,0xC0,0x03,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x78,0xF8,0x01,0x78,0xFE,0x03,0x78,0xFF,0x0F,0xF8,0x83,0x0F,0xF8,0x01,0x1F,0xF8,0x00,0x1E,0xF8,0x00,0x3E,0xF8,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x1C,0xE0,0x01,0x1E,0xE0,0x01,0x1F,0xC0,0x87,0x0F,0x80,0xFF,0x07,0x00,0xFF,0x03,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x36
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0x80,0x03,0x00,0xC0,0x03,0x00,0xC0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x00,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x37
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x80,0xFF,0x07,0xC0,0xFF,0x0F,0xE0,0x83,0x0F,0xF0,0x01,0x1F,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x01,0x1E,0xF0,0x01,0x0F,0xE0,0x83,0x07,0xC0,0xCF,0x03,0x80,0xFF,0x01,0x00,0xFF,0x00,0x80,0xFF,0x01,0xC0,0xFB,0x07,0xE0,0xE1,0x0F,0xF0,0xC0,0x1F,0xF0,0x00,0x1F,0x78,0x00,0x3E,0x78,0x00,0x3E,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF8,0x00,0x3C,0xF0,0x01,0x1E,0xF0,0x83,0x0F,0xE0,0xFF,0x07,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x38
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x80,0xFF,0x01,0xC0,0xFF,0x07,0xE0,0xC3,0x07,0xF0,0x01,0x0F,0xF0,0x00,0x0F,0x70,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3E,0xF8,0x00,0x3E,0xF0,0x00,0x3E,0xF0,0x01,0x3F,0xE0,0x83,0x3F,0xC0,0xFF,0x3D,0x80,0xFF,0x3C,0x00,0x3F,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x80,0x07,0xE0,0xE0,0x03,0xE0,0xFF,0x01,0xE0,0xFF,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x38,0x00,0x00,0x3E,0x00,0x80,0x1F,0x00,0xE0,0x07,0x00,0xF0,0x01,0x00,0xFC,0x00,0x00,0x3F,0x00,0xC0,0x0F,0x00,0xF0,0x03,0x00,0xFC,0x00,0x00,0xF0,0x03,0x00,0xC0,0x0F,0x00,0x00,0x3F,0x00,0x00,0xFC,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x00,0x80,0x1F,0x00,0x00,0x3E,0x00,0x00,0x38,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x1C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x01,0x00,0xE0,0x07,0x00,0x80,0x0F,0x00,0x00,0x3F,0x00,0x00,0xFC,0x00,0x00,0xF0,0x03,0x00,0xC0,0x0F,0x00,0x00,0x3F,0x00,0xC0,0x0F,0x00,0xF0,0x03,0x00,0xFC,0x00,0x00,0x3F,0x00,0x80,0x0F,0x00,0xE0,0x07,0x00,0xF8,0x01,0x00,0x7C,0x00,0x00,0x1C,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x0F,0x38,0xC0,0x0F,0x38,0x00,0x1F,0x38,0x00,0x1E,0x38,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x3F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0x00,0xFF,0x03,0xC0,0x87,0x07,0xE0,0x01,0x0E,0xF0,0x00,0x0E,0x70,0x00,0x1C,0x38,0xE0,0x1F,0x38,0xF0,0x1F,0x1C,0x38,0x1E,0x1C,0x1C,0x1C,0x1C,0x0E,0x1C,0x0E,0x0E,0x1C,0x0E,0x06,0x1C,0x0E,0x07,0x1C,0x0E,0x07,0x1E,0x0E,0x07,0x1E,0x0E,0x07,0x1F,0x0E,0x07,0x1F,0x0E,0x87,0x1F,0x0E,0x87,0x1D,0x1E,0xCE,0x1D,0x1C,0xFE,0x1C,0x1C,0x7C,0xFC,0x38,0x38,0xFC,0x38,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xC0,0x03,0x03,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x40
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x41
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x07,0xF0,0xFF,0x0F,0xF0,0x80,0x1F,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x0F,0xF0,0xC0,0x07,0xF0,0xFF,0x03,0xF0,0xFF,0x00,0xF0,0xFF,0x03,0xF0,0xC0,0x0F,0xF0,0x00,0x1F,0xF0,0x00,0x1E,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3E,0xF0,0x00,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x07,0xF0,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x42
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0x00,0xFE,0x7F,0x80,0xFF,0x7F,0xC0,0x0F,0x78,0xE0,0x03,0x40,0xF0,0x01,0x00,0xF8,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x01,0x00,0xE0,0x03,0x00,0xC0,0x1F,0x70,0x80,0xFF,0x7F,0x00,0xFE,0x7F,0x00,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x43
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0x78,0xC0,0x0F,0x78,0x00,0x1F,0x78,0x00,0x3E,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x38,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1F,0x78,0xE0,0x0F,0xF8,0xFF,0x07,0xF8,0xFF,0x01,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x44
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x45
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x7F,0xE0,0xFF,0x7F,0xE0,0xFF,0x7F,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0xFF,0x1F,0xE0,0xFF,0x1F,0xE0,0xFF,0x1F,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x46
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0x00,0xFE,0x7F,0x80,0xFF,0x7F,0xC0,0x0F,0x78,0xE0,0x03,0x40,0xF0,0x01,0x00,0xF8,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0xC0,0x7F,0x3C,0xC0,0x7F,0x3C,0xC0,0x7F,0x3C,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0xF8,0x00,0x78,0xF0,0x01,0x78,0xE0,0x03,0x78,0xC0,0x1F,0x78,0x80,0xFF,0x7F,0x00,0xFE,0x7F,0x00,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x47
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x48
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x49
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x03,0xE0,0xFF,0x03,0xE0,0xFF,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x01,0x18,0xF0,0x01,0xF8,0xFF,0x00,0xF8,0x7F,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x1F,0x78,0x80,0x0F,0x78,0xC0,0x07,0x78,0xE0,0x03,0x78,0xE0,0x01,0x78,0xF0,0x00,0x78,0xF8,0x00,0x78,0x7C,0x00,0x78,0x3C,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0x78,0x07,0x00,0xF8,0x0F,0x00,0x78,0x1F,0x00,0x78,0x3E,0x00,0x78,0x3C,0x00,0x78,0x78,0x00,0x78,0xF8,0x00,0x78,0xF0,0x01,0x78,0xE0,0x03,0x78,0xC0,0x07,0x78,0x80,0x0F,0x78,0x00,0x1F,0x78,0x00,0x3F,0x78,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x3E,0x7C,0x00,0x3E,0xFC,0x00,0x3E,0xFC,0x00,0x3F,0xFC,0x00,0x3F,0xDC,0x01,0x3B,0xDC,0x81,0x3B,0xDC,0x81,0x3B,0x9C,0x83,0x39,0x9C,0xC3,0x39,0x9C,0xC3,0x39,0x1C,0xC7,0x38,0x1C,0xE7,0x38,0x1C,0xE7,0x38,0x1C,0x6E,0x38,0x1C,0x7E,0x38,0x1C,0x7E,0x38,0x1C,0x3C,0x38,0x1C,0x3C,0x38,0x1C,0x3C,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x1C,0x78,0x00,0x1C,0xF8,0x00,0x1C,0xF8,0x01,0x1C,0xF8,0x01,0x1C,0xF8,0x03,0x1C,0xF8,0x07,0x1C,0xB8,0x07,0x1C,0xB8,0x0F,0x1C,0x38,0x1F,0x1C,0x38,0x1F,0x1C,0x38,0x3E,0x1C,0x38,0x3C,0x1C,0x38,0x7C,0x1C,0x38,0xF8,0x1C,0x38,0xF0,0x1C,0x38,0xF0,0x1D,0x38,0xE0,0x1F,0x38,0xE0,0x1F,0x38,0xC0,0x1F,0x38,0x80,0x1F,0x38,0x80,0x1F,0x38,0x00,0x1F,0x38,0x00,0x1E,0x38,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x4F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x07,0xF0,0xFF,0x1F,0xF0,0x00,0x1F,0xF0,0x00,0x3E,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xF0,0xC0,0x0F,0xF0,0xFF,0x07,0xF0,0xFF,0x03,0xF0,0x7F,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x50
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x03,0x00,0xC0,0x07,0x00,0x80,0x1F,0x00,0x00,0xFF,0x00,0x00,0x7E,0x00,0x00,0x78,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x51
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x07,0xF0,0xFF,0x0F,0xF0,0x80,0x0F,0xF0,0x00,0x1F,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x0F,0xF0,0x80,0x0F,0xF0,0xE0,0x07,0xF0,0xFF,0x03,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0xF0,0xF0,0x01,0xF0,0xF0,0x01,0xF0,0xE0,0x03,0xF0,0xC0,0x07,0xF0,0x80,0x0F,0xF0,0x80,0x0F,0xF0,0x00,0x1F,0xF0,0x00,0x3E,0xF0,0x00,0x7C,0xF0,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x52
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xC0,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x01,0x0F,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x03,0x00,0xF0,0x1F,0x00,0xC0,0xFF,0x00,0x00,0xFF,0x07,0x00,0xFC,0x0F,0x00,0xE0,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x18,0x00,0x1E,0xF8,0x80,0x1F,0xF8,0xFF,0x0F,0xF8,0xFF,0x03,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x53
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x54
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xE0,0x83,0x0F,0xE0,0xFF,0x0F,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x55
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0xF0,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3E,0x00,0x7C,0x3C,0x00,0x3C,0x7C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1E,0xF0,0x00,0x0F,0xF0,0x01,0x0F,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x83,0x07,0xC0,0xC3,0x03,0xC0,0xC7,0x03,0x80,0xC7,0x01,0x80,0xE7,0x01,0x80,0xEF,0x01,0x00,0xEF,0x00,0x00,0xFF,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x56
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0xE0,0x0F,0x00,0xE0,0x0F,0x00,0xE0,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x3C,0x70,0x0E,0x3C,0x70,0x0E,0x7C,0x70,0x1E,0x7E,0x70,0x1E,0x7E,0x38,0x1C,0x7E,0x38,0x1C,0xFE,0x38,0x1C,0xE7,0x38,0x1C,0xE7,0x38,0x3C,0xE7,0x38,0x3C,0xE7,0x1C,0x38,0xE3,0x1D,0xB8,0xC3,0x1D,0xB8,0xC3,0x1D,0xB8,0xC3,0x1D,0xB8,0xC1,0x1F,0xF8,0x81,0x0F,0xF8,0x81,0x0F,0xF0,0x81,0x0F,0xF0,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x57
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x78,0x7C,0x00,0x3C,0xF8,0x00,0x1C,0xF0,0x00,0x0E,0xF0,0x01,0x0F,0xE0,0x83,0x07,0xC0,0x87,0x03,0xC0,0xC7,0x01,0x80,0xEF,0x01,0x00,0xFF,0x00,0x00,0x7E,0x00,0x00,0x3E,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x00,0xFF,0x00,0x80,0xF7,0x01,0x80,0xE3,0x03,0xC0,0xC3,0x07,0xE0,0xC1,0x07,0xF0,0x80,0x0F,0x70,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3E,0x1E,0x00,0x7C,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x58
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0xF0,0x3C,0x00,0x78,0x78,0x00,0x38,0xF8,0x00,0x3C,0xF0,0x00,0x1C,0xE0,0x01,0x1E,0xE0,0x03,0x0F,0xC0,0x07,0x07,0x80,0x87,0x07,0x80,0x8F,0x03,0x00,0xDF,0x03,0x00,0xFE,0x01,0x00,0xFE,0x00,0x00,0xFC,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x59
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0xFC,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5A
{0x00,0x00,0x00,0x00,0xFE,0x1F,0x00,0xFE,0x1F,0x00,0xFE,0x1F,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0xFE,0x1F,0x00,0xFE,0x1F,0x00,0xFE,0x1F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5B
{0x00,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5C
{0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x77,0x00,0x00,0x77,0x00,0x00,0xE7,0x00,0x80,0xE3,0x00,0x80,0xC3,0x01,0xC0,0xC1,0x01,0xC0,0xC1,0x03,0xC0,0x80,0x03,0xE0,0x80,0x07,0xE0,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x0E,0x38,0x00,0x0E,0x38,0x00,0x1C,0x38,0x00,0x1C,0x1C,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x5F
{0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x61
{0x00,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0xF8,0x00,0x78,0xFE,0x03,0x78,0xFF,0x07,0x78,0x87,0x0F,0xF8,0x01,0x0F,0xF8,0x00,0x0F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x0F,0x78,0x00,0x0F,0xF8,0x80,0x0F,0xF8,0xC3,0x07,0xF8,0xFF,0x03,0x78,0xFF,0x01,0x38,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0x00,0xFF,0x1F,0xC0,0xFF,0x1F,0xE0,0x07,0x1C,0xE0,0x03,0x00,0xF0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xF0,0x03,0x00,0xE0,0x0F,0x1C,0xC0,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x63
{0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x3F,0x1E,0xC0,0xFF,0x1E,0xE0,0xFF,0x1F,0xF0,0xC1,0x1F,0xF0,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x78,0x00,0x1F,0x78,0x80,0x1F,0xF0,0xE0,0x1F,0xF0,0xFF,0x1E,0xE0,0x7F,0x1E,0x80,0x1F,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x80,0xFF,0x03,0xC0,0xFF,0x07,0xE0,0x83,0x0F,0xE0,0x01,0x0F,0xF0,0x00,0x0E,0xF0,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x80,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x65
{0x00,0x00,0x00,0x00,0xC0,0x7F,0x00,0xF0,0xFF,0x00,0xFC,0xFF,0x00,0x7C,0xC0,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0xF8,0xFF,0x7F,0xF8,0xFF,0x7F,0xF8,0xFF,0x7F,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1E,0xC0,0xFF,0x1E,0xE0,0xFF,0x1F,0xF0,0xC1,0x1F,0xF0,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x78,0x00,0x1F,0xF8,0x80,0x1F,0xF0,0xE1,0x1E,0xF0,0xFF,0x1E,0xE0,0x7F,0x1E,0x80,0x1F,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x0F,0x70,0xC0,0x07,0xF0,0xFF,0x03,0xF0,0xFF,0x01,0x80,0x7F,0x00}, // 0x67
{0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xE0,0x07,0xF0,0xF8,0x0F,0xF0,0xFC,0x1F,0xF0,0x0E,0x1E,0xF0,0x07,0x3E,0xF0,0x03,0x3C,0xF0,0x01,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x68
{0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x69
{0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xF0,0x00,0x18,0xF8,0x00,0xF8,0x7F,0x00,0xF8,0x3F,0x00,0xE0,0x0F,0x00}, // 0x6A
{0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x80,0x1F,0xF0,0x80,0x0F,0xF0,0xC0,0x07,0xF0,0xE0,0x03,0xF0,0xF0,0x01,0xF0,0xF8,0x01,0xF0,0xF8,0x00,0xF0,0x7C,0x00,0xF0,0x3E,0x00,0xF0,0x1F,0x00,0xF0,0x1F,0x00,0xF0,0x3E,0x00,0xF0,0x7C,0x00,0xF0,0xF8,0x00,0xF0,0xF0,0x01,0xF0,0xE0,0x03,0xF0,0xC0,0x07,0xF0,0x80,0x0F,0xF0,0x80,0x1F,0xF0,0x00,0x3F,0xF0,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6B
{0x00,0x00,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x0F,0x0E,0x9C,0x1F,0x1F,0xDC,0x9F,0x3F,0xFC,0xF8,0x39,0x7C,0xF8,0x38,0x3C,0x78,0x38,0x3C,0x78,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x1C,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xE0,0x07,0xF0,0xF8,0x0F,0xF0,0xFC,0x1F,0xF0,0x0E,0x1E,0xF0,0x07,0x3E,0xF0,0x03,0x3C,0xF0,0x01,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,0x01,0xF0,0xFC,0x07,0xF0,0xFE,0x0F,0xF0,0x0F,0x1F,0xF0,0x03,0x1E,0xF0,0x01,0x1E,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x01,0x1F,0xF0,0x87,0x0F,0xF0,0xFF,0x07,0xF0,0xFE,0x03,0xF0,0xF8,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00}, // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1C,0xC0,0xFF,0x1E,0xE0,0xFF,0x1F,0xF0,0xC1,0x1F,0xF0,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x78,0x00,0x1F,0x78,0x80,0x1F,0xF0,0xE0,0x1E,0xF0,0x7F,0x1E,0xE0,0x3F,0x1E,0x80,0x1F,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E}, // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x83,0x3F,0xC0,0xE3,0x3F,0xC0,0xF3,0x3F,0xC0,0x7B,0x38,0xC0,0x1F,0x38,0xC0,0x0F,0x38,0xC0,0x07,0x38,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xC0,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0E,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x03,0x00,0xE0,0x1F,0x00,0xC0,0xFF,0x00,0x00,0xFF,0x03,0x00,0xF8,0x0F,0x00,0xC0,0x0F,0x00,0x00,0x1F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x08,0x00,0x1F,0x78,0x80,0x0F,0xF8,0xFF,0x07,0xF8,0xFF,0x03,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x73
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x1F,0x00,0x00,0x3E,0x00,0x00,0xFE,0x3F,0x00,0xFC,0x3F,0x00,0xF0,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0x78,0xC0,0x0F,0x78,0xE0,0x0F,0xF8,0x70,0x0F,0xF0,0x7F,0x0F,0xE0,0x1F,0x0F,0xC0,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x7C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x7C,0x00,0x3E,0x78,0x00,0x1E,0xF8,0x00,0x1E,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x83,0x07,0xC0,0xC3,0x03,0xC0,0xC3,0x03,0x80,0xC7,0x01,0x80,0xE7,0x01,0x00,0xEF,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0xE0,0x0F,0x00,0xE0,0x0F,0x3C,0x60,0x0E,0x7C,0x70,0x0E,0x7C,0x70,0x1E,0x7E,0x70,0x1E,0x7E,0x70,0x1E,0x66,0x30,0x1C,0xE6,0x38,0x1C,0xE7,0x38,0x1C,0xE7,0x38,0x3C,0xC3,0x38,0x3C,0xC3,0x19,0xB8,0xC3,0x1D,0xB8,0xC3,0x1D,0xB8,0x81,0x1D,0xF8,0x81,0x1F,0xF8,0x81,0x0F,0xF8,0x80,0x0F,0xF0,0x80,0x0F,0xF0,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x1E,0xF8,0x00,0x0E,0xF0,0x01,0x07,0xE0,0x81,0x07,0xE0,0x83,0x03,0xC0,0xC7,0x01,0x80,0xEF,0x01,0x80,0xEF,0x00,0x00,0x7F,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xF7,0x01,0x80,0xF3,0x01,0xC0,0xE3,0x03,0xE0,0xC1,0x07,0xE0,0x80,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x78,0x3C,0x00,0x38,0x7C,0x00,0x3C,0x78,0x00,0x1C,0x78,0x00,0x1E,0xF8,0x00,0x0E,0xF0,0x00,0x0F,0xF0,0x01,0x0F,0xE0,0x81,0x07,0xE0,0x83,0x07,0xC0,0xC3,0x03,0xC0,0xC7,0x03,0x80,0xE7,0x01,0x80,0xE7,0x01,0x00,0xEF,0x00,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0xFC,0x00,0x00}, // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0xC0,0x07,0x00,0xE0,0x03,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0xC0,0x07,0x00,0xE0,0x03,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0xF8,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7A
{0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0xF0,0x0F,0x00,0xF8,0x0F,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x7C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x7C,0x00,0x00,0x3E,0x00,0xE0,0x1F,0x00,0xE0,0x07,0x00,0xE0,0x1F,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x0F,0x00,0xF0,0x0F,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7B
{0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7C
{0x00,0x00,0x00,0xF0,0x03,0x00,0xF0,0x0F,0x00,0xF0,0x1F,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x3E,0x00,0x00,0x7C,0x00,0x00,0xF8,0x07,0x00,0xE0,0x07,0x00,0xF8,0x07,0x00,0x7C,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0xF0,0x1F,0x00,0xF0,0x0F,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0xF8,0x07,0x70,0xFC,0x0F,0x70,0x1C,0x3F,0x70,0x0E,0xFC,0x38,0x0E,0xF0,0x3F,0x0E,0xE0,0x1F,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x07,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0x20,0x00,0x04,0xE0,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x7F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0x00,0xFE,0x7F,0x80,0xFF,0x7F,0xC0,0x0F,0x78,0xE0,0x03,0x40,0xF0,0x01,0x00,0xF8,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x01,0x00,0xE0,0x03,0x00,0xC0,0x1F,0x70,0x80,0xFF,0x7F,0x00,0xFE,0x7F,0x00,0xF8,0x0F,0x00,0x60,0x00,0x00,0x30,0x00,0x00,0xF0,0x00,0x00,0xC0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xF8,0x01,0x00,0xF8,0x00}, // 0x80
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x83,0x03,0x80,0x83,0x03,0x80,0x83,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0x78,0xC0,0x0F,0x78,0xE0,0x0F,0xF8,0x70,0x0F,0xF0,0x7F,0x0F,0xE0,0x1F,0x0F,0xC0,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x81
{0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x80,0xFF,0x03,0xC0,0xFF,0x07,0xE0,0x83,0x0F,0xE0,0x01,0x0F,0xF0,0x00,0x0E,0xF0,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x80,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x82
{0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0xC3,0x03,0xE0,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x83
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x84
{0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x85
{0x00,0x1C,0x00,0x00,0x22,0x00,0x00,0x41,0x00,0x00,0x41,0x00,0x00,0x41,0x00,0x00,0x22,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0x00,0xFF,0x1F,0xC0,0xFF,0x1F,0xE0,0x07,0x1C,0xE0,0x03,0x00,0xF0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xF0,0x03,0x00,0xE0,0x0F,0x1C,0xC0,0xFF,0x1F,0x00,0xFF,0x1F,0x00,0xFC,0x07,0x00,0x18,0x00,0x00,0x0C,0x00,0x00,0x3C,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x7E,0x00,0x00,0x3E,0x00}, // 0x87
{0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00,0xFE,0x01,0x00,0xCF,0x03,0x80,0x87,0x07,0xC0,0x01,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x80,0xFF,0x03,0xC0,0xFF,0x07,0xE0,0x83,0x0F,0xE0,0x01,0x0F,0xF0,0x00,0x0E,0xF0,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x80,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x88
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x80,0xFF,0x03,0xC0,0xFF,0x07,0xE0,0x83,0x0F,0xE0,0x01,0x0F,0xF0,0x00,0x0E,0xF0,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x80,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x89
{0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x80,0xFF,0x03,0xC0,0xFF,0x07,0xE0,0x83,0x0F,0xE0,0x01,0x0F,0xF0,0x00,0x0E,0xF0,0x00,0x1E,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x78,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x07,0x1C,0xC0,0xFF,0x1F,0x80,0xFF,0x1F,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8B
{0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00,0xFE,0x01,0x00,0xCF,0x03,0x80,0x87,0x07,0xC0,0x01,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8C
{0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8D
{0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8E
{0x00,0x3C,0x00,0x00,0x42,0x00,0x00,0x81,0x00,0x00,0x81,0x00,0x00,0x81,0x00,0x00,0xC3,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x8F
{0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x87,0x0F,0xF8,0xCF,0x3F,0xF8,0xFF,0x3F,0x08,0xFE,0x78,0x00,0x7C,0x70,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0xC0,0xFF,0xFF,0xF0,0xFF,0xFF,0xF8,0xFF,0xFF,0x7C,0x3C,0x00,0x3E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x3C,0x00,0x1E,0x7C,0x00,0x1E,0x7C,0x00,0x3E,0xFE,0xC0,0xFC,0xF7,0xFF,0xF8,0xE3,0xFF,0xF0,0xC1,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x91
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x3F,0x00,0xFC,0x3F,0x00,0xFC,0x3F,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0xFF,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xF3,0x00,0x80,0xF3,0x00,0xC0,0xF3,0x00,0xC0,0xF1,0x1F,0xE0,0xF1,0x1F,0xE0,0xF0,0x1F,0xE0,0xF0,0x00,0x70,0xF0,0x00,0x70,0xF0,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0xFC,0xFF,0x00,0x1C,0xF0,0x00,0x1C,0xF0,0x00,0x0E,0xF0,0x7F,0x0E,0xF0,0x7F,0x0F,0xF0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x92
{0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0xC3,0x03,0xE0,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x93
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x83,0x03,0x80,0x83,0x03,0x80,0x83,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x94
{0x00,0x00,0x00,0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x95
{0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0xC3,0x03,0xE0,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0x78,0xC0,0x0F,0x78,0xE0,0x0F,0xF8,0x70,0x0F,0xF0,0x7F,0x0F,0xE0,0x1F,0x0F,0xC0,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x96
{0x00,0x00,0x00,0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0x78,0xC0,0x0F,0x78,0xE0,0x0F,0xF8,0x70,0x0F,0xF0,0x7F,0x0F,0xE0,0x1F,0x0F,0xC0,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x97
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x78,0x3C,0x00,0x38,0x7C,0x00,0x3C,0x78,0x00,0x1C,0x78,0x00,0x1E,0xF8,0x00,0x0E,0xF0,0x00,0x0F,0xF0,0x01,0x0F,0xE0,0x81,0x07,0xE0,0x83,0x07,0xC0,0xC3,0x03,0xC0,0xC7,0x03,0x80,0xE7,0x01,0x80,0xE7,0x01,0x00,0xEF,0x00,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0xFC,0x00,0x00}, // 0x98
{0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x99
{0x80,0x03,0x0E,0x80,0x03,0x0E,0x80,0x03,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xE0,0x83,0x0F,0xE0,0xFF,0x0F,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x38,0xC0,0xFF,0x1F,0xE0,0xFF,0x0F,0xF0,0xC1,0x0F,0xF8,0x00,0x1F,0x78,0x80,0x1F,0x78,0xC0,0x1F,0x3C,0xE0,0x3C,0x3C,0x70,0x3C,0x3C,0x38,0x3C,0x3C,0x3C,0x3C,0x3C,0x1C,0x3C,0x3C,0x0E,0x3C,0x3C,0x07,0x3C,0xF8,0x03,0x1E,0xF8,0x01,0x1E,0xF8,0x00,0x1F,0xF0,0x83,0x0F,0xF0,0xFF,0x07,0xF8,0xFF,0x03,0x1C,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0xF0,0x1F,0x00,0xF8,0x1F,0x00,0x3C,0x10,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0xFF,0x1F,0xE0,0xFF,0x1F,0xE0,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x70,0xC0,0xFF,0x3B,0xE0,0xFF,0x1F,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1F,0x3C,0x80,0x3F,0x3C,0xC0,0x3F,0x1E,0xC0,0x79,0x1E,0xE0,0x78,0x1E,0x70,0x78,0x1E,0x38,0x78,0x1E,0x3C,0x78,0x1E,0x1C,0x78,0x1E,0x0E,0x78,0x1E,0x07,0x78,0x9E,0x03,0x78,0xFC,0x03,0x3C,0xFC,0x01,0x3C,0xF8,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xF8,0xFF,0x07,0xDC,0xFF,0x03,0x0E,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x1C,0x00,0x1C,0x3E,0x00,0x3E,0x7C,0x00,0x1F,0xF8,0x80,0x0F,0xF0,0xC1,0x07,0xE0,0xE3,0x03,0xC0,0xF7,0x01,0x80,0xFF,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x7F,0x00,0x80,0xFF,0x00,0xC0,0xF7,0x01,0xE0,0xE3,0x03,0xF0,0xC1,0x07,0xF8,0x80,0x0F,0x7C,0x00,0x1F,0x3E,0x00,0x3E,0x1C,0x00,0x1C,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0x9E
{0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0xF8,0x1F,0x00,0xFC,0x1F,0x00,0x3C,0x10,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0xE0,0xFF,0x07,0xE0,0xFF,0x07,0xE0,0xFF,0x07,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x02,0x0F,0x00,0xFE,0x0F,0x00,0xFE,0x07,0x00,0xFC,0x01,0x00}, // 0x9F
{0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA0
{0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA1
{0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA2
{0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0x78,0xC0,0x0F,0x78,0xE0,0x0F,0xF8,0x70,0x0F,0xF0,0x7F,0x0F,0xE0,0x1F,0x0F,0xC0,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x80,0x3F,0x06,0xC0,0xFF,0x07,0xC0,0xF8,0x03,0xC0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xE0,0x07,0xF0,0xF8,0x0F,0xF0,0xFC,0x1F,0xF0,0x0E,0x1E,0xF0,0x07,0x3E,0xF0,0x03,0x3C,0xF0,0x01,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA4
{0x00,0x0F,0x06,0x80,0x3F,0x07,0xC0,0xF9,0x03,0xC0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x1C,0x78,0x00,0x1C,0xF8,0x00,0x1C,0xF8,0x01,0x1C,0xF8,0x01,0x1C,0xF8,0x03,0x1C,0xF8,0x07,0x1C,0xB8,0x07,0x1C,0xB8,0x0F,0x1C,0x38,0x1F,0x1C,0x38,0x1F,0x1C,0x38,0x3E,0x1C,0x38,0x3C,0x1C,0x38,0x7C,0x1C,0x38,0xF8,0x1C,0x38,0xF0,0x1C,0x38,0xF0,0x1D,0x38,0xE0,0x1F,0x38,0xE0,0x1F,0x38,0xC0,0x1F,0x38,0x80,0x1F,0x38,0x80,0x1F,0x38,0x00,0x1F,0x38,0x00,0x1E,0x38,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xC0,0xC1,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xFE,0x03,0x80,0xFF,0x03,0xC0,0x83,0x03,0xE0,0x80,0x03,0xE0,0x80,0x03,0xE0,0x80,0x03,0xE0,0xE1,0x03,0xC0,0x3F,0x0F,0x80,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xE0,0xC1,0x03,0xE0,0x80,0x03,0x70,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x07,0x70,0x00,0x07,0xE0,0x80,0x03,0xE0,0xC1,0x03,0xC0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x1C,0x78,0x00,0x1C,0xF8,0x00,0x1C,0xF0,0x03,0x1C,0xF0,0xFF,0x1F,0xC0,0xFF,0x1F,0x00,0xFF,0x03}, // 0xA8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x80,0xFF,0x00,0xE0,0xC1,0x03,0x60,0x3F,0x03,0x30,0x63,0x06,0x30,0x63,0x06,0x18,0x63,0x0C,0x18,0x33,0x0C,0x18,0x1F,0x0C,0x18,0x13,0x0C,0x18,0x33,0x0C,0x30,0x33,0x06,0x30,0x63,0x06,0x60,0x00,0x03,0xE0,0xC1,0x03,0x80,0xFF,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x07,0x3F,0x80,0x03,0x3F,0x80,0x03,0x38,0xC0,0x01,0x38,0xC0,0x01,0x38,0xE0,0x00,0x38,0xE0,0x00,0x38,0x70,0x00,0x38,0x38,0x00,0x38,0x38,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x87,0x1F,0x00,0xC7,0x7F,0x80,0x43,0xF0,0x80,0x03,0xE0,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xE0,0x00,0x70,0xE0,0x00,0x3C,0x70,0x00,0x1E,0x38,0x00,0x07,0x38,0x80,0x03,0x1C,0xC0,0x01,0x1C,0xC0,0xFF,0x0E,0xC0,0xFF,0x0E,0xC0,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0E,0x3F,0x00,0x07,0x3F,0x00,0x07,0x38,0x80,0x03,0x38,0x80,0x03,0x38,0xC0,0x01,0x38,0xC0,0x01,0x38,0xE0,0x00,0x38,0x70,0x00,0x38,0x70,0x00,0x38,0x38,0x00,0x38,0x38,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x38,0x0E,0x1E,0x00,0x0E,0x1F,0x00,0x07,0x1F,0x00,0x87,0x1D,0x80,0xC3,0x1C,0x80,0xE3,0x1C,0xC0,0x71,0x1C,0xC0,0x31,0x1C,0xE0,0x18,0x1C,0x70,0xF8,0x7F,0x70,0xF8,0x7F,0x38,0x00,0x1C,0x38,0x00,0x1C,0x1C,0x00,0x1C,0x1C,0x00,0x1C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00}, // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x00,0x0E,0x0E,0x00,0x07,0x07,0x80,0x83,0x03,0xC0,0xC1,0x01,0xE0,0xE0,0x00,0x70,0x70,0x00,0x38,0x38,0x00,0x1C,0x1C,0x00,0x38,0x38,0x00,0x70,0x70,0x00,0xE0,0xE0,0x00,0xC0,0xC1,0x01,0x80,0x83,0x03,0x00,0x07,0x07,0x00,0x0E,0x0E,0x00,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x00,0x1C,0x38,0x00,0x78,0x70,0x00,0xF0,0xE0,0x00,0xE0,0xC1,0x01,0xC0,0x83,0x03,0x80,0x07,0x07,0x00,0x0E,0x0E,0x00,0x1E,0x1C,0x00,0x0F,0x0E,0x80,0x07,0x07,0xC0,0x83,0x03,0xE0,0xC1,0x01,0xF0,0xE0,0x00,0x78,0x70,0x00,0x3C,0x38,0x00,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xAF
{0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB0
{0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F}, // 0xB1
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F}, // 0xB2
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xB3
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xB4
{0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB5
{0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB6
{0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xE0,0x80,0x03,0x70,0x00,0x07,0x38,0x00,0x0E,0x18,0x00,0x0C,0x0C,0x00,0x18,0x0C,0xFC,0x18,0x0C,0xFF,0x19,0x86,0xFF,0x31,0xC6,0x83,0x31,0xC6,0x01,0x30,0xE6,0x00,0x30,0xE6,0x00,0x30,0xE6,0x00,0x30,0xE6,0x00,0x30,0xE6,0x00,0x30,0xE6,0x01,0x30,0xC6,0x01,0x30,0xC6,0x07,0x31,0x86,0xFF,0x31,0x0C,0xFF,0x19,0x0C,0x7E,0x18,0x0C,0x00,0x18,0x18,0x00,0x0C,0x38,0x00,0x0E,0x70,0x00,0x07,0xE0,0x80,0x03,0xC0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xB8
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xB9
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xBB
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0xFF,0xC7,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xBC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0xFC,0x01,0x00,0xFF,0x07,0x80,0xFF,0x07,0xC0,0x37,0x07,0xE0,0x31,0x00,0xF0,0x30,0x00,0xF0,0x30,0x00,0xF8,0x30,0x00,0x78,0x30,0x00,0x78,0x30,0x00,0x78,0x30,0x00,0x78,0x30,0x00,0x78,0x30,0x00,0x78,0x30,0x00,0x78,0x30,0x00,0xF8,0x30,0x00,0xF0,0x30,0x00,0xF0,0x31,0x00,0xE0,0x33,0x00,0xE0,0x3F,0x06,0xC0,0xFF,0x07,0x00,0xFF,0x07,0x00,0xFC,0x01,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xBD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0xF0,0x7C,0x00,0x70,0x78,0x00,0x38,0xF8,0x00,0x3C,0xF0,0x00,0x1E,0xE0,0x01,0x0E,0xE0,0x03,0x07,0xC0,0x83,0x07,0xC0,0x87,0x03,0x80,0xCF,0x01,0x00,0xEF,0x01,0x00,0xFF,0x00,0x00,0x7E,0x00,0x00,0x7C,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xBF
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC0
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xC2
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC4
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xC5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x80,0x3F,0x06,0xC0,0xFF,0x07,0xC0,0xF8,0x03,0xC0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xE0,0xFF,0x03,0xE0,0xFF,0x07,0xE0,0x80,0x0F,0x20,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0xFE,0x0F,0x80,0xFF,0x0F,0xE0,0xFF,0x0F,0xF0,0x03,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x00,0x0F,0x78,0x80,0x0F,0xF8,0xE1,0x1F,0xF0,0xFF,0xFE,0xE0,0x7F,0xFE,0x80,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC6
{0x00,0x0F,0x06,0x80,0x3F,0x07,0xC0,0xF9,0x03,0xC0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xF7,0x00,0x00,0xF7,0x00,0x80,0xE7,0x01,0x80,0xE3,0x01,0x80,0xE3,0x01,0xC0,0xC3,0x03,0xC0,0xC1,0x03,0xE0,0x81,0x07,0xE0,0x81,0x07,0xE0,0x80,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3E,0x00,0x7C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x0F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC7
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xC9
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xCB
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0xC7,0xFF,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xCD
{0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0xFF,0xC7,0xFF,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01,0x00,0xC7,0x01}, // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x38,0x00,0x38,0x70,0x7C,0x1C,0xE0,0xFF,0x0F,0xC0,0xFF,0x07,0xC0,0x83,0x07,0xC0,0x01,0x07,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xC0,0x01,0x07,0xC0,0x83,0x07,0xC0,0xFF,0x07,0xE0,0xFF,0x0F,0x70,0x7C,0x1C,0x38,0x00,0x38,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xCF
{0x00,0x00,0x00,0x7C,0x40,0x00,0xFC,0xF3,0x00,0xFC,0x7F,0x00,0xE0,0x3F,0x00,0x00,0x3F,0x00,0x80,0x7F,0x00,0xE0,0xFB,0x01,0xE0,0xF0,0x01,0x60,0xE0,0x03,0x00,0xC0,0x07,0x00,0xFF,0x0F,0xC0,0xFF,0x0F,0xE0,0xFF,0x1F,0xF0,0x83,0x1F,0xF0,0x00,0x1F,0x78,0x00,0x3E,0x78,0x00,0x3E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF0,0x00,0x0F,0xF0,0xC3,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x01,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x07,0x78,0xC0,0x0F,0x78,0x00,0x1F,0x78,0x00,0x3E,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x78,0x78,0x00,0x78,0xFF,0x0F,0x78,0xFF,0x0F,0x78,0xFF,0x0F,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x78,0x78,0x00,0x38,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1F,0x78,0xE0,0x0F,0xF8,0xFF,0x07,0xF8,0xFF,0x01,0xF8,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD1
{0x00,0xFC,0x00,0x00,0xFE,0x01,0x00,0xCF,0x03,0x80,0x03,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD2
{0x80,0x03,0x0E,0x80,0x03,0x0E,0x80,0x03,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD3
{0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0xFF,0x1F,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0xFF,0x07,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0xF0,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0xF8,0x7F,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD5
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD6
{0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD7
{0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD8
{0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00}, // 0xDA
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 0xDC
{0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDD
{0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDE
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xDF
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE0
{0x00,0x00,0x00,0x80,0x3F,0x00,0xE0,0xFF,0x00,0xF0,0xFF,0x01,0xF0,0xE1,0x03,0xF8,0xC0,0x03,0x78,0xC0,0x03,0x78,0xC0,0x03,0x78,0xC0,0x01,0x78,0xE0,0x01,0x78,0xF0,0x00,0x78,0xF0,0x00,0x78,0x78,0x00,0x78,0x3C,0x00,0x78,0x3C,0x00,0x78,0x3C,0x00,0x78,0x7C,0x00,0x78,0xF8,0x00,0x78,0xF8,0x01,0x78,0xF0,0x07,0x78,0xE0,0x0F,0x78,0x80,0x0F,0x78,0x00,0x1F,0x78,0x00,0x3E,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x0E,0x1E,0x78,0xFE,0x1F,0x78,0xFE,0x0F,0x78,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE1
{0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE2
{0xC0,0x03,0x00,0x80,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x80,0x3F,0x06,0xC0,0xFF,0x07,0xC0,0xF8,0x03,0xC0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE4
{0x00,0x0F,0x06,0x80,0x3F,0x07,0xC0,0xF9,0x03,0xC0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xE0,0xFF,0x07,0xF0,0x81,0x0F,0xF8,0x00,0x1F,0x78,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x1E,0x00,0x78,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x1E,0xF8,0x00,0x1F,0xF0,0x81,0x0F,0xE0,0xFF,0x07,0xC0,0xFF,0x03,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xF0,0x01,0x1F,0xF0,0x81,0x1F,0xF0,0xC7,0x1F,0xF0,0xFF,0x1E,0xF0,0x7E,0x3E,0xF0,0x3C,0x3C,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00}, // 0xE6
{0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xF0,0x01,0xF0,0xFC,0x07,0xF0,0xFE,0x0F,0xF0,0x0E,0x1F,0xF0,0x03,0x1E,0xF0,0x01,0x1E,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1E,0xF0,0x01,0x1F,0xF0,0x87,0x0F,0xF0,0xFF,0x07,0xF0,0xFE,0x03,0xF0,0xF8,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00}, // 0xE7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0xFF,0x03,0xF0,0xFF,0x0F,0xF0,0xFF,0x1F,0xF0,0x00,0x1F,0xF0,0x00,0x3E,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x00,0x3E,0xF0,0x00,0x1F,0xF0,0xC0,0x0F,0xF0,0xFF,0x07,0xF0,0xFF,0x03,0xF0,0x7F,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE8
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xE0,0x83,0x0F,0xE0,0xFF,0x0F,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xE9
{0x00,0x7E,0x00,0x00,0xFF,0x00,0x80,0xE7,0x01,0xC0,0x81,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xE0,0x83,0x0F,0xE0,0xFF,0x0F,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEA
{0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x1E,0xF0,0x00,0x1F,0xE0,0x83,0x0F,0xE0,0xFF,0x0F,0x80,0xFF,0x03,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEB
{0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x78,0x3C,0x00,0x38,0x7C,0x00,0x3C,0x78,0x00,0x1C,0x78,0x00,0x1E,0xF8,0x00,0x0E,0xF0,0x00,0x0F,0xF0,0x01,0x0F,0xE0,0x81,0x07,0xE0,0x83,0x07,0xC0,0xC3,0x03,0xC0,0xC7,0x03,0x80,0xE7,0x01,0x80,0xE7,0x01,0x00,0xEF,0x00,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0xFC,0x00,0x00}, // 0xEC
{0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0xF0,0x3C,0x00,0x78,0x78,0x00,0x38,0xF8,0x00,0x3C,0xF0,0x00,0x1C,0xE0,0x01,0x1E,0xE0,0x03,0x0F,0xC0,0x07,0x07,0x80,0x87,0x07,0x80,0x8F,0x03,0x00,0xDF,0x03,0x00,0xFE,0x01,0x00,0xFE,0x00,0x00,0xFC,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xED
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEE
{0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 0xF2
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0xE0,0xFE,0x03,0x70,0x82,0x07,0x38,0x00,0x07,0x38,0x00,0x07,0x1C,0x80,0x03,0x0E,0xF8,0x01,0x0E,0xF8,0x00,0x07,0xE0,0x83,0x03,0x80,0x87,0x03,0x00,0xC7,0x01,0x00,0xE7,0x00,0x82,0xE7,0x00,0xFE,0x73,0x00,0xFE,0x38,0x3C,0x00,0x38,0x3E,0x00,0x1C,0x3E,0x00,0x0E,0x3B,0x00,0x8E,0x39,0x00,0xC7,0x39,0x80,0xE3,0x38,0x80,0x63,0x38,0xC0,0x31,0x38,0xE0,0xF0,0xFF,0xE0,0xF0,0xFF,0x70,0x00,0x38,0x38,0x00,0x38,0x38,0x00,0x38,0x1C,0x00,0x38,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x07,0xE0,0xFF,0x07,0xF0,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF8,0x0F,0x06,0xF0,0x0F,0x06,0xF0,0x0F,0x06,0xE0,0x0F,0x06,0xC0,0x0F,0x06,0x00,0x0F,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x00,0xFF,0x07,0x80,0xFF,0x07,0xC0,0x03,0x06,0xE0,0x01,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x03,0x00,0xC0,0x07,0x00,0x80,0x3F,0x00,0x80,0xFF,0x00,0x80,0xFF,0x01,0xC0,0xF1,0x03,0xC0,0xC0,0x07,0xE0,0x80,0x0F,0xE0,0x00,0x0F,0xE0,0x00,0x0E,0xE0,0x01,0x0E,0xC0,0x07,0x0E,0xC0,0x0F,0x07,0x80,0x7F,0x07,0x00,0xFE,0x03,0x00,0xF8,0x03,0x00,0xE0,0x07,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x20,0x00,0x0F,0xE0,0x81,0x07,0xE0,0xFF,0x03,0xE0,0xFF,0x01,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0xFC,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x0C,0x00,0x00,0x3C,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x7E,0x00,0x00,0x3E,0x00}, // 0xF7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0x7F,0x00,0x80,0xE3,0x00,0x80,0xC1,0x00,0x80,0xC1,0x00,0x80,0xC1,0x00,0x80,0xE3,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF8
{0xC0,0x01,0x07,0xC0,0x01,0x07,0xC0,0x01,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0xC0,0x1F,0x00,0xC0,0x1F,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x01,0xC0,0xC1,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xE0,0x01,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0xE0,0x01,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0xC0,0xC1,0x03,0xC0,0xFF,0x01,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xC0,0xFF,0x01,0xC0,0xC0,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xF0,0x00,0x00,0x7C,0x00,0x00,0x1E,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0xC0,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0xFE,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 0xFF
};
#endif

#ifdef USE_FONT_32X53
__UG_FONT_DATA unsigned char font_32x53[256][212]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x00
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0x1F,0xF8,0x01,0xC0,0x03,0xC0,0x03,0xE0,0x01,0x80,0x07,0xF0,0x00,0x00,0x0F,0x70,0x00,0x00,0x0E,0x38,0x1C,0x38,0x1C,0x38,0x3E,0x7C,0x1C,0x3C,0x3E,0x7C,0x3C,0x1C,0x3E,0x7C,0x38,0x1C,0x1C,0x38,0x38,0x1C,0x00,0x00,0x38,0x1C,0x00,0x00,0x38,0x1C,0x00,0x00,0x38,0x1C,0x03,0xC0,0x38,0x3C,0x03,0xC0,0x3C,0x38,0x07,0xE0,0x1C,0x38,0x1E,0x78,0x1C,0x70,0xFC,0x3F,0x0E,0xF0,0xF8,0x1F,0x0F,0xE0,0xE1,0x87,0x07,0xC0,0x03,0xC0,0x03,0x80,0x1F,0xF8,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x01
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xE3,0xC7,0x1F,0xF8,0xC1,0x83,0x1F,0xFC,0xC1,0x83,0x3F,0xFC,0xC1,0x83,0x3F,0xFC,0xE3,0xC7,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFC,0x3F,0x3F,0xFC,0xFC,0x3F,0x3F,0xF8,0xF8,0x1F,0x1F,0xF8,0xE1,0x87,0x1F,0xF0,0x03,0xC0,0x0F,0xF0,0x07,0xE0,0x0F,0xE0,0x1F,0xF8,0x07,0xC0,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x02
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xE0,0x03,0xF0,0x1F,0xF8,0x0F,0xF0,0x3F,0xFC,0x0F,0xF8,0x7F,0xFE,0x1F,0xFC,0x7F,0xFE,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x03
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xC0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFF,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0x7F,0xFC,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x00,0x00,0xFF,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x01,0x00,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x04
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF8,0x1F,0x00,0xE0,0xFB,0xDF,0x07,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFC,0xBF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xF8,0xDF,0xFB,0x1F,0xF0,0xCF,0xF3,0x0F,0xE0,0xC3,0xC3,0x07,0x00,0xC0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x05
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x0F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFC,0xFF,0xFF,0x3F,0xF8,0xDF,0xFB,0x1F,0xF0,0xCF,0xF3,0x0F,0xE0,0xC3,0xC3,0x07,0x00,0xC0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x80,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x80,0xFF,0x1F,0x00,0x80,0xFF,0x3F,0x00,0x80,0xBF,0x3F,0x00,0x00,0xC3,0x3F,0x00,0x00,0xC0,0x3F,0x00,0x00,0xE0,0x79,0x00,0x00,0xF0,0x79,0x00,0x00,0xF0,0x78,0x00,0x00,0xF8,0xF0,0x00,0x00,0x78,0xF0,0x00,0xFE,0x3D,0x30,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x1F,0x00,0xF0,0xFF,0x3F,0x00,0xF8,0x03,0x7F,0x00,0xFC,0x00,0xFC,0x00,0x7C,0x00,0xF8,0x00,0x3E,0x00,0xF0,0x01,0x1E,0x00,0xE0,0x01,0x1F,0x00,0xE0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x1F,0x00,0xE0,0x03,0x1E,0x00,0xE0,0x01,0x3E,0x00,0xF0,0x01,0x7C,0x00,0xF8,0x00,0xFC,0x00,0xFC,0x00,0xF8,0x03,0x7F,0x00,0xF0,0xFF,0x3F,0x00,0xE0,0xFF,0x1F,0x00,0x80,0xFF,0x07,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x00,0x00,0x0F,0xF8,0x00,0x00,0x1F,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0xF8,0x00,0x00,0x1F,0xF0,0x00,0x00,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x3E,0x00,0x00,0x80,0x3F,0x00,0x00,0xF0,0x3F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0x3F,0x00,0xC0,0xFF,0x3B,0x00,0xF0,0xFF,0x38,0x00,0xF8,0x3F,0x38,0x00,0xF8,0x0F,0x38,0x00,0xF8,0x03,0x38,0x00,0xF8,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0xE0,0x3F,0x00,0x38,0xF8,0x3F,0x00,0x38,0xFC,0x3F,0x00,0x38,0xFC,0x1F,0x00,0x38,0xFE,0x1F,0x00,0x38,0xFE,0x0F,0x00,0x38,0xFE,0x07,0x00,0x38,0xFC,0x03,0x00,0x38,0xF8,0x00,0xE0,0x3F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFE,0x1F,0x00,0x00,0xFE,0x1F,0x00,0x00,0xFE,0x0F,0x00,0x00,0xFE,0x07,0x00,0x00,0xFC,0x03,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xC0,0xC0,0x03,0x03,0xE0,0xF1,0x8F,0x07,0xE0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0x01,0x80,0x3F,0xFC,0x01,0x80,0x0F,0xF0,0x01,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xFC,0x03,0xC0,0x3F,0xFC,0x03,0xC0,0x3F,0xFC,0x03,0xC0,0x3F,0xFC,0x03,0xC0,0x3F,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x3F,0xFC,0x01,0x80,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xE0,0xF1,0x8F,0x07,0xC0,0xC0,0x03,0x03,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x0F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0xFE,0x0F,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFE,0xFF,0x01,0x00,0xFE,0xFF,0x07,0x00,0xFE,0xFF,0x1F,0x00,0xFE,0xFF,0x7F,0x00,0xFE,0xFF,0xFF,0x01,0xFE,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0x1F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x1F,0xFE,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0x01,0xFE,0xFF,0x7F,0x00,0xFE,0xFF,0x1F,0x00,0xFE,0xFF,0x07,0x00,0xFE,0xFF,0x01,0x00,0xFE,0xFF,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFE,0x0F,0x00,0x00,0xFE,0x03,0x00,0x00,0xFE,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x10
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7F,0x00,0x00,0xC0,0x7F,0x00,0x00,0xF0,0x7F,0x00,0x00,0xFC,0x7F,0x00,0x00,0xFF,0x7F,0x00,0x80,0xFF,0x7F,0x00,0xE0,0xFF,0x7F,0x00,0xF8,0xFF,0x7F,0x00,0xFE,0xFF,0x7F,0x80,0xFF,0xFF,0x7F,0xE0,0xFF,0xFF,0x7F,0xF8,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xF8,0xFF,0xFF,0x7F,0xE0,0xFF,0xFF,0x7F,0x80,0xFF,0xFF,0x7F,0x00,0xFE,0xFF,0x7F,0x00,0xF8,0xFF,0x7F,0x00,0xE0,0xFF,0x7F,0x00,0x80,0xFF,0x7F,0x00,0x00,0xFF,0x7F,0x00,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x7F,0x00,0x00,0xC0,0x7F,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x11
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x80,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xDE,0x7B,0x00,0x00,0xCF,0xF3,0x00,0x00,0xC7,0xE3,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC7,0xE3,0x00,0x00,0xCF,0xF3,0x00,0x00,0xDE,0x7B,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x01,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x12
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0E,0x70,0x00,0x00,0x0E,0x70,0x00,0x00,0x0E,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0xFC,0x01,0x80,0x3F,0xFC,0x01,0x80,0x3F,0xFC,0x01,0x80,0x3F,0xFC,0x01,0x80,0x3F,0xFC,0x01,0x80,0x3F,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x13
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xF0,0xFF,0x80,0x03,0xF0,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF0,0xFF,0x80,0x03,0xF0,0xFF,0x80,0x03,0xE0,0xFF,0x80,0x03,0xC0,0xFF,0x80,0x03,0x80,0xFF,0x80,0x03,0x00,0xFE,0x80,0x03,0x00,0xF8,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x14
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x7F,0x00,0x00,0xF8,0xFF,0x03,0x00,0xFE,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x80,0x3F,0xC0,0x03,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0xFF,0x01,0x00,0x00,0xFE,0x07,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xCF,0xFF,0x00,0x80,0x0F,0xFF,0x01,0x80,0x07,0xFC,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x0F,0xC0,0x07,0x80,0x1F,0xC0,0x07,0x80,0x7F,0xC0,0x03,0x00,0xFF,0xE0,0x03,0x00,0xFE,0xE3,0x01,0x00,0xFC,0xFF,0x00,0x00,0xF0,0x7F,0x00,0x00,0xE0,0x7F,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0xF8,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x40,0x00,0xC0,0x07,0xC0,0x01,0xE0,0x03,0xC0,0x0F,0xF8,0x03,0xC0,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x00,0x00,0xFF,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x15
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x16
{0x00,0x80,0x01,0x00,0x00,0x80,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xDE,0x7B,0x00,0x00,0xCF,0xF3,0x00,0x00,0xC7,0xE3,0x00,0x00,0xC1,0x83,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC1,0x83,0x00,0x00,0xC7,0xE3,0x00,0x00,0xCF,0xF3,0x00,0x00,0xDE,0x7B,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x01,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00},   // 0x17
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x80,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xCF,0xF3,0x00,0x00,0xC7,0xE3,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x18
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC7,0xE3,0x00,0x00,0xCF,0xF3,0x00,0x00,0xDE,0x7B,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x01,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x19
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0xFC,0xFF,0xFF,0x0F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xF0,0xFF,0xFF,0x3F,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x38,0x00,0x00,0x0E,0x70,0x00,0x00,0x0F,0xF0,0x00,0x80,0x07,0xE0,0x01,0xC0,0x07,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xF0,0xFF,0xFF,0x0F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xF0,0xFF,0xFF,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x01,0x00,0x0F,0xF0,0x00,0x00,0x0E,0x70,0x00,0x00,0x1C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0x7F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x20
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x21
{0x00,0x00,0x00,0x00,0xC0,0x0F,0xF8,0x01,0xC0,0x0F,0xF8,0x01,0xC0,0x0F,0xF8,0x01,0xC0,0x0F,0xF8,0x01,0xC0,0x0F,0xF8,0x01,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x22
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xE0,0x81,0x07,0x00,0xE0,0x81,0x07,0x00,0xE0,0x81,0x07,0x00,0xE0,0x81,0x07,0x00,0xF0,0xC0,0x03,0x00,0xF0,0xC0,0x03,0x00,0xF0,0xC0,0x03,0x00,0x78,0xE0,0x01,0x00,0x78,0xE0,0x01,0xE0,0xFF,0xFF,0x7F,0xF0,0xFF,0xFF,0x7F,0xF0,0xFF,0xFF,0x7F,0xF0,0xFF,0xFF,0x3F,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x0F,0x3C,0x00,0x00,0x0F,0x3C,0x00,0xFC,0xFF,0xFF,0x1F,0xFE,0xFF,0xFF,0x1F,0xFE,0xFF,0xFF,0x0F,0xFE,0xFF,0xFF,0x0F,0x80,0x07,0x1E,0x00,0x80,0x07,0x1E,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xC0,0x03,0x0F,0x00,0xE0,0x81,0x07,0x00,0xE0,0x81,0x07,0x00,0xE0,0x81,0x07,0x00,0xE0,0x81,0x07,0x00,0xF0,0xC0,0x03,0x00,0xF0,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x23
{0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0xF0,0x3F,0x00,0x00,0xFC,0xFF,0x01,0x00,0xFE,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x80,0x9F,0xC3,0x03,0x80,0x8F,0x03,0x02,0xC0,0x8F,0x03,0x00,0xC0,0x87,0x03,0x00,0xC0,0x87,0x03,0x00,0xC0,0x87,0x03,0x00,0xC0,0x87,0x03,0x00,0xC0,0x8F,0x03,0x00,0x80,0x8F,0x03,0x00,0x80,0x9F,0x03,0x00,0x00,0xBF,0x03,0x00,0x00,0xFE,0x03,0x00,0x00,0xFC,0x03,0x00,0x00,0xF8,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x3F,0x00,0x00,0x80,0x7F,0x00,0x00,0x80,0xFF,0x00,0x00,0x80,0xFF,0x01,0x00,0x80,0xFB,0x03,0x00,0x80,0xF3,0x03,0x00,0x80,0xE3,0x07,0x00,0x80,0xC3,0x07,0x00,0x80,0xC3,0x07,0x00,0x80,0xC3,0x07,0x00,0x80,0xC3,0x07,0x00,0x80,0xC3,0x07,0x00,0x80,0xE3,0x03,0xE0,0x80,0xE3,0x03,0xE0,0x87,0xFB,0x01,0xE0,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x00,0x80,0xFF,0x3F,0x00,0x00,0xFC,0x0F,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x24
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xE0,0x07,0x00,0x78,0xF8,0x1F,0x00,0x3C,0xFC,0x3F,0x00,0x3C,0x3E,0x7C,0x00,0x1E,0x1E,0x78,0x00,0x0F,0x1E,0x78,0x80,0x07,0x0F,0xF0,0x80,0x07,0x0F,0xF0,0xC0,0x03,0x0F,0xF0,0xE0,0x01,0x0F,0xF0,0xE0,0x01,0x0F,0xF0,0xF0,0x00,0x0F,0xF0,0x78,0x00,0x1E,0x78,0x78,0x00,0x1E,0x78,0x3C,0x00,0x3C,0x3C,0x1E,0x00,0xFC,0x3F,0x0F,0x00,0xF8,0x1F,0x0F,0x00,0xE0,0x87,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0xE1,0x07,0x00,0xF0,0xF8,0x1F,0x00,0xF0,0xFC,0x3F,0x00,0x78,0x3C,0x3C,0x00,0x3C,0x1E,0x78,0x00,0x1E,0x1E,0x78,0x00,0x1E,0x0F,0xF0,0x00,0x0F,0x0F,0xF0,0x80,0x07,0x0F,0xF0,0x80,0x07,0x0F,0xF0,0xC0,0x03,0x0F,0xF0,0xE0,0x01,0x0F,0xF0,0xE0,0x01,0x1E,0x78,0xF0,0x00,0x1E,0x78,0x78,0x00,0x3C,0x3C,0x3C,0x00,0xFC,0x3F,0x3C,0x00,0xF8,0x1F,0x1E,0x00,0xE0,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x25
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xFC,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0x7E,0xFC,0x00,0x00,0x3F,0xF8,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF8,0x00,0x00,0x3F,0xF8,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x3F,0x00,0x00,0xFE,0x1F,0x00,0x00,0xFC,0x0F,0x00,0x00,0xFC,0x03,0x00,0x00,0xFF,0x01,0x00,0xC0,0xFF,0x01,0x00,0xE0,0xFF,0x01,0xF8,0xF0,0xF3,0x03,0xF8,0xF8,0xE1,0x03,0xF8,0xFC,0xE0,0x07,0xF8,0x7C,0xC0,0x0F,0x78,0x3E,0xC0,0x0F,0x78,0x3E,0x80,0x1F,0x78,0x3E,0x00,0x3F,0x7C,0x3E,0x00,0x7F,0x3C,0x3E,0x00,0x7E,0x3C,0x3E,0x00,0xFC,0x3E,0x7E,0x00,0xFC,0x1F,0x7E,0x00,0xF8,0x0F,0xFC,0x00,0xF0,0x0F,0xFC,0x01,0xE0,0x07,0xF8,0x03,0xF0,0x0F,0xF0,0x07,0xFE,0x1F,0xF0,0xFF,0xFF,0x3F,0xC0,0xFF,0x3F,0x7F,0x80,0xFF,0x0F,0xFE,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x26
{0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x27
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0xC0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xFE,0x03,0x00,0x00,0xFF,0x00,0x00,0x80,0x3F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x28
{0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xC0,0x7F,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFF,0x00,0x00,0xC0,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x03,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x29
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x20,0xC0,0x01,0x02,0xE0,0xC0,0x81,0x03,0xE0,0xC3,0xE1,0x03,0xE0,0x0F,0xF8,0x03,0xF0,0x1F,0xFC,0x07,0xE0,0x0F,0xF8,0x03,0x00,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x04,0x00,0x00,0x78,0x0F,0x00,0x00,0x3C,0x1E,0x00,0x00,0x3E,0x3E,0x00,0x00,0x1F,0x7C,0x00,0x80,0x1F,0xFC,0x00,0x80,0x0F,0xF8,0x00,0x00,0x07,0x70,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x2F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0x1F,0xF8,0x01,0xC0,0x0F,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x01,0x80,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x00,0x00,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x00,0x00,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x01,0x80,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x0F,0xF0,0x03,0x80,0x1F,0xF8,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x30
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x80,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x0F,0x00,0xC0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0x87,0x0F,0x00,0x60,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0xE0,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x31
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x00,0xC0,0xFF,0x0F,0x00,0xE0,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0x03,0x7F,0x00,0x60,0x00,0xFC,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x32
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0x00,0x80,0xFF,0x3F,0x00,0x80,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x00,0x80,0x07,0xFC,0x01,0x80,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFC,0x0F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFC,0x7F,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x40,0x00,0xF8,0x01,0xC0,0x03,0xFE,0x01,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0x7F,0x00,0xC0,0xFF,0x1F,0x00,0x00,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x33
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFF,0x00,0x00,0x80,0xFF,0x00,0x00,0x80,0xFF,0x00,0x00,0xC0,0xFF,0x00,0x00,0xE0,0xFB,0x00,0x00,0xE0,0xF9,0x00,0x00,0xF0,0xF9,0x00,0x00,0xF8,0xF8,0x00,0x00,0x78,0xF8,0x00,0x00,0x3C,0xF8,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1E,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x07,0xF8,0x00,0xC0,0x03,0xF8,0x00,0xE0,0x03,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0xF8,0xFF,0xFF,0x1F,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x34
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0xFF,0x01,0x00,0x00,0xFF,0x0F,0x00,0x00,0xFF,0x3F,0x00,0x00,0xFF,0x7F,0x00,0x00,0x80,0xFF,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x80,0x00,0xF8,0x01,0x80,0x07,0xFE,0x00,0x80,0xFF,0xFF,0x00,0x80,0xFF,0x3F,0x00,0x80,0xFF,0x1F,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x35
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0x00,0xE0,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0xFC,0xFF,0x07,0x00,0xFE,0x80,0x07,0x00,0x3F,0x00,0x04,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x81,0x1F,0x00,0xF0,0xE1,0x7F,0x00,0xF0,0xF9,0xFF,0x01,0xF0,0xFD,0xFF,0x03,0xF0,0x3D,0xF8,0x07,0xF0,0x0F,0xE0,0x07,0xF0,0x07,0xC0,0x0F,0xF0,0x07,0x80,0x0F,0xF0,0x03,0x80,0x1F,0xF0,0x03,0x00,0x1F,0xF0,0x03,0x00,0x1F,0xF0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xC0,0x03,0x80,0x0F,0xC0,0x07,0x80,0x0F,0xC0,0x0F,0xC0,0x0F,0x80,0x1F,0xE0,0x07,0x00,0x3F,0xF0,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFE,0xFF,0x00,0x00,0xF8,0x7F,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x36
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x37
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0xFC,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x3F,0xFC,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x0F,0xE0,0x01,0xC0,0x0F,0xF0,0x01,0x80,0x1F,0xF0,0x01,0x80,0x3F,0xF8,0x00,0x00,0xFF,0x7C,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0x1F,0xFF,0x01,0xC0,0x0F,0xFE,0x03,0xC0,0x07,0xF8,0x03,0xE0,0x03,0xF0,0x07,0xE0,0x03,0xE0,0x07,0xF0,0x01,0xC0,0x0F,0xF0,0x01,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xE0,0x0F,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x38
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x1F,0xF8,0x01,0xC0,0x0F,0xF0,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x1F,0xF0,0x01,0x80,0x1F,0xF0,0x01,0x80,0x1F,0xF0,0x03,0x80,0x1F,0xE0,0x03,0xC0,0x1F,0xE0,0x07,0xC0,0x1F,0xC0,0x0F,0xE0,0x1F,0xC0,0x3F,0x78,0x1F,0x80,0xFF,0x7F,0x1F,0x00,0xFF,0x3F,0x1F,0x00,0xFC,0x0F,0x1F,0x00,0xF0,0x03,0x1F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x40,0x00,0xF8,0x01,0xC0,0x03,0xFE,0x00,0xC0,0xFF,0x7F,0x00,0xC0,0xFF,0x3F,0x00,0xC0,0xFF,0x0F,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x39
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x3E,0x00,0x00,0x80,0x3F,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x07,0x00,0x00,0xFE,0x01,0x00,0xC0,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xFC,0x07,0x00,0x00,0xFF,0x01,0x00,0xC0,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xFC,0x07,0x00,0x00,0xF0,0x1F,0x00,0x00,0xC0,0x7F,0x00,0x00,0x00,0xFF,0x01,0x00,0x00,0xFC,0x07,0x00,0x00,0xF0,0x1F,0x00,0x00,0xC0,0x7F,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0xF8,0x07,0x00,0x00,0xE0,0x1F,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0xF8,0x07,0x00,0x00,0xE0,0x1F,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0xF8,0x0F,0x00,0x00,0xE0,0x3F,0x00,0x00,0x80,0xFF,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0xF8,0x0F,0x00,0x00,0xE0,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xFE,0x03,0x00,0x80,0xFF,0x00,0x00,0xE0,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xFE,0x03,0x00,0x80,0x7F,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x07,0x00,0x00,0xFC,0x01,0x00,0x00,0x7C,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,0x00,0xF0,0xFF,0x7F,0x00,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x03,0xF0,0x01,0xF8,0x07,0xF0,0x00,0xE0,0x07,0xF0,0x00,0xC0,0x0F,0xF0,0x00,0x80,0x0F,0xF0,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x3F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0xF0,0xFF,0x01,0x00,0xFC,0xFF,0x03,0x00,0x7E,0xE0,0x07,0x00,0x1F,0x80,0x0F,0x80,0x0F,0x00,0x0F,0xC0,0x07,0x00,0x0F,0xC0,0x03,0x00,0x1E,0xE0,0x01,0xF8,0x1E,0xF0,0x01,0xFE,0x1F,0xF0,0x00,0xFF,0x1F,0xF0,0x80,0x0F,0x1F,0x78,0x80,0x07,0x1E,0x78,0xC0,0x03,0x1E,0x78,0xE0,0x01,0x1E,0x7C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x00,0x1E,0x3C,0xF0,0x00,0x1F,0x3C,0xF0,0x00,0x1F,0x3C,0xF0,0x00,0x1F,0x3C,0xF0,0x80,0x1F,0x3C,0xF0,0x80,0x1F,0x3C,0xF0,0xC0,0x1F,0x3C,0xF0,0xC0,0x1F,0x3C,0xF0,0xE0,0x1E,0x7C,0xF0,0xF1,0x1E,0x78,0xE0,0x79,0x1E,0x78,0xE0,0x7F,0x1E,0x78,0xC0,0x3F,0xFE,0xF0,0xC0,0x1F,0xFE,0xF0,0x00,0x0F,0xFE,0xE0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x0F,0x00,0x01,0x00,0x3F,0xE0,0x01,0x00,0xFE,0xFF,0x01,0x00,0xF8,0xFF,0x01,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x40
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x41
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x1F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xE0,0x03,0xF0,0x07,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xFC,0x01,0xE0,0xFF,0xFF,0x00,0xE0,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x01,0xE0,0x03,0xFE,0x03,0xE0,0x03,0xF0,0x07,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xF0,0x0F,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x01,0xE0,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x42
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0xE0,0xFF,0x3F,0x00,0xF8,0xFF,0x3F,0x00,0xFE,0xFF,0x3F,0x00,0xFF,0x01,0x3E,0x80,0x3F,0x00,0x30,0xC0,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x00,0x80,0x7F,0x00,0x20,0x00,0xFF,0x01,0x3C,0x00,0xFE,0xFF,0x3F,0x00,0xF8,0xFF,0x3F,0x00,0xE0,0xFF,0x1F,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x43
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0x00,0xF8,0xFF,0x1F,0x00,0xF8,0xFF,0x7F,0x00,0xF8,0xFF,0xFF,0x00,0xF8,0x00,0xFE,0x01,0xF8,0x00,0xF8,0x03,0xF8,0x00,0xE0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xE0,0x03,0xF8,0x00,0xF8,0x03,0xF8,0x00,0xFF,0x01,0xF8,0xFF,0xFF,0x00,0xF8,0xFF,0x7F,0x00,0xF8,0xFF,0x1F,0x00,0xF8,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x44
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x45
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x07,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x46
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x01,0x00,0xF0,0xFF,0x1F,0x00,0xFC,0xFF,0x1F,0x00,0xFF,0xFF,0x1F,0x80,0xFF,0x00,0x1F,0xC0,0x1F,0x00,0x18,0xE0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0xFC,0x1F,0x7C,0x00,0xFC,0x1F,0x7C,0x00,0xFC,0x1F,0x7C,0x00,0xFC,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x03,0x00,0x1F,0xE0,0x07,0x00,0x1F,0xE0,0x0F,0x00,0x1F,0xC0,0x3F,0x00,0x1F,0x80,0xFF,0x01,0x1F,0x00,0xFF,0xFF,0x1F,0x00,0xFC,0xFF,0x1F,0x00,0xF0,0xFF,0x1F,0x00,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x47
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x48
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x49
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7E,0x00,0xC0,0x03,0x3F,0x00,0xC0,0xFF,0x1F,0x00,0xC0,0xFF,0x1F,0x00,0xC0,0xFF,0x07,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xC0,0x0F,0xF0,0x01,0xE0,0x07,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF8,0x00,0xF0,0x01,0x7C,0x00,0xF0,0x01,0x3E,0x00,0xF0,0x01,0x3F,0x00,0xF0,0x01,0x1F,0x00,0xF0,0x81,0x0F,0x00,0xF0,0xC1,0x07,0x00,0xF0,0xE1,0x03,0x00,0xF0,0xF1,0x01,0x00,0xF0,0xF9,0x01,0x00,0xF0,0xFD,0x00,0x00,0xF0,0x7D,0x00,0x00,0xF0,0xFF,0x00,0x00,0xF0,0xFD,0x01,0x00,0xF0,0xF9,0x01,0x00,0xF0,0xF1,0x03,0x00,0xF0,0xE1,0x07,0x00,0xF0,0xC1,0x0F,0x00,0xF0,0x81,0x1F,0x00,0xF0,0x01,0x3F,0x00,0xF0,0x01,0x7E,0x00,0xF0,0x01,0xFE,0x00,0xF0,0x01,0xFC,0x01,0xF0,0x01,0xF8,0x03,0xF0,0x01,0xF0,0x07,0xF0,0x01,0xE0,0x0F,0xF0,0x01,0xC0,0x1F,0xF0,0x01,0x80,0x3F,0xF0,0x01,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0x80,0x1F,0xFC,0x01,0xC0,0x1F,0xFC,0x01,0xC0,0x1F,0xFC,0x03,0xC0,0x1F,0xFC,0x03,0xE0,0x1F,0xFC,0x03,0xE0,0x1F,0xFC,0x07,0xE0,0x1E,0xBC,0x07,0xF0,0x1E,0xBC,0x0F,0xF0,0x1E,0x3C,0x0F,0x70,0x1E,0x3C,0x0F,0x78,0x1E,0x3C,0x1F,0x78,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x3E,0x3C,0x1E,0x3C,0x3C,0x1E,0x1E,0x3C,0x3C,0x1E,0x1E,0x3C,0x7C,0x1E,0x1E,0x3C,0x78,0x0F,0x1E,0x3C,0x78,0x0F,0x1E,0x3C,0xF8,0x07,0x1E,0x3C,0xF0,0x07,0x1E,0x3C,0xF0,0x07,0x1E,0x3C,0xF0,0x03,0x1E,0x3C,0xE0,0x03,0x1E,0x3C,0xE0,0x03,0x1E,0x3C,0x00,0x00,0x1E,0x3C,0x00,0x00,0x1E,0x3C,0x00,0x00,0x1E,0x3C,0x00,0x00,0x1E,0x3C,0x00,0x00,0x1E,0x3C,0x00,0x00,0x1E,0x3C,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x0F,0xF0,0x03,0x00,0x0F,0xF0,0x03,0x00,0x0F,0xF0,0x07,0x00,0x0F,0xF0,0x07,0x00,0x0F,0xF0,0x0F,0x00,0x0F,0xF0,0x1F,0x00,0x0F,0xF0,0x1F,0x00,0x0F,0xF0,0x3F,0x00,0x0F,0xF0,0x7E,0x00,0x0F,0xF0,0x7E,0x00,0x0F,0xF0,0xFC,0x00,0x0F,0xF0,0xF8,0x01,0x0F,0xF0,0xF8,0x01,0x0F,0xF0,0xF0,0x03,0x0F,0xF0,0xE0,0x03,0x0F,0xF0,0xE0,0x07,0x0F,0xF0,0xC0,0x0F,0x0F,0xF0,0xC0,0x0F,0x0F,0xF0,0x80,0x1F,0x0F,0xF0,0x00,0x3F,0x0F,0xF0,0x00,0x3F,0x0F,0xF0,0x00,0x7E,0x0F,0xF0,0x00,0x7C,0x0F,0xF0,0x00,0xFC,0x0F,0xF0,0x00,0xF8,0x0F,0xF0,0x00,0xF8,0x0F,0xF0,0x00,0xF0,0x0F,0xF0,0x00,0xE0,0x0F,0xF0,0x00,0xE0,0x0F,0xF0,0x00,0xC0,0x0F,0xF0,0x00,0x80,0x0F,0xF0,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x4F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0x7F,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x0F,0xC0,0x07,0xE0,0x1F,0xC0,0x07,0x80,0x1F,0xC0,0x07,0x00,0x3F,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x1F,0xC0,0x07,0x80,0x1F,0xC0,0x07,0xC0,0x1F,0xC0,0x07,0xF8,0x0F,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x01,0xC0,0xFF,0x7F,0x00,0xC0,0xFF,0x0F,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x50
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x7F,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0xF8,0x07,0x00,0x00,0xF0,0x1F,0x00,0x00,0xC0,0xFF,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x51
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x1F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x03,0xE0,0x03,0xF8,0x03,0xE0,0x03,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xF0,0x03,0xE0,0x03,0xF8,0x01,0xE0,0x03,0xFE,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0x3F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0x83,0x1F,0x00,0xE0,0x03,0x3F,0x00,0xE0,0x03,0x7F,0x00,0xE0,0x03,0x7E,0x00,0xE0,0x03,0xFC,0x00,0xE0,0x03,0xF8,0x01,0xE0,0x03,0xF8,0x03,0xE0,0x03,0xF0,0x03,0xE0,0x03,0xE0,0x07,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x1F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x3F,0xE0,0x03,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x52
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xE0,0x0F,0xF0,0x03,0xE0,0x03,0x00,0x03,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x3F,0x00,0x00,0xC0,0xFF,0x00,0x00,0x80,0xFF,0x07,0x00,0x00,0xFF,0x3F,0x00,0x00,0xFC,0xFF,0x00,0x00,0xF0,0xFF,0x01,0x00,0x80,0xFF,0x03,0x00,0x00,0xFC,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x10,0x00,0xC0,0x07,0xF0,0x00,0xE0,0x07,0xF0,0x07,0xF8,0x03,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x00,0xC0,0xFF,0x3F,0x00,0x00,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x53
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x54
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xC0,0x0F,0xE0,0x07,0xC0,0x1F,0xF0,0x07,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x55
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0xF8,0x3E,0x00,0x00,0x78,0x3E,0x00,0x00,0x7C,0x7E,0x00,0x00,0x7C,0x7C,0x00,0x00,0x3C,0xFC,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1E,0xF8,0x00,0x00,0x1F,0xF8,0x01,0x00,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x0F,0xE0,0x01,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x3F,0x78,0x00,0x00,0x3F,0x7C,0x00,0x00,0x7E,0x3C,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x56
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1E,0x00,0x00,0x78,0x1E,0x00,0x00,0x78,0x1E,0x00,0x00,0x78,0x1E,0x00,0x00,0x78,0x3E,0xC0,0x07,0x78,0x3E,0xE0,0x07,0x78,0x3E,0xE0,0x07,0x3C,0x3C,0xE0,0x0F,0x3C,0x3C,0xE0,0x0F,0x3C,0x3C,0xF0,0x0F,0x3C,0x7C,0xF0,0x0F,0x3C,0x7C,0xF0,0x1F,0x3C,0x7C,0x70,0x1F,0x1E,0x78,0x78,0x1E,0x1E,0x78,0x78,0x1E,0x1E,0x78,0x78,0x1E,0x1E,0x78,0x3C,0x3E,0x1E,0xF8,0x3C,0x3C,0x1E,0xF8,0x3C,0x3C,0x0F,0xF8,0x3C,0x3C,0x0F,0xF0,0x1E,0x7C,0x0F,0xF0,0x1E,0x78,0x0F,0xF0,0x1E,0x78,0x0F,0xF0,0x1E,0x78,0x07,0xF0,0x1F,0xF8,0x07,0xF0,0x0F,0xF0,0x07,0xE0,0x0F,0xF0,0x07,0xE0,0x0F,0xF0,0x07,0xE0,0x0F,0xF0,0x07,0xE0,0x07,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x57
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x7C,0xFC,0x00,0x00,0x3E,0xF8,0x01,0x00,0x1F,0xF0,0x03,0x80,0x0F,0xF0,0x07,0x80,0x0F,0xE0,0x07,0xC0,0x07,0xC0,0x0F,0xE0,0x03,0x80,0x1F,0xF0,0x01,0x80,0x3F,0xF8,0x00,0x00,0x3F,0xF8,0x00,0x00,0x7E,0x7C,0x00,0x00,0xFC,0x3E,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF8,0x3F,0x00,0x00,0x7C,0x7F,0x00,0x00,0x3E,0x7E,0x00,0x00,0x1F,0xFC,0x00,0x00,0x1F,0xF8,0x01,0x80,0x0F,0xF8,0x03,0xC0,0x07,0xF0,0x03,0xE0,0x03,0xE0,0x07,0xF0,0x01,0xC0,0x0F,0xF0,0x01,0xC0,0x1F,0xF8,0x00,0x80,0x1F,0x7C,0x00,0x00,0x3F,0x3E,0x00,0x00,0x7E,0x1F,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x58
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0xF8,0xFC,0x00,0x00,0x7C,0xF8,0x01,0x00,0x3E,0xF8,0x01,0x00,0x3E,0xF0,0x03,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xC0,0x0F,0xC0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF8,0x00,0x00,0x7E,0xF8,0x00,0x00,0xFC,0x7C,0x00,0x00,0xF8,0x3E,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x59
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x3F,0xF0,0xFF,0xFF,0x3F,0xF0,0xFF,0xFF,0x3F,0xF0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5A
{0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5B
{0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5C
{0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x1E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x3C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1E,0x78,0x00,0x00,0x0F,0x78,0x00,0x00,0x0F,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xE0,0x01,0xC0,0x03,0xE0,0x01,0xC0,0x03,0xC0,0x03,0xE0,0x01,0xC0,0x03,0xE0,0x01,0x80,0x07,0xF0,0x01,0x80,0x07,0xF0,0x00,0x00,0x0F,0xF0,0x00,0x00,0x0F,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x5F
{0x00,0xF8,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x60
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x61
{0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x81,0x1F,0x00,0xF0,0xE1,0x7F,0x00,0xF0,0xF1,0xFF,0x00,0xF0,0xF9,0xFF,0x01,0xF0,0x7D,0xF8,0x03,0xF0,0x1F,0xE0,0x03,0xF0,0x07,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0xC0,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x01,0xE0,0x07,0xF0,0x03,0xE0,0x03,0xF0,0x0F,0xF0,0x03,0xF0,0x1F,0xFC,0x01,0xF0,0xFD,0xFF,0x00,0xF0,0xF8,0x7F,0x00,0xF0,0xF0,0x3F,0x00,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x62
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x7F,0x00,0x00,0xF8,0xFF,0x07,0x00,0xFE,0xFF,0x07,0x00,0xFF,0xFF,0x07,0x80,0x7F,0x80,0x07,0xC0,0x1F,0x00,0x04,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0xFF,0x00,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFC,0xFF,0x0F,0x00,0xF8,0xFF,0x0F,0x00,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x63
{0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0xF8,0xC3,0x07,0x00,0xFE,0xCF,0x07,0x00,0xFF,0xDF,0x07,0x80,0xFF,0xFF,0x07,0xC0,0x1F,0xFC,0x07,0xE0,0x07,0xF8,0x07,0xE0,0x03,0xE0,0x07,0xF0,0x03,0xC0,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x01,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF0,0x01,0xE0,0x07,0xF0,0x01,0xF0,0x07,0xF0,0x01,0xF8,0x07,0xE0,0x03,0xFC,0x07,0xE0,0x0F,0xDF,0x07,0xC0,0xFF,0xCF,0x07,0x80,0xFF,0xC7,0x07,0x00,0xFF,0xC3,0x07,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x64
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x3F,0xF8,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0x7F,0x80,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xF8,0xFF,0x07,0x00,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x65
{0x00,0x00,0xFC,0x0F,0x00,0x00,0xFF,0x7F,0x00,0xC0,0xFF,0x7F,0x00,0xE0,0xFF,0x7F,0x00,0xF0,0x0F,0x70,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0xF8,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x3F,0xF8,0xFF,0xFF,0x3F,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x66
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x83,0x0F,0x00,0xFE,0x8F,0x0F,0x00,0xFF,0xBF,0x0F,0x80,0xFF,0xFF,0x0F,0xC0,0x1F,0xFC,0x0F,0xE0,0x07,0xF0,0x0F,0xE0,0x03,0xC0,0x0F,0xF0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0xC0,0x0F,0xF0,0x01,0xC0,0x0F,0xF0,0x03,0xE0,0x0F,0xE0,0x07,0xF8,0x0F,0xE0,0x0F,0xBE,0x0F,0xC0,0xFF,0x9F,0x0F,0x80,0xFF,0x8F,0x0F,0x00,0xFF,0x87,0x0F,0x00,0xFC,0x81,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x40,0x00,0xF0,0x03,0xE0,0x03,0xFC,0x01,0xE0,0xFF,0xFF,0x01,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0x3F,0x00,0x00,0xFE,0x07,0x00},   // 0x67
{0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x7F,0x00,0xE0,0xC3,0xFF,0x01,0xE0,0xE3,0xFF,0x03,0xE0,0xF3,0xFF,0x07,0xE0,0xFB,0xFF,0x07,0xE0,0xFF,0xE0,0x0F,0xE0,0x3F,0xC0,0x0F,0xE0,0x1F,0x80,0x0F,0xE0,0x0F,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x68
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x69
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0x3F,0x00,0xC0,0xFF,0x3F,0x00,0xC0,0xFF,0x3F,0x00,0xC0,0xFF,0x3F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1F,0x00,0x08,0x00,0x1F,0x00,0x78,0xC0,0x0F,0x00,0xF8,0xFF,0x0F,0x00,0xF8,0xFF,0x07,0x00,0xF8,0xFF,0x03,0x00,0xC0,0x7F,0x00,0x00},   // 0x6A
{0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x80,0x1F,0xC0,0x07,0xC0,0x0F,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xF8,0x01,0xC0,0x07,0xFC,0x00,0xC0,0x07,0x7E,0x00,0xC0,0x07,0x3F,0x00,0xC0,0x07,0x1F,0x00,0xC0,0x87,0x0F,0x00,0xC0,0xC7,0x07,0x00,0xC0,0xE7,0x03,0x00,0xC0,0xF7,0x01,0x00,0xC0,0xFF,0x03,0x00,0xC0,0xF7,0x03,0x00,0xC0,0xE7,0x07,0x00,0xC0,0xC7,0x0F,0x00,0xC0,0x87,0x1F,0x00,0xC0,0x07,0x3F,0x00,0xC0,0x07,0x7E,0x00,0xC0,0x07,0xFE,0x00,0xC0,0x07,0xFC,0x01,0xC0,0x07,0xF8,0x03,0xC0,0x07,0xF0,0x07,0xC0,0x07,0xE0,0x0F,0xC0,0x07,0xC0,0x1F,0xC0,0x07,0x80,0x3F,0xC0,0x07,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6B
{0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x3C,0xC0,0x03,0x3C,0x7E,0xF0,0x07,0x3C,0xFF,0xF8,0x0F,0xBC,0xFF,0xFC,0x0F,0xFC,0xF3,0x1D,0x1F,0xFC,0xE1,0x0F,0x1E,0xFC,0xE0,0x07,0x1E,0x7C,0xE0,0x07,0x1E,0x7C,0xE0,0x03,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x3C,0xE0,0x01,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x7F,0x00,0xE0,0xC3,0xFF,0x01,0xE0,0xE3,0xFF,0x03,0xE0,0xF3,0xFF,0x07,0xE0,0xFB,0xFF,0x07,0xE0,0xFF,0xE0,0x0F,0xE0,0x3F,0xC0,0x0F,0xE0,0x1F,0x80,0x0F,0xE0,0x0F,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x6F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x3F,0x00,0xE0,0xC3,0xFF,0x00,0xE0,0xF3,0xFF,0x01,0xE0,0xFB,0xFF,0x03,0xE0,0xFB,0xF0,0x07,0xE0,0x3F,0xC0,0x07,0xE0,0x0F,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x07,0xC0,0x07,0xE0,0x1F,0xE0,0x07,0xE0,0x3F,0xF8,0x03,0xE0,0xFF,0xFF,0x01,0xE0,0xFB,0xFF,0x00,0xE0,0xF3,0x7F,0x00,0xE0,0xC3,0x1F,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x70
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x83,0x07,0x00,0xFE,0x8F,0x07,0x00,0xFF,0xDF,0x07,0x80,0xFF,0xFF,0x07,0xC0,0x1F,0xFC,0x07,0xE0,0x07,0xF8,0x07,0xE0,0x03,0xE0,0x07,0xF0,0x03,0xC0,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x01,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF0,0x01,0xE0,0x07,0xF0,0x01,0xE0,0x07,0xF0,0x01,0xF0,0x07,0xE0,0x03,0xFC,0x07,0xE0,0x0F,0xDF,0x07,0xC0,0xFF,0xCF,0x07,0x80,0xFF,0xC7,0x07,0x00,0xFF,0xC3,0x07,0x00,0xFC,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00},   // 0x71
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x0F,0x00,0x1F,0xFC,0x1F,0x00,0x1F,0xFF,0x1F,0x00,0x9F,0xFF,0x1F,0x00,0xDF,0x0F,0x1E,0x00,0xFF,0x03,0x1E,0x00,0xFF,0x00,0x1E,0x00,0x7F,0x00,0x1E,0x00,0x3F,0x00,0x1E,0x00,0x3F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x72
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x3F,0x00,0x00,0xFC,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0x03,0x80,0x3F,0xC0,0x03,0xC0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x3F,0x00,0x00,0x80,0xFF,0x01,0x00,0x00,0xFF,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF8,0xFF,0x01,0x00,0xC0,0xFF,0x03,0x00,0x00,0xFE,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x0F,0xE0,0x00,0xE0,0x07,0xE0,0x07,0xF8,0x07,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x01,0xC0,0xFF,0x7F,0x00,0x00,0xFC,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x73
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0xF8,0xFF,0xFF,0x07,0xF8,0xFF,0xFF,0x07,0xF8,0xFF,0xFF,0x07,0xF8,0xFF,0xFF,0x07,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x03,0x08,0x00,0xF8,0xFF,0x0F,0x00,0xF0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x74
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0xE0,0x0F,0xE0,0x03,0xF0,0x0F,0xE0,0x07,0xF8,0x0F,0xE0,0x0F,0xFE,0x0F,0xC0,0xFF,0xBF,0x0F,0xC0,0xFF,0x9F,0x0F,0x80,0xFF,0x8F,0x0F,0x00,0xFF,0x87,0x0F,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x75
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x3F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x01,0x80,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x78,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x1E,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x76
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x70,0x1E,0xC0,0x07,0x78,0x3E,0xE0,0x07,0x78,0x3E,0xE0,0x07,0x78,0x3E,0xE0,0x0F,0x78,0x3E,0xE0,0x0F,0x38,0x3C,0xF0,0x0F,0x3C,0x3C,0x70,0x0E,0x3C,0x7C,0x70,0x1E,0x3C,0x7C,0x70,0x1E,0x3C,0x7C,0x78,0x1E,0x1C,0x78,0x38,0x1C,0x1E,0x78,0x38,0x3C,0x1E,0x78,0x3C,0x3C,0x1E,0xF8,0x3C,0x3C,0x1E,0xF8,0x1C,0x38,0x0E,0xF8,0x1C,0x78,0x0E,0xF0,0x1E,0x78,0x0F,0xF0,0x0E,0x78,0x0F,0xF0,0x0F,0x70,0x0F,0xF0,0x0F,0xF0,0x07,0xF0,0x0F,0xF0,0x07,0xE0,0x07,0xF0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x77
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0x80,0x1F,0xF8,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x0F,0xE0,0x03,0xC0,0x1F,0xF0,0x01,0x80,0x1F,0xF8,0x00,0x00,0x3F,0xFC,0x00,0x00,0x7E,0x7C,0x00,0x00,0xFE,0x3E,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3E,0x7F,0x00,0x00,0x3F,0x7E,0x00,0x00,0x1F,0xFC,0x00,0x80,0x0F,0xF8,0x01,0xC0,0x07,0xF8,0x03,0xE0,0x07,0xF0,0x07,0xE0,0x03,0xE0,0x07,0xF0,0x01,0xC0,0x0F,0xF8,0x00,0x80,0x1F,0xFC,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x78
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x7C,0xF8,0x00,0x00,0x3C,0xF8,0x01,0x00,0x3E,0xF0,0x01,0x00,0x1E,0xF0,0x03,0x00,0x1F,0xF0,0x03,0x00,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xC0,0x07,0xC0,0x07,0xC0,0x0F,0xC0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x01,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF0,0x00,0x00,0x7E,0xF8,0x00,0x00,0x7E,0x78,0x00,0x00,0x7C,0x7C,0x00,0x00,0xFC,0x3C,0x00,0x00,0xF8,0x3E,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7E,0x00,0x00,0xF8,0x7F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x79
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x1F,0xE0,0xFF,0xFF,0x1F,0xE0,0xFF,0xFF,0x1F,0xE0,0xFF,0xFF,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7A
{0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x07,0x00,0x00,0xFF,0x07,0x00,0x80,0xFF,0x07,0x00,0xC0,0xFF,0x07,0x00,0xC0,0x1F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF8,0x03,0x00,0xC0,0xFF,0x01,0x00,0xC0,0x7F,0x00,0x00,0xC0,0x7F,0x00,0x00,0xC0,0xFF,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0xFF,0x07,0x00,0x80,0xFF,0x07,0x00,0x00,0xFE,0x07,0x00,0x00,0xF8,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7B
{0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7C
{0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xE0,0xFF,0x00,0x00,0xE0,0xFF,0x01,0x00,0xE0,0xFF,0x03,0x00,0x00,0xF8,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x1F,0x00,0x00,0x80,0xFF,0x03,0x00,0x00,0xFE,0x03,0x00,0x00,0xFE,0x03,0x00,0x00,0xFF,0x03,0x00,0x80,0x1F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF8,0x03,0x00,0xE0,0xFF,0x03,0x00,0xE0,0xFF,0x01,0x00,0xE0,0xFF,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0F,0x00,0x00,0xE0,0x3F,0x00,0x3C,0xF0,0xFF,0x00,0x3C,0xF8,0xFF,0x01,0x3C,0x78,0xF8,0x07,0x3E,0x7C,0xE0,0x1F,0x1E,0x3C,0x80,0xFF,0x1F,0x3C,0x00,0xFF,0x0F,0x3C,0x00,0xFC,0x07,0x00,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x7F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0xE0,0xFF,0x3F,0x00,0xF8,0xFF,0x3F,0x00,0xFE,0xFF,0x3F,0x00,0xFF,0x01,0x3E,0x80,0x3F,0x00,0x30,0xC0,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x00,0x80,0x7F,0x00,0x20,0x00,0xFF,0x01,0x3C,0x00,0xFE,0xFF,0x3F,0x00,0xF8,0xFF,0x3F,0x00,0xE0,0xFF,0x1F,0x00,0x00,0xFF,0x01,0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF8,0x00,0x00,0x80,0x7F,0x00,0x00,0x80,0x1F,0x00},   // 0x80
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0xE0,0x0F,0xE0,0x03,0xF0,0x0F,0xE0,0x07,0xF8,0x0F,0xE0,0x0F,0xFE,0x0F,0xC0,0xFF,0xBF,0x0F,0xC0,0xFF,0x9F,0x0F,0x80,0xFF,0x8F,0x0F,0x00,0xFF,0x87,0x0F,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x81
{0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x3F,0xF8,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0x7F,0x80,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xF8,0xFF,0x07,0x00,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x82
{0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0x7C,0x3E,0x00,0x00,0x3C,0x3C,0x00,0x00,0x1E,0x78,0x00,0x00,0x0F,0xF0,0x00,0x80,0x07,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x83
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x84
{0x00,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x85
{0x00,0xC0,0x03,0x00,0x00,0xF0,0x0F,0x00,0x00,0x30,0x0C,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x30,0x0C,0x00,0x00,0xF0,0x0F,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x86
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x7F,0x00,0x00,0xF8,0xFF,0x07,0x00,0xFE,0xFF,0x07,0x00,0xFF,0xFF,0x07,0x80,0x7F,0x80,0x07,0xC0,0x1F,0x00,0x04,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0xFF,0x00,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFC,0xFF,0x0F,0x00,0xF8,0xFF,0x0F,0x00,0xC0,0xFF,0x00,0x00,0x80,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3E,0x00,0x00,0xE0,0x1F,0x00,0x00,0xE0,0x07,0x00},   // 0x87
{0x00,0xC0,0x0F,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF0,0x3F,0x00,0x00,0xF8,0x7C,0x00,0x00,0x78,0x78,0x00,0x00,0x3C,0xF0,0x00,0x00,0x1E,0xE0,0x01,0x00,0x0F,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x3F,0xF8,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0x7F,0x80,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xF8,0xFF,0x07,0x00,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x88
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0xE0,0x01,0x00,0x78,0xE0,0x01,0x00,0x78,0xE0,0x01,0x00,0x78,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x3F,0xF8,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0x7F,0x80,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xF8,0xFF,0x07,0x00,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x89
{0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF8,0x7F,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFF,0xFF,0x01,0x80,0x3F,0xF8,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x1F,0x00,0x08,0x80,0x7F,0x80,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xF8,0xFF,0x07,0x00,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8B
{0x00,0xC0,0x0F,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF0,0x3F,0x00,0x00,0xF8,0x7C,0x00,0x00,0x78,0x78,0x00,0x00,0x3C,0xF0,0x00,0x00,0x1E,0xE0,0x01,0x00,0x0F,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8C
{0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8D
{0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8E
{0x00,0xE0,0x03,0x00,0x00,0xF0,0x07,0x00,0x00,0x30,0x06,0x00,0x00,0x18,0x0C,0x00,0x00,0x18,0x0C,0x00,0x00,0x18,0x0C,0x00,0x00,0x38,0x0E,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x0F,0x00,0x00,0x7C,0x1F,0x00,0x00,0x3C,0x1F,0x00,0x00,0x3C,0x3F,0x00,0x00,0x3E,0x3E,0x00,0x00,0x1E,0x3E,0x00,0x00,0x1F,0x7C,0x00,0x00,0x0F,0x7C,0x00,0x00,0x0F,0xFC,0x00,0x80,0x0F,0xF8,0x00,0x80,0x07,0xF8,0x01,0xC0,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x01,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xE0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x0F,0xF8,0x00,0x80,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x8F
{0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x90
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0xF0,0x01,0xF8,0x7F,0xFC,0x07,0xF8,0xFF,0xFE,0x0F,0xF8,0xFF,0xFF,0x1F,0x18,0xF8,0x0F,0x1F,0x00,0xF0,0x07,0x3E,0x00,0xE0,0x07,0x3C,0x00,0xE0,0x03,0x3C,0x00,0xE0,0x03,0x7C,0x00,0xE0,0x03,0x7C,0x00,0xE0,0x03,0x7C,0x00,0xE0,0x03,0x7C,0x00,0xFF,0xFF,0x7F,0xC0,0xFF,0xFF,0x7F,0xF0,0xFF,0xFF,0x7F,0xF8,0xE1,0xFF,0x7F,0xFC,0xE0,0x03,0x00,0x7C,0xE0,0x03,0x00,0x3E,0xE0,0x03,0x00,0x3E,0xE0,0x03,0x00,0x3E,0xE0,0x03,0x00,0x3E,0xE0,0x07,0x00,0x3E,0xE0,0x07,0x00,0x7E,0xF0,0x0F,0x00,0xFC,0xF8,0x1F,0x70,0xFC,0xFF,0xFF,0x7F,0xF8,0x3F,0xFF,0x7F,0xF0,0x1F,0xFE,0x3F,0xC0,0x07,0xF8,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x91
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x3F,0x00,0xC0,0xFF,0x3F,0x00,0xC0,0xFF,0x3F,0x00,0xE0,0xFF,0x3F,0x00,0xE0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x3C,0x1F,0x00,0x00,0x3C,0x1F,0x00,0x00,0x1E,0x1F,0x00,0x00,0x1E,0x1F,0x00,0x00,0x0F,0x1F,0x00,0x00,0x0F,0xFF,0x0F,0x80,0x07,0xFF,0x0F,0x80,0x07,0xFF,0x0F,0xC0,0x07,0xFF,0x0F,0xC0,0x03,0x1F,0x00,0xC0,0x03,0x1F,0x00,0xE0,0x01,0x1F,0x00,0xE0,0xFF,0x1F,0x00,0xF0,0xFF,0x1F,0x00,0xF0,0xFF,0x1F,0x00,0xF8,0xFF,0x1F,0x00,0x78,0x00,0x1F,0x00,0x7C,0x00,0x1F,0x00,0x3C,0x00,0x1F,0x00,0x3C,0x00,0xFF,0x7F,0x1E,0x00,0xFF,0x7F,0x1E,0x00,0xFF,0x7F,0x1F,0x00,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x92
{0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0x7C,0x3E,0x00,0x00,0x3C,0x3C,0x00,0x00,0x1E,0x78,0x00,0x00,0x0F,0xF0,0x00,0x80,0x07,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x93
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x94
{0x00,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x95
{0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0x7C,0x3E,0x00,0x00,0x3C,0x3C,0x00,0x00,0x1E,0x78,0x00,0x00,0x0F,0xF0,0x00,0x80,0x07,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0xE0,0x0F,0xE0,0x03,0xF0,0x0F,0xE0,0x07,0xF8,0x0F,0xE0,0x0F,0xFE,0x0F,0xC0,0xFF,0xBF,0x0F,0xC0,0xFF,0x9F,0x0F,0x80,0xFF,0x8F,0x0F,0x00,0xFF,0x87,0x0F,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x96
{0x00,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xC0,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0xE0,0x0F,0xE0,0x03,0xF0,0x0F,0xE0,0x07,0xF8,0x0F,0xE0,0x0F,0xFE,0x0F,0xC0,0xFF,0xBF,0x0F,0xC0,0xFF,0x9F,0x0F,0x80,0xFF,0x8F,0x0F,0x00,0xFF,0x87,0x0F,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x97
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x3C,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x7C,0xF8,0x00,0x00,0x3C,0xF8,0x01,0x00,0x3E,0xF0,0x01,0x00,0x1E,0xF0,0x03,0x00,0x1F,0xF0,0x03,0x00,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xC0,0x07,0xC0,0x07,0xC0,0x0F,0xC0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x01,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF0,0x00,0x00,0x7E,0xF8,0x00,0x00,0x7E,0x78,0x00,0x00,0x7C,0x7C,0x00,0x00,0xFC,0x3C,0x00,0x00,0xF8,0x3E,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7E,0x00,0x00,0xF8,0x7F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x98
{0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x99
{0x00,0x0F,0xE0,0x01,0x00,0x0F,0xE0,0x01,0x00,0x0F,0xE0,0x01,0x00,0x0F,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xC0,0x0F,0xE0,0x07,0xC0,0x1F,0xF0,0x07,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9A
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x1E,0x00,0xFE,0x3F,0x0F,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x03,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xF0,0x07,0xF0,0x03,0xF0,0x0F,0xF0,0x01,0xF8,0x0F,0xF0,0x01,0xBC,0x0F,0xF8,0x00,0x1E,0x1F,0xF8,0x00,0x0F,0x1F,0xF8,0x00,0x0F,0x1F,0xF8,0x80,0x07,0x1F,0xF8,0xC0,0x03,0x1F,0xF8,0xE0,0x01,0x1F,0xF8,0xF0,0x00,0x1F,0xF8,0xF0,0x00,0x1F,0xF8,0x78,0x00,0x1F,0xF0,0x3D,0x80,0x0F,0xF0,0x1F,0x80,0x0F,0xF0,0x0F,0xC0,0x0F,0xE0,0x0F,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0xC0,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x00,0xF0,0xFE,0x7F,0x00,0x78,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9B
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x03,0x00,0x00,0xFF,0x07,0x00,0x80,0xFF,0x07,0x00,0xC0,0xFF,0x07,0x00,0xE0,0x07,0x06,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xFF,0x3F,0x00,0x00,0xFF,0x3F,0x00,0x00,0xFF,0x3F,0x00,0x00,0xFF,0x3F,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x3C,0x00,0xFC,0x3F,0x1E,0x00,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x0F,0xC0,0x1F,0xF8,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0xE0,0x0F,0xF0,0x01,0xE0,0x0F,0xF8,0x00,0xF0,0x1F,0xF8,0x00,0x78,0x1F,0xF8,0x00,0x3C,0x1F,0x7C,0x00,0x3C,0x3E,0x7C,0x00,0x1E,0x3E,0x7C,0x00,0x0F,0x3E,0x7C,0x80,0x07,0x3E,0x7C,0x80,0x07,0x3E,0x7C,0xC0,0x03,0x3E,0x7C,0xE0,0x01,0x3E,0x7C,0xE0,0x01,0x3E,0x7C,0xF0,0x00,0x3E,0x7C,0x78,0x00,0x3E,0x7C,0x3C,0x00,0x3E,0xF8,0x3C,0x00,0x1F,0xF8,0x1E,0x00,0x1F,0xF8,0x0F,0x00,0x1F,0xF0,0x07,0x80,0x0F,0xF0,0x07,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x1F,0xF8,0x03,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x00,0x78,0xFC,0x3F,0x00,0x3C,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9D
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x08,0x38,0x00,0x00,0x1C,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x03,0x80,0x0F,0xF0,0x01,0x00,0x1F,0xF8,0x00,0x00,0x3E,0x7C,0x00,0x00,0x7C,0x3E,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0x7C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0xC0,0x07,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x38,0x00,0x00,0x1C,0x10,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0x9E
{0x00,0x00,0xFC,0x07,0x00,0x00,0xFF,0x0F,0x00,0xC0,0xFF,0x0F,0x00,0xC0,0xFF,0x0F,0x00,0xE0,0x07,0x0C,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x80,0xFF,0xFF,0x01,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x06,0xFC,0x00,0x00,0xFE,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFE,0x3F,0x00,0x00,0xFC,0x07,0x00,0x00},   // 0x9F
{0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA0
{0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA1
{0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA2
{0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x03,0xE0,0x0F,0xE0,0x03,0xF0,0x0F,0xE0,0x07,0xF8,0x0F,0xE0,0x0F,0xFE,0x0F,0xC0,0xFF,0xBF,0x0F,0xC0,0xFF,0x9F,0x0F,0x80,0xFF,0x8F,0x0F,0x00,0xFF,0x87,0x0F,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x00,0xFF,0xF3,0x00,0x80,0xE7,0x7F,0x00,0x80,0x83,0x7F,0x00,0x80,0x03,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x7F,0x00,0xE0,0xC3,0xFF,0x01,0xE0,0xE3,0xFF,0x03,0xE0,0xF3,0xFF,0x07,0xE0,0xFB,0xFF,0x07,0xE0,0xFF,0xE0,0x0F,0xE0,0x3F,0xC0,0x0F,0xE0,0x1F,0x80,0x0F,0xE0,0x0F,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA4
{0x00,0x3C,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x00,0xFF,0xF3,0x00,0x80,0xE7,0x7F,0x00,0x80,0x83,0x7F,0x00,0x80,0x03,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x0F,0xF0,0x03,0x00,0x0F,0xF0,0x03,0x00,0x0F,0xF0,0x07,0x00,0x0F,0xF0,0x07,0x00,0x0F,0xF0,0x0F,0x00,0x0F,0xF0,0x1F,0x00,0x0F,0xF0,0x1F,0x00,0x0F,0xF0,0x3F,0x00,0x0F,0xF0,0x7E,0x00,0x0F,0xF0,0x7E,0x00,0x0F,0xF0,0xFC,0x00,0x0F,0xF0,0xF8,0x01,0x0F,0xF0,0xF8,0x01,0x0F,0xF0,0xF0,0x03,0x0F,0xF0,0xE0,0x03,0x0F,0xF0,0xE0,0x07,0x0F,0xF0,0xC0,0x0F,0x0F,0xF0,0xC0,0x0F,0x0F,0xF0,0x80,0x1F,0x0F,0xF0,0x00,0x3F,0x0F,0xF0,0x00,0x3F,0x0F,0xF0,0x00,0x7E,0x0F,0xF0,0x00,0x7C,0x0F,0xF0,0x00,0xFC,0x0F,0xF0,0x00,0xF8,0x0F,0xF0,0x00,0xF8,0x0F,0xF0,0x00,0xF0,0x0F,0xF0,0x00,0xE0,0x0F,0xF0,0x00,0xE0,0x0F,0xF0,0x00,0xC0,0x0F,0xF0,0x00,0x80,0x0F,0xF0,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0x00,0x80,0xFF,0x1F,0x00,0x80,0xFF,0x3F,0x00,0x80,0x07,0x7E,0x00,0x80,0x01,0x7C,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,0xF0,0x7F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0x7F,0x00,0x80,0x1F,0x78,0x00,0xC0,0x07,0x78,0x00,0xC0,0x03,0x78,0x00,0xC0,0x03,0x78,0x00,0xC0,0x03,0x7C,0x00,0xC0,0x07,0xFF,0x00,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xF1,0x03,0x00,0x7E,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0x1F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xE0,0x01,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x80,0x07,0xE0,0x01,0x80,0x0F,0xF0,0x01,0x00,0x1F,0xF8,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0x80,0x3F,0x00,0x00,0x80,0x3F,0x00,0x00,0x80,0x3F,0x00,0x00,0x80,0x3F,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0x7C,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x0F,0xF0,0x01,0x00,0x0F,0xF0,0x03,0x00,0x0F,0xF0,0x07,0x00,0x0F,0xE0,0x1F,0x80,0x0F,0xC0,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xF0,0xFF,0x00,0x00,0x00,0x00,0x00},   // 0xA8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0xFE,0x1F,0x00,0x00,0x0F,0x3C,0x00,0x80,0x03,0x70,0x00,0xC0,0xF9,0xE3,0x00,0xE0,0xF8,0xC7,0x01,0x60,0x18,0x8E,0x01,0x60,0x18,0x8C,0x01,0x30,0x18,0x0C,0x03,0x30,0x18,0x0E,0x03,0x30,0xF8,0x07,0x03,0x30,0xF8,0x03,0x03,0x30,0x98,0x03,0x03,0x30,0x18,0x07,0x03,0x60,0x18,0x87,0x01,0x60,0x18,0x8E,0x01,0xE0,0x18,0xCE,0x01,0xC0,0x19,0xFC,0x00,0x80,0x03,0x70,0x00,0x00,0x0F,0x3C,0x00,0x00,0xFE,0x1F,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xA9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xE0,0x01,0xFF,0x01,0xF0,0x00,0xFF,0x01,0xF0,0x00,0xFF,0x01,0x78,0x00,0xF0,0x01,0x78,0x00,0xF0,0x01,0x3C,0x00,0xF0,0x01,0x3C,0x00,0xF0,0x01,0x1E,0x00,0xF0,0x01,0x1E,0x00,0xF0,0x01,0x0F,0x00,0xF0,0x81,0x07,0x00,0xF0,0x81,0x07,0x00,0xF0,0xC1,0x03,0x00,0xF0,0xC1,0x03,0x00,0xF0,0xE1,0x01,0x00,0xF0,0xE1,0x01,0x00,0xF0,0xF1,0x00,0x00,0xF0,0xF1,0x00,0x00,0xF0,0x79,0x00,0x00,0xF0,0x79,0xF8,0x07,0x00,0x3C,0xFE,0x1F,0x00,0x3C,0xFE,0x3F,0x00,0x1E,0x06,0x7E,0x00,0x1E,0x00,0x7C,0x00,0x0F,0x00,0x7C,0x00,0x0F,0x00,0x7C,0x80,0x07,0x00,0x7E,0x80,0x07,0x00,0x3F,0xC0,0x03,0x80,0x1F,0xC0,0x03,0xC0,0x0F,0xE0,0x01,0xE0,0x03,0xF0,0x00,0xF0,0x01,0xF0,0x00,0x78,0x00,0x78,0x00,0x3C,0x00,0x78,0x00,0x3E,0x00,0x3C,0x00,0xFE,0x7F,0x3C,0x00,0xFE,0x7F,0x1E,0x00,0xFE,0x7F,0x1E,0x00,0xFE,0x7F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xC0,0x03,0xFF,0x01,0xE0,0x01,0xFF,0x01,0xE0,0x01,0xFF,0x01,0xF0,0x00,0xF0,0x01,0xF0,0x00,0xF0,0x01,0x78,0x00,0xF0,0x01,0x78,0x00,0xF0,0x01,0x3C,0x00,0xF0,0x01,0x3C,0x00,0xF0,0x01,0x1E,0x00,0xF0,0x01,0x0F,0x00,0xF0,0x01,0x0F,0x00,0xF0,0x81,0x07,0x00,0xF0,0x81,0x07,0x00,0xF0,0xC1,0x03,0x00,0xF0,0xC1,0x03,0x00,0xF0,0xE1,0x01,0x00,0xF0,0xE1,0x01,0x00,0xF0,0xF1,0x00,0x00,0xF0,0xF1,0xC0,0x0F,0x00,0x78,0xE0,0x0F,0x00,0x78,0xE0,0x0F,0x00,0x3C,0xF0,0x0F,0x00,0x3C,0xB8,0x0F,0x00,0x1E,0x9C,0x0F,0x00,0x1E,0x8E,0x0F,0x00,0x0F,0x87,0x0F,0x00,0x8F,0x87,0x0F,0x80,0x87,0x83,0x0F,0x80,0xC7,0x81,0x0F,0xC0,0xE3,0x80,0x0F,0xE0,0xE1,0xFF,0x7F,0xE0,0xE1,0xFF,0x7F,0xF0,0xE0,0xFF,0x7F,0xF0,0x00,0x80,0x0F,0x78,0x00,0x80,0x0F,0x78,0x00,0x80,0x0F,0x3C,0x00,0x80,0x0F,0x3C,0x00,0x80,0x0F,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00},   // 0xAD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x02,0x00,0xE0,0x00,0x07,0x00,0xF0,0x81,0x0F,0x00,0xF8,0xC0,0x07,0x00,0x7C,0xE0,0x03,0x00,0x3E,0xF0,0x01,0x00,0x1F,0xF8,0x00,0x80,0x0F,0x7C,0x00,0xC0,0x07,0x3E,0x00,0xE0,0x03,0x1F,0x00,0xF0,0x81,0x0F,0x00,0xF0,0x80,0x07,0x00,0xF8,0xC0,0x07,0x00,0xF0,0x81,0x0F,0x00,0xE0,0x03,0x1F,0x00,0xC0,0x07,0x3E,0x00,0x80,0x0F,0x7C,0x00,0x00,0x1F,0xF8,0x00,0x00,0x3E,0xF0,0x01,0x00,0x7C,0xE0,0x03,0x00,0xF8,0xC0,0x07,0x00,0xF0,0x81,0x0F,0x00,0xE0,0x00,0x07,0x00,0x40,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x02,0x00,0xE0,0x00,0x07,0x00,0xF0,0x81,0x0F,0x00,0xE0,0x03,0x1F,0x00,0xC0,0x07,0x3E,0x00,0x80,0x0F,0x7C,0x00,0x00,0x1F,0xF8,0x00,0x00,0x3E,0xF0,0x01,0x00,0x7C,0xE0,0x03,0x00,0xF8,0xC0,0x07,0x00,0xF0,0x81,0x0F,0x00,0xE0,0x03,0x1F,0x00,0xE0,0x01,0x0F,0x00,0xF0,0x80,0x07,0x00,0xF8,0xC0,0x07,0x00,0x7C,0xE0,0x03,0x00,0x3E,0xF0,0x01,0x00,0x1F,0xF8,0x00,0x80,0x0F,0x7C,0x00,0xC0,0x07,0x3E,0x00,0xE0,0x03,0x1F,0x00,0xF0,0x81,0x0F,0x00,0xE0,0x00,0x07,0x00,0x40,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xAF
{0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB0
{0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x00,0x00,0x00,0x00,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03},   // 0xB1
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03,0x1F,0xF8,0xE0,0x03},   // 0xB2
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xB3
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xB4
{0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB5
{0x00,0xF0,0x1F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xFC,0x7E,0x00,0x00,0x7E,0xFC,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB6
{0x00,0x3F,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF0,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1F,0x00,0x00,0xFC,0x7F,0x00,0x00,0xFF,0xFF,0x01,0x80,0x1F,0xF0,0x03,0xC0,0x07,0xC0,0x07,0xE0,0x01,0x00,0x0F,0xE0,0x00,0x00,0x0E,0xF0,0x00,0x00,0x1E,0x70,0x00,0x00,0x1C,0x78,0xC0,0x3F,0x3C,0x38,0xF0,0xFF,0x38,0x38,0xFC,0xFF,0x38,0x38,0x7E,0xE0,0x38,0x3C,0x1E,0x00,0x78,0x1C,0x0F,0x00,0x70,0x1C,0x0F,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x07,0x00,0x70,0x9C,0x0F,0x00,0x70,0x1C,0x0F,0x00,0x70,0x1C,0x1F,0x00,0x70,0x3C,0x3E,0x00,0x78,0x38,0x7E,0xE0,0x38,0x38,0xFC,0xFF,0x38,0x38,0xF0,0xFF,0x38,0x78,0xC0,0x1F,0x3C,0x70,0x00,0x00,0x1C,0xF0,0x00,0x00,0x1E,0xE0,0x00,0x00,0x0E,0xE0,0x01,0x00,0x0F,0xC0,0x07,0xC0,0x07,0x80,0x1F,0xF0,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xB8
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xB9
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xBA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x3F,0x00,0xFF,0xFF,0x3F,0x00,0xFF,0xFF,0x3F,0x00,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xBB
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0xFF,0x3F,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0xFF,0xFF,0x3F,0x00,0xFF,0xFF,0x3F,0x00,0xFF,0xFF,0x3F,0x00,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0xC0,0x3F,0x00,0x00,0xF0,0xFF,0x03,0x00,0xFC,0xFF,0x03,0x00,0xFE,0xFF,0x03,0x00,0x7F,0xC7,0x03,0x80,0x1F,0x07,0x02,0x80,0x0F,0x07,0x00,0xC0,0x07,0x07,0x00,0xC0,0x07,0x07,0x00,0xC0,0x07,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xE0,0x03,0x07,0x00,0xC0,0x07,0x07,0x00,0xC0,0x07,0x07,0x00,0xC0,0x0F,0x07,0x00,0x80,0x1F,0x07,0x00,0x80,0x3F,0x07,0x02,0x00,0xFF,0xC7,0x03,0x00,0xFE,0xFF,0x03,0x00,0xFC,0xFF,0x03,0x00,0xF8,0xFF,0x01,0x00,0xC0,0x3F,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7C,0xFC,0x00,0x00,0x3C,0xF8,0x01,0x00,0x1E,0xF8,0x01,0x00,0x1F,0xF0,0x03,0x00,0x0F,0xF0,0x07,0x80,0x07,0xE0,0x07,0xC0,0x07,0xC0,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x01,0x80,0x1F,0xF0,0x01,0x00,0x3F,0xF8,0x00,0x00,0x3F,0x78,0x00,0x00,0x7E,0x7C,0x00,0x00,0xFE,0x3E,0x00,0x00,0xFC,0x1E,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x07,0x00,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xBE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xBF
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC0
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xC2
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xC3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC4
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xC5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x00,0xFF,0xF3,0x00,0x80,0xE7,0x7F,0x00,0x80,0x83,0x7F,0x00,0x80,0x03,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0x00,0x80,0xFF,0x3F,0x00,0xE0,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0x00,0xE0,0x03,0xFE,0x00,0x60,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0xF0,0xFF,0x01,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF0,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x01,0xF0,0x01,0xF0,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xFC,0x01,0xF0,0x03,0xFF,0x03,0xF0,0xFF,0xEF,0x3F,0xE0,0xFF,0xE7,0x3F,0xC0,0xFF,0xC1,0x3F,0x00,0x7F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC6
{0x00,0x3C,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x00,0xFF,0xF3,0x00,0x80,0xE7,0x7F,0x00,0x80,0x83,0x7F,0x00,0x80,0x03,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x78,0x1F,0x00,0x00,0x78,0x1F,0x00,0x00,0x7C,0x3F,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3C,0x3E,0x00,0x00,0x3E,0x7C,0x00,0x00,0x1E,0x7C,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,0xF8,0x00,0x00,0x0F,0xF8,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xF0,0x01,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x07,0xE0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x0F,0xF0,0xFF,0xFF,0x0F,0xF8,0xFF,0xFF,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3F,0x7C,0x00,0x00,0x3E,0x7E,0x00,0x00,0x7E,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3F,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC7
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x00,0xFC,0xFF,0xFF,0x00,0xFC,0xFF,0xFF,0x00,0xFC,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xC8
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x00,0xFC,0xFF,0xFF,0x00,0xFC,0xFF,0xFF,0x00,0xFC,0xFF,0xFF,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xC9
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xCB
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0xFC,0xFF,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xCC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCD
{0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00,0x00,0x3C,0x3C,0x00},   // 0xCE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x70,0x00,0x00,0x0C,0xF8,0x00,0x00,0x1E,0xF0,0xE1,0x07,0x0F,0xE0,0xFB,0x9F,0x07,0xC0,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0x01,0x00,0x3F,0xFC,0x00,0x80,0x0F,0xF0,0x01,0x80,0x07,0xE0,0x01,0xC0,0x07,0xE0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x07,0xE0,0x03,0x80,0x07,0xE0,0x01,0x80,0x0F,0xF0,0x01,0x00,0x3F,0xFC,0x00,0x80,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x03,0xE0,0xF9,0x9F,0x07,0xF0,0xE0,0x07,0x0F,0x78,0x00,0x00,0x1E,0x30,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xCF
{0x00,0x00,0x00,0x00,0xF8,0x01,0x08,0x00,0xF8,0x0F,0x0E,0x00,0xF8,0x3F,0x1F,0x00,0xF8,0xFF,0x0F,0x00,0x80,0xFF,0x07,0x00,0x00,0xFC,0x03,0x00,0x00,0xFC,0x0F,0x00,0x00,0xFE,0x1F,0x00,0x80,0x9F,0x3F,0x00,0xC0,0x07,0x7F,0x00,0x80,0x03,0xFE,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF8,0x01,0x00,0xF0,0xFF,0x03,0x00,0xFC,0xFF,0x03,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x07,0xC0,0x1F,0xF8,0x07,0xE0,0x07,0xE0,0x0F,0xE0,0x03,0xC0,0x0F,0xF0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x1F,0xF0,0x01,0x80,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x07,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0x00,0xF8,0xFF,0x1F,0x00,0xF8,0xFF,0x7F,0x00,0xF8,0xFF,0xFF,0x00,0xF8,0x00,0xFE,0x01,0xF8,0x00,0xF8,0x03,0xF8,0x00,0xE0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xFF,0x3F,0x00,0x1F,0xFF,0x3F,0x00,0x1F,0xFF,0x3F,0x00,0x1F,0xFF,0x3F,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0x80,0x0F,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xE0,0x03,0xF8,0x00,0xF8,0x03,0xF8,0x00,0xFF,0x01,0xF8,0xFF,0xFF,0x00,0xF8,0xFF,0x7F,0x00,0xF8,0xFF,0x1F,0x00,0xF8,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD1
{0x00,0xC0,0x7F,0x00,0x00,0xE0,0xFF,0x00,0x00,0xF0,0xFB,0x01,0x00,0xF8,0xF1,0x03,0x00,0x7C,0xC0,0x07,0x00,0x3E,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD2
{0x00,0x0F,0xE0,0x01,0x00,0x0F,0xE0,0x01,0x00,0x0F,0xE0,0x01,0x00,0x0F,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD3
{0x00,0xFC,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0xFF,0xFF,0x1F,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0xE0,0xFF,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD5
{0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD6
{0x00,0xF0,0x1F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xFC,0x7E,0x00,0x00,0x7E,0xFC,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD7
{0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD8
{0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xD9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0xFF,0xFF,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00},   // 0xDA
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},   // 0xDB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},   // 0xDC
{0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDD
{0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0xF0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDE
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xDF
{0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE0
{0x00,0xFC,0x03,0x00,0x00,0xFF,0x1F,0x00,0xC0,0xFF,0x3F,0x00,0xC0,0xFF,0x7F,0x00,0xE0,0x07,0xFE,0x00,0xE0,0x03,0xFC,0x00,0xF0,0x03,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0xF8,0x00,0xF0,0x01,0x78,0x00,0xF0,0x01,0x7C,0x00,0xF0,0x01,0x3C,0x00,0xF0,0x01,0x3E,0x00,0xF0,0x01,0x1F,0x00,0xF0,0x01,0x0F,0x00,0xF0,0x81,0x0F,0x00,0xF0,0x81,0x07,0x00,0xF0,0xC1,0x07,0x00,0xF0,0xC1,0x07,0x00,0xF0,0xC1,0x0F,0x00,0xF0,0xC1,0x1F,0x00,0xF0,0x81,0x3F,0x00,0xF0,0x81,0x7F,0x00,0xF0,0x01,0xFF,0x00,0xF0,0x01,0xFE,0x01,0xF0,0x01,0xFC,0x03,0xF0,0x01,0xF8,0x07,0xF0,0x01,0xF0,0x0F,0xF0,0x01,0xE0,0x1F,0xF0,0x01,0x80,0x1F,0xF0,0x01,0x00,0x3F,0xF0,0x01,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF0,0x01,0x00,0x3E,0xF0,0x01,0x00,0x3E,0xF0,0x01,0x00,0x3E,0xF0,0x21,0x00,0x3F,0xF0,0xE1,0x81,0x1F,0xF0,0xE1,0xFF,0x1F,0xF0,0xE1,0xFF,0x0F,0xF0,0xE1,0xFF,0x03,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE1
{0x00,0xF0,0x1F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xFC,0x7E,0x00,0x00,0x7E,0xFC,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE2
{0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x00,0xFF,0xF3,0x00,0x80,0xE7,0x7F,0x00,0x80,0x83,0x7F,0x00,0x80,0x03,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE4
{0x00,0x3C,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x00,0xFF,0xF3,0x00,0x80,0xE7,0x7F,0x00,0x80,0x83,0x7F,0x00,0x80,0x03,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFF,0xFF,0x00,0x80,0xFF,0xFF,0x01,0xC0,0x1F,0xF8,0x03,0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x07,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0x7C,0x00,0x00,0x3E,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x1F,0xF8,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFC,0x3F,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xE0,0x07,0xC0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x1F,0xF0,0x0F,0xE0,0x3F,0xF8,0x0F,0xE0,0xFF,0xBF,0x0F,0xE0,0xFF,0xBF,0x1F,0xE0,0xFB,0x1F,0x1F,0xE0,0xF3,0x0F,0x1F,0xE0,0xC3,0x07,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00},   // 0xE6
{0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x3F,0x00,0xE0,0xC3,0xFF,0x00,0xE0,0xE3,0xFF,0x01,0xE0,0xF3,0xFF,0x03,0xE0,0xFB,0xF0,0x07,0xE0,0x3F,0xC0,0x07,0xE0,0x0F,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x0F,0xE0,0x07,0xC0,0x07,0xE0,0x1F,0xE0,0x07,0xE0,0x3F,0xF8,0x03,0xE0,0xFF,0xFF,0x01,0xE0,0xFB,0xFF,0x00,0xE0,0xF3,0x7F,0x00,0xE0,0xC3,0x1F,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0xFF,0x7F,0x00,0xC0,0xFF,0xFF,0x03,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x0F,0xC0,0x07,0xE0,0x1F,0xC0,0x07,0x80,0x1F,0xC0,0x07,0x00,0x3F,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x3E,0xC0,0x07,0x00,0x1F,0xC0,0x07,0x80,0x1F,0xC0,0x07,0xC0,0x1F,0xC0,0x07,0xF8,0x0F,0xC0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x01,0xC0,0xFF,0x7F,0x00,0xC0,0xFF,0x0F,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE8
{0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xC0,0x0F,0xE0,0x07,0xC0,0x1F,0xF0,0x07,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xE9
{0x00,0xF0,0x1F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xFC,0x7E,0x00,0x00,0x7E,0xFC,0x00,0x00,0x1F,0xF0,0x01,0x80,0x0F,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xC0,0x0F,0xE0,0x07,0xC0,0x1F,0xF0,0x07,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEA
{0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xE0,0x03,0x00,0x00,0xC0,0x07,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xC0,0x0F,0xE0,0x07,0xC0,0x1F,0xF0,0x07,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEB
{0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x0F,0x00,0x00,0x80,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x7C,0xF8,0x00,0x00,0x3C,0xF8,0x01,0x00,0x3E,0xF0,0x01,0x00,0x1E,0xF0,0x03,0x00,0x1F,0xF0,0x03,0x00,0x0F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xC0,0x07,0xC0,0x07,0xC0,0x0F,0xC0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x1F,0xE0,0x01,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF0,0x00,0x00,0x7E,0xF8,0x00,0x00,0x7E,0x78,0x00,0x00,0x7C,0x7C,0x00,0x00,0xFC,0x3C,0x00,0x00,0xF8,0x3E,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x7E,0x00,0x00,0xF8,0x7F,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEC
{0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0xF8,0xFC,0x00,0x00,0x7C,0xF8,0x01,0x00,0x3E,0xF8,0x01,0x00,0x3E,0xF0,0x03,0x00,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x07,0x80,0x0F,0xC0,0x0F,0xC0,0x07,0x80,0x0F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF8,0x00,0x00,0x7E,0xF8,0x00,0x00,0xFC,0x7C,0x00,0x00,0xF8,0x3E,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xED
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEE
{0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xEF
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF0
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF1
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},   // 0xF2
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0x00,0xF8,0xFE,0x1F,0x00,0x7C,0xFE,0x3F,0x00,0x3E,0x06,0x7E,0x00,0x3E,0x00,0x7C,0x00,0x1F,0x00,0x7C,0x80,0x0F,0x00,0x3C,0x80,0x0F,0x00,0x3F,0xC0,0x07,0xF8,0x0F,0xE0,0x03,0xF8,0x03,0xE0,0x03,0xF8,0x0F,0xF0,0x01,0x80,0x3F,0xF0,0x01,0x00,0x3E,0xF8,0x00,0x00,0x7C,0x7C,0x00,0x00,0x7C,0x7C,0x00,0x00,0x7C,0x3E,0x00,0x06,0x7E,0x1F,0x00,0xFE,0x3F,0x1F,0x00,0xFE,0x9F,0x0F,0x00,0xFC,0xC3,0x87,0x1F,0x00,0xC0,0xC7,0x1F,0x00,0xE0,0xC3,0x1F,0x00,0xF0,0xE1,0x1F,0x00,0xF0,0x71,0x1F,0x00,0xF8,0x38,0x1F,0x00,0x7C,0x1C,0x1F,0x00,0x7C,0x0E,0x1F,0x00,0x3E,0x0F,0x1F,0x00,0x9F,0x07,0x1F,0x00,0x9F,0x03,0x1F,0x80,0xCF,0x01,0x1F,0x80,0xCF,0xFF,0xFF,0xC0,0xC7,0xFF,0xFF,0xE0,0xC3,0xFF,0xFF,0xE0,0x03,0x00,0x1F,0xF0,0x01,0x00,0x1F,0xF8,0x00,0x00,0x1F,0xF8,0x00,0x00,0x1F,0x7C,0x00,0x00,0x1F,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x03,0xC0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x03,0xF0,0xFF,0x80,0x03,0xF0,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF8,0xFF,0x80,0x03,0xF0,0xFF,0x80,0x03,0xF0,0xFF,0x80,0x03,0xE0,0xFF,0x80,0x03,0xC0,0xFF,0x80,0x03,0x80,0xFF,0x80,0x03,0x00,0xFE,0x80,0x03,0x00,0xF8,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0xE0,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF4
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x7F,0x00,0x00,0xF8,0xFF,0x03,0x00,0xFE,0xFF,0x03,0x00,0xFF,0xFF,0x03,0x80,0x3F,0xC0,0x03,0x80,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x0F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0xFF,0x01,0x00,0x00,0xFE,0x07,0x00,0x00,0xFC,0x1F,0x00,0x00,0xFE,0x7F,0x00,0x00,0xCF,0xFF,0x00,0x80,0x0F,0xFF,0x01,0x80,0x07,0xFC,0x03,0xC0,0x07,0xF0,0x03,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x0F,0xC0,0x07,0x80,0x1F,0xC0,0x07,0x80,0x7F,0xC0,0x03,0x00,0xFF,0xE0,0x03,0x00,0xFE,0xE3,0x01,0x00,0xFC,0xFF,0x00,0x00,0xF0,0x7F,0x00,0x00,0xE0,0x7F,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0xF8,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x40,0x00,0xC0,0x07,0xC0,0x01,0xE0,0x03,0xC0,0x0F,0xF8,0x03,0xC0,0xFF,0xFF,0x01,0xC0,0xFF,0xFF,0x00,0x00,0xFF,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF5
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x1F,0xFC,0xFF,0xFF,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF6
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,0x00,0xC0,0x01,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3E,0x00,0x00,0xE0,0x1F,0x00,0x00,0xE0,0x07,0x00},   // 0xF7
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x07,0x00,0x00,0x38,0x0E,0x00,0x00,0x1C,0x1C,0x00,0x00,0x0C,0x18,0x00,0x00,0x0C,0x18,0x00,0x00,0x0C,0x18,0x00,0x00,0x1C,0x1C,0x00,0x00,0x38,0x0E,0x00,0x00,0xF0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF8
{0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x80,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xF9
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFA
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0x00,0xFE,0x07,0x00,0x00,0xFE,0x07,0x00,0x00,0xFE,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFB
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1F,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x0F,0xF8,0x01,0x00,0x01,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xFE,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF8,0x0F,0x00,0x00,0xF8,0x3F,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x0F,0xFC,0x01,0x00,0xFF,0xFF,0x00,0x00,0xFF,0x7F,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFC
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFF,0x7F,0x00,0x00,0xFF,0xFF,0x00,0x00,0x0F,0xFC,0x01,0x00,0x01,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x80,0x3F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF0,0x03,0x00,0x00,0xFC,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFD
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},   // 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 0xFF
};
#endif

#ifdef USE_FONT_4X6
   const UG_FONT FONT_4X6 = {(unsigned char*)font_4x6,FONT_TYPE_1BPP,4,6,0,255,NULL};
#endif
#ifdef USE_FONT_5X8
   const UG_FONT FONT_5X8 = {(unsigned char*)font_5x8,FONT_TYPE_1BPP,5,8,0,255,NULL};
#endif
#ifdef USE_FONT_5X12
   const UG_FONT FONT_5X12 = {(unsigned char*)font_5x12,FONT_TYPE_1BPP,5,12,0,255,NULL};
#endif
#ifdef USE_FONT_6X8
   const UG_FONT FONT_6X8 = {(unsigned char*)font_6x8,FONT_TYPE_1BPP,6,8,0,255,NULL};
#endif
#ifdef USE_FONT_6X10
   const UG_FONT FONT_6X10 = {(unsigned char*)font_6x10,FONT_TYPE_1BPP,6,10,0,255,NULL};
#endif
#ifdef USE_FONT_7X12
   const UG_FONT FONT_7X12 = {(unsigned char*)font_7x12,FONT_TYPE_1BPP,7,12,0,255,NULL};
#endif
#ifdef USE_FONT_8X8
   const UG_FONT FONT_8X8 = {(unsigned char*)font_8x8,FONT_TYPE_1BPP,8,8,0,255,NULL};
#endif
#ifdef USE_FONT_8X12
   const UG_FONT FONT_8X12 = {(unsigned char*)font_8x12,FONT_TYPE_1BPP,8,12,0,255,NULL};
#endif
#ifdef USE_FONT_8X12_CYRILLIC
   const UG_FONT FONT_8X12 = {(unsigned char*)font_8x12,FONT_TYPE_1BPP,8,12,0,255,NULL};
#endif
#ifdef USE_FONT_8X14
   const UG_FONT FONT_8X14 = {(unsigned char*)font_8x14,FONT_TYPE_1BPP,8,14,0,255,NULL};
#endif
#ifdef USE_FONT_10X16
   const UG_FONT FONT_10X16 = {(unsigned char*)font_10x16,FONT_TYPE_1BPP,10,16,0,255,NULL};
#endif
#ifdef USE_FONT_12X16
   const UG_FONT FONT_12X16 = {(unsigned char*)font_12x16,FONT_TYPE_1BPP,12,16,0,255,NULL};
#endif
#ifdef USE_FONT_12X20
   const UG_FONT FONT_12X20 = {(unsigned char*)font_12x20,FONT_TYPE_1BPP,12,20,0,255,NULL};
#endif
#ifdef USE_FONT_16X26
   const UG_FONT FONT_16X26 = {(unsigned char*)font_16x26,FONT_TYPE_1BPP,16,26,0,255,NULL};
#endif
#ifdef USE_FONT_22X36
   const UG_FONT FONT_22X36 = {(unsigned char*)font_22x36,FONT_TYPE_1BPP,22,36,0,255,NULL};
#endif
#ifdef USE_FONT_24X40
   const UG_FONT FONT_24X40 = {(unsigned char*)font_24x40,FONT_TYPE_1BPP,24,40,0,255,NULL};
#endif
#ifdef USE_FONT_32X53
   const UG_FONT FONT_32X53 = {(unsigned char*)font_32x53,FONT_TYPE_1BPP,32,53,0,255,NULL};
#endif



UG_S16 UG_Init( UG_GUI* g, void (*p)(UG_S16,UG_S16,UG_COLOR), UG_S16 x, UG_S16 y )
{
   UG_U8 i;

   g->pset = (void(*)(UG_S16,UG_S16,UG_COLOR))p;
   g->x_dim = x;
   g->y_dim = y;
   g->console.x_start = 4;
   g->console.y_start = 4;
   g->console.x_end = g->x_dim - g->console.x_start-1;
   g->console.y_end = g->y_dim - g->console.x_start-1;
   g->console.x_pos = g->console.x_end;
   g->console.y_pos = g->console.y_end;
   g->char_h_space = 1;
   g->char_v_space = 1;
   g->font.p = NULL;
   g->font.char_height = 0;
   g->font.char_width = 0;
   g->font.start_char = 0;
   g->font.end_char = 0;
   g->font.widths = NULL;
   #ifdef USE_COLOR_RGB888
   g->desktop_color = 0x5E8BEf;
   #endif
   #ifdef USE_COLOR_RGB565
   g->desktop_color = 0x5C5D;
   #endif
   g->fore_color = C_WHITE;
   g->back_color = C_BLACK;
   g->next_window = NULL;
   g->active_window = NULL;
   g->last_window = NULL;

   /* Clear drivers */
   for(i=0;i<NUMBER_OF_DRIVERS;i++)
   {
      g->driver[i].driver = NULL;
      g->driver[i].state = 0;
   }

   gui = g;
   return 1;
}

UG_S16 UG_SelectGUI( UG_GUI* g )
{
   gui = g;
   return 1;
}

void UG_FontSelect( const UG_FONT* font )
{
   gui->font = *font;
}

void UG_FillScreen( UG_COLOR c )
{
   UG_FillFrame(0,0,gui->x_dim-1,gui->y_dim-1,c);
}

void UG_FillFrame( UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_COLOR c )
{
   UG_S16 n,m;

   if ( x2 < x1 )
   {
      n = x2;
      x2 = x1;
      x1 = n;
   }
   if ( y2 < y1 )
   {
      n = y2;
      y2 = y1;
      y1 = n;
   }

   /* Is hardware acceleration available? */
   if ( gui->driver[DRIVER_FILL_FRAME].state & DRIVER_ENABLED )
   {
      if( ((UG_RESULT(*)(UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_COLOR c))gui->driver[DRIVER_FILL_FRAME].driver)(x1,y1,x2,y2,c) == UG_RESULT_OK ) return;
   }

   for( m=y1; m<=y2; m++ )
   {
      for( n=x1; n<=x2; n++ )
      {
         gui->pset(n,m,c);
      }
   }
}

void UG_FillRoundFrame( UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_S16 r, UG_COLOR c )
{
   UG_S16  x,y,xd;

   if ( x2 < x1 )
   {
      x = x2;
      x2 = x1;
      x1 = x;
   }
   if ( y2 < y1 )
   {
      y = y2;
      y2 = y1;
      y1 = y;
   }

   if ( r<=0 ) return;

   xd = 3 - (r << 1);
   x = 0;
   y = r;

   UG_FillFrame(x1 + r, y1, x2 - r, y2, c);

   while ( x <= y )
   {
     if( y > 0 )
     {
        UG_DrawLine(x2 + x - r, y1 - y + r, x2+ x - r, y + y2 - r, c);
        UG_DrawLine(x1 - x + r, y1 - y + r, x1- x + r, y + y2 - r, c);
     }
     if( x > 0 )
     {
        UG_DrawLine(x1 - y + r, y1 - x + r, x1 - y + r, x + y2 - r, c);
        UG_DrawLine(x2 + y - r, y1 - x + r, x2 + y - r, x + y2 - r, c);
     }
     if ( xd < 0 )
     {
        xd += (x << 2) + 6;
     }
     else
     {
        xd += ((x - y) << 2) + 10;
        y--;
     }
     x++;
   }
}

void UG_DrawMesh( UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_COLOR c )
{
   UG_S16 n,m;

   if ( x2 < x1 )
   {
      n = x2;
      x2 = x1;
      x1 = n;
   }
   if ( y2 < y1 )
   {
      n = y2;
      y2 = y1;
      y1 = n;
   }

   for( m=y1; m<=y2; m+=2 )
   {
      for( n=x1; n<=x2; n+=2 )
      {
         gui->pset(n,m,c);
      }
   }
}

void UG_DrawFrame( UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_COLOR c )
{
   UG_DrawLine(x1,y1,x2,y1,c);
   UG_DrawLine(x1,y2,x2,y2,c);
   UG_DrawLine(x1,y1,x1,y2,c);
   UG_DrawLine(x2,y1,x2,y2,c);
}

void UG_DrawRoundFrame( UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_S16 r, UG_COLOR c )
{
   UG_S16 n;
   if ( x2 < x1 )
   {
      n = x2;
      x2 = x1;
      x1 = n;
   }
   if ( y2 < y1 )
   {
      n = y2;
      y2 = y1;
      y1 = n;
   }

   if ( r > x2 ) return;
   if ( r > y2 ) return;

   UG_DrawLine(x1+r, y1, x2-r, y1, c);
   UG_DrawLine(x1+r, y2, x2-r, y2, c);
   UG_DrawLine(x1, y1+r, x1, y2-r, c);
   UG_DrawLine(x2, y1+r, x2, y2-r, c);
   UG_DrawArc(x1+r, y1+r, r, 0x0C, c);
   UG_DrawArc(x2-r, y1+r, r, 0x03, c);
   UG_DrawArc(x1+r, y2-r, r, 0x30, c);
   UG_DrawArc(x2-r, y2-r, r, 0xC0, c);
}

void UG_DrawPixel( UG_S16 x0, UG_S16 y0, UG_COLOR c )
{
   gui->pset(x0,y0,c);
}

void UG_DrawCircle( UG_S16 x0, UG_S16 y0, UG_S16 r, UG_COLOR c )
{
   UG_S16 x,y,xd,yd,e;

   if ( x0<0 ) return;
   if ( y0<0 ) return;
   if ( r<=0 ) return;

   xd = 1 - (r << 1);
   yd = 0;
   e = 0;
   x = r;
   y = 0;

   while ( x >= y )
   {
      gui->pset(x0 - x, y0 + y, c);
      gui->pset(x0 - x, y0 - y, c);
      gui->pset(x0 + x, y0 + y, c);
      gui->pset(x0 + x, y0 - y, c);
      gui->pset(x0 - y, y0 + x, c);
      gui->pset(x0 - y, y0 - x, c);
      gui->pset(x0 + y, y0 + x, c);
      gui->pset(x0 + y, y0 - x, c);

      y++;
      e += yd;
      yd += 2;
      if ( ((e << 1) + xd) > 0 )
      {
         x--;
         e += xd;
         xd += 2;
      }
   }
}

void UG_FillCircle( UG_S16 x0, UG_S16 y0, UG_S16 r, UG_COLOR c )
{
   UG_S16  x,y,xd;

   if ( x0<0 ) return;
   if ( y0<0 ) return;
   if ( r<=0 ) return;

   xd = 3 - (r << 1);
   x = 0;
   y = r;

   while ( x <= y )
   {
     if( y > 0 )
     {
        UG_DrawLine(x0 - x, y0 - y,x0 - x, y0 + y, c);
        UG_DrawLine(x0 + x, y0 - y,x0 + x, y0 + y, c);
     }
     if( x > 0 )
     {
        UG_DrawLine(x0 - y, y0 - x,x0 - y, y0 + x, c);
        UG_DrawLine(x0 + y, y0 - x,x0 + y, y0 + x, c);
     }
     if ( xd < 0 )
     {
        xd += (x << 2) + 6;
     }
     else
     {
        xd += ((x - y) << 2) + 10;
        y--;
     }
     x++;
   }
   UG_DrawCircle(x0, y0, r,c);
}

void UG_DrawArc( UG_S16 x0, UG_S16 y0, UG_S16 r, UG_U8 s, UG_COLOR c )
{
   UG_S16 x,y,xd,yd,e;

   if ( x0<0 ) return;
   if ( y0<0 ) return;
   if ( r<=0 ) return;

   xd = 1 - (r << 1);
   yd = 0;
   e = 0;
   x = r;
   y = 0;

   while ( x >= y )
   {
      // Q1
      if ( s & 0x01 ) gui->pset(x0 + x, y0 - y, c);
      if ( s & 0x02 ) gui->pset(x0 + y, y0 - x, c);

      // Q2
      if ( s & 0x04 ) gui->pset(x0 - y, y0 - x, c);
      if ( s & 0x08 ) gui->pset(x0 - x, y0 - y, c);

      // Q3
      if ( s & 0x10 ) gui->pset(x0 - x, y0 + y, c);
      if ( s & 0x20 ) gui->pset(x0 - y, y0 + x, c);

      // Q4
      if ( s & 0x40 ) gui->pset(x0 + y, y0 + x, c);
      if ( s & 0x80 ) gui->pset(x0 + x, y0 + y, c);

      y++;
      e += yd;
      yd += 2;
      if ( ((e << 1) + xd) > 0 )
      {
         x--;
         e += xd;
         xd += 2;
      }
   }
}

void UG_DrawLine( UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_COLOR c )
{
   UG_S16 n, dx, dy, sgndx, sgndy, dxabs, dyabs, x, y, drawx, drawy;

   /* Is hardware acceleration available? */
   if ( gui->driver[DRIVER_DRAW_LINE].state & DRIVER_ENABLED )
   {
      if( ((UG_RESULT(*)(UG_S16 x1, UG_S16 y1, UG_S16 x2, UG_S16 y2, UG_COLOR c))gui->driver[DRIVER_DRAW_LINE].driver)(x1,y1,x2,y2,c) == UG_RESULT_OK ) return;
   }

   dx = x2 - x1;
   dy = y2 - y1;
   dxabs = (dx>0)?dx:-dx;
   dyabs = (dy>0)?dy:-dy;
   sgndx = (dx>0)?1:-1;
   sgndy = (dy>0)?1:-1;
   x = dyabs >> 1;
   y = dxabs >> 1;
   drawx = x1;
   drawy = y1;

   gui->pset(drawx, drawy,c);

   if( dxabs >= dyabs )
   {
      for( n=0; n<dxabs; n++ )
      {
         y += dyabs;
         if( y >= dxabs )
         {
            y -= dxabs;
            drawy += sgndy;
         }
         drawx += sgndx;
         gui->pset(drawx, drawy,c);
      }
   }
   else
   {
      for( n=0; n<dyabs; n++ )
      {
         x += dxabs;
         if( x >= dyabs )
         {
            x -= dyabs;
            drawx += sgndx;
         }
         drawy += sgndy;
         gui->pset(drawx, drawy,c);
      }
   }  
}

void UG_PutString( UG_S16 x, UG_S16 y, char* str )
{
   UG_S16 xp,yp;
   UG_U8 cw;
   char chr;

   xp=x;
   yp=y;

   while ( *str != 0 )
   {
      chr = *str++;
	  if (chr < gui->font.start_char || chr > gui->font.end_char) continue;
      if ( chr == '\n' )
      {
         xp = gui->x_dim;
         continue;
      }
	  cw = gui->font.widths ? gui->font.widths[chr - gui->font.start_char] : gui->font.char_width;

      if ( xp + cw > gui->x_dim - 1 )
      {
         xp = x;
         yp += gui->font.char_height+gui->char_v_space;
      }

      UG_PutChar(chr, xp, yp, gui->fore_color, gui->back_color);

      xp += cw + gui->char_h_space;
   }
}

void UG_PutChar( char chr, UG_S16 x, UG_S16 y, UG_COLOR fc, UG_COLOR bc )
{
	_UG_PutChar(chr,x,y,fc,bc,&gui->font);
}

void UG_ConsolePutString( char* str )
{
   char chr;
   UG_U8 cw;

   while ( *str != 0 )
   {
      chr = *str;
      if ( chr == '\n' )
      {
         gui->console.x_pos = gui->x_dim;
         str++;
         continue;
      }
      
      cw = gui->font.widths ? gui->font.widths[chr - gui->font.start_char] : gui->font.char_width;
      gui->console.x_pos += cw+gui->char_h_space;

      if ( gui->console.x_pos+cw > gui->console.x_end )
      {
         gui->console.x_pos = gui->console.x_start;
         gui->console.y_pos += gui->font.char_height+gui->char_v_space;
      }
      if ( gui->console.y_pos+gui->font.char_height > gui->console.y_end )
      {
         gui->console.x_pos = gui->console.x_start;
         gui->console.y_pos = gui->console.y_start;
         UG_FillFrame(gui->console.x_start,gui->console.y_start,gui->console.x_end,gui->console.y_end,gui->console.back_color);
      }

      UG_PutChar(chr, gui->console.x_pos, gui->console.y_pos, gui->console.fore_color, gui->console.back_color);
      str++;
   }
}

void UG_ConsoleSetArea( UG_S16 xs, UG_S16 ys, UG_S16 xe, UG_S16 ye )
{
   gui->console.x_start = xs;
   gui->console.y_start = ys;
   gui->console.x_end = xe;
   gui->console.y_end = ye;
}

void UG_ConsoleSetForecolor( UG_COLOR c )
{
   gui->console.fore_color = c;
}

void UG_ConsoleSetBackcolor( UG_COLOR c )
{
   gui->console.back_color = c;
}

void UG_SetForecolor( UG_COLOR c )
{
   gui->fore_color = c;
}

void UG_SetBackcolor( UG_COLOR c )
{
   gui->back_color = c;
}

UG_S16 UG_GetXDim( void )
{
   return gui->x_dim;
}

UG_S16 UG_GetYDim( void )
{
   return gui->y_dim;
}

void UG_FontSetHSpace( UG_U16 s )
{
   gui->char_h_space = s;
}

void UG_FontSetVSpace( UG_U16 s )
{
   gui->char_v_space = s;
}

/* -------------------------------------------------------------------------------- */
/* -- INTERNAL FUNCTIONS                                                         -- */
/* -------------------------------------------------------------------------------- */
void _UG_PutChar( char chr, UG_S16 x, UG_S16 y, UG_COLOR fc, UG_COLOR bc, const UG_FONT* font)
{
   UG_U16 i,j,k,xo,yo,c,bn,actual_char_width;
   UG_U8 b,bt;
   UG_U32 index;
   UG_COLOR color;
   void(*push_pixel)(UG_COLOR);

   bt = (UG_U8)chr;

   switch ( bt )
   {
      case 0xF6: bt = 0x94; break; // 
      case 0xD6: bt = 0x99; break; // 
      case 0xFC: bt = 0x81; break; // 
      case 0xDC: bt = 0x9A; break; // 
      case 0xE4: bt = 0x84; break; // 
      case 0xC4: bt = 0x8E; break; // 
      case 0xB5: bt = 0xE6; break; // 
      case 0xB0: bt = 0xF8; break; // 
   }

   if (bt < font->start_char || bt > font->end_char) return;
   
   yo = y;
   bn = font->char_width;
   if ( !bn ) return;
   bn >>= 3;
   if ( font->char_width % 8 ) bn++;
   actual_char_width = (font->widths ? font->widths[bt - font->start_char] : font->char_width);

   /* Is hardware acceleration available? */
   if ( gui->driver[DRIVER_FILL_AREA].state & DRIVER_ENABLED )
   {
	   //(void(*)(UG_COLOR))
      push_pixel = ((void*(*)(UG_S16, UG_S16, UG_S16, UG_S16))gui->driver[DRIVER_FILL_AREA].driver)(x,y,x+actual_char_width-1,y+font->char_height-1);
	   
      if (font->font_type == FONT_TYPE_1BPP)
	  {
	      index = (bt - font->start_char)* font->char_height * bn;
		  for( j=0;j<font->char_height;j++ )
		  {
			 c=actual_char_width;
			 for( i=0;i<bn;i++ )
			 {
				b = font->p[index++];
				for( k=0;(k<8) && c;k++ )
				{
				   if( b & 0x01 )
				   {
					  push_pixel(fc);
				   }
				   else
				   {
					  push_pixel(bc);
				   }
				   b >>= 1;
				   c--;
				}
			 }
	 	 }
	  }
	  else if (font->font_type == FONT_TYPE_8BPP)
	  {
		   index = (bt - font->start_char)* font->char_height * font->char_width;
		   for( j=0;j<font->char_height;j++ )
		   {
			  for( i=0;i<actual_char_width;i++ )
			  {
				 b = font->p[index++];
				 color = (((fc & 0xFF) * b + (bc & 0xFF) * (256 - b)) >> 8) & 0xFF |//Blue component
				         (((fc & 0xFF00) * b + (bc & 0xFF00) * (256 - b)) >> 8)  & 0xFF00|//Green component
				         (((fc & 0xFF0000) * b + (bc & 0xFF0000) * (256 - b)) >> 8) & 0xFF0000; //Red component
				 push_pixel(color);
			  }
			  index += font->char_width - actual_char_width;
		  }
	  }
   }
   else
   {
	   /*Not accelerated output*/
	   if (font->font_type == FONT_TYPE_1BPP)
	   {
         index = (bt - font->start_char)* font->char_height * bn;
         for( j=0;j<font->char_height;j++ )
         {
           xo = x;
           c=actual_char_width;
           for( i=0;i<bn;i++ )
           {
             b = font->p[index++];
             for( k=0;(k<8) && c;k++ )
             {
               if( b & 0x01 )
               {
                  gui->pset(xo,yo,fc);
               }
               else
               {
                  gui->pset(xo,yo,bc);
               }
               b >>= 1;
               xo++;
               c--;
             }
           }
           yo++;
         }
      }
      else if (font->font_type == FONT_TYPE_8BPP)
      {
         index = (bt - font->start_char)* font->char_height * font->char_width;
         for( j=0;j<font->char_height;j++ )
         {
            xo = x;
            for( i=0;i<actual_char_width;i++ )
            {
               b = font->p[index++];
               color = (((fc & 0xFF) * b + (bc & 0xFF) * (256 - b)) >> 8) & 0xFF |//Blue component
                       (((fc & 0xFF00) * b + (bc & 0xFF00) * (256 - b)) >> 8)  & 0xFF00|//Green component
                       (((fc & 0xFF0000) * b + (bc & 0xFF0000) * (256 - b)) >> 8) & 0xFF0000; //Red component
               gui->pset(xo,yo,color);
               xo++;
            }
            index += font->char_width - actual_char_width;
            yo++;
         }
      }
   }
}

void _UG_PutText(UG_TEXT* txt)
{
   UG_U16 sl,rc,wl;
   UG_S16 xp,yp;
   UG_S16 xs=txt->a.xs;
   UG_S16 ys=txt->a.ys;
   UG_S16 xe=txt->a.xe;
   UG_S16 ye=txt->a.ye;
   UG_U8  align=txt->align;
   UG_S16 char_width=txt->font->char_width;
   UG_S16 char_height=txt->font->char_height;
   UG_S16 char_h_space=txt->h_space;
   UG_S16 char_v_space=txt->v_space;

   char chr;

   char* str = txt->str;
   char* c = str;

   if ( txt->font->p == NULL ) return;
   if ( str == NULL ) return;
   if ( (ye - ys) < txt->font->char_height ) return;

   rc=1;
   c=str;
   while ( *c != 0 )
   {
      if ( *c == '\n' ) rc++;
      c++;
   }

   yp = 0;
   if ( align & (ALIGN_V_CENTER | ALIGN_V_BOTTOM) )
   {
      yp = ye - ys + 1;
      yp -= char_height*rc;
      yp -= char_v_space*(rc-1);
      if ( yp < 0 ) return;
   }
   if ( align & ALIGN_V_CENTER ) yp >>= 1;
   yp += ys;

   while( 1 )
   {
      sl=0;
      c=str;
      wl = 0;
      while( (*c != 0) && (*c != '\n') )
      {
         if (*c < txt->font->start_char || *c > txt->font->end_char) {c++; continue;}
         sl++;
         wl += (txt->font->widths ? txt->font->widths[*c - txt->font->start_char] : char_width) + char_h_space;
         c++;
      }
      wl -= char_h_space;

      xp = xe - xs + 1;
      xp -= wl;
      if ( xp < 0 ) return;

      if ( align & ALIGN_H_LEFT ) xp = 0;
      else if ( align & ALIGN_H_CENTER ) xp >>= 1;
      xp += xs;

      while( (*str != '\n') )
      {
         chr = *str++;
         if ( chr == 0 ) return;
         _UG_PutChar(chr,xp,yp,txt->fc,txt->bc,txt->font);
         xp += (txt->font->widths ? txt->font->widths[chr - txt->font->start_char] : char_width) + char_h_space;
      }
      str++;
      yp += char_height + char_v_space;
   }
}
