/***********************************************************************
 Sample Code Disclaimer

 Copyright  2001 Palm, Inc. or its subsidiaries.  All
 rights reserved.

 You may incorporate this sample code (the "Code") into your applications
 for Palm OS(R) platform products and may use the Code to develop
 such applications without restriction.  The Code is provided to you on
 an "AS IS" basis and the responsibility for its operation is 100% yours.
 PALM, INC. AND ITS SUBSIDIARIES (COLLECTIVELY, "PALM") DISCLAIM
 ALL WARRANTIES, TERMS AND CONDITIONS WITH RESPECT TO THE CODE, EXPRESS,
 IMPLIED, STATUTORY OR OTHERWISE, INCLUDING WARRANTIES, TERMS OR
 CONDITIONS OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 NONINFRINGEMENT AND SATISFACTORY QUALITY.  You are not permitted to
 redistribute the Code on a stand-alone basis and you may only
 redistribute the Code in object code form as incorporated into your
 applications.  TO THE FULL EXTENT ALLOWED BY LAW, PALM ALSO EXCLUDES ANY
 LIABILITY, WHETHER BASED IN CONTRACT OR TORT (INCLUDING NEGLIGENCE), FOR
 INCIDENTAL, CONSEQUENTIAL, INDIRECT, SPECIAL OR PUNITIVE DAMAGES OF ANY
 KIND, OR FOR LOSS OF REVENUE OR PROFITS, LOSS OF BUSINESS, LOSS OF
 INFORMATION OR DATA, OR OTHER FINANCIAL LOSS ARISING OUT OF OR IN
 CONNECTION WITH THE USE OR PERFORMANCE OF THE CODE.  The Code is subject
 to Restricted Rights for U.S. government users and export regulations.
 
 SAMPLE NAME:		HostFS

 FILE:				HostFSDispatch.c

 DATE:				6/25/2001

 DESCRIPTION:		Source Code

 COMPILER:			Metrowerks CodeWarrior

 *****************************************************************************
 
 Description: Sample filesystem library dispatch table implementation.

 *****************************************************************************/


// If building from Metrowerks then build this as a standalone library
#ifdef __PALMOS_TRAPS__
  #ifdef EMULATION_LEVEL
    #undef EMULATION_LEVEL
  #endif
  #define EMULATION_LEVEL EMULATION_NONE
#endif

// Define __PALMOS_TRAPS__ to 0.  For some reason, this library is built as a PalmOS
// Code resource (which sets __PALMOS_TRAPS__ to 1 internally which messes things up
// since we need to get to the address of the routine names here (not use traps).
#undef __PALMOS_TRAPS__
#define __PALMOS_TRAPS__ 0

// Define this so that we can get the addresses of the Serial Library
// routines. Other modules access the routines through traps.
#define	USE_TRAPS 	0


// Include Palm headers
#include <PalmTypes.h>
#include <LibTraps.h>
#include <SystemMgr.h>

// Our library public definitions
#include "VFSMgr.h"
#include "FSLib.h"


/********************************************************************
 * Private routines:
 ********************************************************************/

#define PrvFSInstall		__Startup__

Err	PrvFSInstall(UInt16 refNum, SysLibTblEntryPtr entryP);

Err PrvShouldWeInstall(void);

static void *PrvDispatchTable();


/************************************************************
 *
 *  FUNCTION:     __Startup__  (PrvFSInstall)
 *
 *  DESCRIPTION:	Entry point for FSLib Library installation resource. This
 *		is a 'libr' resource in the "FSLib Library" resource database.
 *		This resource contains the INet Library API entry points.
 *
 *		To install the library, the system calls SysLibLoad(). SysLibLoad()
 *		will find the library database and call SysLibInstall() on
 *		the 'libr' resource. SysLibInstall() will
 *		jump to this resource to have it install it's dispatch table
 *		into the library entry.
 *
 *  PARAMETERS:
 *		refNum - refNum of library
 *		entryP - the Library's entry pointer
 *
 *  RETURNS:        0 if no error
 *
 *  CALLED BY:    SysLibInstall(), SysLibRemove()
 *
 *************************************************************/
Err	PrvFSInstall(UInt16 /* fsLibRefNum */, SysLibTblEntryPtr entryP)
{
	// Install pointer to our dispatch table
	entryP->dispatchTblP = (void **)PrvDispatchTable();
	
	return 0;
}


/************************************************************
 *
 *  FUNCTION: PrvDispatchTable
 *
 *  DESCRIPTION: Dispatch Table for FS Library.
 *		This table gets installed into the dispatchTblP
 *		field of the library entry in the library table. It gives
 *		the 32-bit offset of every routine relative to the start of
 *		the dispatch table.
 *
 *  PARAMETERS:	None
 *
 *	CALLED BY:
 *		PrvFSInstall
 *
 *  RETURNS: Nothing
 *
 *************************************************************/
#define	kNumDispatchEntries	32		// UPDATE THIS WHEN CALLS ARE ADDED TO @TABLE
#define	kOffset						((kNumDispatchEntries + 1) * 2)

#if defined(__MC68K__)
static asm void *  PrvDispatchTable()
{
	LEA		@Table, A0								// table ptr
	RTS												// return;

@Table:
	DC.W		@Name
	DC.W		(kOffset)							// Open
	DC.W		(kOffset+(1*4))						// Close
	DC.W		(kOffset+(2*4))						// Sleep
	DC.W		(kOffset+(3*4))						// Wake
	
	DC.W		(kOffset+(4*4))						// LibAPIVersion
	DC.W		(kOffset+(5*4))						// CustomControl
	DC.W		(kOffset+(6*4))						// FilesystemType
	
	DC.W		(kOffset+(7*4))						// FileCreate
	DC.W		(kOffset+(8*4))						// FileOpen
	DC.W		(kOffset+(9*4))						// FileClose
	DC.W		(kOffset+(10*4))					// FileRead
	DC.W		(kOffset+(11*4))					// FileWrite
	DC.W		(kOffset+(12*4))					// FileDelete
	DC.W		(kOffset+(13*4))					// FileRename
	DC.W		(kOffset+(14*4))					// FileSeek
	DC.W		(kOffset+(15*4))					// FileEOF
	DC.W		(kOffset+(16*4))					// FileTell
	DC.W		(kOffset+(17*4))					// FileResize
	DC.W		(kOffset+(18*4))					// FileAttributesGet
	DC.W		(kOffset+(19*4))					// FileAttributesSet
	DC.W		(kOffset+(20*4))					// FileDateGet
	DC.W		(kOffset+(21*4))					// FileDateSet
	DC.W		(kOffset+(22*4))					// FileSize
	
	DC.W		(kOffset+(23*4))					// DirCreate
	DC.W		(kOffset+(24*4))					// DirEntryEnumerate
	
	DC.W		(kOffset+(25*4))					// VolumeFormat
	DC.W		(kOffset+(26*4))					// VolumeMount
	DC.W		(kOffset+(27*4))					// VolumeUnmount
	DC.W		(kOffset+(28*4))					// VolumeInfo
	DC.W		(kOffset+(29*4))					// VolumeLabelGet
	DC.W		(kOffset+(30*4))					// VolumeLabelSet
	DC.W		(kOffset+(31*4))					// VolumeSize
	

@GotoLibOpen:
	JMP 	FSLibOpen
@GotoLibClose:
	JMP 	FSLibClose
@GotoLibSleep:
	JMP 	FSLibSleep
@GotoLibWake:
	JMP 	FSLibWake
	
@GotoLibAPIVersion:
	JMP 	FSLibAPIVersion
@GotoCustomControl:
	JMP 	FSCustomControl
@GotoFilesystemType:
	JMP 	FSFilesystemType
	
@GotoFileCreate:
	JMP 	FSFileCreate
@GotoFileOpen:
	JMP 	FSFileOpen
@GotoFileClose:
	JMP 	FSFileClose
@GotoFileReadLow:
	JMP 	FSFileRead
@GotoFileWrite:
	JMP 	FSFileWrite
@GotoFileDelete:
	JMP 	FSFileDelete
@GotoFileRename:
	JMP 	FSFileRename
@GotoFileSeek:
	JMP 	FSFileSeek
@GotoFileEOF:
	JMP 	FSFileEOF
@GotoFileTell:
	JMP 	FSFileTell
@GotoFileSetSize:
	JMP 	FSFileResize
@GotoFileGetAttributes:
	JMP 	FSFileGetAttributes
@GotoFileSetAttributes:
	JMP 	FSFileSetAttributes
@GotoFileGetDates:
	JMP 	FSFileGetDate
@GotoFileSetDates:
	JMP 	FSFileSetDate
@GotoFileGetSize:
	JMP 	FSFileSize
	
@GotoDirCreate:
	JMP 	FSDirCreate
@GotoDirEntryEnumerate:
	JMP 	FSDirEntryEnumerate
	
@GotoVolumeFormat:
	JMP 	FSVolumeFormat
@GotoVolumeMount:
	JMP 	FSVolumeMount
@GotoVolumeUnmount:
	JMP 	FSVolumeUnmount
@GotoVolumeInfo:
	JMP 	FSVolumeInfo
@GotoVolumeGetLabel:
	JMP 	FSVolumeGetLabel
@GotoVolumeSetLabel:
	JMP 	FSVolumeSetLabel
@GotoVolumeSize:
	JMP 	FSVolumeSize
@Name:
	DC.B	"HostFS Library"
}
#else
#error "Processor type not defined"
#endif

